(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else {
		var a = factory();
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(self, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@applitools/dom-capture/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@applitools/dom-capture/index.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const makeGetScript = __webpack_require__(/*! ./src/getScript */ "./node_modules/@applitools/dom-capture/src/getScript.js");
const getCaptureDom = makeGetScript('captureDom');
const getCaptureDomPoll = makeGetScript('captureDomAndPoll');
const getPollResult = makeGetScript('pollResult');
const getCaptureDomForIE = makeGetScript('captureDomForIE');
const getCaptureDomPollForIE = makeGetScript('captureDomAndPollForIE');
const getPollResultForIE = makeGetScript('pollResultForIE');

module.exports = {
  getCaptureDom,
  getCaptureDomPoll,
  getPollResult,
  getCaptureDomForIE,
  getCaptureDomPollForIE,
  getPollResultForIE,
};


/***/ }),

/***/ "./node_modules/@applitools/dom-capture/src/getScript.js":
/*!***************************************************************!*\
  !*** ./node_modules/@applitools/dom-capture/src/getScript.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
var __dirname = "node_modules/@applitools/dom-capture/src";

const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js");
const {promisify: p} = __webpack_require__(/*! util */ "./node_modules/util/util.js");
const {cacheFunctionAsync} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js");

const makeGetScript = filename =>
  cacheFunctionAsync(async function() {
    return await p(fs.readFile)(__dirname + `/../dist/${filename}.js`, 'utf-8');
  });

module.exports = makeGetScript;


/***/ }),

/***/ "./node_modules/@applitools/dom-snapshot/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@applitools/dom-snapshot/index.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const makeGetScript = __webpack_require__(/*! ./src/getScript */ "./node_modules/@applitools/dom-snapshot/src/getScript.js");
const getProcessPage = makeGetScript('processPage');
const getProcessPagePoll = makeGetScript('processPagePoll');
const getProcessPageAndSerialize = makeGetScript('processPageAndSerialize');
const getProcessPageAndSerializePoll = makeGetScript('processPageAndSerializePoll');
const getPollResult = makeGetScript('pollResult');
const getProcessPageForIE = makeGetScript('processPageForIE');
const getProcessPagePollForIE = makeGetScript('processPagePollForIE');
const getProcessPageAndSerializeForIE = makeGetScript('processPageAndSerializeForIE');
const getProcessPageAndSerializePollForIE = makeGetScript('processPageAndSerializePollForIE');
const getPollResultForIE = makeGetScript('pollResultForIE');

module.exports = {
  getProcessPage,
  getProcessPagePoll,
  getPollResult,

  // IE scripts:
  getProcessPageForIE,
  getProcessPagePollForIE,
  getPollResultForIE,

  // deprecated:
  getProcessPageAndSerialize,
  getProcessPageAndSerializePoll,
  getProcessPageAndSerializeForIE,
  getProcessPageAndSerializePollForIE,
};


/***/ }),

/***/ "./node_modules/@applitools/dom-snapshot/src/getScript.js":
/*!****************************************************************!*\
  !*** ./node_modules/@applitools/dom-snapshot/src/getScript.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
var __dirname = "node_modules/@applitools/dom-snapshot/src";

const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js");
const {promisify: p} = __webpack_require__(/*! util */ "./node_modules/util/util.js");
const {cacheFunctionAsync} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js");

const makeGetScript = filename =>
  cacheFunctionAsync(async function() {
    return await p(fs.readFile)(__dirname + `/../dist/${filename}.js`, 'utf-8');
  });

module.exports = makeGetScript;


/***/ }),

/***/ "./node_modules/@applitools/driver/dist/context.js":
/*!*********************************************************!*\
  !*** ./node_modules/@applitools/driver/dist/context.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Context = void 0;
const utils = __importStar(__webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js"));
const element_1 = __webpack_require__(/*! ./element */ "./node_modules/@applitools/driver/dist/element.js");
const snippets = __webpack_require__(/*! @applitools/snippets */ "./node_modules/@applitools/snippets/dist/index.js");
class Context {
    constructor(options) {
        var _a, _b, _c;
        this._state = {};
        if (options.context instanceof Context)
            return options.context;
        this._spec = options.spec;
        if (options.logger)
            this._logger = options.logger;
        if (options.context) {
            if ((_c = (_b = (_a = this._spec).isContext) === null || _b === void 0 ? void 0 : _b.call(_a, options.context)) !== null && _c !== void 0 ? _c : this._spec.isDriver(options.context)) {
                this._target = options.context;
            }
            else {
                throw new TypeError('Context constructor called with argument of unknown type of context!');
            }
        }
        if (this.isReference(options.reference)) {
            if (options.reference instanceof Context)
                return options.reference;
            if (!options.parent) {
                throw new TypeError('Cannot construct child context without reference to the parent');
            }
            this._reference = options.reference;
            this._parent = options.parent;
            this._scrollingElement = options.scrollingElement;
            this._driver = options.driver || this._parent.driver;
        }
        else if (!options.reference) {
            this._element = null;
            this._parent = null;
            this._scrollingElement = options.scrollingElement;
            this._driver = options.driver;
        }
        else {
            throw new TypeError('Context constructor called with argument of unknown type!');
        }
    }
    get target() {
        return this._target;
    }
    get driver() {
        return this._driver;
    }
    get parent() {
        var _a;
        return (_a = this._parent) !== null && _a !== void 0 ? _a : null;
    }
    get main() {
        var _a, _b;
        return (_b = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.main) !== null && _b !== void 0 ? _b : this;
    }
    get path() {
        var _a, _b;
        return [...((_b = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.path) !== null && _b !== void 0 ? _b : []), this];
    }
    get isMain() {
        return this.main === this;
    }
    get isCurrent() {
        return this.driver.currentContext === this;
    }
    get isInitialized() {
        return Boolean(this._element) || this.isMain;
    }
    get isRef() {
        return !this._target;
    }
    isReference(reference) {
        return (reference instanceof Context ||
            utils.types.isInteger(reference) ||
            utils.types.isString(reference) ||
            reference instanceof element_1.Element ||
            this._spec.isElement(reference) ||
            this._spec.isSelector(reference));
    }
    async init() {
        if (this.isInitialized)
            return this;
        if (!this._reference)
            throw new TypeError('Cannot initialize context without a reference to the context element');
        await this.parent.focus();
        this._logger.log('Context initialization');
        if (utils.types.isInteger(this._reference)) {
            this._logger.log('Getting context element using index:', this._reference);
            const elements = await this.parent.elements('frame, iframe');
            if (this._reference > elements.length) {
                throw new TypeError(`Context element with index ${this._reference} is not found`);
            }
            this._element = elements[this._reference];
        }
        else if (utils.types.isString(this._reference) || this._spec.isSelector(this._reference)) {
            if (utils.types.isString(this._reference)) {
                this._logger.log('Getting context element by name or id', this._reference);
                this._element = await this.parent
                    .element(`iframe[name="${this._reference}"], iframe#${this._reference}`)
                    .catch(() => null);
            }
            if (!this._element && this._spec.isSelector(this._reference)) {
                this._logger.log('Getting context element by selector', this._reference);
                this._element = await this.parent.element(this._reference);
            }
            if (!this._element) {
                throw new TypeError(`Context element with name, id, or selector ${JSON.stringify(this._reference)}' is not found`);
            }
        }
        else if (this._spec.isElement(this._reference) || this._reference instanceof element_1.Element) {
            this._logger.log('Initialize context from reference element', this._reference);
            this._element = new element_1.Element({
                spec: this._spec,
                context: this.parent,
                element: this._reference,
                logger: this._logger,
            });
        }
        else {
            throw new TypeError('Reference type does not supported');
        }
        this._reference = null;
        return this;
    }
    async focus() {
        if (this.isCurrent) {
            return this;
        }
        else if (this.isMain) {
            await this.driver.switchToMainContext();
            return this;
        }
        if (this.isRef) {
            await this.init();
        }
        if (!this.parent.isCurrent) {
            await this.driver.switchTo(this);
            return this;
        }
        await this.parent.preserveInnerOffset();
        if (this.parent.isMain)
            await this.parent.preserveContextRegions();
        await this.preserveContextRegions();
        this._target = await this._spec.childContext(this.parent.target, this._element.target);
        this.driver.updateCurrentContext(this);
        return this;
    }
    async equals(context) {
        if (context === this || (this.isMain && context === null))
            return true;
        if (!this._element)
            return false;
        return this._element.equals(context instanceof Context ? await context.getContextElement() : context);
    }
    async context(reference) {
        if (reference instanceof Context) {
            if (reference.parent !== this) {
                throw Error('Cannot attach a child context because it has a different parent');
            }
            return reference;
        }
        else if (this.isReference(reference)) {
            return new Context({ spec: this._spec, parent: this, driver: this.driver, reference, logger: this._logger });
        }
        else if (utils.types.has(reference, 'reference')) {
            const parent = reference.parent ? await this.context(reference.parent) : this;
            return new Context({
                spec: this._spec,
                parent,
                driver: this.driver,
                reference: reference.reference,
                scrollingElement: reference === null || reference === void 0 ? void 0 : reference.scrollingElement,
                logger: this._logger,
            });
        }
    }
    async element(selectorOrElement) {
        if (this._spec.isSelector(selectorOrElement)) {
            if (this.isRef) {
                return new element_1.Element({ spec: this._spec, context: this, selector: selectorOrElement, logger: this._logger });
            }
            await this.focus();
            const element = await this._spec.findElement(this.target, selectorOrElement);
            return element
                ? new element_1.Element({ spec: this._spec, context: this, element, selector: selectorOrElement, logger: this._logger })
                : null;
        }
        else if (this._spec.isElement(selectorOrElement)) {
            return new element_1.Element({ spec: this._spec, context: this, element: selectorOrElement, logger: this._logger });
        }
        else {
            throw new TypeError('Cannot find element using argument of unknown type!');
        }
    }
    async elements(selectorOrElement) {
        if (this._spec.isSelector(selectorOrElement)) {
            if (this.isRef) {
                return [new element_1.Element({ spec: this._spec, context: this, selector: selectorOrElement, logger: this._logger })];
            }
            await this.focus();
            const elements = await this._spec.findElements(this.target, selectorOrElement);
            return elements.map((element, index) => {
                return new element_1.Element({
                    spec: this._spec,
                    context: this,
                    element,
                    selector: selectorOrElement,
                    index,
                    logger: this._logger,
                });
            });
        }
        else if (this._spec.isElement(selectorOrElement)) {
            return [new element_1.Element({ spec: this._spec, context: this, element: selectorOrElement, logger: this._logger })];
        }
        else {
            throw new TypeError('Cannot find elements using argument of unknown type!');
        }
    }
    async execute(script, arg) {
        await this.focus();
        try {
            return await this._spec.executeScript(this.target, script, serialize.call(this, arg));
        }
        catch (err) {
            this._logger.warn('Error during script execution with argument', arg);
            this._logger.error(err);
            throw err;
        }
        function serialize(value) {
            var _a, _b;
            if (this._spec.isElement(value) || value instanceof element_1.Element) {
                return value instanceof element_1.Element ? value.toJSON() : value;
            }
            else if (utils.types.isArray(value)) {
                return value.map(value => serialize.call(this, value));
            }
            else if (utils.types.isObject(value)) {
                return Object.entries((_b = (_a = value.toJSON) === null || _a === void 0 ? void 0 : _a.call(value)) !== null && _b !== void 0 ? _b : value).reduce((serialized, [key, value]) => {
                    return Object.assign(serialized, { [key]: serialize.call(this, value) });
                }, {});
            }
            else {
                return value;
            }
        }
    }
    async getContextElement() {
        if (this.isMain)
            return null;
        await this.init();
        return this._element;
    }
    async getScrollingElement() {
        if (!(this._scrollingElement instanceof element_1.Element)) {
            await this.focus();
            if (this._scrollingElement) {
                this._scrollingElement = await this.element(this._scrollingElement);
            }
            else {
                this._scrollingElement = await this.element(this.driver.isWeb ? { type: 'css', selector: 'html' } : { type: 'xpath', selector: '//*[@scrollable="true"]' });
            }
        }
        return this._scrollingElement;
    }
    async setScrollingElement(scrollingElement) {
        if (scrollingElement === undefined)
            return;
        else if (scrollingElement === null)
            this._scrollingElement = null;
        else {
            this._scrollingElement =
                scrollingElement instanceof element_1.Element ? scrollingElement : await this.element(scrollingElement);
        }
    }
    async blurElement(element) {
        try {
            return await this.execute(snippets.blurElement, [element]);
        }
        catch (err) {
            this._logger.warn('Cannot blur element', element);
            this._logger.error(err);
            return null;
        }
    }
    async focusElement(element) {
        try {
            return await this.execute(snippets.focusElement, [element]);
        }
        catch (err) {
            this._logger.warn('Cannot focus element', element);
            this._logger.error(err);
            return null;
        }
    }
    async getRegion() {
        var _a;
        if (this.isMain && this.isCurrent) {
            const viewportRegion = utils.geometry.region({ x: 0, y: 0 }, await this.driver.getViewportSize());
            this._state.region = this._scrollingElement
                ? utils.geometry.region({ x: 0, y: 0 }, utils.geometry.intersect(viewportRegion, await this._scrollingElement.getRegion()))
                : viewportRegion;
        }
        else if ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isCurrent) {
            await this.init();
            this._state.region = await this._element.getRegion();
        }
        return this._state.region;
    }
    async getClientRegion() {
        var _a;
        if (this.isMain && this.isCurrent) {
            const viewportRegion = utils.geometry.region({ x: 0, y: 0 }, await this.driver.getViewportSize());
            this._state.clientRegion = this._scrollingElement
                ? utils.geometry.region({ x: 0, y: 0 }, utils.geometry.intersect(viewportRegion, await this._scrollingElement.getClientRegion()))
                : viewportRegion;
        }
        else if ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.isCurrent) {
            await this.init();
            this._state.clientRegion = await this._element.getClientRegion();
        }
        return this._state.clientRegion;
    }
    async getScrollingRegion() {
        if (this.isCurrent) {
            const scrollingElement = await this.getScrollingElement();
            this._state.scrollingRegion = await scrollingElement.getClientRegion();
        }
        return this._state.scrollingRegion;
    }
    async getContentSize() {
        return this.execute(snippets.getDocumentSize);
    }
    async getInnerOffset() {
        if (this.isCurrent) {
            const scrollingElement = await this.getScrollingElement();
            this._state.innerOffset = scrollingElement ? await scrollingElement.getInnerOffset() : { x: 0, y: 0 };
        }
        return this._state.innerOffset;
    }
    async getLocationInMainContext() {
        return this.path.reduce((location, context) => {
            return location.then(async (location) => {
                return utils.geometry.offset(location, utils.geometry.location(await context.getClientRegion()));
            });
        }, Promise.resolve({ x: 0, y: 0 }));
    }
    async getLocationInViewport() {
        var _a, _b;
        let location = utils.geometry.offsetNegative({ x: 0, y: 0 }, await this.getInnerOffset());
        if (this.isMain)
            return location;
        let currentContext = this;
        while (currentContext) {
            const contextLocation = utils.geometry.location(await currentContext.getClientRegion());
            const parentContextInnerOffset = (_b = (await ((_a = currentContext.parent) === null || _a === void 0 ? void 0 : _a.getInnerOffset()))) !== null && _b !== void 0 ? _b : { x: 0, y: 0 };
            location = utils.geometry.offsetNegative(utils.geometry.offset(location, contextLocation), parentContextInnerOffset);
            currentContext = currentContext.parent;
        }
        return location;
    }
    async getRegionInViewport(region) {
        var _a, _b;
        let currentContext = this;
        if (region)
            region = utils.geometry.offsetNegative(region, await currentContext.getInnerOffset());
        else
            region = { x: 0, y: 0, width: Infinity, height: Infinity };
        while (currentContext) {
            const contextRegion = await currentContext.getClientRegion();
            // const contextScrollingRegion = await currentContext.getScrollingRegion()
            const parentContextInnerOffset = (_b = (await ((_a = currentContext.parent) === null || _a === void 0 ? void 0 : _a.getInnerOffset()))) !== null && _b !== void 0 ? _b : { x: 0, y: 0 };
            region = utils.geometry.intersect(contextRegion, utils.geometry.offset(region, contextRegion));
            // region = utils.geometry.intersect(contextScrollingRegion, region)
            region = utils.geometry.offsetNegative(region, parentContextInnerOffset);
            currentContext = currentContext.parent;
        }
        return region;
    }
    async preserveInnerOffset() {
        this._state.innerOffset = await this.getInnerOffset();
    }
    async preserveContextRegions() {
        this._state.region = await this.getRegion();
        this._state.clientRegion = await this.getClientRegion();
    }
    async preserveScrollingRegion() {
        this._state.scrollingRegion = await this.getScrollingRegion();
    }
}
exports.Context = Context;


/***/ }),

/***/ "./node_modules/@applitools/driver/dist/driver.js":
/*!********************************************************!*\
  !*** ./node_modules/@applitools/driver/dist/driver.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Driver = void 0;
const utils = __importStar(__webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js"));
const context_1 = __webpack_require__(/*! ./context */ "./node_modules/@applitools/driver/dist/context.js");
const user_agent_1 = __webpack_require__(/*! ./user-agent */ "./node_modules/@applitools/driver/dist/user-agent.js");
const snippets = __webpack_require__(/*! @applitools/snippets */ "./node_modules/@applitools/snippets/dist/index.js");
// eslint-disable-next-line
class Driver {
    constructor(options) {
        var _a, _b, _c, _d, _e, _f;
        if (options.driver instanceof Driver)
            return options.driver;
        this._spec = options.spec;
        if (options.logger)
            this._logger = options.logger;
        if (this._spec.isDriver(options.driver)) {
            this._target = (_c = (_b = (_a = this._spec).transformDriver) === null || _b === void 0 ? void 0 : _b.call(_a, options.driver)) !== null && _c !== void 0 ? _c : options.driver;
        }
        else {
            throw new TypeError('Driver constructor called with argument of unknown type!');
        }
        this._mainContext = new context_1.Context({
            spec: this._spec,
            context: (_f = (_e = (_d = this._spec).extractContext) === null || _e === void 0 ? void 0 : _e.call(_d, this._target)) !== null && _f !== void 0 ? _f : this._target,
            driver: this,
            logger: this._logger,
        });
        this._currentContext = this._mainContext;
    }
    get target() {
        return this._target;
    }
    get currentContext() {
        return this._currentContext;
    }
    get mainContext() {
        return this._mainContext;
    }
    get deviceName() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.deviceName;
    }
    get platformName() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.platformName;
    }
    get platformVersion() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.platformVersion;
    }
    get browserName() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.browserName;
    }
    get browserVersion() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.browserVersion;
    }
    get userAgent() {
        var _a;
        return (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.userAgent;
    }
    get pixelRatio() {
        var _a;
        return (_a = this._driverInfo.pixelRatio) !== null && _a !== void 0 ? _a : 1;
    }
    get isNative() {
        var _a, _b;
        return (_b = (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.isNative) !== null && _b !== void 0 ? _b : false;
    }
    get isWeb() {
        return !this.isNative;
    }
    get isMobile() {
        var _a, _b;
        return (_b = (_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.isMobile) !== null && _b !== void 0 ? _b : false;
    }
    get isIOS() {
        return this.platformName === 'iOS';
    }
    get isAndroid() {
        return this.platformName === 'Android';
    }
    get isIE() {
        return /(internet explorer|ie)/i.test(this.browserName);
    }
    get isEdgeLegacy() {
        return /edge/i.test(this.browserName) && Number(this.browserVersion) <= 44;
    }
    updateCurrentContext(context) {
        this._currentContext = context;
    }
    async init() {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        this._driverInfo = await ((_b = (_a = this._spec).getDriverInfo) === null || _b === void 0 ? void 0 : _b.call(_a, this.target));
        if (this.isWeb) {
            const userAgent = (_d = (_c = this._driverInfo) === null || _c === void 0 ? void 0 : _c.userAgent) !== null && _d !== void 0 ? _d : (await this.execute(snippets.getUserAgent));
            const pixelRatio = (_f = (_e = this._driverInfo) === null || _e === void 0 ? void 0 : _e.pixelRatio) !== null && _f !== void 0 ? _f : (await this.execute(snippets.getPixelRatio));
            const userAgentInfo = userAgent ? user_agent_1.parseUserAgent(userAgent) : {};
            this._driverInfo = Object.assign(Object.assign({}, this._driverInfo), { isMobile: (_h = (_g = this._driverInfo) === null || _g === void 0 ? void 0 : _g.isMobile) !== null && _h !== void 0 ? _h : ['iOS', 'Android'].includes(userAgentInfo.platformName), platformName: (_j = userAgentInfo.platformName) !== null && _j !== void 0 ? _j : (_k = this._driverInfo) === null || _k === void 0 ? void 0 : _k.platformName, platformVersion: (_l = userAgentInfo.platformVersion) !== null && _l !== void 0 ? _l : (_m = this._driverInfo) === null || _m === void 0 ? void 0 : _m.platformVersion, browserName: (_o = userAgentInfo.browserName) !== null && _o !== void 0 ? _o : (_p = this._driverInfo) === null || _p === void 0 ? void 0 : _p.browserName, browserVersion: (_q = userAgentInfo.browserVersion) !== null && _q !== void 0 ? _q : (_r = this._driverInfo) === null || _r === void 0 ? void 0 : _r.browserVersion, userAgent,
                pixelRatio });
        }
        this._logger.log('Driver initialized', this._driverInfo);
        return this;
    }
    async refreshContexts() {
        if (this.isNative)
            return this.currentContext;
        const spec = this._spec;
        let currentContext = this.currentContext.target;
        let contextInfo = await getContextInfo(currentContext);
        const path = [];
        if (spec.parentContext) {
            while (!contextInfo.isRoot) {
                currentContext = await spec.parentContext(currentContext);
                const contextReference = await findContextReference(currentContext, contextInfo);
                if (!contextReference)
                    throw new Error('Unable to find out the chain of frames');
                path.unshift(contextReference);
                contextInfo = await getContextInfo(currentContext);
            }
        }
        else {
            currentContext = await spec.mainContext(currentContext);
            path.push(...(await findContextPath(currentContext, contextInfo)));
        }
        this._currentContext = this._mainContext;
        return this.switchToChildContext(...path);
        async function getContextInfo(context) {
            const [documentElement, selector, isRoot, isCORS] = await spec.executeScript(context, snippets.getContextInfo);
            return { documentElement, selector, isRoot, isCORS };
        }
        async function getChildContextsInfo(context) {
            const framesInfo = await spec.executeScript(context, snippets.getChildFramesInfo);
            return framesInfo.map(([contextElement, isCORS]) => ({ contextElement, isCORS }));
        }
        async function isEqualElements(context, element1, element2) {
            return spec.executeScript(context, snippets.isEqualElements, [element1, element2]).catch(() => false);
        }
        async function findContextReference(context, contextInfo) {
            if (contextInfo.selector) {
                const contextElement = await spec.findElement(context, { type: 'xpath', selector: contextInfo.selector });
                if (contextElement)
                    return contextElement;
            }
            for (const childContextInfo of await getChildContextsInfo(context)) {
                if (childContextInfo.isCORS !== contextInfo.isCORS)
                    continue;
                const childContext = await spec.childContext(context, childContextInfo.contextElement);
                const contentDocument = await spec.findElement(childContext, { type: 'css', selector: 'html' });
                const isWantedContext = await isEqualElements(childContext, contentDocument, contextInfo.documentElement);
                await spec.parentContext(childContext);
                if (isWantedContext)
                    return childContextInfo.contextElement;
            }
        }
        async function findContextPath(context, contextInfo, contextPath = []) {
            const contentDocument = await spec.findElement(context, { type: 'css', selector: 'html' });
            if (await isEqualElements(context, contentDocument, contextInfo.documentElement)) {
                return contextPath;
            }
            for (const childContextInfo of await getChildContextsInfo(context)) {
                const childContext = await spec.childContext(context, childContextInfo.contextElement);
                const possibleContextPath = [...contextPath, childContextInfo.contextElement];
                const wantedContextPath = await findContextPath(childContext, contextInfo, possibleContextPath);
                await spec.mainContext(context);
                if (wantedContextPath)
                    return wantedContextPath;
                for (const contextElement of contextPath) {
                    await spec.childContext(context, contextElement);
                }
            }
        }
    }
    async switchTo(context) {
        if (await this.currentContext.equals(context))
            return;
        const currentPath = this.currentContext.path;
        const requiredPath = context.path;
        let diffIndex = -1;
        for (const [index, context] of requiredPath.entries()) {
            if (currentPath[index] && !(await currentPath[index].equals(context))) {
                diffIndex = index;
                break;
            }
        }
        if (diffIndex === 0) {
            throw new Error('Cannot switch to the context, because it has different main context');
        }
        else if (diffIndex === -1) {
            if (currentPath.length === requiredPath.length) {
                // required and current paths are the same
                return this.currentContext;
            }
            else if (requiredPath.length > currentPath.length) {
                // current path is a sub-path of required path
                return this.switchToChildContext(...requiredPath.slice(currentPath.length));
            }
            else if (currentPath.length - requiredPath.length <= requiredPath.length) {
                // required path is a sub-path of current path
                return this.switchToParentContext(currentPath.length - requiredPath.length);
            }
            else {
                // required path is a sub-path of current path
                await this.switchToMainContext();
                return this.switchToChildContext(...requiredPath);
            }
        }
        else if (currentPath.length - diffIndex <= diffIndex) {
            // required path is different from current or they are partially intersected
            // chose an optimal way to traverse from current context to target context
            await this.switchToParentContext(currentPath.length - diffIndex);
            return this.switchToChildContext(...requiredPath.slice(diffIndex));
        }
        else {
            await this.switchToMainContext();
            return this.switchToChildContext(...requiredPath);
        }
    }
    async switchToMainContext() {
        if (this.isNative)
            throw new Error('Contexts are supported only for web drivers');
        this._logger.log('Switching to the main context');
        await this._spec.mainContext(this.currentContext.target);
        return (this._currentContext = this._mainContext);
    }
    async switchToParentContext(elevation = 1) {
        if (this.isNative)
            throw new Error('Contexts are supported only for web drivers');
        this._logger.log('Switching to a parent context with elevation:', elevation);
        if (this.currentContext.path.length <= elevation) {
            return this.switchToMainContext();
        }
        try {
            while (elevation > 0) {
                await this._spec.parentContext(this.currentContext.target);
                this._currentContext = this._currentContext.parent;
                elevation -= 1;
            }
        }
        catch (err) {
            this._logger.warn('Unable to switch to a parent context due to error', err);
            this._logger.log('Applying workaround to switch to the parent frame');
            const path = this.currentContext.path.slice(1, -elevation);
            await this.switchToMainContext();
            await this.switchToChildContext(...path);
            elevation = 0;
        }
        return this.currentContext;
    }
    async switchToChildContext(...references) {
        if (this.isNative)
            throw new Error('Contexts are supported only for web drivers');
        this._logger.log('Switching to a child context with depth:', references.length);
        for (const reference of references) {
            if (reference === this.mainContext)
                continue;
            const context = await this.currentContext.context(reference);
            await context.focus();
        }
        return this.currentContext;
    }
    async normalizeRegion(region) {
        if (!this._driverInfo.viewportRegion || !this.isNative)
            return region;
        const viewportRegion = this.isIOS
            ? utils.geometry.scale(this._driverInfo.viewportRegion, 1 / this.pixelRatio)
            : this._driverInfo.viewportRegion;
        const offsetRegion = utils.geometry.offsetNegative(region, utils.geometry.location(viewportRegion));
        return this.isAndroid ? utils.geometry.scale(offsetRegion, 1 / this.pixelRatio) : offsetRegion;
    }
    async getRegionInViewport(context, region) {
        await context.focus();
        return context.getRegionInViewport(region);
    }
    async element(selector) {
        return this.currentContext.element(selector);
    }
    async elements(selector) {
        return this.currentContext.elements(selector);
    }
    async execute(script, arg) {
        return this.currentContext.execute(script, arg);
    }
    async takeScreenshot() {
        return this._spec.takeScreenshot(this.target);
    }
    async getViewportSize() {
        var _a;
        let size;
        if (this.isNative) {
            this._logger.log('Extracting viewport size from native driver');
            if ((_a = this._driverInfo) === null || _a === void 0 ? void 0 : _a.viewportRegion) {
                size = utils.geometry.scale(utils.geometry.size(this._driverInfo.viewportRegion), 1 / this.pixelRatio);
            }
            else {
                size = await this._spec.getWindowSize(this.target);
                if (size.height > size.width) {
                    const orientation = await this.getOrientation();
                    if (orientation === 'landscape') {
                        size = { width: size.height, height: size.width };
                    }
                }
            }
        }
        else if (this._spec.getViewportSize) {
            this._logger.log('Extracting viewport size from web driver using spec method');
            size = await this._spec.getViewportSize(this.target);
        }
        else {
            this._logger.log('Extracting viewport size from web driver using js snippet');
            size = await this.mainContext.execute(snippets.getViewportSize);
        }
        this._logger.log('Extracted viewport size', size);
        return size;
    }
    async setViewportSize(size) {
        if (this.isMobile)
            return;
        if (this._spec.setViewportSize) {
            this._logger.log('Setting viewport size to', size, 'using spec method');
            await this._spec.setViewportSize(this.target, size);
            return;
        }
        this._logger.log('Setting viewport size to', size, 'using workaround');
        const requiredViewportSize = size;
        let currentViewportSize = await this.getViewportSize();
        if (utils.geometry.equals(currentViewportSize, requiredViewportSize))
            return;
        let currentWindowSize = await this._spec.getWindowSize(this.target);
        this._logger.log('Extracted window size', currentWindowSize);
        let attempt = 0;
        while (attempt++ < 3) {
            const requiredWindowSize = {
                width: currentWindowSize.width + (requiredViewportSize.width - currentViewportSize.width),
                height: currentWindowSize.height + (requiredViewportSize.height - currentViewportSize.height),
            };
            this._logger.log(`Attempt #${attempt} to set viewport size by setting window size to`, requiredWindowSize);
            await this._spec.setWindowSize(this.target, requiredWindowSize);
            await utils.general.sleep(3000);
            currentWindowSize = requiredWindowSize;
            currentViewportSize = await this.getViewportSize();
            if (utils.geometry.equals(currentViewportSize, requiredViewportSize))
                return;
            this._logger.log(`Attempt #${attempt} to set viewport size failed. Current viewport:`, currentViewportSize);
        }
        throw new Error('Failed to set viewport size!');
    }
    async getDisplaySize() {
        if (this.isWeb)
            return;
        const size = await this._spec.getWindowSize(this.target);
        return utils.geometry.scale(size, 1 / this.pixelRatio);
    }
    async getOrientation() {
        if (this.isWeb)
            return;
        const orientation = this._spec.getOrientation(this.target);
        this._logger.log('Extracted device orientation:', orientation);
        return orientation;
    }
    async getTitle() {
        if (this.isNative)
            return null;
        const title = await this._spec.getTitle(this.target);
        this._logger.log('Extracted title:', title);
        return title;
    }
    async getUrl() {
        if (this.isNative)
            return null;
        const url = this._spec.getUrl(this.target);
        this._logger.log('Extracted url:', url);
        return url;
    }
    async visit(url) {
        await this._spec.visit(this.target, url);
    }
}
exports.Driver = Driver;


/***/ }),

/***/ "./node_modules/@applitools/driver/dist/element.js":
/*!*********************************************************!*\
  !*** ./node_modules/@applitools/driver/dist/element.js ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Element = void 0;
const utils = __importStar(__webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js"));
const snippets = __webpack_require__(/*! @applitools/snippets */ "./node_modules/@applitools/snippets/dist/index.js");
class Element {
    constructor(options) {
        var _a, _b, _c, _d, _e, _f;
        this._state = {};
        if (options.element instanceof Element)
            return options.element;
        this._spec = options.spec;
        if (options.context)
            this._context = options.context;
        if (options.logger)
            this._logger = options.logger;
        if (this._spec.isElement(options.element)) {
            this._target = (_c = (_b = (_a = this._spec).transformElement) === null || _b === void 0 ? void 0 : _b.call(_a, options.element)) !== null && _c !== void 0 ? _c : options.element;
            // Some frameworks contains information about the selector inside an element
            this._selector = (_d = options.selector) !== null && _d !== void 0 ? _d : (_f = (_e = this._spec).extractSelector) === null || _f === void 0 ? void 0 : _f.call(_e, options.element);
            this._index = options.index;
        }
        else if (this._spec.isSelector(options.selector)) {
            this._selector = options.selector;
        }
        else {
            throw new TypeError('Element constructor called with argument of unknown type!');
        }
    }
    get target() {
        return this._target;
    }
    get selector() {
        return this._selector;
    }
    get context() {
        return this._context;
    }
    get driver() {
        return this.context.driver;
    }
    get isRef() {
        return this.context.isRef || !this.target;
    }
    async equals(element) {
        if (this.isRef)
            return false;
        element = element instanceof Element ? element.target : element;
        if (this._spec.isEqualElements) {
            return this._spec.isEqualElements(this.context.target, this.target, element);
        }
        else {
            return this._spec
                .executeScript(this.context.target, snippets.isEqualElements, [this.target, element])
                .catch(() => false);
        }
    }
    async init(context) {
        this._context = context;
        this._logger = context._logger;
        if (this._target)
            return this;
        if (this._selector) {
            const element = await this._context.element(this._selector);
            if (!element)
                throw new Error(`Cannot find element with selector ${JSON.stringify(this._selector)}`);
            this._target = element.target;
            return this;
        }
    }
    async getRegion() {
        const region = await this.withRefresh(async () => {
            if (this.driver.isWeb) {
                this._logger.log('Extracting region of web element with selector', this.selector);
                return this.context.execute(snippets.getElementRect, [this, false]);
            }
            else {
                this._logger.log('Extracting region of native element with selector', this.selector);
                const region = await this._spec.getElementRegion(this.driver.target, this.target);
                this._logger.log('Extracted native region', region);
                return this.driver.normalizeRegion(region);
            }
        });
        this._logger.log('Extracted region', region);
        return region;
    }
    async getClientRegion() {
        const region = await this.withRefresh(async () => {
            if (this.driver.isWeb) {
                this._logger.log('Extracting region of web element with selector', this.selector);
                return this.context.execute(snippets.getElementRect, [this, true]);
            }
            else {
                this._logger.log('Extracting region of native element with selector', this.selector);
                const region = await this._spec.getElementRegion(this.driver.target, this.target);
                this._logger.log('Extracted native region', region);
                return this.driver.normalizeRegion(region);
            }
        });
        this._logger.log('Extracted client region', region);
        return region;
    }
    async getContentSize() {
        if (this._state.contentSize)
            return this._state.contentSize;
        const size = await this.withRefresh(async () => {
            var _a;
            if (this.driver.isWeb) {
                this._logger.log('Extracting content size of web element with selector', this.selector);
                return this.context.execute(snippets.getElementContentSize, [this]);
            }
            else {
                this._logger.log('Extracting content size of native element with selector', this.selector);
                try {
                    if (this.driver.isAndroid) {
                        const className = await this.getAttribute('className');
                        if ([
                            'android.widget.ListView',
                            'android.widget.GridView',
                            'android.support.v7.widget.RecyclerView',
                            // 'androidx.recyclerview.widget.RecyclerView',
                            'androidx.viewpager2.widget.ViewPager2',
                        ].includes(className)) {
                            this._logger.log('Trying to extract content size using android helper library');
                            const helperElement = await this.driver.element({
                                type: '-android uiautomator',
                                selector: 'new UiSelector().description("EyesAppiumHelper")',
                            });
                            if (helperElement) {
                                const elementRegion = await this._spec.getElementRegion(this.driver.target, this.target);
                                await helperElement.click();
                                const info = await this._spec.getElementText(this.driver.target, helperElement.target);
                                this._state.contentSize = utils.geometry.scale({ width: elementRegion.width, height: Number(info) }, 1 / this.driver.pixelRatio);
                            }
                            else {
                                this._logger.log('Helper library for android was not detected');
                            }
                        }
                    }
                    else if (this.driver.isIOS) {
                        const type = await this.getAttribute('type');
                        if (type === 'XCUIElementTypeScrollView') {
                            const elementRegion = await this._spec.getElementRegion(this.driver.target, this.target);
                            const [childElement] = await this.driver.elements({
                                type: 'xpath',
                                selector: '//XCUIElementTypeScrollView[1]/*', // We cannot be sure that our element is the first one
                            });
                            const childElementRegion = await this._spec.getElementRegion(this.driver.target, childElement.target);
                            this._state.contentSize = {
                                width: elementRegion.width,
                                height: childElementRegion.y + childElementRegion.height - elementRegion.y,
                            };
                        }
                        else if (type === 'XCUIElementTypeCollectionView') {
                            this._logger.log('Trying to extract content size using ios helper library');
                            const helperElement = await this.driver.element({
                                type: 'name',
                                selector: 'applitools_grab_scrollable_data_button',
                            });
                            if (helperElement) {
                                const helperElementRegion = await this._spec.getElementRegion(this.driver.target, helperElement.target);
                                await this._spec.performAction(this.driver.target, [
                                    { action: 'tap', x: helperElementRegion.x, y: helperElementRegion.y },
                                    { action: 'wait', ms: 1000 },
                                    { action: 'release' },
                                ]);
                                const infoElement = await this.driver.element({ type: 'name', selector: 'applitools_content_size_label' });
                                const info = await this._spec.getElementText(this.driver.target, infoElement.target);
                                if (info) {
                                    const [_, width, height] = info.match(/\{(\d+),\s?(\d+)\}/);
                                    this._state.contentSize = { width: Number(width), height: Number(height) };
                                }
                            }
                            else {
                                this._logger.log('Helper library for ios was not detected');
                            }
                        }
                    }
                    if (!this._state.contentSize) {
                        const data = JSON.parse(await this.getAttribute('contentSize'));
                        this._logger.log('Extracted native content size attribute', data);
                        this._state.contentSize = this.driver.isIOS
                            ? { width: data.width, height: data.scrollableOffset }
                            : utils.geometry.scale({ width: data.width, height: data.height + data.scrollableOffset }, 1 / this.driver.pixelRatio);
                        this._touchPadding = (_a = data.touchPadding) !== null && _a !== void 0 ? _a : this._touchPadding;
                    }
                    if (this.driver.isAndroid) {
                        this._logger.log('Stabilizing android scroll offset');
                        // android has a bug when after extracting 'contentSize' attribute the element is being scrolled by undetermined number of pixels
                        const originalScrollOffset = await this.getScrollOffset();
                        this._state.scrollOffset = { x: -1, y: -1 };
                        await this.scrollTo({ x: 0, y: 0 });
                        await this.scrollTo(originalScrollOffset);
                    }
                    return this._state.contentSize;
                }
                catch (err) {
                    this._logger.warn('Failed to extract content size, extracting client size instead');
                    this._logger.error(err);
                    return utils.geometry.size(await this.getClientRegion());
                }
            }
        });
        this._logger.log('Extracted content size', size);
        return size;
    }
    async isScrollable() {
        this._logger.log('Check is element with selector', this.selector, 'is scrollable');
        const isScrollable = await this.withRefresh(async () => {
            if (this.driver.isWeb) {
                return this.context.execute(snippets.isElementScrollable, [this]);
            }
            else if (this.driver.isAndroid) {
                const data = JSON.parse(await this.getAttribute('scrollable'));
                return Boolean(data) || false;
            }
            else if (this.driver.isIOS) {
                const type = await this.getAttribute('type');
                return ['XCUIElementTypeScrollView', 'XCUIElementTypeTable', 'XCUIElementTypeCollectionView'].includes(type);
            }
        });
        this._logger.log('Element is scrollable', isScrollable);
        return isScrollable;
    }
    async isRoot() {
        // TODO replace with snippet
        return this.withRefresh(async () => {
            if (this.driver.isWeb) {
                const rootElement = await this.context.element({ type: 'css', selector: 'html' });
                return this.equals(rootElement);
            }
            else {
                return false;
            }
        });
    }
    async getTouchPadding() {
        if (this._touchPadding == null) {
            if (this.driver.isWeb)
                this._touchPadding = 0;
            else if (this.driver.isIOS)
                this._touchPadding = 14;
            else if (this.driver.isAndroid) {
                const { touchPadding } = JSON.parse(await this.getAttribute('contentSize'));
                this._touchPadding = touchPadding !== null && touchPadding !== void 0 ? touchPadding : 0;
            }
        }
        return this._touchPadding;
    }
    async getAttribute(name) {
        if (this.driver.isWeb) {
            const properties = await this.context.execute(snippets.getElementProperties, [this, [name]]);
            return properties[name];
        }
        else {
            return this._spec.getElementAttribute(this.driver.target, this.target, name);
        }
    }
    async setAttribute(name, value) {
        if (this.driver.isWeb) {
            await this.context.execute(snippets.setElementAttributes, [this, { [name]: value }]);
        }
    }
    async scrollTo(offset) {
        return this.withRefresh(async () => {
            offset = { x: Math.round(offset.x), y: Math.round(offset.y) };
            if (this.driver.isWeb) {
                return this.context.execute(snippets.scrollTo, [this, offset]);
            }
            else {
                const currentScrollOffset = await this.getScrollOffset();
                if (utils.geometry.equals(offset, currentScrollOffset))
                    return currentScrollOffset;
                const contentSize = await this.getContentSize();
                const scrollableRegion = await this._spec.getElementRegion(this.driver.target, this.target);
                const scaledScrollableRegion = this.driver.isAndroid
                    ? utils.geometry.scale(scrollableRegion, 1 / this.driver.pixelRatio)
                    : scrollableRegion;
                const maxOffset = {
                    x: Math.round(scaledScrollableRegion.width * (contentSize.width / scaledScrollableRegion.width - 1)),
                    y: Math.round(scaledScrollableRegion.height * (contentSize.height / scaledScrollableRegion.height - 1)),
                };
                let requiredOffset;
                let remainingOffset;
                if (offset.x === 0 && offset.y === 0) {
                    requiredOffset = offset;
                    remainingOffset = { x: -maxOffset.x, y: -maxOffset.y };
                }
                else {
                    requiredOffset = { x: Math.min(offset.x, maxOffset.x), y: Math.min(offset.y, maxOffset.y) };
                    remainingOffset = utils.geometry.offsetNegative(requiredOffset, currentScrollOffset);
                }
                if (this.driver.isAndroid) {
                    remainingOffset = utils.geometry.scale(remainingOffset, this.driver.pixelRatio);
                }
                const actions = [];
                const xPadding = Math.floor(scrollableRegion.width * 0.1);
                const yCenter = Math.floor(scrollableRegion.y + scrollableRegion.height / 2);
                const xLeft = scrollableRegion.y + xPadding;
                const xDirection = remainingOffset.y > 0 ? 'right' : 'left';
                let xRemaining = Math.abs(remainingOffset.x);
                while (xRemaining > 0) {
                    const xRight = scrollableRegion.x + Math.min(xRemaining + xPadding, scrollableRegion.width - xPadding);
                    const [xStart, xEnd] = xDirection === 'right' ? [xRight, xLeft] : [xLeft, xRight];
                    actions.push({ action: 'press', x: xStart, y: yCenter }, { action: 'wait', ms: 1500 }, { action: 'moveTo', x: xEnd, y: yCenter }, { action: 'release' });
                    xRemaining -= xRight - xLeft;
                }
                const yPadding = Math.floor(scrollableRegion.height * 0.1);
                const xCenter = Math.floor(scrollableRegion.x + scrollableRegion.width / 2); // 0
                const yTop = scrollableRegion.y + yPadding;
                const yDirection = remainingOffset.y > 0 ? 'down' : 'up';
                let yRemaining = Math.abs(remainingOffset.y) + (await this.getTouchPadding()) * 2;
                while (yRemaining > 0) {
                    const yBottom = scrollableRegion.y + Math.min(yRemaining + yPadding, scrollableRegion.height - yPadding);
                    const [yStart, yEnd] = yDirection === 'down' ? [yBottom, yTop] : [yTop, yBottom];
                    actions.push({ action: 'press', x: xCenter, y: yStart }, { action: 'wait', ms: 1500 }, { action: 'moveTo', x: xCenter, y: yEnd }, { action: 'wait', ms: 1500 }, { action: 'release' });
                    yRemaining -= yBottom - yTop;
                }
                if (actions.length > 0) {
                    await this._spec.performAction(this.driver.target, actions);
                }
                this._state.scrollOffset = requiredOffset;
                return this._state.scrollOffset;
            }
        });
    }
    async translateTo(offset) {
        offset = { x: Math.round(offset.x), y: Math.round(offset.y) };
        if (this.driver.isWeb) {
            return this.withRefresh(async () => this.context.execute(snippets.translateTo, [this, offset]));
        }
        else {
            throw new Error('Cannot apply css translate scrolling on non-web element');
        }
    }
    async getScrollOffset() {
        var _a;
        if (this.driver.isWeb) {
            return this.withRefresh(() => this.context.execute(snippets.getElementScrollOffset, [this]));
        }
        else {
            return (_a = this._state.scrollOffset) !== null && _a !== void 0 ? _a : { x: 0, y: 0 };
        }
    }
    async getTranslateOffset() {
        if (this.driver.isWeb) {
            return this.withRefresh(() => this.context.execute(snippets.getElementTranslateOffset, [this]));
        }
        else {
            throw new Error('Cannot apply css translate scrolling on non-web element');
        }
    }
    async getInnerOffset() {
        if (this.driver.isWeb) {
            return this.withRefresh(() => this.context.execute(snippets.getElementInnerOffset, [this]));
        }
        else {
            return this.getScrollOffset();
        }
    }
    async click() {
        await this._spec.click(this.context.target, this.target);
    }
    async preserveState() {
        if (this.driver.isNative)
            return;
        // TODO create single js snippet
        const scrollOffset = await this.getScrollOffset();
        const transforms = await this.context.execute(snippets.getElementStyleProperties, [
            this,
            ['transform', '-webkit-transform'],
        ]);
        if (!utils.types.has(this._state, ['scrollOffset', 'transforms'])) {
            this._state.scrollOffset = scrollOffset;
            this._state.transforms = transforms;
        }
        return { scrollOffset, transforms };
    }
    async restoreState(state = this._state) {
        if (this.driver.isNative)
            return;
        if (state.scrollOffset)
            await this.scrollTo(state.scrollOffset);
        if (state.transforms)
            await this.context.execute(snippets.setElementStyleProperties, [this, state.transforms]);
        if (state === this._state) {
            this._state.scrollOffset = null;
            this._state.transforms = null;
        }
    }
    async hideScrollbars() {
        if (this.driver.isNative)
            return;
        if (this._originalOverflow)
            return;
        return this.withRefresh(async () => {
            const { overflow } = await this.context.execute(snippets.setElementStyleProperties, [this, { overflow: 'hidden' }]);
            this._originalOverflow = overflow;
        });
    }
    async restoreScrollbars() {
        if (this.driver.isNative)
            return;
        if (!this._originalOverflow)
            return;
        return this.withRefresh(async () => {
            await this.context.execute(snippets.setElementStyleProperties, [this, { overflow: this._originalOverflow }]);
            this._originalOverflow = null;
        });
    }
    async refresh(freshElement) {
        if (this._spec.isElement(freshElement)) {
            this._target = freshElement;
            return true;
        }
        if (!this._selector)
            return false;
        const element = this._index > 0
            ? await this.context.elements(this._selector).then(elements => elements[this._index])
            : await this.context.element(this._selector);
        if (element) {
            this._target = element.target;
        }
        return Boolean(element);
    }
    async withRefresh(operation) {
        if (!this._spec.isStaleElementError)
            return operation();
        try {
            const result = await operation();
            // Some frameworks could handle stale element reference error by itself or doesn't throw an error
            if (this._spec.isStaleElementError(result, this.selector)) {
                await this.refresh();
                return operation();
            }
            return result;
        }
        catch (err) {
            if (this._spec.isStaleElementError(err)) {
                const refreshed = await this.refresh();
                if (refreshed)
                    return operation();
            }
            throw err;
        }
    }
    toJSON() {
        return this.target;
    }
}
exports.Element = Element;


/***/ }),

/***/ "./node_modules/@applitools/driver/dist/index.js":
/*!*******************************************************!*\
  !*** ./node_modules/@applitools/driver/dist/index.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./context */ "./node_modules/@applitools/driver/dist/context.js"), exports);
__exportStar(__webpack_require__(/*! ./driver */ "./node_modules/@applitools/driver/dist/driver.js"), exports);
__exportStar(__webpack_require__(/*! ./element */ "./node_modules/@applitools/driver/dist/element.js"), exports);


/***/ }),

/***/ "./node_modules/@applitools/driver/dist/user-agent.js":
/*!************************************************************!*\
  !*** ./node_modules/@applitools/driver/dist/user-agent.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.parseBrowser = exports.parsePlatform = exports.parseUserAgent = void 0;
const utils = __importStar(__webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js"));
const MAJOR_MINOR = '(\\d+)(?:[_.](\\d+))?';
const PLATFORM_REGEXES = [
    new RegExp(`(?:(Windows NT) ${MAJOR_MINOR})`),
    new RegExp('(?:(Windows XP))'),
    new RegExp('(?:(Windows 2000))'),
    new RegExp('(?:(Windows NT))'),
    new RegExp('(?:(Windows))'),
    new RegExp(`(?:(Mac OS X) ${MAJOR_MINOR})`),
    new RegExp(`(?:(Android) ${MAJOR_MINOR})`),
    new RegExp(`(?:(CPU(?: i[a-zA-Z]+)? OS) ${MAJOR_MINOR})`),
    new RegExp('(?:(Mac OS X))'),
    new RegExp('(?:(Mac_PowerPC))'),
    new RegExp('(?:(Linux))'),
    new RegExp('(?:(CrOS))'),
    new RegExp('(?:(SymbOS))'),
];
const BROWSER_REGEXPES = [
    new RegExp(`(?:(Opera)/${MAJOR_MINOR})`),
    new RegExp(`(?:(Edg)/${MAJOR_MINOR})`),
    new RegExp(`(?:(Edge)/${MAJOR_MINOR})`),
    new RegExp(`(?:(Chrome)/${MAJOR_MINOR})`),
    new RegExp(`(?:(Safari)/${MAJOR_MINOR})`),
    new RegExp(`(?:(Firefox)/${MAJOR_MINOR})`),
    new RegExp(`(?:MS(IE) ${MAJOR_MINOR})`),
];
const HIDDEN_IE_REGEX = new RegExp(`(?:rv:${MAJOR_MINOR}\\) like Gecko)`);
const BROWSER_VERSION_REGEX = new RegExp(`(?:Version/${MAJOR_MINOR})`);
function parseUserAgent(userAgent) {
    utils.guard.notNull(userAgent, { name: 'userAgent' });
    userAgent = userAgent.trim();
    return Object.assign(Object.assign({}, parsePlatform(userAgent)), parseBrowser(userAgent));
}
exports.parseUserAgent = parseUserAgent;
function parsePlatform(userAgent) {
    const platformRegExp = PLATFORM_REGEXES.find(regexp => regexp.test(userAgent));
    if (!platformRegExp)
        return { platformName: 'Unknown' };
    const [_, platformName, platformMajorVersion, platformMinorVersion] = platformRegExp.exec(userAgent);
    if (platformName.startsWith('CPU')) {
        return { platformName: 'iOS', platformVersion: platformMajorVersion };
    }
    else if (platformName === 'Windows 2000' || platformName === 'Windows XP') {
        return { platformName: 'Windows', platformVersion: '5' };
    }
    else if (platformName === 'Windows NT') {
        const result = { platformName: 'Windows', platformVersion: platformMajorVersion };
        if (!platformMajorVersion) {
            result.platformVersion = '4';
        }
        else if (platformMajorVersion === '6' && platformMinorVersion === '1') {
            result.platformVersion = '7';
        }
        else if (platformMajorVersion === '6' && (platformMinorVersion === '2' || platformMinorVersion === '3')) {
            result.platformVersion = '8';
        }
        return result;
    }
    else if (platformName === 'Mac_PowerPC') {
        return { platformName: 'Macintosh', platformVersion: platformMajorVersion };
    }
    else if (platformName === 'CrOS') {
        return { platformName: 'Chrome OS', platformVersion: platformMajorVersion };
    }
    else {
        return { platformName, platformVersion: platformMajorVersion };
    }
}
exports.parsePlatform = parsePlatform;
function parseBrowser(userAgent) {
    const browserRegExp = BROWSER_REGEXPES.find(regexp => regexp.test(userAgent));
    if (!browserRegExp) {
        if (HIDDEN_IE_REGEX.test(userAgent)) {
            const [_, browserVersion] = HIDDEN_IE_REGEX.exec(userAgent);
            return { browserName: 'IE', browserVersion };
        }
        else {
            return { browserName: 'Unknown' };
        }
    }
    const [_, browserName, browserVersion] = browserRegExp.exec(userAgent);
    const result = { browserName, browserVersion };
    if (result.browserName === 'Edg')
        result.browserName = 'Edge';
    if (BROWSER_VERSION_REGEX.test(userAgent)) {
        const [_, browserVersion] = BROWSER_VERSION_REGEX.exec(userAgent);
        result.browserVersion = browserVersion;
    }
    return result;
}
exports.parseBrowser = parseBrowser;


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

/* eslint-disable max-len */

exports.makeSDK = __webpack_require__(/*! ./lib/new/sdk */ "./node_modules/@applitools/eyes-sdk-core/lib/new/sdk.js")

// config
exports.AccessibilityLevel = __webpack_require__(/*! ./lib/config/AccessibilityLevel */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityLevel.js")
exports.AccessibilityGuidelinesVersion = __webpack_require__(/*! ./lib/config/AccessibilityGuidelinesVersion */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityGuidelinesVersion.js")
exports.AccessibilityMatchSettings = __webpack_require__(/*! ./lib/config/AccessibilityMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityMatchSettings.js")
exports.AccessibilityRegionType = __webpack_require__(/*! ./lib/config/AccessibilityRegionType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityRegionType.js")
exports.BatchInfo = __webpack_require__(/*! ./lib/config/BatchInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BatchInfo.js")
exports.BrowserType = __webpack_require__(/*! ./lib/config/BrowserType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js")
exports.Configuration = __webpack_require__(/*! ./lib/config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")
exports.DeviceName = __webpack_require__(/*! ./lib/config/DeviceName */ "./node_modules/@applitools/eyes-sdk-core/lib/config/DeviceName.js")
exports.ExactMatchSettings = __webpack_require__(/*! ./lib/config/ExactMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ExactMatchSettings.js")
exports.FloatingMatchSettings = __webpack_require__(/*! ./lib/config/FloatingMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js")
exports.ImageMatchSettings = __webpack_require__(/*! ./lib/config/ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js")
exports.MatchLevel = __webpack_require__(/*! ./lib/config/MatchLevel */ "./node_modules/@applitools/eyes-sdk-core/lib/config/MatchLevel.js")
exports.PropertyData = __webpack_require__(/*! ./lib/config/PropertyData */ "./node_modules/@applitools/eyes-sdk-core/lib/config/PropertyData.js")
exports.ProxySettings = __webpack_require__(/*! ./lib/config/ProxySettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ProxySettings.js")
exports.ScreenOrientation = __webpack_require__(/*! ./lib/config/ScreenOrientation */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ScreenOrientation.js")
exports.SessionType = __webpack_require__(/*! ./lib/config/SessionType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/SessionType.js")
exports.StitchMode = __webpack_require__(/*! ./lib/config/StitchMode */ "./node_modules/@applitools/eyes-sdk-core/lib/config/StitchMode.js")
exports.IosDeviceName = __webpack_require__(/*! ./lib/config/IosDeviceName */ "./node_modules/@applitools/eyes-sdk-core/lib/config/IosDeviceName.js")
exports.IosVersion = __webpack_require__(/*! ./lib/config/IosVersion */ "./node_modules/@applitools/eyes-sdk-core/lib/config/IosVersion.js")

// errors
exports.EyesError = __webpack_require__(/*! ./lib/errors/EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")
exports.DiffsFoundError = __webpack_require__(/*! ./lib/errors/DiffsFoundError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js")
exports.NewTestError = __webpack_require__(/*! ./lib/errors/NewTestError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js")
exports.TestFailedError = __webpack_require__(/*! ./lib/errors/TestFailedError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js")

// geometry
exports.CoordinatesType = __webpack_require__(/*! ./lib/geometry/CoordinatesType */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/CoordinatesType.js")
exports.Location = __webpack_require__(/*! ./lib/geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")
exports.RectangleSize = __webpack_require__(/*! ./lib/geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
exports.Region = __webpack_require__(/*! ./lib/geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")

// handler
exports.PropertyHandler = __webpack_require__(/*! ./lib/handler/PropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/PropertyHandler.js")
exports.ReadOnlyPropertyHandler = __webpack_require__(/*! ./lib/handler/ReadOnlyPropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/ReadOnlyPropertyHandler.js")
exports.SimplePropertyHandler = __webpack_require__(/*! ./lib/handler/SimplePropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/SimplePropertyHandler.js")

// images
exports.ImageDeltaCompressor = __webpack_require__(/*! ./lib/images/ImageDeltaCompressor */ "./node_modules/@applitools/eyes-sdk-core/lib/images/ImageDeltaCompressor.js")

// logging
exports.ConsoleLogHandler = __webpack_require__(/*! ./lib/logging/ConsoleLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/ConsoleLogHandler.js")
exports.DebugLogHandler = __webpack_require__(/*! ./lib/logging/DebugLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/DebugLogHandler.js")
exports.FileLogHandler = __webpack_require__(/*! ./lib/logging/FileLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/FileLogHandler.js") // -browser
exports.Logger = __webpack_require__(/*! ./lib/logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")
exports.LogHandler = __webpack_require__(/*! ./lib/logging/LogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js")
exports.NullLogHandler = __webpack_require__(/*! ./lib/logging/NullLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/NullLogHandler.js")

// utils
exports.ArgumentGuard = __webpack_require__(/*! ./lib/utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
exports.ConfigUtils = __webpack_require__(/*! ./lib/utils/ConfigUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ConfigUtils.js")
exports.DateTimeUtils = __webpack_require__(/*! ./lib/utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")
exports.FileUtils = __webpack_require__(/*! ./lib/utils/FileUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/FileUtils.js")
exports.GeneralUtils = __webpack_require__(/*! ./lib/utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
exports.PerformanceUtils = __webpack_require__(/*! ./lib/utils/PerformanceUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js")
exports.StreamUtils = __webpack_require__(/*! ./lib/utils/StreamUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/StreamUtils.js")
exports.TypeUtils = __webpack_require__(/*! ./lib/utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
exports.deserializeDomSnapshotResult = __webpack_require__(/*! ./lib/utils/deserializeDomSnapshotResult */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/deserializeDomSnapshotResult.js")
exports.CorsIframeHandle = __webpack_require__(/*! ./lib/capture/CorsIframeHandles */ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandles.js")
exports.CorsIframeHandler = __webpack_require__(/*! ./lib/capture/CorsIframeHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandler.js")

const closeBatch = __webpack_require__(/*! ./lib/close/closeBatch */ "./node_modules/@applitools/eyes-sdk-core/lib/close/closeBatch.js")
const makeBatchClose = __webpack_require__(/*! ./lib/close/BatchClose */ "./node_modules/@applitools/eyes-sdk-core/lib/close/BatchClose.js")
exports.BatchClose = makeBatchClose(closeBatch)

exports.RemoteSessionEventHandler = __webpack_require__(/*! ./lib/events/RemoteSessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/RemoteSessionEventHandler.js")
exports.SessionEventHandler = __webpack_require__(/*! ./lib/events/SessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js")
exports.ValidationInfo = __webpack_require__(/*! ./lib/events/ValidationInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationInfo.js")
exports.ValidationResult = __webpack_require__(/*! ./lib/events/ValidationResult */ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationResult.js")

exports.AppOutput = __webpack_require__(/*! ./lib/match/AppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/match/AppOutput.js")
exports.MatchResult = __webpack_require__(/*! ./lib/match/MatchResult */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js")
exports.MatchWindowAndCloseData = __webpack_require__(/*! ./lib/match/MatchWindowAndCloseData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowAndCloseData.js")
exports.MatchWindowData = __webpack_require__(/*! ./lib/match/MatchWindowData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js")
exports.ImageMatchOptions = __webpack_require__(/*! ./lib/match/ImageMatchOptions */ "./node_modules/@applitools/eyes-sdk-core/lib/match/ImageMatchOptions.js")

exports.metadata = {
  ActualAppOutput: __webpack_require__(/*! ./lib/metadata/ActualAppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ActualAppOutput.js"),
  Annotations: __webpack_require__(/*! ./lib/metadata/Annotations */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Annotations.js"),
  BatchInfo: __webpack_require__(/*! ./lib/metadata/BatchInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/BatchInfo.js"),
  Branch: __webpack_require__(/*! ./lib/metadata/Branch */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Branch.js"),
  ExpectedAppOutput: __webpack_require__(/*! ./lib/metadata/ExpectedAppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ExpectedAppOutput.js"),
  Image: __webpack_require__(/*! ./lib/metadata/Image */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Image.js"),
  ImageMatchSettings: __webpack_require__(/*! ./lib/metadata/ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ImageMatchSettings.js"),
  SessionResults: __webpack_require__(/*! ./lib/metadata/SessionResults */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/SessionResults.js"),
  StartInfo: __webpack_require__(/*! ./lib/metadata/StartInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/StartInfo.js"),
}

exports.RenderInfo = __webpack_require__(/*! ./lib/renderer/RenderInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderInfo.js")
exports.RenderRequest = __webpack_require__(/*! ./lib/renderer/RenderRequest */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderRequest.js")
exports.RenderStatus = __webpack_require__(/*! ./lib/renderer/RenderStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatus.js")
exports.RenderStatusResults = __webpack_require__(/*! ./lib/renderer/RenderStatusResults */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatusResults.js")
exports.RGridDom = __webpack_require__(/*! ./lib/renderer/RGridDom */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridDom.js")
exports.RGridResource = __webpack_require__(/*! ./lib/renderer/RGridResource */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridResource.js")
exports.RunningRender = __webpack_require__(/*! ./lib/renderer/RunningRender */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RunningRender.js")
exports.EmulationInfo = __webpack_require__(/*! ./lib/renderer/EmulationInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationInfo.js")
exports.EmulationDevice = __webpack_require__(/*! ./lib/renderer/EmulationDevice */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationDevice.js")

exports.RenderingInfo = __webpack_require__(/*! ./lib/server/RenderingInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js")
exports.RunningSession = __webpack_require__(/*! ./lib/server/RunningSession */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RunningSession.js")
exports.ServerConnector = __webpack_require__(/*! ./lib/server/ServerConnector */ "./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js")
exports.getTunnelAgentFromProxy = __webpack_require__(/*! ./lib/server/getTunnelAgentFromProxy */ "./node_modules/@applitools/eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js")
exports.SessionStartInfo = __webpack_require__(/*! ./lib/server/SessionStartInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/SessionStartInfo.js")

exports.MouseTrigger = __webpack_require__(/*! ./lib/triggers/MouseTrigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/MouseTrigger.js")
exports.TextTrigger = __webpack_require__(/*! ./lib/triggers/TextTrigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/TextTrigger.js")
exports.Trigger = __webpack_require__(/*! ./lib/triggers/Trigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/Trigger.js")

exports.AppEnvironment = __webpack_require__(/*! ./lib/AppEnvironment */ "./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js")
exports.FailureReports = __webpack_require__(/*! ./lib/FailureReports */ "./node_modules/@applitools/eyes-sdk-core/lib/FailureReports.js")
exports.MatchWindowTask = __webpack_require__(/*! ./lib/MatchWindowTask */ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowTask.js")
exports.TestResults = __webpack_require__(/*! ./lib/TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")
exports.TestResultsError = __webpack_require__(/*! ./lib/TestResultsError */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsError.js")
exports.AccessibilityStatus = __webpack_require__(/*! ./lib/AccessibilityStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/AccessibilityStatus.js")
exports.TestResultsFormatter = __webpack_require__(/*! ./lib/TestResultsFormatter */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsFormatter.js")
exports.TestResultsStatus = __webpack_require__(/*! ./lib/TestResultsStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js")

exports.EyesBase = __webpack_require__(/*! ./lib/sdk/EyesBase */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesBase.js")
exports.EyesClassic = __webpack_require__(/*! ./lib/sdk/EyesClassic */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesClassic.js")
exports.EyesVisualGrid = __webpack_require__(/*! ./lib/sdk/EyesVisualGrid */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesVisualGrid.js")
exports.EyesFactory = __webpack_require__(/*! ./lib/sdk/EyesFactory */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesFactory.js")
exports.EyesSDK = __webpack_require__(/*! ./lib/sdk/EyesSDK */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesSDK.js")

exports.takeDomSnapshot = __webpack_require__(/*! ./lib/utils/takeDomSnapshot */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshot.js")
exports.takeDomSnapshots = __webpack_require__(/*! ./lib/utils/takeDomSnapshots */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshots.js")
exports.takeDomCapture = __webpack_require__(/*! ./lib/utils/takeDomCapture */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomCapture.js")

exports.EyesRunner = __webpack_require__(/*! ./lib/runner/EyesRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js")
exports.ClassicRunner = __webpack_require__(/*! ./lib/runner/ClassicRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js")
exports.VisualGridRunner = __webpack_require__(/*! ./lib/runner/VisualGridRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js")
exports.RunnerOptions = __webpack_require__(/*! ./lib/runner/RunnerOptions */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/RunnerOptions.js")
exports.LogEvent = __webpack_require__(/*! ./lib/logging/LogEvent */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogEvent.js")
exports.RunnerStartedEvent = __webpack_require__(/*! ./lib/logging/RunnerStartedEvent */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/RunnerStartedEvent.js")


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/AccessibilityStatus.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/AccessibilityStatus.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const Enum = __webpack_require__(/*! ./utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('./utils/Enum').EnumValues<typeof AccessibilityStatuses>} AccessibilityStatus
 */

const AccessibilityStatuses = Enum('AccessibilityStatus', {
  /** @type {'Passed'} */
  Passed: 'Passed',
  /** @type {'Failed'} */
  Failed: 'Failed',
})

module.exports = AccessibilityStatuses


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const RectangleSize = __webpack_require__(/*! ../lib/geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const GeneralUtils = __webpack_require__(/*! ../lib/utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * The environment in which the application under test is executing.
 */
class AppEnvironment {
  /**
   * Creates a new AppEnvironment instance.
   * @param data
   * @param {string} [data.os]
   * @param {string} [data.hostingApp]
   * @param {RectangleSize} [data.displaySize]
   * @param {string} [data.deviceInfo]
   * @param {string} [data.osInfo]
   * @param {string} [data.hostingAppInfo]
   */
  constructor({os, hostingApp, displaySize, deviceInfo, osInfo, hostingAppInfo} = {}) {
    if (displaySize && !(displaySize instanceof RectangleSize)) {
      displaySize = new RectangleSize(displaySize)
    }

    this._os = os
    this._hostingApp = hostingApp
    this._displaySize = displaySize
    this._deviceInfo = deviceInfo
    this._osInfo = osInfo
    this._hostingAppInfo = hostingAppInfo

    /** @type {string} */
    this._inferred = undefined
  }

  /**
   * Creates a new AppEnvironment instance.
   *
   * @param {string} inferred
   * @return {AppEnvironment}
   */
  static fromInferred(inferred) {
    const env = new AppEnvironment()
    env.setInferred(inferred)
    return env
  }

  /**
   * Gets the information inferred from the execution environment or {@code null} if no information could be inferred.
   *
   * @return {string}
   */
  geInferred() {
    return this._inferred
  }

  /**
   * Sets the inferred environment information.
   *
   * @param {string} value
   */
  setInferred(value) {
    this._inferred = value
  }

  /**
   * Gets the OS hosting the application under test or {@code null} if unknown.
   *
   * @return {string}
   */
  getOs() {
    return this._os
  }

  /**
   * Sets the OS hosting the application under test or {@code null} if unknown.
   *
   * @param {string} value
   */
  setOs(value) {
    this._os = value
  }

  /**
   * Gets the application hosting the application under test or {@code null} if unknown.
   *
   * @return {string}
   */
  getHostingApp() {
    return this._hostingApp
  }

  /**
   * Sets the application hosting the application under test or {@code null} if unknown.
   *
   * @param {string} value
   */
  setHostingApp(value) {
    this._hostingApp = value
  }

  /**
   * Gets the display size of the application or {@code null} if unknown.
   *
   * @return {RectangleSize}
   */
  getDisplaySize() {
    return this._displaySize
  }

  /**
   * Sets the display size of the application or {@code null} if unknown.
   *
   * @param {RectangleSize} value
   */
  setDisplaySize(value) {
    this._displaySize = value
  }

  /**
   * Gets the OS hosting the application under test or {@code null} if unknown. (not part of test signature)
   *
   * @return {string}
   */
  getOsInfo() {
    return this._osInfo
  }

  /**
   * Sets the OS hosting the application under test or {@code null} if unknown. (not part of test signature)
   *
   * @param {string} value
   */
  setOsInfo(value) {
    this._osInfo = value
  }

  /**
   * Gets the application hosting the application under test or {@code null} if unknown. (not part of test signature)
   *
   * @return {string}
   */
  getHostingAppInfo() {
    return this._hostingAppInfo
  }

  /**
   * Sets the application hosting the application under test or {@code null} if unknown. (not part of test signature)
   *
   * @param {string} value
   */
  setHostingAppInfo(value) {
    this._hostingAppInfo = value
  }

  /**
   * Gets the device info (not part of test signature)
   *
   * @return {string}
   */
  getDeviceInfo() {
    return this._deviceInfo
  }

  /**
   * Sets the device info (not part of test signature)
   *
   * @param {string} value
   */
  setDeviceInfo(value) {
    this._deviceInfo = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `[OS = ${this._os == null ? '?' : `'${this._os}'`} HostingApp = ${
      this._hostingApp == null ? '?' : `'${this._hostingApp}'`
    } DisplaySize = ${this._displaySize}]`
  }
}

module.exports = AppEnvironment


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/FailureReports.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/FailureReports.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const Enum = __webpack_require__(/*! ./utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")
/**
 * @typedef {string} CoordinatesType
 */

/**
 * Determines how detected failures are reported.
 */
const FailureReports = Enum('FailureReport', {
  /**
   * Failures are reported immediately when they are detected.
   */
  IMMEDIATE: 'IMMEDIATE',

  /**
   * Failures are reported when tests are completed (i.e., when {@link EyesBase#close()} is called).
   */
  ON_CLOSE: 'ON_CLOSE',
})

module.exports = FailureReports


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowAndCloseTask.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowAndCloseTask.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const MatchWindowTask = __webpack_require__(/*! ./MatchWindowTask */ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowTask.js")
const ImageMatchOptions = __webpack_require__(/*! ./match/ImageMatchOptions */ "./node_modules/@applitools/eyes-sdk-core/lib/match/ImageMatchOptions.js")
const MatchWindowAndCloseData = __webpack_require__(/*! ./match/MatchWindowAndCloseData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowAndCloseData.js")

/**
 * Handles matching of output with the expected output (including retry and 'ignore mismatch' when needed).
 *
 * @ignore
 */
class MatchWindowAndCloseTask extends MatchWindowTask {
  constructor({updateBaselineIfNew, updateBaselineIfDifferent, ...options}) {
    super(options)
    this._updateBaseLineIfNew = updateBaselineIfNew
    this._updateBaselineIfDifferent = updateBaselineIfDifferent
  }

  async _perform({name, url, renderId, variationGroupId, appOutput, matchSettings, ignoreMismatch, userInputs}) {
    const data = new MatchWindowAndCloseData({
      userInputs,
      appOutput,
      tag: name,
      ignoreMismatch,
      updateBaselineIfNew: this._updateBaseLineIfNew,
      updateBaselineIfDifferent: this._updateBaselineIfDifferent,
      removeSessionIfMatching: ignoreMismatch,
      options: new ImageMatchOptions({
        name,
        source: url,
        renderId,
        variantId: variationGroupId,
        imageMatchSettings: matchSettings,
        userInputs,
        ignoreMismatch,
        ignoreMatch: false,
        forceMismatch: false,
        forceMatch: false,
      }),
    })

    const matchResult = await this._serverConnector.matchWindowAndClose(this._runningSession, data)
    return {matchResult, isSuccess: !matchResult.getIsDifferent()}
  }
}

module.exports = MatchWindowAndCloseTask


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowTask.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowTask.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const PerformanceUtils = __webpack_require__(/*! ./utils/PerformanceUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js")
const MatchWindowData = __webpack_require__(/*! ./match/MatchWindowData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js")
const ImageMatchOptions = __webpack_require__(/*! ./match/ImageMatchOptions */ "./node_modules/@applitools/eyes-sdk-core/lib/match/ImageMatchOptions.js")

const MATCH_INTERVAL = 500 // Milliseconds

class MatchWindowTask {
  constructor({getMatchData, serverConnector, runningSession, retryTimeout, logger}) {
    utils.guard.notNull(getMatchData, {name: 'getMatchData'})
    utils.guard.notNull(serverConnector, {name: 'serverConnector'})
    utils.guard.notNull(runningSession, {name: 'runningSession'})
    utils.guard.isGreaterThenOrEqual(retryTimeout, 0, {name: 'retryTimeout'})
    utils.guard.notNull(logger, {name: 'logger'})

    this._getMatchData = getMatchData
    this._serverConnector = serverConnector
    this._runningSession = runningSession
    this._defaultRetryTimeout = retryTimeout
    this._logger = logger

    this._matchResult = undefined
    this._lastScreenshot = undefined
  }

  async match({
    name,
    url,
    renderId,
    variationGroupId,
    ignoreMismatch,
    sendDom,
    retryTimeout,
    shouldRunOnceOnTimeout,
    userInputs,
  }) {
    utils.guard.isString(name, {name: 'name'})
    utils.guard.isBoolean(shouldRunOnceOnTimeout, {name: 'shouldRunOnceOnTimeout'})
    utils.guard.isBoolean(ignoreMismatch, {name: 'ignoreMismatch'})
    utils.guard.isNumber(retryTimeout, {name: 'retryTimeout', strict: false})

    if (retryTimeout == null || retryTimeout < 0) retryTimeout = this._defaultRetryTimeout
    this._logger.verbose(`retryTimeout = ${retryTimeout}`)

    const timeStart = PerformanceUtils.start()

    const matchOptions = {name, url, renderId, variationGroupId, ignoreMismatch, userInputs}
    let result, lastScreenshot
    // If the wait to load time is 0, or "run once" is true, we perform a single check window.
    if (retryTimeout === 0 || shouldRunOnceOnTimeout) {
      if (shouldRunOnceOnTimeout) await utils.general.sleep(retryTimeout)
      const {screenshot, appOutput, matchSettings} = await this._getMatchData({
        lastScreenshot: this._lastScreenshot,
        sendDom,
      })
      lastScreenshot = screenshot
      result = await this._perform({...matchOptions, appOutput, matchSettings})
    } else {
      const startTime = Date.now()
      let timeSpent = 0
      while (retryTimeout >= timeSpent) {
        const {screenshot, appOutput, matchSettings} = await this._getMatchData({
          lastScreenshot: this._lastScreenshot,
          sendDom,
        })
        lastScreenshot = screenshot
        result = await this._perform({...matchOptions, ignoreMismatch: true, appOutput, matchSettings})
        if (result.isSuccess) break
        await utils.general.sleep(MatchWindowTask.MATCH_INTERVAL)
        timeSpent = Date.now() - startTime
      }

      if (!result.isSuccess) {
        const {screenshot, appOutput, matchSettings} = await this._getMatchData({
          lastScreenshot: this._lastScreenshot,
          sendDom,
        })
        lastScreenshot = screenshot
        result = await this._perform({...matchOptions, appOutput, matchSettings})
      }
    }

    this._logger.verbose(`Completed in ${timeStart.end().summary}`)

    if (ignoreMismatch) {
      return result.matchResult
    }

    this._updateLastScreenshot(lastScreenshot)
    return result.matchResult
  }

  async _perform({name, url, renderId, variationGroupId, appOutput, matchSettings, ignoreMismatch, userInputs}) {
    const data = new MatchWindowData({
      userInputs,
      appOutput,
      tag: name,
      ignoreMismatch,
      options: new ImageMatchOptions({
        name,
        source: url,
        renderId,
        variantId: variationGroupId,
        imageMatchSettings: matchSettings,
        userInputs,
        ignoreMismatch,
        ignoreMatch: false,
        forceMismatch: false,
        forceMatch: false,
      }),
    })

    const matchResult = await this._serverConnector.matchWindow(this._runningSession, data)
    return {matchResult, isSuccess: matchResult.getAsExpected()}
  }

  _updateLastScreenshot(screenshot) {
    if (screenshot) {
      this._lastScreenshot = screenshot
    }
  }

  getLastScreenshot() {
    return this._lastScreenshot
  }
}

MatchWindowTask.MATCH_INTERVAL = MATCH_INTERVAL
module.exports = MatchWindowTask


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const GeneralUtils = __webpack_require__(/*! ./utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const DateTimeUtils = __webpack_require__(/*! ./utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")
const RectangleSize = __webpack_require__(/*! ./geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const TestResultsStatuses = __webpack_require__(/*! ./TestResultsStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js")

/**
 * @typedef {import('./TestResultsStatus').TestResultsStatus} TestResultsStatus
 */

class SessionUrls {
  /**
   * @param {Object} data
   * @param {string} data.batch
   * @param {string} data.session
   */
  constructor({batch, session} = {}) {
    this._batch = batch
    this._session = session
  }

  /**
   * @return {string}
   */
  getBatch() {
    return this._batch
  }

  /**
   * @param {string} value
   */
  setBatch(value) {
    this._batch = value
  }

  /**
   * @return {string}
   */
  getSession() {
    return this._session
  }

  /**
   * @param {string} value
   */
  setSession(value) {
    this._session = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, [], {id: 'testId'})
  }
}

class ApiUrls {
  /**
   * @param {Object} data
   * @param {string} data.baselineImage
   * @param {string} data.currentImage
   * @param {string} data.checkpointImage
   * @param {string} data.checkpointImageThumbnail
   * @param {string} data.diffImage
   */
  constructor({baselineImage, currentImage, checkpointImage, checkpointImageThumbnail, diffImage} = {}) {
    this._baselineImage = baselineImage
    this._currentImage = currentImage
    this._checkpointImage = checkpointImage
    this._checkpointImageThumbnail = checkpointImageThumbnail
    this._diffImage = diffImage
  }

  /**
   * @return {string}
   */
  getBaselineImage() {
    return this._baselineImage
  }

  /**
   * @param {string} value
   */
  setBaselineImage(value) {
    this._baselineImage = value
  }

  /**
   * @return {string}
   */
  getCurrentImage() {
    return this._currentImage
  }

  /**
   * @param {string} value
   */
  setCurrentImage(value) {
    this._currentImage = value
  }

  /**
   * @return {string}
   */
  getCheckpointImage() {
    return this._checkpointImage
  }

  /**
   * @param {string} value
   */
  setCheckpointImage(value) {
    this._checkpointImage = value
  }

  /**
   * @return {string}
   */
  getCheckpointImageThumbnail() {
    return this._checkpointImageThumbnail
  }

  /**
   * @param {string} value
   */
  setCheckpointImageThumbnail(value) {
    this._checkpointImageThumbnail = value
  }

  /**
   * @return {string}
   */
  getDiffImage() {
    return this._diffImage
  }

  /**
   * @param {string} value
   */
  setDiffImage(value) {
    this._diffImage = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }
}

class AppUrls {
  /**
   * @param {Object} data
   * @param {string} data.step
   * @param {string} data.stepEditor
   */
  constructor({step, stepEditor} = {}) {
    this._step = step
    this._stepEditor = stepEditor
  }

  /**
   * @return {string}
   */
  getStep() {
    return this._step
  }

  /**
   * @param {string} value
   */
  setStep(value) {
    this._step = value
  }

  /**
   * @return {string}
   */
  getStepEditor() {
    return this._stepEditor
  }

  /**
   * @param {string} value
   */
  setStepEditor(value) {
    this._stepEditor = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }
}

class StepInfo {
  /**
   * @param {Object} info
   * @param {string} info.name
   * @param {boolean} info.isDifferent
   * @param {boolean} info.hasBaselineImage
   * @param {boolean} info.hasCurrentImage
   * @param {AppUrls|object} info.appUrls
   * @param {ApiUrls|object} info.apiUrls
   * @param {string[]} [info.renderId]
   */
  constructor({name, isDifferent, hasBaselineImage, hasCurrentImage, appUrls, apiUrls, renderId} = {}) {
    if (appUrls && !(appUrls instanceof AppUrls)) {
      appUrls = new AppUrls(appUrls)
    }

    if (apiUrls && !(apiUrls instanceof ApiUrls)) {
      apiUrls = new ApiUrls(apiUrls)
    }

    this._name = name
    this._isDifferent = isDifferent
    this._hasBaselineImage = hasBaselineImage
    this._hasCurrentImage = hasCurrentImage
    this._appUrls = appUrls
    this._apiUrls = apiUrls
    this._renderId = renderId
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} value
   */
  setName(value) {
    this._name = value
  }

  /**
   * @return {boolean}
   */
  getIsDifferent() {
    return this._isDifferent
  }

  /**
   * @param {boolean} value
   */
  setIsDifferent(value) {
    this._isDifferent = value
  }

  /**
   * @return {boolean}
   */
  getHasBaselineImage() {
    return this._hasBaselineImage
  }

  /**
   * @param {boolean} value
   */
  setHasBaselineImage(value) {
    this._hasBaselineImage = value
  }

  /**
   * @return {boolean}
   */
  getHasCurrentImage() {
    return this._hasCurrentImage
  }

  /**
   * @param {boolean} value
   */
  setHasCurrentImage(value) {
    this._hasCurrentImage = value
  }

  /**
   * @return {AppUrls}
   */
  getAppUrls() {
    return this._appUrls
  }

  /**
   * @param {AppUrls} value
   */
  setAppUrls(value) {
    this._appUrls = value
  }

  /**
   * @return {ApiUrls}
   */
  getApiUrls() {
    return this._apiUrls
  }

  /**
   * @param {ApiUrls} value
   */
  setApiUrls(value) {
    this._apiUrls = value
  }

  /**
   * @return {string} value
   */
  getRenderId() {
    return this._renderId
  }

  /**
   * @param {string} value
   */
  setRenderId(value) {
    this._renderId = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }
}

/**
 * @typedef SessionAccessibilityStatus
 * @prop {AccessibilityLevel} level - accessibility level.
 * @prop {AccessibilityGuidelinesVersion} version - accessibility guidelines version.
 * @prop {AccessibilityStatus} status - test accessibility status.
 */

/**
 * Eyes test results.
 */
class TestResults {
  /**
   * @param {Object} results
   * @param {string} [results.id]
   * @param {string} [results.name]
   * @param {string} [results.secretToken]
   * @param {TestResultsStatus} [results.status]
   * @param {string} [results.appName]
   * @param {string} [results.batchName]
   * @param {string} [results.batchId]
   * @param {string} [results.branchName]
   * @param {string} [results.hostOS]
   * @param {string} [results.hostApp]
   * @param {RectangleSize|object} [results.hostDisplaySize]
   * @param {SessionAccessibilityStatus} [results.accessibilityStatus]
   * @param {Date|string} [results.startedAt]
   * @param {number} [results.duration]
   * @param {boolean} [results.isNew]
   * @param {boolean} [results.isDifferent]
   * @param {boolean} [results.isAborted]
   * @param {SessionUrls|object} [results.appUrls]
   * @param {SessionUrls|object} [results.apiUrls]
   * @param {StepInfo[]|object[]} [results.stepsInfo]
   * @param {number} [results.steps]
   * @param {number} [results.matches]
   * @param {number} [results.mismatches]
   * @param {number} [results.missing]
   * @param {number} [results.exactMatches]
   * @param {number} [results.strictMatches]
   * @param {number} [results.contentMatches]
   * @param {number} [results.layoutMatches]
   * @param {number} [results.noneMatches]
   * @param {string} [results.url]
   */
  constructor({
    id,
    name,
    secretToken,
    status,
    appName,
    batchName,
    batchId,
    branchName,
    hostOS,
    hostApp,
    hostDisplaySize,
    startedAt,
    duration,
    isNew,
    isDifferent,
    isAborted,
    appUrls,
    apiUrls,
    stepsInfo,
    steps,
    matches,
    mismatches,
    missing,
    exactMatches,
    strictMatches,
    contentMatches,
    layoutMatches,
    noneMatches,
    url,
    accessibilityStatus,
  } = {}) {
    if (hostDisplaySize && !(hostDisplaySize instanceof RectangleSize)) {
      hostDisplaySize = new RectangleSize(hostDisplaySize)
    }

    if (appUrls && !(appUrls instanceof SessionUrls)) {
      appUrls = new SessionUrls(appUrls)
    }

    if (apiUrls && !(apiUrls instanceof SessionUrls)) {
      apiUrls = new SessionUrls(apiUrls)
    }

    if (startedAt && !(startedAt instanceof Date)) {
      startedAt = DateTimeUtils.fromISO8601DateTime(startedAt)
    }

    if (stepsInfo && stepsInfo.length > 0 && !(stepsInfo[0] instanceof StepInfo)) {
      stepsInfo = stepsInfo.map(step => new StepInfo(step))
    }

    this._id = id
    this._name = name
    this._secretToken = secretToken
    // this._id = undefined;
    this._status = status
    this._appName = appName
    this._batchName = batchName
    this._batchId = batchId
    this._branchName = branchName
    this._hostOS = hostOS
    this._hostApp = hostApp
    this._hostDisplaySize = hostDisplaySize
    this._startedAt = startedAt
    this._duration = duration
    this._isNew = isNew
    this._isDifferent = isDifferent
    this._isAborted = isAborted
    // this._defaultMatchSettings = undefined;
    this._appUrls = appUrls
    this._apiUrls = apiUrls
    this._stepsInfo = stepsInfo
    this._steps = steps
    this._matches = matches
    this._mismatches = mismatches
    this._missing = missing
    this._exactMatches = exactMatches
    this._strictMatches = strictMatches
    this._contentMatches = contentMatches
    this._layoutMatches = layoutMatches
    this._noneMatches = noneMatches
    this._url = url
    this._accessibilityStatus = accessibilityStatus

    /** @type {ServerConnector} */
    this._serverConnector = undefined
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} value
   */
  setName(value) {
    this._name = value
  }

  /**
   * @return {string}
   */
  getSecretToken() {
    return this._secretToken
  }

  /**
   * @param {string} value
   */
  setSecretToken(value) {
    this._secretToken = value
  }

  /**
   * @return {TestResultsStatus}
   */
  getStatus() {
    return this._status
  }

  /**
   * @param {TestResultsStatus} value
   */
  setStatus(value) {
    this._status = value
  }

  /**
   * @return {string}
   */
  getAppName() {
    return this._appName
  }

  /**
   * @param {string} value
   */
  setAppName(value) {
    this._appName = value
  }

  /**
   * @return {string}
   */
  getBatchName() {
    return this._batchName
  }

  /**
   * @param {string} value
   */
  setBatchName(value) {
    this._batchName = value
  }

  /**
   * @return {string}
   */
  getBatchId() {
    return this._batchId
  }

  /**
   * @param {string} value
   */
  setBatchId(value) {
    this._batchId = value
  }

  /**
   * @return {string}
   */
  getBranchName() {
    return this._branchName
  }

  /**
   * @param {string} value
   */
  setBranchName(value) {
    this._branchName = value
  }

  /**
   * @return {string}
   */
  getHostOS() {
    return this._hostOS
  }

  /**
   * @param {string} value
   */
  setHostOS(value) {
    this._hostOS = value
  }

  /**
   * @return {string}
   */
  getHostApp() {
    return this._hostApp
  }

  /**
   * @param {string} value
   */
  setHostApp(value) {
    this._hostApp = value
  }

  /**
   * @return {RectangleSize}
   */
  getHostDisplaySize() {
    return this._hostDisplaySize
  }

  /**
   * @param {RectangleSize} value
   */
  setHostDisplaySize(value) {
    this._hostDisplaySize = value
  }

  /**
   * @return {SessionAccessibilityStatus}
   */
  getAccessibilityStatus() {
    return this._accessibilityStatus
  }

  /**
   * @param {SessionAccessibilityStatus} value
   */
  setAccessibilityStatus(value) {
    this._accessibilityStatus = value
  }

  /**
   * @return {Date}
   */
  getStartedAt() {
    return this._startedAt
  }

  /**
   * @param {Date} value
   */
  setStartedAt(value) {
    this._startedAt = value
  }

  /**
   * @return {number}
   */
  getDuration() {
    return this._duration
  }

  /**
   * @param {number} value
   */
  setDuration(value) {
    this._duration = value
  }

  /**
   * @return {boolean} - Whether or not this is a new test.
   */
  getIsNew() {
    return this._isNew
  }

  /**
   * @param {boolean} value - Whether or not this test has an existing baseline.
   */
  setIsNew(value) {
    this._isNew = value
  }

  /**
   * @return {boolean}
   */
  getIsDifferent() {
    return this._isDifferent
  }

  /**
   * @param {boolean} value
   */
  setIsDifferent(value) {
    this._isDifferent = value
  }

  /**
   * @return {boolean}
   */
  getIsAborted() {
    return this._isAborted
  }

  /**
   * @param {boolean} value
   */
  setIsAborted(value) {
    this._isAborted = value
  }

  /**
   * @return {SessionUrls}
   */
  getAppUrls() {
    return this._appUrls
  }

  /**
   * @param {SessionUrls} value
   */
  setAppUrls(value) {
    this._appUrls = value
  }

  /**
   * @return {SessionUrls}
   */
  getApiUrls() {
    return this._apiUrls
  }

  /**
   * @param {SessionUrls} value
   */
  setApiUrls(value) {
    this._apiUrls = value
  }

  /**
   * @return {StepInfo[]}
   */
  getStepsInfo() {
    return this._stepsInfo
  }

  /**
   * @param {StepInfo[]} value
   */
  setStepsInfo(value) {
    this._stepsInfo = value
  }

  /**
   * @return {number} - The total number of test steps.
   */
  getSteps() {
    return this._steps
  }

  /**
   * @param {number} value - The number of visual checkpoints in the test.
   */
  setSteps(value) {
    this._steps = value
  }

  /**
   * @return {number} - The total number of test steps that matched the baseline.
   */
  getMatches() {
    return this._matches
  }

  /**
   * @param {number} value - The number of visual matches in the test.
   */
  setMatches(value) {
    this._matches = value
  }

  /**
   * @return {number} - The total number of test steps that did not match the baseline.
   */
  getMismatches() {
    return this._mismatches
  }

  /**
   * @param {number} value - The number of mismatches in the test.
   */
  setMismatches(value) {
    this._mismatches = value
  }

  /**
   * @return {number} - The total number of baseline test steps that were missing in the test.
   */
  getMissing() {
    return this._missing
  }

  /**
   * @param {number} value - The number of visual checkpoints that were available in the baseline but were not found
   *   in the current test.
   */
  setMissing(value) {
    this._missing = value
  }

  /**
   * @return {number} - The total number of test steps that exactly matched the baseline.
   */
  getExactMatches() {
    return this._exactMatches
  }

  /**
   * @param {number} value - The number of matches performed with match level set to {@link MatchLevel#Exact}
   */
  setExactMatches(value) {
    this._exactMatches = value
  }

  /**
   * @return {number} - The total number of test steps that strictly matched the baseline.
   */
  getStrictMatches() {
    return this._strictMatches
  }

  /**
   * @param {number} value - The number of matches performed with match level set to {@link MatchLevel#Strict}
   */
  setStrictMatches(value) {
    this._strictMatches = value
  }

  /**
   * @return {number} - The total number of test steps that matched the baseline by content.
   */
  getContentMatches() {
    return this._contentMatches
  }

  /**
   * @param {number} value - The number of matches performed with match level set to {@link MatchLevel#Content}
   */
  setContentMatches(value) {
    this._contentMatches = value
  }

  /**
   * @return {number} - The total number of test steps that matched the baseline by layout.
   */
  getLayoutMatches() {
    return this._layoutMatches
  }

  /**
   * @param {number} value - The number of matches performed with match level set to {@link MatchLevel#Layout}
   */
  setLayoutMatches(value) {
    this._layoutMatches = value
  }

  /**
   * @return {number} - The total number of test steps that matched the baseline without performing any comparison.
   */
  getNoneMatches() {
    return this._noneMatches
  }

  /**
   * @param {number} value - The number of matches performed with match level set to {@link MatchLevel#None}
   */
  setNoneMatches(value) {
    this._noneMatches = value
  }

  /**
   * @return {string} - The URL where test results can be viewed.
   */
  getUrl() {
    return this._url
  }

  /**
   * @param {string} value - The URL of the test results.
   */
  setUrl(value) {
    this._url = value
  }

  /**
   * @return {boolean} - Whether or not this test passed.
   */
  isPassed() {
    return this._status === TestResultsStatuses.Passed
  }

  /**
   * @param {ServerConnector} serverConnector
   */
  setServerConnector(serverConnector) {
    this._serverConnector = serverConnector
  }

  /**
   * @return {Promise}
   */
  async deleteSession() {
    return this._serverConnector.deleteSession(this)
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, ['_serverConnector'])
  }

  /**
   * @override
   */
  toString() {
    const isNewTestStr = this._isNew ? 'new test' : 'existing test'
    return `TestResults of ${isNewTestStr} ${GeneralUtils.toString(this, ['_secretToken', '_serverConnector'])}`
  }
}

module.exports = TestResults


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsError.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/TestResultsError.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const TestResults = __webpack_require__(/*! ./TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")

class TestResultsError extends TestResults {
  constructor({name, error}) {
    super({name})
    this.isError = true
    this.error = error
  }
}

module.exports = TestResultsError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsFormatter.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/TestResultsFormatter.js ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";


const OK = 'ok'
const NOT_OK = 'not ok'

/**
 * A utility class for aggregating and formatting test results.
 */
class TestResultsFormatter {
  /**
   * @param {TestResults[]} resultsList
   */
  constructor(resultsList = []) {
    this._resultsList = resultsList
  }

  /**
   * Adds an additional results object to the currently stored results list.
   *
   * @param {TestResults} results - A test results returned by a call to `eyes.close' or 'eyes.abort'.
   * @return {TestResultsFormatter} - The updated 'TestResultsFormatter' instance.
   */
  addTestResults(results) {
    if (results) {
      this._resultsList.push(results)
    }

    return this
  }

  /**
   * Adds an additional results object to the currently stored results list.
   *
   * @deprecated use {@link #addTestResults(results)} instead
   * @param {TestResults} results - A test results returned by a call to `eyes.close' or 'eyes.abort'.
   * @return {TestResultsFormatter} - The updated 'TestResultsFormatter' instance.
   */
  addResults(results) {
    return this.addTestResults(results)
  }

  /**
   * @return {TestResults[]}
   */
  getResultsList() {
    return this._resultsList
  }

  /**
   * @return {void}
   */
  clearResultsList() {
    this._resultsList = []
  }

  /**
   * Creates a TAP representation of the tests results list in hierarchic format.
   *
   * @param {boolean} [includeSubTests=true] - If true, steps will be treated as "subtests". Default is true.
   * @param {boolean} [markNewAsPassed=false] - If true, new tests will be treated as "passed". Default is false.
   * @return {string} - A string which is the TAP representation of the results list.
   */
  asFormatterString(includeSubTests = true, markNewAsPassed = false) {
    if (this._resultsList.length === 0) {
      return 'No results found.'
    }

    let formattedString = '[EYES: TEST RESULTS]:\n'

    for (let i = 0; i < this._resultsList.length; i += 1) {
      /** @type {TestResults} */ const currentResult = this._resultsList[i]

      const testTitle = `${currentResult.getName()} [${currentResult.getHostDisplaySize().toString()}]`
      let testResult = ''

      if (currentResult.getIsNew()) {
        testResult = markNewAsPassed ? 'Passed' : 'New'
      } else if (currentResult.isPassed()) {
        testResult = 'Passed'
      } else {
        const stepsFailed = currentResult.getMismatches() + currentResult.getMissing()
        testResult = `Failed ${stepsFailed} of ${currentResult.getSteps()}`
      }

      formattedString += `${testTitle} - ${testResult}\n`

      if (includeSubTests) {
        if (currentResult.getStepsInfo().length > 0) {
          for (let j = 0; j < currentResult.getStepsInfo().length; j += 1) {
            const currentStep = currentResult.getStepsInfo()[j]

            const subTestTitle = currentStep.getName()
            const subTestResult = currentStep.getIsDifferent() ? 'Passed' : 'Failed'
            formattedString += `\t> ${subTestTitle} - ${subTestResult}\n`
          }
        } else {
          formattedString += '\tNo steps exist for this test.\n'
        }
      }
    }

    formattedString += `See details at ${this._resultsList[0].getAppUrls().getBatch()}`

    return formattedString
  }

  /**
   * Creates a TAP representation of the tests results list in hierarchic format.
   *
   * @param {boolean} [includeSubTests=true] - If true, steps will be treated as "subtests". Default is true.
   * @param {boolean} [markNewAsPassed=false] - If true, new tests will be treated as "passed". Default is false.
   * @return {string} - A string which is the TAP representation of the results list.
   */
  asHierarchicTAPString(includeSubTests = true, markNewAsPassed = false) {
    if (this._resultsList.length === 0) {
      return ''
    }

    let tapString = `1..${this._resultsList.length}\n`

    for (let i = 0; i < this._resultsList.length; i += 1) {
      /** @type {TestResults} */ const currentResult = this._resultsList[i]
      const tapIndex = i + 1

      if (i > 0) {
        tapString += '#\n'
      }

      const name = `Test: '${currentResult.getName()}', Application: '${currentResult.getAppName()}'`

      if (currentResult.isPassed()) {
        tapString += `${OK} ${tapIndex} - [PASSED TEST] ${name}\n`
      } else if (currentResult.getIsNew()) {
        // Test did not pass (might also be a new test).
        // New test
        const newResult = markNewAsPassed ? OK : NOT_OK
        tapString += `${newResult} ${tapIndex} - [NEW TEST] ${name}\n`
      } else {
        // Failed / Aborted test.
        tapString += `${NOT_OK} ${tapIndex} - `
        if (currentResult.getIsAborted()) {
          tapString += `[ABORTED TEST] ${name}\n`
        } else {
          tapString += `[FAILED TEST] ${name}\n`
        }
        tapString += `#\tMismatches: ${currentResult.getMismatches()}\n`
      }

      const url =
        currentResult.getAppUrls() && currentResult.getAppUrls().getSession()
          ? currentResult.getAppUrls().getSession()
          : "No URL (session didn't start)."
      tapString += `#\tTest url: ${url}\n`
      tapString += `#\tBrowser: ${currentResult.getHostApp()}, Viewport: ${currentResult.getHostDisplaySize()}\n`

      if (includeSubTests) {
        if (currentResult.getStepsInfo().length > 0) {
          tapString += `\t1..${currentResult.getStepsInfo().length}\n`
          for (let j = 0; j < currentResult.getStepsInfo().length; j += 1) {
            const currentStep = currentResult.getStepsInfo()[j]
            tapString += '\t'
            tapString += currentStep.getIsDifferent() ? NOT_OK : OK
            tapString += ` '${currentStep.getName()}', URL: ${currentStep.getAppUrls().getStep()}\n`
          }
        } else {
          tapString += '\tNo steps exist for this test.\n'
        }
      }
    }

    return tapString
  }

  /**
   * Creates a TAP representation of the tests results list in which each steps are colored as success/fail.
   *
   * @param {boolean} [markNewAsPassed=false] - If true, new tests will be treated as "passed". Default is false.
   * @return {string} - A string which is the TAP representation of the results list.
   */
  asFlattenedTAPString(markNewAsPassed = false) {
    if (this._resultsList.length === 0) {
      return ''
    }

    let tapString = ''
    let stepsCounter = 0

    // We'll add the TAP plan at the beginning, after we calculate the total number of steps.
    for (let i = 0; i < this._resultsList.length; i += 1) {
      tapString += '#\n'

      /** @type {TestResults} */ const currentResult = this._resultsList[i]
      const tapIndex = i + 1

      const name = `Test: '${currentResult.getName()}', Application: '${currentResult.getAppName()}'`

      if (currentResult.isPassed()) {
        tapString += `# ${OK} ${tapIndex} - [PASSED TEST] ${name}\n`
      } else if (currentResult.getIsNew()) {
        // Test did not pass (might also be a new test).
        // New test
        const newResult = markNewAsPassed ? OK : NOT_OK
        tapString += `# ${newResult} ${tapIndex} - [NEW TEST] ${name}\n`
      } else {
        // Failed / Aborted test.
        tapString += `# ${NOT_OK} ${tapIndex} - `
        if (currentResult.getIsAborted()) {
          tapString += `[ABORTED TEST] ${name}\n`
        } else {
          tapString += `[FAILED TEST] ${name}\n`
        }
        tapString += `#\tMismatches: ${currentResult.getMismatches()}\n`
      }

      const url =
        currentResult.getAppUrls() && currentResult.getAppUrls().getSession()
          ? currentResult.getAppUrls().getSession()
          : "No URL (session didn't start)."

      tapString += `#\tTest url: ${url}\n`
      if (currentResult.getStepsInfo().length > 0) {
        for (let j = 0; j < currentResult.getStepsInfo().length; j += 1) {
          stepsCounter += 1
          const currentStep = currentResult.getStepsInfo()[j]
          tapString += currentStep.getIsDifferent() ? NOT_OK : OK
          tapString += ` ${stepsCounter} '${currentStep.getName()}', URL: ${currentStep.getAppUrls().getStep()}\n`
        }
      } else {
        tapString += '#\tNo steps exist for this test.\n'
      }
    }

    if (stepsCounter > 0) {
      tapString = `1..${stepsCounter}\n${tapString}`
    }

    return tapString
  }

  toXmlOutput({totalTime} = {}) {
    const suiteName = 'Eyes Test Suite'
    let output = `<?xml version="1.0" encoding="UTF-8" ?>`
    const testResults = this._resultsList
    output += `\n<testsuite name="${suiteName}" tests="${testResults.length}" time="${totalTime}">`
    testResults.forEach(result => {
      const duration = result.getDuration()
      output += `\n<testcase name="${result.getName()}"${duration ? ' time="' + duration + '"' : ''}>`
      if (result.getIsDifferent()) {
        output += `\n<failure>`
        output += `\nDifference found. See ${result.getAppUrls().getBatch()} for details.`
        output += `\n</failure>`
      } else if (result.getIsAborted()) {
        output += `\n<failure>`
        output += `\nTest aborted.`
        output += `\n</failure>`
      } else if (result.isError) {
        output += `\n<failure>`
        output += `\n${result.error.message}`
        output += `\n</failure>`
      }
      output += `\n</testcase>`
    })
    output += `\n</testsuite>`
    return output
  }

  /**
   * Creates a JSON representation of the tests results list
   *
   * @param {string|number} [space=null] - A String or Number object that's used to insert white space into the output JSON string for readability purposes.
   * @return {string} - A string which is the JSON representation of the results list.
   */
  toJsonOutput(space) {
    return JSON.stringify(this._resultsList, null, space)
  }
}

module.exports = TestResultsFormatter


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ./utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @enum
 * @typedef {string} TestResultsStatus
 */

const TestResultsStatuses = Enum('TestResultsStatus', {
  Passed: 'Passed',
  Unresolved: 'Unresolved',
  Failed: 'Failed',
})

module.exports = TestResultsStatuses


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandler.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandler.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")

class CorsIframeHandler {
  /**
   * @param {object} json
   * @param {string} origin
   */
  static blankCorsIframeSrc(json, origin) {
    if (json.tagName === 'IFRAME') {
      if (json.attributes.src) {
        const frameUrl = new URL(json.attributes.src, origin)
        if (origin !== frameUrl.origin) {
          json.attributes.src = ''
        }
      }
    }

    if (json.childNodes) {
      for (const child of json.childNodes) {
        CorsIframeHandler.blankCorsIframeSrc(child, origin)
      }
    }
  }

  /**
   * @param page
   * @param {string} page.url
   * @param {object[]} page.cdt
   * @param {object[]} page.frames
   * @return {object[]}
   */
  static blankCorsIframeSrcOfCdt({url, cdt, frames}) {
    const frameUrls = new Set(frames.map(frame => frame.url))
    cdt.map(node => {
      if (node.nodeName === 'IFRAME') {
        const srcAttr = node.attributes.find(attr => attr.name === 'src')
        const absoluteSrcAttr = srcAttr && new URL(srcAttr.value, url).href
        if (absoluteSrcAttr && !frameUrls.has(absoluteSrcAttr)) {
          srcAttr.value = ''
        }
      }
      return node
    })

    for (const frame of frames) {
      CorsIframeHandler.blankCorsIframeSrcOfCdt(frame)
    }

    return cdt
  }
}

module.exports = CorsIframeHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandles.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandles.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof CorsIframeHandles>} CorsIframeHandle
 */

const CorsIframeHandles = Enum('CorsIframeHandle', {
  /**
   * We should REMOVE the SRC attribute of the iframe
   * @type {'BLANK'}
   */
  BLANK: 'BLANK',
  /**
   * Not to do anything
   * @type {'KEEP'}
   */
  KEEP: 'KEEP',
  /**
   * @type {'SNAPSHOT'}
   */
  SNAPSHOT: 'SNAPSHOT',
})

module.exports = CorsIframeHandles


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/close/BatchClose.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/close/BatchClose.js ***!
  \************************************************************************/
/***/ ((module) => {

function makeBatchClose(closeBatch) {
  return function BatchClose() {
    const that = {
      batchIds: null,
      serverUrl: null,
      apiKey: null,
      proxy: null,
    }

    that.setBatchIds = function(batchIds) {
      that.batchIds = batchIds
      return that
    }

    that.setUrl = function(serverUrl) {
      that.serverUrl = serverUrl
      return that
    }

    that.setApiKey = function(apiKey) {
      that.apiKey = apiKey
      return that
    }

    that.setProxy = function(proxy) {
      that.proxy = proxy
      return that
    }

    that.close = async function() {
      const {batchIds, serverUrl, apiKey, proxy} = that
      await closeBatch({batchIds, serverUrl, apiKey, proxy})
    }

    return that
  }
}

module.exports = makeBatchClose


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/close/closeBatch.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/close/closeBatch.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const Logger = __webpack_require__(/*! ../logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")
const ServerConnector = __webpack_require__(/*! ../server/ServerConnector */ "./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js")
const Configuration = __webpack_require__(/*! ../config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")
const {presult} = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

async function closeBatch({batchIds, serverUrl, apiKey, proxy}) {
  if (!batchIds) throw new Error('no batchIds were set')
  const serverConnector = new ServerConnector({
    logger: new Logger(!!process.env.APPLITOOLS_SHOW_LOGS),
    configuration: new Configuration({serverUrl, apiKey, proxy}),
    getAgentId: () => '',
  })

  const promises = batchIds.map(batchId => serverConnector.deleteBatchSessions(batchId))
  const results = await Promise.all(promises.map(presult))
  const error = results.find(([err]) => !!err)
  if (error) throw error[0]
}

module.exports = closeBatch


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityGuidelinesVersion.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityGuidelinesVersion.js ***!
  \*********************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof AccessibilityGuidelinesVersions>} AccessibilityGuidelinesVersion
 */

/**
 * The spec version for which to check the image visual accessibility level.
 */
const AccessibilityGuidelinesVersions = Enum('AccessibilityGuidelinesVersion', {
  /** @type {'WCAG_2_0'} */
  WCAG_2_0: 'WCAG_2_0',
  /** @type {'WCAG_2_1'} */
  WCAG_2_1: 'WCAG_2_1',
})

module.exports = AccessibilityGuidelinesVersions


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityLevel.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityLevel.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof AccessibilityLevels>} AccessibilityLevel
 */

/**
 * The extent in which to check the image visual accessibility level.
 */
const AccessibilityLevels = Enum('AccessibilityLevel', {
  /**
   * Low accessibility level.
   * @type {'AA'}
   */
  AA: 'AA',
  /**
   * Highest accessibility level.
   * @type {'AAA'}
   */
  AAA: 'AAA',
})

module.exports = AccessibilityLevels


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityMatchSettings.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityMatchSettings.js ***!
  \*****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const AccessibilityRegionTypes = __webpack_require__(/*! ./AccessibilityRegionType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityRegionType.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")

/**
 * @typedef {import('./AccessibilityRegionType').AccessibilityRegionType} AccessibilityRegionType
 */

/**
 * Encapsulates Accessibility match settings.
 */
class AccessibilityMatchSettings {
  /**
   * @param {object} settings
   * @param {number} settings.left
   * @param {number} settings.top
   * @param {number} settings.width
   * @param {number} settings.height
   * @param {AccessibilityRegionType} [settings.type]
   */
  constructor({left, top, width, height, type, accessibilityType} = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }
    ArgumentGuard.isValidEnumValue(type, AccessibilityRegionTypes, false)

    this._left = left
    this._top = top
    this._width = width
    this._height = height
    this._type = type || accessibilityType
  }

  /**
   * @return {number}
   */
  getLeft() {
    return this._left
  }

  /**
   * @param {number} value
   */
  setLeft(value) {
    this._left = value
  }

  /**
   * @return {number}
   */
  getTop() {
    return this._top
  }

  /**
   * @param {number} value
   */
  setTop(value) {
    this._top = value
  }

  /**
   * @return {number}
   */
  getWidth() {
    return this._width
  }

  /**
   * @param {number} value
   */
  setWidth(value) {
    this._width = value
  }

  /**
   * @return {number}
   */
  getHeight() {
    return this._height
  }

  /**
   * @param {number} value
   */
  setHeight(value) {
    this._height = value
  }

  /**
   * @return {AccessibilityRegionType}
   */
  getType() {
    return this._type
  }

  /**
   * @param {AccessibilityRegionType} value
   */
  setType(value) {
    ArgumentGuard.isValidEnumValue(value, AccessibilityRegionTypes)
    this._type = value
  }

  /**
   * @return {Region}
   */
  getRegion() {
    return new Region(this._left, this._top, this._width, this._height)
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `AccessibilityMatchSettings { ${JSON.stringify(this)} }`
  }
}

module.exports = AccessibilityMatchSettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityRegionType.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityRegionType.js ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof AccessibilityRegionTypes>} AccessibilityRegionType
 */

/**
 * The type of accessibility for a region.
 */
const AccessibilityRegionTypes = Enum('AccessibilityRegionType', {
  /** @type {'IgnoreContrast'} */
  IgnoreContrast: 'IgnoreContrast',
  /** @type {'RegularText'} */
  RegularText: 'RegularText',
  /** @type {'LargeText'} */
  LargeText: 'LargeText',
  /** @type {'BoldText'} */
  BoldText: 'BoldText',
  /** @type {'GraphicalObject'} */
  GraphicalObject: 'GraphicalObject',
})

module.exports = AccessibilityRegionTypes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/BatchInfo.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/BatchInfo.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")

/**
 * @typedef BatchInfoObject
 * @prop {string} [id]
 * @prop {string} [name]
 * @prop {array} [properties]
 * @prop {Date|string} [startedAt]
 * @prop {string} [sequenceName]
 * @prop {boolean} [notifyOnCompletion]
 */

/**
 * A batch of tests.
 */
class BatchInfo {
  /**
   * Creates a new BatchInfo instance.
   * Alternatively, batch can be set via global variables `APPLITOOLS_BATCH_ID`, `APPLITOOLS_BATCH_NAME`, `APPLITOOLS_BATCH_SEQUENCE`.
   *
   * @signature `new BatchInfo()`
   *
   * @signature `new BatchInfo(batchInfo)`
   * @sigparam {BatchInfo} batchInfo - The BatchInfo instance to clone from.
   *
   * @signature `new BatchInfo(object)`
   * @sigparam {{id: (string|undefined), name: (string|undefined), startedAt: (Date|string|undefined), sequenceName: (string|undefined)}} object - The batch object to clone from.
   *
   * @signature `new BatchInfo(name, startedAt, id)`
   * @sigparam {string} name - Name of batch or {@code null} if anonymous.
   * @sigparam {Date|string} [startedAt] - Batch start time, defaults to the current time.
   * @sigparam {string} [id] - The ID of the existing batch, used to clone batch.
   *
   * @param {BatchInfo|BatchInfoObject|string} [varArg1] - The BatchInfo (or object) to clone from or the name of new batch.
   *   If no arguments given, new BatchInfo will be created with default or environment settings.
   * @param {string} [varArg2] - Batch start time, defaults to the current time.
   * @param {string} [varArg3] - ID of the batch, defaults is generated using GeneralUtils.guid().
   */
  constructor(varArg1, varArg2, varArg3) {
    if (varArg1 instanceof BatchInfo) {
      return new BatchInfo({
        id: varArg1.getId(),
        name: varArg1.getName(),
        startedAt: varArg1.getStartedAt(),
        sequenceName: varArg1.getSequenceName(),
        notifyOnCompletion: varArg1.getNotifyOnCompletion(),
        properties: varArg1.getProperties(),
        isCompleted: varArg1.getIsCompleted(),
        isGeneratedId: varArg1.getIsGeneratedId(),
      })
    }

    if (TypeUtils.isString(varArg1)) {
      return new BatchInfo({id: varArg3, name: varArg1, startedAt: varArg2})
    }

    let {id, name, properties, startedAt, sequenceName, notifyOnCompletion, isCompleted, isGeneratedId} = varArg1 || {}
    ArgumentGuard.isString(id, 'batchId', false)
    ArgumentGuard.isString(name, 'batchName', false)
    ArgumentGuard.isString(sequenceName, 'sequenceName', false)
    ArgumentGuard.isArray(properties, 'properties', false)
    ArgumentGuard.isBoolean(notifyOnCompletion, 'notifyOnCompletion', false)
    ArgumentGuard.isBoolean(isCompleted, 'isCompleted', false)
    ArgumentGuard.isBoolean(isGeneratedId, 'isGeneratedId', false)

    if (startedAt && !(startedAt instanceof Date)) {
      ArgumentGuard.isString(startedAt, 'startedAt', false)
      startedAt = DateTimeUtils.fromISO8601DateTime(startedAt)
    }

    this._id = id || GeneralUtils.getEnvValue('BATCH_ID')
    this._isGeneratedId = !!isGeneratedId || Boolean(this._id && this._id.startsWith('generated-'))
    if (!this._id) {
      this._generateAndSetId()
    }
    this._name = name || GeneralUtils.getEnvValue('BATCH_NAME')
    this._properties = properties || []
    this._startedAt = startedAt || new Date()
    this._sequenceName = sequenceName || GeneralUtils.getEnvValue('BATCH_SEQUENCE')
    this._notifyOnCompletion = notifyOnCompletion || GeneralUtils.getEnvValue('BATCH_NOTIFY', true) || false
    this._isCompleted = isCompleted || false
  }

  /**
   * @return {string} - The id of the current batch.
   */
  getId() {
    return this._id
  }

  getIsGeneratedId() {
    return this._isGeneratedId
  }

  setIsGeneratedId(value) {
    return (this._isGeneratedId = value)
  }

  /**
   * Sets a unique identifier for the batch. Sessions with batch info which includes the same ID will be grouped
   * together.
   *
   * @param {string} value - The batch's ID
   * @return {this}
   */
  setId(value) {
    ArgumentGuard.notNullOrEmpty(value, 'id')
    this._id = value
    return this
  }

  /**
   * @return {string} - The name of the batch or {@code null} if anonymous.
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} name - The name of the batch to use.
   * @return {this}
   */
  setName(name) {
    this._name = name
    return this
  }

  /**
   * @return {array} - custom batch properties
   */
  getProperties() {
    return this._properties
  }

  /**
   * @param {array} properties - The custom batch properties to set
   * @return {this}
   */
  setProperties(props) {
    this._properties = props
    return this
  }

  /**
   * @param {string} name - The custom batch property name
   * @param {string} value - The custom batch property value
   * @return {this}
   */
  addProperty(name, value) {
    this._properties.push({name, value})
    return this
  }

  /**
   * @return {Date} - The batch start date
   */
  getStartedAt() {
    return this._startedAt
  }

  /**
   * @param {string} startedAt
   * @return {this}
   */
  setStartedAt(startedAt) {
    this._startedAt = startedAt
    return this
  }

  /**
   * @return {string} - The name of the sequence.
   */
  getSequenceName() {
    return this._sequenceName
  }

  /**
   * @param {string} sequenceName - The Batch's sequence name.
   * @return {this}
   */
  setSequenceName(sequenceName) {
    this._sequenceName = sequenceName
    return this
  }

  /**
   * @return {boolean} - Indicate whether notification should be sent on this batch completion.
   */
  getNotifyOnCompletion() {
    return this._notifyOnCompletion
  }

  /**
   * @param {boolean} notifyOnCompletion - Indicate whether notification should be sent on this batch completion.
   * @return {this}
   */
  setNotifyOnCompletion(notifyOnCompletion) {
    this._notifyOnCompletion = notifyOnCompletion
    return this
  }

  /**
   * @return {boolean}
   */
  getIsCompleted() {
    return this._isCompleted
  }

  /**
   * @param {boolean} isCompleted
   * @return {this}
   */
  setIsCompleted(isCompleted) {
    this._isCompleted = isCompleted
    return this
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, ['_isCompleted', '_isGeneratedId'], {
      sequenceName: 'batchSequenceName',
    })
  }

  /**
   * @override
   */
  toString() {
    return `BatchInfo { ${JSON.stringify(this)} }`
  }

  _generateAndSetId() {
    this._isGeneratedId = true
    this._id = GeneralUtils.guid()
  }
}

module.exports = BatchInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof BrowserTypes>} BrowserType
 */

const BrowserTypes = Enum('BrowserType', {
  /** @type {'chrome'} */
  CHROME: 'chrome',
  /** @type {'firefox'} */
  FIREFOX: 'firefox',
  /** @type {'ie'} */
  IE_11: 'ie',
  /** @type {'ie10'} */
  IE_10: 'ie10',
  /** @type {'edge'} */
  EDGE: 'edge',
  /** @type {'edgechromium'} */
  EDGE_CHROMIUM: 'edgechromium',
  /** @type {'edgelegacy'} */
  EDGE_LEGACY: 'edgelegacy',
  /** @type {'safari'} */
  SAFARI: 'safari',
  /** @type {'safari-earlyaccess'} */
  SAFARI_EARLY_ACCESS: 'safari-earlyaccess',
  /** @type {'chrome-one-version-back'} */
  SAFARI_ONE_VERSION_BACK: 'safari-one-version-back',
  /** @type {'safari-two-versions-back'} */
  SAFARI_TWO_VERSIONS_BACK: 'safari-two-versions-back',
  /** @type {'edgechromium-one-version-back'} */
  CHROME_ONE_VERSION_BACK: 'chrome-one-version-back',
  /** @type {'chrome-two-versions-back'} */
  CHROME_TWO_VERSIONS_BACK: 'chrome-two-versions-back',
  /** @type {'firefox-one-version-back'} */
  FIREFOX_ONE_VERSION_BACK: 'firefox-one-version-back',
  /** @type {'firefox-two-versions-back'} */
  FIREFOX_TWO_VERSIONS_BACK: 'firefox-two-versions-back',
  /** @type {'safari-one-version-back'} */
  EDGE_CHROMIUM_ONE_VERSION_BACK: 'edgechromium-one-version-back',
  /** @type {'edgechromium-two-versions-back'} */
  EDGE_CHROMIUM_TWO_VERSIONS_BACK: 'edgechromium-two-versions-back',
})

module.exports = BrowserTypes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const BatchInfo = __webpack_require__(/*! ./BatchInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BatchInfo.js")
const PropertyData = __webpack_require__(/*! ./PropertyData */ "./node_modules/@applitools/eyes-sdk-core/lib/config/PropertyData.js")
const ProxySettings = __webpack_require__(/*! ./ProxySettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ProxySettings.js")
const BrowserType = __webpack_require__(/*! ./BrowserType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js")
const StitchModes = __webpack_require__(/*! ./StitchMode */ "./node_modules/@applitools/eyes-sdk-core/lib/config/StitchMode.js")
const ScreenOrientation = __webpack_require__(/*! ./ScreenOrientation */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ScreenOrientation.js")
const ImageMatchSettings = __webpack_require__(/*! ./ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js")
const RectangleSize = __webpack_require__(/*! ../geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * @typedef {import('./AccessibilityLevel').AccessibilityLevel} AccessibilityLevel
 * @typedef {import('./AccessibilityGuidelinesVersion').AccessibilityGuidelinesVersion} AccessibilityGuidelinesVersion
 * @typedef {import('./StitchMode').StitchMode} StitchMode
 * @typedef {import('./SessionType').SessionType} SessionType
 * @typedef {import('./ProxySettings')} ProxySettings
 * @typedef {import('./ProxySettings').PlainProxySettings} PlainProxySettings
 * @typedef {import('./ImageMatchSettings')} ImageMatchSettings
 * @typedef {import('../geometry/RectangleSize')} RectangleSize
 * @typedef {import('../geometry/RectangleSize').PlainRectangleSize} PlainRectangleSize
 */

/**
 * @typedef {{level: AccessibilityLevel, guidelinesVersion: AccessibilityGuidelinesVersion}} AccessibilitySettings
 */
/**
 * @typedef {{width: number, height: number, name: (BrowserType|undefined)}} DesktopBrowserInfo
 */
/**
 * @typedef {{deviceName: DeviceName, screenOrientation: (ScreenOrientation|undefined)}} EmulationInfo
 */
/**
 * @typedef {{chromeEmulationInfo: EmulationInfo}} ChromeEmulationInfo
 */
/**
 * @typedef {{iosDeviceInfo: {deviceName: IosDeviceName, screenOrientation: (ScreenOrientation|undefined)}}} IosDeviceInfo
 */
/**
 * @typedef {(DesktopBrowserInfo|EmulationInfo|ChromeEmulationInfo|IosDeviceInfo)} RenderInfo
 */

const MIN_MATCH_TIMEOUT = 500

const DEFAULT_VALUES = {
  isDisabled: false,
  matchTimeout: 2000, // ms
  serverUrl: 'https://eyesapi.applitools.com',
  compareWithParentBranch: false,
  saveFailedTests: false,
  saveNewTests: true,
  ignoreBaseline: false,
  sendDom: true,
  dontCloseBatches: false,

  // classic (selenium)
  waitBeforeScreenshots: 100, // ms
  stitchMode: StitchModes.SCROLL,
  hideScrollbars: true,
  hideCaret: true,
  stitchOverlap: 50, // px

  // visual-grid
  concurrentSessions: 1,
  isThrowExceptionOn: false,
}

/**
 * @typedef PlainConfiguration
 * @prop {boolean} showLogs
 *
 * @prop {string} appName
 * @prop {string} testName
 * @prop {string} displayName
 *
 * @prop {string} serverUrl
 * @prop {ProxySettings|PlainProxySettings} proxySettings
 * @prop {number} connectionTimeout
 * @prop {string} apiKey
 *
 * @prop {boolean} isDisabled
 * @prop {SessionType} sessionType
 * @prop {boolean} removeSession
 * @prop {string} agentId
 * @prop {PropertyData[]} properties
 * @prop {RectangleSize|PlainRectangleSize} viewportSize
 * @prop {BatchInfo} batch
 * @prop {number} matchTimeout
 * @prop {ImageMatchSettings} defaultMatchSettings
 *
 * @prop {string} baselineEnvName
 * @prop {string} environmentName
 * @prop {string} baselineName
 * @prop {string} parentBranchName
 * @prop {string} baselineBranchName
 * @prop {boolean} compareWithParentBranch
 *
 * @prop {boolean} saveFailedTests
 * @prop {boolean} saveNewTests
 * @prop {boolean} ignoreBaseline
 * @prop {boolean} saveDiffs
 * @prop {boolean} sendDom
 *
 * @prop {string} hostApp
 * @prop {string} hostOS
 * @prop {string} hostAppInfo
 * @prop {string} hostOSInfo
 * @prop {string} deviceInfo
 */

/**
 * @typedef PlainConfigurationClassic
 * @prop {boolean} forceFullPageScreenshot
 * @prop {number} waitBeforeScreenshots
 * @prop {StitchMode} stitchMode
 * @prop {number} stitchOverlap
 * @prop {boolean} hideScrollbars
 * @prop {boolean} hideCaret
 */

/**
 * @typedef PlainConfigurationVisualGrid
 * @prop {number} concurrentSessions
 * @prop {boolean} isThrowExceptionOn
 * @prop {RenderInfo[]} browsersInfo
 * @prop {boolean} dontCloseBatches
 */

class Configuration {
  /**
   * @param {Configuration|object} [configuration]
   */
  constructor(configuration) {
    /** @private @type {boolean} */
    this._showLogs = undefined

    /** @type {string} */
    this._appName = undefined
    /** @type {string} */
    this._testName = undefined
    /** @type {string} */
    this._displayName = undefined
    /** @type {boolean} */
    this._isDisabled = undefined
    /** @type {number} */
    this._matchTimeout = undefined
    /** @type {SessionType} */
    this._sessionType = undefined
    /** @type {RectangleSize} */
    this._viewportSize = undefined
    /** @type {string} */
    this._agentId = undefined

    /** @type {string} */
    this._apiKey = undefined
    /** @type {string} */
    this._serverUrl = undefined
    /** @type {ProxySettings} */
    this._proxySettings = undefined
    /** @type {number} */
    this._connectionTimeout = undefined
    /** @type {boolean} */
    this._removeSession = undefined

    /** @type {BatchInfo} */
    this._batch = undefined

    /** @type {PropertyData[]} */
    this._properties = []

    /** @type {string} */
    this._baselineEnvName = undefined
    /** @type {string} */
    this._environmentName = undefined

    /** @type {string} */
    this._branchName = undefined
    /** @type {string} */
    this._parentBranchName = undefined
    /** @type {string} */
    this._baselineBranchName = undefined
    /** @type {boolean} */
    this._compareWithParentBranch = undefined

    /** @type {boolean} */
    this._saveFailedTests = undefined
    /** @type {boolean} */
    this._saveNewTests = undefined
    /** @type {boolean} */
    this._ignoreBaseline = undefined
    /** @type {boolean} */
    this._saveDiffs = undefined
    /** @type {boolean} */
    this._sendDom = undefined

    /** @type {string} */
    this._hostApp = undefined
    /** @type {string} */
    this._hostOS = undefined
    /** @type {string} */
    this._hostAppInfo = undefined
    /** @type {string} */
    this._hostOSInfo = undefined
    /** @type {string} */
    this._deviceInfo = undefined

    /** @type {ImageMatchSettings} */
    this._defaultMatchSettings = new ImageMatchSettings(configuration ? configuration.defaultMatchSettings : undefined)

    // classic (selenium)
    /** @type {boolean} */
    this._forceFullPageScreenshot = undefined
    /** @type {number} */
    this._waitBeforeScreenshots = undefined
    /** @type {StitchMode} */
    this._stitchMode = undefined
    /** @type {boolean} */
    this._hideScrollbars = undefined
    /** @type {boolean} */
    this._hideCaret = undefined
    /** @type {number} */
    this._stitchOverlap = undefined

    // visual grid
    /** @type {number} */
    this._concurrentSessions = undefined
    /** @type {boolean} */
    this._isThrowExceptionOn = undefined
    /** @type {RenderInfo[]} */
    this._browsersInfo = undefined

    /** @type {boolean} */
    this._dontCloseBatches = undefined

    /** @type {Object} */
    this._visualGridOptions = undefined

    /** @type {number[]|boolean} */
    this._layoutBreakpoints = undefined

    /** @type {boolean} */
    this._disableBrowserFetching = undefined

    /** @type {number} */
    this._abortIdleTestTimeout = undefined

    /** @type {boolean} */
    this._ignoreGitMergeBase = undefined

    if (configuration) {
      this.mergeConfig(configuration)
    }
  }

  /**
   * @return {boolean}
   */
  getShowLogs() {
    return this._showLogs
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setShowLogs(value) {
    ArgumentGuard.isBoolean(value, 'showLogs')
    this._showLogs = value
    return this
  }

  /**
   * @return {boolean}
   */
  getSaveDebugData() {
    GeneralUtils.deprecationWarning({deprecatedThing: 'saveDebugData', isDead: true})
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setSaveDebugData(_value) {
    GeneralUtils.deprecationWarning({deprecatedThing: 'saveDebugData', isDead: true})
    return this
  }

  /**
   * @return {string} - The currently set API key or {@code null} if no key is set.
   */
  getApiKey() {
    return TypeUtils.getOrDefault(this._apiKey, GeneralUtils.getEnvValue('API_KEY'))
  }

  /**
   * Sets the API key of your applitools Eyes account.
   *
   * @param {string} value - The api key to be used.
   * @return {this}
   */
  setApiKey(value) {
    ArgumentGuard.isString(value, 'apiKey')
    ArgumentGuard.alphanumeric(value, 'apiKey')
    this._apiKey = value
    return this
  }

  /**
   * @return {string} - The URI of the eyes server.
   */
  getServerUrl() {
    return TypeUtils.getOrDefault(this._serverUrl, GeneralUtils.getEnvValue('SERVER_URL') || DEFAULT_VALUES.serverUrl)
  }

  /**
   * Sets the current server URL used by the rest client.
   *
   * @param {string} value - The URI of the rest server, or {@code null} to use the default server.
   * @return {this}
   */
  setServerUrl(value) {
    ArgumentGuard.isString(value, 'serverUrl', false)
    this._serverUrl = value
    return this
  }

  /**
   * @return {ProxySettings} - The current proxy settings, or {@code undefined} if no proxy is set.
   */
  getProxy() {
    return this._proxySettings
  }

  /**
   * Sets the proxy settings to be used by the rest client.
   *
   * @param {ProxySettings|PlainProxySettings|string|boolean} value - The ProxySettings object or proxy url to be used.
   *   Use {@code false} to disable proxy (even if it set via env variables). Use {@code null} to reset proxy settings.
   * @return {this}
   */
  setProxy(value) {
    if (TypeUtils.isNull(value)) {
      this._proxySettings = undefined
    } else if (value === false || TypeUtils.isString(value)) {
      this._proxySettings = new ProxySettings(value)
    } else if (value instanceof ProxySettings) {
      this._proxySettings = value
    } else {
      this._proxySettings = new ProxySettings(value.url, value.username, value.password, value.isHttpOnly)
    }
    return this
  }

  /**
   * @return {number} - The timeout for web requests (in milliseconds).
   */
  getConnectionTimeout() {
    return this._connectionTimeout
  }

  /**
   * Sets the connect and read timeouts for web requests.
   *
   * @param {number} value - Connect/Read timeout in milliseconds. 0 equals infinity.
   * @return {this}
   */
  setConnectionTimeout(value) {
    ArgumentGuard.greaterThanOrEqualToZero(value, 'connectionTimeout', true)
    this._connectionTimeout = value
    return this
  }

  /**
   * @return {boolean} - Whether sessions are removed immediately after they are finished.
   */
  getRemoveSession() {
    return this._removeSession
  }

  /**
   * Whether sessions are removed immediately after they are finished.
   *
   * @param {boolean} value
   * @return {this}
   */
  setRemoveSession(value) {
    ArgumentGuard.isBoolean(value, 'removeSession')
    this._removeSession = value
    return this
  }

  /**
   * @return {boolean} - The currently compareWithParentBranch value
   */
  getCompareWithParentBranch() {
    return TypeUtils.getOrDefault(this._compareWithParentBranch, DEFAULT_VALUES.compareWithParentBranch)
  }

  /**
   * @param {boolean} value - New compareWithParentBranch value, default is false
   * @return {this}
   */
  setCompareWithParentBranch(value) {
    ArgumentGuard.isBoolean(value, 'compareWithParentBranch')
    this._compareWithParentBranch = value
    return this
  }

  /**
   * @return {boolean} - The currently ignoreBaseline value
   */
  getIgnoreBaseline() {
    return TypeUtils.getOrDefault(this._ignoreBaseline, DEFAULT_VALUES.ignoreBaseline)
  }

  /**
   * @param {boolean} value - New ignoreBaseline value, default is false
   * @return {this}
   */
  setIgnoreBaseline(value) {
    ArgumentGuard.isBoolean(value, 'ignoreBaseline')
    this._ignoreBaseline = value
    return this
  }

  /**
   * @return {boolean} - True if new tests are saved by default.
   */
  getSaveNewTests() {
    return TypeUtils.getOrDefault(this._saveNewTests, DEFAULT_VALUES.saveNewTests)
  }

  /**
   * Used for automatic save of a test run. New tests are automatically saved by default.
   *
   * @param {boolean} value - True if new tests should be saved by default. False otherwise.
   * @return {this}
   */
  setSaveNewTests(value) {
    ArgumentGuard.isBoolean(value, 'saveNewTests')
    this._saveNewTests = value
    return this
  }

  /**
   * @return {boolean} - True if failed tests are saved by default.
   */
  getSaveFailedTests() {
    return TypeUtils.getOrDefault(this._saveFailedTests, DEFAULT_VALUES.saveFailedTests)
  }

  /**
   * Set whether or not failed tests are saved by default.
   *
   * @param {boolean} value - True if failed tests should be saved by default, false otherwise.
   * @return {this}
   */
  setSaveFailedTests(value) {
    ArgumentGuard.isBoolean(value, 'saveFailedTests')
    this._saveFailedTests = value
    return this
  }

  /**
   * @return {number} - The maximum time in ms {@link #checkWindowBase(RegionProvider, string, boolean, number)} waits
   *   for a match.
   */
  getMatchTimeout() {
    return TypeUtils.getOrDefault(this._matchTimeout, DEFAULT_VALUES.matchTimeout)
  }

  /**
   * Sets the maximum time (in ms) a match operation tries to perform a match.
   * @param {number} value - Total number of ms to wait for a match.
   * @return {this}
   */
  setMatchTimeout(value) {
    ArgumentGuard.greaterThanOrEqualToZero(value, 'matchTimeout', true)

    if (value !== 0 && MIN_MATCH_TIMEOUT > value) {
      throw new TypeError(`Match timeout must be set in milliseconds, and must be > ${MIN_MATCH_TIMEOUT}`)
    }

    this._matchTimeout = value
    return this
  }

  /**
   * @return {boolean} - Whether eyes is disabled.
   */
  getIsDisabled() {
    return TypeUtils.getOrDefault(this._isDisabled, DEFAULT_VALUES.isDisabled)
  }

  /**
   * @param {boolean} value - If true, all interactions with this API will be silently ignored.
   * @return {this}
   */
  setIsDisabled(value) {
    ArgumentGuard.isBoolean(value, 'isDisabled', false)
    this._isDisabled = value
    return this
  }

  /**
   * @return {BatchInfo}
   */
  getBatch() {
    if (this._batch === undefined) {
      this._batch = new BatchInfo()
    }

    return this._batch
  }

  /**
   * Sets the batch in which context future tests will run or {@code null} if tests are to run standalone.
   *
   * @param {BatchInfo|BatchInfoObject} value
   * @return {this}
   */
  setBatch(value) {
    this._batch = value ? new BatchInfo(value) : undefined
    return this
  }

  /**
   * @return {PropertyData[]}
   */
  getProperties() {
    return this._properties
  }

  /**
   * @signature `setProperties(properties)`
   * @sigparam {PropertyData[]} properties - A list of PropertyData instances
   *
   * @signature `setProperties(propertiesObj)`
   * @sigparam {PropertyDataObject[]} propertiesObj - A list of property data objects
   *
   * @param {PropertyData[]|PropertyDataObject[]} value
   * @return {this}
   */
  setProperties(value) {
    ArgumentGuard.isArray(value, 'properties')

    for (const data of value) {
      this._properties.push(new PropertyData(data))
    }
    return this
  }

  /**
   * Adds a property to be sent to the server.
   *
   * @signature `addProperty(property)`
   * @sigparam {PropertyData|PropertyDataObject} property - The name and value are taken from the object passed
   *
   * @signature`addProperty(propertyName, propertyValue)`
   * @sigparam {string} propertyName - The name of the property
   * @sigparam {string} propertyValue - The value of the property
   *
   * @param {PropertyData|string} propertyOrName - The property name or PropertyData object.
   * @param {string} [propertyValue] - The property value.
   * @return {this}
   */
  addProperty(propertyOrName, propertyValue) {
    this._properties.push(new PropertyData(propertyOrName, propertyValue))
    return this
  }

  /**
   * @return {string}
   */
  getBranchName() {
    return TypeUtils.getOrDefault(this._branchName, GeneralUtils.getEnvValue('BRANCH'))
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setBranchName(value) {
    ArgumentGuard.isString(value, 'branchName')
    this._branchName = value
    return this
  }

  /**
   * @return {string}
   */
  getAgentId() {
    return this._agentId
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setAgentId(value) {
    ArgumentGuard.isString(value, 'agentId')
    this._agentId = value
    return this
  }

  /**
   * @return {string}
   */
  getParentBranchName() {
    return TypeUtils.getOrDefault(this._parentBranchName, GeneralUtils.getEnvValue('PARENT_BRANCH'))
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setParentBranchName(value) {
    ArgumentGuard.isString(value, 'parentBranchName')
    this._parentBranchName = value
    return this
  }

  /**
   * @return {string}
   */
  getBaselineBranchName() {
    return TypeUtils.getOrDefault(this._baselineBranchName, GeneralUtils.getEnvValue('BASELINE_BRANCH'))
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setBaselineBranchName(value) {
    ArgumentGuard.isString(value, 'baselineBranchName')
    this._baselineBranchName = value
    return this
  }

  /**
   * @return {string}
   */
  getBaselineEnvName() {
    return this._baselineEnvName
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setBaselineEnvName(value) {
    ArgumentGuard.isString(value, 'baselineEnvName', false)
    this._baselineEnvName = value ? value.trim() : undefined
    return this
  }

  /**
   * @return {string}
   */
  getEnvironmentName() {
    return this._environmentName
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setEnvironmentName(value) {
    ArgumentGuard.isString(value, 'environmentName', false)
    this._environmentName = value ? value.trim() : undefined
    return this
  }

  /**
   * @return {boolean}
   */
  getSaveDiffs() {
    return this._saveDiffs
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setSaveDiffs(value) {
    ArgumentGuard.isBoolean(value, 'saveDiffs')
    this._saveDiffs = value
    return this
  }

  /**
   * @return {boolean}
   */
  getSendDom() {
    return TypeUtils.getOrDefault(this._sendDom, DEFAULT_VALUES.sendDom)
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setSendDom(value) {
    ArgumentGuard.isBoolean(value, 'sendDom')
    this._sendDom = value
    return this
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostApp() {
    return this._hostApp
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   */
  setHostApp(value) {
    if (TypeUtils.isNull(value)) {
      this._hostApp = undefined
    } else {
      this._hostApp = value.trim()
    }
    return this
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostOS() {
    return this._hostOS
  }

  /**
   * Sets the host OS name - overrides the one in the agent string.
   *
   * @param {string} value - The host OS running the AUT.
   */
  setHostOS(value) {
    if (TypeUtils.isNull(value)) {
      this._hostOS = undefined
    } else {
      this._hostOS = value.trim()
    }
    return this
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostAppInfo() {
    return this._hostAppInfo
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   */
  setHostAppInfo(value) {
    if (TypeUtils.isNull(value)) {
      this._hostAppInfo = undefined
    } else {
      this._hostAppInfo = value.trim()
    }
    return this
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostOSInfo() {
    return this._hostOSInfo
  }

  /**
   * Sets the host OS name - overrides the one in the agent string.
   *
   * @param {string} value - The host OS running the AUT.
   */
  setHostOSInfo(value) {
    if (TypeUtils.isNull(value)) {
      this._hostOSInfo = undefined
    } else {
      this._hostOSInfo = value.trim()
    }
    return this
  }

  /**
   * @return {string} - The application name running the AUT.
   */
  getDeviceInfo() {
    return this._deviceInfo
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   * @return {this}
   */
  setDeviceInfo(value) {
    if (TypeUtils.isNull(value)) {
      this._deviceInfo = undefined
    } else {
      this._deviceInfo = value.trim()
    }
    return this
  }

  /**
   * @return {string}
   */
  getAppName() {
    return this._appName
  }

  /**
   * The default app name if no current name was provided. If this is {@code null} then there is no default appName.
   *
   * @param {string} value
   * @return {this}
   */
  setAppName(value) {
    ArgumentGuard.isString(value, 'appName', false)
    this._appName = value
    return this
  }

  /**
   * @return {string}
   */
  getTestName() {
    return this._testName
  }

  /**
   * @param {string} value
   * @return {this}
   */
  setTestName(value) {
    ArgumentGuard.isString(value, 'testName', false)
    this._testName = value
    return this
  }

  /**
   * @return {string} - The display name of the currently running test.
   */
  getDisplayName() {
    return this._displayName
  }

  /**
   * @param {string} value - The display name of the currently running test.
   * @return {this}
   */
  setDisplayName(value) {
    ArgumentGuard.isString(value, 'displayName', false)
    this._displayName = value
    return this
  }

  /**
   * @return {RectangleSize}
   */
  getViewportSize() {
    return this._viewportSize
  }

  /**
   * @param {RectangleSize|PlainRectangleSize} value
   * @return {this}
   */
  setViewportSize(value) {
    if (TypeUtils.isNull(value)) {
      this._viewportSize = undefined
    } else {
      this._viewportSize = new RectangleSize(value)
    }
    return this
  }

  /**
   * @return {SessionType}
   */
  getSessionType() {
    return this._sessionType
  }

  /**
   * @param {SessionType} value
   * @return {this}
   */
  setSessionType(value) {
    this._sessionType = value
    return this
  }

  /**
   * @return {ImageMatchSettings} - The match settings used for the session.
   */
  getDefaultMatchSettings() {
    return this._defaultMatchSettings
  }

  /**
   * Updates the match settings to be used for the session.
   *
   * @param {ImageMatchSettings|object} value - The match settings to be used for the session.
   * @return {this}
   */
  setDefaultMatchSettings(value) {
    ArgumentGuard.notNull(value, 'defaultMatchSettings')
    this._defaultMatchSettings = new ImageMatchSettings(value)
    return this
  }

  /**
   * @return {MatchLevel} - The test-wide match level.
   */
  getMatchLevel() {
    return this._defaultMatchSettings.getMatchLevel()
  }

  /**
   * The test-wide match level to use when checking application screenshot with the expected output.
   *
   * @param {MatchLevel} value - The test-wide match level to use when checking application screenshot with the
   *   expected output.
   * @return {this}
   */
  setMatchLevel(value) {
    this._defaultMatchSettings.setMatchLevel(value)
    return this
  }

  /**
   * @return {AccessibilitySettings} - The test-wide accessibility settings.
   */
  getAccessibilityValidation() {
    return this._defaultMatchSettings.getAccessibilitySettings()
  }

  /**
   * The test-wide accessibility settings to use when checking application screenshot.
   *
   * @param {AccessibilitySettings} value - The test-wide accessibility settings to use when checking application screenshot.
   * @return {this}
   */
  setAccessibilityValidation(value) {
    this._defaultMatchSettings.setAccessibilitySettings(value)
    return this
  }

  /**
   * @return {boolean} - The test-wide useDom to use in match requests.
   */
  getUseDom() {
    return this._defaultMatchSettings.getUseDom()
  }

  /**
   * The test-wide useDom to use.
   *
   * @param {boolean} value - The test-wide useDom to use in match requests.
   * @return {this}
   */
  setUseDom(value) {
    this._defaultMatchSettings.setUseDom(value)
    return this
  }

  /**
   * @return {boolean} - The test-wide enablePatterns to use in match requests.
   */
  getEnablePatterns() {
    return this._defaultMatchSettings.getEnablePatterns()
  }

  /**
   * The test-wide enablePatterns to use.
   *
   * @param {boolean} value - The test-wide enablePatterns to use in match requests.
   * @return {this}
   */
  setEnablePatterns(value) {
    this._defaultMatchSettings.setEnablePatterns(value)
    return this
  }

  /**
   * @return {boolean} - The test-wide ignoreDisplacements to use in match requests.
   */
  getIgnoreDisplacements() {
    return this._defaultMatchSettings.getIgnoreDisplacements()
  }

  /**
   * The test-wide ignoreDisplacements to use.
   *
   * @param {boolean} value - The test-wide ignoreDisplacements to use in match requests.
   * @return {this}
   */
  setIgnoreDisplacements(value) {
    this._defaultMatchSettings.setIgnoreDisplacements(value)
    return this
  }

  /**
   * @return {boolean} - Whether to ignore or the blinking caret or not when comparing images.
   */
  getIgnoreCaret() {
    return this._defaultMatchSettings.getIgnoreCaret()
  }

  /**
   * Sets the ignore blinking caret value.
   *
   * @param {boolean} value - The ignore value.
   * @return {this}
   */
  setIgnoreCaret(value) {
    this._defaultMatchSettings.setIgnoreCaret(value)
    return this
  }

  /* ------------ Classic (Selenium) properties ------------ */

  /**
   * @return {boolean} - Whether Eyes should force a full page screenshot.
   */
  getForceFullPageScreenshot() {
    return this._forceFullPageScreenshot
  }

  /**
   * Forces a full page screenshot (by scrolling and stitching) if the browser only supports viewport screenshots).
   *
   * @param {boolean} value - Whether to force a full page screenshot or not.
   * @return {this}
   */
  setForceFullPageScreenshot(value) {
    this._forceFullPageScreenshot = value
    return this
  }

  /**
   * @return {number} - The time to wait just before taking a screenshot.
   */
  getWaitBeforeScreenshots() {
    return TypeUtils.getOrDefault(this._waitBeforeScreenshots, DEFAULT_VALUES.waitBeforeScreenshots)
  }

  /**
   * Sets the time to wait just before taking a screenshot (e.g., to allow positioning to stabilize when performing a
   * full page stitching).
   *
   * @param {number} value - The time to wait (Milliseconds). Values smaller or equal to 0, will cause the
   *   default value to be used.
   * @return {this}
   */
  setWaitBeforeScreenshots(value) {
    if (value <= 0) {
      this._waitBeforeScreenshots = undefined
    } else {
      this._waitBeforeScreenshots = value
    }
    return this
  }

  /**
   * @return {StitchMode} - The current stitch mode settings.
   */
  getStitchMode() {
    return TypeUtils.getOrDefault(this._stitchMode, DEFAULT_VALUES.stitchMode)
  }

  /**
   * Set the type of stitching used for full page screenshots. When the page includes fixed position header/sidebar,
   * use {@link StitchMode#CSS}. Default is {@link StitchMode#SCROLL}.
   *
   * @param {StitchMode} value - The stitch mode to set.
   * @return {this}
   */
  setStitchMode(value) {
    this._stitchMode = value
    return this
  }

  /**
   * @return {boolean} - Whether or not scrollbars are hidden when taking screenshots.
   */
  getHideScrollbars() {
    return TypeUtils.getOrDefault(this._hideScrollbars, DEFAULT_VALUES.hideScrollbars)
  }

  /**
   * Hide the scrollbars when taking screenshots.
   *
   * @param {boolean} value - Whether to hide the scrollbars or not.
   * @return {this}
   */
  setHideScrollbars(value) {
    this._hideScrollbars = value
    return this
  }

  /**
   * @return {boolean}
   */
  getHideCaret() {
    return TypeUtils.getOrDefault(this._hideCaret, DEFAULT_VALUES.hideCaret)
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setHideCaret(value) {
    this._hideCaret = value
    return this
  }

  /**
   * @return {number} - Returns the stitching overlap in pixels.
   */
  getStitchOverlap() {
    return TypeUtils.getOrDefault(this._stitchOverlap, DEFAULT_VALUES.stitchOverlap)
  }

  /**
   * Sets the stitch overlap in pixels.
   *
   * @param {number} value - The width (in pixels) of the overlap.
   * @return {this}
   */
  setStitchOverlap(value) {
    this._stitchOverlap = value
    return this
  }

  /**
   * @return {boolean}
   */
  getDontCloseBatches() {
    return TypeUtils.getOrDefault(
      this._dontCloseBatches,
      GeneralUtils.getEnvValue('DONT_CLOSE_BATCHES', true) || DEFAULT_VALUES.dontCloseBatches,
    )
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setDontCloseBatches(value) {
    ArgumentGuard.isBoolean(value, 'dontCloseBatches')
    this._dontCloseBatches = value
    return this
  }

  /* ------------ Visual Grid properties ------------ */

  /**
   * @deprecated
   * @return {number}
   */
  getConcurrentSessions() {
    return TypeUtils.getOrDefault(this._concurrentSessions, DEFAULT_VALUES.concurrentSessions)
  }

  /**
   * @deprecated
   * @param {number} value
   * @return {this}
   */
  setConcurrentSessions(value) {
    this._concurrentSessions = value
    return this
  }

  /**
   * @return {boolean}
   */
  getIsThrowExceptionOn() {
    return TypeUtils.getOrDefault(this._isThrowExceptionOn, DEFAULT_VALUES.isThrowExceptionOn)
  }

  /**
   * @param {boolean} value
   * @return {this}
   */
  setIsThrowExceptionOn(value) {
    this._isThrowExceptionOn = value
    return this
  }

  /**
   * @return {RenderInfo[]|undefined}
   */
  getBrowsersInfo() {
    return this._browsersInfo
  }

  /**
   * @param {RenderInfo[]} value
   * @return {this}
   */
  setBrowsersInfo(value) {
    if (!this._browsersInfo) {
      this._browsersInfo = []
    }
    ArgumentGuard.isArray(value, 'properties')

    for (const data of value) {
      this._browsersInfo.push(data)
    }
    return this
  }

  /**
   * @param {...RenderInfo} browsersInfo
   * @return {this}
   */
  addBrowsers(...browsersInfo) {
    for (const [i, b] of browsersInfo.entries()) {
      ArgumentGuard.isPlainObject(b, `addBrowsers( arg${i} )`)
    }

    if (!this._browsersInfo) {
      this._browsersInfo = []
    }
    this._browsersInfo.push(...browsersInfo)
    return this
  }

  /**
   * @param {number|RenderInfo} widthOrBrowserInfo
   * @param {number} [height]
   * @param {BrowserType} [browserType]
   * @return {this}
   */
  addBrowser(widthOrBrowserInfo, height, browserType = BrowserType.CHROME) {
    if (arguments.length === 1) {
      this.addBrowsers(widthOrBrowserInfo)
    } else {
      const browserInfo = {width: widthOrBrowserInfo, height, name: browserType}
      this.addBrowsers(browserInfo)
    }
    return this
  }

  /**
   * @param {DeviceName} deviceName
   * @param {ScreenOrientation} [screenOrientation=ScreenOrientation.PORTRAIT]
   * @return {this}
   */
  addDeviceEmulation(deviceName, screenOrientation = ScreenOrientation.PORTRAIT) {
    const deviceInfo = {
      deviceName,
      screenOrientation,
    }

    if (!this._browsersInfo) {
      this._browsersInfo = []
    }

    this._browsersInfo.push(deviceInfo)
    return this
  }

  getVisualGridOptions() {
    return this._visualGridOptions
  }

  setVisualGridOptions(value) {
    this._visualGridOptions = value
    return this
  }

  setVisualGridOption(key, value) {
    if (!this._visualGridOptions) {
      this._visualGridOptions = {}
    }
    this._visualGridOptions[key] = value
    return this
  }

  getLayoutBreakpoints() {
    return this._layoutBreakpoints
  }

  setLayoutBreakpoints(breakpoints) {
    ArgumentGuard.notNull(breakpoints, 'breakpoints')
    this._layoutBreakpoints = breakpoints
    return this
  }

  getDisableBrowserFetching() {
    return this._disableBrowserFetching
  }

  setDisableBrowserFetching(value) {
    this._disableBrowserFetching = value
    return this
  }

  getAbortIdleTestTimeout() {
    return this._abortIdleTestTimeout
  }

  setAbortIdleTestTimeout(value) {
    ArgumentGuard.isNumber(value, 'abortIdleTestTimeout')
    this._abortIdleTestTimeout = value
    return this
  }

  getIgnoreGitMergeBase() {
    return this._ignoreGitMergeBase
  }

  setIgnoreGitMergeBase(input) {
    ArgumentGuard.isBoolean(input, 'ignoreGitMergeBase')
    this._ignoreGitMergeBase = input
    return this
  }

  /**
   * @param {Configuration|object} other
   */
  mergeConfig(other) {
    Object.keys(other).forEach(prop => {
      let privateProp = prop
      if (prop === 'proxy') {
        privateProp = '_proxySettings'
      } else if (!prop.startsWith('_')) {
        privateProp = `_${prop}`
      }

      if (Object.prototype.hasOwnProperty.call(this, privateProp) && other[prop] !== undefined) {
        const publicProp = prop.startsWith('_') ? prop.slice(1) : prop
        const setterName = `set${publicProp.charAt(0).toUpperCase()}${publicProp.slice(1)}`
        if (typeof this[setterName] === 'function') {
          this[setterName](other[prop])
        } else {
          this[privateProp] = other[prop]
        }
      }
    })
  }

  /**
   * @return {object}
   */
  toOpenEyesConfiguration() {
    return {
      appName: this.getAppName(),
      testName: this.getTestName(),
      displayName: this.getDisplayName(),
      browser: this.getBrowsersInfo(),
      properties: this.getProperties(),
      batch: this.getBatch(),
      baselineBranchName: this.getBaselineBranchName(),
      baselineEnvName: this.getBaselineEnvName(),
      baselineName: this.getBaselineEnvName(),
      envName: this.getEnvironmentName(),
      branchName: this.getBranchName(),
      saveDiffs: this.getSaveDiffs(),
      saveFailedTests: this.getSaveFailedTests(),
      saveNewTests: this.getSaveNewTests(),
      compareWithParentBranch: this.getCompareWithParentBranch(),
      ignoreBaseline: this.getIgnoreBaseline(),
      parentBranchName: this.getParentBranchName(),
      isDisabled: this.getIsDisabled(),
      matchTimeout: this.getMatchTimeout(),
      ignoreCaret: this.getIgnoreCaret(),
      matchLevel: this.getMatchLevel(),
      useDom: this.getUseDom(),
      enablePatterns: this.getEnablePatterns(),
      ignoreDisplacements: this.getIgnoreDisplacements(),
      accessibilitySettings: this.getAccessibilityValidation(),
      visualGridOptions: this.getVisualGridOptions(),
      ignoreGitMergeBase: this.getIgnoreGitMergeBase(),
    }
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @return {Configuration}
   */
  cloneConfig() {
    return new Configuration(this)
  }
}

module.exports = Configuration


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/DeviceName.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/DeviceName.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof DeviceNames>} DeviceName
 */

const DeviceNames = Enum('DeviceName', {
  /** @type {'Blackberry PlayBook'} */
  Blackberry_PlayBook: 'Blackberry PlayBook',
  /** @type {'BlackBerry Z30'} */
  BlackBerry_Z30: 'BlackBerry Z30',
  /** @type {'Galaxy A5'} */
  Galaxy_A5: 'Galaxy A5',
  /** @type {'Galaxy Note 10'} */
  Galaxy_Note_10: 'Galaxy Note 10',
  /** @type {'Galaxy Note 10 Plus'} */
  Galaxy_Note_10_Plus: 'Galaxy Note 10 Plus',
  /** @type {'Galaxy Note 2'} */
  Galaxy_Note_2: 'Galaxy Note 2',
  /** @type {'Galaxy Note 3'} */
  Galaxy_Note_3: 'Galaxy Note 3',
  /** @type {'Galaxy Note 4'} */
  Galaxy_Note_4: 'Galaxy Note 4',
  /** @type {'Galaxy Note 8'} */
  Galaxy_Note_8: 'Galaxy Note 8',
  /** @type {'Galaxy Note 9'} */
  Galaxy_Note_9: 'Galaxy Note 9',
  /** @type {'Galaxy S10'} */
  Galaxy_S10: 'Galaxy S10',
  /** @type {'Galaxy S20'} */
  Galaxy_S20: 'Galaxy S20',
  /** @type {'Galaxy S10 Plus'} */
  Galaxy_S10_Plus: 'Galaxy S10 Plus',
  /** @type {'Galaxy S3'} */
  Galaxy_S3: 'Galaxy S3',
  /** @type {'Galaxy S5'} */
  Galaxy_S5: 'Galaxy S5',
  /** @type {'Galaxy S8'} */
  Galaxy_S8: 'Galaxy S8',
  /** @type {'Galaxy S8 Plus'} */
  Galaxy_S8_Plus: 'Galaxy S8 Plus',
  /** @type {'Galaxy S9'} */
  Galaxy_S9: 'Galaxy S9',
  /** @type {'Galaxy S9 Plus'} */
  Galaxy_S9_Plus: 'Galaxy S9 Plus',
  /** @type {'iPad'} */
  iPad: 'iPad',
  /** @type {'iPad 6th Gen'} */
  iPad_6th_Gen: 'iPad 6th Gen',
  /** @type {'iPad 7th Gen'} */
  iPad_7th_Gen: 'iPad 7th Gen',
  /** @type {'iPad Air 2'} */
  iPad_Air_2: 'iPad Air 2',
  /** @type {'iPad Mini'} */
  iPad_Mini: 'iPad Mini',
  /** @type {'iPad Pro'} */
  iPad_Pro: 'iPad Pro',
  /** @type {'iPhone 11'} */
  iPhone_11: 'iPhone 11',
  /** @type {'iPhone 11 Pro'} */
  iPhone_11_Pro: 'iPhone 11 Pro',
  /** @type {'iPhone 11 Pro Max'} */
  iPhone_11_Pro_Max: 'iPhone 11 Pro Max',
  /** @type {'iPhone 4'} */
  iPhone_4: 'iPhone 4',
  /** @type {'iPhone 5/SE'} */
  iPhone_5SE: 'iPhone 5/SE',
  /** @type {'iPhone 6/7/8'} */
  iPhone_6_7_8: 'iPhone 6/7/8',
  /** @type {'iPhone 6/7/8 Plus'} */
  iPhone_6_7_8_Plus: 'iPhone 6/7/8 Plus',
  /** @type {'iPhone X'} */
  iPhone_X: 'iPhone X',
  /** @type {'iPhone XR'} */
  iPhone_XR: 'iPhone XR',
  /** @type {'iPhone XS'} */
  iPhone_XS: 'iPhone XS',
  /** @type {'iPhone XS Max'} */
  iPhone_XS_Max: 'iPhone XS Max',
  /** @type {'Kindle Fire HDX'} */
  Kindle_Fire_HDX: 'Kindle Fire HDX',
  /** @type {'Laptop with HiDPI screen'} */
  Laptop_with_HiDPI_screen: 'Laptop with HiDPI screen',
  /** @type {'Laptop with MDPI screen'} */
  Laptop_with_MDPI_screen: 'Laptop with MDPI screen',
  /** @type {'Laptop with touch'} */
  Laptop_with_touch: 'Laptop with touch',
  /** @type {'LG G6'} */
  LG_G6: 'LG G6',
  /** @type {'LG Optimus L70'} */
  LG_Optimus_L70: 'LG Optimus L70',
  /** @type {'Microsoft Lumia 550'} */
  Microsoft_Lumia_550: 'Microsoft Lumia 550',
  /** @type {'Microsoft Lumia 950'} */
  Microsoft_Lumia_950: 'Microsoft Lumia 950',
  /** @type {'Nexus 10'} */
  Nexus_10: 'Nexus 10',
  /** @type {'Nexus 4'} */
  Nexus_4: 'Nexus 4',
  /** @type {'Nexus 5'} */
  Nexus_5: 'Nexus 5',
  /** @type {'Nexus 5X'} */
  Nexus_5X: 'Nexus 5X',
  /** @type {'Nexus 6'} */
  Nexus_6: 'Nexus 6',
  /** @type {'Nexus 6P'} */
  Nexus_6P: 'Nexus 6P',
  /** @type {'Nexus 7'} */
  Nexus_7: 'Nexus 7',
  /** @type {'Nokia Lumia 520'} */
  Nokia_Lumia_520: 'Nokia Lumia 520',
  /** @type {'Nokia N9'} */
  Nokia_N9: 'Nokia N9',
  /** @type {'OnePlus 7T'} */
  OnePlus_7T: 'OnePlus 7T',
  /** @type {'OnePlus 7T Pro'} */
  OnePlus_7T_Pro: 'OnePlus 7T Pro',
  // /** @type {nePlus_8: 'OnePlus 8'} */
  // OnePlus_8: 'OnePlus 8',
  // /** @type {nePlus_8_Pro: 'OnePlus 8 Pro'} */
  // OnePlus_8_Pro: 'OnePlus 8 Pro',
  /** @type {'Pixel 2'} */
  Pixel_2: 'Pixel 2',
  /** @type {'Pixel 2 XL'} */
  Pixel_2_XL: 'Pixel 2 XL',
  /** @type {'Pixel 3'} */
  Pixel_3: 'Pixel 3',
  /** @type {'Pixel 3 XL'} */
  Pixel_3_XL: 'Pixel 3 XL',
  /** @type {'Pixel 4'} */
  Pixel_4: 'Pixel 4',
  /** @type {'Pixel 4 XL'} */
  Pixel_4_XL: 'Pixel 4 XL',
})

module.exports = DeviceNames


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/ExactMatchSettings.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/ExactMatchSettings.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * Encapsulates match settings for the a session.
 */
class ExactMatchSettings {
  /**
   * Encapsulate threshold settings for the "Exact" match level.
   * @param settings
   * @param {number} [settings.minDiffIntensity=0] - The minimum intensity difference of pixel to be considered a change. Valid
   *   values are 0-255.
   * @param {number} [settings.minDiffWidth=0] - The minimum width of an intensity filtered pixels cluster to be considered a
   *   change. Must be >= 0.
   * @param {number} [settings.minDiffHeight=0] - The minimum height of an intensity filtered pixels cluster to be considered a
   *   change. Must be >= 0.
   * @param {number} [settings.matchThreshold=0] - The maximum percentage(!) of different pixels (after intensity, width and
   *   height filtering) which is still considered as a match. Valid values are fractions between 0-1.
   */
  constructor({minDiffIntensity, minDiffWidth, minDiffHeight, matchThreshold} = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    this._minDiffIntensity = minDiffIntensity || 0
    this._minDiffWidth = minDiffWidth || 0
    this._minDiffHeight = minDiffHeight || 0
    this._matchThreshold = matchThreshold || 0
  }

  /**
   * @return {number} - The minimum intensity difference of pixel to be considered a change.
   */
  getMinDiffIntensity() {
    return this._minDiffIntensity
  }

  /**
   * @param {number} value - The minimum intensity difference of pixel to be considered a change. Valid values are 0-255.
   */
  setMinDiffIntensity(value) {
    this._minDiffIntensity = value
  }

  /**
   * @return {number} - The minimum width of an intensity filtered pixels cluster to be considered a change.
   */
  getMinDiffWidth() {
    return this._minDiffWidth
  }

  /**
   * @param {number} value - The minimum width of an intensity filtered pixels cluster to be considered a change.
   *   Must be >= 0.
   */
  setMinDiffWidth(value) {
    this._minDiffWidth = value
  }

  /**
   * @return {number} - The minimum width of an intensity filtered pixels cluster to be considered a change.
   */
  getMinDiffHeight() {
    return this._minDiffHeight
  }

  /**
   * @param {number} value - The minimum height of an intensity filtered pixels cluster to be considered a change. Must
   *   be >= 0.
   */
  setMinDiffHeight(value) {
    this._minDiffHeight = value
  }

  /**
   * @return {number} - The maximum percentage(!) of different pixels (after intensity, width and height filtering) which
   *   is still considered as a match.
   */
  getMatchThreshold() {
    return this._matchThreshold
  }

  /**
   * @param {number} value - The maximum percentage(!) of different pixels (after intensity, width and height filtering)
   *   which is still considered as a match. Valid values are fractions between 0-1.
   */
  setMatchThreshold(value) {
    this._matchThreshold = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `ExactMatchSettings { ${JSON.stringify(this)} }`
  }
}

module.exports = ExactMatchSettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")

/**
 * Encapsulates floating match settings for the a session.
 */
class FloatingMatchSettings {
  /**
   * @param settings
   * @param {number} settings.left
   * @param {number} settings.top
   * @param {number} settings.width
   * @param {number} settings.height
   * @param {number} settings.maxUpOffset
   * @param {number} settings.maxDownOffset
   * @param {number} settings.maxLeftOffset
   * @param {number} settings.maxRightOffset
   */
  constructor({left, top, width, height, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset} = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    this._left = left
    this._top = top
    this._width = width
    this._height = height
    this._maxUpOffset = maxUpOffset
    this._maxDownOffset = maxDownOffset
    this._maxLeftOffset = maxLeftOffset
    this._maxRightOffset = maxRightOffset
  }

  /**
   * @return {number}
   */
  getLeft() {
    return this._left
  }

  /**
   * @param {number} value
   */
  setLeft(value) {
    this._left = value
  }

  /**
   * @return {number}
   */
  getTop() {
    return this._top
  }

  /**
   * @param {number} value
   */
  setTop(value) {
    this._top = value
  }

  /**
   * @return {number}
   */
  getWidth() {
    return this._width
  }

  /**
   * @param {number} value
   */
  setWidth(value) {
    this._width = value
  }

  /**
   * @return {number}
   */
  getHeight() {
    return this._height
  }

  /**
   * @param {number} value
   */
  setHeight(value) {
    this._height = value
  }

  /**
   * @return {number}
   */
  getMaxUpOffset() {
    return this._maxUpOffset
  }

  /**
   * @param {number} value
   */
  setMaxUpOffset(value) {
    this._maxUpOffset = value
  }

  /**
   * @return {number}
   */
  getMaxDownOffset() {
    return this._maxDownOffset
  }

  /**
   * @param {number} value
   */
  setMaxDownOffset(value) {
    this._maxDownOffset = value
  }

  /**
   * @return {number}
   */
  getMaxLeftOffset() {
    return this._maxLeftOffset
  }

  /**
   * @param {number} value
   */
  setMaxLeftOffset(value) {
    this._maxLeftOffset = value
  }

  /**
   * @return {number}
   */
  getMaxRightOffset() {
    return this._maxRightOffset
  }

  /**
   * @param {number} value
   */
  setMaxRightOffset(value) {
    this._maxRightOffset = value
  }

  /**
   * @return {Region}
   */
  getRegion() {
    return new Region(this._left, this._top, this._width, this._height)
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `FloatingMatchSettings { ${JSON.stringify(this)} }`
  }
}

module.exports = FloatingMatchSettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const MatchLevel = __webpack_require__(/*! ./MatchLevel */ "./node_modules/@applitools/eyes-sdk-core/lib/config/MatchLevel.js")
const AccessibilityLevel = __webpack_require__(/*! ./AccessibilityLevel */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityLevel.js")
const AccessibilityGuidelinesVersions = __webpack_require__(/*! ./AccessibilityGuidelinesVersion */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityGuidelinesVersion.js")
const ExactMatchSettings = __webpack_require__(/*! ./ExactMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ExactMatchSettings.js")
const AccessibilityMatchSettings = __webpack_require__(/*! ./AccessibilityMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityMatchSettings.js")
const FloatingMatchSettings = __webpack_require__(/*! ./FloatingMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")

const DEFAULT_VALUES = {
  matchLevel: MatchLevel.Strict,
  ignoreCaret: true,
  useDom: false,
  enablePatterns: false,
  ignoreDisplacements: false,
}

/**
 * Encapsulates match settings for the a session.
 */
class ImageMatchSettings {
  /**
   * @param {MatchLevel} [matchLevel=MatchLevel.Strict] The "strictness" level to use.
   * @param {ExactMatchSettings} [exact] - Additional threshold parameters when the {@code Exact} match level is used.
   * @param {boolean} [ignoreCaret]
   * @param {boolean} [useDom]
   * @param {boolean} [enablePatterns]
   * @param {boolean} [ignoreDisplacements]
   * @param {Region[]} [ignore]
   * @param {Region[]} [layout]
   * @param {Region[]} [strict]
   * @param {Region[]} [content]
   * @param {AccessibilityMatchSettings[]} [accessibility]
   * @param {FloatingMatchSettings[]} [floating]
   * @param {AccessibilitySettings} [accessibilitySettings]
   */
  constructor(imageMatchSettings) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    if (arguments[0] && arguments[0].constructor.name === 'ImageMatchSettings') {
      return new ImageMatchSettings(arguments[0]._toPlain())
    }

    const {
      matchLevel,
      exact,
      ignoreCaret,
      useDom,
      enablePatterns,
      ignoreDisplacements,
      ignore,
      layout,
      strict,
      content,
      accessibility,
      floating,
      accessibilitySettings,
    } = imageMatchSettings || {}

    ArgumentGuard.isValidEnumValue(matchLevel, MatchLevel, false)
    ArgumentGuard.isBoolean(ignoreCaret, 'ignoreCaret', false)
    ArgumentGuard.isBoolean(useDom, 'useDom', false)
    ArgumentGuard.isBoolean(enablePatterns, 'enablePatterns', false)
    ArgumentGuard.isBoolean(ignoreDisplacements, 'ignoreDisplacements', false)
    ArgumentGuard.isArray(ignore, 'ignore', false)
    ArgumentGuard.isArray(layout, 'layout', false)
    ArgumentGuard.isArray(strict, 'strict', false)
    ArgumentGuard.isArray(content, 'content', false)
    ArgumentGuard.isArray(accessibility, 'accessibility', false)
    ArgumentGuard.isArray(floating, 'floating', false)
    ArgumentGuard.isValidType(exact, ExactMatchSettings, false)

    this._matchLevel = TypeUtils.getOrDefault(matchLevel, DEFAULT_VALUES.matchLevel)
    this._ignoreCaret = TypeUtils.getOrDefault(ignoreCaret, DEFAULT_VALUES.ignoreCaret)
    this._useDom = TypeUtils.getOrDefault(useDom, DEFAULT_VALUES.useDom)
    this._enablePatterns = TypeUtils.getOrDefault(enablePatterns, DEFAULT_VALUES.enablePatterns)
    this._ignoreDisplacements = TypeUtils.getOrDefault(ignoreDisplacements, DEFAULT_VALUES.ignoreDisplacements)
    this._exact = exact

    /** @type {Region[]} */
    this._ignoreRegions = (ignore || []).map(region => new Region(region))
    /** @type {Region[]} */
    this._layoutRegions = (layout || []).map(region => new Region(region)) || []
    /** @type {Region[]} */
    this._strictRegions = (strict || []).map(region => new Region(region)) || []
    /** @type {Region[]} */
    this._contentRegions = (content || []).map(region => new Region(region)) || []
    /** @type {AccessibilityMatchSettings[]} */
    this._accessibilityMatchSettings =
      (accessibility || []).map(region =>
        TypeUtils.instanceOf(region, 'AccessibilityMatchSettings') ? region : new AccessibilityMatchSettings(region),
      ) || []
    /** @type {AccessibilitySettings} */
    this.setAccessibilitySettings(accessibilitySettings)
    /** @type {FloatingMatchSettings[]} */
    this._floatingMatchSettings =
      (floating || []).map(region =>
        TypeUtils.instanceOf(region, 'FloatingMatchSettings') ? region : new FloatingMatchSettings(region),
      ) || []
  }

  /**
   * @return {MatchLevel} - The match level to use.
   */
  getMatchLevel() {
    return this._matchLevel
  }

  /**
   * @param {MatchLevel} value - The match level to use.
   */
  setMatchLevel(value) {
    ArgumentGuard.isValidEnumValue(value, MatchLevel)
    this._matchLevel = value
  }

  /**
   * @return {AccessibilitySettings} - The accessibility settings to use.
   */
  getAccessibilitySettings() {
    return this._accessibilitySettings
  }

  /**
   * @param {AccessibilitySettings} value - The accessibility settings to use.
   */
  setAccessibilitySettings(value) {
    if (value) {
      ArgumentGuard.hasProperties(value, ['level', 'guidelinesVersion'], 'accessibilitySettings')
      ArgumentGuard.isValidEnumValue(value.level, AccessibilityLevel)
      ArgumentGuard.isValidEnumValue(value.guidelinesVersion, AccessibilityGuidelinesVersions)
    }
    this._accessibilitySettings = value
  }

  /**
   * @return {ExactMatchSettings} - The additional threshold params when the {@code Exact} match level is used, if any.
   */
  getExact() {
    return this._exact
  }

  /**
   * @param {ExactMatchSettings} value - The additional threshold parameters when the {@code Exact} match level is used.
   */
  setExact(value) {
    this._exact = value
  }

  /**
   * @return {boolean} - The parameters for the "IgnoreCaret" match settings.
   */
  getIgnoreCaret() {
    return this._ignoreCaret
  }

  /**
   * @param {boolean} value - The parameters for the "ignoreCaret" match settings.
   */
  setIgnoreCaret(value) {
    this._ignoreCaret = value
  }

  /**
   * @return {boolean}
   */
  getUseDom() {
    return this._useDom
  }

  /**
   * @param {boolean} value
   */
  setUseDom(value) {
    this._useDom = value
  }

  /**
   * @return {boolean}
   */
  getEnablePatterns() {
    return this._enablePatterns
  }

  /**
   * @param {boolean} value
   */
  setEnablePatterns(value) {
    this._enablePatterns = value
  }

  /**
   * @return {boolean}
   */
  getIgnoreDisplacements() {
    return this._ignoreDisplacements
  }

  /**
   * @param {boolean} value
   */
  setIgnoreDisplacements(value) {
    this._ignoreDisplacements = value
  }

  /**
   * Returns the array of regions to ignore.
   * @return {Region[]} - the array of regions to ignore.
   */
  getIgnoreRegions() {
    return this._ignoreRegions
  }

  /**
   * Sets an array of regions to ignore.
   * @param {Region[]} ignoreRegions - The array of regions to ignore.
   */
  setIgnoreRegions(ignoreRegions) {
    this._ignoreRegions = ignoreRegions
  }

  /**
   * Sets an array of regions to check using the Layout method.
   * @param {Region[]} layoutRegions - The array of regions to ignore.
   */
  setLayoutRegions(layoutRegions) {
    this._layoutRegions = layoutRegions
  }

  /**
   * Returns the array of regions to check using the Layout method.
   * @return {Region[]} - the array of regions to ignore.
   */
  getLayoutRegions() {
    return this._layoutRegions
  }

  /**
   * Returns the array of regions to check using the Strict method.
   * @return {Region[]} - the array of regions to ignore.
   */
  getStrictRegions() {
    return this._strictRegions
  }

  /**
   * Sets an array of regions to check using the Strict method.
   * @param {Region[]} strictRegions - The array of regions to ignore.
   */
  setStrictRegions(strictRegions) {
    this._strictRegions = strictRegions
  }

  /**
   * Returns the array of regions to check using the Content method.
   * @return {Region[]} - the array of regions to ignore.
   */
  getContentRegions() {
    return this._contentRegions
  }

  /**
   * Sets an array of regions to check using the Content method.
   * @param {Region[]} contentRegions - The array of regions to ignore.
   */
  setContentRegions(contentRegions) {
    this._contentRegions = contentRegions
  }

  /**
   * Returns an array of floating regions.
   * @return {FloatingMatchSettings[]} - an array of floating regions.
   */
  getFloatingRegions() {
    return this._floatingMatchSettings
  }

  /**
   * Sets an array of accessibility regions.
   * @param {AccessibilityMatchSettings[]} accessibilityMatchSettings - The array of accessibility regions.
   */
  setAccessibilityRegions(accessibilityMatchSettings) {
    this._accessibilityMatchSettings = accessibilityMatchSettings
  }

  /**
   * Returns an array of accessibility regions.
   * @return {AccessibilityMatchSettings[]} - an array of accessibility regions.
   */
  getAccessibilityRegions() {
    return this._accessibilityMatchSettings
  }

  /**
   * Sets an array of floating regions.
   * @param {FloatingMatchSettings[]} floatingMatchSettings - The array of floating regions.
   */
  setFloatingRegions(floatingMatchSettings) {
    this._floatingMatchSettings = floatingMatchSettings
  }

  /**
   * @override
   */
  toJSON() {
    const obj = this._toPlain()
    if (obj.accessibilitySettings) {
      obj.accessibilitySettings = {
        level: obj.accessibilitySettings.level,
        version: obj.accessibilitySettings.guidelinesVersion,
      }
    }
    return obj
  }

  _toPlain() {
    return GeneralUtils.toPlain(this, [], {
      ignoreRegions: 'ignore',
      layoutRegions: 'layout',
      strictRegions: 'strict',
      contentRegions: 'content',
      floatingMatchSettings: 'floating',
      accessibilityMatchSettings: 'accessibility',
    })
  }

  /**
   * @override
   */
  toString() {
    return `ImageMatchSettings { ${JSON.stringify(this)} }`
  }
}

module.exports = ImageMatchSettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/IosDeviceName.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/IosDeviceName.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof IosDeviceNames>} IosDeviceName
 */

const IosDeviceNames = Enum('IosDeviceName', {
  /** @type {'iPhone 11 Pro'} */
  iPhone_11_Pro: 'iPhone 11 Pro',
  /** @type {'iPhone 11 Pro Max'} */
  iPhone_11_Pro_Max: 'iPhone 11 Pro Max',
  /** @type {'iPhone 11'} */
  iPhone_11: 'iPhone 11',
  /** @type {'iPhone XR'} */
  iPhone_XR: 'iPhone XR',
  /** @type {'iPhone Xs'} */
  iPhone_XS: 'iPhone Xs',
  /** @type {'iPhone X'} */
  iPhone_X: 'iPhone X',
  /** @type {'iPhone 8'} */
  iPhone_8: 'iPhone 8',
  /** @type {'iPhone 7'} */
  iPhone_7: 'iPhone 7',
  /** @type {'iPad Pro (12.9-inch) (3rd generation)'} */
  iPad_Pro_3: 'iPad Pro (12.9-inch) (3rd generation)',
  /** @type {'iPad (7th generation)'} */
  iPad_7: 'iPad (7th generation)',
  /** @type {'iPad Air (2nd generation)'} */
  iPad_Air_2: 'iPad Air (2nd generation)',
  /** @type {'iPhone 12 Pro Max'} */
  iPhone_12_Pro_Max: 'iPhone 12 Pro Max',
  /** @type {'iPhone 12 Pro'} */
  iPhone_12_Pro: 'iPhone 12 Pro',
  /** @type {'iPhone 12'} */
  iPhone_12: 'iPhone 12',
  /** @type {'iPhone 12 mini'} */
  iPhone_12_mini: 'iPhone 12 mini',
})

module.exports = IosDeviceNames


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/IosVersion.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/IosVersion.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof IosVersions>} IosVersion
 */

/**
 * iOS version for visual-grid rendering
 */
const IosVersions = Enum('IosVersion', {
  /** @type {'latest'} */
  LATEST: 'latest',
  LATEST_ONE_VERSION_BACK: 'latest-1',
})

module.exports = IosVersions


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/MatchLevel.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/MatchLevel.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof MatchLevels>} MatchLevel
 */

/**
 * The extent in which two images match (or are expected to match).
 */
const MatchLevels = Enum('MatchLevel', {
  /**
   * Images do not necessarily match.
   * @type {'None'}
   */
  None: 'None',
  /**
   * Images have the same layout (legacy algorithm).
   * @type {'Layout1'}
   */
  LegacyLayout: 'Layout1',
  /**
   * Images have the same layout.
   * @type {'Layout'}
   */
  Layout: 'Layout',
  /**
   * Images have the same layout.
   * @type {'Layout2'}
   */
  Layout2: 'Layout2',
  /**
   * Images have the same content.
   * @type {'Content'}
   */
  Content: 'Content',
  /**
   * Images are nearly identical.
   * @type {'Strict'}
   */
  Strict: 'Strict',
  /**
   * Images are identical.
   * @type {'Exact'}
   */
  Exact: 'Exact',
})

module.exports = MatchLevels


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/PropertyData.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/PropertyData.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")

/**
 * @typedef {{name: string, value: string}} PropertyDataObject
 */

/**
 * A property to sent to the server
 */
class PropertyData {
  /**
   * @signature `new PropertyData(location)`
   * @sigparam {PropertyData} location - The PropertyData instance to clone from.
   *
   * @signature `new PropertyData(object)`
   * @sigparam {{name: string, value: string}} object - The property object to clone from.
   *
   * @signature `new PropertyData(name, value)`
   * @sigparam {string} name - The property name.
   * @sigparam {string} value - The property value.
   *
   * @param {string|PropertyDataObject|PropertyData} varArg1
   * @param {string} [varArg2]
   */
  constructor(varArg1, varArg2) {
    if (arguments.length === 2) {
      return new PropertyData({name: varArg1, value: varArg2})
    }

    if (varArg1 instanceof PropertyData) {
      return new PropertyData({name: varArg1.getName(), value: varArg1.getValue()})
    }

    const {name, value} = varArg1
    ArgumentGuard.isString(name, 'name')
    ArgumentGuard.notNull(value, 'value')

    /** @type {string} */
    this._name = name
    /** @type {string} */
    this._value = value
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} value
   */
  setName(value) {
    this._name = value
  }

  /**
   * @return {string}
   */
  getValue() {
    return this._value
  }

  /**
   * @param {string} value
   */
  setValue(value) {
    this._value = value
  }

  /**
   * @override
   */
  toJSON() {
    return {
      name: this._name,
      value: this._value,
    }
  }

  /**
   * @override
   */
  toString() {
    return `PropertyData { ${JSON.stringify(this)} }`
  }
}

module.exports = PropertyData


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/ProxySettings.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/ProxySettings.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")

/**
 * @typedef PlainProxySettings
 * @prop {string} url
 * @prop {string} [username]
 * @prop {string} [password]
 */

/**
 * @typedef ProxyObject
 * @param {string} protocol
 * @param {string} host
 * @param {number} port
 * @param {{username: string, password: string}} auth
 * @param {boolean} isHttpOnly
 */

/**
 * Encapsulates settings for sending Eyes communication via proxy.
 */
class ProxySettings {
  /**
   *
   * @param {string|boolean} uri - The proxy's URI or {@code false} to completely disable proxy.
   * @param {string} [username] - The username to be sent to the proxy.
   * @param {string} [password] - The password to be sent to the proxy.
   * @param {boolean} [isHttpOnly] - If the Proxy is an HTTP only and requires https over http tunneling.
   */
  constructor(uri, username, password, isHttpOnly) {
    ArgumentGuard.notNull(uri, 'uri')

    if (uri === false) {
      this._isDisabled = true
    } else {
      this._uri = uri
      this._username = username
      this._password = password
      this._isHttpOnly = isHttpOnly
      this._isDisabled = false

      if (isHttpOnly) this._port = this.findPortFromUriString(uri)
      this._url = new URL(uri.includes('://') ? uri : `http://${uri}`)
    }
  }

  // NOTE:
  // This is needed to preserve port 80 and backwards compatibility with the
  // default port of 8080 when running isHttpOnly.
  //
  // By default, URL sets the default port for a protocol to an empty string.
  // When an empty string is set for the port and isHttpOnly is enabled, then
  // the port defaults to 8080. Without this, port 80 is not a legal
  // configuraiton option.
  //
  // See also:
  // https://nodejs.org/api/url.html#url_url_port
  // eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js:26
  findPortFromUriString(uri) {
    const result = uri.match(/:(\d+)$/)
    return result ? result[1] : ''
  }

  getUri() {
    return this._uri
  }

  getUsername() {
    return this._username
  }

  getPassword() {
    return this._password
  }

  getIsHttpOnly() {
    return this._isHttpOnly
  }

  getIsDisabled() {
    return this._isDisabled
  }

  /**
   * @return {{protocol: string, host: string, port: number, auth: {username: string, password: string}, isHttpOnly: boolean}|boolean}
   */
  toProxyObject() {
    if (this._isDisabled) {
      return false
    }

    const proxy = {}

    proxy.protocol = this._url.protocol
    proxy.host = this._url.hostname
    proxy.port = this._port ? this._port : this._url.port
    proxy.isHttpOnly = !!this._isHttpOnly

    if (!this._username && this._url.username) {
      proxy.auth = {
        username: this._url.username,
        password: this._url.password,
      }
    } else if (this._username) {
      proxy.auth = {
        username: this._username,
        password: this._password,
      }
    }

    return proxy
  }
}

module.exports = ProxySettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/ScreenOrientation.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/ScreenOrientation.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof ScreenOrientations>} ScreenOrientation
 */

/**
 * Represents the types of available stitch modes.
 */
const ScreenOrientations = Enum('ScreenOrientation', {
  /** @type {'portrait'} */
  PORTRAIT: 'portrait',
  /** @type {'landscape'} */
  LANDSCAPE: 'landscape',
})

module.exports = ScreenOrientations


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/SessionType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/SessionType.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof SessionTypes>} SessionType
 */

/**
 * Represents the types of available stitch modes.
 */
const SessionTypes = Enum('SessionType', {
  /**
   * Default type of sessions.
   * @type {'SEQUENTIAL'}
   */
  SEQUENTIAL: 'SEQUENTIAL',
  /**
   * A timing test session
   * @type {'PROGRESSION'}
   */
  PROGRESSION: 'PROGRESSION',
})

module.exports = SessionTypes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/config/StitchMode.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/config/StitchMode.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {import('../utils/Enum').EnumValues<typeof StitchModes>} StitchMode
 */

/**
 * Represents the types of available stitch modes.
 */
const StitchModes = Enum('StitchMode', {
  /**
   * Standard JS scrolling.
   * @type {'Scroll'}
   */
  SCROLL: 'Scroll',
  /**
   * CSS translation based stitching.
   * @type {'CSS'}
   */
  CSS: 'CSS',
})

module.exports = StitchModes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const EyesError = __webpack_require__(/*! ./EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")

/**
 * Indicates that an existing test ended, and that differences where found from the baseline.
 */
class DiffsFoundError extends EyesError {
  constructor(testResult) {
    const message = `Test '${testResult.name}' of '${testResult.appName}' detected differences! See details at: ${testResult.url}`
    super(message, {reason: 'test different', testResult})
  }
}

module.exports = DiffsFoundError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js ***!
  \************************************************************************/
/***/ ((module) => {

/**
 * The base Applitools Eyes error type.
 */
class EyesError extends Error {
  constructor(message, {reason = 'internal', error, ...info} = {}) {
    super()
    this.name = this.constructor.name
    this.message = message
    this.reason = reason
    this.info = info
    this.originalError = error

    if (error instanceof Error) {
      this.message = `${message}: ${error.message}`
      this.stack = error.stack
    }
  }
}

module.exports = EyesError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const EyesError = __webpack_require__(/*! ./EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")

/**
 * Indicates that a new test (i.e., a test for which no baseline exists) ended.
 */
class NewTestError extends EyesError {
  constructor(testResult) {
    const message = `Test '${testResult.name}' of '${testResult.appName}' is new! Please approve the new baseline at ${testResult.url}`
    super(message, {reason: 'test new', testResult})
  }
}

module.exports = NewTestError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const EyesError = __webpack_require__(/*! ./EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")

/**
 * Indicates that a test did not pass (i.e., test either failed or is a new test).
 */
class TestFailedError extends EyesError {
  constructor(testResult) {
    const message = `Test '${testResult.name}' of '${testResult.appName}' is failed! See details at ${testResult.url}`
    super(message, {reason: 'test failed', testResult})
  }
}

module.exports = TestFailedError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/events/RemoteSessionEventHandler.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/events/RemoteSessionEventHandler.js ***!
  \****************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const axios = __webpack_require__(/*! axios */ "./node_modules/axios/index.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const SessionEventHandler = __webpack_require__(/*! ./SessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js")

// Constants
const DEFAULT_CONNECTION_TIMEOUT_MS = 30000
const SERVER_SUFFIX = '/applitools/sessions'

class RemoteSessionEventHandler extends SessionEventHandler {
  constructor(serverUrl, accessKey) {
    super()

    this._autSessionId = null
    this._serverUrl = serverUrl
    this._httpOptions = {
      strictSSL: false,
      baseUrl: GeneralUtils.urlConcat(serverUrl, SERVER_SUFFIX),
      json: true,
      params: {accessKey},
      timeout: DEFAULT_CONNECTION_TIMEOUT_MS,
    }
  }

  /**
   * @param {number} value
   */
  setTimeout(value) {
    this._httpOptions.timeout = value
  }

  /**
   * @return {number}
   */
  getTimeout() {
    return this._httpOptions.timeout
  }

  /**
   * @param {string} value
   */
  setServerUrl(value) {
    this._serverUrl = value
    this._httpOptions.baseUrl = GeneralUtils.urlConcat(value, SERVER_SUFFIX)
  }

  /**
   * @return {string}
   */
  getServerUrl() {
    return this._serverUrl
  }

  /**
   * @param {string} value
   */
  setAccessKey(value) {
    this._httpOptions.params.accessKey = value
  }

  /**
   * @return {string}
   */
  getAccessKey() {
    return this._httpOptions.params.accessKey
  }

  /**
   * @inheritDoc
   */
  initStarted() {
    const options = Object.create(this._httpOptions)
    options.uri = this._autSessionId
    options.data = {action: 'initStart'}
    options.method = 'PUT'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  initEnded() {
    const options = Object.create(this._httpOptions)
    options.uri = this._autSessionId
    options.data = {action: 'initEnd'}
    options.method = 'PUT'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  setSizeWillStart(sizeToSet) {
    const options = Object.create(this._httpOptions)
    options.uri = this._autSessionId
    options.data = {action: 'setSizeStart', size: sizeToSet}
    options.method = 'PUT'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  setSizeEnded() {
    const options = Object.create(this._httpOptions)
    options.uri = this._autSessionId
    options.data = {action: 'setSizeEnd'}
    options.method = 'PUT'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  testStarted(autSessionId) {
    this._autSessionId = autSessionId

    const options = Object.create(this._httpOptions)
    options.uri = ''
    options.data = {autSessionId}
    options.method = 'POST'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  testEnded(autSessionId, testResults) {
    const options = Object.create(this._httpOptions)
    options.uri = autSessionId
    options.data = {action: 'testEnd', testResults}
    options.method = 'PUT'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  validationWillStart(autSessionId, validationInfo) {
    const options = Object.create(this._httpOptions)
    options.uri = `${autSessionId}/validations`
    options.data = validationInfo
    options.method = 'POST'
    return axios(options)
  }

  /**
   * @inheritDoc
   */
  validationEnded(autSessionId, validationId, validationResult) {
    const options = Object.create(this._httpOptions)
    options.uri = `${autSessionId}/validations/${validationId}`
    options.data = {action: 'validationEnd', asExpected: validationResult.getAsExpected()}
    options.method = 'PUT'
    return axios(options)
  }
}

module.exports = RemoteSessionEventHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";


/* eslint-disable no-unused-vars */

/**
 * The base class for session event handler. Specific implementations should use this class as abstract.
 *
 * @abstract
 */
class SessionEventHandler {
  /**
   * Called when the data gathering for creating a session phase had started.
   *
   * @return {Promise}
   */
  initStarted() {}

  /**
   * Called when the data gathering phase had ended.
   *
   * @return {Promise}
   */
  initEnded() {}

  /**
   * Called when setting the size of the application window is about to start.
   *
   * @param {RectangleSize} sizeToSet - an object with 'width' and 'height' properties.
   * @return {Promise}
   */
  setSizeWillStart(sizeToSet) {}

  /**
   * Called 'set size' operation has ended (either failed/success).
   *
   * @return {Promise}
   */
  setSizeEnded() {}

  /**
   * Called after a session had started.
   *
   * @param {string} autSessionId - The AUT session ID.
   * @return {Promise}
   */
  testStarted(autSessionId) {}

  /**
   * Called after a session had ended.
   *
   * @param {string} autSessionId - The AUT session ID.
   * @param {TestResults} testResults - The test results.
   * @return {Promise}
   */
  testEnded(autSessionId, testResults) {}

  /**
   * Called before a new validation will be started.
   *
   * @param {string} autSessionId - The AUT session ID.
   * @param {ValidationInfo} validationInfo - The validation parameters.
   * @return {Promise}
   */
  validationWillStart(autSessionId, validationInfo) {}

  /**
   * Called when a validation had ended.
   *
   * @param {string} autSessionId - The AUT session ID.
   * @param {number} validationId - The ID of the validation which had ended.
   * @param {ValidationResult} validationResult - The validation results.
   * @return {Promise}
   */
  validationEnded(autSessionId, validationId, validationResult) {}
}

module.exports = SessionEventHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandlers.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandlers.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const SessionEventHandler = __webpack_require__(/*! ./SessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js")

class SessionEventHandlers extends SessionEventHandler {
  constructor() {
    super()

    /** @type {SessionEventHandler[]} */
    this._eventHandlers = []
  }

  /**
   * @param {SessionEventHandler} handler
   */
  addEventHandler(handler) {
    if (handler === this) {
      return
    }

    this._eventHandlers.push(handler)
  }

  /**
   * @param {SessionEventHandler} handler
   */
  removeEventHandler(handler) {
    if (handler === this) {
      return
    }

    const index = this._eventHandlers.indexOf(handler)
    this._eventHandlers.splice(index, 1)
  }

  clearEventHandlers() {
    this._eventHandlers.length = 0
  }

  /**
   * Called when the data gathering for creating a session phase had started.
   *
   * @override
   * @return {Promise}
   */
  initStarted() {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.initStarted()))
  }

  /**
   * Called when the data gathering phase had ended.
   *
   * @override
   * @return {Promise}
   */
  initEnded() {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.initEnded()))
  }

  /**
   * Called when setting the size of the application window is about to start.
   *
   * @override
   * @param {RectangleSize} sizeToSet - an object with 'width' and 'height' properties.
   * @return {Promise}
   */
  setSizeWillStart(sizeToSet) {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.setSizeWillStart(sizeToSet)))
  }

  /**
   * Called 'set size' operation has ended (either failed/success).
   *
   * @override
   * @return {Promise}
   */
  setSizeEnded() {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.setSizeEnded()))
  }

  /**
   * Called after a session had started.
   *
   * @override
   * @param {string} autSessionId - The AUT session ID.
   * @return {Promise}
   */
  testStarted(autSessionId) {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.testStarted(autSessionId)))
  }

  /**
   * Called after a session had ended.
   *
   * @override
   * @param {string} autSessionId - The AUT session ID.
   * @param {TestResults} testResults - The test results.
   * @return {Promise}
   */
  testEnded(autSessionId, testResults) {
    return Promise.all(this._eventHandlers.map(eventHandler => eventHandler.testEnded(autSessionId, testResults)))
  }

  /**
   * Called before a new validation will be started.
   *
   * @override
   * @param {string} autSessionId - The AUT session ID.
   * @param {ValidationInfo} validationInfo - The validation parameters.
   * @return {Promise}
   */
  validationWillStart(autSessionId, validationInfo) {
    return Promise.all(
      this._eventHandlers.map(eventHandler => eventHandler.validationWillStart(autSessionId, validationInfo)),
    )
  }

  /**
   * Called when a validation had ended.
   *
   * @override
   * @param {string} autSessionId - The AUT session ID.
   * @param {number} validationId - The ID of the validation which had ended.
   * @param {ValidationResult} validationResult - The validation results.
   * @return {Promise}
   */
  validationEnded(autSessionId, validationId, validationResult) {
    return Promise.all(
      this._eventHandlers.map(eventHandler =>
        eventHandler.validationEnded(autSessionId, validationId, validationResult),
      ),
    )
  }
}

module.exports = SessionEventHandlers


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationInfo.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationInfo.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * Encapsulates the information for the validation about to execute.
 */
class ValidationInfo {
  /**
   * @param {number} [validationId]
   * @param {string} [tag]
   */
  constructor(validationId, tag) {
    this._validationId = validationId
    this._tag = tag
  }

  /**
   * @param {number} value
   */
  setValidationId(value) {
    this._validationId = value
  }

  /**
   * @return {number}
   */
  getValidationId() {
    return this._validationId
  }

  /**
   * @param {string} value
   */
  setTag(value) {
    this._tag = value
  }

  /**
   * @return {string}
   */
  getTag() {
    return this._tag
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }
}

module.exports = ValidationInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationResult.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationResult.js ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";


/**
 * Encapsulates the information for the validation about to execute.
 */
class ValidationResult {
  /**
   * @param {boolean} [asExpected]
   */
  constructor(asExpected) {
    this._asExpected = asExpected
  }

  /**
   * @param {boolean} value
   */
  setAsExpected(value) {
    this._asExpected = value
  }

  /**
   * @return {boolean}
   */
  getAsExpected() {
    return this._asExpected
  }
}

module.exports = ValidationResult


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/CoordinatesType.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/geometry/CoordinatesType.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const Enum = __webpack_require__(/*! ../utils/Enum */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js")

/**
 * @typedef {string} CoordinatesType
 */

const CoordinatesTypes = Enum('CoordinatesType', {
  /**
   * The coordinates should be used "as is" on the screenshot image. Regardless of the current context.
   */
  SCREENSHOT_AS_IS: 'SCREENSHOT_AS_IS',
  /**
   * The coordinates should be used "as is" within the current context. For example, if we're inside a frame, the
   * coordinates are "as is", but within the current frame's viewport.
   */
  CONTEXT_AS_IS: 'CONTEXT_AS_IS',
  /**
   * Coordinates are relative to the context. For example, if we are in a context of a frame in a web page, then the
   * coordinates are relative to the  frame. In this case, if we want to crop an image region based on an element's
   * region, we will need to calculate their respective "as is" coordinates.
   */
  CONTEXT_RELATIVE: 'CONTEXT_RELATIVE',
})

module.exports = CoordinatesTypes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")

/**
 * @typedef {{x: number, y: number}} LocationObject
 */

/**
 * A location in a two-dimensional plane.
 */
class Location {
  /**
   * Creates a Location instance.
   * @param {Location|LocationObject|number} varArg1 - The Location (or object) to clone from or the X coordinate of new Location.
   * @param {number} [varArg2] - The Y coordinate of new Location.
   */
  constructor(varArg1, varArg2) {
    if (arguments.length === 2) {
      return new Location({x: varArg1, y: varArg2})
    }

    if (TypeUtils.instanceOf(varArg1, Location)) {
      return new Location({x: varArg1.getX(), y: varArg1.getY()})
    }

    const {x, y} = varArg1
    ArgumentGuard.isNumber(x, 'x')
    ArgumentGuard.isNumber(y, 'y')

    this._x = x
    this._y = y
  }

  static get __Location() {
    return true
  }

  /**
   * @return {number} The X coordinate of this location.
   */
  getX() {
    return this._x
  }

  /**
   * @return {number} - The Y coordinate of this location.
   */
  getY() {
    return this._y
  }

  /**
   * Indicates whether some other Location is "equal to" this one.
   *
   * @param {Location} obj - The reference object with which to compare.
   * @return {boolean} - A {@code true} if this object is the same as the obj argument, {@code false} otherwise.
   */
  equals(obj) {
    if (typeof obj !== typeof this || !(obj instanceof Location)) {
      return false
    }

    return this.getX() === obj.getX() && this.getY() === obj.getY()
  }

  /**
   * Get a location translated by the specified amount.
   *
   * @param {number} dx - The amount to offset the x-coordinate.
   * @param {number} dy - The amount to offset the y-coordinate.
   * @return {Location} - A location translated by the specified amount.
   */
  offset(dx, dy) {
    return new Location({x: this._x + dx, y: this._y + dy})
  }

  /**
   *
   * @param {Location} other
   * @return {Location}
   */
  offsetNegative(other) {
    return new Location({x: this._x - other.getX(), y: this._y - other.getY()})
  }

  /**
   * Get a location translated by the specified amount.
   *
   * @param {Location} amount - The amount to offset.
   * @return {Location} - A location translated by the specified amount.
   */
  offsetByLocation(amount) {
    return this.offset(amount.getX(), amount.getY())
  }

  /**
   * Get a scaled location.
   *
   * @param {number} scaleRatio - The ratio by which to scale the results.
   * @return {Location} - A scaled copy of the current location.
   */
  scale(scaleRatio) {
    return new Location({x: this._x * scaleRatio, y: this._y * scaleRatio})
  }

  /**
   * @override
   */
  toJSON() {
    return {x: this._x, y: this._y}
  }

  /**
   * @override
   */
  toString() {
    return `(${this._x}, ${this._y})`
  }

  toStringForFilename() {
    return `${this._x}_${this._y}`
  }
}

/** @type {Location} */
Location.ZERO = new Location({x: 0, y: 0})

module.exports = Location


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")

/**
 * @typedef PlainRectangleSize
 * @prop {number} width
 * @prop {number} height
 */

/**
 * Represents a 2D size.
 */
class RectangleSize {
  /**
   * Creates a RectangleSize instance.
   * @param {RectangleSize|PlainRectangleSize|number} varArg1 - The RectangleSize (or object) to clone from or the width of new RectangleSize.
   * @param {number} [varArg2] - The height of new RectangleSize.
   */
  constructor(varArg1, varArg2) {
    if (arguments.length === 2) {
      return new RectangleSize({width: varArg1, height: varArg2})
    }

    if (varArg1 instanceof RectangleSize) {
      return new RectangleSize({width: varArg1.getWidth(), height: varArg1.getHeight()})
    }

    const {width, height} = varArg1
    ArgumentGuard.greaterThanOrEqualToZero(width, 'width')
    ArgumentGuard.greaterThanOrEqualToZero(height, 'height')

    this._width = width
    this._height = height
  }

  /**
   * Parses a string into a {@link RectangleSize} instance.
   *
   * @param {string} size - A string representing width and height separated by "x".
   * @return {RectangleSize} - An instance representing the input size.
   */
  static parse(size) {
    ArgumentGuard.notNull(size, 'size')
    const parts = size.split('x')
    if (parts.length !== 2) {
      throw new Error(`IllegalArgument: Not a valid size string: ${size}`)
    }

    return new RectangleSize({width: parseInt(parts[0], 10), height: parseInt(parts[1], 10)})
  }

  /**
   * @return {boolean}
   */
  isEmpty() {
    return this.getWidth() === 0 && this.getHeight() === 0
  }

  /**
   * @return {number} - The rectangle's width.
   */
  getWidth() {
    return this._width
  }

  /**
   * @return {number} - The rectangle's height.
   */
  getHeight() {
    return this._height
  }

  /**
   * Indicates whether some other RectangleSize is "equal to" this one.
   *
   * @param {object|RectangleSize} obj - The reference object with which to compare.
   * @return {boolean} - A {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   */
  equals(obj) {
    if (typeof obj !== typeof this || !(obj instanceof RectangleSize)) {
      return false
    }

    return this.getWidth() === obj.getWidth() && this.getHeight() === obj.getHeight()
  }

  /**
   * Get a scaled version of the current size.
   *
   * @param {number} scaleRatio - The ratio by which to scale the results.
   * @return {RectangleSize} - A scaled copy of the current size.
   */
  scale(scaleRatio) {
    return new RectangleSize({
      width: this._width * scaleRatio,
      height: this._height * scaleRatio,
    })
  }

  /**
   * @override
   */
  toJSON() {
    return {width: this._width, height: this._height}
  }

  /**
   * @override
   */
  toString() {
    return `${this._width}x${this._height}`
  }
}

/** @type {RectangleSize} */
RectangleSize.EMPTY = new RectangleSize(0, 0)

module.exports = RectangleSize


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const RectangleSize = __webpack_require__(/*! ./RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const Location = __webpack_require__(/*! ./Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")
const CoordinatesTypes = __webpack_require__(/*! ./CoordinatesType */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/CoordinatesType.js")

/**
 * @typedef {import('./CoordinatesType').CoordinatesType} CoordinatesType
 */

/**
 * @typedef {{left: number, top: number, width: number, height: number, coordinatesType: CoordinatesType|undefined}} RegionObject
 */

/**
 * @private
 * @param {Region} containerRegion - The region to divide into sub-regions.
 * @param {RectangleSize} subRegionSize - The maximum size of each sub-region.
 * @return {Region[]} - The sub-regions composing the current region. If subRegionSize is equal or greater than
 *   the current region, only a single region is returned.
 */
const getSubRegionsWithFixedSize = (containerRegion, subRegionSize) => {
  ArgumentGuard.notNull(containerRegion, 'containerRegion')
  ArgumentGuard.notNull(subRegionSize, 'subRegionSize')

  const subRegions = []

  let subRegionWidth = subRegionSize.getWidth()
  let subRegionHeight = subRegionSize.getHeight()

  ArgumentGuard.greaterThanZero(subRegionWidth, 'subRegionSize width')
  ArgumentGuard.greaterThanZero(subRegionHeight, 'subRegionSize height')

  // Normalizing.
  if (subRegionWidth > containerRegion.getWidth()) {
    subRegionWidth = containerRegion.getWidth()
  }
  if (subRegionHeight > containerRegion.getHeight()) {
    subRegionHeight = containerRegion.getHeight()
  }

  // If the requested size is greater or equal to the entire region size, we return a copy of the region.
  if (subRegionWidth === containerRegion.getWidth() && subRegionHeight === containerRegion.getHeight()) {
    subRegions.push(new Region(containerRegion))
    return subRegions
  }

  let currentTop = containerRegion.getTop()
  const bottom = containerRegion.getTop() + containerRegion.getHeight() - 1
  const right = containerRegion.getLeft() + containerRegion.getWidth() - 1

  while (currentTop <= bottom) {
    if (currentTop + subRegionHeight > bottom) {
      currentTop = bottom - subRegionHeight + 1
    }

    let currentLeft = containerRegion.getLeft()
    while (currentLeft <= right) {
      if (currentLeft + subRegionWidth > right) {
        currentLeft = right - subRegionWidth + 1
      }

      subRegions.push(new Region(currentLeft, currentTop, subRegionWidth, subRegionHeight))

      currentLeft += subRegionWidth
    }
    currentTop += subRegionHeight
  }
  return subRegions
}

/**
 * @private
 * @param {Region} containerRegion - The region to divide into sub-regions.
 * @param {RectangleSize} maxSubRegionSize - The maximum size of each sub-region (some regions might be smaller).
 * @return {Region[]} - The sub-regions composing the current region. If maxSubRegionSize is equal or greater than
 *   the current region, only a single region is returned.
 */
const getSubRegionsWithVaryingSize = (containerRegion, maxSubRegionSize, scrollDownAmmount) => {
  ArgumentGuard.notNull(containerRegion, 'containerRegion')
  ArgumentGuard.notNull(maxSubRegionSize, 'maxSubRegionSize')
  ArgumentGuard.greaterThanZero(maxSubRegionSize.getWidth(), 'maxSubRegionSize.getWidth()')
  ArgumentGuard.greaterThanZero(maxSubRegionSize.getHeight(), 'maxSubRegionSize.getHeight()')
  ArgumentGuard.greaterThanOrEqualToZero(scrollDownAmmount, 'scrollDownAmmount')

  const subRegions = []

  let currentTop = containerRegion.getTop()
  const bottom = containerRegion.getTop() + containerRegion.getHeight()
  const right = containerRegion.getLeft() + containerRegion.getWidth()

  while (currentTop < bottom) {
    let currentBottom = currentTop + maxSubRegionSize.getHeight()
    if (currentBottom > bottom) {
      currentBottom = bottom
    }

    let currentLeft = containerRegion.getLeft()
    while (currentLeft < right) {
      let currentRight = currentLeft + maxSubRegionSize.getWidth()
      if (currentRight > right) {
        currentRight = right
      }

      const currentHeight = currentBottom - currentTop
      const currentWidth = currentRight - currentLeft

      subRegions.push(new Region(currentLeft, currentTop, currentWidth, currentHeight))
      currentLeft += maxSubRegionSize.getWidth()
    }
    currentTop = currentBottom !== bottom ? currentBottom - scrollDownAmmount : bottom
  }
  return subRegions
}

/**
 * A Region in a two-dimensional plane.
 */
class Region {
  /**
   * Creates a Region instance.
   * @param {Region|RegionObject|Location|number} varArg1 - The Region (or object) to clone from, the Location of new region or the left offset of new region.
   * @param {RectangleSize|number} [varArg2] - The Region size or the top offset of new region.
   * @param {CoordinatesType|number} [varArg3] - The width of new region.
   * @param {number} [varArg4] - The height of new region.
   * @param {CoordinatesType} [varArg5] - The coordinatesType of new region (protected argument).
   */
  constructor(varArg1, varArg2, varArg3, varArg4, varArg5) {
    if (arguments.length === 2 || arguments.length === 3) {
      // eslint-disable-next-line max-len
      return new Region({
        left: varArg1.getX(),
        top: varArg1.getY(),
        width: varArg2.getWidth(),
        height: varArg2.getHeight(),
        coordinatesType: varArg3,
      })
    }

    if (arguments.length === 4 || arguments.length === 5) {
      // eslint-disable-next-line max-len
      return new Region({
        left: varArg1,
        top: varArg2,
        width: varArg3,
        height: varArg4,
        coordinatesType: varArg5,
      })
    }

    if (TypeUtils.instanceOf(varArg1, Region)) {
      // eslint-disable-next-line max-len
      return new Region({
        left: varArg1.getLeft(),
        top: varArg1.getTop(),
        width: varArg1.getWidth(),
        height: varArg1.getHeight(),
        coordinatesType: varArg1.getCoordinatesType(),
      })
    }

    const {left = varArg1.x, top = varArg1.y, width, height, coordinatesType, error} = varArg1

    if (error) {
      this._error = error
    } else {
      ArgumentGuard.isNumber(left, 'left')
      ArgumentGuard.isNumber(top, 'top')
      ArgumentGuard.greaterThanOrEqualToZero(width, 'width')
      ArgumentGuard.greaterThanOrEqualToZero(height, 'height')

      this._left = left
      this._top = top
      this._width = width
      this._height = height
      this._coordinatesType = coordinatesType || CoordinatesTypes.SCREENSHOT_AS_IS
    }
  }

  static get __Region() {
    return true
  }

  /**
   * @param {object} object
   * @return {boolean}
   */
  static isRegionCompatible(object) {
    return (
      object instanceof Region ||
      (TypeUtils.isPlainObject(object) && TypeUtils.has(object, ['left', 'top', 'width', 'height']))
    )
  }

  /**
   * @return {number} - The region's left offset.
   */
  getLeft() {
    return this._left
  }

  /**
   * @param {number} value
   */
  setLeft(value) {
    this._left = value
  }

  /**
   * @return {number} - The region's top offset.
   */
  getTop() {
    return this._top
  }

  /**
   * @param {number} value
   */
  setTop(value) {
    this._top = value
  }

  /**
   * @return {number} - The region's right offset.
   */
  getRight() {
    return this._left + this._width
  }

  /**
   * @return {number} - The region's bottom offset.
   */
  getBottom() {
    return this._top + this._height
  }

  /**
   * @return {number} - The region's width.
   */
  getWidth() {
    return this._width
  }

  /**
   * @param {number} value
   */
  setWidth(value) {
    this._width = value
  }

  /**
   * @return {number} - The region's height.
   */
  getHeight() {
    return this._height
  }

  /**
   * @param {number} value
   */
  setHeight(value) {
    this._height = value
  }

  /**
   * @return {CoordinatesType} - The region's coordinatesType.
   */
  getCoordinatesType() {
    return this._coordinatesType
  }

  /**
   * @param {CoordinatesType} value
   */
  setCoordinatesType(value) {
    this._coordinatesType = value
  }

  /**
   * @return {string}
   */
  getError() {
    return this._error
  }

  /**
   * @param {string} value
   */
  setError(value) {
    this._error = value
  }

  /**
   * @return {Location} - The (top,left) position of the current region.
   */
  getLocation() {
    return new Location({x: this._left, y: this._top})
  }

  /**
   * Set the (top,left) position of the current region
   *
   * @param {Location} location - The (top,left) position to set.
   */
  setLocation(location) {
    ArgumentGuard.notNull(location, 'location')
    this._left = location.getX()
    this._top = location.getY()
  }

  /**
   * @return {RectangleSize} - The size of the region.
   */
  getSize() {
    return new RectangleSize({width: this._width, height: this._height})
  }

  /**
   * Set the (width,height) size of the current region
   *
   * @param {RectangleSize} size - The updated size of the region.
   */
  setSize(size) {
    ArgumentGuard.notNull(size, 'size')
    this._width = size.getWidth()
    this._height = size.getHeight()
  }

  /**
   * Indicates whether some other Region is "equal to" this one.
   *
   * @param {object|Region} obj - The reference object with which to compare.
   * @return {boolean} - A {@code true} if this object is the same as the obj argument; {@code false} otherwise.
   */
  equals(obj) {
    if (typeof obj !== typeof this || !(obj instanceof Region)) {
      return false
    }

    return (
      this.getLeft() === obj.getLeft() &&
      this.getTop() === obj.getTop() &&
      this.getWidth() === obj.getWidth() &&
      this.getHeight() === obj.getHeight()
    )
  }

  /**
   * @return {boolean} - A {@code true} if the region is empty; {@code false} otherwise.
   */
  isEmpty() {
    return (
      this.getLeft() === Region.EMPTY.getLeft() &&
      this.getTop() === Region.EMPTY.getTop() &&
      this.getWidth() === Region.EMPTY.getWidth() &&
      this.getHeight() === Region.EMPTY.getHeight()
    )
  }

  /**
   * @return {boolean} - A {@code true} if the region's size is 0, false otherwise.
   */
  isSizeEmpty() {
    return this.getWidth() <= 0 || this.getHeight() <= 0
  }

  /**
   * Get a Region translated by the specified amount.
   *
   * @param {number} dx - The amount to offset the x-coordinate.
   * @param {number} dy - The amount to offset the y-coordinate.
   * @return {Region} - A region with an offset location.
   */
  offset(dx, dy) {
    return new Region(this.getLocation().offset(dx, dy), this.getSize(), this.getCoordinatesType())
  }

  /**
   * @return {Location}
   */
  getMiddleOffset() {
    const middleX = this._width / 2
    const middleY = this._height / 2

    return new Location({x: middleX, y: middleY})
  }

  /**
   * Get a region which is a scaled version of the current region.
   * IMPORTANT: This also scales the LOCATION(!!) of the region (not just its size).
   *
   * @param {number} scaleRatio - The ratio by which to scale the results.
   * @return {Region} - A new region which is a scaled version of the current region.
   */
  scale(scaleRatio) {
    return new Region(this.getLocation().scale(scaleRatio), this.getSize().scale(scaleRatio), this.getCoordinatesType())
  }

  /**
   * Returns a list of sub-regions which compose the current region.
   *
   * @param {RectangleSize} subRegionSize - The default sub-region size to use.
   * @param {boolean} [isFixedSize=false] - If {@code false}, then sub-regions might have a size which is smaller then
   *   {@code subRegionSize} (thus there will be no overlap of regions). Otherwise, all sub-regions will have the same
   * @param {number} [scrollDownAmmount=0] - If exists (double overlap) then each non-top region is scrolled up (page down)
   *   by this ammount; this is under the assumption that this mmount should be removed from the top of images.
   * @return {Region[]} - The sub-regions composing the current region. If {@code subRegionSize} is equal or
   *   greater than the current region, only a single region is returned.
   */
  getSubRegions(subRegionSize, isFixedSize = false, scrollDownAmmount = 0) {
    if (isFixedSize) {
      return getSubRegionsWithFixedSize(this, subRegionSize)
    }

    return getSubRegionsWithVaryingSize(this, subRegionSize, scrollDownAmmount)
  }

  /**
   * Check if a specified region is contained within the another region or location.
   *
   * @param {Region|Location} locationOrRegion - The region or location to check if it is contained within the current
   *   region.
   * @return {boolean} - True if the region is contained within given object, false otherwise.
   */
  contains(locationOrRegion) {
    if (locationOrRegion instanceof Location) {
      return (
        locationOrRegion.getX() >= this._left &&
        locationOrRegion.getX() <= this._left + this._width &&
        locationOrRegion.getY() >= this._top &&
        locationOrRegion.getY() <= this._top + this._height
      )
    }

    if (locationOrRegion instanceof Region) {
      return (
        this._top <= locationOrRegion.getTop() &&
        this._left <= locationOrRegion.getLeft() &&
        this._top + this._height >= locationOrRegion.getTop() + locationOrRegion.getHeight() &&
        this._left + this._width >= locationOrRegion.getLeft() + locationOrRegion.getWidth()
      )
    }

    throw new TypeError('Unsupported type of given object.')
  }

  /**
   * Check if a region is intersected with the current region.
   *
   * @param {Region} other - The region to check intersection with.
   * @return {boolean} - True if the regions are intersected, false otherwise.
   */
  isIntersected(other) {
    const right = this._left + this._width
    const bottom = this._top + this._height

    const otherLeft = other.getLeft()
    const otherTop = other.getTop()
    const otherRight = otherLeft + other.getWidth()
    const otherBottom = otherTop + other.getHeight()

    return (
      ((this._left <= otherLeft && otherLeft <= right) || (otherLeft <= this._left && this._left <= otherRight)) &&
      ((this._top <= otherTop && otherTop <= bottom) || (otherTop <= this._top && this._top <= otherBottom))
    )
  }

  /**
   * Replaces this region with the intersection of itself and {@code other}
   *
   * @param {Region} other - The region with which to intersect.
   */
  intersect(other) {
    if (!this.isIntersected(other)) {
      this.makeEmpty()
      return
    }

    // The regions intersect. So let's first find the left & top values
    const otherLeft = other.getLeft()
    const otherTop = other.getTop()

    const intersectionLeft = this._left >= otherLeft ? this._left : otherLeft
    const intersectionTop = this._top >= otherTop ? this._top : otherTop

    // Now the width and height of the intersect
    const right = this._left + this._width
    const otherRight = otherLeft + other.getWidth()
    const intersectionRight = right <= otherRight ? right : otherRight
    const intersectionWidth = intersectionRight - intersectionLeft

    const bottom = this._top + this._height
    const otherBottom = otherTop + other.getHeight()
    const intersectionBottom = bottom <= otherBottom ? bottom : otherBottom
    const intersectionHeight = intersectionBottom - intersectionTop

    this._left = intersectionLeft
    this._top = intersectionTop
    this._width = intersectionWidth
    this._height = intersectionHeight
  }

  /**
   * @protected
   */
  makeEmpty() {
    this._left = Region.EMPTY.getLeft()
    this._top = Region.EMPTY.getTop()
    this._width = Region.EMPTY.getWidth()
    this._height = Region.EMPTY.getHeight()
    this._coordinatesType = Region.EMPTY.getCoordinatesType()
  }

  /**
   * @override
   */
  toJSON() {
    if (this._error) {
      return {
        error: this._error,
      }
    }

    return {
      left: this._left,
      top: this._top,
      width: this._width,
      height: this._height,
      // coordinatesType: this._coordinatesType,
    }
  }

  async toPersistedRegions(_driver) {
    return [
      {
        left: this._left,
        top: this._top,
        width: this._width,
        height: this._height,
      },
    ]
  }

  /**
   * @override
   */
  toString() {
    if (this._error) {
      return `Error: ${this._error}`
    }

    return `(${this._left}, ${this._top}) ${this._width}x${this._height}`
  }
}

/** @type {Region} */
Region.EMPTY = new Region(0, 0, 0, 0)

module.exports = Region


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/getScmInfo.js":
/*!******************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/getScmInfo.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {pexec, cachify, presult} = __webpack_require__(/*! ../lib/utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

async function doGetScmInfo(branchName, parentBranchName, _opts) {
  const commitTimeCmd = `HASH=$(git merge-base ${branchName} ${parentBranchName}) && git show -q --format=%cI $HASH`
  let [{stderr} = {}, {stdout} = {}] = await presult(pexec(commitTimeCmd, _opts))

  // missing branch info
  let missingBranch = _missingBranchName(stderr)
  if (missingBranch) {
    const fetchBranchCmd = `git fetch origin ${missingBranch}:${missingBranch}`
    ;[{stderr} = {}, {stdout} = {}] = await presult(pexec(`${fetchBranchCmd} && ${commitTimeCmd}`, _opts))
  }

  // missing current branch commits
  if (!stdout) {
    const fetchBranchCmd = 'git fetch origin --unshallow'
    ;[{stderr} = {}, {stdout} = {}] = await presult(pexec(`${fetchBranchCmd} && ${commitTimeCmd}`, _opts))
  }

  if (stdout) {
    stdout = stdout.replace(/\s/g, '')
  }
  if (!_isCorrectInfo(stdout)) {
    throw new Error(`stderr: ${stderr}, stdout: ${stdout}`)
  }

  return stdout
}

function _isCorrectInfo(stdout) {
  return stdout && stdout.match(/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\+\d{2}:\d{2}/)
}

function _missingBranchName(stderr) {
  const m = stderr && stderr.match(/Not a valid object name ([^\s]+)/)
  return m && m[1]
}

module.exports = cachify(doGetScmInfo, true)


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/handler/PropertyHandler.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/handler/PropertyHandler.js ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";


/* eslint-disable no-unused-vars */

/**
 * Encapsulates getter/setter behavior. (e.g., set only once etc.).
 *
 * @abstract
 */
class PropertyHandler {
  /**
   * @param {*} obj - The object to set.
   * @return {boolean} {@code true} if the object was set, {@code false} otherwise.
   */
  set(obj) {}

  /**
   * @return {*} - The object that was set. (Note that object might also be set in the constructor of an impl class).
   */
  get() {}
}

module.exports = PropertyHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/handler/ReadOnlyPropertyHandler.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/handler/ReadOnlyPropertyHandler.js ***!
  \***************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const PropertyHandler = __webpack_require__(/*! ./PropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/PropertyHandler.js")

/**
 * A property handler for read-only properties (i.e., set always fails).
 */
class ReadOnlyPropertyHandler extends PropertyHandler {
  /**
   * @param {Logger} [logger]
   * @param {object} [obj] - The object to set.
   */
  constructor(logger, obj) {
    super()
    this._logger = logger
    this._obj = obj || null
  }

  /**
   * @inheritDoc
   */
  set(_obj) {
    // eslint-disable-line no-unused-vars
    this._logger.verbose('Ignored. (ReadOnlyPropertyHandler)')
    return false
  }

  /**
   * @inheritDoc
   */
  get() {
    return this._obj
  }
}

module.exports = ReadOnlyPropertyHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/handler/SimplePropertyHandler.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/handler/SimplePropertyHandler.js ***!
  \*************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const PropertyHandler = __webpack_require__(/*! ./PropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/PropertyHandler.js")

/**
 * A simple implementation of {@link PropertyHandler}. Allows get/set.
 */
class SimplePropertyHandler extends PropertyHandler {
  /**
   * @param {object} [obj] - The object to set.
   */
  constructor(obj) {
    super()
    this._obj = obj || null
  }

  /**
   * @inheritDoc
   */
  set(obj) {
    this._obj = obj
    return true
  }

  /**
   * @inheritDoc
   */
  get() {
    return this._obj
  }
}

module.exports = SimplePropertyHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/images/ImageDeltaCompressor.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/images/ImageDeltaCompressor.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];


const zlib = __webpack_require__(/*! zlib */ "./node_modules/browserify-zlib/lib/index.js")
const {WritableBufferStream} = __webpack_require__(/*! ../utils/StreamUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/StreamUtils.js")

const PREAMBLE = Buffer.from('applitools', 'utf8')
const COMPRESS_BY_RAW_BLOCKS_FORMAT = 3
const DEFLATE_BUFFER_RATE = 0.6

/**
 * @param {Buffer} pixels
 * @param {number} pixelLength
 * @return {Buffer}
 */
const rgbaToAbgrColors = (pixels, pixelLength) => {
  let r, g, b, a
  for (let offset = 0, {length} = pixels; offset < length; offset += pixelLength) {
    r = pixels[offset]
    g = pixels[offset + 1]
    b = pixels[offset + 2]
    a = pixels[offset + 3]

    pixels[offset] = a
    pixels[offset + 1] = b
    pixels[offset + 2] = g
    pixels[offset + 3] = r
  }
  return pixels
}

/**
 * Computes the width and height of the image data contained in the block at the input column and row.
 *
 * @param {{width: number, height: number}} imageSize - The image size in pixels.
 * @param {number} blockSize - The block size for which we would like to compute the image data width and height.
 * @param {number} blockColumn - The block column index
 * @param {number} blockRow - The block row index
 * @return {{width: number, height: number}} - The width and height of the image data contained in the block.
 */
const getActualBlockSize = (imageSize, blockSize, blockColumn, blockRow) => {
  const width = Math.min(imageSize.width - blockColumn * blockSize, blockSize)
  const height = Math.min(imageSize.height - blockRow * blockSize, blockSize)
  return {width, height}
}

/**
 * @param {Buffer} sourcePixels
 * @param {Buffer} targetPixels
 * @param {{width: number, height: number}} imageSize
 * @param {number} pixelLength
 * @param {number} blockSize
 * @param {number} blockColumn
 * @param {number} blockRow
 * @param {number} channel
 * @return {{isIdentical: boolean, buffer: Buffer}}
 */
const compareAndCopyBlockChannelData = (
  sourcePixels,
  targetPixels,
  imageSize,
  pixelLength,
  blockSize,
  blockColumn,
  blockRow,
  channel,
) => {
  let isIdentical = true // initial default

  // Getting the actual amount of data in the block we wish to copy
  const actualBlockSize = getActualBlockSize(imageSize, blockSize, blockColumn, blockRow)

  const actualBlockHeight = actualBlockSize.height
  const actualBlockWidth = actualBlockSize.width

  const stride = imageSize.width * pixelLength

  // The number of bytes actually contained in the block for the current channel (might be less
  // than blockSize*blockSize)
  const channelBytes = Buffer.alloc(actualBlockHeight * actualBlockWidth)
  let channelBytesOffset = 0

  // Actually comparing and copying the pixels
  let sourceByte, targetByte
  for (let h = 0; h < actualBlockHeight; h += 1) {
    let offset = (blockSize * blockRow + h) * stride + blockSize * blockColumn * pixelLength + channel
    for (let w = 0; w < actualBlockWidth; w += 1) {
      sourceByte = sourcePixels[offset]
      targetByte = targetPixels[offset]
      if (sourceByte !== targetByte) {
        isIdentical = false
      }

      channelBytes[channelBytesOffset] = targetByte
      channelBytesOffset += 1
      offset += pixelLength
    }
  }

  return {
    isIdentical,
    buffer: channelBytes,
  }
}

/**
 * Provides image compression based on delta between consecutive images
 */
class ImageDeltaCompressor {
  /**
   * Compresses a target image based on a difference from a source image.
   *
   * @param {Image|png.Image} targetData - The image we want to compress.
   * @param {Buffer} targetBuffer - The image we want to compress in its png buffer representation.
   * @param {Image|png.Image} sourceData - The baseline image by which a compression will be performed.
   * @param {number} [blockSize=10] - How many pixels per block.
   * @return {Buffer} - The compression result.
   */
  static compressByRawBlocks(targetData, targetBuffer, sourceData, blockSize = 10) {
    // If there's no image to compare to, or the images are in different
    // sizes, we simply return the encoded target.
    if (
      !targetData ||
      !sourceData ||
      sourceData.width !== targetData.width ||
      sourceData.height !== targetData.height
    ) {
      return targetBuffer
    }

    // The number of bytes comprising a pixel (depends if there's an Alpha channel).
    // targetData.data[6] bits: 1 palette, 2 color, 4 alpha
    // IMPORTANT: png-async always return data in following format RGBA.
    const pixelLength = 4
    const imageSize = {width: targetData.width, height: targetData.height}

    // IMPORTANT: Notice that the pixel bytes are (A)BGR!
    const targetPixels = rgbaToAbgrColors(targetData.data, pixelLength)
    const sourcePixels = rgbaToAbgrColors(sourceData.data, pixelLength)

    // Calculating how many block columns and rows we've got.
    const blockColumnsCount = Math.trunc(targetData.width / blockSize + (targetData.width % blockSize === 0 ? 0 : 1))
    const blockRowsCount = Math.trunc(targetData.height / blockSize + (targetData.height % blockSize === 0 ? 0 : 1))

    // Writing the header
    const stream = new WritableBufferStream()
    const blocksStream = new WritableBufferStream()
    stream.write(PREAMBLE)
    stream.write(Buffer.from([COMPRESS_BY_RAW_BLOCKS_FORMAT]))

    // since we don't have a source ID, we write 0 length (Big endian).
    stream.writeShort(0)
    // Writing the block size (Big endian)
    stream.writeShort(blockSize)

    let compareResult
    for (let channel = 0; channel < 3; channel += 1) {
      // The image is RGB, so all that's left is to skip the Alpha channel if there is one.
      const actualChannelIndex = pixelLength === 4 ? channel + 1 : channel

      let blockNumber = 0
      for (let blockRow = 0; blockRow < blockRowsCount; blockRow += 1) {
        for (let blockColumn = 0; blockColumn < blockColumnsCount; blockColumn += 1) {
          compareResult = compareAndCopyBlockChannelData(
            sourcePixels,
            targetPixels,
            imageSize,
            pixelLength,
            blockSize,
            blockColumn,
            blockRow,
            actualChannelIndex,
          )

          if (!compareResult.isIdentical) {
            blocksStream.writeByte(channel)
            blocksStream.writeInt(blockNumber)
            blocksStream.write(compareResult.buffer)

            // If the number of bytes already written is greater then the number of bytes for the
            // uncompressed target, we just return the uncompressed target.
            // NOTE: we need take in account that it will be compressed at the end by zlib
            if (
              stream.getBuffer().length + blocksStream.getBuffer().length * DEFLATE_BUFFER_RATE >
              targetBuffer.length
            ) {
              return targetBuffer
            }
          }

          blockNumber += 1
        }
      }
    }

    const blocksBuffer = zlib.deflateRawSync(blocksStream.getBuffer(), {
      level: zlib.Z_BEST_COMPRESSION,
    })
    stream.write(blocksBuffer)

    if (stream.getBuffer().length > targetBuffer.length) {
      return targetBuffer
    }

    return stream.getBuffer()
  }
}

module.exports = ImageDeltaCompressor


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/ConsoleLogHandler.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/ConsoleLogHandler.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const LogHandler = __webpack_require__(/*! ./LogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js")

/**
 * Write log messages to the browser/node console
 */
class ConsoleLogHandler extends LogHandler {
  /**
   * Handle a message to be logged.
   *
   * @override
   * @param {boolean} verbose - is the message verbose
   * @param {string} logString
   */
  onMessage(verbose, logString) {
    if (!verbose || this.getIsVerbose()) {
      console.log(logString) // eslint-disable-line no-console
    }
  }
}

module.exports = ConsoleLogHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/DebugLogHandler.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/DebugLogHandler.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const debug = __webpack_require__(/*! debug */ "./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/browser.js")

const LogHandler = __webpack_require__(/*! ./LogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js")

/**
 * Write log messages to the browser/node console
 */
class DebugLogHandler extends LogHandler {
  /**
   * @param {boolean} [isVerbose=false] - Whether to handle or ignore verbose log messages.
   * @param {string} [appName] - The app name to use
   * @param {object} [debugInstance] - Another instance which should be extended
   */
  constructor(isVerbose = false, appName, debugInstance) {
    super(isVerbose)

    this._debug = debugInstance || debug(appName || 'eyes')
  }

  /**
   * Handle a message to be logged.
   *
   * @override
   * @param {boolean} verbose - is the message verbose
   * @param {string} logString
   */
  onMessage(verbose, logString) {
    if (!verbose || this.getIsVerbose()) {
      this._debug(logString)
    }
  }

  /**
   * @param {string} name
   * @return {DebugLogHandler}
   */
  extend(name) {
    return new DebugLogHandler(this.getIsVerbose(), undefined, this._debug.extend(name))
  }
}

module.exports = DebugLogHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/FileLogHandler.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/FileLogHandler.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js")
const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js")
const os = __webpack_require__(/*! os */ "./node_modules/os-browserify/browser.js")

const LogHandler = __webpack_require__(/*! ./LogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js")

/**
 * @private
 * @param {string} filename
 */
function ensureDirectoryExistence(filename) {
  const dirname = path.dirname(filename)
  if (!fs.existsSync(dirname)) {
    ensureDirectoryExistence(dirname)
    fs.mkdirSync(dirname)
  }
}

/**
 * Write log messages to the browser/node console
 */
class FileLogHandler extends LogHandler {
  /**
   * @param {boolean} isVerbose - Whether to handle or ignore verbose log messages.
   * @param {string} [filename] - The file in which to save the logs.
   * @param {boolean} [append=true] - Whether to append the logs to existing file, or to overwrite the existing file.
   */
  constructor(isVerbose, filename = 'eyes.log', append = true) {
    super(isVerbose)

    this._filename = filename
    this._append = append
  }

  /**
   * Create a file logger
   *
   * @override
   */
  open() {
    this.close()

    const file = path.normalize(this._filename)
    const opts = {
      flags: this._append ? 'a' : 'w',
      encoding: 'utf8',
    }

    ensureDirectoryExistence(file)
    this._writer = fs.createWriteStream(file, opts)
  }

  /**
   * Close the file logger
   *
   * @override
   */
  close() {
    if (this._writer) {
      this._writer.end()
      this._writer = undefined
    }
  }

  /**
   * Handle a message to be logged.
   *
   * @override
   * @param {boolean} verbose - Whether this message is flagged as verbose or not.
   * @param {string} logString - The string to log.
   */
  onMessage(verbose, logString) {
    if (this._writer && (!verbose || this.getIsVerbose())) {
      this._writer.write(logString + os.EOL)
    }
  }
}

module.exports = FileLogHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogEvent.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/LogEvent.js ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";

/**
 * @typedef {'Info'|'Notice'|'Warn'|'Error'} LogLevel
 */

/**
 * @typedef {{timestamp: string, level: LogLevel, event: {type: string, ...data: object}}} LogEvent
 */

/**
 *
 * @param {LogLevel} level
 * @param {string} type
 * @param {object} data
 * @return {LogEvent}
 */
function LogEvent({level = 'Info', type, ...data}) {
  return {timestamp: new Date().toISOString(), level, event: {type, ...data}}
}

module.exports = LogEvent


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";


/**
 * Handles log messages produces by the Eyes API.
 *
 * @abstract
 */
class LogHandler {
  /**
   * @param {boolean} [isVerbose=false] - Whether to handle or ignore verbose log messages.
   */
  constructor(isVerbose = false) {
    this.setIsVerbose(isVerbose)
  }

  /**
   * Whether to handle or ignore verbose log messages.
   *
   * @param {boolean} isVerbose
   */
  setIsVerbose(isVerbose) {
    this._isVerbose = !!isVerbose
  }

  /**
   * Whether to handle or ignore verbose log messages.
   *
   * @return {boolean} - isVerbose
   */
  getIsVerbose() {
    return this._isVerbose
  }

  open() {}

  close() {}

  /**
   * @param {boolean} verbose
   * @param {string} logString
   */
  onMessage(verbose, logString) {} // eslint-disable-line no-unused-vars
}

module.exports = LogHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const makeLogger = __webpack_require__(/*! @applitools/logger */ "./node_modules/@applitools/logger/index.js")
const stackTrace = __webpack_require__(/*! stack-trace */ "./node_modules/stack-trace/lib/stack-trace.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")
const PerformanceUtils = __webpack_require__(/*! ../utils/PerformanceUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js")
const NullLogHandler = __webpack_require__(/*! ./NullLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/NullLogHandler.js")
const ConsoleLogHandler = __webpack_require__(/*! ./ConsoleLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/ConsoleLogHandler.js")
const FileLogHandler = __webpack_require__(/*! ./FileLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/FileLogHandler.js")
const DebugLogHandler = __webpack_require__(/*! ./DebugLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/DebugLogHandler.js")

const timeStorage = PerformanceUtils.start()

/**
 * Write log messages using the provided Log Handler
 */
class Logger {
  /**
   * @param {boolean|string} [showLogs] - Determines which log handler will be used. If set to {@code true}, then
   *   `ConsoleLogHandler` will be used, if not set or set to {@code false} then `DebugLogHandler` used.
   * @param {string} [debugAppName] - If using `DebugLogHandler` then this is the debug app name.
   */
  constructor(showLogs = false, debugAppName) {
    if (TypeUtils.isString(showLogs)) {
      showLogs = showLogs === 'true'
    }

    ArgumentGuard.isBoolean(showLogs, 'showLogs')
    ArgumentGuard.isString(debugAppName, 'debugAppName', false)

    this._logHandler = showLogs ? new ConsoleLogHandler(true) : new DebugLogHandler(true, debugAppName)
    this._sessionId = ''
    this._isIncludeTime = false
  }

  /**
   * @param {string} sessionId
   */
  setSessionId(sessionId) {
    this._sessionId = sessionId
  }

  /**
   * @param {boolean} isIncludeTime
   */
  setIncludeTime(isIncludeTime) {
    this._isIncludeTime = isIncludeTime
  }

  /**
   * @return {LogHandler} - The currently set log handler.
   */
  getLogHandler() {
    return this._logHandler
  }

  /**
   * @param {LogHandler} [handler] - The log handler to set. If you want a log handler which does nothing, use
   *   {@link NullLogHandler}.
   */
  setLogHandler(handler) {
    this._logHandler = handler || new NullLogHandler()
  }

  _getNewLogger() {
    return makeLogger({
      handler:
        this._logHandler instanceof FileLogHandler
          ? {type: 'file', filename: this._logHandler._filename, append: true}
          : {type: 'console'},
      level: this._logHandler instanceof NullLogHandler || this._logHandler.getIsVerbose() ? 'silent' : 'info',
    })
  }

  /**
   * @param {string} name
   * @return {Logger}
   */
  extend(name) {
    const newLogger = new Logger()
    const handler = this._logHandler.extend ? this._logHandler.extend(name) : this._logHandler
    newLogger.setLogHandler(handler)
    newLogger.setIncludeTime(this._isIncludeTime)
    newLogger.setSessionId(this._sessionId)
    return newLogger
  }

  /**
   * Writes a verbose write message.
   *
   * @param {*} args
   */
  verbose(...args) {
    this._logHandler.onMessage(true, this._getFormattedString('VERBOSE', GeneralUtils.stringify(...args)))
  }

  /**
   * Writes a (non-verbose) write message.
   *
   * @param {*} args
   */
  log(...args) {
    this._logHandler.onMessage(false, this._getFormattedString('LOG    ', GeneralUtils.stringify(...args)))
  }

  /**
   * @private
   * @return {string} - The name of the method which called the logger, if possible, or an empty string.
   */
  _getFormattedString(logLevel, message) {
    const dateTime = DateTimeUtils.toISO8601DateTime()

    let elapsedTime = ''
    if (this._isIncludeTime) {
      elapsedTime = `${timeStorage.end().time} ms. `
      timeStorage.start()
    }

    return `${dateTime} Eyes: [${logLevel}] {${this._sessionId}} ${this._getMethodName()}${elapsedTime}${message}`
  }

  /**
   * @private
   * @return {string} - The name of the method which called the logger, if possible, or an empty string.
   */
  _getMethodName() {
    if (typeof Error.captureStackTrace === 'function') {
      /**
       * @typedef CallSite
       * @prop {function(): string} getTypeName returns the type of this as a string.
       * @prop {function(): string} getFunctionName returns the name of the current function, typically its name property.
       * @prop {function(): string} getMethodName returns the name of the property of this or one of its prototypes that holds the current function
       * @prop {function(): string} getFileName if this function was defined in a script returns the name of the script
       * @prop {function(): number} getLineNumber if this function was defined in a script returns the current line number
       * @prop {function(): number} getColumnNumber if this function was defined in a script returns the current column number
       * @prop {function(): boolean} isNative is this call in native V8 code?
       */

      /** @type {CallSite[]} */
      const trace = stackTrace.get()

      // _getMethodName() <- _getFormattedString <- log()/verbose() <- "actual caller"
      if (trace && trace.length >= 3) {
        const className = trace[3].getTypeName()
        const methodName = trace[3].getMethodName()
        return className ? `${className}.${methodName || '<init>'}(): ` : '(): '
      }
    }

    return ''
  }
}

module.exports = Logger


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/NullLogHandler.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/NullLogHandler.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const LogHandler = __webpack_require__(/*! ./LogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogHandler.js")

/**
 * Ignores all log messages.
 */
class NullLogHandler extends LogHandler {}

module.exports = NullLogHandler


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/logging/RunnerStartedEvent.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/logging/RunnerStartedEvent.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const LogEvent = __webpack_require__(/*! ./LogEvent */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/LogEvent.js")

function RunnerStartedEvent({concurrency, testConcurrency, defaultConcurrency}) {
  return LogEvent({
    level: 'Notice',
    type: 'runnerStarted',
    concurrency,
    testConcurrency,
    defaultConcurrency,
    node: {version: process.version, platform: process.platform, arch: process.arch},
  })
}

module.exports = RunnerStartedEvent


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/match/AppOutput.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/match/AppOutput.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const Location = __webpack_require__(/*! ../geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")

/**
 * An application output (title, image, etc).
 *
 * @ignore
 */
class AppOutput {
  /**
   * @param {object} output
   * @param {string} output.title - The title of the screen of the application being captured.
   * @param {Buffer} [output.screenshot] - Base64 encoding of the screenshot's bytes (the byte can be in either in compressed
   *   or uncompressed form)
   * @param {string} [output.screenshotUrl] - The URL that points to the screenshot
   * @param {string} [output.domUrl] - URL that points to a dom capture of the provided screenshot
   * @param {Location} [output.imageLocation] - Location of the provided screenshot relative to the logical full-page
   *   screenshot (e.g. in checkRegion)
   */
  constructor({title, screenshot, screenshotUrl, domUrl, imageLocation} = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    this._title = title
    this._screenshot64 = screenshot
    this._screenshotUrl = screenshotUrl
    this._domUrl = domUrl
    this._imageLocation = new Location(imageLocation)
  }

  /**
   * @return {string}
   */
  getTitle() {
    return this._title
  }

  /**
   * @param {string} value
   */
  setTitle(value) {
    this._title = value
  }

  /**
   * @return {Buffer}
   */
  getScreenshot64() {
    return this._screenshot64
  }

  /**
   * @param {Buffer} value
   */
  setScreenshot64(value) {
    this._screenshot64 = value
  }

  /**
   * @return {string}
   */
  getScreenshotUrl() {
    return this._screenshotUrl
  }

  /**
   * @param {string} value
   */
  setScreenshotUrl(value) {
    this._screenshotUrl = value
  }

  /**
   * @return {string}
   */
  getDomUrl() {
    return this._domUrl
  }

  /**
   * @param {string} value
   */
  setDomUrl(value) {
    this._domUrl = value
  }

  /**
   * @return {Location}
   */
  getImageLocation() {
    return this._imageLocation
  }

  /**
   * @param {Location} value
   */
  setImageLocation(value) {
    this._imageLocation = value
  }

  /**
   * @override
   */
  toJSON() {
    const object = {
      title: this._title,
    }

    if (this._screenshot64) {
      object.screenshot64 = this._screenshot64
    }

    if (this._screenshotUrl) {
      object.screenshotUrl = this._screenshotUrl
    }

    if (this._domUrl) {
      object.domUrl = this._domUrl
    }

    if (this._imageLocation) {
      object.location = this._imageLocation.toJSON()
    }

    return object
  }

  /**
   * @override
   */
  toString() {
    const object = this.toJSON()

    if (object.screenshot64) {
      object.screenshot64 = 'REMOVED_FROM_OUTPUT'
    }

    return `AppOutput { ${object} }`
  }
}

module.exports = AppOutput


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/match/ImageMatchOptions.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/match/ImageMatchOptions.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * Encapsulates the "Options" section of the MatchExpectedOutput body data.
 */
class ImageMatchOptions {
  /**
   * @param options
   * @param {string} options.name - The tag of the window to be matched.
   * @param {string} options.renderId - The render ID of the screenshot to match.
   * @param {Trigger[]} options.userInputs - A list of triggers between the previous matchWindow call and the current matchWindow
   *   call. Can be array of size 0, but MUST NOT be null.
   * @param {boolean} options.ignoreMismatch - Tells the server whether or not to store a mismatch for the current window as
   *   window in the session.
   * @param {boolean} options.ignoreMatch - Tells the server whether or not to store a match for the current window as window in
   *   the session.
   * @param {boolean} options.forceMismatch - Forces the server to skip the comparison process and mark the current window as a
   *   mismatch.
   * @param {boolean} options.forceMatch - Forces the server to skip the comparison process and mark the current window as a
   *   match.
   * @param {ImageMatchSettings} options.imageMatchSettings - Settings specifying how the server should compare the image.
   * @param {string} options.source
   */
  constructor({
    name,
    renderId,
    userInputs,
    ignoreMismatch,
    ignoreMatch,
    forceMismatch,
    forceMatch,
    imageMatchSettings,
    source,
    variantId,
  } = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    ArgumentGuard.notNull(userInputs, 'userInputs')

    this._name = name
    this._renderId = renderId
    this._userInputs = userInputs
    this._ignoreMismatch = ignoreMismatch
    this._ignoreMatch = ignoreMatch
    this._forceMismatch = forceMismatch
    this._forceMatch = forceMatch
    this._imageMatchSettings = imageMatchSettings
    this._source = source
    this._variantId = variantId
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @return {string}
   */
  getRenderId() {
    return this._renderId
  }

  /**
   * @return {Trigger[]}
   */
  getUserInputs() {
    return this._userInputs
  }

  /**
   * @return {boolean}
   */
  getIgnoreMismatch() {
    return this._ignoreMismatch
  }

  /**
   * @return {boolean}
   */
  getIgnoreMatch() {
    return this._ignoreMatch
  }

  /**
   * @return {boolean}
   */
  getForceMismatch() {
    return this._forceMismatch
  }

  /**
   * @return {boolean}
   */
  getForceMatch() {
    return this._forceMatch
  }

  /**
   * @return {ImageMatchSettings}
   */
  getImageMatchSettings() {
    return this._imageMatchSettings
  }

  /**
   * @return {string}
   */
  getSource() {
    return this._source
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `Options { ${JSON.stringify(this)} }`
  }
}

module.exports = ImageMatchOptions


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * The result of a window match by the agent.
 */
class MatchResult {
  /**
   * @param {object} result
   * @param {boolean} [result.asExpected]
   * @param {number} [result.windowId]
   */
  constructor({asExpected, windowId} = {}) {
    this._asExpected = asExpected
    this._windowId = windowId
  }

  /**
   * @return {boolean}
   */
  getAsExpected() {
    return this._asExpected
  }

  /**
   * @param {boolean} value
   */
  setAsExpected(value) {
    this._asExpected = value
  }

  /**
   * @return {number}
   */
  getWindowId() {
    return this._windowId
  }

  /**
   * @param {number} value
   */
  setWindowId(value) {
    this._windowId = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `MatchResult { ${JSON.stringify(this)} }`
  }
}

module.exports = MatchResult


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowAndCloseData.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowAndCloseData.js ***!
  \*************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const MatchWindowData = __webpack_require__(/*! ./MatchWindowData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js")

/**
 * Encapsulates the data to be sent to the agent on a "matchWindow" command.
 *
 * @ignore
 */
class MatchWindowAndCloseData extends MatchWindowData {
  /**
   * @param {Trigger[]} userInputs - A list of triggers between the previous matchWindow call and the current matchWindow
   *   call. Can be array of size 0, but MUST NOT be null.
   * @param {AppOutput} appOutput - The appOutput for the current matchWindow call.
   * @param {string} tag - The tag of the window to be matched.
   * @param {boolean} [ignoreMismatch]
   * @param {Options} [options]
   */
  constructor({
    userInputs,
    appOutput,
    tag,
    ignoreMismatch,
    options,
    updateBaselineIfDifferent,
    updateBaselineIfNew,
    removeSessionIfMatching,
  } = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    super({userInputs, appOutput, tag, ignoreMismatch, options})

    this._updateBaselineIfDifferent = updateBaselineIfDifferent
    this._updateBaselineIfNew = updateBaselineIfNew
    this._removeSession = false
    this._removeSessionIfMatching = removeSessionIfMatching
    /** @type {string} */
    this._agentId = undefined
  }

  /**
   * @return {SessionStartInfo}
   */
  getStartInfo() {
    return this._startInfo
  }

  /**
   * @param {SessionStartInfo} startInfo
   */
  setStartInfo(startInfo) {
    this._startInfo = startInfo
  }

  /**
   * @return {boolean}
   */
  getUpdateBaseline() {
    return this._updateBaseline
  }

  /**
   * @param {boolean} updateBaseline
   */
  setUpdateBaseline(updateBaseline) {
    this._updateBaseline = updateBaseline
  }

  /**
   * @return {boolean}
   */
  getUpdateBaselineIfDifferent() {
    return this._updateBaselineIfDifferent
  }

  /**
   * @param {boolean} updateBaselineIfDifferent
   */
  setUpdateBaselineIfDifferent(updateBaselineIfDifferent) {
    this._updateBaselineIfDifferent = updateBaselineIfDifferent
  }

  /**
   * @return {boolean}
   */
  getUpdateBaselineIfNew() {
    return this._updateBaselineIfNew
  }

  /**
   * @param {boolean} updateBaselineIfNew
   */
  setUpdateBaselineIfNew(updateBaselineIfNew) {
    this._updateBaselineIfNew = updateBaselineIfNew
  }

  /**
   * @return {boolean}
   */
  getRemoveSession() {
    return this._removeSession
  }

  /**
   * @param {boolean} removeSession
   */
  setRemoveSession(removeSession) {
    this._removeSession = removeSession
  }

  /**
   * @return {boolean}
   */
  getRemoveSessionIfMatching() {
    return this._removeSessionIfMatching
  }

  /**
   * @param {boolean} removeSessionIfMatching
   */
  setRemoveSessionIfMatching(removeSessionIfMatching) {
    this._removeSessionIfMatching = removeSessionIfMatching
  }

  /**
   * @return {string}
   */
  getAgentId() {
    return this._agentId
  }

  /**
   * @param {string} agentId
   */
  setAgentId(agentId) {
    this._agentId = agentId
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    const object = this.toJSON()

    if (object.appOutput.screenshot64) {
      object.appOutput.screenshot64 = 'REMOVED_FROM_OUTPUT'
    }

    return `MatchWindowAndCloseData { ${JSON.stringify(object)} }`
  }
}

module.exports = MatchWindowAndCloseData


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * Encapsulates the data to be sent to the agent on a "matchWindow" command.
 */
class MatchWindowData {
  /**
   * @param data
   * @param {Trigger[]} data.userInputs - A list of triggers between the previous matchWindow call and the current matchWindow
   *   call. Can be array of size 0, but MUST NOT be null.
   * @param {AppOutput} data.appOutput - The appOutput for the current matchWindow call.
   * @param {string} data.tag - The tag of the window to be matched.
   * @param {boolean} [data.ignoreMismatch]
   * @param {Options} [data.options]
   */
  constructor({userInputs, appOutput, tag, ignoreMismatch, options} = {}) {
    if (arguments.length > 1) {
      throw new TypeError('Please, use object as a parameter to the constructor!')
    }

    ArgumentGuard.notNull(appOutput, 'appOutput')

    this._userInputs = userInputs
    this._appOutput = appOutput
    this._tag = tag
    this._ignoreMismatch = ignoreMismatch
    this._options = options
  }

  /**
   * @return {Trigger[]}
   */
  getUserInputs() {
    return this._userInputs
  }

  /**
   * @return {AppOutput}
   */
  getAppOutput() {
    return this._appOutput
  }

  /**
   * @return {string}
   */
  getTag() {
    return this._tag
  }

  /**
   * @return {?boolean}
   */
  getIgnoreMismatch() {
    return this._ignoreMismatch
  }

  /**
   * @return {?Options}
   */
  getOptions() {
    return this._options
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    const object = this.toJSON()

    if (object.appOutput.screenshot64) {
      object.appOutput.screenshot64 = 'REMOVED_FROM_OUTPUT'
    }

    return `MatchWindowData { ${JSON.stringify(object)} }`
  }
}

module.exports = MatchWindowData


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ActualAppOutput.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/ActualAppOutput.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")

const ImageMatchSettings = __webpack_require__(/*! ./ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ImageMatchSettings.js")
const Image = __webpack_require__(/*! ./Image */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Image.js")

class ActualAppOutput {
  /**
   * @param output
   * @param {Image|object} output.image
   * @param {Image|object} output.thumbprint
   * @param {ImageMatchSettings|object} output.imageMatchSettings
   * @param {boolean} output.ignoreExpectedOutputSettings
   * @param {boolean} output.isMatching
   * @param {boolean} output.areImagesMatching
   * @param {Date|string} output.occurredAt
   * @param {object[]} output.userInputs
   * @param {string} output.windowTitle
   * @param {string} output.tag
   * @param {boolean} output.isPrimary
   */
  constructor({
    image,
    thumbprint,
    imageMatchSettings,
    ignoreExpectedOutputSettings,
    isMatching,
    areImagesMatching,
    occurredAt,
    userInputs,
    windowTitle,
    tag,
    isPrimary,
  } = {}) {
    if (image && !(image instanceof Image)) {
      image = new Image(image)
    }

    if (thumbprint && !(thumbprint instanceof Image)) {
      thumbprint = new Image(thumbprint)
    }

    if (imageMatchSettings && !(imageMatchSettings instanceof ImageMatchSettings)) {
      imageMatchSettings = new ImageMatchSettings(imageMatchSettings)
    }

    if (occurredAt && !(occurredAt instanceof Date)) {
      occurredAt = DateTimeUtils.fromISO8601DateTime(occurredAt)
    }

    this._image = image
    this._thumbprint = thumbprint
    this._imageMatchSettings = imageMatchSettings
    this._ignoreExpectedOutputSettings = ignoreExpectedOutputSettings
    this._isMatching = isMatching
    this._areImagesMatching = areImagesMatching
    this._occurredAt = occurredAt
    this._userInputs = userInputs
    this._windowTitle = windowTitle
    this._tag = tag
    this._isPrimary = isPrimary
  }

  /**
   * @return {Image}
   */
  getImage() {
    return this._image
  }

  /**
   * @param {Image} value
   */
  setImage(value) {
    this._image = value
  }

  /**
   * @return {Image}
   */
  getThumbprint() {
    return this._thumbprint
  }

  /**
   * @param {Image} value
   */
  setThumbprint(value) {
    this._thumbprint = value
  }

  /**
   * @return {ImageMatchSettings}
   */
  getImageMatchSettings() {
    return this._imageMatchSettings
  }

  /**
   * @param {ImageMatchSettings} value
   */
  setImageMatchSettings(value) {
    this._imageMatchSettings = value
  }

  /**
   * @return {boolean}
   */
  getIgnoreExpectedOutputSettings() {
    return this._ignoreExpectedOutputSettings
  }

  /**
   * @param {boolean} value
   */
  setIgnoreExpectedOutputSettings(value) {
    this._ignoreExpectedOutputSettings = value
  }

  /**
   * @return {boolean}
   */
  getIsMatching() {
    return this._isMatching
  }

  /**
   * @param {boolean} value
   */
  setIsMatching(value) {
    this._isMatching = value
  }

  /**
   * @return {boolean}
   */
  getAreImagesMatching() {
    return this._areImagesMatching
  }

  /**
   * @param {boolean} value
   */
  setAreImagesMatching(value) {
    this._areImagesMatching = value
  }

  /**
   * @return {Date}
   */
  getOccurredAt() {
    return this._occurredAt
  }

  /**
   * @param {Date} value
   */
  setOccurredAt(value) {
    this._occurredAt = value
  }

  /**
   * @return {object[]}
   */
  getUserInputs() {
    return this._userInputs
  }

  /**
   * @param {object[]} value
   */
  setUserInputs(value) {
    this._userInputs = value
  }

  /**
   * @return {string}
   */
  getWindowTitle() {
    return this._windowTitle
  }

  /**
   * @param {string} value
   */
  setWindowTitle(value) {
    this._windowTitle = value
  }

  /**
   * @return {string}
   */
  getTag() {
    return this._tag
  }

  /**
   * @param {string} value
   */
  setTag(value) {
    this._tag = value
  }

  /**
   * @return {boolean}
   */
  getIsPrimary() {
    return this._isPrimary
  }

  /**
   * @param {boolean} value
   */
  setIsPrimary(value) {
    this._isPrimary = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `ActualAppOutput { ${JSON.stringify(this)} }`
  }
}

module.exports = ActualAppOutput


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Annotations.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/Annotations.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const FloatingMatchSettings = __webpack_require__(/*! ../config/FloatingMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js")

class Annotations {
  /**
   * @param regions
   * @param {FloatingMatchSettings[]|object[]} regions.floating
   * @param {Region[]|object[]} regions.ignore
   * @param {Region[]|object[]} regions.strict
   * @param {Region[]|object[]} regions.content
   * @param {Region[]|object[]} regions.layout
   */
  constructor({floating, ignore, strict, content, layout} = {}) {
    if (ignore && ignore.length > 0 && !(ignore[0] instanceof Region)) {
      ignore = ignore.map(region => new Region(region))
    }

    if (strict && strict.length > 0 && !(strict[0] instanceof Region)) {
      strict = strict.map(region => new Region(region))
    }

    if (content && content.length > 0 && !(content[0] instanceof Region)) {
      content = content.map(region => new Region(region))
    }

    if (layout && layout.length > 0 && !(layout[0] instanceof Region)) {
      layout = layout.map(region => new Region(region))
    }

    if (floating && floating.length > 0 && !(floating[0] instanceof FloatingMatchSettings)) {
      floating = floating.map(region => new FloatingMatchSettings(region))
    }

    this._floating = floating
    this._ignore = ignore
    this._strict = strict
    this._content = content
    this._layout = layout
  }

  /**
   * @return {FloatingMatchSettings[]}
   */
  getFloating() {
    return this._floating
  }

  /**
   * @param {FloatingMatchSettings[]} value
   */
  setFloating(value) {
    this._floating = value
  }

  /**
   * @return {Region[]}
   */
  getIgnore() {
    return this._ignore
  }

  /**
   * @param {Region[]} value
   */
  setIgnore(value) {
    this._ignore = value
  }

  /**
   * @return {Region[]}
   */
  getStrict() {
    return this._strict
  }

  /**
   * @param {Region[]} value
   */
  setStrict(value) {
    this._strict = value
  }

  /**
   * @return {Region[]}
   */
  getContent() {
    return this._content
  }

  /**
   * @param {Region[]} value
   */
  setContent(value) {
    this._content = value
  }

  /**
   * @return {Region[]}
   */
  getLayout() {
    return this._layout
  }

  /**
   * @param {Region[]} value
   */
  setLayout(value) {
    this._layout = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `Annotations { ${JSON.stringify(this)} }`
  }
}

module.exports = Annotations


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/BatchInfo.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/BatchInfo.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")

class BatchInfo {
  /**
   * @param info
   * @param {string} info.id
   * @param {string} info.name
   * @param {Date|string} info.startedAt
   * @param {array} info.properties
   */
  constructor({id, name, startedAt, properties} = {}) {
    if (startedAt && !(startedAt instanceof Date)) {
      startedAt = DateTimeUtils.fromISO8601DateTime(startedAt)
    }

    this._id = id
    this._name = name
    this._startedAt = startedAt
    this._properties = properties
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} value
   */
  setName(value) {
    this._name = value
  }

  /**
   * @return {Date}
   */
  getStartedAt() {
    return this._startedAt
  }

  /**
   * @param {Date} value
   */
  setStartedAt(value) {
    this._startedAt = value
  }

  /**
   * @return {array}
   */
  getProperties() {
    return this._properties
  }

  /**
   * @param {array} value
   */
  setProperties(value) {
    this._properties = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `BatchInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = BatchInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Branch.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/Branch.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

class Branch {
  /**
   * @param data
   * @param {string} data.id
   * @param {string} data.name
   * @param {boolean} data.isDeleted
   * @param {object} data.updateInfo - TODO: add typed `updateInfo`
   */
  constructor({id, name, isDeleted, updateInfo} = {}) {
    this._id = id
    this._name = name
    this._isDeleted = isDeleted
    this._updateInfo = updateInfo
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {string}
   */
  getName() {
    return this._name
  }

  /**
   * @param {string} value
   */
  setName(value) {
    this._name = value
  }

  /**
   * @return {boolean}
   */
  getIsDeleted() {
    return this._isDeleted
  }

  /**
   * @param {boolean} value
   */
  setIsDeleted(value) {
    this._isDeleted = value
  }

  /**
   * @return {object}
   */
  getUpdateInfo() {
    return this._updateInfo
  }

  /**
   * @param {object} value
   */
  setUpdateInfo(value) {
    this._updateInfo = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `Branch { ${JSON.stringify(this)} }`
  }
}

module.exports = Branch


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ExpectedAppOutput.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/ExpectedAppOutput.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")

const Annotations = __webpack_require__(/*! ./Annotations */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Annotations.js")
const Image = __webpack_require__(/*! ./Image */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Image.js")

class ExpectedAppOutput {
  /**
   * @param output
   * @param {string} output.tag
   * @param {Image|object} output.image
   * @param {Image|object} output.thumbprint
   * @param {Date|string} output.occurredAt
   * @param {Annotations|object} output.annotations
   */
  constructor({tag, image, thumbprint, occurredAt, annotations} = {}) {
    if (image && !(image instanceof Image)) {
      image = new Image(image)
    }

    if (thumbprint && !(thumbprint instanceof Image)) {
      thumbprint = new Image(thumbprint)
    }

    if (annotations && !(annotations instanceof Annotations)) {
      annotations = new Annotations(annotations)
    }

    if (occurredAt && !(occurredAt instanceof Date)) {
      occurredAt = DateTimeUtils.fromISO8601DateTime(occurredAt)
    }

    this._tag = tag
    this._image = image
    this._thumbprint = thumbprint
    this._occurredAt = occurredAt
    this._annotations = annotations
  }

  /**
   * @return {string}
   */
  getTag() {
    return this._tag
  }

  /**
   * @param {string} value
   */
  setTag(value) {
    this._tag = value
  }

  /**
   * @return {Image}
   */
  getImage() {
    return this._image
  }

  /**
   * @param {Image} value
   */
  setImage(value) {
    this._image = value
  }

  /**
   * @return {Image}
   */
  getThumbprint() {
    return this._thumbprint
  }

  /**
   * @param {Image} value
   */
  setThumbprint(value) {
    this._thumbprint = value
  }

  /**
   * @return {Date}
   */
  getOccurredAt() {
    return this._occurredAt
  }

  /**
   * @param {Date} value
   */
  setOccurredAt(value) {
    this._occurredAt = value
  }

  /**
   * @return {Annotations}
   */
  getAnnotations() {
    return this._annotations
  }

  /**
   * @param {Annotations} value
   */
  setAnnotations(value) {
    this._annotations = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `ExpectedAppOutput { ${JSON.stringify(this)} }`
  }
}

module.exports = ExpectedAppOutput


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Image.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/Image.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const RectangleSize = __webpack_require__(/*! ../geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")

class Image {
  /**
   * @param data
   * @param {string} data.id
   * @param {RectangleSize|object} data.size
   * @param {boolean} data.hasDom
   */
  constructor({id, size, hasDom} = {}) {
    if (size && !(size instanceof RectangleSize)) {
      size = new RectangleSize(size)
    }

    this._id = id
    this._size = size
    // this._rectangle = size;
    // this._location = size;
    this._hasDom = hasDom
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {RectangleSize}
   */
  getSize() {
    return this._size
  }

  /**
   * @param {RectangleSize} value
   */
  setSize(value) {
    this._size = value
  }

  /**
   * @return {boolean}
   */
  getHasDom() {
    return this._hasDom
  }

  /**
   * @param {boolean} value
   */
  setHasDom(value) {
    this._hasDom = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `Image { ${JSON.stringify(this)} }`
  }
}

module.exports = Image


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ImageMatchSettings.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/ImageMatchSettings.js ***!
  \***********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const FloatingMatchSettings = __webpack_require__(/*! ../config/FloatingMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/FloatingMatchSettings.js")

class ImageMatchSettings {
  /**
   * @param {MatchLevel|string} matchLevel
   * @param {number} ignoreCaret
   * @param {Region[]|object[]} ignore
   * @param {Region[]|object[]} strict
   * @param {Region[]|object[]} content
   * @param {Region[]|object[]} layout
   * @param {FloatingMatchSettings[]|object[]} floating
   *
   * @param {number} splitTopHeight
   * @param {number} splitBottomHeight
   * @param {number} scale
   * @param {number} remainder
   */
  constructor({
    matchLevel,
    ignore,
    strict,
    content,
    layout,
    floating,
    splitTopHeight,
    splitBottomHeight,
    ignoreCaret,
    scale,
    remainder,
  } = {}) {
    if (ignore && ignore.length > 0 && !(ignore[0] instanceof Region)) {
      ignore = ignore.map(region => new Region(region))
    }

    if (strict && strict.length > 0 && !(strict[0] instanceof Region)) {
      strict = strict.map(region => new Region(region))
    }

    if (content && content.length > 0 && !(content[0] instanceof Region)) {
      content = content.map(region => new Region(region))
    }

    if (layout && layout.length > 0 && !(layout[0] instanceof Region)) {
      layout = layout.map(region => new Region(region))
    }

    if (floating && floating.length > 0 && !(floating[0] instanceof FloatingMatchSettings)) {
      floating = floating.map(region => new FloatingMatchSettings(region))
    }

    this._matchLevel = matchLevel
    this._ignore = ignore
    this._strict = strict
    this._content = content
    this._layout = layout
    this._floating = floating
    this._splitTopHeight = splitTopHeight
    this._splitBottomHeight = splitBottomHeight
    this._ignoreCaret = ignoreCaret
    this._scale = scale
    this._remainder = remainder
  }

  /**
   * @return {MatchLevel}
   */
  getMatchLevel() {
    return this._matchLevel
  }

  /**
   * @param {MatchLevel} value
   */
  setMatchLevel(value) {
    this._matchLevel = value
  }

  /**
   * @return {Region[]}
   */
  getIgnore() {
    return this._ignore
  }

  /**
   * @param {Region[]} value
   */
  setIgnore(value) {
    this._ignore = value
  }

  /**
   * @return {Region[]}
   */
  getStrict() {
    return this._strict
  }

  /**
   * @param {Region[]} value
   */
  setStrict(value) {
    this._strict = value
  }

  /**
   * @return {Region[]}
   */
  getContent() {
    return this._content
  }

  /**
   * @param {Region[]} value
   */
  setContent(value) {
    this._content = value
  }

  /**
   * @return {Region[]}
   */
  getLayout() {
    return this._layout
  }

  /**
   * @param {Region[]} value
   */
  setLayout(value) {
    this._layout = value
  }

  /**
   * @return {FloatingMatchSettings[]}
   */
  getFloating() {
    return this._floating
  }

  /**
   * @param {FloatingMatchSettings[]} value
   */
  setFloating(value) {
    this._floating = value
  }

  /**
   * @return {number}
   */
  getSplitTopHeight() {
    return this._splitTopHeight
  }

  /**
   * @param {number} value
   */
  setSplitTopHeight(value) {
    this._splitTopHeight = value
  }

  /**
   * @return {number}
   */
  getSplitBottomHeight() {
    return this._splitBottomHeight
  }

  /**
   * @param {number} value
   */
  setSplitBottomHeight(value) {
    this._splitBottomHeight = value
  }

  /**
   * @return {boolean}
   */
  getIgnoreCaret() {
    return this._ignoreCaret
  }

  /**
   * @param {boolean} value
   */
  setIgnoreCaret(value) {
    this._ignoreCaret = value
  }

  /**
   * @return {number}
   */
  getScale() {
    return this._scale
  }

  /**
   * @param {number} value
   */
  setScale(value) {
    this._scale = value
  }

  /**
   * @return {number}
   */
  getRemainder() {
    return this._remainder
  }

  /**
   * @param {number} value
   */
  setRemainder(value) {
    this._remainder = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `ImageMatchSettings { ${JSON.stringify(this)} }`
  }
}

module.exports = ImageMatchSettings


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/SessionResults.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/SessionResults.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ActualAppOutput = __webpack_require__(/*! ./ActualAppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ActualAppOutput.js")
const ExpectedAppOutput = __webpack_require__(/*! ./ExpectedAppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ExpectedAppOutput.js")
const Branch = __webpack_require__(/*! ./Branch */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/Branch.js")
const StartInfo = __webpack_require__(/*! ./StartInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/StartInfo.js")
const AppEnvironment = __webpack_require__(/*! ../AppEnvironment */ "./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js")

class SessionResults {
  /**
   * @param data
   * @param {string} data.id
   * @param {number} data.revision
   * @param {string} data.runningSessionId
   * @param {boolean} data.isAborted
   * @param {boolean} data.isStarred
   * @param {StartInfo|object} data.startInfo
   * @param {string} data.batchId
   * @param {string} data.secretToken
   * @param {string} data.state
   * @param {string} data.status
   * @param {string} data.isDefaultStatus
   * @param {string} data.startedAt
   * @param {number} data.duration
   * @param {boolean} data.isDifferent
   * @param {AppEnvironment|object} data.env
   * @param {Branch|object} data.branch
   * @param {ExpectedAppOutput[]|object[]} data.expectedAppOutput
   * @param {ActualAppOutput[]|object[]} data.actualAppOutput
   * @param {string} data.baselineId
   * @param {string} data.baselineRevId
   * @param {string} data.scenarioId
   * @param {string} data.scenarioName
   * @param {string} data.appId
   * @param {string} data.baselineModelId
   * @param {string} data.baselineEnvId
   * @param {AppEnvironment|object} data.baselineEnv
   * @param {string} data.appName
   * @param {string} data.baselineBranchName
   * @param {boolean} data.isNew
   */
  constructor({
    id,
    revision,
    runningSessionId,
    isAborted,
    isStarred,
    startInfo,
    batchId,
    secretToken,
    state,
    status,
    isDefaultStatus,
    startedAt,
    duration,
    isDifferent,
    env,
    branch,
    expectedAppOutput,
    actualAppOutput,
    baselineId,
    baselineRevId,
    scenarioId,
    scenarioName,
    appId,
    baselineModelId,
    baselineEnvId,
    baselineEnv,
    appName,
    baselineBranchName,
    isNew,
  } = {}) {
    if (env && !(env instanceof AppEnvironment)) {
      env = new AppEnvironment(env)
    }

    if (baselineEnv && !(baselineEnv instanceof AppEnvironment)) {
      baselineEnv = new AppEnvironment(baselineEnv)
    }

    if (branch && !(branch instanceof Branch)) {
      branch = new Branch(branch)
    }

    if (startInfo && !(startInfo instanceof StartInfo)) {
      startInfo = new StartInfo(startInfo)
    }

    if (actualAppOutput && actualAppOutput.length > 0 && !(actualAppOutput[0] instanceof ActualAppOutput)) {
      actualAppOutput = actualAppOutput.map(output => new ActualAppOutput(output))
    }

    if (
      expectedAppOutput &&
      expectedAppOutput.length > 0 &&
      !!expectedAppOutput[0] &&
      !(expectedAppOutput[0] instanceof ExpectedAppOutput)
    ) {
      expectedAppOutput = expectedAppOutput.map(output => new ExpectedAppOutput(output))
    }

    this._id = id
    this._revision = revision
    this._runningSessionId = runningSessionId
    this._isAborted = isAborted
    this._isStarred = isStarred
    this._startInfo = startInfo
    this._batchId = batchId
    this._secretToken = secretToken
    this._state = state
    this._status = status
    this._isDefaultStatus = isDefaultStatus
    this._startedAt = startedAt
    this._duration = duration
    this._isDifferent = isDifferent
    this._env = env
    this._branch = branch
    this._expectedAppOutput = expectedAppOutput
    this._actualAppOutput = actualAppOutput
    this._baselineId = baselineId
    this._baselineRevId = baselineRevId
    this._scenarioId = scenarioId
    this._scenarioName = scenarioName
    this._appId = appId
    this._baselineModelId = baselineModelId
    this._baselineEnvId = baselineEnvId
    this._baselineEnv = baselineEnv
    this._appName = appName
    this._baselineBranchName = baselineBranchName
    this._isNew = isNew
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {number}
   */
  getRevision() {
    return this._revision
  }

  /**
   * @param {number} value
   */
  setRevision(value) {
    this._revision = value
  }

  /**
   * @return {string}
   */
  getRunningSessionId() {
    return this._runningSessionId
  }

  /**
   * @param {string} value
   */
  setRunningSessionId(value) {
    this._runningSessionId = value
  }

  /**
   * @return {boolean}
   */
  getIsAborted() {
    return this._isAborted
  }

  /**
   * @param {boolean} value
   */
  setIsAborted(value) {
    this._isAborted = value
  }

  /**
   * @return {boolean}
   */
  getIsStarred() {
    return this._isStarred
  }

  /**
   * @param {boolean} value
   */
  setIsStarred(value) {
    this._isStarred = value
  }

  /**
   * @return {StartInfo}
   */
  getStartInfo() {
    return this._startInfo
  }

  /**
   * @param {StartInfo} value
   */
  setStartInfo(value) {
    this._startInfo = value
  }

  /**
   * @return {string}
   */
  getBatchId() {
    return this._batchId
  }

  /**
   * @param {string} value
   */
  setBatchId(value) {
    this._batchId = value
  }

  /**
   * @return {string}
   */
  getSecretToken() {
    return this._secretToken
  }

  /**
   * @param {string} value
   */
  setSecretToken(value) {
    this._secretToken = value
  }

  /**
   * @return {string}
   */
  getState() {
    return this._state
  }

  /**
   * @param {string} value
   */
  setState(value) {
    this._state = value
  }

  /**
   * @return {string}
   */
  getStatus() {
    return this._status
  }

  /**
   * @param {string} value
   */
  setStatus(value) {
    this._status = value
  }

  /**
   * @return {boolean}
   */
  getIsDefaultStatus() {
    return this._isDefaultStatus
  }

  /**
   * @param {boolean} value
   */
  setIsDefaultStatus(value) {
    this._isDefaultStatus = value
  }

  /**
   * @return {string}
   */
  getStartedAt() {
    return this._startedAt
  }

  /**
   * @param {string} value
   */
  setStartedAt(value) {
    this._startedAt = value
  }

  /**
   * @return {number}
   */
  getDuration() {
    return this._duration
  }

  /**
   * @param {number} value
   */
  setDuration(value) {
    this._duration = value
  }

  /**
   * @return {boolean}
   */
  getIsDifferent() {
    return this._isDifferent
  }

  /**
   * @param {boolean} value
   */
  setIsDifferent(value) {
    this._isDifferent = value
  }

  /**
   * @return {AppEnvironment}
   */
  getEnv() {
    return this._env
  }

  /**
   * @param {AppEnvironment} value
   */
  setEnv(value) {
    this._env = value
  }

  /**
   * @return {Branch}
   */
  getBranch() {
    return this._branch
  }

  /**
   * @param {Branch} value
   */
  setBranch(value) {
    this._branch = value
  }

  /**
   * @return {ExpectedAppOutput[]}
   */
  getExpectedAppOutput() {
    return this._expectedAppOutput
  }

  /**
   * @param {ExpectedAppOutput[]} value
   */
  setExpectedAppOutput(value) {
    this._expectedAppOutput = value
  }

  /**
   * @return {ActualAppOutput[]}
   */
  getActualAppOutput() {
    return this._actualAppOutput
  }

  /**
   * @param {ActualAppOutput[]} value
   */
  setActualAppOutput(value) {
    this._actualAppOutput = value
  }

  /**
   * @return {string}
   */
  getBaselineId() {
    return this._baselineId
  }

  /**
   * @param {string} value
   */
  setBaselineId(value) {
    this._baselineId = value
  }

  /**
   * @return {string}
   */
  getBaselineRevId() {
    return this._baselineRevId
  }

  /**
   * @param {string} value
   */
  setBaselineRevId(value) {
    this._baselineRevId = value
  }

  /**
   * @return {string}
   */
  getScenarioId() {
    return this._scenarioId
  }

  /**
   * @param {string} value
   */
  setScenarioId(value) {
    this._scenarioId = value
  }

  /**
   * @return {string}
   */
  getScenarioName() {
    return this._scenarioName
  }

  /**
   * @param {string} value
   */
  setScenarioName(value) {
    this._scenarioName = value
  }

  /**
   * @return {string}
   */
  getAppId() {
    return this._appId
  }

  /**
   * @param {string} value
   */
  setAppId(value) {
    this._appId = value
  }

  /**
   * @return {string}
   */
  getBaselineModelId() {
    return this._baselineModelId
  }

  /**
   * @param {string} value
   */
  setBaselineModelId(value) {
    this._baselineModelId = value
  }

  /**
   * @return {string}
   */
  getBaselineEnvId() {
    return this._baselineEnvId
  }

  /**
   * @param {string} value
   */
  setBaselineEnvId(value) {
    this._baselineEnvId = value
  }

  /**
   * @return {AppEnvironment}
   */
  getBaselineEnv() {
    return this._baselineEnv
  }

  /**
   * @param {AppEnvironment} value
   */
  setBaselineEnv(value) {
    this._baselineEnv = value
  }

  /**
   * @return {string}
   */
  getAppName() {
    return this._appName
  }

  /**
   * @param {string} value
   */
  setAppName(value) {
    this._appName = value
  }

  /**
   * @return {string}
   */
  getBaselineBranchName() {
    return this._baselineBranchName
  }

  /**
   * @param {string} value
   */
  setBaselineBranchName(value) {
    this._baselineBranchName = value
  }

  /**
   * @return {boolean}
   */
  getIsNew() {
    return this._isNew
  }

  /**
   * @param {boolean} value
   */
  setIsNew(value) {
    this._isNew = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `SessionResults { ${JSON.stringify(this)} }`
  }
}

module.exports = SessionResults


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/StartInfo.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/metadata/StartInfo.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ImageMatchSettings = __webpack_require__(/*! ./ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/ImageMatchSettings.js")
const BatchInfo = __webpack_require__(/*! ./BatchInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/metadata/BatchInfo.js")
const AppEnvironment = __webpack_require__(/*! ../AppEnvironment */ "./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js")

class StartInfo {
  /**
   * @param info
   * @param {string} info.sessionType
   * @param {boolean} info.isTransient
   * @param {boolean} info.ignoreBaseline
   * @param {string} info.appIdOrName
   * @param {boolean} info.compareWithParentBranch
   * @param {string} info.scenarioIdOrName
   * @param {string} info.displayName
   * @param {BatchInfo|object} info.batchInfo
   * @param {AppEnvironment|object} info.environment
   * @param {MatchLevel|string} info.matchLevel
   * @param {ImageMatchSettings|object} info.defaultMatchSettings
   * @param {string} info.agentId
   * @param {object[]} info.properties
   * @param {boolean} info.render
   */
  constructor({
    sessionType,
    isTransient,
    ignoreBaseline,
    appIdOrName,
    compareWithParentBranch,
    scenarioIdOrName,
    displayName,
    batchInfo,
    environment,
    matchLevel,
    defaultMatchSettings,
    agentId,
    properties,
    render,
  } = {}) {
    if (batchInfo && !(batchInfo instanceof BatchInfo)) {
      batchInfo = new BatchInfo(batchInfo)
    }

    if (defaultMatchSettings && !(defaultMatchSettings instanceof ImageMatchSettings)) {
      defaultMatchSettings = new ImageMatchSettings(defaultMatchSettings)
    }

    if (environment && !(environment instanceof AppEnvironment)) {
      environment = new AppEnvironment(environment)
    }

    this._sessionType = sessionType
    this._isTransient = isTransient
    this._ignoreBaseline = ignoreBaseline
    this._appIdOrName = appIdOrName
    this._compareWithParentBranch = compareWithParentBranch
    this._scenarioIdOrName = scenarioIdOrName
    this._displayName = displayName
    this._batchInfo = batchInfo
    this._environment = environment
    this._matchLevel = matchLevel
    this._defaultMatchSettings = defaultMatchSettings
    this._agentId = agentId
    this._properties = properties
    this._render = render
  }

  /**
   * @return {string}
   */
  getSessionType() {
    return this._sessionType
  }

  /**
   * @param {string} value
   */
  setSessionType(value) {
    this._sessionType = value
  }

  /**
   * @return {boolean}
   */
  getIsTransient() {
    return this._isTransient
  }

  /**
   * @param {boolean} value
   */
  setIsTransient(value) {
    this._isTransient = value
  }

  /**
   * @return {boolean}
   */
  getIgnoreBaseline() {
    return this._ignoreBaseline
  }

  /**
   * @param {boolean} value
   */
  setIgnoreBaseline(value) {
    this._ignoreBaseline = value
  }

  /**
   * @return {string}
   */
  getAppIdOrName() {
    return this._appIdOrName
  }

  /**
   * @param {string} value
   */
  setAppIdOrName(value) {
    this._appIdOrName = value
  }

  /**
   * @return {boolean}
   */
  getCompareWithParentBranch() {
    return this._compareWithParentBranch
  }

  /**
   * @param {boolean} value
   */
  setCompareWithParentBranch(value) {
    this._compareWithParentBranch = value
  }

  /**
   * @return {string}
   */
  getScenarioIdOrName() {
    return this._scenarioIdOrName
  }

  /**
   * @param {string} value
   */
  setScenarioIdOrName(value) {
    this._scenarioIdOrName = value
  }

  /**
   * @return {string}
   */
  getDisplayName() {
    return this._displayName
  }

  /**
   * @param {string} value
   */
  setDisplayName(value) {
    this._displayName = value
  }

  /**
   * @return {BatchInfo}
   */
  getBatchInfo() {
    return this._batchInfo
  }

  /**
   * @param {BatchInfo} value
   */
  setBatchInfo(value) {
    this._batchInfo = value
  }

  /**
   * @return {AppEnvironment}
   */
  getEnvironment() {
    return this._environment
  }

  /**
   * @param {AppEnvironment} value
   */
  setEnvironment(value) {
    this._environment = value
  }

  /**
   * @return {string}
   */
  getMatchLevel() {
    return this._matchLevel
  }

  /**
   * @param {string} value
   */
  setMatchLevel(value) {
    this._matchLevel = value
  }

  /**
   * @return {ImageMatchSettings}
   */
  getDefaultMatchSettings() {
    return this._defaultMatchSettings
  }

  /**
   * @param {ImageMatchSettings} value
   */
  setDefaultMatchSettings(value) {
    this._defaultMatchSettings = value
  }

  /**
   * @return {string}
   */
  getAgentId() {
    return this._agentId
  }

  /**
   * @param {string} value
   */
  setAgentId(value) {
    this._agentId = value
  }

  /**
   * @return {object[]}
   */
  getProperties() {
    return this._properties
  }

  /**
   * @param {object[]} value
   */
  setProperties(value) {
    this._properties = value
  }

  /**
   * @return {boolean}
   */
  getRender() {
    return this._render
  }

  /**
   * @param {boolean} value
   */
  setRender(value) {
    this._render = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `StartInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = StartInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/abort.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/abort.js ***!
  \*****************************************************************/
/***/ ((module) => {

function makeAbort({eyes}) {
  return async function abort() {
    let results = await eyes.abort()

    if (!results) return []

    return results.map(result => (result ? result.toJSON() : null))
  }
}

module.exports = makeAbort


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/check.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/check.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const MatchResult = __webpack_require__(/*! ../match/MatchResult */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js")

function makeCheck({eyes}) {
  return async function check({settings, config} = {}) {
    if (config) eyes._configuration.mergeConfig(config)
    const result = await eyes.check(settings)
    return result ? result.toJSON() : new MatchResult().toJSON()
  }
}

module.exports = makeCheck


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/close-all-eyes.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/close-all-eyes.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const DiffsFoundError = __webpack_require__(/*! ../errors/DiffsFoundError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js")
const NewTestError = __webpack_require__(/*! ../errors/NewTestError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js")
const TestFailedError = __webpack_require__(/*! ../errors/TestFailedError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js")

function makeCloseAllEyes({runner}) {
  return async function closeAllEyes({throwErr = false} = {}) {
    const results = await runner.getAllTestResults()
    results.forEach(result => {
      if (throwErr) {
        if (result.status === 'Unresolved') {
          if (result.isNew) throw new NewTestError(result)
          else throw new DiffsFoundError(result)
        } else if (result.status === 'Failed') {
          throw new TestFailedError(result)
        }
      }
    })

    return results
  }
}

module.exports = makeCloseAllEyes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/close-batches.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/close-batches.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const closeBatch = __webpack_require__(/*! ../close/closeBatch */ "./node_modules/@applitools/eyes-sdk-core/lib/close/closeBatch.js")

function makeCloseBatches() {
  return function closeBatches(options) {
    return closeBatch(options)
  }
}

module.exports = makeCloseBatches


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/close.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/close.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const DiffsFoundError = __webpack_require__(/*! ../errors/DiffsFoundError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js")
const NewTestError = __webpack_require__(/*! ../errors/NewTestError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js")
const TestFailedError = __webpack_require__(/*! ../errors/TestFailedError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js")

function makeClose({eyes}) {
  return async function close({throwErr = false} = {}) {
    let results = await eyes.close()

    results.forEach(result => {
      if (throwErr) {
        if (result.status === 'Unresolved') {
          if (result.isNew) throw new NewTestError(result)
          else throw new DiffsFoundError(result)
        } else if (result.status === 'Failed') {
          throw new TestFailedError(result)
        }
      }
    })

    return results
  }
}

module.exports = makeClose


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/delete-test.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/delete-test.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");
const Logger = __webpack_require__(/*! ../logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")
const ServerConnector = __webpack_require__(/*! ../server/ServerConnector */ "./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js")
const Configuration = __webpack_require__(/*! ../config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")
const TestResults = __webpack_require__(/*! ../TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")

function makeDeleteTestResults() {
  return async function deleteTestResults({testId, batchId, secretToken, serverUrl, apiKey, proxy}) {
    const serverConnector = new ServerConnector({
      logger: new Logger(!!process.env.APPLITOOLS_SHOW_LOGS),
      configuration: new Configuration({serverUrl, apiKey, proxy}),
      getAgentId: () => '',
    })

    await serverConnector.deleteSession(new TestResults({id: testId, batchId, secretToken}))
  }
}

module.exports = makeDeleteTestResults


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text-regions.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text-regions.js ***!
  \********************************************************************************/
/***/ ((module) => {

function makeExtractTextRegions({eyes}) {
  return async function extractTextRegions({settings, config}) {
    if (config) eyes._configuration.mergeConfig(config)
    return eyes.extractTextRegions(settings)
  }
}

module.exports = makeExtractTextRegions


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text.js ***!
  \************************************************************************/
/***/ ((module) => {

function makeExtractText({eyes}) {
  return async function extractText({regions, config}) {
    if (config) eyes._configuration.mergeConfig(config)
    return eyes.extractText(regions)
  }
}

module.exports = makeExtractText


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/get-viewport-size.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/get-viewport-size.js ***!
  \*****************************************************************************/
/***/ ((module) => {

function makeGetViewportSize(sdk) {
  return function getViewportSize({driver}) {
    return sdk.EyesFactory.getViewportSize(driver)
  }
}

module.exports = makeGetViewportSize


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/locate.js":
/*!******************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/locate.js ***!
  \******************************************************************/
/***/ ((module) => {

function makeLocate({eyes}) {
  return async function locate({settings, config}) {
    if (config) eyes._configuration.mergeConfig(config)
    return eyes.locate(settings)
  }
}

module.exports = makeLocate


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/make-manager.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/make-manager.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const VisualGridRunner = __webpack_require__(/*! ../runner/VisualGridRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js")
const ClassicRunner = __webpack_require__(/*! ../runner/ClassicRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js")

const makeOpenEyes = __webpack_require__(/*! ./open-eyes */ "./node_modules/@applitools/eyes-sdk-core/lib/new/open-eyes.js")
const makeCloseAllEyes = __webpack_require__(/*! ./close-all-eyes */ "./node_modules/@applitools/eyes-sdk-core/lib/new/close-all-eyes.js")

function makeMakeManager(sdk) {
  return function makeManager({type, concurrency, legacy} = {}) {
    const runner =
      type === 'vg' ? new VisualGridRunner(legacy ? concurrency : {testConcurrency: concurrency}) : new ClassicRunner()

    return {
      openEyes: makeOpenEyes({sdk, runner}),
      closeAllEyes: makeCloseAllEyes({sdk, runner}),
    }
  }
}

module.exports = makeMakeManager


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/open-eyes.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/open-eyes.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const SessionEventHandler = __webpack_require__(/*! ../events/SessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandler.js")
const RemoteSessionEventHandler = __webpack_require__(/*! ../events/RemoteSessionEventHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/events/RemoteSessionEventHandler.js")

const makeCheck = __webpack_require__(/*! ./check */ "./node_modules/@applitools/eyes-sdk-core/lib/new/check.js")
const makeLocate = __webpack_require__(/*! ./locate */ "./node_modules/@applitools/eyes-sdk-core/lib/new/locate.js")
const makeExtractText = __webpack_require__(/*! ./extract-text */ "./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text.js")
const makeExtractTextRegions = __webpack_require__(/*! ./extract-text-regions */ "./node_modules/@applitools/eyes-sdk-core/lib/new/extract-text-regions.js")
const makeClose = __webpack_require__(/*! ./close */ "./node_modules/@applitools/eyes-sdk-core/lib/new/close.js")
const makeAbort = __webpack_require__(/*! ./abort */ "./node_modules/@applitools/eyes-sdk-core/lib/new/abort.js")
const ConsoleLogHandler = __webpack_require__(/*! ../logging/ConsoleLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/ConsoleLogHandler.js")
const FileLogHandler = __webpack_require__(/*! ../logging/FileLogHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/FileLogHandler.js")

function makeOpenEyes({sdk, runner}) {
  return async function openEyes({driver, config, on}) {
    const eyes = new sdk.EyesFactory(runner)
    eyes.setConfiguration(config)
    if (config.scrollRootElement) eyes.setScrollRootElement(config.scrollRootElement)
    if (config.cut) eyes.setCut(config.cut)
    if (config.rotation) eyes.setRotation(config.rotation)
    if (config.scaleRatio) eyes.setScaleRatio(config.scaleRatio)
    if (config.logs) {
      if (config.logs.type === 'console') {
        eyes.setLogHandler(new ConsoleLogHandler(true))
      } else if (config.logs.type === 'file') {
        eyes.setLogHandler(new FileLogHandler(true, config.logs.filename, config.logs.append))
      }
    }
    if (config.debugScreenshots) eyes.setDebugScreenshots(config.debugScreenshots)
    if (config.remoteEvents) {
      const remoteSessionEventHandler = new RemoteSessionEventHandler(
        config.remoteEvents.serverUrl,
        config.remoteEvents.accessKey,
      )
      if (config.remoteEvents.timeout !== undefined) {
        remoteSessionEventHandler.setTimeout(config.remoteEvents.timeout)
      }
      eyes.addSessionEventHandler(remoteSessionEventHandler)
    }
    if (on) {
      const sessionEventHandler = new SessionEventHandler()
      for (const event of Object.keys(sessionEventHandler)) {
        sessionEventHandler[event] = (...args) => on(event, ...args)
      }
      eyes.addSessionEventHandler(sessionEventHandler)
    }

    await eyes.open(driver, config.appName, config.testName)

    return {
      check: makeCheck({eyes}),
      locate: makeLocate({eyes}),
      extractText: makeExtractText({eyes}),
      extractTextRegions: makeExtractTextRegions({eyes}),
      close: makeClose({eyes}),
      abort: makeAbort({eyes}),
    }
  }
}

module.exports = makeOpenEyes


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/sdk.js":
/*!***************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/sdk.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const EyesSDK = __webpack_require__(/*! ../sdk/EyesSDK */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesSDK.js")

const makeMakeManager = __webpack_require__(/*! ./make-manager */ "./node_modules/@applitools/eyes-sdk-core/lib/new/make-manager.js")
const makeGetViewportSize = __webpack_require__(/*! ./get-viewport-size */ "./node_modules/@applitools/eyes-sdk-core/lib/new/get-viewport-size.js")
const makeSetViewportSize = __webpack_require__(/*! ./set-viewport-size */ "./node_modules/@applitools/eyes-sdk-core/lib/new/set-viewport-size.js")
const makeCloseBatches = __webpack_require__(/*! ./close-batches */ "./node_modules/@applitools/eyes-sdk-core/lib/new/close-batches.js")
const makeDeleteTest = __webpack_require__(/*! ./delete-test */ "./node_modules/@applitools/eyes-sdk-core/lib/new/delete-test.js")

function makeSdk(options) {
  const sdk = EyesSDK(options)

  return {
    isDriver: options.spec.isDriver,
    isElement: options.spec.isElement,
    isSelector: options.spec.isSelector,
    makeManager: makeMakeManager(sdk),
    getViewportSize: makeGetViewportSize(sdk),
    setViewportSize: makeSetViewportSize(sdk),
    closeBatches: makeCloseBatches(sdk),
    deleteTest: makeDeleteTest(sdk),
  }
}

module.exports = makeSdk


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/new/set-viewport-size.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/new/set-viewport-size.js ***!
  \*****************************************************************************/
/***/ ((module) => {

function makeSetViewportSize(sdk) {
  return function setViewportSize({driver, size}) {
    return sdk.EyesFactory.setViewportSize(driver, size)
  }
}

module.exports = makeSetViewportSize


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationDevice.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationDevice.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

class EmulationDevice {
  /**
   * @param data
   * @param {number} data.width
   * @param {number} data.height
   * @param {string} data.deviceScaleFactor
   * @param {string} data.mobile
   */
  constructor({width, height, deviceScaleFactor, mobile} = {}) {
    this._width = width
    this._height = height
    this._deviceScaleFactor = deviceScaleFactor
    this._mobile = mobile
  }

  /**
   * @return {number}
   */
  getWidth() {
    return this._width
  }

  /**
   * @param {number} value
   */
  setWidth(value) {
    this._width = value
  }

  /**
   * @return {number}
   */
  getHeight() {
    return this._height
  }

  /**
   * @param {number} value
   */
  setHeight(value) {
    this._height = value
  }

  /**
   * @return {string}
   */
  getDeviceScaleFactor() {
    return this._deviceScaleFactor
  }

  /**
   * @param {string} value
   */
  setDeviceScaleFactor(value) {
    this._deviceScaleFactor = value
  }

  /**
   * @return {string}
   */
  getMobile() {
    return this._mobile
  }

  /**
   * @param {string} value
   */
  setMobile(value) {
    this._mobile = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `EmulationDevice { ${JSON.stringify(this)} }`
  }
}

module.exports = EmulationDevice


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationInfo.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationInfo.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const EmulationDevice = __webpack_require__(/*! ./EmulationDevice */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationDevice.js")

class EmulationInfo {
  /**
   * @param info
   * @param {EmulationDevice|object} info.device
   * @param {string} info.deviceName
   * @param {ScreenOrientation} info.screenOrientation
   */
  constructor({device, deviceName, screenOrientation} = {}) {
    if (device && !(device instanceof EmulationDevice)) {
      device = new EmulationDevice(device)
    }

    this._device = device
    this._deviceName = deviceName
    this._screenOrientation = screenOrientation
  }

  /**
   * @return {EmulationDevice}
   */
  getDevice() {
    return this._device
  }

  /**
   * @param {EmulationDevice} value
   */
  setDevice(value) {
    this._device = value
  }

  /**
   * @return {string}
   */
  getDeviceName() {
    return this._deviceName
  }

  /**
   * @param {string} value
   */
  setDeviceName(value) {
    this._deviceName = value
  }

  /**
   * @return {ScreenOrientation}
   */
  getScreenOrientation() {
    return this._screenOrientation
  }

  /**
   * @param {ScreenOrientation} value
   */
  setScreenOrientation(value) {
    this._screenOrientation = value
  }

  /**
   * @override
   */
  toJSON() {
    if (this._device) {
      return Object.assign(
        {
          screenOrientation: this._screenOrientation,
        },
        this._device.toJSON(),
      )
    }

    return GeneralUtils.toPlain(this, ['_device'])
  }

  /**
   * @override
   */
  toString() {
    return `EmulationInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = EmulationInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridDom.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridDom.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const crypto = __webpack_require__(/*! crypto */ "./node_modules/crypto-browserify/index.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const RGridResource = __webpack_require__(/*! ./RGridResource */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridResource.js")

class RGridDom {
  /**
   * @param data
   * @param {object} [data.domNodes]
   * @param {RGridResource[]} [data.resources]
   */
  constructor({domNodes, resources} = {}) {
    this._domNodes = domNodes
    this._resources = resources || []

    /** @type {string} */
    this._sha256hash = undefined
    /** @type {string} */
    this._contentAsCdt = undefined
  }

  /**
   * @return {object} - The domNodes of the current page.
   */
  getDomNodes() {
    return this._domNodes
  }

  /**
   * @param {object} value - The page's domNodes
   */
  setDomNodes(value) {
    ArgumentGuard.notNull(value, 'domNodes')
    this._domNodes = value
  }

  /**
   * @return {RGridResource[]} - The resourceType of the current page
   */
  getResources() {
    return this._resources
  }

  /**
   * @param {RGridResource[]} value - The page's resourceType
   */
  setResources(value) {
    ArgumentGuard.notNull(value, 'resources')
    this._resources = value
  }

  asResource() {
    const res = new RGridResource()
    res.setContent(this._getContentAsCdt())
    res.setContentType('x-applitools-html/cdt')
    return res
  }

  getSha256Hash() {
    if (!this._sha256hash) {
      this._sha256hash = crypto
        .createHash('sha256')
        .update(this._getContentAsCdt())
        .digest('hex')
    }

    return this._sha256hash
  }

  getHashAsObject() {
    return {
      hashFormat: 'sha256',
      hash: this.getSha256Hash(),
    }
  }

  _getContentAsCdt() {
    if (!this._contentAsCdt) {
      const resources = {}

      this._resources.forEach(resource => {
        resources[resource.getUrl()] = resource.getHashAsObject()
      })

      this._contentAsCdt = JSON.stringify({
        resources,
        domNodes: this._domNodes,
      })
    }

    return this._contentAsCdt
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, ['_contentAsCdt', '_sha256hash'])
  }

  /**
   * @override
   */
  toString() {
    return `RGridDom { ${JSON.stringify(this)} }`
  }
}

module.exports = RGridDom


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridResource.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridResource.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const crypto = __webpack_require__(/*! crypto */ "./node_modules/crypto-browserify/index.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

const VISUAL_GRID_MAX_BUFFER_SIZE = 15 * 1000000

class RGridResource {
  /**
   * @param data
   * @param {string} [data.url]
   * @param {string} [data.contentType]
   * @param {Buffer} [data.content]
   */
  constructor({url, contentType, content, errorStatusCode} = {}) {
    this._url = url
    this._contentType = contentType
    this._content = content
    this._errorStatusCode = errorStatusCode

    /** @type {string} */
    this._sha256hash = undefined

    this._trimContent()
  }

  /**
   * @return {string} - The url of the current resource.
   */
  getUrl() {
    return this._url
  }

  /**
   * @param {string} value - The resource's url
   */
  setUrl(value) {
    ArgumentGuard.notNull(value, 'url')
    this._url = value
  }

  /**
   * @return {string} - The contentType of the current resource.
   */
  getContentType() {
    return this._contentType
  }

  /**
   * @param {string} value - The resource's contentType
   */
  setContentType(value) {
    ArgumentGuard.notNull(value, 'contentType')
    this._contentType = value
  }

  /**
   * @return {Buffer} - The content of the current resource.
   */
  getContent() {
    return this._content
  }

  /**
   * @param {Buffer} value - The resource's content
   */
  setContent(value) {
    ArgumentGuard.notNull(value, this._url ? `content (of ${this._url})` : 'content')
    this._content = value
    this._sha256hash = undefined

    this._trimContent()
  }

  _trimContent() {
    if (this._content && this._content.length > VISUAL_GRID_MAX_BUFFER_SIZE) {
      this._content = this._content.slice(0, VISUAL_GRID_MAX_BUFFER_SIZE - 100000)
    }
  }

  getErrorStatusCode() {
    return this._errorStatusCode
  }

  setErrorStatusCode(errorStatusCode) {
    this._errorStatusCode = errorStatusCode
  }

  getSha256Hash() {
    if (!this._sha256hash) {
      this._sha256hash = crypto
        .createHash('sha256')
        .update(this._content)
        .digest('hex')
    }

    return this._sha256hash
  }

  // TODO: now that there's errorStatusCode, this function should be renamed to toPlainObject or prepareToSerialize or something
  getHashAsObject() {
    if (this._errorStatusCode) {
      return {errorStatusCode: this._errorStatusCode}
    } else {
      return {
        hashFormat: 'sha256',
        hash: this.getSha256Hash(),
        contentType: this.getContentType(),
      }
    }
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, ['_sha256hash'])
  }

  /**
   * @override
   */
  toString() {
    return `RGridResource { ${JSON.stringify(this)} }`
  }
}

module.exports = RGridResource


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderInfo.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderInfo.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

const EmulationInfo = __webpack_require__(/*! ./EmulationInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/EmulationInfo.js")

/**
 * @typedef {{iosDeviceInfo: {deviceName: IosDevieName, screenOrientation: (ScreenOrientation|undefined)})}} IosDeviceInfo
 */

class RenderInfo {
  /**
   * @param info
   * @param {number} info.width
   * @param {number} info.height
   * @param {string} info.sizeMode
   * @param {string} info.selector
   * @param {Region|object} info.region
   * @param {EmulationInfo|object} info.emulationInfo
   * @param {IosDeviceInfo} info.iosDeviceInfo
   */
  constructor({width, height, sizeMode, selector, region, emulationInfo, iosDeviceInfo} = {}) {
    if (region && !(region instanceof Region)) {
      region = new Region(region)
    }

    if (emulationInfo && !(emulationInfo instanceof EmulationInfo)) {
      emulationInfo = new EmulationInfo(emulationInfo)
    }

    this._width = width
    this._height = height
    this._sizeMode = sizeMode
    this._selector = selector
    this._region = region
    this._emulationInfo = emulationInfo
    this._iosDeviceInfo = iosDeviceInfo
  }

  /**
   * @param {RectangleSize} size
   * @param {string} [sizeMode='full-page'] supported values [viewport|full-page]
   * @return {RenderInfo}
   */
  static fromRectangleSize(size, sizeMode = 'full-page') {
    const renderInfo = new RenderInfo()
    renderInfo.setWidth(size.getWidth())
    renderInfo.setHeight(size.getHeight())
    renderInfo.setSizeMode(sizeMode)
    return renderInfo
  }

  /**
   * @return {number}
   */
  getWidth() {
    return this._width
  }

  /**
   * @param {number} value
   */
  setWidth(value) {
    this._width = value
  }

  /**
   * @return {number}
   */
  getHeight() {
    return this._height
  }

  /**
   * @param {number} value
   */
  setHeight(value) {
    this._height = value
  }

  /**
   * @return {string}
   */
  getSizeMode() {
    return this._sizeMode
  }

  /**
   * @param {string} value
   */
  setSizeMode(value) {
    this._sizeMode = value
  }

  /**
   * @return {string}
   */
  getSelector() {
    return this._selector
  }

  /**
   * @param {string} value
   */
  setSelector(value) {
    this._selector = value
  }

  /**
   * @return {Region}
   */
  getRegion() {
    return this._region
  }

  /**
   * @param {Region} value
   */
  setRegion(value) {
    this._region = value
  }

  /**
   * @return {EmulationInfo}
   */
  getEmulationInfo() {
    return this._emulationInfo
  }

  /**
   * @param {EmulationInfo} value
   */
  setEmulationInfo(value) {
    this._emulationInfo = value
  }

  getIosDeviceInfo() {
    return this._iosDeviceInfo
  }

  /**
   * @override
   */
  toJSON() {
    const obj = GeneralUtils.toPlain(this, ['_emulationInfo', '_iosDeviceInfo'])

    if (this._emulationInfo) {
      obj.emulationInfo = this._emulationInfo.toJSON()
    }

    if (this._iosDeviceInfo) {
      obj.iosDeviceInfo = GeneralUtils.toPlain(this._iosDeviceInfo, undefined, {
        deviceName: 'name',
        iosVersion: 'version',
      })
    }

    // TODO remove this when rendering-grid changes x/y to left/top
    if (obj.region) {
      obj.region.x = obj.region.left
      obj.region.y = obj.region.top
      delete obj.region.left
      delete obj.region.top
    }
    return obj
  }

  /**
   * @override
   */
  toString() {
    return `RenderInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = RenderInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderRequest.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderRequest.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";


/**
 * Encapsulates data required to start render using the RenderingGrid API.
 */
class RenderRequest {
  /**
   * @param request
   * @param {string} request.webhook
   * @param {string} request.url
   * @param {RGridDom} request.dom
   * @param {RGridResource[]} request.resources
   * @param {RenderInfo} [request.renderInfo]
   * @param {string} [request.platform]
   * @param {string} [request.browserName]
   * @param {Object} [request.scriptHooks]
   * @param {string[]} request.selectorsToFindRegionsFor
   * @param {boolean} request.sendDom
   * @param {string} request.renderId
   * @param {Object} request.visualGridOptions
   */
  constructor({
    webhook,
    stitchingService,
    url,
    dom,
    resources,
    renderInfo,
    platform,
    browserName,
    scriptHooks,
    selectorsToFindRegionsFor,
    sendDom,
    renderId,
    agentId,
    visualGridOptions,
    renderer,
  } = {}) {
    this._webhook = webhook
    this._stitchingService = stitchingService
    this._url = url
    this._dom = dom
    this._resources = resources
    this._renderInfo = renderInfo
    this._platform = platform
    this._browserName = browserName
    this._renderId = renderId
    this._scriptHooks = scriptHooks
    this._selectorsToFindRegionsFor = selectorsToFindRegionsFor
    this._sendDom = sendDom
    this._agentId = agentId
    this._visualGridOptions = visualGridOptions
    this._renderer = renderer
  }

  /**
   * @return {string}
   */
  getWebhook() {
    return this._webhook
  }

  /**
   * @return {string}
   */
  getStitchingService() {
    return this._stitchingService
  }

  /**
   * @return {string}
   */
  getUrl() {
    return this._url
  }

  /**
   * @return {RGridDom}
   */
  getDom() {
    return this._dom
  }

  /**
   * @return {RGridDom}
   */
  setDom(dom) {
    this._dom = dom
  }

  /**
   * @return {RGridResource[]}
   */
  getResources() {
    return this._resources
  }

  setResources(resources) {
    this._resources = resources
  }

  /**
   * @return {RenderInfo}
   */
  getRenderInfo() {
    return this._renderInfo
  }

  /**
   * @return {string}
   */
  getPlatform() {
    return this._platform
  }

  /**
   * @return {string}
   */
  getBrowserName() {
    return this._browserName
  }

  /**
   * @return {string}
   */
  getRenderId() {
    return this._renderId
  }

  /**
   * @return {string}
   */
  getAgentId() {
    return this._agentId
  }

  /**
   * @param {string} value
   */
  setAgentId(value) {
    this._agentId = value
  }

  /**
   * @param {string} value
   */
  setRenderId(value) {
    this._renderId = value
  }

  /**
   * @return {string}
   */
  getScriptHooks() {
    return this._scriptHooks
  }

  /**
   * @param {string} value
   */
  setScriptHooks(value) {
    this._scriptHooks = value
  }

  /**
   * @return {string[]}
   */
  getSelectorsToFindRegionsFor() {
    return this._selectorsToFindRegionsFor
  }

  /**
   * @param {string[]} value
   */
  setSelectorsToFindRegionsFor(value) {
    this._selectorsToFindRegionsFor = value
  }

  /**
   * @return {boolean}
   */
  getSendDom() {
    return this._sendDom
  }

  /**
   * @param {boolean} value
   */
  setSendDom(value) {
    this._sendDom = value
  }

  getVisualGridOptions() {
    return this._visualGridOptions
  }

  setVisualGridOptions(options) {
    this._visualGridOptions = options
  }

  getRenderer() {
    return this._renderer
  }

  setRenderer(renderer) {
    this._renderer = renderer
  }

  /**
   * @override
   */
  toJSON() {
    const resources = {}
    if (this.getResources()) {
      this.getResources().forEach(resource => {
        resources[resource.getUrl()] = resource.getHashAsObject()
      })
    }

    const object = {
      webhook: this._webhook,
      stitchingService: this._stitchingService,
      url: this._url,
      dom: this._dom ? this._dom.getHashAsObject() : null,
      resources: this._resources
        ? this._resources.reduce((resources, resource) => {
            return Object.assign(resources, {[resource.getUrl()]: resource.getHashAsObject()})
          }, {})
        : null,
      enableMultipleResultsPerSelector: true,
    }

    if (this._renderId) {
      object.renderId = this._renderId
    }

    if (this._agentId) {
      object.agentId = this._agentId
    }

    if (this._browserName) {
      object.browser = {
        name: this._browserName,
      }
    }

    if (this._platform) {
      object.platform = {
        name: this._platform,
      }
    }

    if (this._renderInfo) {
      object.renderInfo = this._renderInfo.toJSON()
    }

    if (this._scriptHooks) {
      object.scriptHooks = this._scriptHooks
    }

    if (this._selectorsToFindRegionsFor) {
      object.selectorsToFindRegionsFor = this._selectorsToFindRegionsFor
    }

    if (this._sendDom !== undefined) {
      object.sendDom = this._sendDom
    }

    if (this._visualGridOptions) {
      object.options = this._visualGridOptions
    }

    return object
  }

  /**
   * @override
   */
  toString() {
    return `RenderRequest { ${JSON.stringify(this)} }`
  }
}

module.exports = RenderRequest


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatus.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatus.js ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";


/**
 * @readonly
 * @enum {string}
 */
const RenderStatus = {
  /**
   * A rendering requires some additional resources
   */
  NEED_MORE_RESOURCES: 'need-more-resources',

  /**
   * A rendering is in process
   */
  RENDERING: 'rendering',

  /**
   * A rendering finished
   */
  RENDERED: 'rendered',

  /**
   * A rendering finished with an error
   */
  ERROR: 'error',
}

Object.freeze(RenderStatus)
module.exports = RenderStatus


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatusResults.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatusResults.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const RectangleSize = __webpack_require__(/*! ../geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

/**
 * Encapsulates data for the render currently running in the client.
 */
class RenderStatusResults {
  /**
   * @param {RenderStatus} status
   * @param {string} imageLocation
   * @param {string} domLocation
   * @param {string} error
   * @param {string} os
   * @param {string} userAgent
   * @param {RectangleSize|object} deviceSize
   * @param {object[][]} selectorRegions
   */
  constructor({
    status,
    imageLocation,
    domLocation,
    error,
    os,
    userAgent,
    deviceSize,
    selectorRegions,
    imagePositionInActiveFrame,
  } = {}) {
    if (deviceSize && !(deviceSize instanceof RectangleSize)) {
      deviceSize = new RectangleSize(deviceSize)
    }
    if (selectorRegions && selectorRegions.length > 0) {
      selectorRegions = selectorRegions.map(regions => {
        return regions.map(innerRegion => {
          return new Region({
            left: innerRegion.x,
            top: innerRegion.y,
            width: innerRegion.width,
            height: innerRegion.height,
            error: innerRegion.error,
          })
        })
      })
    }

    this._status = status
    this._imageLocation = imageLocation
    this._domLocation = domLocation
    this._error = error
    this._os = os
    this._userAgent = userAgent
    this._deviceSize = deviceSize
    this._selectorRegions = selectorRegions
    this._imagePositionInActiveFrame = imagePositionInActiveFrame
  }

  /**
   * @return {boolean}
   */
  isEmpty() {
    return (
      this._status === undefined &&
      this._imageLocation === undefined &&
      this._domLocation === undefined &&
      this._error === undefined &&
      this._os === undefined &&
      this._userAgent === undefined &&
      this._deviceSize === undefined &&
      this._selectorRegions === undefined
    )
  }

  /**
   * @return {RenderStatus}
   */
  getStatus() {
    return this._status
  }

  /**
   * @param {RenderStatus} value
   */
  setStatus(value) {
    this._status = value
  }

  /**
   * @return {string}
   */
  getImageLocation() {
    return this._imageLocation
  }

  /**
   * @param {string} value
   */
  setImageLocation(value) {
    this._imageLocation = value
  }

  /**
   * @return {string}
   */
  getDomLocation() {
    return this._domLocation
  }

  /**
   * @param {string} value
   */
  setDomLocation(value) {
    this._domLocation = value
  }

  /**
   * @return {string}
   */
  getError() {
    return this._error
  }

  /**
   * @param {string} value
   */
  setError(value) {
    this._error = value
  }

  /**
   * @return {string}
   */
  getOS() {
    return this._os
  }

  /**
   * @param {string} value
   */
  setOS(value) {
    this._os = value
  }

  /**
   * @return {string}
   */
  getUserAgent() {
    return this._userAgent
  }

  /**
   * @param {string} value
   */
  setUserAgent(value) {
    this._userAgent = value
  }

  /**
   * @return {RectangleSize}
   */
  getDeviceSize() {
    return this._deviceSize
  }

  /**
   * @param {RectangleSize} value
   */
  setDeviceSize(value) {
    this._deviceSize = value
  }

  /**
   * @return {Region[][]}
   */
  getSelectorRegions() {
    return this._selectorRegions
  }

  /**
   * @param {Region[][]} value
   */
  setSelectorRegions(value) {
    this._selectorRegions = value
  }

  /**
   * @return {Location}
   */
  imagePositionInActiveFrame() {
    return this._imagePositionInActiveFrame
  }

  /**
   * @param {Location} value
   */
  setImagePositionInActiveFrame(value) {
    this._imagePositionInActiveFrame = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `RenderStatusResults { ${JSON.stringify(this)} }`
  }
}

module.exports = RenderStatusResults


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RunningRender.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/renderer/RunningRender.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
/**
 * Encapsulates data for the render currently running in the client.
 */
class RunningRender {
  /**
   * @param data
   * @param {string} data.renderId
   * @param {string} data.jobId
   * @param {RenderStatus} data.renderStatus
   * @param {string[]} data.needMoreResources
   * @param {boolean} data.needMoreDom
   */
  constructor({renderId, jobId, renderStatus, needMoreResources, needMoreDom} = {}) {
    this._renderId = renderId
    this._jobId = jobId
    this._renderStatus = renderStatus
    this._needMoreResources = needMoreResources
    this._needMoreDom = needMoreDom
  }

  /**
   * @return {string}
   */
  getRenderId() {
    return this._renderId
  }

  /**
   * @param {string} value
   */
  setRenderId(value) {
    this._renderId = value
  }

  /**
   * @return {string}
   */
  getJobId() {
    return this._jobId
  }

  /**
   * @param {string} value
   */
  setJobId(value) {
    this._jobId = value
  }

  /**
   * @return {RenderStatus}
   */
  getRenderStatus() {
    return this._renderStatus
  }

  /**
   * @param {RenderStatus} value
   */
  setRenderStatus(value) {
    this._renderStatus = value
  }

  /**
   * @return {string[]}
   */
  getNeedMoreResources() {
    return this._needMoreResources
  }

  /**
   * @param {string[]} value
   */
  setNeedMoreResources(value) {
    this._needMoreResources = value
  }

  /**
   * @return {boolean}
   */
  getNeedMoreDom() {
    return this._needMoreDom
  }

  /**
   * @param {boolean} value
   */
  setNeedMoreDom(value) {
    this._needMoreDom = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `RunningRender { ${JSON.stringify(this)} }`
  }
}
module.exports = RunningRender


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const EyesRunner = __webpack_require__(/*! ./EyesRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js")

class ClassicRunner extends EyesRunner {}

module.exports = ClassicRunner


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

class EyesRunner {
  constructor() {
    /** @type {Eyes[]} */
    this._eyesInstances = []
    /** @type {TestResults[]} */
    this._allTestResult = []
    this._getBatchInfo = undefined
  }

  attachEyes(eyes, serverConnector) {
    this._eyesInstances.push(eyes)
    if (!this._getBatchInfo) {
      const fetchBatchInfo = serverConnector.batchInfo.bind(serverConnector)
      this._getBatchInfo = GeneralUtils.cachify(fetchBatchInfo)
    }
    if (!this._getRenderingInfo) {
      const getRenderingInfo = serverConnector.renderInfo.bind(serverConnector)
      this._getRenderingInfo = GeneralUtils.cachify(getRenderingInfo)
    }
  }

  async getBatchInfoWithCache(batchId) {
    if (this._getBatchInfo) {
      return this._getBatchInfo(batchId)
    } else {
      throw new Error('Eyes runner could not get batch info since attachEyes was not called before')
    }
  }

  async getRenderingInfoWithCache() {
    if (this._getRenderingInfo) {
      return this._getRenderingInfo()
    } else {
      throw new Error('Eyes runner could not get rendering info since attachEyes was not called before')
    }
  }

  async getAllTestResults() {
    await this._closeAllBatches()
    await this._awaitAllClosePromises()

    return this._allTestResult
  }

  async _awaitAllClosePromises() {
    if (this._eyesInstances.length > 0) {
      await Promise.all(
        this._eyesInstances.map(eyes =>
          eyes._closePromise.catch(err => {
            this._eyesInstances[0]
              .getLogger()
              .verbose(`Properly handling close error while await all close promises in getAllTestResults: ${err}`)
          }),
        ),
      )
    }
  }

  /**
   * @protected
   * @return {Promise<void>}
   */
  async _closeAllBatches() {
    if (this._eyesInstances.length > 0) {
      const promises = []
      const batchIds = new Set()
      for (const eyesInstance of this._eyesInstances) {
        const batchId = eyesInstance.getBatch().getId()
        if (!batchIds.has(batchId)) {
          batchIds.add(batchId)
          promises.push(eyesInstance.closeBatch())
        }
      }

      await Promise.all(promises)
    }
  }
}

module.exports = EyesRunner


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/runner/RunnerOptions.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/runner/RunnerOptions.js ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";


function RunnerOptions() {
  const CONCURRENCY_DEFAULT = 5
  const options = {}

  return {
    testConcurrency(value) {
      return {...options, testConcurrency: value || CONCURRENCY_DEFAULT}
    },
  }
}

module.exports = RunnerOptions


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const EyesRunner = __webpack_require__(/*! ./EyesRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js")

/**
 * @typedef {{testConcurrency: number}} RunnerOptions
 */

class VisualGridRunner extends EyesRunner {
  /**
   * @param {number|RunnerOptions} [concurrencyOrRunnerOptions]
   */
  constructor(concurrencyOrRunnerOptions) {
    super()
    if (typeof concurrencyOrRunnerOptions === 'number') {
      this._legacyConcurrency = concurrencyOrRunnerOptions
    } else if (concurrencyOrRunnerOptions && concurrencyOrRunnerOptions.testConcurrency) {
      this._concurrentSessions = concurrencyOrRunnerOptions.testConcurrency
    } else if (concurrencyOrRunnerOptions) {
      throw new Error(
        'VisualGridRunner expects an object argument with property testConcurrency for controlling the number of concurrent visual tests',
      )
    }
  }

  /**
   * @deprecated
   * @return {number}
   */
  getConcurrentSessions() {
    return this._concurrentSessions
  }

  get legacyConcurrency() {
    return this._legacyConcurrency
  }

  get testConcurrency() {
    return this._concurrentSessions
  }

  set testConcurrency(runnerOptions) {
    this._concurrentSessions = runnerOptions.testConcurrency
  }

  makeGetVisualGridClient(makeVisualGridClient) {
    if (!this._getVisualGridClient) {
      this._getVisualGridClient = makeVisualGridClient
    }
  }

  async getVisualGridClientWithCache(config) {
    if (this._getVisualGridClient) {
      return this._getVisualGridClient(config)
    } else {
      throw new Error(
        'VisualGrid runner could not get visual grid client since makeGetVisualGridClient was not called before',
      )
    }
  }
}

module.exports = VisualGridRunner


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/CheckSettingsUtils.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/CheckSettingsUtils.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const snippets = __webpack_require__(/*! @applitools/snippets */ "./node_modules/@applitools/snippets/dist/index.js")
const ImageMatchSettings = __webpack_require__(/*! ../config/ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js")

async function toPersistedCheckSettings({checkSettings, context, logger}) {
  const elementsById = {}

  const persistedCheckSettings = {
    ...checkSettings,
    region: (await referencesToPersistedRegions(checkSettings.region && [checkSettings.region]))[0],
    ignoreRegions: await referencesToPersistedRegions(checkSettings.ignoreRegions),
    floatingRegions: await referencesToPersistedRegions(checkSettings.floatingRegions),
    strictRegions: await referencesToPersistedRegions(checkSettings.strictRegions),
    layoutRegions: await referencesToPersistedRegions(checkSettings.layoutRegions),
    contentRegions: await referencesToPersistedRegions(checkSettings.contentRegions),
    accessibilityRegions: await referencesToPersistedRegions(checkSettings.accessibilityRegions),
  }

  await makePersistance()

  return {persistedCheckSettings, cleanupPersistance}

  async function referencesToPersistedRegions(references = []) {
    const persistedRegions = []
    for (const reference of references) {
      const {region, ...options} = reference.region ? reference : {region: reference}
      let referenceRegions
      if (utils.types.has(region, ['width', 'height'])) {
        referenceRegions = [region]
      } else {
        const elements = await context.elements(region)
        referenceRegions = elements.map(element => {
          const elementId = utils.general.guid()
          elementsById[elementId] = element
          return {
            type: 'css',
            selector: `[data-applitools-marker~="${elementId}"]`,
          }
        })
      }

      persistedRegions.push(...referenceRegions.map(region => (reference.region ? {region, ...options} : region)))
    }
    return persistedRegions
  }

  async function makePersistance() {
    await context.execute(snippets.setElementMarkers, [Object.values(elementsById), Object.keys(elementsById)])
    logger.verbose(`elements marked: ${Object.keys(elementsById)}`)
  }

  async function cleanupPersistance() {
    await context.execute(snippets.cleanupElementMarkers, [Object.values(elementsById)])
    logger.verbose(`elements cleaned up: ${Object.keys(elementsById)}`)
  }
}

function toCheckWindowConfiguration({checkSettings, configuration}) {
  const config = {
    ignore:
      checkSettings.ignoreRegions &&
      checkSettings.ignoreRegions.map(region => {
        return utils.types.has(region, ['x', 'y'])
          ? {left: region.x, top: region.y, width: region.width, height: region.height}
          : region
      }),
    floating:
      checkSettings.floatingRegions &&
      checkSettings.floatingRegions.map(({region, ...offsets}) => {
        return utils.types.has(region, ['x', 'y'])
          ? {left: region.x, top: region.y, width: region.width, height: region.height, ...offsets}
          : {...region, ...offsets}
      }),
    strict:
      checkSettings.strictRegions &&
      checkSettings.strictRegions.map(region => {
        return utils.types.has(region, ['x', 'y'])
          ? {left: region.x, top: region.y, width: region.width, height: region.height}
          : region
      }),
    layout:
      checkSettings.layoutRegions &&
      checkSettings.layoutRegions.map(region => {
        return utils.types.has(region, ['x', 'y'])
          ? {left: region.x, top: region.y, width: region.width, height: region.height}
          : region
      }),
    content:
      checkSettings.contentRegions &&
      checkSettings.contentRegions.map(region => {
        return utils.types.has(region, ['x', 'y'])
          ? {left: region.x, top: region.y, width: region.width, height: region.height}
          : region
      }),
    accessibility:
      checkSettings.accessibilityRegions &&
      checkSettings.accessibilityRegions.map(({region, type}) => {
        if (utils.types.has(region, ['x', 'y'])) {
          region = {left: region.x, top: region.y, width: region.width, height: region.height}
        }
        return {...region, accessibilityType: type}
      }),
    target: checkSettings.region ? 'region' : 'window',
    fully: configuration.getForceFullPageScreenshot() || checkSettings.fully || false,
    tag: checkSettings.name,
    scriptHooks: checkSettings.hooks,
    sendDom: configuration.getSendDom() || checkSettings.sendDom, // this is wrong, but kept for backwards compatibility,
    ignoreDisplacements: checkSettings.ignoreDisplacements,
    matchLevel: TypeUtils.getOrDefault(checkSettings.matchLevel, configuration.getMatchLevel()),
    visualGridOptions: TypeUtils.getOrDefault(checkSettings.visualGridOptions, configuration.getVisualGridOptions()),
    enablePatterns: TypeUtils.getOrDefault(checkSettings.enablePatterns, configuration.getEnablePatterns()),
    useDom: TypeUtils.getOrDefault(checkSettings.useDom, configuration.getUseDom()),
    variationGroupId: checkSettings.variationGroupId,
  }

  if (config.target === 'region') {
    if (utils.types.has(checkSettings.region, ['width', 'height'])) {
      config.region = utils.types.has(checkSettings.region, ['x', 'y'])
        ? {
            left: checkSettings.region.x,
            top: checkSettings.region.y,
            width: checkSettings.region.width,
            height: checkSettings.region.height,
          }
        : checkSettings.region
    } else {
      config.selector = checkSettings.region
    }
  }

  return config
}

function toMatchSettings({checkSettings = {}, configuration}) {
  const matchSettings = {
    matchLevel: checkSettings.matchLevel || configuration.getDefaultMatchSettings().getMatchLevel(),
    ignoreCaret: checkSettings.ignoreCaret || configuration.getDefaultMatchSettings().getIgnoreCaret(),
    useDom: checkSettings.useDom || configuration.getDefaultMatchSettings().getUseDom(),
    enablePatterns: checkSettings.enablePatterns || configuration.getDefaultMatchSettings().getEnablePatterns(),
    ignoreDisplacements:
      checkSettings.ignoreDisplacements || configuration.getDefaultMatchSettings().getIgnoreDisplacements(),
    accessibilitySettings: configuration.getDefaultMatchSettings().getAccessibilitySettings(),
    exact: null,
    ignore: transformRegions(checkSettings.ignoreRegions),
    layout: transformRegions(checkSettings.layoutRegions),
    strict: transformRegions(checkSettings.strictRegions),
    content: transformRegions(checkSettings.contentRegions),
    floating: transformRegions(checkSettings.floatingRegions),
    accessibility: transformRegions(checkSettings.accessibilityRegions),
  }

  return new ImageMatchSettings(matchSettings)

  function transformRegions(regions) {
    if (!regions || regions.length === 0) return regions
    return regions.map(target => {
      const {region, ...options} = target.region ? target : {region: target}
      if (utils.types.has(region, ['x', 'y', 'width', 'height'])) {
        return {
          left: Math.round(region.x),
          top: Math.round(region.y),
          width: Math.round(region.width),
          height: Math.round(region.height),
          ...options,
        }
      }
      return region
    })
  }
}

async function toScreenshotCheckSettings({checkSettings, context, screenshot}) {
  const screenshotCheckSettings = {
    ...checkSettings,
    ignoreRegions: await referencesToRegions(checkSettings.ignoreRegions),
    floatingRegions: await referencesToRegions(checkSettings.floatingRegions),
    strictRegions: await referencesToRegions(checkSettings.strictRegions),
    layoutRegions: await referencesToRegions(checkSettings.layoutRegions),
    contentRegions: await referencesToRegions(checkSettings.contentRegions),
    accessibilityRegions: await referencesToRegions(checkSettings.accessibilityRegions),
  }

  return screenshotCheckSettings

  async function referencesToRegions(references) {
    if (!references) return references
    const regions = []
    for (const reference of references) {
      const referenceRegions = []
      const {region, ...options} = reference.region ? reference : {region: reference}
      if (utils.types.has(region, ['x', 'y', 'width', 'height'])) {
        referenceRegions.push(region)
      } else {
        const elements = await context.elements(region)
        const contextLocationInViewport = await context.getLocationInViewport()

        for (const element of elements) {
          const region = utils.geometry.offset(await element.getRegion(), contextLocationInViewport)
          referenceRegions.push({
            x: Math.max(0, region.x - screenshot.region.x),
            y: Math.max(0, region.y - screenshot.region.y),
            width: region.width,
            height: region.height,
          })
        }
      }
      regions.push(...referenceRegions.map(region => (reference.region ? {region, ...options} : region)))
    }
    return regions
  }
}

module.exports = {
  toPersistedCheckSettings,
  toCheckWindowConfiguration,
  toScreenshotCheckSettings,
  toMatchSettings,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesBase.js":
/*!********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesBase.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const Logger = __webpack_require__(/*! ../logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")
const EyesError = __webpack_require__(/*! ../errors/EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const Location = __webpack_require__(/*! ../geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")
const RectangleSize = __webpack_require__(/*! ../geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const CoordinatesType = __webpack_require__(/*! ../geometry/CoordinatesType */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/CoordinatesType.js")

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")

const ImageDeltaCompressor = __webpack_require__(/*! ../images/ImageDeltaCompressor */ "./node_modules/@applitools/eyes-sdk-core/lib/images/ImageDeltaCompressor.js")
const SimplePropertyHandler = __webpack_require__(/*! ../handler/SimplePropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/SimplePropertyHandler.js")
const ReadOnlyPropertyHandler = __webpack_require__(/*! ../handler/ReadOnlyPropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/ReadOnlyPropertyHandler.js")
const SessionType = __webpack_require__(/*! ../config/SessionType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/SessionType.js")
const Configuration = __webpack_require__(/*! ../config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")

const AppOutput = __webpack_require__(/*! ../match/AppOutput */ "./node_modules/@applitools/eyes-sdk-core/lib/match/AppOutput.js")

const TextTrigger = __webpack_require__(/*! ../triggers/TextTrigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/TextTrigger.js")
const MouseTrigger = __webpack_require__(/*! ../triggers/MouseTrigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/MouseTrigger.js")

const MatchResult = __webpack_require__(/*! ../match/MatchResult */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js")
const MatchWindowData = __webpack_require__(/*! ../match/MatchWindowData */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchWindowData.js")

const DiffsFoundError = __webpack_require__(/*! ../errors/DiffsFoundError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js")
const NewTestError = __webpack_require__(/*! ../errors/NewTestError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/NewTestError.js")
const TestFailedError = __webpack_require__(/*! ../errors/TestFailedError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js")

const ValidationInfo = __webpack_require__(/*! ../events/ValidationInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationInfo.js")
const ValidationResult = __webpack_require__(/*! ../events/ValidationResult */ "./node_modules/@applitools/eyes-sdk-core/lib/events/ValidationResult.js")
const SessionEventHandlers = __webpack_require__(/*! ../events/SessionEventHandlers */ "./node_modules/@applitools/eyes-sdk-core/lib/events/SessionEventHandlers.js")

const SessionStartInfo = __webpack_require__(/*! ../server/SessionStartInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/SessionStartInfo.js")
const TestResultsStatus = __webpack_require__(/*! ../TestResultsStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js")
const TestResults = __webpack_require__(/*! ../TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")
const ServerConnector = __webpack_require__(/*! ../server/ServerConnector */ "./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js")

const FailureReports = __webpack_require__(/*! ../FailureReports */ "./node_modules/@applitools/eyes-sdk-core/lib/FailureReports.js")
const AppEnvironment = __webpack_require__(/*! ../AppEnvironment */ "./node_modules/@applitools/eyes-sdk-core/lib/AppEnvironment.js")
const MatchWindowTask = __webpack_require__(/*! ../MatchWindowTask */ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowTask.js")
const MatchWindowAndCloseTask = __webpack_require__(/*! ../MatchWindowAndCloseTask */ "./node_modules/@applitools/eyes-sdk-core/lib/MatchWindowAndCloseTask.js")
const getScmInfo = __webpack_require__(/*! ../getScmInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/getScmInfo.js")

/**
 * Core/Base class for Eyes - to allow code reuse for different SDKs (images, selenium, etc).
 */
class EyesBase {
  /**
   * Creates a new {@code EyesBase}instance that interacts with the Eyes Server at the specified url.
   *
   * @param {?string} [serverUrl] - The Eyes server URL.
   * @param {?boolean} [isDisabled=false] - Will be checked <b>before</b> any argument validation. If true, all method
   *   will immediately return without performing any action.
   * @param {Configuration} [configuration]
   */
  constructor(serverUrl, isDisabled, configuration = new Configuration()) {
    /** @var {Logger} */
    this._logger = new Logger(configuration.getShowLogs())
    /** @var {Configuration} */
    this._configuration = configuration.cloneConfig()

    this._configuration.setServerUrl(serverUrl)
    this._configuration.setIsDisabled(isDisabled)

    /** @type {ServerConnector} */
    this._serverConnector = new ServerConnector({
      logger: this._logger,
      configuration: this._configuration,
      getAgentId: this.getFullAgentId.bind(this),
    })

    if (this._configuration.getIsDisabled()) {
      this._userInputs = []
      return
    }

    this._initProviders()

    /** @type {FailureReports} */
    this._failureReports = FailureReports.ON_CLOSE

    /** @type {number} */
    this._validationId = -1
    /** @type {SessionEventHandlers} */
    this._sessionEventHandlers = new SessionEventHandlers()

    /** @type {MatchWindowTask} */ this._matchWindowTask = undefined
    /** @type {RunningSession} */ this._runningSession = undefined
    /** @type {SessionStartInfo} */ this._sessionStartInfo = undefined

    /** @type {boolean} */ this._shouldMatchWindowRunOnceOnTimeout = undefined
    /** @type {boolean} */ this._isViewportSizeSet = undefined

    /** @type {boolean} */ this._isOpen = false
    /** @type {boolean} */ this._isVisualGrid = false

    /** @type {boolean} */ this._useImageDeltaCompression = true

    /**
     * Will be set for separately for each test.
     * @type {string}
     */
    this._currentAppName = undefined

    /**
     * The session ID of webdriver instance
     * @type {string}
     */
    this._autSessionId = undefined

    /**
     * @type {Trigger[]}
     */
    this._userInputs = []
  }

  /**
   * @return {Logger}
   */
  getLogger() {
    return this._logger
  }

  set logger(logger) {
    this._logger = logger
  }

  /**
   * Sets a handler of log messages generated by this API.
   *
   * @param {LogHandler} logHandler - Handles log messages generated by this API.
   */
  setLogHandler(logHandler) {
    this._logger.setLogHandler(logHandler)
  }

  /**
   * @return {LogHandler} - The currently set log handler.
   */
  getLogHandler() {
    return this._logger.getLogHandler()
  }

  /**
   * @param {...string} args
   */
  log(...args) {
    this._logger.log(...args)
  }

  /**
   * @return {Configuration}
   */
  getConfiguration() {
    return this._configuration.cloneConfig()
  }

  /**
   * @param {Configuration|object} configuration
   */
  setConfiguration(configuration) {
    if (!configuration || !configuration.constructor || configuration.constructor.name !== 'Configuration') {
      configuration = new Configuration(configuration)
    }

    this._configuration = configuration.cloneConfig()
    this._serverConnector._configuration = this._configuration
  }

  /**
   * Sets the user given agent id of the SDK.
   *
   * @param {string} agentId - The agent ID to set.
   */
  setAgentId(agentId) {
    this._configuration.setAgentId(agentId)
  }

  /**
   * @return {string} - The user given agent id of the SDK.
   */
  getAgentId() {
    return this._configuration.getAgentId()
  }

  /**
   * Sets the API key of your Applitools Eyes account.
   *
   * @param {string} apiKey - The api key to be used.
   */
  setApiKey(apiKey) {
    this._configuration.setApiKey(apiKey)
  }

  /**
   * @return {string} - The currently set API key or {@code null} if no key is set.
   */
  getApiKey() {
    return this._configuration.getApiKey()
  }

  /**
   * Sets the current server URL used by the rest client.
   *
   * @param {string} serverUrl - The URI of the rest server, or {@code null} to use the default server.
   */
  setServerUrl(serverUrl) {
    this._configuration.setServerUrl(serverUrl)
  }

  /**
   * @return {string} - The URI of the eyes server.
   */
  getServerUrl() {
    return this._configuration.getServerUrl()
  }

  /**
   * Sets the proxy settings to be used for all requests to Eyes server.
   * Alternatively, proxy can be set via global variables `HTTP_PROXY`, `HTTPS_PROXY`, `NO_PROXY`.
   *
   * @signature `setProxy(proxySettings)`
   * @sigparam {ProxySettings} proxySettings - The ProxySettings instance to use.
   *
   * @signature `setProxy(isEnabled)`
   * @sigparam {boolean} isEnabled - You can pass {@code false} to completely disable proxy.
   *
   * @signature `setProxy(url, username, password)`
   * @sigparam {string} url - The proxy url to be used.
   * @sigparam {string} [username] - The proxy username to be used.
   * @sigparam {string} [password] - The proxy password to be used.
   *
   * @param {?(ProxySettings|boolean|string)} varArg - The ProxySettings object or proxy url to be used.
   *  Use {@code false} to disable proxy (even if it set via env variables). Use {@code null} to reset proxy settings.
   * @param {string} [username] - The proxy username to be used.
   * @param {string} [password] - The proxy password to be used.
   */
  setProxy(varArg, username, password) {
    if (!username && !password) {
      this._configuration.setProxy(varArg)
    } else {
      this._configuration.setProxy({
        url: varArg,
        username,
        password,
      })
    }
  }

  /**
   * @return {ProxySettings} - current proxy settings used by the server connector, or {@code null} if no proxy is set.
   */
  getProxy() {
    return this._configuration.getProxy()
  }

  /**
   * @return {number} - The timeout for web requests (in milliseconds).
   */
  getConnectionTimeout() {
    return this._configuration.getConnectionTimeout()
  }

  /**
   * Sets the connect and read timeouts for web requests.
   *
   * @param {number} connectionTimeout - Connect/Read timeout in milliseconds. 0 equals infinity.
   */
  setConnectionTimeout(connectionTimeout) {
    this._configuration.setConnectionTimeout(connectionTimeout)
  }

  /**
   * Whether sessions are removed immediately after they are finished.
   *
   * @param {boolean} removeSession
   */
  setRemoveSession(removeSession) {
    this._configuration.setRemoveSession(removeSession)
  }

  /**
   * @return {boolean} - Whether sessions are removed immediately after they are finished.
   */
  getRemoveSession() {
    return this._configuration.getRemoveSession()
  }

  /**
   * @param {boolean} isDisabled - If true, all interactions with this API will be silently ignored.
   */
  setIsDisabled(isDisabled) {
    this._configuration.setIsDisabled(isDisabled)
  }

  /**
   * @return {boolean} - Whether eyes is disabled.
   */
  getIsDisabled() {
    return this._configuration.getIsDisabled()
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostApp() {
    return this._configuration.getHostApp()
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   */
  setHostApp(value) {
    this._logger.log(`Host App: ${value}`)
    this._configuration.setHostApp(value)
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostOS() {
    return this._configuration.getHostOS()
  }

  /**
   * Sets the host OS name - overrides the one in the agent string.
   *
   * @param {string} value - The host OS running the AUT.
   */
  setHostOS(value) {
    this._logger.log(`Host OS: ${value}`)
    this._configuration.setHostOS(value)
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostAppInfo() {
    return this._configuration.getHostAppInfo()
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   */
  setHostAppInfo(value) {
    this._logger.log(`Host App Info: ${value}`)
    this._configuration.setHostAppInfo(value)
  }

  /**
   * @return {string} - The host OS as set by the user.
   */
  getHostOSInfo() {
    return this._configuration.getHostOSInfo()
  }

  /**
   * Sets the host OS name - overrides the one in the agent string.
   *
   * @param {string} value - The host OS running the AUT.
   */
  setHostOSInfo(value) {
    this._logger.log(`Host OS Info: ${value}`)
    this._configuration.setHostOSInfo(value)
  }

  /**
   * @return {string} - The application name running the AUT.
   */
  getDeviceInfo() {
    return this._configuration.getDeviceInfo()
  }

  /**
   * Sets the host application - overrides the one in the agent string.
   *
   * @param {string} value - The application running the AUT (e.g., Chrome).
   */
  setDeviceInfo(value) {
    this._logger.log(`Device Info: ${value}`)
    this._configuration.setDeviceInfo(value)
  }

  /**
   * @param {string} appName - The name of the application under test.
   */
  setAppName(appName) {
    this._configuration.setAppName(appName)
  }

  /**
   * @return {string} - The name of the application under test.
   */
  getAppName() {
    return this._configuration.getAppName()
  }

  /**
   * Sets the branch in which the baseline for subsequent test runs resides. If the branch does not already exist it
   * will be created under the specified parent branch (see {@link #setParentBranchName}). Changes to the baseline
   * or model of a branch do not propagate to other branches.
   *
   * @param {string} branchName - Branch name or {@code null} to specify the default branch.
   */
  setBranchName(branchName) {
    this._configuration.setBranchName(branchName)
  }

  /**
   * @return {string} - The current branch name.
   */
  getBranchName() {
    return this._configuration.getBranchName()
  }

  /**
   * Sets the branch under which new branches are created.
   *
   * @param {string} parentBranchName - Branch name or {@code null} to specify the default branch.
   */
  setParentBranchName(parentBranchName) {
    this._configuration.setParentBranchName(parentBranchName)
  }

  /**
   * @return {string} - The name of the current parent branch under which new branches will be created.
   */
  getParentBranchName() {
    return this._configuration.getParentBranchName()
  }

  /**
   * Sets the baseline branch under which new branches are created.
   *
   * @param {string} baselineBranchName - Branch name or {@code null} to specify the default branch.
   */
  setBaselineBranchName(baselineBranchName) {
    this._configuration.setBaselineBranchName(baselineBranchName)
  }

  /**
   * @return {string} - The name of the baseline branch
   */
  getBaselineBranchName() {
    return this._configuration.getBaselineBranchName()
  }

  /**
   * Sets the maximum time (in ms) a match operation tries to perform a match.
   * @param {number} ms - Total number of ms to wait for a match.
   */
  setMatchTimeout(ms) {
    if (this._configuration.getIsDisabled()) {
      this._logger.verbose('Ignored')
      return
    }

    this._configuration.setMatchTimeout(ms)
  }

  /**
   * @return {number} - The maximum time in ms {@link #checkWindowBase(RegionProvider, string, boolean, number)} waits
   *   for a match.
   */
  getMatchTimeout() {
    return this._configuration.getMatchTimeout()
  }

  /**
   * Set whether or not new tests are saved by default.
   *
   * @param {boolean} saveNewTests - True if new tests should be saved by default. False otherwise.
   */
  setSaveNewTests(saveNewTests) {
    this._configuration.setSaveNewTests(saveNewTests)
  }

  /**
   * @return {boolean} - True if new tests are saved by default.
   */
  getSaveNewTests() {
    return this._configuration.getSaveNewTests()
  }

  /**
   * Set whether or not failed tests are saved by default.
   *
   * @param {boolean} saveFailedTests - True if failed tests should be saved by default, false otherwise.
   */
  setSaveFailedTests(saveFailedTests) {
    this._configuration.setSaveFailedTests(saveFailedTests)
  }

  /**
   * @return {boolean} - True if failed tests are saved by default.
   */
  getSaveFailedTests() {
    return this._configuration.getSaveFailedTests()
  }

  /**
   * Sets the batch in which context future tests will run or {@code null} if tests are to run standalone.
   *
   * @param {BatchInfo|BatchInfoObject|string} batchOrName - The batch name or batch object
   * @param {string} [batchId] - ID of the batch, should be generated using GeneralUtils.guid()
   * @param {string} [startedAt] - Start date of the batch, can be created as new Date().toUTCString()
   */
  setBatch(batchOrName, batchId, startedAt) {
    if (this._configuration.getIsDisabled()) {
      this._logger.verbose('Ignored')
      return
    }

    if (arguments.length > 1) {
      this._configuration.setBatch({
        id: batchId,
        name: batchOrName,
        startedAt,
      })
    } else {
      this._configuration.setBatch(batchOrName)
    }

    this._logger.verbose(`setBatch(${this._configuration._batch})`)
  }

  /**
   * @return {BatchInfo} - The currently set batch info.
   */
  getBatch() {
    return this._configuration.getBatch()
  }

  /**
   * Adds a property to be sent to the server.
   *
   * @param {string} name - The property name.
   * @param {string} value - The property value.
   */
  addProperty(name, value) {
    return this._configuration.addProperty(name, value)
  }

  /**
   * Clears the list of custom properties.
   */
  clearProperties() {
    this._configuration._properties = []
  }

  /**
   * Automatically save differences as a baseline.
   *
   * @param {boolean} saveDiffs - Sets whether to automatically save differences as baseline.
   */
  setSaveDiffs(saveDiffs) {
    this._configuration.setSaveDiffs(saveDiffs)
  }

  /**
   * @return {boolean} - whether to automatically save differences as baseline.
   */
  getSaveDiffs() {
    return this._configuration.getSaveDiffs()
  }

  /**
   * @param {boolean} sendDom
   */
  setSendDom(sendDom) {
    this._configuration.setSendDom(sendDom)
  }

  /**
   * @return {boolean}
   */
  getSendDom() {
    return this._configuration.getSendDom()
  }

  /**
   * @param {boolean} compareWithParentBranch - New compareWithParentBranch value, default is false
   */
  setCompareWithParentBranch(compareWithParentBranch) {
    this._configuration.setCompareWithParentBranch(compareWithParentBranch)
  }

  /**
   * @deprecated Use {@link #getCompareWithParentBranch()} instead
   * @return {boolean} - The currently compareWithParentBranch value
   */
  isCompareWithParentBranch() {
    return this._configuration.getCompareWithParentBranch()
  }

  /**
   * @return {boolean} - The currently compareWithParentBranch value
   */
  getCompareWithParentBranch() {
    return this._configuration.getCompareWithParentBranch()
  }

  /**
   * @param {boolean} ignoreBaseline - New ignoreBaseline value, default is false
   */
  setIgnoreBaseline(ignoreBaseline) {
    this._configuration.setIgnoreBaseline(ignoreBaseline)
  }

  /**
   * @deprecated Use {@link #getIgnoreBaseline()} instead
   * @return {boolean} - The currently ignoreBaseline value
   */
  isIgnoreBaseline() {
    return this._configuration.getIgnoreBaseline()
  }

  /**
   * @return {boolean} - The currently ignoreBaseline value
   */
  getIgnoreBaseline() {
    return this._configuration.getIgnoreBaseline()
  }

  /**
   * @deprecated Only available for backward compatibility. See {@link #setBaselineEnvName(string)}.
   * @param {string} baselineName - If specified, determines the baseline to compare with and disables automatic baseline
   *   inference.
   */
  setBaselineName(baselineName) {
    this.setBaselineEnvName(baselineName)
  }

  /**
   * @deprecated Only available for backward compatibility. See {@link #getBaselineEnvName()}.
   * @return {string} - The baseline name, if it was specified.
   */
  getBaselineName() {
    return this.getBaselineEnvName()
  }

  /**
   * If not {@code null}, determines the name of the environment of the baseline.
   *
   * @param {string} baselineEnvName - The name of the baseline's environment.
   */
  setBaselineEnvName(baselineEnvName) {
    this._logger.log(`Baseline environment name: ${baselineEnvName}`)
    this._configuration.setBaselineEnvName(baselineEnvName)
  }

  /**
   * If not {@code null}, determines the name of the environment of the baseline.
   *
   * @return {string} - The name of the baseline's environment, or {@code null} if no such name was set.
   */
  getBaselineEnvName() {
    return this._configuration.getBaselineEnvName()
  }

  /**
   * If not {@code null} specifies a name for the environment in which the application under test is running.
   *
   * @deprecated use {@link setEnvironmentName} instead
   * @param {string} envName - The name of the environment of the baseline.
   */
  setEnvName(envName) {
    this.setEnvironmentName(envName)
  }

  /**
   * If not {@code null} specifies a name for the environment in which the application under test is running.
   *
   * @param {string} envName - The name of the environment of the baseline.
   */
  setEnvironmentName(envName) {
    this._logger.log(`Environment name: ${envName}`)
    this._configuration.setEnvironmentName(envName)
  }

  /**
   * If not {@code null} specifies a name for the environment in which the application under test is running.
   *
   * @return {string} - The name of the environment of the baseline, or {@code null} if no such name was set.
   */
  getEnvName() {
    return this._configuration.getEnvironmentName()
  }

  /**
   * @param {string} testName - The name of the currently running test.
   */
  setTestName(testName) {
    this._configuration.setTestName(testName)
  }

  /**
   * @return {?string} - The name of the currently running test.
   */
  getTestName() {
    return this._configuration.getTestName()
  }

  /**
   * @param {string} displayName - The display name of the currently running test.
   */
  setDisplayName(displayName) {
    this._configuration.setDisplayName(displayName)
  }

  /**
   * @return {?string} - The display name of the currently running test.
   */
  getDisplayName() {
    return this._configuration.getDisplayName()
  }

  /**
   * @return {ImageMatchSettings} - The match settings used for the session.
   */
  getDefaultMatchSettings() {
    return this._configuration.getDefaultMatchSettings()
  }

  /**
   * Updates the match settings to be used for the session.
   *
   * @param {ImageMatchSettings} defaultMatchSettings - The match settings to be used for the session.
   */
  setDefaultMatchSettings(defaultMatchSettings) {
    this._configuration.setDefaultMatchSettings(defaultMatchSettings)
  }

  /**
   * The test-wide match level to use when checking application screenshot with the expected output.
   *
   * @param {MatchLevel} matchLevel - The test-wide match level to use when checking application screenshot with the
   *   expected output.
   */
  setMatchLevel(matchLevel) {
    this._configuration.getDefaultMatchSettings().setMatchLevel(matchLevel)
  }

  /**
   * @return {MatchLevel} - The test-wide match level.
   */
  getMatchLevel() {
    return this._configuration.getDefaultMatchSettings().getMatchLevel()
  }

  /**
   * The test-wide useDom to use.
   *
   * @param {boolean} useDom - The test-wide useDom to use in match requests.
   */
  setUseDom(useDom) {
    this._configuration.getDefaultMatchSettings().setUseDom(useDom)
  }

  /**
   * @return {boolean} - The test-wide useDom to use in match requests.
   */
  getUseDom() {
    return this._configuration.getDefaultMatchSettings().getUseDom()
  }

  /**
   * The test-wide enablePatterns to use.
   *
   * @param {boolean} enablePatterns - The test-wide enablePatterns to use in match requests.
   */
  setEnablePatterns(enablePatterns) {
    this._configuration.getDefaultMatchSettings().setEnablePatterns(enablePatterns)
  }

  /**
   * @return {boolean} - The test-wide enablePatterns to use in match requests.
   */
  getEnablePatterns() {
    return this._configuration.getDefaultMatchSettings().getEnablePatterns()
  }

  /**
   * The test-wide ignoreDisplacements to use.
   *
   * @param {boolean} ignoreDisplacements - The test-wide ignoreDisplacements to use in match requests.
   */
  setIgnoreDisplacements(ignoreDisplacements) {
    this._configuration.getDefaultMatchSettings().setIgnoreDisplacements(ignoreDisplacements)
  }

  /**
   * @return {boolean} - The test-wide ignoreDisplacements to use in match requests.
   */
  getIgnoreDisplacements() {
    return this._configuration.getDefaultMatchSettings().getIgnoreDisplacements()
  }

  /**
   * Sets the ignore blinking caret value.
   *
   * @param {boolean} value - The ignore value.
   */
  setIgnoreCaret(value) {
    this._configuration.getDefaultMatchSettings().setIgnoreCaret(value)
  }

  /**
   * @return {boolean} - Whether to ignore or the blinking caret or not when comparing images.
   */
  getIgnoreCaret() {
    return this._configuration.getDefaultMatchSettings().getIgnoreCaret()
  }

  /**
   * @param {boolean} [hardReset=false] - If false, init providers only if they're not initialized.
   * @private
   */
  _initProviders(hardReset = false) {
    if (hardReset) {
      this._viewportSizeHandler = undefined
    }

    if (!this._viewportSizeHandler) {
      /** @type {PropertyHandler<RectangleSize>} */
      this._viewportSizeHandler = new SimplePropertyHandler()
      this._viewportSizeHandler.set(null)
    }
  }

  getAndSaveRenderingInfo() {
    throw new TypeError('The method "getAndSaveRenderingInfo" is not implemented!')
  }

  _getAndSaveBatchInfoFromServer(_batchId) {
    throw new TypeError('The method "_getAndSaveBatchInfoFromServer" is not implemented!')
  }

  async _getScmMergeBaseTime(branchName, parentBranchName) {
    ArgumentGuard.notNullOrEmpty(branchName, 'branchName')
    ArgumentGuard.notNullOrEmpty(parentBranchName, 'parentBranchName')
    return getScmInfo(branchName, parentBranchName)
  }

  async handleScmMergeBaseTime() {
    const batchId = this.getUserSetBatchId()
    let scmSourceBranch = this._configuration.getBranchName()
    let scmTargetBranch = this._configuration.getParentBranchName()

    const isLocalBranchTest = scmSourceBranch && scmTargetBranch && scmSourceBranch !== scmTargetBranch
    const isCiBranchTest = batchId && !scmSourceBranch && !scmTargetBranch

    let err
    if (isCiBranchTest) {
      ;[err, {scmSourceBranch, scmTargetBranch} = {}] = await GeneralUtils.presult(
        this._getAndSaveBatchInfoFromServer(batchId),
      )
      this._logger.log(
        `_getAndSaveBatchInfoFromServer done for ${batchId},
        branchName: ${scmSourceBranch}, parentBranchName: ${scmTargetBranch}, err: ${err}`,
      )
    }

    let mergeBaseTime
    if ((isLocalBranchTest || isCiBranchTest) && !err) {
      ;[err, mergeBaseTime] = await GeneralUtils.presult(this._getScmMergeBaseTime(scmSourceBranch, scmTargetBranch))
      this._logger.log('_getScmMergeBaseTime done,', `mergeBaseTime: ${mergeBaseTime} err: ${err}`)
    }

    return mergeBaseTime
  }

  /**
   * @param {RenderingInfo} renderingInfo
   */
  setRenderingInfo(renderingInfo) {
    this._serverConnector.setRenderingInfo(renderingInfo)
  }

  /**
   * @return {string} - The name of the application under test.
   */
  getAppName() {
    return this._currentAppName || this._configuration.getAppName()
  }

  /**
   * Clears the user inputs list.
   *
   * @protected
   */
  clearUserInputs() {
    if (this._configuration.getIsDisabled()) {
      return
    }
    this._userInputs.length = 0
  }

  /**
   * @protected
   * @return {Trigger[]} - User inputs collected between {@code checkWindowBase} invocations.
   */
  getUserInputs() {
    if (this._configuration.getIsDisabled()) {
      return null
    }

    return this._userInputs.map(input => Object.assign(Object.create(input), input))
  }

  /**
   * @param {FailureReports} failureReports - Use one of the values in FailureReports.
   */
  setFailureReports(failureReports) {
    ArgumentGuard.isValidEnumValue(failureReports, FailureReports)
    this._failureReports = failureReports
  }

  /**
   * @return {FailureReports} - The failure reports setting.
   */
  getFailureReports() {
    return this._failureReports
  }

  /**
   * @return {string} - The full agent id composed of both the base agent id and the user given agent id.
   */
  getFullAgentId() {
    return this.getAgentId() ? `${this.getAgentId()} [${this.getBaseAgentId()}]` : this.getBaseAgentId()
  }

  /**
   * @return {boolean} - Whether a session is open.
   */
  getIsOpen() {
    return this._isOpen
  }

  setRender(_value) {
    GeneralUtils.deprecationWarning({deprecatedThing: 'setRender', isDead: true})
  }

  getRender() {
    GeneralUtils.deprecationWarning({deprecatedThing: 'getRender', isDead: true})
  }

  /**
   * Ends the currently running test.
   *
   * @param {boolean} [throwEx=true] - If true, then the returned promise will 'reject' for failed/aborted tests.
   * @return {Promise<TestResults>} - A promise which resolves/rejects (depending on the value of 'throwEx') to the test
   *   results.
   */
  async close(throwEx = true) {
    try {
      if (this._configuration.getIsDisabled()) {
        this._logger.verbose('Eyes close ignored. (disabled)')
        return null
      }

      this._logger.verbose(`EyesBase.close(${throwEx})`)
      ArgumentGuard.isValidState(this._isOpen, 'Eyes not open')

      this._isOpen = false

      this._lastScreenshot = null
      this.clearUserInputs()

      this._initProviders(true)

      // If a session wasn't started, use empty results.
      if (!this._runningSession) {
        this._logger.verbose('Server session was not started')
        this._logger.log('--- Empty test ended.')
        const testResult = new TestResults({name: this._configuration._testName})
        testResult.isEmpty = true
        return testResult
      }

      const isNewSession = this._runningSession.getIsNew()
      const sessionResultsUrl = this._runningSession.getUrl()

      this._logger.verbose('Ending server session...')

      // Session was started, call the server to end the session.
      const results = await this._serverConnector.stopSession(this._runningSession, false, {
        updateBaselineIfNew: this._configuration.getSaveNewTests(),
        updateBaselineIfDifferent: this._configuration.getSaveFailedTests(),
      })
      results.setIsNew(isNewSession)
      results.setUrl(sessionResultsUrl)

      // for backwards compatibility with outdated servers
      if (!results.getStatus()) {
        if (results.getMissing() === 0 && results.getMismatches() === 0) {
          results.setStatus(TestResultsStatus.Passed)
        } else {
          results.setStatus(TestResultsStatus.Unresolved)
        }
      }

      this._logger.verbose(`Results: ${results}`)

      const status = results.getStatus()
      await this._sessionEventHandlers.testEnded(await this.getAUTSessionId(), results)

      if (status === TestResultsStatus.Unresolved) {
        if (results.getIsNew()) {
          this._logger.log(`--- New test ended. Please approve the new baseline at ${sessionResultsUrl}`)
          if (throwEx) {
            throw new NewTestError(results.toJSON())
          }
        } else {
          this._logger.log(`--- Failed test ended. See details at ${sessionResultsUrl}`)
          if (throwEx) {
            throw new DiffsFoundError(results.toJSON())
          }
        }
      } else if (status === TestResultsStatus.Failed) {
        this._logger.log(`--- Failed test ended. See details at ${sessionResultsUrl}`)
        if (throwEx) {
          throw new TestFailedError(results.toJSON())
        }
      } else {
        this._logger.log(`--- Test passed. See details at ${sessionResultsUrl}`)
      }

      results.setServerConnector(this._serverConnector)
      return results
    } catch (err) {
      this._logger.log(`Failed to abort server session: ${err.message}`)
      throw err
    } finally {
      // Making sure that we reset the running session even if an exception was thrown during close.
      this._matchWindowTask = null
      this._autSessionId = undefined
      this._runningSession = null
      this._currentAppName = undefined
      this._logger.getLogHandler().close()
    }
  }

  /**
   * If a test is running, aborts it. Otherwise, does nothing.
   *
   * @alias abort
   * @return {Promise<?TestResults>} - A promise which resolves to the test results.
   */
  async abortIfNotClosed() {
    return this.abort()
  }

  /**
   * If a test is running, aborts it. Otherwise, does nothing.
   *
   * @return {Promise<?TestResults>} - A promise which resolves to the test results.
   */
  async abort() {
    try {
      if (this._configuration.getIsDisabled()) {
        this._logger.verbose('Eyes abort ignored. (disabled)')
        return null
      }

      this._isOpen = false

      this._lastScreenshot = null
      this.clearUserInputs()

      if (!this._runningSession) {
        this._logger.verbose('Closed')
        return null
      }

      this._logger.verbose('Aborting server session...')
      const testResults = await this._serverConnector.stopSession(this._runningSession, true)

      this._logger.log('--- Test aborted.')
      return testResults
    } catch (err) {
      this._logger.log(`Failed to abort server session: ${err}`)
      return null
    } finally {
      this._runningSession = null
      this._logger.getLogHandler().close()
    }
  }

  /**
   * Takes a snapshot of the application under test and matches it with the expected output.
   *
   * @protected
   * @param {RegionProvider} regionProvider - Returns the region to check or empty region to check the entire window.
   * @param {string} [tag=''] - An optional tag to be associated with the snapshot.
   * @param {boolean} [ignoreMismatch=false] - Whether to ignore this check if a mismatch is found.
   * @param {CheckSettings} [checkSettings] - The settings to use.
   * @param {string} [source] - The tested source page.
   * @return {Promise<MatchResult>} - The result of matching the output with the expected output.
   * @throws DiffsFoundError - Thrown if a mismatch is detected and immediate failure reports are enabled.
   */
  async checkWindowBase({
    name = '',
    url,
    renderId,
    variationGroupId,
    sendDom,
    retryTimeout = -1,
    ignoreMismatch = false,
    closeAfterMatch,
    throwEx,
  } = {}) {
    if (closeAfterMatch) {
      return this.checkWindowAndCloseBase({
        name,
        url,
        renderId,
        variationGroupId,
        sendDom,
        retryTimeout,
        ignoreMismatch,
        throwEx,
      })
    }

    this._validationId += 1
    const validationInfo = new ValidationInfo(this._validationId, name)

    await GeneralUtils.sleep(this._configuration.getWaitBeforeScreenshots())

    await this.beforeMatchWindow()
    await this._sessionEventHandlers.validationWillStart(this._autSessionId, validationInfo)

    await this._ensureRunningSession()

    this._matchWindowTask = new MatchWindowTask({
      getMatchData: (...args) => this._getAppOutputWithScreenshot(...args),
      serverConnector: this._serverConnector,
      runningSession: this._runningSession,
      retryTimeout: this._configuration.getMatchTimeout(),
      logger: this._logger,
    })

    this._logger.verbose('Calling match window...')

    const matchResult = await this._matchWindowTask.match({
      name,
      url,
      renderId,
      variationGroupId,
      ignoreMismatch,
      sendDom,
      retryTimeout,
      shouldRunOnceOnTimeout: this._shouldMatchWindowRunOnceOnTimeout,
      userInputs: this.getUserInputs(),
    })

    await this.afterMatchWindow()

    this._logger.verbose('MatchWindow Done!')
    const validationResult = new ValidationResult(matchResult.getAsExpected())

    if (!ignoreMismatch) {
      this.clearUserInputs()
    }

    this._validateResult(name, matchResult)
    this._logger.verbose('Done!')
    await this._sessionEventHandlers.validationEnded(
      this._autSessionId,
      validationInfo.getValidationId(),
      validationResult,
    )

    return matchResult
  }

  /**
   * Takes a snapshot of the application under test and matches it with the expected output.
   *
   * @protected
   * @param {RegionProvider} regionProvider - Returns the region to check or empty rectangle to check the entire window.
   * @param {string} [tag=''] - An optional tag to be associated with the snapshot.
   * @param {boolean} [ignoreMismatch=false] - Whether to ignore this check if a mismatch is found.
   * @param {CheckSettings} [checkSettings] - The settings to use.
   * @return {Promise<TestResults>} - The result of matching the output with the expected output.
   */
  async checkWindowAndCloseBase({
    name = '',
    url,
    renderId,
    variationGroupId,
    sendDom,
    retryTimeout = -1,
    ignoreMismatch = false,
    throwEx,
  }) {
    this._validationId += 1
    const validationInfo = new ValidationInfo(this._validationId, name)

    await GeneralUtils.sleep(this._configuration.getWaitBeforeScreenshots())

    await this.beforeMatchWindow()
    await this._sessionEventHandlers.validationWillStart(this._autSessionId, validationInfo)

    await this._ensureRunningSession()

    this._shouldMatchWindowRunOnceOnTimeout = true
    this._matchWindowTask = new MatchWindowAndCloseTask({
      getMatchData: (...args) => this._getAppOutputWithScreenshot(...args),
      serverConnector: this._serverConnector,
      runningSession: this._runningSession,
      retryTimeout: this._configuration.getMatchTimeout(),
      updateBaselineIfNew: this._configuration.getSaveNewTests(),
      updateBaselineIfDifferent: this._configuration.getSaveFailedTests(),
      logger: this._logger,
    })

    this._logger.verbose('Calling match window...')

    const results = await this._matchWindowTask.match({
      name,
      url,
      renderId,
      variationGroupId,
      ignoreMismatch,
      sendDom,
      retryTimeout,
      shouldRunOnceOnTimeout: this._shouldMatchWindowRunOnceOnTimeout,
      userInputs: this.getUserInputs(),
    })

    await this.afterMatchWindow()

    this._logger.verbose('MatchWindow Done!')

    try {
      if (!ignoreMismatch) {
        this.clearUserInputs()
      }

      const isNewSession = this._runningSession.getIsNew()
      const sessionResultsUrl = this._runningSession.getUrl()

      const matchResult = new MatchResult()
      matchResult.setAsExpected(!results.getIsDifferent())
      this._validateResult(name, matchResult)

      this._logger.verbose('Done!')

      results.setIsNew(isNewSession)
      results.setUrl(sessionResultsUrl)

      // for backwards compatibility with outdated servers
      if (!results.getStatus()) {
        if (results.getMissing() === 0 && results.getMismatches() === 0) {
          results.setStatus(TestResultsStatus.Passed)
        } else {
          results.setStatus(TestResultsStatus.Unresolved)
        }
      }

      this._logger.verbose(`Results: ${results}`)

      const status = results.getStatus()
      await this._sessionEventHandlers.testEnded(await this.getAUTSessionId(), results)

      if (status === TestResultsStatus.Unresolved) {
        if (results.getIsNew()) {
          this._logger.log(`--- New test ended. Please approve the new baseline at ${sessionResultsUrl}`)
          if (throwEx) {
            throw new NewTestError(results.toJSON())
          }
        } else {
          this._logger.log(`--- Failed test ended. See details at ${sessionResultsUrl}`)
          if (throwEx) {
            throw new DiffsFoundError(results.toJSON())
          }
        }
      } else if (status === TestResultsStatus.Failed) {
        this._logger.log(`--- Failed test ended. See details at ${sessionResultsUrl}`)
        if (throwEx) {
          throw new TestFailedError(results.toJSON())
        }
      } else {
        this._logger.log(`--- Test passed. See details at ${sessionResultsUrl}`)
      }

      results.setServerConnector(this._serverConnector)
      return results
    } catch (err) {
      this._logger.log(`Failed to abort server session: ${err.message}`)
      throw err
    } finally {
      // Making sure that we reset the running session even if an exception was thrown during close.
      this._matchWindowTask = null
      this._autSessionId = undefined
      this._runningSession = null
      this._currentAppName = undefined
      this._logger.getLogHandler().close()
    }
  }

  /**
   * @protected
   * @return {Promise}
   */
  async beforeMatchWindow() {
    return undefined
  }

  /**
   * @protected
   * @return {Promise}
   */
  async afterMatchWindow() {
    return undefined
  }

  /**
   * @protected
   * @return {Promise<?string>}
   */
  async getOrigin() {
    return undefined
  }

  /**
   * Replaces an actual image in the current running session.
   *
   * @param {number} stepIndex - The zero based index of the step in which to replace the actual image.
   * @param {Buffer} screenshot - The PNG bytes of the updated screenshot.
   * @param {string} [tag] - The updated tag for the step.
   * @param {string} [title] - The updated title for the step.
   * @param {Trigger[]} [userInputs] - The updated userInputs for the step.
   * @return {Promise<MatchResult>} - A promise which resolves when replacing is done, or rejects on error.
   */
  async replaceWindow(stepIndex, screenshot, tag = '', title = '', userInputs = []) {
    this._logger.verbose('EyesBase.replaceWindow - running')

    if (this._configuration.getIsDisabled()) {
      this._logger.verbose('Ignored')
      const result = new MatchResult()
      result.setAsExpected(true)
      return result
    }

    ArgumentGuard.isValidState(this._isOpen, 'Eyes not open')

    this._logger.verbose('EyesBase.replaceWindow - calling serverConnector.replaceWindow')

    const replaceWindowData = new MatchWindowData({
      userInputs,
      appOutput: new AppOutput({title, screenshot}),
      tag,
    })

    const result = await this._serverConnector.replaceWindow(this._runningSession, stepIndex, replaceWindowData)
    this._logger.verbose('EyesBase.replaceWindow done')
    return result
  }

  /**
   * @private
   * @param {string} tag
   * @param {MatchResult} result
   */
  _validateResult(tag, result) {
    if (result.getAsExpected()) {
      return
    }

    this._shouldMatchWindowRunOnceOnTimeout = true

    if (this._runningSession && !this._runningSession.getIsNew()) {
      this._logger.log(`Mismatch! (${tag})`)
    }

    if (this.getFailureReports() === FailureReports.IMMEDIATE) {
      throw new TestFailedError(
        null,
        `Mismatch found in '${this._sessionStartInfo.getScenarioIdOrName()}' of '${this._sessionStartInfo.getAppIdOrName()}'`,
      )
    }
  }

  /**
   * Starts a test.
   *
   * @protected
   * @param {string} appName - The name of the application under test.
   * @param {string} testName - The test name.
   * @param {RectangleSize|PalinRectangleSize} [viewportSize] - The client's viewport size (i.e., the
   *   visible part of the document's body) or {@code null} to allow any viewport size.
   * @param {SessionType} [sessionType=SessionType.SEQUENTIAL] - The type of test (e.g., Progression for timing tests),
   *   or {@code null} to use the default.
   * @param {skipStartingSession} [skipStartingSession=false] - If {@code true} skip starting the session.
   * @return {Promise}
   */
  async openBase(appName, testName, viewportSize, sessionType = SessionType.SEQUENTIAL, skipStartingSession = false) {
    this._logger.getLogHandler().open()

    if (viewportSize) this._configuration.setViewportSize(viewportSize)

    try {
      if (this._configuration.getIsDisabled()) {
        this._logger.verbose('Eyes Open ignored - disabled')
        return
      }

      // If there's no default application name, one must be provided for the current test.
      if (!this._configuration.getAppName()) {
        ArgumentGuard.notNull(appName, 'appName')
      }
      ArgumentGuard.notNull(testName, 'testName')

      this._logger.verbose(`Agent = ${this.getFullAgentId()}`)
      this._logger.verbose(`openBase('${appName}', '${testName}', '${this._configuration.getViewportSize()}')`)

      if (!this._renderingInfoPromise) {
        this._renderingInfoPromise = this.getAndSaveRenderingInfo()
      }

      if (!this._configuration.getIgnoreGitMergeBase()) this._scmMergeBaseTimePromise = this.handleScmMergeBaseTime()

      await this._sessionEventHandlers.testStarted(await this.getAUTSessionId())

      this._validateApiKey()
      this._logOpenBase()
      await this._validateSessionOpen()

      this._initProviders()
      this._isViewportSizeSet = false
      await this.beforeOpen()

      this._currentAppName = appName || this._configuration.getAppName()
      this._configuration.setTestName(testName)
      this._viewportSizeHandler.set(this._configuration.getViewportSize())
      this._configuration.setSessionType(sessionType)
      this._validationId = -1

      if (this._configuration.getViewportSize() && !skipStartingSession) {
        await this._ensureRunningSession()
      }

      this._autSessionId = await this.getAUTSessionId()
      this._isOpen = true
      await this.afterOpen()
    } catch (err) {
      this._logger.log(err.message)
      this._logger.getLogHandler().close()
      throw err
    }
  }

  /**
   * @protected
   * @return {Promise}
   */
  async beforeOpen() {
    return undefined
  }

  /**
   * @protected
   * @return {Promise}
   */
  async afterOpen() {
    return undefined
  }

  /**
   * @private
   * @return {Promise}
   */
  async _ensureRunningSession() {
    if (this._runningSession) {
      this._logger.verbose('session already running.')
      return
    }

    this._logger.verbose('No running session, calling start session...')
    await this.startSession()
    this._logger.setSessionId(this._runningSession.getSessionId())
    this._logger.verbose('Done!')
  }

  /**
   * @private
   */
  _validateApiKey() {
    if (!this.getApiKey()) {
      const errMsg = 'API key is missing! Please set it using setApiKey()'
      this._logger.log(errMsg)
      throw new Error(errMsg)
    }
  }

  /**
   * @private
   */
  _logOpenBase() {
    this._logger.verbose(`Eyes server URL is '${this._configuration.getServerUrl()}'`)
    this._logger.verbose(`Timeout = '${this._configuration.getConnectionTimeout()}'`)
    this._logger.verbose(`matchTimeout = '${this._configuration.getMatchTimeout()}'`)
    this._logger.verbose(`Default match settings = '${this._configuration.getDefaultMatchSettings()}'`)
    this._logger.verbose(`FailureReports = '${this._failureReports}'`)
  }

  /**
   * @private
   * @return {Promise}
   */
  async _validateSessionOpen() {
    if (this._isOpen) {
      await this.abort()
      const errMsg = 'A test is already running'
      this._logger.log(errMsg)
      throw new Error(errMsg)
    }
  }

  /**
   * Define the viewport size as {@code size} without doing any actual action on the
   *
   * @param {RectangleSize} explicitViewportSize - The size of the viewport. {@code null} disables the explicit size.
   */
  setExplicitViewportSize(explicitViewportSize) {
    if (!explicitViewportSize) {
      this._viewportSizeHandler = new SimplePropertyHandler()
      this._viewportSizeHandler.set(null)
      this._configuration.setViewportSize(undefined)
      this._isViewportSizeSet = false
      return
    }

    this._logger.verbose(`Viewport size explicitly set to ${explicitViewportSize}`)
    this._viewportSizeHandler = new ReadOnlyPropertyHandler(this._logger, new RectangleSize(explicitViewportSize))
    this._configuration.setViewportSize(explicitViewportSize)
    this._isViewportSizeSet = true
  }

  /**
   * Adds a trigger to the current list of user inputs.
   *
   * @protected
   * @param {Trigger} trigger - The trigger to add to the user inputs list.
   */
  addUserInput(trigger) {
    if (this._configuration.getIsDisabled()) {
      return
    }

    ArgumentGuard.notNull(trigger, 'trigger')
    this._userInputs.push(trigger)
  }

  /**
   * Adds a text trigger.
   *
   * @protected
   * @param {Region} control - The control's position relative to the window.
   * @param {string} text - The trigger's text.
   */
  addTextTriggerBase(control, text) {
    if (this._configuration.getIsDisabled()) {
      this._logger.verbose(`Ignoring '${text}' (disabled)`)
      return
    }

    ArgumentGuard.notNull(control, 'control')
    ArgumentGuard.notNull(text, 'text')

    // We don't want to change the objects we received.
    let newControl = new Region(control)

    if (!this._matchWindowTask || !this._matchWindowTask.getLastScreenshot()) {
      this._logger.verbose(`Ignoring '${text}' (no screenshot)`)
      return
    }

    newControl = this._matchWindowTask
      .getLastScreenshot()
      .getIntersectedRegion(newControl, CoordinatesType.SCREENSHOT_AS_IS)
    if (newControl.isSizeEmpty()) {
      this._logger.verbose(`Ignoring '${text}' (out of bounds)`)
      return
    }

    const trigger = new TextTrigger(newControl, text)
    this._userInputs.push(trigger)

    this._logger.verbose(`Added ${trigger}`)
  }

  /**
   * Adds a mouse trigger.
   *
   * @protected
   * @param {MouseTrigger.MouseAction} action - Mouse action.
   * @param {Region} control - The control on which the trigger is activated (location is relative to the window).
   * @param {Location} cursor - The cursor's position relative to the control.
   */
  addMouseTriggerBase(action, control, cursor) {
    if (this._configuration.getIsDisabled()) {
      this._logger.verbose(`Ignoring ${action} (disabled)`)
      return
    }

    ArgumentGuard.notNull(action, 'action')
    ArgumentGuard.notNull(control, 'control')
    ArgumentGuard.notNull(cursor, 'cursor')

    // Triggers are actually performed on the previous window.
    if (!this._matchWindowTask || !this._matchWindowTask.getLastScreenshot()) {
      this._logger.verbose(`Ignoring ${action} (no screenshot)`)
      return
    }

    // We don't want to change the objects we received.
    const newControl = new Region(control)
    // Getting the location of the cursor in the screenshot
    let cursorInScreenshot = new Location(cursor)
    // First we need to getting the cursor's coordinates relative to the context (and not to the control).
    cursorInScreenshot.offsetByLocation(newControl.getLocation())
    try {
      cursorInScreenshot = this._matchWindowTask
        .getLastScreenshot()
        .getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE)
    } catch (err) {
      throw err
    }

    const controlScreenshotIntersect = this._matchWindowTask
      .getLastScreenshot()
      .getIntersectedRegion(newControl, CoordinatesType.SCREENSHOT_AS_IS)

    // If the region is NOT empty, we'll give the coordinates relative to the control.
    if (!controlScreenshotIntersect.isSizeEmpty()) {
      const l = controlScreenshotIntersect.getLocation()
      cursorInScreenshot.offset(-l.getX(), -l.getY())
    }

    const trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot)
    this._userInputs.push(trigger)
  }

  setAppEnvironment(hostOS, hostApp) {
    if (this.getIsDisabled()) {
      this._logger.verbose('Ignored')
      return
    }

    this._logger.verbose(`SetAppEnvironment(${hostOS}, ${hostApp})`)

    this._configuration.setHostOS(hostOS)
    this._configuration.setHostApp(hostApp)
  }

  /**
   * Application environment is the environment (e.g., the host OS) which runs the application under test.
   *
   * @protected
   * @return {Promise<AppEnvironment>} - The current application environment.
   */
  async getAppEnvironment() {
    const appEnv = new AppEnvironment()

    // If hostOS isn't set, we'll try and extract and OS ourselves.
    if (this._configuration.getHostOS()) {
      appEnv.setOs(this._configuration.getHostOS())
    }

    if (this._configuration.getHostApp()) {
      appEnv.setHostingApp(this._configuration.getHostApp())
    }

    if (this._configuration.getDeviceInfo()) {
      appEnv.setDeviceInfo(this._configuration.getDeviceInfo())
    }

    if (this._configuration.getHostAppInfo()) {
      appEnv.setHostingAppInfo(this._configuration.getHostAppInfo())
    }

    if (this._configuration.getHostOSInfo()) {
      appEnv.setOsInfo(this._configuration.getHostOSInfo())
    }

    const inferred = await this.getInferredEnvironment()
    appEnv.setInferred(inferred)
    appEnv.setDisplaySize(this._viewportSizeHandler.get())
    return appEnv
  }

  /**
   * Start eyes session on the eyes server.
   *
   * @protected
   * @return {Promise}
   */
  async startSession() {
    this._logger.verbose('startSession()')

    if (this._runningSession) {
      return
    }

    this._logger.verbose(`Batch is ${this._configuration.getBatch()}`)
    this._autSessionId = await this.getAUTSessionId()

    try {
      await this._ensureViewportSize()
    } catch (error) {
      // Throw to skip execution of all consecutive "then" blocks.
      throw new EyesError('Failed to set/get viewport size', {reason: 'driver', error})
    }

    await this._sessionEventHandlers.initStarted()
    const appEnvironment = await this.getAppEnvironment()
    this._logger.verbose(`Application environment is ${appEnvironment}`)
    await this._sessionEventHandlers.initEnded()

    let parentBranchBaselineSavedBefore
    if (this._scmMergeBaseTimePromise) parentBranchBaselineSavedBefore = await this._scmMergeBaseTimePromise

    this._sessionStartInfo = new SessionStartInfo({
      agentId: this.getFullAgentId(),
      sessionType: this._configuration.getSessionType(),
      appIdOrName: this.getAppName(),
      verId: undefined,
      scenarioIdOrName: this._configuration.getTestName(),
      displayName: this._configuration.getDisplayName(),
      batchInfo: this._configuration.getBatch(),
      baselineEnvName: this._configuration.getBaselineEnvName(),
      environmentName: this._configuration.getEnvironmentName(),
      environment: appEnvironment,
      defaultMatchSettings: this._configuration.getDefaultMatchSettings(),
      branchName: this._configuration.getBranchName(),
      parentBranchName: this._configuration.getParentBranchName(),
      parentBranchBaselineSavedBefore,
      baselineBranchName: this._configuration.getBaselineBranchName(),
      compareWithParentBranch: this._configuration.getCompareWithParentBranch(),
      ignoreBaseline: this._configuration.getIgnoreBaseline(),
      saveDiffs: this._configuration.getSaveDiffs(),
      properties: this._configuration.getProperties(),
      agentSessionId: GeneralUtils.guid(),
      timeout: this._configuration.getAbortIdleTestTimeout(),
      agentRunId: this.agentRunId,
    })

    this._logger.verbose('Starting server session...')
    this._runningSession = await this._serverConnector.startSession(this._sessionStartInfo)
    this._logger.verbose(`Server session ID is ${this._runningSession.getId()}`)

    if (this._runningSession.getRenderingInfo()) {
      this._serverConnector.setRenderingInfo(this._runningSession.getRenderingInfo())
    }

    const testInfo = `'${this._configuration.getTestName()}' of '${this.getAppName()}' "${appEnvironment}`
    if (this._runningSession.getIsNew()) {
      this._logger.log(`--- New test started - ${testInfo}`)
      this._shouldMatchWindowRunOnceOnTimeout = true
    } else {
      this._logger.log(`--- Test started - ${testInfo}`)
      this._shouldMatchWindowRunOnceOnTimeout = false
    }
  }

  /**
   * @package
   * @return {Promise}
   */
  async closeBatch() {
    if (this._configuration.getIsDisabled() || this._configuration.getDontCloseBatches()) {
      this._logger.verbose('closeBatch Ignored')
      return
    }

    try {
      if (this._configuration._batch) {
        const batchId = this.getBatchIdWithoutGenerating()
        await this._serverConnector.deleteBatchSessions(batchId)
      } else {
        this._logger.log('Failed to close batch: no batch found.')
      }
    } catch (e) {
      this._logger.log('Failed to close batch: error occurred', e)
    }
  }

  getUserSetBatchId() {
    const isGeneratedId = this._configuration._batch && this._configuration._batch.getIsGeneratedId()
    if (!isGeneratedId) {
      return this.getBatchIdWithoutGenerating()
    }
  }

  /*
   * Get batch id if set by user.
   * do not do eyesInstance.getBatch().getId() because it would generate
   * a new id if called before open.
   */
  getBatchIdWithoutGenerating() {
    // TODO
    // we need the Configuration to check for default values like getEnvValue('BATCH_ID') instead of
    // it creating new Objects (with defaults) on demand, see Configuration#getBatch().
    return (this._configuration._batch && this._configuration._batch.getId()) || GeneralUtils.getEnvValue('BATCH_ID')
  }

  /**
   * @private
   * @return {Promise}
   */
  async _ensureViewportSize() {
    if (!this._isViewportSizeSet) {
      try {
        if (this._viewportSizeHandler.get()) {
          const targetSize = this._viewportSizeHandler.get()
          await this._sessionEventHandlers.setSizeWillStart(targetSize)
          await this.setViewportSize(targetSize)

          // If it's read-only, no point in making the getViewportSize() call..
        } else if (!(this._viewportSizeHandler instanceof ReadOnlyPropertyHandler)) {
          const targetSize = await this.getViewportSize()
          await this._sessionEventHandlers.setSizeWillStart(targetSize)
          this._viewportSizeHandler.set(targetSize)
          this._configuration.setViewportSize(targetSize)
        }

        this._isViewportSizeSet = true
        await this._sessionEventHandlers.setSizeEnded()
      } catch (err) {
        this._logger.verbose('Can not ensure ViewportSize', err)
        this._isViewportSizeSet = false
      }
    }
  }

  /**
   * @private
   * @param {Region} region - The region of the screenshot which will be set in the application output.
   * @param {EyesScreenshot} lastScreenshot - Previous application screenshot (for compression) or `null` if not
   *   available.
   * @param {CheckSettings} checkSettings - The check settings object of the current test.
   * @return {Promise<AppOutputWithScreenshot>} - The updated app output and screenshot.
   */
  async _getAppOutputWithScreenshot({lastScreenshot, sendDom}) {
    this._logger.verbose('getting screenshot...')

    // Getting the screenshot (abstract function implemented by each SDK).
    const screenshot = await this.getScreenshot()
    this._logger.verbose('Done getting screenshot!')

    let screenshotUrl, domUrl
    if (screenshot) {
      const targetBuffer = await screenshot.image.toPng()
      let screenshotBuffer = targetBuffer

      if (this._useImageDeltaCompression && lastScreenshot) {
        try {
          this._logger.verbose('Compressing screenshot...')
          const sourceData = await lastScreenshot.image.toObject()
          const targetData = await screenshot.image.toObject()

          screenshotBuffer = ImageDeltaCompressor.compressByRawBlocks(targetData, targetBuffer, sourceData)
          const savedSize = targetBuffer.length - screenshotBuffer.length
          if (savedSize === 0) {
            this._logger.verbose('Compression skipped, because of significant difference.')
          } else {
            this._logger.verbose(`Compression finished, saved size is ${savedSize}.`)
          }
        } catch (err) {
          this._logger.log('Failed to compress screenshot!', err)
        }
      }

      await this._renderingInfoPromise
      screenshotUrl = await this._serverConnector.uploadScreenshot(GeneralUtils.guid(), screenshotBuffer)
      this._logger.verbose('Done uploading screenshot!')

      if (screenshot.dom) {
        domUrl = await this._serverConnector.postDomSnapshot(GeneralUtils.guid(), screenshot.dom)
        this._logger.verbose('Done uploading dom!')
      }
    } else {
      this._logger.verbose('getting screenshot url...')
      screenshotUrl = await this.getScreenshotUrl()
      this._logger.verbose('Done getting screenshotUrl!')
      this._logger.verbose('Getting dom url...')
      domUrl = await this.getDomUrl()
      this._logger.verbose('Done getting domUrl!')
    }

    this._logger.verbose(`screenshotUrl: ${screenshotUrl}`)
    this._logger.verbose(`domUrl: ${domUrl}`)

    const title = await this.getTitle()
    const imageLocation = await this.getImageLocation()

    const appOutput = new AppOutput({
      title,
      screenshotUrl,
      domUrl,
      imageLocation,
    })
    this._logger.verbose('Done!')
    return {screenshot, appOutput, matchSettings: this.getMatchSettings()}
  }

  /**
   * @return {SessionEventHandlers}
   */
  getSessionEventHandlers() {
    return this._sessionEventHandlers
  }

  /**
   * @param {SessionEventHandler} eventHandler
   */
  addSessionEventHandler(eventHandler) {
    this._sessionEventHandlers.addEventHandler(eventHandler)
  }

  /**
   * @param {SessionEventHandler} eventHandler
   */
  removeSessionEventHandler(eventHandler) {
    this._sessionEventHandlers.removeEventHandler(eventHandler)
  }

  clearSessionEventHandlers() {
    this._sessionEventHandlers.clearEventHandlers()
  }

  /**
   * @return {RunningSession} - An object containing data about the currently running session.
   */
  getRunningSession() {
    return this._runningSession
  }

  /**
   * @protected
   * @abstract
   * @return {string} - The base agent id of the SDK.
   */
  getBaseAgentId() {
    throw new TypeError('The method "getBaseAgentId" is not implemented!')
  }

  /**
   * Get the session id.
   *
   * @protected
   * @return {Promise<?string>} - A promise which resolves to the webdriver's session ID.
   */
  async getAUTSessionId() {
    return undefined
  }

  /**
   * @protected
   * @abstract
   * @return {Promise<RectangleSize>} - The viewport size of the AUT.
   */
  async getViewportSize() {
    throw new TypeError('The method is not implemented!')
  }

  /**
   * @protected
   * @abstract
   * @param {RectangleSize} size - The required viewport size.
   * @return {Promise}
   */
  async setViewportSize(_size) {
    // eslint-disable-line no-unused-vars
    throw new TypeError('The method is not implemented!')
  }

  /**
   * The inferred string is in the format "source:info" where source is either "useragent" or "pos".
   * Information associated with a "useragent" source is a valid browser user agent string. Information associated with
   * a "pos" source is a string of the format "process-name;os-name" where "process-name" is the name of the main
   * module of the executed process and "os-name" is the OS name.
   *
   * @protected
   * @abstract
   * @return {Promise<string>} - The inferred environment string or {@code null} if none is available.
   */
  async getInferredEnvironment() {
    throw new TypeError('The method is not implemented!')
  }

  /**
   * An updated screenshot.
   *
   * @protected
   * @abstract
   * @return {Promise<EyesScreenshot>}
   */
  async getScreenshot() {
    throw new TypeError('The method is not implemented!')
  }

  /**
   * An updated screenshot.
   *
   * @protected
   * @return {Promise<?string>}
   */
  async getScreenshotUrl() {
    return undefined
  }

  /**
   * The current title of of the AUT.
   *
   * @protected
   * @abstract
   * @return {Promise<string>}
   */
  async getTitle() {
    throw new TypeError('The method is not implemented!')
  }

  /**
   * A url pointing to a DOM capture of the AUT at the time of screenshot
   *
   * @protected
   * @return {Promise<?string>}
   */
  async getDomUrl() {
    return undefined
  }

  /**
   * The location of the image relative to the logical full page image, when cropping an image e.g. with checkRegion
   *
   * @protected
   * @return {Promise<?Location>}
   */
  async getImageLocation() {
    return undefined
  }

  /**
   * @return {boolean}
   */
  isVisualGrid() {
    return this._isVisualGrid
  }

  /**
   * @ignore
   * @param {boolean} isVisualGrid
   */
  setIsVisualGrid(isVisualGrid) {
    this._isVisualGrid = isVisualGrid
  }
}

module.exports = EyesBase


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesClassic.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesClassic.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const screenshoter = __webpack_require__(/*! @applitools/screenshoter */ "./node_modules/@applitools/screenshoter/index.js")
const {Driver} = __webpack_require__(/*! @applitools/driver */ "./node_modules/@applitools/driver/dist/index.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const Location = __webpack_require__(/*! ../geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")
const FailureReports = __webpack_require__(/*! ../FailureReports */ "./node_modules/@applitools/eyes-sdk-core/lib/FailureReports.js")
const ClassicRunner = __webpack_require__(/*! ../runner/ClassicRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js")
const takeDomCapture = __webpack_require__(/*! ../utils/takeDomCapture */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomCapture.js")
const EyesCore = __webpack_require__(/*! ./EyesCore */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesCore.js")
const CheckSettingsUtils = __webpack_require__(/*! ./CheckSettingsUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/CheckSettingsUtils.js")

class EyesClassic extends EyesCore {
  static specialize({agentId, spec}) {
    return class extends EyesClassic {
      static get spec() {
        return spec
      }
      get spec() {
        return spec
      }
      /**
       * @return {string} base agent id
       */
      getBaseAgentId() {
        return agentId
      }
    }
  }

  constructor(serverUrl, isDisabled = false, runner = new ClassicRunner()) {
    super(serverUrl, isDisabled)
    /** @private */
    this._runner = runner
    this._runner.attachEyes(this, this._serverConnector)

    /** @private @type {string}*/
    this._domUrl
    /** @private @type {EyesWrappedElement<TDriver, TElement, TSelector>} */
    this._scrollRootElement = undefined
    /** @private @type {Promise<void>} */
    this._closePromise = Promise.resolve()
  }

  async open(driver, appName, testName, viewportSize, sessionType) {
    ArgumentGuard.notNull(driver, 'driver')

    this._driver = await new Driver({spec: this.spec, driver, logger: this._logger._getNewLogger()}).init()
    this._context = this._driver.currentContext

    this._configuration.setAppName(TypeUtils.getOrDefault(appName, this._configuration.getAppName()))
    this._configuration.setTestName(TypeUtils.getOrDefault(testName, this._configuration.getTestName()))
    this._configuration.setViewportSize(TypeUtils.getOrDefault(viewportSize, this._configuration.getViewportSize()))
    this._configuration.setSessionType(TypeUtils.getOrDefault(sessionType, this._configuration.getSessionType()))

    if (!this._configuration.getViewportSize()) {
      const vs = await this._driver.getViewportSize()
      this._configuration.setViewportSize(vs)
    }

    if (this._driver.isMobile) {
      // set viewportSize to null if browser is mobile
      this._configuration.setViewportSize(null)
    }

    await this.openBase(
      this._configuration.getAppName(),
      this._configuration.getTestName(),
      this._configuration.getViewportSize(),
      this._configuration.getSessionType(),
    )
  }

  async _check(checkSettings = {}, closeAfterMatch = false, throwEx = true) {
    this._context = await this._driver.refreshContexts()
    await this._context.main.setScrollingElement(this._scrollRootElement)
    await this._context.setScrollingElement(checkSettings.scrollRootElement)

    this._checkSettings = checkSettings

    return await this.checkWindowBase({
      name: checkSettings.name,
      url: await this._driver.getUrl(),
      renderId: checkSettings.renderId,
      variationGroupId: checkSettings.variationGroupId,
      sendDom: checkSettings.sendDom,
      retryTimeout: checkSettings.timeout,
      closeAfterMatch,
      throwEx,
    })
  }

  async getScreenshot() {
    this._logger.verbose('getScreenshot()')

    const screenshotSettings = {
      frames:
        this._checkSettings.frames &&
        this._checkSettings.frames.map(frame => ({
          reference: utils.types.has(frame, 'frame') ? frame.frame : frame,
          scrollingElement: frame.scrollRootElement,
        })),
      region: this._checkSettings.region,
      fully: this._checkSettings.fully || this._configuration.getForceFullPageScreenshot(),
      hideScrollbars: this._configuration.getHideScrollbars(),
      hideCaret: this._configuration.getHideCaret(),
      scrollingMode: this._configuration.getStitchMode().toLocaleLowerCase(),
      overlap: this._configuration.getStitchOverlap(),
      wait: this._configuration.getWaitBeforeScreenshots(),
      stabilization: {
        crop: this.getCut(),
        scale: this.getScaleRatio(),
        rotation: this.getRotation(),
      },
    }

    let dom
    const screenshot = await screenshoter({
      ...screenshotSettings,
      driver: this._driver,
      hooks: {
        afterScreenshot: async ({driver, scroller, screenshot}) => {
          if (driver.isWeb && TypeUtils.getOrDefault(this._checkSettings.sendDom, this._configuration.getSendDom())) {
            this._logger.verbose('Getting window DOM...')
            if (screenshotSettings.fully) {
              await scroller.element.setAttribute('data-applitools-scroll', true)
            }
            dom = await takeDomCapture(this._logger, driver.mainContext).catch(() => null)
          }
          this._checkSettings = await CheckSettingsUtils.toScreenshotCheckSettings({
            context: driver.currentContext,
            checkSettings: this._checkSettings,
            screenshot,
          })
        },
      },
      debug: this.getDebugScreenshots(),
      logger: this._logger,
    })

    this._imageLocation = new Location(Math.round(screenshot.region.x), Math.round(screenshot.region.y))

    this._matchSettings = await CheckSettingsUtils.toMatchSettings({
      checkSettings: this._checkSettings,
      configuration: this._configuration,
    })

    return {...screenshot, dom}
  }

  async close() {
    let isErrorCaught = false
    this._closePromise = super
      .close(true)
      .catch(err => {
        isErrorCaught = true
        return err
      })
      .then(results => {
        if (isErrorCaught) {
          if (results.info && results.info.testResult) return [results.info.testResult]
          else throw results
        }
        return [results.toJSON()]
      })
      .then(results => {
        if (this._runner) {
          this._runner._allTestResult.push(...results)
        }
        return results
      })

    return this._closePromise
  }

  async abort() {
    return [await super.abort()]
  }

  async getAppEnvironment() {
    const appEnv = await super.getAppEnvironment()

    if (!appEnv._deviceInfo && this._driver.deviceName) {
      appEnv.setDeviceInfo(this._driver.deviceName)
    }

    if (!appEnv._os && this._driver.isNative) {
      let os = this._driver.platformName
      if (this._driver.platformVersion) {
        os += ` ${this._driver.platformVersion}`
      }
      if (os) {
        appEnv.setOs(os)
      }
    }
    return appEnv
  }

  setFailureReport(mode) {
    if (mode === FailureReports.IMMEDIATE) {
      this._failureReportOverridden = true
      mode = FailureReports.ON_CLOSE
    }

    EyesCore.prototype.setFailureReport.call(this, mode)
  }

  getSendDom() {
    return !this._driver.isNative && super.getSendDom()
  }

  getImageLocation() {
    if (this._imageLocation) {
      return new Location(Math.round(this._imageLocation.getX()), Math.round(this._imageLocation.getY()))
    }
    return Location.ZERO
  }

  getMatchSettings() {
    return this._matchSettings
  }

  async getInferredEnvironment() {
    try {
      const userAgent = this._driver.userAgent
      return userAgent ? 'useragent:' + userAgent : userAgent
    } catch (err) {
      return null
    }
  }

  async getRegionByLocator(locator) {
    const element = await this._driver.element(locator)
    const rect = await element.getElementRect()
    return rect
  }
}

module.exports = EyesClassic


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesCore.js":
/*!********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesCore.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");

const {Driver} = __webpack_require__(/*! @applitools/driver */ "./node_modules/@applitools/driver/dist/index.js")
const screenshoter = __webpack_require__(/*! @applitools/screenshoter */ "./node_modules/@applitools/screenshoter/index.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const Region = __webpack_require__(/*! ../geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
const Location = __webpack_require__(/*! ../geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")
const RectangleSize = __webpack_require__(/*! ../geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
const ReadOnlyPropertyHandler = __webpack_require__(/*! ../handler/ReadOnlyPropertyHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/handler/ReadOnlyPropertyHandler.js")
const TestFailedError = __webpack_require__(/*! ../errors/TestFailedError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/TestFailedError.js")
const EyesBase = __webpack_require__(/*! ./EyesBase */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesBase.js")
const Logger = __webpack_require__(/*! ../logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const takeDomCapture = __webpack_require__(/*! ../utils/takeDomCapture */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomCapture.js")

class EyesCore extends EyesBase {
  constructor(serverUrl, isDisabled) {
    super(serverUrl, isDisabled)

    /** @type {EyesWrappedDriver<TDriver, TElement, TSelector>} */
    this._driver = undefined
    /** @private @type {EyesBrowsingContext<TDriver, TElement, TSelector>} */
    this._context = undefined
    /** @private */
    this._rotation = undefined
  }

  async check(checkSettings = {}) {
    return this._check(checkSettings)
  }

  async checkAndClose(checkSettings, throwEx) {
    this._logger.verbose(`checkAndClose(checkSettings) - begin`)
    return this._check(checkSettings, true, throwEx)
  }

  async locate(visualLocatorSettings) {
    ArgumentGuard.notNull(visualLocatorSettings, 'visualLocatorSettings')
    this._logger.verbose('Get locators with given names: ', visualLocatorSettings.locatorNames)
    const screenshot = await screenshoter({
      logger: this._logger,
      driver: this._driver,
      hideScrollbars: this._configuration.getHideScrollbars(),
      hideCaret: this._configuration.getHideCaret(),
      scrollingMode: this._configuration.getStitchMode().toLocaleLowerCase(),
      overlap: this._configuration.getStitchOverlap(),
      wait: this._configuration.getWaitBeforeScreenshots(),
      stabilization: {
        crop: this.getCut(),
        scale: this.getScaleRatio(),
        rotation: this.getRotation(),
      },
      debug: this.getDebugScreenshots(),
    })
    await this.getAndSaveRenderingInfo()
    const imageUrl = await this._serverConnector.uploadScreenshot(GeneralUtils.guid(), await screenshot.image.toPng())
    const appName = this._configuration.getAppName()
    return this._serverConnector.postLocators({
      appName,
      imageUrl,
      locatorNames: visualLocatorSettings.locatorNames,
      firstOnly: visualLocatorSettings.firstOnly,
    })
  }

  async extractText(regions) {
    if (!TypeUtils.isArray(regions)) regions = [regions]

    await this._driver.refreshContexts()

    const extractTextInputs = []

    for (const userRegion of regions) {
      const region = {...userRegion}

      let dom
      const screenshot = await screenshoter({
        logger: this._logger,
        driver: this._driver,
        region: Region.isRegionCompatible(region.target)
          ? {
              x: region.target.left,
              y: region.target.top,
              width: region.target.width,
              height: region.target.height,
            }
          : region.target,
        fully: true,
        hideScrollbars: this._configuration.getHideScrollbars(),
        hideCaret: this._configuration.getHideCaret(),
        scrollingMode: this._configuration.getStitchMode().toLocaleLowerCase(),
        overlap: this._configuration.getStitchOverlap(),
        wait: this._configuration.getWaitBeforeScreenshots(),
        stabilization: {
          crop: this.getCut(),
          scale: this.getScaleRatio(),
          rotation: this.getRotation(),
        },
        debug: this.getDebugScreenshots(),
        hooks: {
          afterScreenshot: async ({driver, scroller}) => {
            if (driver.isWeb) {
              this._logger.verbose('Getting window DOM...')
              await scroller.element.setAttribute('data-applitools-scroll', true)
              dom = await takeDomCapture(this._logger, driver.mainContext).catch(() => null)
            }
          },
        },
      })

      if (region.hint === undefined && !Region.isRegionCompatible(region.target)) {
        const element = await this._context.element(region.target)
        if (!element) {
          throw new Error(`Unable to find element using provided selector - "${region.target}"`)
        }
        // TODO create a separate snippet with more sophisticated logic
        region.hint = await this._context.execute('return arguments[0].innerText', element)
        if (region.hint) {
          region.hint = region.hint.replace(/[.\\+]/g, '\\$&')
        }
      }

      await this.getAndSaveRenderingInfo()
      const [screenshotUrl, domUrl] = await Promise.all([
        this._serverConnector.uploadScreenshot(GeneralUtils.guid(), await screenshot.image.toPng()),
        this._serverConnector.postDomSnapshot(GeneralUtils.guid(), dom),
      ])
      extractTextInputs.push({
        domUrl,
        screenshotUrl,
        location: {x: Math.round(screenshot.region.x), y: Math.round(screenshot.region.y)},
        region: {
          left: 0,
          top: 0,
          width: screenshot.image.width,
          height: screenshot.image.height,
          expected: region.hint,
        },
        minMatch: region.minMatch,
        language: region.language,
      })
    }

    const results = await Promise.all(extractTextInputs.map(input => this._serverConnector.extractText(input)))

    return results.reduce((strs, result) => strs.concat(result), [])
  }

  async extractTextRegions(config) {
    ArgumentGuard.notNull(config.patterns, 'patterns')

    await this._driver.refreshContexts()

    let dom
    const screenshot = await screenshoter({
      logger: this._logger,
      driver: this._driver,
      hideScrollbars: this._configuration.getHideScrollbars(),
      hideCaret: this._configuration.getHideCaret(),
      scrollingMode: this._configuration.getStitchMode().toLocaleLowerCase(),
      overlap: this._configuration.getStitchOverlap(),
      wait: this._configuration.getWaitBeforeScreenshots(),
      stabilization: {
        crop: this.getCut(),
        scale: this.getScaleRatio(),
        rotation: this.getRotation(),
      },
      debug: this.getDebugScreenshots(),
      hooks: {
        afterScreenshot: async ({driver}) => {
          if (driver.isWeb) {
            this._logger.verbose('Getting window DOM...')
            dom = await takeDomCapture(this._logger, driver.mainContext).catch(() => null)
          }
        },
      },
    })

    await this.getAndSaveRenderingInfo()
    const [screenshotUrl, domUrl] = await Promise.all([
      this._serverConnector.uploadScreenshot(GeneralUtils.guid(), await screenshot.image.toPng()),
      this._serverConnector.postDomSnapshot(GeneralUtils.guid(), dom),
    ])

    return this._serverConnector.extractTextRegions({
      domUrl,
      screenshotUrl,
      location: {x: Math.round(screenshot.region.x), y: Math.round(screenshot.region.y)},
      patterns: config.patterns,
      ignoreCase: config.ignoreCase,
      firstOnly: config.firstOnly,
      language: config.language,
    })
  }

  /* ------------ Getters/Setters ------------ */

  static async getViewportSize(driver) {
    const logger = new Logger(process.env.APPLITOOLS_SHOW_LOGS)
    const wrapper = await new Driver({spec: this.spec, driver, logger: logger._getNewLogger()}).init()
    const viewportSize = await wrapper.getViewportSize()
    return viewportSize
  }

  static async setViewportSize(driver, viewportSize) {
    const logger = new Logger(process.env.APPLITOOLS_SHOW_LOGS)
    const wrapper = await new Driver({spec: this.spec, driver, logger: logger._getNewLogger()}).init()
    if (!wrapper.isMobile) {
      ArgumentGuard.notNull(viewportSize, 'viewportSize')
      await wrapper.setViewportSize(viewportSize)
    }
  }

  async getViewportSize() {
    const viewportSize = this._viewportSizeHandler.get()
    return viewportSize ? viewportSize : this._driver.getViewportSize()
  }

  async setViewportSize(viewportSize) {
    if (this._viewportSizeHandler instanceof ReadOnlyPropertyHandler) {
      this._logger.verbose('Ignored (viewport size given explicitly)')
      return Promise.resolve()
    }

    if (!this._driver.isMobile) {
      ArgumentGuard.notNull(viewportSize, 'viewportSize')
      viewportSize = new RectangleSize(viewportSize)
      try {
        await this._driver.setViewportSize(viewportSize.toJSON())
        this._effectiveViewport = new Region(Location.ZERO, viewportSize)
      } catch (e) {
        const viewportSize = await this._driver.getViewportSize()
        this._viewportSizeHandler.set(new RectangleSize(viewportSize))
        throw new TestFailedError('Failed to set the viewport size', e)
      }
    }

    this._viewportSizeHandler.set(new RectangleSize(viewportSize))
  }

  async _getAndSaveBatchInfoFromServer(batchId) {
    ArgumentGuard.notNullOrEmpty(batchId, 'batchId')
    return this._runner.getBatchInfoWithCache(batchId)
  }

  async getAndSaveRenderingInfo() {
    const renderingInfo = await this._runner.getRenderingInfoWithCache()
    this._serverConnector.setRenderingInfo(renderingInfo)
  }

  async getAUTSessionId() {
    if (!this._driver) {
      return undefined
    }
    return this._driver.sessionId
  }

  async getTitle() {
    return this._driver.getTitle()
  }

  getDriver() {
    return this._driver
  }

  getRemoteWebDriver() {
    return this._driver.target
  }

  getRunner() {
    return this._runner
  }

  getDevicePixelRatio() {
    return this._devicePixelRatio
  }

  getRegionToCheck() {
    return this._regionToCheck
  }

  setRegionToCheck(regionToCheck) {
    this._regionToCheck = regionToCheck
  }

  shouldStitchContent() {
    return this._stitchContent
  }

  setScrollRootElement(scrollRootElement) {
    if (scrollRootElement === null) {
      this._scrollRootElement = null
    } else if (this.spec.isSelector(scrollRootElement) || this.spec.isElement(scrollRootElement)) {
      this._scrollRootElement = scrollRootElement
    } else {
      this._scrollRootElement = undefined
    }
  }

  getScrollRootElement() {
    return this._scrollRootElement
  }

  setRotation(rotation) {
    this._rotation = rotation
  }

  getRotation() {
    return this._rotation
  }

  setScaleRatio(scaleRatio) {
    this._scaleRatio = scaleRatio
  }

  getScaleRatio() {
    return this._scaleRatio
  }

  setCut(cut) {
    this._cut = cut
  }

  getCut() {
    return this._cut
  }

  setDebugScreenshots(debugScreenshots) {
    this._debugScreenshots = debugScreenshots
  }

  getDebugScreenshots() {
    return this._debugScreenshots
  }

  getDomUrl() {
    return this._domUrl
  }

  setDomUrl(domUrl) {
    this._domUrl = domUrl
  }

  setCorsIframeHandle(corsIframeHandle) {
    this._corsIframeHandle = corsIframeHandle
  }

  getCorsIframeHandle() {
    return this._corsIframeHandle
  }
}

module.exports = EyesCore


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesFactory.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesFactory.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const Configuration = __webpack_require__(/*! ../config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")
const CorsIframeHandles = __webpack_require__(/*! ../capture/CorsIframeHandles */ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandles.js")
const EyesRunner = __webpack_require__(/*! ../runner/EyesRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/EyesRunner.js")
const ClassicRunner = __webpack_require__(/*! ../runner/ClassicRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/ClassicRunner.js")
const VisualGridRunner = __webpack_require__(/*! ../runner/VisualGridRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js")

/**
 * @typedef {import('../runner/EyesRunner')} EyesRunner
 */

/**
 * @template TDriver, TElement, TSelector
 * @typedef {import('./EyesClassic')<TDriver, TElement, TSelector>} EyesClassic
 */

/**
 * @template TDriver, TElement, TSelector
 * @typedef {import('./EyesVisualGrid')<TDriver, TElement, TSelector>} EyesVisualGrid
 */

/**
 * @template TDriver, TElement, TSelector
 * @typedef {new (serverUrl?: string|boolean|EyesRunner, isDisabled?: boolean, runner?: EyesRunner) => EyesClassic<TDriver, TElement, TSelector>} EyesFactoryCtor
 */

/**
 * This class represents an abstraction for construction of {@link EyesClassic} and {@link EyesVisualGrid}
 *
 * @template TDriver
 * @template TElement
 * @template TSelector
 */
class EyesFactory {
  /**
   * Return a specialized
   * @template TDriver, TElement, TSelector
   * @param {Object} implementations - implementations of related classes
   * @param {new (...args: any[]) => EyesClassic<TDriver, TElement, TSelector>} implementations.EyesClassic - specialized implementation of {@link EyesClassic} class
   * @param {new (...args: any[]) => EyesVisualGrid<TDriver, TElement, TSelector>} implementations.EyesVisualGrid - specialized implementation of {@link EyesVisualGrid} class
   * @return {EyesFactoryCtor<TDriver, TElement, TSelector>} specialized version of {@link EyesFactory}
   */
  static specialize({EyesClassic, EyesVisualGrid}) {
    return class extends EyesFactory {
      /**
       * @return {EyesClassic} specialized implementation of {@link EyesClassic} class
       */
      static get EyesClassic() {
        return EyesClassic
      }
      /**
       * @return {EyesClassic} specialized implementation of {@link EyesVisualGrid} class
       */
      static get EyesVisualGrid() {
        return EyesVisualGrid
      }

      static async getViewportSize(driver) {
        return EyesClassic.getViewportSize(driver)
      }

      /**
       * Sets the browser's viewport size
       * @param {TDriver} driver - driver object for the specific framework
       * @param {RectangleSize|{width: number, height: number}} viewportSize - viewport size
       */
      static async setViewportSize(driver, viewportSize) {
        return EyesClassic.setViewportSize(driver, viewportSize)
      }
    }
  }
  /**
   * @param {string|boolean|EyesRunner} [serverUrl=EyesBase.getDefaultServerUrl()] - Eyes server URL
   * @param {boolean} [isDisabled=false] - set to true to disable Applitools Eyes and use the webdriver directly
   * @param {EyesRunner} [runner=new ClassicRunner()] - runner related to the wanted Eyes implementation
   */
  constructor(serverUrl, isDisabled, runner = new ClassicRunner()) {
    if (serverUrl instanceof EyesRunner) {
      runner = serverUrl
      serverUrl = undefined
    }
    if (runner instanceof VisualGridRunner) {
      return new this.constructor.EyesVisualGrid(serverUrl, isDisabled, runner)
    }
    return new this.constructor.EyesClassic(serverUrl, isDisabled, runner)
  }
  /**
   * @param {string} [serverUrl] - The Eyes server URL.
   * @param {boolean} [isDisabled=false] - Set {@code true} to disable Applitools Eyes and use the webdriver directly.
   * @param {Object} [config] - Additional configuration object.
   */
  static fromBrowserInfo(serverUrl, isDisabled, config = {}) {
    let eyes

    if (config.browser) {
      eyes = new this.EyesVisualGrid(serverUrl, isDisabled)

      const cfg = new Configuration()
      const browsers = Array.isArray(config.browser) ? config.browser : [config.browser]
      browsers.forEach(browser => {
        // If it quacks like a duck
        if (browser.name) {
          cfg.addBrowser(browser.width, browser.height, browser.name)
        } else if (browser.deviceName) {
          cfg.addDeviceEmulation(browser.deviceName, browser.screenOrientation)
        }
      })
      eyes.setConfiguration(cfg)
    } else {
      eyes = new this.EyesClassic(serverUrl, isDisabled)
    }

    eyes._corsIframeHandle = CorsIframeHandles.BLANK

    return eyes
  }
}

module.exports = EyesFactory


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesSDK.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesSDK.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const EyesClassic = __webpack_require__(/*! ./EyesClassic */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesClassic.js")
const EyesVisualGrid = __webpack_require__(/*! ./EyesVisualGrid */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesVisualGrid.js")
const EyesFactory = __webpack_require__(/*! ./EyesFactory */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesFactory.js")

function EyesSDK({name, version, spec, VisualGridClient}) {
  const SDKEyesClassic = EyesClassic.specialize({
    agentId: `${name}/${version}`,
    spec,
  })

  const SDKEyesVisualGrid = EyesVisualGrid.specialize({
    agentId: `${name}.visualgrid/${version}`,
    spec: spec,
    VisualGridClient,
  })

  const SDKEyesFactory = EyesFactory.specialize({
    EyesClassic: SDKEyesClassic,
    EyesVisualGrid: SDKEyesVisualGrid,
  })

  return {
    EyesClassic: SDKEyesClassic,
    EyesVisualGrid: SDKEyesVisualGrid,
    EyesFactory: SDKEyesFactory,
  }
}

module.exports = EyesSDK


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesUtils.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesUtils.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const EyesError = __webpack_require__(/*! ../errors/EyesError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/EyesError.js")

async function executePollScript(logger, context, scripts, {executionTimeout = 5 * 60 * 1000, pollTimeout = 200} = {}) {
  logger.verbose('Executing poll script')
  let isExecutionTimedOut = false
  const executionTimer = setTimeout(() => (isExecutionTimedOut = true), executionTimeout)
  try {
    const {script, args = []} = scripts.main
    let response = deserialize(await context.execute(script, ...args))
    let chunks = ''
    while (!isExecutionTimedOut) {
      if (response.status === 'ERROR') {
        throw new EyesError(`Error during execute poll script: '${response.error}'`, {error: response.error})
      } else if (response.status === 'SUCCESS') {
        return response.value
      } else if (response.status === 'SUCCESS_CHUNKED') {
        chunks += response.value
        if (response.done) return deserialize(chunks)
      } else if (response.status === 'WIP') {
        await GeneralUtils.sleep(pollTimeout)
      }
      logger.verbose('Polling...')
      const {script, args = []} = scripts.poll
      response = deserialize(await context.execute(script, ...args))
    }
    throw new EyesError('Poll script execution is timed out', {reason: 'timeout'})
  } finally {
    clearTimeout(executionTimer)
  }

  function deserialize(json) {
    try {
      return JSON.parse(json)
    } catch (err) {
      const firstChars = json.slice(0, 100)
      const lastChars = json.slice(-100)
      throw new Error(
        `Response is not a valid JSON string. length: ${json.length}, first 100 chars: "${firstChars}", last 100 chars: "${lastChars}". error: ${err}`,
      )
    }
  }
}

module.exports = {
  executePollScript,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesVisualGrid.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesVisualGrid.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const {Driver} = __webpack_require__(/*! @applitools/driver */ "./node_modules/@applitools/driver/dist/index.js")
const BrowserType = __webpack_require__(/*! ../config/BrowserType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js")
const Configuration = __webpack_require__(/*! ../config/Configuration */ "./node_modules/@applitools/eyes-sdk-core/lib/config/Configuration.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const TestResultsFormatter = __webpack_require__(/*! ../TestResultsFormatter */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsFormatter.js")
const CorsIframeHandler = __webpack_require__(/*! ../capture/CorsIframeHandler */ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandler.js")
const CorsIframeHandles = __webpack_require__(/*! ../capture/CorsIframeHandles */ "./node_modules/@applitools/eyes-sdk-core/lib/capture/CorsIframeHandles.js")
const VisualGridRunner = __webpack_require__(/*! ../runner/VisualGridRunner */ "./node_modules/@applitools/eyes-sdk-core/lib/runner/VisualGridRunner.js")
const takeDomSnapshots = __webpack_require__(/*! ../utils/takeDomSnapshots */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshots.js")
const EyesCore = __webpack_require__(/*! ./EyesCore */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesCore.js")
const CheckSettingsUtils = __webpack_require__(/*! ./CheckSettingsUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/CheckSettingsUtils.js")

class EyesVisualGrid extends EyesCore {
  static specialize({agentId, spec, VisualGridClient}) {
    return class extends EyesVisualGrid {
      static get spec() {
        return spec
      }
      static get VisualGridClient() {
        return VisualGridClient
      }
      get spec() {
        return spec
      }
      getBaseAgentId() {
        return agentId
      }
    }
  }

  constructor(serverUrl, isDisabled, runner = new VisualGridRunner()) {
    super(serverUrl, isDisabled)
    /** @private */
    this._runner = runner
    this._runner.attachEyes(this, this._serverConnector)
    this._runner.makeGetVisualGridClient(this.constructor.VisualGridClient.makeVisualGridClient)

    /** @private @type {boolean} */
    this._isOpen = false
    /** @private @type {boolean} */
    this._isVisualGrid = true
    /** @private @type {CorsIframeHandle} */
    this._corsIframeHandle = CorsIframeHandles.BLANK

    /** @private */
    this._checkWindowCommand = undefined
    /** @private */
    this._closeCommand = undefined
    /** @private */
    this._abortCommand = undefined

    /** @private @type {Promise<void>} */
    this._closePromise = Promise.resolve()
  }

  async open(driver, optArg1, optArg2, optArg3, optArg4) {
    ArgumentGuard.notNull(driver, 'driver')

    this._driver = await new Driver({spec: this.spec, driver, logger: this._logger._getNewLogger()}).init()
    this._context = this._driver.currentContext

    if (optArg1 instanceof Configuration) {
      this._configuration.mergeConfig(optArg1)
    } else {
      this._configuration.setAppName(TypeUtils.getOrDefault(optArg1, this._configuration.getAppName()))
      this._configuration.setTestName(TypeUtils.getOrDefault(optArg2, this._configuration.getTestName()))
      this._configuration.setViewportSize(TypeUtils.getOrDefault(optArg3, this._configuration.getViewportSize()))
      this._configuration.setSessionType(TypeUtils.getOrDefault(optArg4, this._configuration.getSessionType()))
    }

    ArgumentGuard.notNull(this._configuration.getAppName(), 'appName')
    ArgumentGuard.notNull(this._configuration.getTestName(), 'testName')

    const browsersInfo = this._configuration.getBrowsersInfo()
    if (!this._configuration.getViewportSize() && browsersInfo && browsersInfo.length > 0) {
      const browserInfo = browsersInfo.find(browserInfo => browserInfo.width)
      if (browserInfo) {
        this._configuration.setViewportSize({width: browserInfo.width, height: browserInfo.height})
      }
    }

    if (!this._configuration.getViewportSize()) {
      const vs = await this._driver.getViewportSize()
      this._configuration.setViewportSize(vs)
    }

    if (!browsersInfo || browsersInfo.length === 0) {
      const vs = this._configuration.getViewportSize()
      this._configuration.addBrowser(vs.getWidth(), vs.getHeight(), BrowserType.CHROME)
    }

    const {
      openEyes,
      getResourceUrlsInCache,
      getIosDevicesSizes,
      getEmulatedDevicesSizes,
    } = await this._runner.getVisualGridClientWithCache({
      logger: this._logger,
      agentId: this.getFullAgentId(),
      apiKey: this._configuration.getApiKey(),
      showLogs: this._configuration.getShowLogs(),
      proxy: this._configuration.getProxy(),
      serverUrl: this._configuration.getServerUrl(),
      concurrency: this._runner.legacyConcurrency || this._configuration.getConcurrentSessions(),
      testConcurrency: this._runner.testConcurrency,
    })

    if (this._configuration.getViewportSize()) {
      const vs = this._configuration.getViewportSize()
      await this.setViewportSize(vs)
    }

    const openParams = this._configuration.toOpenEyesConfiguration()
    const {checkWindow, close, abort} = await openEyes({
      ...openParams,
      agentRunId: `${openParams.testName}--${GeneralUtils.randomAlphanumeric(10)}`,
    })

    this._isOpen = true
    this._checkWindowCommand = checkWindow
    this._closeCommand = close
    this._abortCommand = abort
    this._getResourceUrlsInCache = getResourceUrlsInCache
    this._getIosDevicesSizes = getIosDevicesSizes
    this._getEmulatedDevicesSizes = getEmulatedDevicesSizes
  }

  async _check(checkSettings, closeAfterMatch = false, throwEx = true) {
    this._logger.verbose(
      `check started with tag "${checkSettings.name}" for test "${this._configuration.getTestName()}"`,
    )

    return this._checkPrepare(checkSettings, async () => {
      const {persistedCheckSettings, cleanupPersistance} = await CheckSettingsUtils.toPersistedCheckSettings({
        checkSettings,
        context: this._context,
        logger: this._logger,
      })

      try {
        const browsers = this._configuration.getBrowsersInfo()
        const breakpoints = TypeUtils.getOrDefault(
          checkSettings.layoutBreakpoints,
          this._configuration.getLayoutBreakpoints(),
        )
        const disableBrowserFetching = TypeUtils.getOrDefault(
          checkSettings.disableBrowserFetching,
          this._configuration.getDisableBrowserFetching(),
        )
        const showLogs = this._configuration.getShowLogs()
        const snapshots = await takeDomSnapshots({
          browsers,
          breakpoints,
          disableBrowserFetching,
          driver: this._driver,
          logger: this._logger,
          skipResources: this._getResourceUrlsInCache(),
          getViewportSize: () => this.getViewportSize().then(rectangleSize => rectangleSize.toJSON()),
          getEmulatedDevicesSizes: this._getEmulatedDevicesSizes,
          getIosDevicesSizes: this._getIosDevicesSizes,
          showLogs,
        })
        const [{url}] = snapshots
        if (this.getCorsIframeHandle() === CorsIframeHandles.BLANK) {
          snapshots.forEach(CorsIframeHandler.blankCorsIframeSrcOfCdt)
        }

        const config = CheckSettingsUtils.toCheckWindowConfiguration({
          checkSettings: persistedCheckSettings,
          configuration: this._configuration,
        })

        return await this._checkWindowCommand({
          ...config,
          closeAfterMatch,
          throwEx,
          snapshot: snapshots,
          url,
        })
      } finally {
        await cleanupPersistance()
      }
    })
  }

  async _checkPrepare(checkSettings, operation) {
    this._context = await this._driver.refreshContexts()
    await this._context.main.setScrollingElement(this._scrollRootElement)
    await this._context.setScrollingElement(checkSettings.scrollRootElement)
    const originalContext = this._context
    if (checkSettings.frames && checkSettings.frames.length > 0) {
      this._context = await this._context.context(
        checkSettings.frames.reduce(
          (parent, frame) => ({
            reference: utils.types.has(frame, 'frame') ? frame.frame : frame,
            scrollingElement: frame.scrollRootElement,
            parent,
          }),
          null,
        ),
      )
      await this._context.focus()
    }
    try {
      return await operation()
    } finally {
      this._context = await originalContext.focus()
    }
  }

  async getScreenshot() {
    return undefined
  }

  async close() {
    let isErrorCaught = false
    this._closePromise = this._closeCommand(true)
      .catch(err => {
        isErrorCaught = true
        return err
      })
      .then(results => {
        this._isOpen = false
        if (isErrorCaught) {
          const error = TypeUtils.isArray(results) ? results.find(result => result instanceof Error) : results
          if (!error.info || !error.info.testResult) throw error
        }
        return results.map(result => (result instanceof Error ? result.info.testResult : result.toJSON()))
      })
      .then(results => {
        if (this._runner) {
          this._runner._allTestResult.push(...results)
        }
        return results
      })

    return this._closePromise
  }

  async closeAndPrintResults(throwEx = true) {
    const results = await this.close(throwEx)

    const testResultsFormatter = new TestResultsFormatter(results)
    // eslint-disable-next-line no-console
    console.log(testResultsFormatter.asFormatterString())
  }

  async abort() {
    this._isOpen = false
    return this._abortCommand()
  }

  async getInferredEnvironment() {
    return undefined
  }
}
module.exports = EyesVisualGrid


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

class RenderingInfo {
  /**
   * @param info
   * @param {string} info.serviceUrl
   * @param {string} info.accessToken
   * @param {string} info.resultsUrl
   */
  constructor({serviceUrl, accessToken, resultsUrl, stitchingServiceUrl} = {}) {
    this._serviceUrl = serviceUrl
    this._accessToken = accessToken
    this._resultsUrl = resultsUrl
    this._stitchingServiceUrl = stitchingServiceUrl
  }

  /**
   * @return {string}
   */
  getServiceUrl() {
    return this._serviceUrl
  }

  /**
   * @param {string} value
   */
  setServiceUrl(value) {
    this._serviceUrl = value
  }

  /**
   * @return {string}
   */
  getAccessToken() {
    return this._accessToken
  }

  /**
   * @param {string} value
   */
  setAccessToken(value) {
    this._accessToken = value
  }

  /**
   * @return {string}
   */
  getResultsUrl() {
    return this._resultsUrl
  }

  /**
   * @param {string} value
   */
  setResultsUrl(value) {
    this._resultsUrl = value
  }

  /**
   * @return {{sub: string, exp: number, iss: string}}
   */
  getDecodedAccessToken() {
    if (this._payload) {
      this._payload = GeneralUtils.jwtDecode(this._accessToken)
    }
    return this._payload
  }

  /**
   * @return {string}
   */
  getStitchingServiceUrl() {
    return this._stitchingServiceUrl
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this, ['_payload'])
  }

  /**
   * @override
   */
  toString() {
    return `RenderingInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = RenderingInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/RunningSession.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/RunningSession.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const RenderingInfo = __webpack_require__(/*! ./RenderingInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js")

/**
 * Encapsulates data for the session currently running in the agent.
 */
class RunningSession {
  /**
   * @param session
   * @param {string} session.id
   * @param {string} session.sessionId
   * @param {string} session.batchId
   * @param {string} session.baselineId
   * @param {string} session.url
   * @param {RenderingInfo|object} session.renderingInfo
   */
  constructor({id, sessionId, batchId, baselineId, url, renderingInfo, isNew} = {}) {
    if (renderingInfo && !(renderingInfo instanceof RenderingInfo)) {
      renderingInfo = new RenderingInfo(renderingInfo)
    }

    this._id = id
    this._sessionId = sessionId
    this._batchId = batchId
    this._baselineId = baselineId
    this._url = url
    this._renderingInfo = renderingInfo
    this._isNew = isNew
  }

  /**
   * @return {string}
   */
  getId() {
    return this._id
  }

  /**
   * @param {string} value
   */
  setId(value) {
    this._id = value
  }

  /**
   * @return {string}
   */
  getSessionId() {
    return this._sessionId
  }

  /**
   * @param {string} value
   */
  setSessionId(value) {
    this._sessionId = value
  }

  /**
   * @return {string}
   */
  getBatchId() {
    return this._batchId
  }

  /**
   * @param {string} value
   */
  setBatchId(value) {
    this._batchId = value
  }

  /**
   * @return {string}
   */
  getBaselineId() {
    return this._baselineId
  }

  /**
   * @param {string} value
   */
  setBaselineId(value) {
    this._baselineId = value
  }

  /**
   * @return {string}
   */
  getUrl() {
    return this._url
  }

  /**
   * @param {string} value
   */
  setUrl(value) {
    this._url = value
  }

  /**
   * @return {RenderingInfo}
   */
  getRenderingInfo() {
    return this._renderingInfo
  }

  /**
   * @param {RenderingInfo} value
   */
  setRenderingInfo(value) {
    this._renderingInfo = value
  }

  /**
   * @return {boolean}
   */
  getIsNew() {
    return this._isNew
  }

  /**
   * @param {boolean} value
   */
  setIsNew(value) {
    this._isNew = value
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `RunningSession { ${JSON.stringify(this)} }`
  }
}

module.exports = RunningSession


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/ServerConnector.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];

const Axios = __webpack_require__(/*! axios */ "./node_modules/axios/index.js")
const zlib = __webpack_require__(/*! zlib */ "./node_modules/browserify-zlib/lib/index.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const RenderingInfo = __webpack_require__(/*! ./RenderingInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js")
const RunningSession = __webpack_require__(/*! ./RunningSession */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RunningSession.js")
const {configureAxios, delayRequest, handleRequestResponse, handleRequestError} = __webpack_require__(/*! ./requestHelpers */ "./node_modules/@applitools/eyes-sdk-core/lib/server/requestHelpers.js")
const TestResults = __webpack_require__(/*! ../TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")
const MatchResult = __webpack_require__(/*! ../match/MatchResult */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js")

const RunningRender = __webpack_require__(/*! ../renderer/RunningRender */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RunningRender.js")
const RenderStatusResults = __webpack_require__(/*! ../renderer/RenderStatusResults */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatusResults.js")

// Constants
const EYES_API_PATH = '/api/sessions'
const DEFAULT_TIMEOUT_MS = 300000 // ms (5 min)
const REDUCED_TIMEOUT_MS = 15000 // ms (15 sec)
const RETRY_REQUEST_INTERVAL = 500 // 0.5s
const DELAY_BEFORE_POLLING = [].concat(
  Array(5).fill(500), // 5 tries with delay 0.5s
  Array(5).fill(1000), // 5 tries with delay 1s
  Array(5).fill(2000), // 5 tries with delay 2s
  5000, // all next tries with delay 5s
)
const CONCURRENCY_BACKOFF = [].concat(
  Array(5).fill(2000), // 5 tries with delay 2s (total 10s)
  Array(4).fill(5000), // 4 tries with delay 5s (total 20s)
  10000, // all next tries with delay 10s
)

const DEFAULT_HEADERS = {
  Accept: 'application/json',
  'Content-Type': 'application/json',
}

const HTTP_STATUS_CODES = {
  CREATED: 201,
  ACCEPTED: 202,
  OK: 200,
  GONE: 410,
  NOT_FOUND: 404,
  INTERNAL_SERVER_ERROR: 500,
  BAD_GATEWAY: 502,
  GATEWAY_TIMEOUT: 504,
}

const AZURE_RETRY_CONFIG = {
  delayBeforeRetry: 500,
  retry: 5,
}

const REQUEST_GUID = GeneralUtils.guid()
let requestCounter = 0
function createRequestId() {
  return `${++requestCounter}--${REQUEST_GUID}`
}

/**
 * Creates a bytes representation of the given JSON.
 *
 * @private
 * @param {object} jsonData - The data from for which to create the bytes representation.
 * @return {Buffer} - a buffer of bytes which represents the stringified JSON, prefixed with size.
 */
const createDataBytes = jsonData => {
  const dataStr = JSON.stringify(jsonData)
  const dataLen = Buffer.byteLength(dataStr, 'utf8')

  // The result buffer will contain the length of the data + 4 bytes of size
  const result = Buffer.alloc(dataLen + 4)
  result.writeUInt32BE(dataLen, 0)
  result.write(dataStr, 4, dataLen)
  return result
}

/**
 * Provides an API for communication with the Applitools server.
 */
class ServerConnector {
  /**
   * @param {Logger} logger
   * @param {Configuration} configuration
   */
  constructor({logger, configuration, getAgentId}) {
    this._logger = logger
    this._configuration = configuration

    /** @type {RenderingInfo} */
    this._renderingInfo = undefined

    this._axios = Axios.create({
      withApiKey: true,
      retry: 5,
      repeat: 0,
      delayBeforeRetry: 200,
      delayBeforePolling: DELAY_BEFORE_POLLING,
      concurrencyBackoff: CONCURRENCY_BACKOFF,
      createRequestId,
      proxy: undefined,
      headers: DEFAULT_HEADERS,
      timeout: DEFAULT_TIMEOUT_MS,
      responseType: 'json',
      maxBodyLength: 200 * 1024 * 1024, // 200 MB
    })

    this._axios.interceptors.request.use(async config => {
      const axiosConfig = Object.assign({}, this._axios.defaults, config)
      axiosConfig.requestId = axiosConfig.createRequestId()
      configureAxios({
        axiosConfig,
        configuration: this._configuration,
        logger: this._logger,
        agentId: getAgentId(),
      })

      const dataLength = axiosConfig.data && axiosConfig.data.length
      const dataLengthStr = dataLength ? ` and body length ${axiosConfig.data.length}` : ''

      this._logger.verbose(
        `axios request interceptor - ${axiosConfig.name} [${axiosConfig.requestId}${
          axiosConfig.originalRequestId ? ` retry of ${axiosConfig.originalRequestId}` : ''
        }] will now call to ${axiosConfig.url} with params ${JSON.stringify(axiosConfig.params)}${dataLengthStr}`,
      )

      await delayRequest({axiosConfig, logger})

      return axiosConfig
    })
    this._axios.interceptors.response.use(
      response => handleRequestResponse({response, axios: this._axios, logger: this._logger}),
      err => handleRequestError({err, axios: this._axios, logger: this._logger}),
    )
  }

  /**
   * @return {RenderingInfo}
   */
  getRenderingInfo() {
    return this._renderingInfo
  }

  /**
   * @param {RenderingInfo} renderingInfo
   */
  setRenderingInfo(renderingInfo) {
    ArgumentGuard.notNull(renderingInfo, 'renderingInfo')
    this._renderingInfo = renderingInfo
  }

  /**
   * Starts a new running session in the agent. Based on the given parameters, this running session will either be
   * linked to an existing session, or to a completely new session.
   *
   * @param {SessionStartInfo} sessionStartInfo - The start parameters for the session.
   * @return {Promise<RunningSession>} - RunningSession object which represents the current running session
   */
  async startSession(sessionStartInfo) {
    ArgumentGuard.notNull(sessionStartInfo, 'sessionStartInfo')
    this._logger.verbose(`ServerConnector.startSession called with: ${sessionStartInfo}`)

    const config = {
      name: 'startSession',
      method: 'POST',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), EYES_API_PATH, '/running'),
      data: {
        startInfo: sessionStartInfo,
      },
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK, HTTP_STATUS_CODES.CREATED]
    if (validStatusCodes.includes(response.status)) {
      const runningSession = new RunningSession(response.data)
      if (response.data.isNew === undefined) {
        runningSession.setIsNew(response.status === HTTP_STATUS_CODES.CREATED)
      }
      this._logger.verbose('ServerConnector.startSession - post succeeded', runningSession)
      return runningSession
    }

    throw new Error(`ServerConnector.startSession - unexpected status (${response.statusText})`)
  }

  /**
   * Stops the running session.
   *
   * @param {RunningSession} runningSession - The running session to be stopped.
   * @param {boolean} isAborted
   * @param {{updateBaselineIfDifferent: boolean, updateBaselineIfNew: boolean}} save
   * @return {Promise<TestResults>} - TestResults object for the stopped running session
   */
  async stopSession(runningSession, isAborted, {updateBaselineIfDifferent, updateBaselineIfNew} = {}) {
    ArgumentGuard.notNull(runningSession, 'runningSession')
    this._logger.verbose(
      `ServerConnector.stopSession called with ${JSON.stringify({
        isAborted,
        updateBaselineIfNew,
        updateBaselineIfDifferent,
      })} for session: ${runningSession}`,
    )

    const config = {
      name: 'stopSession',
      method: 'DELETE',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/running',
        encodeURIComponent(runningSession.getId()),
      ),
      params: {
        aborted: isAborted,
        updateBaseline: runningSession.getIsNew() ? updateBaselineIfNew : updateBaselineIfDifferent,
        // updateBaselineIfNew,
        // updateBaselineIfDifferent,
      },
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      const testResults = new TestResults(response.data)
      this._logger.verbose('ServerConnector.stopSession - post succeeded', testResults)
      return testResults
    }

    throw new Error(`ServerConnector.stopSession - unexpected status (${response.statusText})`)
  }

  /**
   * Stops the running batch sessions.
   *
   * @param {string} batchId - The batchId to be stopped.
   * @return {Promise<void>}
   */
  async deleteBatchSessions(batchId) {
    ArgumentGuard.notNull(batchId, 'batchId')
    this._logger.verbose(`ServerConnector.deleteBatchSessions called for batchId: ${batchId}`)

    const config = {
      name: 'deleteBatchSessions',
      method: 'DELETE',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/batches',
        batchId,
        '/close/bypointerid',
      ),
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.deleteBatchSessions - delete succeeded')
      return
    }

    throw new Error(`ServerConnector.deleteBatchSessions - unexpected status (${response.statusText})`)
  }

  /**
   * Deletes the given test result
   *
   * @param {TestResults} testResults - The session to delete by test results.
   * @return {Promise}
   */
  async deleteSession(testResults) {
    ArgumentGuard.notNull(testResults, 'testResults')
    this._logger.verbose(`ServerConnector.deleteSession called with ${JSON.stringify(testResults)}`)

    const config = {
      name: 'deleteSession',
      method: 'DELETE',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/batches/',
        testResults.getBatchId(),
        '/',
        testResults.getId(),
      ),
      params: {
        accessToken: testResults.getSecretToken(),
      },
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.deleteSession - delete succeeded')
      return
    }

    throw new Error(`ServerConnector.stopSession - unexpected status (${response.statusText})`)
  }

  async uploadScreenshot(id, screenshot) {
    const url = this._renderingInfo.getResultsUrl().replace('__random__', id)
    const config = {
      name: 'uploadScreenshot',
      method: 'PUT',
      url,
      data: screenshot,
      headers: {
        Date: new Date().toISOString(),
        'x-ms-blob-type': 'BlockBlob',
        'content-type': 'application/octet-stream',
      },
      ...AZURE_RETRY_CONFIG,
    }

    const response = await this._axios.request(config)
    if (response.status !== HTTP_STATUS_CODES.CREATED) {
      throw new Error(`ServerConnector.uploadScreenshot - unexpected status (${response.statusText})`)
    }

    return url
  }

  /**
   * Matches the current window (held by the WebDriver) to the expected window.
   *
   * @param {RunningSession} runningSession - The current agent's running session.
   * @param {MatchWindowData} matchWindowData - Encapsulation of a capture taken from the application.
   * @return {Promise<MatchResult>} - The results of the window matching.
   */
  async matchWindow(runningSession, matchWindowData) {
    ArgumentGuard.notNull(runningSession, 'runningSession')
    ArgumentGuard.notNull(matchWindowData, 'matchWindowData')
    this._logger.verbose(`ServerConnector.matchWindow called with ${matchWindowData} for session: ${runningSession}`)

    const config = {
      name: 'matchWindow',
      method: 'POST',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/running',
        encodeURIComponent(runningSession.getId()),
      ),
      headers: {},
      data: matchWindowData,
    }

    if (matchWindowData.getAppOutput().getScreenshot64()) {
      // if there is screenshot64, then we will send application/octet-stream body instead of application/json
      const screenshot64 = matchWindowData.getAppOutput().getScreenshot64()
      matchWindowData.getAppOutput().setScreenshot64(null) // remove screenshot64 from json
      config.headers['Content-Type'] = 'application/octet-stream'

      config.data = Buffer.concat([createDataBytes(matchWindowData), screenshot64])
      matchWindowData.getAppOutput().setScreenshot64(screenshot64)
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      const matchResult = new MatchResult(response.data)
      this._logger.verbose('ServerConnector.matchWindow - post succeeded', matchResult)
      return matchResult
    }

    throw new Error(`ServerConnector.matchWindow - unexpected status (${response.statusText})`)
  }

  async matchWindowAndClose(runningSession, matchWindowData) {
    if (this._matchWindowAndCloseFallback) {
      this._logger.verbose('ServerConnector.matchWindowAndClose was not found in the previous call. Fallback is used')
      await this.matchWindow(runningSession, matchWindowData)
      return this.stopSession(runningSession, false, {
        updateBaselineIfNew: matchWindowData.getUpdateBaselineIfNew(),
        updateBaselineIfDifferent: matchWindowData.getUpdateBaselineIfDifferent(),
      })
    }
    ArgumentGuard.notNull(runningSession, 'runningSession')
    ArgumentGuard.notNull(matchWindowData, 'matchWindowData')
    this._logger.verbose(
      `ServerConnector.matchWindowAndClose called with ${matchWindowData} for session: ${runningSession}`,
    )

    const config = {
      name: 'matchWindow',
      method: 'POST',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/running',
        encodeURIComponent(runningSession.getId()),
        '/matchandend',
      ),
      headers: {},
      data: matchWindowData,
      dontRetryOn404: true,
    }

    if (matchWindowData.getAppOutput().getScreenshot64()) {
      // if there is screenshot64, then we will send application/octet-stream body instead of application/json
      const screenshot64 = matchWindowData.getAppOutput().getScreenshot64()
      matchWindowData.getAppOutput().setScreenshot64(null) // remove screenshot64 from json
      config.headers['Content-Type'] = 'application/octet-stream'

      config.data = Buffer.concat([createDataBytes(matchWindowData), screenshot64])
      matchWindowData.getAppOutput().setScreenshot64(screenshot64)
    }

    let response
    try {
      response = await this._axios.request(config)
    } catch (err) {
      response = err.response || {}
    }
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      const testResults = new TestResults(response.data)
      this._logger.verbose('ServerConnector.matchWindowAndClose - post succeeded', testResults)
      return testResults
    } else if (response.status === HTTP_STATUS_CODES.NOT_FOUND) {
      this._matchWindowAndCloseFallback = true
      this._logger.verbose('ServerConnector.matchWindowAndClose was not found. Fallback is used')
      await this.matchWindow(runningSession, matchWindowData)
      return this.stopSession(runningSession, false, {
        updateBaselineIfNew: matchWindowData.getUpdateBaselineIfNew(),
        updateBaselineIfDifferent: matchWindowData.getUpdateBaselineIfDifferent(),
      })
    }

    throw new Error(`ServerConnector.matchWindowAndClose - unexpected status (${response.statusText})`)
  }

  /**
   * Replaces an actual image in the current running session.
   *
   * @param {RunningSession} runningSession - The current agent's running session.
   * @param {number} stepIndex - The zero based index of the step in which to replace the actual image.
   * @param {MatchWindowData} matchWindowData - Encapsulation of a capture taken from the application.
   * @return {Promise<MatchResult>} - The results of the window matching.
   */
  async replaceWindow(runningSession, stepIndex, matchWindowData) {
    ArgumentGuard.notNull(runningSession, 'runningSession')
    ArgumentGuard.notNull(matchWindowData, 'matchWindowData')
    this._logger.verbose(`ServerConnector.replaceWindow called with ${matchWindowData} for session: ${runningSession}`)

    const config = {
      name: 'replaceWindow',
      method: 'PUT',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/running',
        runningSession.getId(),
        stepIndex,
      ),
      headers: {
        'Content-Type': 'application/octet-stream',
      },
      data: Buffer.concat([createDataBytes(matchWindowData), matchWindowData.getAppOutput().getScreenshot64()]),
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      const matchResult = new MatchResult(response.data)
      this._logger.verbose('ServerConnector.replaceWindow - post succeeded', matchResult)
      return matchResult
    }

    throw new Error(`ServerConnector.replaceWindow - unexpected status (${response.statusText})`)
  }

  /**
   * Initiate a rendering using RenderingGrid API
   *
   * @return {Promise<RenderingInfo>} - The results of the render request
   */
  async renderInfo() {
    this._logger.verbose('ServerConnector.renderInfo called.')

    const config = {
      name: 'renderInfo',
      method: 'GET',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), EYES_API_PATH, '/renderinfo'),
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._renderingInfo = new RenderingInfo(response.data)
      this._logger.verbose('ServerConnector.renderInfo - post succeeded', this._renderingInfo)
      return this._renderingInfo
    }

    throw new Error(`ServerConnector.renderInfo - unexpected status (${response.statusText})`)
  }

  async batchInfo(batchId) {
    ArgumentGuard.notNullOrEmpty(batchId, 'batchId')
    this._logger.verbose('ServerConnector.batchInfo called.')

    const config = {
      name: 'batchInfo',
      method: 'GET',
      url: GeneralUtils.urlConcat(
        this._configuration.getServerUrl(),
        EYES_API_PATH,
        '/batches',
        batchId,
        'config/bypointerId',
      ),
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.batchInfo - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.batchInfo - unexpected status (${response.statusText})`)
  }

  /**
   * Initiate a rendering using RenderingGrid API
   *
   * @param {RenderRequest[]|RenderRequest} renderRequest - The current agent's running session.
   * @return {Promise<RunningRender[]|RunningRender>} - The results of the render request
   */
  async render(renderRequest) {
    ArgumentGuard.notNull(renderRequest, 'renderRequest')
    this._logger.verbose(`ServerConnector.render called with ${renderRequest}`)

    const isBatch = Array.isArray(renderRequest)
    const config = {
      name: 'render',
      withApiKey: false,
      method: 'POST',
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/render'),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
      },
      data: isBatch ? renderRequest : [renderRequest],
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      let runningRender = Array.from(response.data).map(resultsData => new RunningRender(resultsData))
      if (!isBatch) {
        runningRender = runningRender[0]
      }

      this._logger.verbose('ServerConnector.render - post succeeded', runningRender)
      return runningRender
    }

    throw new Error(`ServerConnector.render - unexpected status (${response.statusText})`)
  }

  async renderGetRenderJobInfo(renderRequests) {
    ArgumentGuard.notNull(renderRequests, 'renderRequests')
    this._logger.verbose(`ServerConnector.renderGetRenderJobInfo called with ${renderRequests}`)

    const config = {
      name: 'renderGetRenderJobInfo',
      withApiKey: false,
      method: 'POST',
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/job-info'),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
      },
      data: renderRequests,
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.renderGetRenderJobInfo - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.renderGetRendererInfo - unexpected status (${response.statusText})`)
  }

  /**
   * Checks if resources already exist on the server
   *
   * @param {RGridResource[]} resources - The resource to use
   * @return {Promise<boolean[]>} - Whether resource exists on the server or not
   */
  async renderCheckResources(resources) {
    ArgumentGuard.notNull(resources, 'resources')
    const hashes = resources.map(resource => resource.getHashAsObject())
    this._logger.verbose(`ServerConnector.renderCheckResources called with resources - ${hashes.map(({hash}) => hash)}`)

    const config = {
      name: 'renderCheckResources',
      withApiKey: false,
      method: 'POST',
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/resources/query/resources-exist/'),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
      },
      params: {
        'render-id': GeneralUtils.guid(),
      },
      data: hashes,
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.renderCheckResources - request succeeded')
      return response.data
    }

    throw new Error(`ServerConnector.renderCheckResources - unexpected status (${response.statusText})`)
  }

  /**
   * Upload resource to the server
   *
   * @param {RGridResource} resource - The resource to upload
   * @return {Promise<boolean>} - True if resource was uploaded
   */
  async renderPutResource(resource) {
    ArgumentGuard.notNull(resource, 'resource')
    ArgumentGuard.notNull(resource.getContent(), 'resource.getContent()')
    this._logger.verbose(`ServerConnector.putResource called with resource#${resource.getSha256Hash()}`)

    const config = {
      name: 'renderPutResource',
      withApiKey: false,
      method: 'PUT',
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/resources/sha256/', resource.getSha256Hash()),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
        'Content-Type': resource.getContentType(),
      },
      maxBodyLength: 15.5 * 1024 * 1024, // 15.5 MB  (VG limit is 16MB)
      params: {
        'render-id': GeneralUtils.guid(),
      },
      data: resource.getContent(),
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.putResource - request succeeded. Response:', response.data)
      return true
    }

    throw new Error(
      `ServerConnector.putResource - unexpected status (${response.statusText}) for resource ${resource.getUrl() ||
        ''} ${resource.getContentType()}`,
    )
  }

  /**
   * Get the rendering status for current render
   *
   * @param {RunningRender} runningRender - The running render
   * @param {boolean} [delayBeforeRequest=false] - If {@code true}, then the request will be delayed
   * @return {Promise<RenderStatusResults>} - The render's status
   */
  renderStatus(runningRender, delayBeforeRequest = false) {
    return this.renderStatusById(runningRender.getRenderId(), delayBeforeRequest)
  }

  /**
   * Get the rendering status for current render
   *
   * @param {string[]|string} renderId - The running renderId
   * @param {boolean} [delayBeforeRequest=false] - If {@code true}, then the request will be delayed
   * @return {Promise<RenderStatusResults[]|RenderStatusResults>} - The render's status
   */
  async renderStatusById(renderId, delayBeforeRequest = false) {
    ArgumentGuard.notNull(renderId, 'renderId')
    this._logger.verbose(`ServerConnector.renderStatus called for render: ${renderId}`)

    const isBatch = Array.isArray(renderId)
    const config = {
      name: 'renderStatus',
      retry: 3,
      delay: delayBeforeRequest ? RETRY_REQUEST_INTERVAL : null,
      delayBeforeRetry: RETRY_REQUEST_INTERVAL,
      withApiKey: false,
      method: 'POST',
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/render-status'),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
      },
      timeout: REDUCED_TIMEOUT_MS,
      data: isBatch ? renderId : [renderId],
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      let renderStatus = Array.from(response.data).map(resultsData => new RenderStatusResults(resultsData || {}))
      if (!isBatch) {
        renderStatus = renderStatus[0] // eslint-disable-line prefer-destructuring
      }

      this._logger.verbose(`ServerConnector.renderStatus - get succeeded for ${renderId} -`, renderStatus)
      return renderStatus
    }

    throw new Error(`ServerConnector.renderStatus - unexpected status (${response.statusText})`)
  }

  /**
   * @param {string} domJson
   * @return {Promise<string>}
   */
  async postDomSnapshot(id, domJson) {
    ArgumentGuard.notNull(domJson, 'domJson')
    this._logger.verbose('ServerConnector.postDomSnapshot called')
    const url = this._renderingInfo.getResultsUrl().replace('__random__', id)

    const config = {
      name: 'postDomSnapshot',
      method: 'PUT',
      url,
      data: zlib.gzipSync(Buffer.from(domJson)),
      headers: {
        Date: new Date().toISOString(),
        'x-ms-blob-type': 'BlockBlob',
        'Content-Type': 'application/octet-stream',
      },
      ...AZURE_RETRY_CONFIG,
    }

    const response = await this._axios.request(config)
    if (response.status !== HTTP_STATUS_CODES.CREATED) {
      throw new Error(`ServerConnector.postDomSnapshot - unexpected status (${response.statusText})`)
    }

    this._logger.verbose('ServerConnector.postDomSnapshot - post succeeded')
    return url
  }

  async getUserAgents() {
    const config = {
      name: 'getUserAgents',
      withApiKey: false,
      url: GeneralUtils.urlConcat(this._renderingInfo.getServiceUrl(), '/user-agents'),
      headers: {
        'X-Auth-Token': this._renderingInfo.getAccessToken(),
      },
    }

    const response = await this._axios.request(config)
    if (response.status === HTTP_STATUS_CODES.OK) {
      return response.data
    } else {
      throw new Error(`ServerConnector.getUserAgents - unexpected status (${response.statusText})`)
    }
  }

  /**
   * Visual locators
   * @template {string} TLocatorName
   * @param {Object} visualLocatorData
   * @param {string} visualLocatorData.appName
   * @param {string} visualLocatorData.imageUrl
   * @param {Readonly<TLocatorName[]>} visualLocatorData.locatorNames
   * @param {string} visualLocatorData.firstOnly
   * @return {Promise<{[TKey in TLocatorName]: RegionObject[]}>}
   */
  async postLocators(visualLocatorData) {
    ArgumentGuard.notNull(visualLocatorData, 'visualLocatorData')
    this._logger.verbose(`ServerConnector.postLocators called with ${JSON.stringify(visualLocatorData)}`)

    const config = {
      name: 'postLocators',
      method: 'POST',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), 'api/locators/locate'),
      data: visualLocatorData,
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.postLocators - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.postLocators - unexpected status (${response.statusText})`)
  }

  async extractText({screenshotUrl, domUrl, location, region, minMatch, language}) {
    ArgumentGuard.notNull(screenshotUrl, 'screenshotUrl')
    this._logger.verbose(
      `ServerConnector.extractText called with ${JSON.stringify({
        screenshotUrl,
        domUrl,
        region,
        location,
        minMatch,
        language,
      })}`,
    )

    const config = {
      name: 'extractText',
      method: 'POST',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), EYES_API_PATH, '/running/images/text'),
      data: {
        appOutput: {screenshotUrl, domUrl, location},
        regions: [region],
        minMatch,
        language,
      },
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.extractText - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.extractText - unexpected status (${response.statusText})`)
  }

  async extractTextRegions({screenshotUrl, domUrl, location, patterns, ignoreCase, firstOnly, language}) {
    ArgumentGuard.notNull(screenshotUrl, 'screenshotUrl')
    this._logger.verbose(
      `ServerConnector.extractTextRegions called with ${JSON.stringify({
        screenshotUrl,
        domUrl,
        location,
        patterns,
        ignoreCase,
        firstOnly,
        language,
      })}`,
    )

    const config = {
      name: 'extractTextRegions',
      method: 'POST',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), EYES_API_PATH, '/running/images/textregions'),
      data: {
        appOutput: {screenshotUrl, domUrl, location},
        patterns,
        ignoreCase,
        firstOnly,
        language,
      },
    }

    const response = await this._axios.request(config)
    const validStatusCodes = [HTTP_STATUS_CODES.OK]
    if (validStatusCodes.includes(response.status)) {
      this._logger.verbose('ServerConnector.extractTextRegions - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.extractTextRegions - unexpected status (${response.statusText})`)
  }

  async getEmulatedDevicesSizes(serviceUrl) {
    this._logger.verbose(`ServerConnector.getEmulatedDevicesSizes`)

    const config = {
      name: 'getEmulatedDevicesSizes',
      method: 'GET',
      withApiKey: false,
      url: GeneralUtils.urlConcat(serviceUrl || this._renderingInfo.getServiceUrl(), '/emulated-devices-sizes'),
    }

    const response = await this._axios.request(config)
    if (response.status === HTTP_STATUS_CODES.OK) {
      return response.data
    } else {
      throw new Error(`ServerConnector.getEmulatedDevicesSizes - unexpected status (${response.statusText})`)
    }
  }

  async getIosDevicesSizes(serviceUrl) {
    this._logger.verbose(`ServerConnector.getIosDevicesSizes`)

    const config = {
      name: 'getIosDevicesSizes',
      method: 'GET',
      url: GeneralUtils.urlConcat(serviceUrl || this._renderingInfo.getServiceUrl(), '/ios-devices-sizes'),
    }

    const response = await this._axios.request(config)
    if (response.status === HTTP_STATUS_CODES.OK) {
      return response.data
    } else {
      throw new Error(`ServerConnector.getIosDevicesSizes - unexpected status (${response.statusText})`)
    }
  }

  /**
   * @param {LogEvent[]} events
   * @return {Promise<string>}
   */
  async logEvents(events) {
    ArgumentGuard.isArray(events, 'events')
    this._logger.verbose(`ServerConnector.logEvents called with ${events.length} events`)

    const config = {
      name: 'logEvents',
      method: 'POST',
      url: GeneralUtils.urlConcat(this._configuration.getServerUrl(), EYES_API_PATH, '/log'),
      data: {events},
    }

    const response = await this._axios.request(config)
    if (response.status === HTTP_STATUS_CODES.OK) {
      this._logger.verbose('ServerConnector.logEvents - post succeeded', response.data)
      return response.data
    }

    throw new Error(`ServerConnector.logEvents - unexpected status (${response.statusText})`)
  }
}

module.exports = ServerConnector


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/SessionStartInfo.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/SessionStartInfo.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")

/**
 * Encapsulates data required to start session using the Session API.
 */
class SessionStartInfo {
  /**
   * @param {object} info
   * @param {string} info.agentId
   * @param {SessionType} [info.sessionType]
   * @param {string} info.appIdOrName
   * @param {string} [info.verId]
   * @param {string} info.scenarioIdOrName
   * @param {string} [info.displayName]
   * @param {BatchInfo} info.batchInfo
   * @param {string} [info.baselineEnvName]
   * @param {string} [info.environmentName]
   * @param {AppEnvironment} info.environment
   * @param {ImageMatchSettings} info.defaultMatchSettings
   * @param {string} [info.branchName]
   * @param {string} [info.parentBranchName]
   * @param {string} [info.parentBranchBaselineSavedBefore]
   * @param {string} [info.baselineBranchName]
   * @param {boolean} [info.compareWithParentBranch]
   * @param {boolean} [info.ignoreBaseline]
   * @param {boolean} [info.saveDiffs]
   * @param {boolean} [info.render]
   * @param {PropertyData[]} [info.properties]
   * @param {number} [info.timeout]
   */
  constructor({
    agentId,
    sessionType,
    appIdOrName,
    verId,
    scenarioIdOrName,
    displayName,
    batchInfo,
    baselineEnvName,
    environmentName,
    environment,
    defaultMatchSettings,
    branchName,
    parentBranchName,
    parentBranchBaselineSavedBefore,
    baselineBranchName,
    compareWithParentBranch,
    ignoreBaseline,
    saveDiffs,
    render,
    properties,
    agentSessionId,
    agentRunId,
    timeout,
  } = {}) {
    ArgumentGuard.notNullOrEmpty(agentId, 'agentId')
    ArgumentGuard.notNullOrEmpty(appIdOrName, 'appIdOrName')
    ArgumentGuard.notNullOrEmpty(scenarioIdOrName, 'scenarioIdOrName')
    ArgumentGuard.notNull(batchInfo, 'batchInfo')
    ArgumentGuard.notNull(environment, 'environment')
    ArgumentGuard.notNull(defaultMatchSettings, 'defaultMatchSettings')

    this._agentId = agentId
    this._sessionType = sessionType
    this._appIdOrName = appIdOrName
    this._verId = verId
    this._scenarioIdOrName = scenarioIdOrName
    this._displayName = displayName
    this._batchInfo = batchInfo
    this._baselineEnvName = baselineEnvName
    this._environmentName = environmentName
    this._environment = environment
    this._defaultMatchSettings = defaultMatchSettings
    this._branchName = branchName
    this._parentBranchName = parentBranchName
    this._parentBranchBaselineSavedBefore = parentBranchBaselineSavedBefore
    this._baselineBranchName = baselineBranchName
    this._compareWithParentBranch = compareWithParentBranch
    this._ignoreBaseline = ignoreBaseline
    this._saveDiffs = saveDiffs
    this._render = render
    this._properties = properties
    this._concurrencyVersion = 2
    this._agentSessionId = agentSessionId
    this._agentRunId = agentRunId
    this._timeout = timeout
  }

  /**
   * @return {string}
   */
  getAgentId() {
    return this._agentId
  }

  /**
   * @return {SessionType}
   */
  getSessionType() {
    return this._sessionType
  }

  /**
   * @return {string}
   */
  getAppIdOrName() {
    return this._appIdOrName
  }

  /**
   * @return {string}
   */
  getVerId() {
    return this._verId
  }

  /**
   * @return {string}
   */
  getScenarioIdOrName() {
    return this._scenarioIdOrName
  }

  /**
   * @return {string}
   */
  getDisplayName() {
    return this._displayName
  }

  /**
   * @return {BatchInfo}
   */
  getBatchInfo() {
    return this._batchInfo
  }

  /**
   * @return {string}
   */
  getBaselineEnvName() {
    return this._baselineEnvName
  }

  /**
   * @return {string}
   */
  getEnvironmentName() {
    return this._environmentName
  }

  /**
   * @return {AppEnvironment}
   */
  getEnvironment() {
    return this._environment
  }

  /**
   * @return {ImageMatchSettings}
   */
  getDefaultMatchSettings() {
    return this._defaultMatchSettings
  }

  /**
   * @return {string}
   */
  getBranchName() {
    return this._branchName
  }

  /**
   * @return {string}
   */
  getParentBranchName() {
    return this._parentBranchName
  }

  /**
   * @return {string}
   */
  getParentBranchBaselineSavedBefore() {
    return this._parentBranchBaselineSavedBefore
  }

  // noinspection JSUnusedGlobalSymbols
  /**
   * @return {string}
   */
  getBaselineBranchName() {
    return this._baselineBranchName
  }

  /**
   * @return {boolean}
   */
  getCompareWithParentBranch() {
    return this._compareWithParentBranch
  }

  /**
   * @return {boolean}
   */
  getIgnoreBaseline() {
    return this._ignoreBaseline
  }

  /**
   * @return {PropertyData[]}
   */
  getProperties() {
    return this._properties
  }

  /**
   * @return {boolean} If true, createSession request will return renderingInfo properties
   */
  getRender() {
    return this._render
  }

  /**
   * @return {boolean}
   */
  getSaveDiffs() {
    return this._saveDiffs
  }

  /**
   * @override
   */
  toJSON() {
    return GeneralUtils.toPlain(this)
  }

  /**
   * @override
   */
  toString() {
    return `SessionStartInfo { ${JSON.stringify(this)} }`
  }
}

module.exports = SessionStartInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const tunnel = __webpack_require__(/*! tunnel */ "?106e")

// TODO proper types
/**
 * @typedef {import('../config/ProxySettings').ProxyObject} ProxyObject
 */

/**
 * @param {proxyObject} proxyObject
 * @return {Agent}
 */
function getTunnelAgentFromProxy(proxyObject) {
  if (tunnel.httpsOverHttp === undefined) {
    throw new Error('http only proxy is not supported in the browser')
  }

  const proxyAuth =
    proxyObject.auth && proxyObject.auth.username
      ? `${proxyObject.auth.username}:${proxyObject.auth.password}`
      : undefined

  return tunnel.httpsOverHttp({
    proxy: {
      host: proxyObject.host,
      port: proxyObject.port || 8080,
      proxyAuth,
    },
  })
}

module.exports = getTunnelAgentFromProxy


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/server/requestHelpers.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/server/requestHelpers.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const getTunnelAgentFromProxy = __webpack_require__(/*! ./getTunnelAgentFromProxy */ "./node_modules/@applitools/eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js")

const DateTimeUtils = __webpack_require__(/*! ../utils/DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")
const TypeUtils = __webpack_require__(/*! ../utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const GeneralUtils = __webpack_require__(/*! ../utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

const HTTP_STATUS_CODES = {
  CREATED: 201,
  ACCEPTED: 202,
  OK: 200,
  GONE: 410,
  NOT_FOUND: 404,
  INTERNAL_SERVER_ERROR: 500,
  BAD_GATEWAY: 502,
  SERVICE_UNAVAILABLE: 503,
  GATEWAY_TIMEOUT: 504,
}

const HTTP_FAILED_CODES = [
  HTTP_STATUS_CODES.NOT_FOUND,
  HTTP_STATUS_CODES.INTERNAL_SERVER_ERROR,
  HTTP_STATUS_CODES.BAD_GATEWAY,
  HTTP_STATUS_CODES.SERVICE_UNAVAILABLE,
  HTTP_STATUS_CODES.GATEWAY_TIMEOUT,
]

const REQUEST_FAILED_CODES = ['ECONNRESET', 'ECONNABORTED', 'ETIMEDOUT', 'ENOTFOUND', 'EAI_AGAIN']

const CUSTOM_HEADER_NAMES = {
  REQUEST_ID: 'x-applitools-eyes-client-request-id',
  AGENT_ID: 'x-applitools-eyes-client',
  EYES_EXPECT: 'Eyes-Expect',
  EYES_EXPECT_VERSION: 'Eyes-Expect-Version',
  EYES_DATE: 'Eyes-Date',
  RETRY_AFTER: 'Retry-After',
}

function configAxiosProxy({axiosConfig, proxy, logger}) {
  const proxyObject = proxy.toProxyObject()
  if (proxy.getIsHttpOnly()) {
    axiosConfig.httpsAgent = getTunnelAgentFromProxy(proxyObject)
    axiosConfig.proxy = false // don't use the proxy, we use tunnel.
    logger.log('proxy is set as http only, using tunnel', proxyObject.host, proxyObject.port)
  } else {
    axiosConfig.proxy = proxyObject
    logger.log('using proxy', axiosConfig.proxy.host, axiosConfig.proxy.port)
  }
}

function configureAxios({axiosConfig, configuration, agentId, logger}) {
  axiosConfig.params = axiosConfig.params || {}
  if (axiosConfig.withApiKey && !('apiKey' in axiosConfig.params)) {
    axiosConfig.params.apiKey = configuration.getApiKey()
  }
  if (!('removeSession' in axiosConfig.params)) {
    const removeSession = configuration.getRemoveSession()
    if (TypeUtils.isNotNull(removeSession)) {
      axiosConfig.params.removeSession = removeSession
    }
  }
  if (!('timeout' in axiosConfig)) {
    const timeout = configuration.getConnectionTimeout()
    if (TypeUtils.isNotNull(timeout)) {
      axiosConfig.timeout = timeout
    }
  }
  if (!('proxy' in axiosConfig)) {
    const proxy = configuration.getProxy()
    if (TypeUtils.isNotNull(proxy)) {
      configAxiosProxy({axiosConfig, proxy, logger})
    }
  }

  axiosConfig.headers = axiosConfig.headers || {}
  if (!(CUSTOM_HEADER_NAMES.AGENT_ID in axiosConfig.headers)) {
    axiosConfig.headers[CUSTOM_HEADER_NAMES.AGENT_ID] = agentId
  }
  if (!(CUSTOM_HEADER_NAMES.REQUEST_ID in axiosConfig.headers)) {
    axiosConfig.headers[CUSTOM_HEADER_NAMES.REQUEST_ID] = axiosConfig.requestId
  }
  // TODO remove when Eyes server stops being backwards compatible with old SDK's that don't support long running tasks
  if (!axiosConfig.isPollingRequest) {
    axiosConfig.headers[CUSTOM_HEADER_NAMES.EYES_EXPECT_VERSION] = '2'
    axiosConfig.headers[CUSTOM_HEADER_NAMES.EYES_EXPECT] = '202+location'
    axiosConfig.headers[CUSTOM_HEADER_NAMES.EYES_DATE] = DateTimeUtils.toRfc1123DateTime(axiosConfig.timestamp)
  }
  // ---
}

async function delayRequest({axiosConfig, logger}) {
  if (axiosConfig.delay) {
    logger.verbose(`axios request interceptor - ${axiosConfig.name} request delayed for ${axiosConfig.delay} ms.`)
    await GeneralUtils.sleep(axiosConfig.delay)
  }
}

async function handleRequestResponse({response, axios, logger}) {
  const {config} = response

  logger.verbose(
    `axios response interceptor - ${config.name} [${config.requestId}] - result ${response.statusText}, status code ${response.status}, url ${config.url}`,
  )

  if (isLongRequest(response)) {
    return startPollingRequest({
      url: response.headers.location,
      delay: response.headers[CUSTOM_HEADER_NAMES.RETRY_AFTER]
        ? Number(response.headers[CUSTOM_HEADER_NAMES.RETRY_AFTER]) * 1000
        : null,
      originalConfig: config,
      axios,
    })
  }

  if (config.isPollingRequest) {
    if (response.status === HTTP_STATUS_CODES.OK) {
      config.repeat += 1
      if (response.headers[CUSTOM_HEADER_NAMES.RETRY_AFTER]) {
        config.delay = Number(response.headers[CUSTOM_HEADER_NAMES.RETRY_AFTER]) * 1000
      } else {
        config.delay = TypeUtils.isArray(config.delayBeforePolling)
          ? config.delayBeforePolling[Math.min(config.repeat, config.delayBeforePolling.length - 1)]
          : config.delayBeforePolling
      }

      if (response.headers.location) {
        config.url = response.headers.location
      }

      return axios.request(config)
    }
  }

  return response
}
function isLongRequest(response) {
  return response.status === HTTP_STATUS_CODES.ACCEPTED && Boolean(response.headers.location)
}
function isConcurrencyBlockedRequest(response) {
  return response.status === HTTP_STATUS_CODES.SERVICE_UNAVAILABLE
}
async function startPollingRequest({url, delay, originalConfig, axios}) {
  const pollingConfig = {
    name: originalConfig.name,
    isPollingRequest: true,
    delayBeforePolling: originalConfig.delayBeforePolling,
    delay:
      delay ||
      (TypeUtils.isArray(originalConfig.delayBeforePolling)
        ? originalConfig.delayBeforePolling[0]
        : originalConfig.delayBeforePolling),
    method: 'GET',
    url,
    repeat: 0,
  }
  const response = await axios.request(pollingConfig)
  switch (response.status) {
    case HTTP_STATUS_CODES.OK:
      return response
    case HTTP_STATUS_CODES.CREATED:
      const {config} = response
      const nextConfig = {
        name: config.name,
        method: 'DELETE', // TODO should be changed to GET when Eyes server will be updated to 10.9
        url: response.headers.location,
        headers: {
          [CUSTOM_HEADER_NAMES.EYES_DATE]: DateTimeUtils.toRfc1123DateTime(),
        },
        originalRequestConfig: originalConfig,
      }
      return axios.request(nextConfig)
    case HTTP_STATUS_CODES.GONE:
      throw new Error('The server task has gone.')
    default:
      throw new Error(`Unknown error during long request: ${JSON.stringify(response)}`)
  }
}

async function handleRequestError({err, axios, logger}) {
  if (!err.config) {
    throw err
  }
  const {response, config} = err
  const reason = `${err.message}${response ? `(${response.statusText})` : ''}`

  logger.log(
    `axios error interceptor - ${config.name} [${config.requestId}] - ${
      config.method
    } request failed. reason=${reason} | url=${config.url} ${
      response ? `| status=${response.status} ` : ''
    }| params=${JSON.stringify(config.params)}`,
  )

  if (response && response.data) {
    logger.verbose(`axios error interceptor - ${config.name} - failure body:\n${response.data}`)
  }

  if (response && response.status === HTTP_STATUS_CODES.NOT_FOUND && config.dontRetryOn404) {
    throw err
  }

  if (response && isConcurrencyBlockedRequest(response)) {
    let backoffIndex, repeat
    if (config.isConcurrencyPolling) {
      backoffIndex = Math.min(config.repeat, config.concurrencyBackoff.length - 1)
      repeat = config.repeat + 1
    } else {
      backoffIndex = 0
      repeat = 0
    }

    return axios.request({
      ...(config.originalRequestConfig || config),
      delay: config.concurrencyBackoff[backoffIndex],
      repeat,
      isConcurrencyPolling: true,
    })
  }

  if (
    config.retry > 0 &&
    ((response && HTTP_FAILED_CODES.includes(response.status)) || REQUEST_FAILED_CODES.includes(err.code))
  ) {
    logger.verbose(`axios error interceptor retrying request with delay ${config.delayBeforeRetry}...`)

    if (config.delayBeforeRetry) {
      config.delay = config.delayBeforeRetry
    }
    config.originalRequestId = config.originalRequestId || config.requestId
    config.repeat += 1
    config.retry -= 1
    return axios.request(config)
  }
  throw new Error(reason)
}

exports.configAxiosProxy = configAxiosProxy
exports.configureAxios = configureAxios
exports.delayRequest = delayRequest

exports.handleRequestResponse = handleRequestResponse

exports.handleRequestError = handleRequestError


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/MouseTrigger.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/triggers/MouseTrigger.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const Trigger = __webpack_require__(/*! ./Trigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/Trigger.js")

/**
 * Encapsulates a text input by the user.
 */
class MouseTrigger extends Trigger {
  /**
   * @param {MouseTrigger.MouseAction} mouseAction
   * @param {Region} control
   * @param {Location} location
   */
  constructor(mouseAction, control, location) {
    super()

    ArgumentGuard.notNull(mouseAction, 'mouseAction')
    ArgumentGuard.notNull(control, 'control')
    ArgumentGuard.notNull(location, 'location')

    this._mouseAction = mouseAction
    this._control = control
    this._location = location // Relative to the top left corner of {@link #control}, or null if unknown.
  }

  /**
   * @return {MouseTrigger.MouseAction}
   */
  getMouseAction() {
    return this._mouseAction
  }

  /**
   * @return {Region}
   */
  getControl() {
    return this._control
  }

  /**
   * @return {Location}
   */
  getLocation() {
    return this._location
  }

  /**
   * @return {Trigger.TriggerType}
   */
  getTriggerType() {
    return Trigger.TriggerType.Mouse
  }

  /**
   * @override
   */
  toString() {
    return `${this._mouseAction} [${this._control}] ${this._location}`
  }
}

/**
 * @readonly
 * @enum {string}
 */
MouseTrigger.MouseAction = {
  None: 'None',
  Click: 'Click',
  RightClick: 'RightClick',
  DoubleClick: 'DoubleClick',
  Move: 'Move',
  Down: 'Down',
  Up: 'Up',
}

Object.freeze(MouseTrigger.MouseAction)
module.exports = MouseTrigger


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/TextTrigger.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/triggers/TextTrigger.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const ArgumentGuard = __webpack_require__(/*! ../utils/ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const Trigger = __webpack_require__(/*! ./Trigger */ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/Trigger.js")

/**
 * Encapsulates a text input by the user.
 */
class TextTrigger extends Trigger {
  /**
   *
   * @param {Region} control
   * @param {string} text
   */
  constructor(control, text) {
    super()

    ArgumentGuard.notNull(control, 'control')
    ArgumentGuard.notNullOrEmpty(text, 'text')

    this._text = text
    this._control = control
  }

  /**
   * @return {string}
   */
  getText() {
    return this._text
  }

  /**
   * @return {Region}
   */
  getControl() {
    return this._control
  }

  /**
   * @return {Trigger.TriggerType}
   */
  getTriggerType() {
    return Trigger.TriggerType.Text
  }

  /**
   * @override
   */
  toString() {
    return `Text [${this._control}] ${this._text}`
  }
}

module.exports = TextTrigger


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/triggers/Trigger.js":
/*!************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/triggers/Trigger.js ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";


/**
 * Encapsulates image retrieval.
 *
 * @abstract
 */
class Trigger {
  /**
   * @return {Trigger.TriggerType}
   */
  getTriggerType() {
    throw new TypeError('The method is not implemented!')
  }
}

/**
 * @readonly
 * @enum {string}
 */
Trigger.TriggerType = {
  Unknown: 'Unknown',
  Mouse: 'Mouse',
  Text: 'Text',
  Keyboard: 'Keyboard',
}

Object.freeze(Trigger.TriggerType)
module.exports = Trigger


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const TypeUtils = __webpack_require__(/*! ./TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")

/**
 * Fails if the input parameter equals the input value.
 *
 * @param {object} param - The input parameter.
 * @param {object} value - The input value.
 * @param {string} paramName - The input parameter name.
 */
function notEqual(param, value, paramName) {
  if (param === value) {
    throw new Error(`IllegalArgument: ${paramName} === ${value}`)
  }
}

/**
 * Fails if the input parameter contains some special characters or punctuation
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 */
function alphanumeric(param, paramName) {
  if (!param.match(/^[a-z0-9]+$/i)) {
    throw new Error(`IllegalArgument: ${paramName} is not alphanumeric`)
  }
}

/**
 * Fails if the input parameter is null.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 */
function notNull(param, paramName) {
  if (param === null || param === undefined) {
    throw new Error(`IllegalArgument: ${paramName} is null or undefined`)
  }
}

/**
 * Fails if the input parameter is not null.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 */
function isNull(param, paramName) {
  if (param !== null && param !== undefined) {
    throw new Error(`IllegalArgument: ${paramName} is not null or undefined`)
  }
}

/**
 * Fails if the input parameter string is null or empty.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 */
function notNullOrEmpty(param, paramName) {
  if (!param) {
    throw new Error(`IllegalArgument: ${paramName} is null or empty`)
  }
}

/**
 * Fails if the input integer parameter is negative.
 *
 * @param {number} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} shouldBeInteger - Whether or not, the number should be en integer
 */
function greaterThanOrEqualToZero(param, paramName, shouldBeInteger = false) {
  if (shouldBeInteger) {
    isInteger(param, paramName)
  }

  if (param < 0) {
    throw new Error(`IllegalArgument: ${paramName} < 0`)
  }
}

/**
 * Fails if the input integer parameter is smaller than 1.
 *
 * @param {number} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} isInteger - Whether or not, the number should be en integer
 */
function greaterThanZero(param, paramName, isInteger = false) {
  if (isInteger) {
    isInteger(param, paramName)
  }

  if (param <= 0) {
    throw new Error(`IllegalArgument: ${paramName} < 1`)
  }
}

/**
 * Fails if the input integer parameter is equal to 0.
 *
 * @param {number} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} isInteger - Whether or not, the number should be en integer
 */
function notZero(param, paramName, isInteger = false) {
  if (isInteger) {
    isInteger(param, paramName)
  }

  if (param === 0) {
    throw new Error(`IllegalArgument: ${paramName} === 0`)
  }
}

/**
 * Fails if the input number is not integer
 *
 * @param {number} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isInteger(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isInteger(param)) {
    throw new Error(`IllegalArgument: ${paramName} is not integer`)
  }
}

/**
 * Fails if param is not a string.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isString(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isString(param)) {
    throw new Error(`IllegalType: ${paramName} is not a string`)
  }
}

/**
 * Fails if param is not a number.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isNumber(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isNumber(param)) {
    throw new Error(`IllegalType: ${paramName} is not a number`)
  }
}

/**
 * Fails if param is not a boolean.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isBoolean(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isBoolean(param)) {
    throw new Error(`IllegalType: ${paramName} is not a boolean`)
  }
}

/**
 * Fails if param is not an array.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isArray(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isArray(param)) {
    throw new Error(`IllegalType: ${paramName} is not an array`)
  }
}

/**
 * Fails if param is not a plain object.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isPlainObject(param, paramName, strict = true) {
  if ((strict || param) && !TypeUtils.isPlainObject(param)) {
    throw new Error(`IllegalType: ${paramName} is not an object`)
  }
}

/**
 * Fails if param is not a buffer.
 *
 * @param {object} param - The input parameter.
 * @param {string} paramName - The input parameter name.
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isBuffer(param, paramName, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !TypeUtils.isBuffer(param)) {
    throw new Error(`IllegalType: ${paramName} is not a buffer`)
  }
}

/**
 * Fails if param is not a base64 string.
 *
 * @param {object} param - The input parameter.
 */
function isBase64(param) {
  if (!TypeUtils.isBase64(param)) {
    throw new Error(`IllegalType: \`${param}\` is not a base64 string`)
  }
}

/**
 * Fails if isValid is false.
 *
 * @param {boolean} isValid - Whether the current state is valid.
 * @param {string} errMsg - A description of the error.
 */
function isValidState(isValid, errMsg) {
  if (!isValid) {
    throw new Error(`IllegalState: ${errMsg}`)
  }
}

/**
 * Fails if isValid is false.
 *
 * @param {object} param - The input parameter.
 * @param {object} type - The expected param type
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isValidType(param, type, strict = true) {
  if ((strict || TypeUtils.isNotNull(param)) && !(param instanceof type)) {
    throw new Error(`IllegalType: ${param} is not instance of ${type.constructor.name}`)
  }
}

/**
 * Fails if isValid is false.
 *
 * @param {*} value - The input value.
 * @param {object} enumObject - The required enum object
 * @param {boolean} [strict=true] - If {@code false} then the value can be null|undefined
 */
function isValidEnumValue(value, enumObject, strict = true) {
  if ((strict || TypeUtils.isNotNull(value)) && !Object.values(enumObject).includes(value)) {
    throw new Error(`IllegalType: ${value} is not a valid '${enumObject._name}' value`)
  }
}

/**
 * Check if object contains all required properties
 *
 * @param {object} object - The input object.
 * @param {string|string[]} properties - The array of properties to test
 * @param {string} paramName - The input parameter name.
 */
function hasProperties(object, properties, paramName) {
  if (!TypeUtils.has(object, properties)) {
    throw new Error(`IllegalArgument: ${paramName} should have the following properties: '${properties}'`)
  }
}

module.exports = {
  notEqual,
  alphanumeric,
  notNull,
  isNull,
  notNullOrEmpty,
  greaterThanOrEqualToZero,
  greaterThanZero,
  notZero,
  isInteger,
  isString,
  isNumber,
  isBoolean,
  isArray,
  isPlainObject,
  isBuffer,
  isBase64,
  isValidState,
  isValidType,
  isValidEnumValue,
  hasProperties,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ConfigUtils.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/ConfigUtils.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const {cosmiconfigSync} = __webpack_require__(/*! cosmiconfig */ "./node_modules/cosmiconfig/dist/index.js")
const GeneralUtils = __webpack_require__(/*! ./GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const Logger = __webpack_require__(/*! ../logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")

function getConfig({configParams = [], configPath, logger = new Logger(!!process.env.APPLITOOLS_SHOW_LOGS)} = {}) {
  const explorer = cosmiconfigSync('applitools', {
    searchPlaces: ['applitools.config.js', 'package.json', 'eyes.config.js', 'eyes.json'],
  })

  let defaultConfig = {}
  try {
    configPath = GeneralUtils.getEnvValue('CONFIG_PATH') || configPath
    const result = configPath ? explorer.load(configPath) : explorer.search()

    if (result) {
      const {config, filepath} = result
      logger.log('Loading configuration from', filepath)
      defaultConfig = config
    }
  } catch (ex) {
    logger.log(`An error occurred while loading configuration. configPath=${configPath}\n`, ex)
  }

  const envConfig = {}
  for (const p of configParams) {
    envConfig[p] = GeneralUtils.getEnvValue(toEnvVarName(p))
    if (envConfig[p] === 'true') {
      envConfig[p] = true
    } else if (envConfig[p] === 'false') {
      envConfig[p] = false
    }
  }

  Object.keys(envConfig).forEach(value => {
    if (envConfig[value] === undefined) {
      delete envConfig[value]
    }
  })

  return Object.assign({}, defaultConfig, envConfig)
}

/**
 * @param {string} camelCaseStr
 * @return {string}
 */
function toEnvVarName(camelCaseStr) {
  return camelCaseStr.replace(/(.)([A-Z])/g, '$1_$2').toUpperCase()
}

module.exports = {
  getConfig,
  toEnvVarName,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const dateFormat = __webpack_require__(/*! dateformat */ "./node_modules/dateformat/lib/dateformat.js")

const DATE_FORMAT_ISO8601 = "yyyy-mm-dd'T'HH:MM:ss'Z'"
const DATE_FORMAT_RFC1123 = "ddd, dd mmm yyyy HH:MM:ss 'GMT'"
const DATE_FORMAT_LOGFILE = 'yyyy_mm_dd__HH_MM_ss_l'

/**
 * Convert a Date object to a ISO-8601 date string
 *
 * @param {Date} [date] - Date which will be converted
 * @return {string} - string formatted as ISO-8601 (yyyy-MM-dd'T'HH:mm:ss'Z')
 */
function toISO8601DateTime(date = new Date()) {
  return dateFormat(date, DATE_FORMAT_ISO8601, true)
}

/**
 * Convert a Date object to a RFC-1123 date string
 *
 * @param {Date} [date] - Date which will be converted
 * @return {string} - string formatted as RFC-1123 (E, dd MMM yyyy HH:mm:ss 'GMT')
 */
function toRfc1123DateTime(date = new Date()) {
  return dateFormat(date, DATE_FORMAT_RFC1123, true)
}

/**
 * @param {Date} [date] - Date which will be converted
 * @param {boolean} [utc=false] - If set to true, then will be used uct time instead of local
 * @return {string} - string formatted for log files (yyyy_mm_dd__HH_MM_ss_l)
 */
function toLogFileDateTime(date = new Date(), utc = false) {
  return dateFormat(date, DATE_FORMAT_LOGFILE, utc)
}

/**
 * Creates {@link Date} instance from an ISO 8601 formatted string.
 *
 * @param {string} dateTime - An ISO 8601 formatted string.
 * @return {Date} - A {@link Date} instance representing the given date and time.
 */
function fromISO8601DateTime(dateTime) {
  return new Date(dateTime)
}

module.exports = {
  toISO8601DateTime,
  toRfc1123DateTime,
  toLogFileDateTime,
  fromISO8601DateTime,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js":
/*!******************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/Enum.js ***!
  \******************************************************************/
/***/ ((module) => {

"use strict";


/**
 * @template {{[key: string]: any}} T
 * @typedef {T[keyof T]} EnumValues
 */

/**
 * @template E
 * @param {string} name
 * @param {E} valuesObj
 * @return {Readonly<E>}
 */
function Enum(name, valuesObj) {
  const enumObj = Object.create({_name: name})
  Object.assign(enumObj, valuesObj)
  Object.freeze(enumObj)
  return enumObj
}

module.exports = Enum


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/FileUtils.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/FileUtils.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js")

/**
 * @param {Buffer} imageBuffer
 * @param {string} filename
 * @return {Promise}
 */
function writeFromBuffer(imageBuffer, filename) {
  return new Promise((resolve, reject) => {
    fs.writeFile(filename, imageBuffer, err => {
      if (err) {
        return reject(err)
      }
      return resolve()
    })
  })
}

/**
 * @param {string} path
 * @return {Promise<Buffer>}
 */
function readToBuffer(path) {
  return new Promise((resolve, reject) => {
    fs.readFile(path, (err, data) => {
      if (err) {
        return reject(err)
      }
      return resolve(data)
    })
  })
}

module.exports = {
  writeFromBuffer,
  readToBuffer,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const merge = __webpack_require__(/*! deepmerge */ "./node_modules/deepmerge/dist/cjs.js")
const {exec} = __webpack_require__(/*! child_process */ "?ecd8")
const {promisify} = __webpack_require__(/*! util */ "./node_modules/util/util.js")
const TypeUtils = __webpack_require__(/*! ./TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
const DateTimeUtils = __webpack_require__(/*! ./DateTimeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/DateTimeUtils.js")
const chalk = __webpack_require__(/*! chalk */ "./node_modules/chalk/source/index.js")
const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")

const promisifiedExec = promisify && exec && promisify(exec)
const ENV_PREFIXES = ['APPLITOOLS_', 'bamboo_APPLITOOLS_']
const ALPHANUMERIC_MASK = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'

/**
 * Concatenate the url to the suffixes - making sure there are no double slashes
 *
 * @param {string} url - The left side of the URL.
 * @param {...string} suffixes - The right side.
 * @return {string} - the URL
 */
function urlConcat(url, ...suffixes) {
  let concatUrl = stripTrailingSlash(url)

  for (let i = 0, l = suffixes.length; i < l; i += 1) {
    /** @type {string} */
    const suffix = String(suffixes[i])
    if (!suffix.startsWith('/') && !(i === l - 1 && suffix.startsWith('?'))) {
      concatUrl += '/'
    }
    concatUrl += stripTrailingSlash(suffix)
  }

  return concatUrl
}

/**
 * If given URL ends with '/', the method with cut it and return URL without it
 *
 * @param {string} url
 * @return {string}
 */
function stripTrailingSlash(url) {
  return url.endsWith('/') ? url.slice(0, -1) : url
}

/**
 * Check if an URL is absolute
 *
 * @param {string} url
 * @return {boolean} - the URL
 */
function isAbsoluteUrl(url) {
  return /^[a-z][a-z0-9+.-]*:/.test(url)
}

/**
 * Add unique query parameter to URL
 *
 * @param {string} url
 * @return {string} - URL with unique query parameter
 */
function generateUniqueUrl(url, query) {
  const uniqueId = guid()
  const uniqueUrl = new URL(url)
  if (!url.includes(query)) uniqueUrl.searchParams.append(query, uniqueId)
  return uniqueUrl.href
}

/**
 * Converts all arguments to a single string, used for logging
 *
 * @param {...*} args
 * @return {string}
 */
function stringify(...args) {
  return args.map(arg => stringifySingle(arg)).join(' ')
}

/**
 * Converts argument to string
 *
 * @param {*} arg
 * @return {string}
 */
function stringifySingle(arg) {
  if (TypeUtils.isObject(arg)) {
    if (!TypeUtils.isPlainObject(arg)) {
      if (arg instanceof Error && arg.stack) {
        return arg.stack
      }

      if (arg instanceof Date) {
        return arg.toISOString()
      }

      if (arg instanceof Array && arg.length) {
        return `[${arg.map(i => stringifySingle(i)).join(',')}]`
      }

      if (typeof arg.toString === 'function' && arg.toString !== Object.prototype.toString) {
        return arg.toString()
      }
    }

    return toString(arg)
  }

  return String(arg)
}

/**
 * Converts object or class to string, used within `toString` method of classes
 *
 * @param {object} object
 * @param {string[]} [exclude]
 * @return {string}
 */
function toString(object, exclude = []) {
  if (!TypeUtils.isPlainObject(object)) {
    object = toPlain(object, exclude)
  }

  try {
    return JSON.stringify(object)
  } catch (err) {
    console.warn("Error on converting to string:", err); // eslint-disable-line
    // console.warn(util.inspect(object, {depth: null, colors: true})); // eslint-disable-line
    return undefined
  }
}

/**
 * Convert a class to plain object
 * Makes all private properties public (remove '_' char from prop names)
 *
 * @param {object} object
 * @param {string[]} [exclude]
 * @param {object} [rename]
 * @return {object}
 */
function toPlain(object, exclude = [], rename = {}) {
  if (object == null) {
    throw new TypeError('Cannot make null plain.')
  }

  const plainObject = {}
  Object.keys(object).forEach(objectKey => {
    let publicKey = objectKey.replace('_', '')
    if (rename[publicKey]) {
      publicKey = rename[publicKey]
    }

    if (Object.prototype.hasOwnProperty.call(object, objectKey) && !exclude.includes(objectKey)) {
      if (object[objectKey] instanceof Object && typeof object[objectKey].toJSON === 'function') {
        plainObject[publicKey] = object[objectKey].toJSON()
      } else if (Array.isArray(object[objectKey])) {
        plainObject[publicKey] = object[objectKey].map(item =>
          typeof item.toJSON === 'function' ? item.toJSON() : item,
        )
      } else {
        plainObject[publicKey] = object[objectKey]
      }
    }
  })
  return plainObject
}

/**
 * Merge two objects x and y deeply, returning a new merged object with the elements from both x and y.
 * If an element at the same key is present for both x and y, the value from y will appear in the result.
 * Merging creates a new object, so that neither x or y are be modified.
 * @see package 'deepmerge'
 *
 * @template TFirst
 * @template TSecond
 * @param {TFirst} target
 * @param {TSecond} source
 * @return {TFirst|TSecond}
 */
function mergeDeep(target, source) {
  return merge(target, source, {isMergeableObject: TypeUtils.isPlainObject})
}

/**
 * Generate GUID
 *
 * @return {string}
 */
function guid() {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
    const r = (Math.random() * 16) | 0 // eslint-disable-line no-bitwise

    const v = c === 'x' ? r : (r & 0x3) | 0x8 // eslint-disable-line no-bitwise
    return v.toString(16)
  })
}

/**
 * Generate random alphanumeric sequence
 *
 * @return {string}
 */
function randomAlphanumeric(length = 8) {
  let res = ''
  for (let i = 0; i < length; i += 1) {
    res += ALPHANUMERIC_MASK.charAt(Math.floor(Math.random() * ALPHANUMERIC_MASK.length))
  }
  return res
}

/**
 * Waits a specified amount of time before resolving the returned promise.
 *
 * @param {number} ms - The amount of time to sleep in milliseconds.
 * @return {Promise} - A promise which is resolved when sleep is done.
 */
function sleep(ms) {
  if (TypeUtils.isNumber(ms)) {
    return new Promise(resolve => setTimeout(resolve, ms))
  }
}

/**
 * Convert a Date object to a ISO-8601 date string
 *
 * @deprecated Use {@link DateTimeUtils.toISO8601DateTime} instead
 * @param {Date} [date] - Date which will be converted
 * @return {string} - string formatted as ISO-8601 (yyyy-MM-dd'T'HH:mm:ss'Z')
 */
function toISO8601DateTime(date) {
  return DateTimeUtils.toISO8601DateTime(date)
}

/**
 * Convert a Date object to a RFC-1123 date string
 *
 * @deprecated Use {@link DateTimeUtils.toRfc1123DateTime} instead
 * @param {Date} [date] - Date which will be converted
 * @return {string} - string formatted as RFC-1123 (E, dd MMM yyyy HH:mm:ss 'GMT')
 */
function toRfc1123DateTime(date) {
  return DateTimeUtils.toRfc1123DateTime(date)
}

/**
 * @deprecated Use {@link DateTimeUtils.toLogFileDateTime} instead
 * @param {Date} [date] - Date which will be converted
 * @return {string} - string formatted as RFC-1123 (yyyy_mm_dd__HH_MM_ss_l)
 */
function toLogFileDateTime(date) {
  return DateTimeUtils.toLogFileDateTime(date)
}

/**
 * Creates {@link Date} instance from an ISO 8601 formatted string.
 *
 * @deprecated Use {@link DateTimeUtils.fromISO8601DateTime} instead
 * @param {string} dateTime - An ISO 8601 formatted string.
 * @return {Date} - A {@link Date} instance representing the given date and time.
 */
function fromISO8601DateTime(dateTime) {
  return DateTimeUtils.fromISO8601DateTime(dateTime)
}

/**
 * Simple method that decode JSON Web Tokens
 *
 * @param {string} token
 * @return {object}
 */
function jwtDecode(token) {
  let payloadSeg = token.split('.')[1]
  payloadSeg += new Array(5 - (payloadSeg.length % 4)).join('=')
  payloadSeg = payloadSeg.replace(/-/g, '+').replace(/_/g, '/')
  return JSON.parse(Buffer.from(payloadSeg, 'base64').toString())
}

/**
 * Cartesian product of arrays
 *
 * @param {...([]|Object)} arrays - Variable number of arrays of n elements
 * @return {Array<Array<[]>>} - Product of arrays as an array of X arrays of N elements,
 *   where X is the product of the input arrays' lengths
 */
function cartesianProduct(...arrays) {
  const getArrayOf = a => (Array.isArray(a) ? a : [a])
  const prod2 = (a, b) =>
    getArrayOf(b)
      .map(e1 => a.map(e2 => [e1, ...e2]))
      .reduce((arr, e) => arr.concat(e), [])
  const prod = (a, ...rest) => (rest.length > 0 ? prod(prod2(a, rest.pop()), ...rest) : a)
  return prod([[]], ...arrays)
}

/**
 * Get a property of the object by a path string
 *
 * @param {object} object - The object to query.
 * @param {string} path - The path of a property (example: "foo.bar.baz" ).
 * @return {*|undefined} - The value of the given property or `undefined` if the property is not exists.
 */
function getPropertyByPath(object, path) {
  if (!object || !/^([a-zA-Z0-9-_.]+\.)*[a-zA-Z0-9-_.]+$/.test(path)) {
    return undefined // TODO: may be we can throw an error if path is given in wrong format
  }

  let val = object
  for (const key of path.split('.')) {
    val = typeof val === 'object' ? val[key] : undefined
    if (val === undefined) {
      return undefined
    }
  }

  return val
}

/**
 * Get an environment property by property name
 *
 * @param {string} propName The property name to look up
 * @param {boolean=false} isBoolean Whether or not the value should be converted to boolean type
 * @return {*|undefined} - The value of the given property or `undefined` if the property is not exists.
 */
function getEnvValue(propName, isBoolean = false) {
  if (process !== undefined) {
    for (const prefix of ENV_PREFIXES) {
      const value = process.env[prefix + propName]
      if (value !== undefined && value !== 'null') {
        // for boolean values, cast string value
        if (isBoolean && !TypeUtils.isBoolean(value)) {
          return value === 'true'
        }

        return value
      }
    }
  }

  return undefined
}

/**
 * Make sure new param value is set with either backward compatible param or the new param.
 *
 * @param {...object[]} params The parameter map.
 * @param {logger} logger to log errors
 * @example
 *
 * foo({newParam, oldPram}) {
 *    ({newParam} = backwardCompatible([{oldParam}, {newParam}], logger))
 *    // now if oldParam is used we set it to oldParam and log a deprecation message.
 * }
 *
 */
function backwardCompatible(...args) {
  const results = {}
  const logger = args.pop()
  for (const [oldParam, newParam] of args) {
    const oldParamName = Object.keys(oldParam)[0]
    const newParamName = Object.keys(newParam)[0]
    if (oldParam[oldParamName] === undefined) {
      results[newParamName] = newParam[newParamName]
    } else {
      logger.log(`warning - "${oldParamName}" is deprecated and will be removed, please use "${newParamName}" instead.`)
      results[newParamName] = oldParam[oldParamName]
    }
  }

  return results
}

/**
 * @param {string} str
 * @return {string}
 */
function cleanStringForJSON(str) {
  if (str == null || str.length === 0) {
    return ''
  }

  let sb = ''
  let char = '\0'
  let tmp

  for (let i = 0, l = str.length; i < l; i += 1) {
    char = str[i]
    switch (char) {
      case '\\':
      case '"':
      case '/':
        sb += '\\' + char; // eslint-disable-line
        break
      case '\b':
        sb += '\\b'
        break
      case '\t':
        sb += '\\t'
        break
      case '\n':
        sb += '\\n'
        break
      case '\f':
        sb += '\\f'
        break
      case '\r':
        sb += '\\r'
        break
      default:
        if (char < ' ') {
          tmp = '000' + char.toString(16); // eslint-disable-line
          sb += '\\u' + tmp.substring(tmp.length - 4); // eslint-disable-line
        } else {
          sb += char
        }
        break
    }
  }

  return sb
}

function isFeatureFlagOn(featureName) {
  const envValue = getEnvValue(featureName)
  return (
    envValue === '1' ||
    envValue === 'true' ||
    (envValue && envValue !== '0' && envValue !== 'false' && envValue !== 'undefined')
  )
}

function isFeatureFlagOff(featureName) {
  return !isFeatureFlagOn(featureName)
}

/**
 * @template T
 * @param {PromiseLike<T>} promise
 *
 * @returns {PromiseLike<[any|undefined, T|undefined]>} a 2-tuple where the first element is the error if promise is rejected,
 *   or undefined if resolved,
 *   and the second value is the value resolved by the promise, or undefined if rejected
 *
 * Note: copyied @applitools/functional-commons
 */
function presult(promise) {
  return promise.then(
    v => [undefined, v],
    err => [err],
  )
}

function pexec(...args) {
  if (!promisifiedExec) {
    throw new Error('cannot find exec and/or promisify perhaps you are running in the browser?')
  }
  return promisifiedExec(...args)
}

function cachify(getterFunction, cacheRegardlessOfArgs = false) {
  const cachedGetter = (function() {
    const cache = {}
    return function(...args) {
      let cacheKey = 'default'
      if (!cacheRegardlessOfArgs) {
        const [key] = args
        cacheKey = stringify(key)
      }
      if (!(cacheKey in cache)) {
        cache[cacheKey] = getterFunction(...args)
      }
      return cache[cacheKey]
    }
  })()
  return cachedGetter
}

function getBreakpointWidth(breakpoints, width) {
  if (!TypeUtils.isArray(breakpoints) || breakpoints.length === 0) {
    return width
  }
  const sortedBreakpoints = Array.from(new Set(breakpoints)).sort((a, b) => (a < b ? 1 : -1))
  const breakpoint = sortedBreakpoints.find(breakpoint => width >= breakpoint)
  return breakpoint || sortedBreakpoints[breakpoints.length - 1] - 1
}

function deprecationWarning({deprecatedThing, newThing, isDead}) {
  const msg = isDead
    ? `Notice: ${deprecatedThing} is no longer supported.`
    : `Notice: ${deprecatedThing} has been renamed. Please use ${newThing} instead.\n`

  chalk.yellow(msg)
}

module.exports = {
  urlConcat,
  stripTrailingSlash,
  isAbsoluteUrl,
  stringify,
  stringifySingle,
  toString,
  toPlain,
  mergeDeep,
  guid,
  randomAlphanumeric,
  sleep,
  toISO8601DateTime,
  toRfc1123DateTime,
  toLogFileDateTime,
  fromISO8601DateTime,
  jwtDecode,
  cartesianProduct,
  getPropertyByPath,
  getEnvValue,
  backwardCompatible,
  cleanStringForJSON,
  isFeatureFlagOn,
  isFeatureFlagOff,
  presult,
  pexec,
  cachify,
  getBreakpointWidth,
  deprecationWarning,
  generateUniqueUrl,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const {performance} = __webpack_require__(/*! perf_hooks */ "./src/builtins/perf_hooks.js")

const MS_IN_S = 1000
const MS_IN_M = 60000

const timeStorage = {}

/**
 * @internal
 */
class Time {
  constructor(name) {
    if (name) {
      this._name = String(name)
    }
  }

  reset() {
    this._startTime = null

    this._result = null
  }

  start() {
    this.reset()
    this._startTime = performance.now()
  }

  /**
   * @return {{name: string, time: number, summary: string}}
   */
  end() {
    if (!this._startTime) {
      throw new Error('start() should be called first!')
    }

    const elapsedMs = performance.now() - this._startTime

    this._result = {
      name: this._name || '',
      time: Number(elapsedMs.toFixed(3)),
      summary: elapsedString(elapsedMs),
    }

    return this._result
  }

  /**
   * @return {?{name: string, time: number, summary: string}}
   */
  result() {
    return this._result
  }
}

/**
 * @param {string} [name] - Instance name or {@code null} if don't want to store it
 * @param {boolean} [storeResults=true]
 * @return {object}
 */
function start(name, storeResults = true) {
  const time = new Time(name)
  time.storeResults = storeResults
  time.start()

  if (name && storeResults) {
    timeStorage[name] = time
  }
  return time
}

/**
 * @param {string} name - Instance name
 * @param {boolean} [deleteResults=false]
 * @return {{name: string, time: number, summary: string}}
 */
function end(name, deleteResults = false) {
  if (!name) {
    throw new Error('Instance name required!')
  }

  const time = timeStorage[name]
  if (!time) {
    throw new Error(`No time instance with name: ${name}`)
  }

  if (time.result()) {
    return time.result()
  }

  const result = time.end()
  if (deleteResults) {
    delete timeStorage[name]
  }

  return result
}

/**
 * @param {string} name - Instance name
 * @return {{name: string, time: number, summary: string}}
 */
function result(name) {
  if (!name) {
    throw new Error('Instance name required!')
  }

  const time = timeStorage[name]
  if (!time) {
    throw new Error(`No time instance with name: ${name}`)
  }

  return time.result()
}

/**
 * Format elapsed time by template (#m #s #ms)
 *
 * @param {number} milliseconds
 * @return {string} - formatted string
 */
function elapsedString(milliseconds) {
  const minutes = Math.floor(milliseconds / MS_IN_M)
  if (minutes > 0) {
    milliseconds -= minutes * MS_IN_M
  }
  const seconds = Math.floor(milliseconds / MS_IN_S)
  if (seconds > 0) {
    milliseconds -= seconds * MS_IN_S
  }

  if (minutes > 0) {
    return `${minutes}m ${seconds}s ${milliseconds}ms`
  }
  return `${seconds}s ${milliseconds}ms`
}

module.exports = {
  start,
  end,
  result,
  elapsedString,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/StreamUtils.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/StreamUtils.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];

const Stream = __webpack_require__(/*! stream */ "./node_modules/stream-browserify/index.js")

class ReadableBufferStream extends Stream.Readable {
  /**
   * @param {Buffer} buffer - The buffer to be used as the stream's source.
   * @param {object} [options] - An "options" object to be passed to the stream constructor.
   */
  constructor(buffer, options) {
    super(options)
    this._buffer = buffer
  }

  /**
   * Override of the _read function, as required when implementing a stream.
   * @private
   */
  _read() {
    this.push(this._buffer)
    this.push(null)
  }
}

class WritableBufferStream extends Stream.Writable {
  /**
   * @param {object} [options] - An "options" object to be passed to the stream constructor.
   * @return {WritableBufferStream}
   */
  constructor(options) {
    super(options)
    this._buffer = Buffer.alloc(0)
  }

  /**
   * Override of the _write function, as require when implementing a Writable stream.
   * @param {Buffer|string} chunk - The chunk to write to the stream.
   * @param {string} enc - If {@code chunk} is a string, this is the encoding of {@code chunk}.
   * @param {function} next - The callback to call when finished handling {@code chunk}.
   * @private
   */
  _write(chunk, enc, next) {
    // Since chunk could be either a Buffer or a string.
    const chunkAsBuffer = Buffer.isBuffer(chunk) ? chunk : Buffer.from(chunk, enc)
    this._buffer = Buffer.concat([this._buffer, chunkAsBuffer])
    next()
  }

  /**
   * @return {boolean} {@code false} if the stream wishes for the calling code to wait for the 'drain' event to be
   *   emitted before continuing to write additional data, otherwise {@code true}.
   */
  writeInt(value) {
    const buf = Buffer.alloc(4)
    buf.writeInt32BE(value, 0)
    return this.write(buf)
  }

  /**
   * @return {boolean} {@code false} if the stream wishes for the calling code to wait for the 'drain' event to be
   *   emitted before continuing to write additional data, otherwise {@code true}.
   */
  writeShort(value) {
    const buf = Buffer.alloc(2)
    buf.writeInt16BE(value, 0)
    return this.write(buf)
  }

  /**
   * @return {boolean} {@code false} if the stream wishes for the calling code to wait for the 'drain' event to be
   *   emitted before continuing to write additional data, otherwise {@code true}.
   */
  writeByte(value) {
    const buf = Buffer.alloc(1)
    buf.writeInt8(value, 0)
    return this.write(buf)
  }

  /**
   * @return {Buffer} - The buffer which contains the chunks written up to this point.
   */
  getBuffer() {
    return this._buffer
  }

  /**
   * Resets the buffer which contains the chunks written so far.
   * @return {Buffer} - The buffer which contains the chunks written up to the reset.
   */
  resetBuffer() {
    const buffer = this._buffer
    this._buffer = Buffer.alloc(0)
    return buffer
  }
}

/**
 * @type {{ReadableBufferStream: ?, WritableBufferStream: ?}}
 */
module.exports = {
  ReadableBufferStream,
  WritableBufferStream,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];


const {hasOwnProperty, toString} = Object.prototype

const BASE64_CHARS_PATTERN = /^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$/
const DUMMY_URL_PATTERN = /^(?:\w+:)?\/\/(\S+)$/

/**
 * Checks if `value` is `null` or `undefined`. But the `value` can be one of following: `0`, `NaN`, `false`, `""`.
 *
 * @param {*} value
 * @return {boolean}
 */
function isNull(value) {
  return value == null
}

/**
 * Checks if `value` is NOT `null` and NOT `undefined`.
 *
 * @param {*} value
 * @return {boolean}
 */
function isNotNull(value) {
  return !isNull(value)
}

/**
 * Checks if `value` has a type `string` or created by the `String` constructor
 *
 * @param {*} value
 * @return {boolean}
 */
function isString(value) {
  return Object.prototype.toString.call(value) === '[object String]'
}

/**
 * Checks if `value` has a type `number` or created by the `Number` constructor
 *
 * @param {*} value
 * @return {boolean}
 */
function isNumber(value) {
  return typeof value === 'number' || value instanceof Number
}

/**
 * Checks if `value` has a type `number` or created by the `Number` constructor and the value is integer
 *
 * @param {*} value
 * @return {boolean}
 */
function isInteger(value) {
  return isNumber(value) && Number.isInteger(value)
}

/**
 * Checks if `value` has a type `boolean` or created by the `Boolean` constructor
 *
 * @param {*} value
 * @return {boolean}
 */
function isBoolean(value) {
  return typeof value === 'boolean' || value instanceof Boolean
}

/**
 * Checks if `value` has a type `object` and not `null`.
 *
 * @param {*} value
 * @return {boolean}
 */
function isObject(value) {
  return typeof value === 'object' && value !== null
}

/**
 * Checks if `value` is a plain object. An object created by either `{}`, `new Object()` or `Object.create(null)`.
 *
 * @param {*} value
 * @return {boolean}
 */
function isPlainObject(value) {
  if (!isObject(value) || toString.call(value) !== '[object Object]') {
    return false
  }

  const prototype = Object.getPrototypeOf(value)
  return prototype === null || prototype === Object.getPrototypeOf({})
}

/**
 * Checks if `value` is an array.
 *
 * @param {*} value
 * @return {boolean}
 */
function isArray(value) {
  return Array.isArray(value)
}

/**
 * Checks if `value` is a Buffer.
 *
 * @param {*} value
 * @return {boolean}
 */
function isBuffer(value) {
  return Buffer.isBuffer(value)
}

/**
 * Checks if `value` is a base64 string.
 *
 * @param {*} value
 * @return {boolean}
 */
function isBase64(value) {
  return isString(value) && BASE64_CHARS_PATTERN.test(value)
}

/**
 * Checks if `value` is a base64 string.
 *
 * @param {*} value
 * @return {boolean}
 */
function isUrl(value) {
  return isString(value) && DUMMY_URL_PATTERN.test(value)
}

/**
 * Checks if `keys` is a direct property(ies) of `object`.
 *
 * @param {object} object - The object to query.
 * @param {string|string[]} keys - The key(s) to check.
 */
function has(object, keys) {
  if (object == null) {
    return false
  }

  if (!Array.isArray(keys)) {
    keys = [keys]
  }

  for (const key of keys) {
    if (!hasOwnProperty.call(object, key)) {
      return false
    }
  }

  return true
}

/**
 * Checks if `methods` is a method(s) of `object`.
 *
 * @param {object} object - The object to query.
 * @param {string|string[]} methods - The methods(s) to check.
 */
function hasMethod(object, methods) {
  if (object == null) {
    return false
  }

  if (!Array.isArray(methods)) {
    methods = [methods]
  }

  for (const key of methods) {
    if (typeof object[key] !== 'function') {
      return false
    }
  }

  return true
}

/**
 * Returns a `value` if it is !== undefined, or `defaultValue` otherwise
 *
 * @param {*} value
 * @param {*} defaultValue
 * @return {*}
 */
function getOrDefault(value, defaultValue) {
  if (value !== undefined) {
    return value
  }

  return defaultValue
}

/**
 * Checks if `value` has a type `function`
 *
 * @param {*} value
 * @return {boolean}
 */
function isFunction(value) {
  return typeof value === 'function'
}

/**
 * Checks if `value` is implements iterator protocol
 *
 * @param {*} value
 * @return {boolean}
 */
function isIterator(value) {
  return Boolean(value) && isFunction(value.next)
}

/**
 * Checks if `obj` is an instance of `constructor`
 *
 * @param {*} obj
 * @param {Function} constructor
 * @return {boolean}
 */
function instanceOf(obj, constructor) {
  if (!obj) return false
  if (!isString(constructor)) return obj.constructor[`__${constructor.name}`]
  let proto = Object.getPrototypeOf(obj)
  while (proto) {
    if (proto.constructor.name === constructor) return true
    proto = Object.getPrototypeOf(proto)
  }
  return false
}

module.exports = {
  isNull,
  isNotNull,
  isString,
  isNumber,
  isInteger,
  isBoolean,
  isObject,
  isPlainObject,
  isArray,
  isBuffer,
  isBase64,
  isUrl,
  has,
  hasMethod,
  getOrDefault,
  isFunction,
  isIterator,
  instanceOf,
}


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/createFramesPaths.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/createFramesPaths.js ***!
  \*******************************************************************************/
/***/ ((module) => {

function createFramesPaths({snapshot, path = [], logger}) {
  const paths = snapshot.crossFrames
    ? snapshot.crossFrames.map(({selector, index}) => ({
        path: path.concat(selector),
        parentSnapshot: snapshot,
        cdtNode: snapshot.cdt[index],
      }))
    : []

  for (const frame of snapshot.frames) {
    if (frame.selector) {
      paths.push(...createFramesPaths({snapshot: frame, path: path.concat(frame.selector), logger}))
    }
  }

  logger.verbose(`frames paths for ${snapshot.crossFrames}`, paths.map(({path}) => path.join('-->')).join(' , '))

  return paths
}

module.exports = createFramesPaths


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/deserializeDomSnapshotResult.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/deserializeDomSnapshotResult.js ***!
  \******************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];


function deserializeDomSnapshotResult(domSnapshotResult) {
  const ret = {
    ...domSnapshotResult,
    resourceContents: blobDataToResourceContents(domSnapshotResult.blobs),
    frames: domSnapshotResult.frames.map(deserializeDomSnapshotResult),
  }
  delete ret.blobs
  delete ret.selector
  delete ret.crossFrames
  return ret
}

function blobDataToResourceContents(blobs) {
  return blobs.reduce((acc, blob) => {
    acc[blob.url] = blob.value !== undefined ? Object.assign(blob, {value: Buffer.from(blob.value, 'base64')}) : blob
    return acc
  }, {})
}

module.exports = deserializeDomSnapshotResult


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/getBrowserInfo.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/getBrowserInfo.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const TypeUtils = __webpack_require__(/*! ./TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")

async function getBrowserInfo({browser, getEmulatedDevicesSizes, getIosDevicesSizes}) {
  const isMobile = browser.deviceName || browser.mobile || browser.iosDeviceInfo || browser.chromeEmulationInfo
  if (!isMobile) {
    const {name, width, height} = browser
    return {name, width, height}
  } else {
    let devicesSizes, browserObj
    if (TypeUtils.has(browser, 'chromeEmulationInfo') || TypeUtils.has(browser, 'deviceName')) {
      browserObj = browser.chromeEmulationInfo || browser
      devicesSizes = await getEmulatedDevicesSizes()
    } else if (TypeUtils.has(browser, 'iosDeviceInfo')) {
      browserObj = browser.iosDeviceInfo
      devicesSizes = await getIosDevicesSizes()
    }
    const {deviceName, screenOrientation = 'portrait'} = browserObj
    const size = devicesSizes[deviceName][screenOrientation]
    return {name: deviceName, screenOrientation, ...size}
  }
}

module.exports = getBrowserInfo


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomCapture.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomCapture.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const Axios = __webpack_require__(/*! axios */ "./node_modules/axios/index.js")
const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")
const {
  getCaptureDomPoll,
  getPollResult,
  getCaptureDomPollForIE,
  getPollResultForIE,
} = __webpack_require__(/*! @applitools/dom-capture */ "./node_modules/@applitools/dom-capture/index.js")
const ArgumentGuard = __webpack_require__(/*! ./ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const GeneralUtils = __webpack_require__(/*! ./GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
const PerformanceUtils = __webpack_require__(/*! ./PerformanceUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/PerformanceUtils.js")
const EyesUtils = __webpack_require__(/*! ../sdk/EyesUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesUtils.js")

const EXECUTION_TIMEOUT = 5 * 60 * 1000
const POLL_TIMEOUT = 200
const IOS_CHUNK_BYTE_LENGTH = 100000
const DEFAULT_CHUNK_BYTE_LENGTH = Number(process.env.APPLITOOLS_SCRIPT_RESULT_MAX_BYTE_LENGTH) || 262144000 // 250MB (could be 256MB but decide to leave a 6MB buffer)

async function takeDomCapture(logger, context, options = {}) {
  ArgumentGuard.notNull(logger, 'logger')
  ArgumentGuard.notNull(context, 'context')
  const driver = context.driver
  const {
    axios = Axios.create(),
    chunkByteLength = driver.isIOS ? IOS_CHUNK_BYTE_LENGTH : DEFAULT_CHUNK_BYTE_LENGTH,
    pollTimeout = POLL_TIMEOUT,
    executionTimeout = EXECUTION_TIMEOUT,
  } = options
  const isLegacyBrowser = driver.isIE || driver.isEdgeLegacy
  const arg = {chunkByteLength}
  const scripts = {
    main: {
      script: `return (${
        isLegacyBrowser ? await getCaptureDomPollForIE() : await getCaptureDomPoll()
      }).apply(null, arguments);`,
      args: [arg],
    },
    poll: {
      script: `return (${
        isLegacyBrowser ? await getPollResultForIE() : await getPollResult()
      }).apply(null, arguments);`,
      args: [arg],
    },
  }

  const url = await driver.getUrl()
  const dom = await captureContextDom(context)

  // TODO save debug DOM like we have for debug screenshots
  return dom

  async function captureContextDom(context) {
    const capture = await EyesUtils.executePollScript(logger, context, scripts, {
      executionTimeout,
      pollTimeout,
    })
    if (!capture) return {}
    const raws = capture.split('\n')
    const tokens = JSON.parse(raws[0])
    const cssEndIndex = raws.indexOf(tokens.separator)
    const frameEndIndex = raws.indexOf(tokens.separator, cssEndIndex + 1)
    let dom = raws[frameEndIndex + 1]

    const cssResources = await Promise.all(
      raws.slice(1, cssEndIndex).reduce((cssResources, href) => {
        return href ? cssResources.concat(fetchCss(url, href)) : cssResources
      }, []),
    )

    for (const {href, css} of cssResources) {
      dom = dom.replace(`${tokens.cssStartToken}${href}${tokens.cssEndToken}`, css)
    }

    const framePaths = raws.slice(cssEndIndex + 1, frameEndIndex)

    for (const xpaths of framePaths) {
      if (!xpaths) continue
      const references = xpaths.split(',').reduce((parent, selector) => {
        return {reference: {type: 'xpath', selector}, parent}
      }, null)
      let contextDom
      try {
        const frame = await context.context(references)
        contextDom = await captureContextDom(frame)
      } catch (ignored) {
        logger.log('Switching to frame failed')
        contextDom = {}
      }
      dom = dom.replace(`${tokens.iframeStartToken}${xpaths}${tokens.iframeEndToken}`, contextDom)
    }

    return dom
  }

  async function fetchCss(baseUri, href, retriesCount = 1) {
    try {
      logger.verbose(`Given URL to download: ${href}`)
      let absHref = href
      if (!GeneralUtils.isAbsoluteUrl(href)) {
        absHref = new URL(href.toString(), baseUri).href
      }

      const timeStart = PerformanceUtils.start()
      const response = await axios(absHref)
      const css = response.data
      logger.verbose(`downloading CSS in length of ${css.length} chars took ${timeStart.end().summary}`)
      const escapedCss = GeneralUtils.cleanStringForJSON(css)
      return {href: absHref, css: escapedCss}
    } catch (err) {
      logger.verbose(err.toString())
      retriesCount -= 1
      if (retriesCount > 0) {
        return fetchCss(baseUri, href, retriesCount)
      }
      return {href, css: ''}
    }
  }
}

module.exports = takeDomCapture


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshot.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshot.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


const {
  getProcessPagePoll,
  getPollResult,
  getProcessPagePollForIE,
  getPollResultForIE,
} = __webpack_require__(/*! @applitools/dom-snapshot */ "./node_modules/@applitools/dom-snapshot/index.js")
const ArgumentGuard = __webpack_require__(/*! ./ArgumentGuard */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ArgumentGuard.js")
const EyesUtils = __webpack_require__(/*! ../sdk/EyesUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesUtils.js")
const deserializeDomSnapshotResult = __webpack_require__(/*! ./deserializeDomSnapshotResult */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/deserializeDomSnapshotResult.js")
const createFramesPaths = __webpack_require__(/*! ./createFramesPaths */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/createFramesPaths.js")
const {generateUniqueUrl} = __webpack_require__(/*! ./GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

const EXECUTION_TIMEOUT = 5 * 60 * 1000
const POLL_TIMEOUT = 200
const DEFAULT_CHUNK_BYTE_LENGTH = 262144000 // 250MB (could be 256MB but decide to leave a 6MB buffer)

async function takeDomSnapshot(logger, driver, options = {}) {
  ArgumentGuard.notNull(logger, 'logger')
  ArgumentGuard.notNull(driver, 'driver')
  const {
    disableBrowserFetching: dontFetchResources,
    chunkByteLength = Number(process.env.APPLITOOLS_SCRIPT_RESULT_MAX_BYTE_LENGTH) || DEFAULT_CHUNK_BYTE_LENGTH,
    pollTimeout = POLL_TIMEOUT,
    executionTimeout = EXECUTION_TIMEOUT,
    showLogs,
    skipResources,
    removeReverseProxyURLPrefixes = !!process.env.APPLITOOLS_SCRIPT_REMOVE_REVERSE_PROXY_URL_PREFIXES,
    uniqueUrl = generateUniqueUrl,
  } = options
  const isLegacyBrowser = driver.isIE || driver.isEdgeLegacy
  const arg = {
    chunkByteLength,
    dontFetchResources,
    serializeResources: true,
    compressResources: false,
    showLogs,
    skipResources,
    removeReverseProxyURLPrefixes,
  }
  const scripts = {
    main: {
      script: `return (${
        isLegacyBrowser ? await getProcessPagePollForIE() : await getProcessPagePoll()
      }).apply(null, arguments);`,
      args: [arg],
    },
    poll: {
      script: `return (${
        isLegacyBrowser ? await getPollResultForIE() : await getPollResult()
      }).apply(null, arguments);`,
      args: [arg],
    },
  }

  const snapshot = await takeContextDomSnapshot(driver.currentContext)
  return deserializeDomSnapshotResult(snapshot)

  async function takeContextDomSnapshot(context) {
    logger.verbose(
      `taking dom snapshot. ${context._reference ? `context referece: ${JSON.stringify(context._reference)}` : ''}`,
    )

    const snapshot = await EyesUtils.executePollScript(logger, context, scripts, {
      executionTimeout,
      pollTimeout,
    })

    const selectorMap = createFramesPaths({snapshot, logger})

    for (const {path, parentSnapshot, cdtNode} of selectorMap) {
      const references = path.reduce((parent, selector) => {
        return {reference: {type: 'css', selector}, parent}
      }, null)

      const frameContext = await context
        .context(references)
        .then(context => context.focus())
        .catch(err => {
          const pathMap = selectorMap.map(({path}) => path.join('->')).join(' | ')
          logger.verbose(`could not switch to frame during takeDomSnapshot. Path to frame: ${pathMap}`, err)
        })
      if (frameContext) {
        const frameSnapshot = await takeContextDomSnapshot(frameContext)
        frameSnapshot.url = uniqueUrl(frameSnapshot.url, 'applitools-iframe')
        parentSnapshot.frames.push(frameSnapshot)
        cdtNode.attributes.push({name: 'data-applitools-src', value: frameSnapshot.url})
      }
    }

    logger.verbose(`dom snapshot cdt length: ${snapshot.cdt.length}`)
    logger.verbose(`blobs urls (${snapshot.blobs.length}):`, JSON.stringify(snapshot.blobs.map(({url}) => url))) // eslint-disable-line prettier/prettier
    logger.verbose(`resource urls (${snapshot.resourceUrls.length}):`, JSON.stringify(snapshot.resourceUrls)) // eslint-disable-line prettier/prettier
    return snapshot
  }
}

module.exports = takeDomSnapshot


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshots.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshots.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const takeDomSnapshot = __webpack_require__(/*! ./takeDomSnapshot */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/takeDomSnapshot.js")
const getBrowserInfo = __webpack_require__(/*! ./getBrowserInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/getBrowserInfo.js")
const chalk = __webpack_require__(/*! chalk */ "./node_modules/chalk/source/index.js")
const GeneralUtils = __webpack_require__(/*! ./GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")

async function takeDomSnapshots({
  breakpoints,
  browsers,
  disableBrowserFetching,
  driver,
  logger,
  showLogs,
  skipResources,
  getViewportSize,
  getEmulatedDevicesSizes,
  getIosDevicesSizes,
}) {
  if (!breakpoints) {
    logger.verbose(`taking single dom snapshot`)
    const snapshot = await takeDomSnapshot(logger, driver, {
      disableBrowserFetching,
      showLogs,
      skipResources,
    })
    return Array(browsers.length).fill(snapshot)
  }

  const requiredWidths = await getRequiredWidths()
  const isStrictBreakpoints = Array.isArray(breakpoints)
  const smallestBreakpoint = Math.min(...(isStrictBreakpoints ? breakpoints : []))

  if (isStrictBreakpoints && requiredWidths.has(smallestBreakpoint - 1)) {
    const smallestBrowsers = requiredWidths
      .get(smallestBreakpoint - 1)
      .map(({name, width}) => `(${name}, ${width})`)
      .join(', ')
    const message = chalk.yellow(
      `The following configuration's viewport-widths are smaller than the smallest configured layout breakpoint (${smallestBreakpoint} pixels): [${smallestBrowsers}]. As a fallback, the resources that will be used for these configurations have been captured on a viewport-width of ${smallestBreakpoint} - 1 pixels. If an additional layout breakpoint is needed for you to achieve better results - please add it to your configuration.`,
    )
    console.log(message)
  }

  logger.verbose(`taking multiple dom snapshots for breakpoints: ${breakpoints}`)
  logger.verbose(`required widths: ${[...requiredWidths.keys()].join(', ')}`)
  const viewportSize = await getViewportSize()
  const snapshots = Array(browsers.length)
  if (requiredWidths.has(viewportSize.width)) {
    logger.log(`taking dom snapshot for existing width ${viewportSize.width}`)
    const snapshot = await takeDomSnapshot(logger, driver, {
      disableBrowserFetching,
      showLogs,
      skipResources,
    })
    requiredWidths.get(viewportSize.width).forEach(({index}) => (snapshots[index] = snapshot))
  }
  for (const [requiredWidth, browsersInfo] of requiredWidths.entries()) {
    logger.log(`taking dom snapshot for width ${requiredWidth}`)
    try {
      await driver.setViewportSize({width: requiredWidth, height: viewportSize.height})
    } catch (err) {
      const actualViewportSize = await driver.getViewportSize()
      if (isStrictBreakpoints) {
        const failedBrowsers = browsersInfo.map(({name, width}) => `(${name}, ${width})`).join(', ')
        const message = chalk.yellow(
          `One of the configured layout breakpoints is ${requiredWidth} pixels, while your local browser has a limit of ${actualViewportSize.width}, so the SDK couldn't resize it to the desired size. As a fallback, the resources that will be used for the following configurations: [${failedBrowsers}] have been captured on the browser's limit (${actualViewportSize.width} pixels). To resolve this, you may use a headless browser as it can be resized to any size.`,
        )
        console.log(message)
      } else {
        const failedBrowsers = browsersInfo.map(({name}) => `(${name})`).join(', ')
        const message = chalk.yellow(
          `The following configurations [${failedBrowsers}] have a viewport-width of ${requiredWidth} pixels, while your local browser has a limit of ${actualViewportSize.width} pixels, so the SDK couldn't resize it to the desired size. As a fallback, the resources that will be used for these checkpoints have been captured on the browser's limit (${actualViewportSize.width} pixels). To resolve this, you may use a headless browser as it can be resized to any size.`,
        )
        console.log(message)
      }
    }
    const snapshot = await takeDomSnapshot(logger, driver, {
      disableBrowserFetching,
      showLogs,
      skipResources,
    })
    browsersInfo.forEach(({index}) => (snapshots[index] = snapshot))
  }
  await driver.setViewportSize(viewportSize)
  return snapshots

  async function getRequiredWidths() {
    return await browsers.reduce((widths, browser, index) => {
      const browserInfo = getBrowserInfo({browser, getEmulatedDevicesSizes, getIosDevicesSizes})
      return widths.then(async widths => {
        const {name, width} = await browserInfo
        const requiredWidth = GeneralUtils.getBreakpointWidth(breakpoints, width)
        let groupedBrowsers = widths.get(requiredWidth)
        if (!groupedBrowsers) {
          groupedBrowsers = []
          widths.set(requiredWidth, groupedBrowsers)
        }
        groupedBrowsers.push({index, width, name})
        return widths
      })
    }, Promise.resolve(new Map()))
  }
}

module.exports = takeDomSnapshots


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/browser.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/browser.js ***!
  \**********************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");
/* eslint-env browser */

/**
 * This is the web browser implementation of `debug()`.
 */

exports.formatArgs = formatArgs;
exports.save = save;
exports.load = load;
exports.useColors = useColors;
exports.storage = localstorage();

/**
 * Colors.
 */

exports.colors = [
	'#0000CC',
	'#0000FF',
	'#0033CC',
	'#0033FF',
	'#0066CC',
	'#0066FF',
	'#0099CC',
	'#0099FF',
	'#00CC00',
	'#00CC33',
	'#00CC66',
	'#00CC99',
	'#00CCCC',
	'#00CCFF',
	'#3300CC',
	'#3300FF',
	'#3333CC',
	'#3333FF',
	'#3366CC',
	'#3366FF',
	'#3399CC',
	'#3399FF',
	'#33CC00',
	'#33CC33',
	'#33CC66',
	'#33CC99',
	'#33CCCC',
	'#33CCFF',
	'#6600CC',
	'#6600FF',
	'#6633CC',
	'#6633FF',
	'#66CC00',
	'#66CC33',
	'#9900CC',
	'#9900FF',
	'#9933CC',
	'#9933FF',
	'#99CC00',
	'#99CC33',
	'#CC0000',
	'#CC0033',
	'#CC0066',
	'#CC0099',
	'#CC00CC',
	'#CC00FF',
	'#CC3300',
	'#CC3333',
	'#CC3366',
	'#CC3399',
	'#CC33CC',
	'#CC33FF',
	'#CC6600',
	'#CC6633',
	'#CC9900',
	'#CC9933',
	'#CCCC00',
	'#CCCC33',
	'#FF0000',
	'#FF0033',
	'#FF0066',
	'#FF0099',
	'#FF00CC',
	'#FF00FF',
	'#FF3300',
	'#FF3333',
	'#FF3366',
	'#FF3399',
	'#FF33CC',
	'#FF33FF',
	'#FF6600',
	'#FF6633',
	'#FF9900',
	'#FF9933',
	'#FFCC00',
	'#FFCC33'
];

/**
 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
 * and the Firebug extension (any Firefox version) are known
 * to support "%c" CSS customizations.
 *
 * TODO: add a `localStorage` variable to explicitly enable/disable colors
 */

// eslint-disable-next-line complexity
function useColors() {
	// NB: In an Electron preload script, document will be defined but not fully
	// initialized. Since we know we're in Chrome, we'll just detect this case
	// explicitly
	if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
		return true;
	}

	// Internet Explorer and Edge do not support colors.
	if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
		return false;
	}

	// Is webkit? http://stackoverflow.com/a/16459606/376773
	// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
	return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
		// Is firebug? http://stackoverflow.com/a/398120/376773
		(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
		// Is firefox >= v31?
		// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
		// Double check webkit in userAgent just in case we are in a worker
		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
}

/**
 * Colorize log arguments if enabled.
 *
 * @api public
 */

function formatArgs(args) {
	args[0] = (this.useColors ? '%c' : '') +
		this.namespace +
		(this.useColors ? ' %c' : ' ') +
		args[0] +
		(this.useColors ? '%c ' : ' ') +
		'+' + module.exports.humanize(this.diff);

	if (!this.useColors) {
		return;
	}

	const c = 'color: ' + this.color;
	args.splice(1, 0, c, 'color: inherit');

	// The final "%c" is somewhat tricky, because there could be other
	// arguments passed either before or after the %c, so we need to
	// figure out the correct index to insert the CSS into
	let index = 0;
	let lastC = 0;
	args[0].replace(/%[a-zA-Z%]/g, match => {
		if (match === '%%') {
			return;
		}
		index++;
		if (match === '%c') {
			// We only are interested in the *last* %c
			// (the user may have provided their own)
			lastC = index;
		}
	});

	args.splice(lastC, 0, c);
}

/**
 * Invokes `console.debug()` when available.
 * No-op when `console.debug` is not a "function".
 * If `console.debug` is not available, falls back
 * to `console.log`.
 *
 * @api public
 */
exports.log = console.debug || console.log || (() => {});

/**
 * Save `namespaces`.
 *
 * @param {String} namespaces
 * @api private
 */
function save(namespaces) {
	try {
		if (namespaces) {
			exports.storage.setItem('debug', namespaces);
		} else {
			exports.storage.removeItem('debug');
		}
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

/**
 * Load `namespaces`.
 *
 * @return {String} returns the previously persisted debug modes
 * @api private
 */
function load() {
	let r;
	try {
		r = exports.storage.getItem('debug');
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}

	// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
	if (!r && typeof process !== 'undefined' && 'env' in process) {
		r = process.env.DEBUG;
	}

	return r;
}

/**
 * Localstorage attempts to return the localstorage.
 *
 * This is necessary because safari throws
 * when a user disables cookies/localstorage
 * and you attempt to access it.
 *
 * @return {LocalStorage}
 * @api private
 */

function localstorage() {
	try {
		// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
		// The Browser also has localStorage in the global context.
		return localStorage;
	} catch (error) {
		// Swallow
		// XXX (@Qix-) should we be logging these?
	}
}

module.exports = __webpack_require__(/*! ./common */ "./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/common.js")(exports);

const {formatters} = module.exports;

/**
 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
 */

formatters.j = function (v) {
	try {
		return JSON.stringify(v);
	} catch (error) {
		return '[UnexpectedJSONParseError]: ' + error.message;
	}
};


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/common.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/node_modules/debug/src/common.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {


/**
 * This is the common logic for both the Node.js and web browser
 * implementations of `debug()`.
 */

function setup(env) {
	createDebug.debug = createDebug;
	createDebug.default = createDebug;
	createDebug.coerce = coerce;
	createDebug.disable = disable;
	createDebug.enable = enable;
	createDebug.enabled = enabled;
	createDebug.humanize = __webpack_require__(/*! ms */ "./node_modules/ms/index.js");

	Object.keys(env).forEach(key => {
		createDebug[key] = env[key];
	});

	/**
	* Active `debug` instances.
	*/
	createDebug.instances = [];

	/**
	* The currently active debug mode names, and names to skip.
	*/

	createDebug.names = [];
	createDebug.skips = [];

	/**
	* Map of special "%n" handling functions, for the debug "format" argument.
	*
	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
	*/
	createDebug.formatters = {};

	/**
	* Selects a color for a debug namespace
	* @param {String} namespace The namespace string for the for the debug instance to be colored
	* @return {Number|String} An ANSI color code for the given namespace
	* @api private
	*/
	function selectColor(namespace) {
		let hash = 0;

		for (let i = 0; i < namespace.length; i++) {
			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
			hash |= 0; // Convert to 32bit integer
		}

		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
	}
	createDebug.selectColor = selectColor;

	/**
	* Create a debugger with the given `namespace`.
	*
	* @param {String} namespace
	* @return {Function}
	* @api public
	*/
	function createDebug(namespace) {
		let prevTime;

		function debug(...args) {
			// Disabled?
			if (!debug.enabled) {
				return;
			}

			const self = debug;

			// Set `diff` timestamp
			const curr = Number(new Date());
			const ms = curr - (prevTime || curr);
			self.diff = ms;
			self.prev = prevTime;
			self.curr = curr;
			prevTime = curr;

			args[0] = createDebug.coerce(args[0]);

			if (typeof args[0] !== 'string') {
				// Anything else let's inspect with %O
				args.unshift('%O');
			}

			// Apply any `formatters` transformations
			let index = 0;
			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
				// If we encounter an escaped % then don't increase the array index
				if (match === '%%') {
					return match;
				}
				index++;
				const formatter = createDebug.formatters[format];
				if (typeof formatter === 'function') {
					const val = args[index];
					match = formatter.call(self, val);

					// Now we need to remove `args[index]` since it's inlined in the `format`
					args.splice(index, 1);
					index--;
				}
				return match;
			});

			// Apply env-specific formatting (colors, etc.)
			createDebug.formatArgs.call(self, args);

			const logFn = self.log || createDebug.log;
			logFn.apply(self, args);
		}

		debug.namespace = namespace;
		debug.enabled = createDebug.enabled(namespace);
		debug.useColors = createDebug.useColors();
		debug.color = createDebug.selectColor(namespace);
		debug.destroy = destroy;
		debug.extend = extend;

		// Env-specific initialization logic for debug instances
		if (typeof createDebug.init === 'function') {
			createDebug.init(debug);
		}

		createDebug.instances.push(debug);

		return debug;
	}

	function destroy() {
		const index = createDebug.instances.indexOf(this);
		if (index !== -1) {
			createDebug.instances.splice(index, 1);
			return true;
		}
		return false;
	}

	function extend(namespace, delimiter) {
		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
		newDebug.log = this.log;
		return newDebug;
	}

	/**
	* Enables a debug mode by namespaces. This can include modes
	* separated by a colon and wildcards.
	*
	* @param {String} namespaces
	* @api public
	*/
	function enable(namespaces) {
		createDebug.save(namespaces);

		createDebug.names = [];
		createDebug.skips = [];

		let i;
		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
		const len = split.length;

		for (i = 0; i < len; i++) {
			if (!split[i]) {
				// ignore empty strings
				continue;
			}

			namespaces = split[i].replace(/\*/g, '.*?');

			if (namespaces[0] === '-') {
				createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
			} else {
				createDebug.names.push(new RegExp('^' + namespaces + '$'));
			}
		}

		for (i = 0; i < createDebug.instances.length; i++) {
			const instance = createDebug.instances[i];
			instance.enabled = createDebug.enabled(instance.namespace);
		}
	}

	/**
	* Disable debug output.
	*
	* @return {String} namespaces
	* @api public
	*/
	function disable() {
		const namespaces = [
			...createDebug.names.map(toNamespace),
			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
		].join(',');
		createDebug.enable('');
		return namespaces;
	}

	/**
	* Returns true if the given mode name is enabled, false otherwise.
	*
	* @param {String} name
	* @return {Boolean}
	* @api public
	*/
	function enabled(name) {
		if (name[name.length - 1] === '*') {
			return true;
		}

		let i;
		let len;

		for (i = 0, len = createDebug.skips.length; i < len; i++) {
			if (createDebug.skips[i].test(name)) {
				return false;
			}
		}

		for (i = 0, len = createDebug.names.length; i < len; i++) {
			if (createDebug.names[i].test(name)) {
				return true;
			}
		}

		return false;
	}

	/**
	* Convert regexp to namespace
	*
	* @param {RegExp} regxep
	* @return {String} namespace
	* @api private
	*/
	function toNamespace(regexp) {
		return regexp.toString()
			.substring(2, regexp.toString().length - 2)
			.replace(/\.\*\?$/, '*');
	}

	/**
	* Coerce `val`.
	*
	* @param {Mixed} val
	* @return {Mixed}
	* @api private
	*/
	function coerce(val) {
		if (val instanceof Error) {
			return val.stack || val.message;
		}
		return val;
	}

	createDebug.enable(createDebug.load());

	return createDebug;
}

module.exports = setup;


/***/ }),

/***/ "./node_modules/@applitools/eyes-sdk-core/shared/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/@applitools/eyes-sdk-core/shared/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

exports.deserializeDomSnapshotResult = __webpack_require__(/*! ../lib/utils/deserializeDomSnapshotResult */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/deserializeDomSnapshotResult.js")
exports.Logger = __webpack_require__(/*! ../lib/logging/Logger */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/Logger.js")

exports.DiffsFoundError = __webpack_require__(/*! ../lib/errors/DiffsFoundError */ "./node_modules/@applitools/eyes-sdk-core/lib/errors/DiffsFoundError.js")
exports.TestResults = __webpack_require__(/*! ../lib/TestResults */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResults.js")
exports.TestResultsError = __webpack_require__(/*! ../lib/TestResultsError */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsError.js")
exports.TestResultsStatus = __webpack_require__(/*! ../lib/TestResultsStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsStatus.js")
exports.TestResultsFormatter = __webpack_require__(/*! ../lib/TestResultsFormatter */ "./node_modules/@applitools/eyes-sdk-core/lib/TestResultsFormatter.js")

exports.RectangleSize = __webpack_require__(/*! ../lib/geometry/RectangleSize */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/RectangleSize.js")
exports.Location = __webpack_require__(/*! ../lib/geometry/Location */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Location.js")

exports.Region = __webpack_require__(/*! ../lib/geometry/Region */ "./node_modules/@applitools/eyes-sdk-core/lib/geometry/Region.js")
exports.AccessibilityRegionType = __webpack_require__(/*! ../lib/config/AccessibilityRegionType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/AccessibilityRegionType.js")

exports.RenderInfo = __webpack_require__(/*! ../lib/renderer/RenderInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderInfo.js")
exports.RenderingInfo = __webpack_require__(/*! ../lib/server/RenderingInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/server/RenderingInfo.js")
exports.RenderRequest = __webpack_require__(/*! ../lib/renderer/RenderRequest */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderRequest.js")
exports.RenderStatus = __webpack_require__(/*! ../lib/renderer/RenderStatus */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatus.js")
exports.RenderStatusResults = __webpack_require__(/*! ../lib/renderer/RenderStatusResults */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RenderStatusResults.js")

exports.RGridResource = __webpack_require__(/*! ../lib/renderer/RGridResource */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridResource.js")
exports.RGridDom = __webpack_require__(/*! ../lib/renderer/RGridDom */ "./node_modules/@applitools/eyes-sdk-core/lib/renderer/RGridDom.js")

exports.EyesBase = __webpack_require__(/*! ../lib/sdk/EyesBase */ "./node_modules/@applitools/eyes-sdk-core/lib/sdk/EyesBase.js")

exports.getTunnelAgentFromProxy = __webpack_require__(/*! ../lib/server/getTunnelAgentFromProxy */ "./node_modules/@applitools/eyes-sdk-core/lib/server/getTunnelAgentFromProxy.js")
exports.BatchInfo = __webpack_require__(/*! ../lib/config/BatchInfo */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BatchInfo.js")
exports.BrowserType = __webpack_require__(/*! ../lib/config/BrowserType */ "./node_modules/@applitools/eyes-sdk-core/lib/config/BrowserType.js")
exports.TypeUtils = __webpack_require__(/*! ../lib/utils/TypeUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/TypeUtils.js")
exports.GeneralUtils = __webpack_require__(/*! ../lib/utils/GeneralUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/GeneralUtils.js")
exports.ConfigUtils = __webpack_require__(/*! ../lib/utils/ConfigUtils */ "./node_modules/@applitools/eyes-sdk-core/lib/utils/ConfigUtils.js")

exports.ImageMatchSettings = __webpack_require__(/*! ../lib/config/ImageMatchSettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ImageMatchSettings.js")

exports.RunnerStartedEvent = __webpack_require__(/*! ../lib/logging/RunnerStartedEvent */ "./node_modules/@applitools/eyes-sdk-core/lib/logging/RunnerStartedEvent.js")
exports.MatchResult = __webpack_require__(/*! ../lib/match/MatchResult */ "./node_modules/@applitools/eyes-sdk-core/lib/match/MatchResult.js")

exports.ProxySettings = __webpack_require__(/*! ../lib/config/ProxySettings */ "./node_modules/@applitools/eyes-sdk-core/lib/config/ProxySettings.js")


/***/ }),

/***/ "./node_modules/@applitools/functional-commons/src/functional-commons.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/functional-commons/src/functional-commons.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {promisify: p} = __webpack_require__(/*! util */ "./node_modules/util/util.js")
const makeThrottledFunction = __webpack_require__(/*! ./make-throttled-function */ "./node_modules/@applitools/functional-commons/src/make-throttled-function.js")

/**
 * @template T
 * @param {(...args: any[]) => T} syncCreationFunction
 * @returns {(...args: any[]) => T}
 */
function cacheFunctionSync(syncCreationFunction) {
  const cacheMap = new Map()

  return (...args) => {
    const key = JSON.stringify(args)

    const cachedValue = cacheMap.get(key)
    if (cachedValue) {
      return cachedValue
    }
    const newValue = syncCreationFunction(...args)
    if (typeof newValue.then === 'function')
      throw new Error('your function returned a promise. Maybe you want to use cacheFunctionAsync?')

    cacheMap.set(key, newValue)

    return newValue
  }
}

/**
 *
 * @param {(...args: any[]) => PromiseLike<T>} asyncCreationFunction
 * @param {{?expireAfterMs: number, ?nowService: {now: () => number}}} [options]
 *
 * @returns {(...args: any[]) => PromiseLike<T>}
 */
function cacheFunctionAsync(
  asyncCreationFunction,
  {expireAfterMs = undefined, nowService = Date} = {},
) {
  const cacheMap = new Map()

  return async (...args) => {
    const key = JSON.stringify(args)

    const cachedValue = cacheMap.get(key)
    if (cachedValue) {
      const {value, creationTime} = cachedValue

      if (expireAfterMs === undefined || nowService.now() < creationTime + expireAfterMs) {
        return value
      }
    }
    const newValue = await asyncCreationFunction(...args)

    cacheMap.set(key, {value: newValue, creationTime: nowService.now()})

    return newValue
  }
}

/**
 * @param {number} from
 * @param {number} to
 * @param {?number} step (default 1)
 *
 * @returns {number[]}
 */
function range(from, to, step = 1) {
  if (from >= to) return []

  return Array(Math.ceil((to - from) / step))
    .fill(0)
    .map((_, i) => i * step + from)
}

/**
 *
 * @param {number[]} numbers
 * @returns {number}
 */
function sum(numbers) {
  return numbers.reduce((a, b) => a + b, 0)
}

/**
 *
 * @param {any} err
 */
function throw_(err) {
  throw err
}

/**
 * @param {[string, any][]} entries
 *
 * @returns {{[x: string]: any}}
 */
function objectFromEntries(entries) {
  return entries.reduce((acc, [name, value]) => ((acc[name] = value), acc), {})
}

function group(prop, list) {
  return list.reduce(function (grouped, item) {
    const key = item[prop]

    grouped[key] = grouped[key] || []

    grouped[key].push(item)

    return grouped
  }, {})
}

const groupBy = (prop) => (list) => group(prop, list)

/**
 * @param {{[x: string]: any}} object
 * @param {([string, any]) => [string, any]} mapFunction
 *
 * @returns {{[x: string]: any}}
 */
function mapObject(object, mapFunction) {
  return objectFromEntries(Object.entries(object).map(([key, value]) => mapFunction(key, value)))
}

/**
 * @param {{[x: string]: any}} object
 * @param {(value: any) => any}  mapFunction
 *
 * @returns {{[x: string]: any}}
 */
function mapValues(object, mapFunction) {
  return mapObject(object, (key, value) => [key, mapFunction(value)])
}

/**
 * @param {{[x: string]: any}} object
 * @param {(value: any) => any}  mapFunction
 *
 * @returns {{[x: string]: any}}
 */
function mapKeys(object, mapFunction) {
  return mapObject(object, (key, value) => [mapFunction(key), value])
}

/**
 *
 * @param {object} object
 * @param {(key:string) => boolean} filterFunc
 *
 * @returns {object}
 */
function filterKeys(object, filterFunc) {
  const ret = {}

  for (const [k, v] of Object.entries(object)) {
    if (filterFunc(k)) {
      ret[k] = v
    }
  }

  return ret
}

/**
 * @param {object} object
 * @param {(value:any) => boolean} filterFunc
 * @returns {object}
 */
function filterValues(object, filterFunc) {
  const ret = {}

  for (const [k, v] of Object.entries(object)) {
    if (filterFunc(v)) {
      ret[k] = v
    }
  }

  return ret
}

/**
 * @param {object} object
 * @param {(entry: [string, any]) => boolean} filterFunc
 * @returns {object}
 */
function filterEntries(object, filterFunc) {
  const ret = {}

  for (const entry of Object.entries(object)) {
    if (filterFunc(entry)) {
      ret[entry[0]] = entry[1]
    }
  }

  return ret
}

/**
 * @param {number} ms
 * @param {() => any} errFactory
 *
 * @returns {Promise<void>}
 */
async function failAfter(ms, errFactory) {
  await p(setTimeout)(ms)

  throw errFactory()
}

/**
 * @template T
 * @param {PromiseLike<T>} promise
 *
 * @returns {PromiseLike<[any|undefined, T|undefined]>} a 2-tuple where the first element is the error if promise is rejected,
 *   or undefined if resolved,
 *   and the second value is the value resolved by the promise, or undefined if rejected
 */
function presult(promise) {
  return promise.then(
    (v) => [undefined, v],
    (err) => [err],
  )
}

/**
 * @template T
 * @param {PromiseLike<T>} promise
 *
 * @returns {PromiseLike<[any|undefined, T|undefined]>}
 */
function unwrapPresult(presultPromise) {
  return presultPromise.then(([err, v]) => (err != null ? Promise.reject(err) : v))
}
/**
 *
 * @param {number} ms
 * @returns {PromiseLike<any>}
 */
function delay(ms) {
  return p(setTimeout)(ms)
}

/**
 * @template T, V
 * @param {Promise<T>|((hasAborted: () => boolean) => Promise<T>)} promiseOrPromiseFunc
 * @param {number} timeout
 * @param {V} value
 * @returns {Promise<T|V>}
 */
function ptimeoutWithValue(promiseOrPromiseFunc, timeout, value) {
  return ptimeoutWithFunction(promiseOrPromiseFunc, timeout, () => value)
}

/**
 * @template T
 * @param {Promise<T>|((hasAborted: () => boolean) => Promise<T>)} promiseOrPromiseFunc
 * @param {number} timeout
 * @param {any} error
 * @returns {Promise<T>}
 */
function ptimeoutWithError(promiseOrPromiseFunc, timeout, error) {
  return ptimeoutWithFunction(promiseOrPromiseFunc, timeout, () => Promise.reject(error))
}

/**
 * @template T, V
 * @param {Promise<T>|((hasAborted: () => boolean) => Promise<T>)} promiseOrPromiseFunc
 * @param {number} timeout
 * @param {() => Promise<V>} func
 * @returns {Promise<T|V>}
 */
async function ptimeoutWithFunction(promiseOrPromiseFunc, timeout, func) {
  let promiseResolved = false
  const hasAborted = () => promiseResolved

  const promise = promiseOrPromiseFunc.then
    ? promiseOrPromiseFunc
    : promiseOrPromiseFunc(hasAborted)

  let cancel
  const v = await Promise.race([
    promise.then(
      (v) => ((promiseResolved = true), cancel && clearTimeout(cancel), v),
      (err) => ((promiseResolved = true), cancel && clearTimeout(cancel), Promise.reject(err)),
    ),
    new Promise(
      (res) =>
        (cancel = setTimeout(() => {
          if (promiseResolved) res(undefined)
          else {
            cancel = undefined
            promiseResolved = true
            res(func())
          }
        }, timeout)),
    ),
  ])

  return v
}

/**
 *
 * @param {{[x: string]: any}|string} error
 * @param {{[x: string]: any}} [properties=undefined]
 *
 * @returns {{[x: string]: any}}
 */
function makeError(error, properties) {
  if (typeof error === 'string') {
    error = new Error(error)
  }
  if (!properties) return error

  return Object.assign(error, properties)
}

/**
 *
 * @param  {...any[]} arrays
 * @returns {any[][]}
 */
function zip(...arrays) {
  const maxLength = arrays.reduce(
    (maxTillNow, array) => (array.length > maxTillNow ? array.length : maxTillNow),
    0,
  )

  const zipResult = []

  for (const i of range(0, maxLength)) {
    zipResult.push(arrays.map((array) => array[i]))
  }

  return zipResult
}

/**
 * @template T, V
 * @param {(T[]|T)[]} array
 * @param {T => V} [mapperFunction]
 * @returns {V[]}
 */
function flatMap(array, mapperFunction = undefined) {
  const flatResult = []

  for (const a of array) {
    if (Array.isArray(a)) {
      for (const aa of a) {
        flatResult.push(mapperFunction ? mapperFunction(aa) : aa)
      }
    } else {
      flatResult.push(mapperFunction ? mapperFunction(a) : a)
    }
  }

  return flatResult
}

function minus(bigArray = [], smallArray = [], keyMapper = (x) => x) {
  return bigArray.filter((item) => !smallArray.map(keyMapper).includes(keyMapper(item)))
}

function diff(left = [], right = [], keyMapper = (x) => x) {
  const intersection = left.filter((item) => right.map(keyMapper).includes(keyMapper(item)))
  return minus(left.concat(right), intersection, keyMapper)
}

const resolveSymbol = Symbol('resolve-promise')
const rejectSymbol = Symbol('reject-promise')

/**
 * @returns {Promise}
 */
function makeResolveablePromise() {
  let exteriorResolve
  let exteriorReject
  const promise = new Promise(
    (resolve, reject) => ([exteriorResolve, exteriorReject] = [resolve, reject]),
  )

  promise[resolveSymbol] = exteriorResolve
  promise[rejectSymbol] = exteriorReject

  return promise
}

/**
 *
 * @param {Promise} promise
 * @param {any} value
 */
function resolveResolveablePromise(promise, value) {
  promise[resolveSymbol](value)
}

/**
 *
 * @param {Promise} promise
 * @param {any} err
 */
function rejectResolveablePromise(promise, err) {
  promise[rejectSymbol](err)
}

/**
 *
 * @param {object} object
 * @param {string[] | {[x: String]: any}} objectKeys
 *
 * @returns {object}
 */
function pick(object, objectKeys) {
  if (object === undefined) return undefined
  if (object === null) return null

  const keys = Array.isArray(objectKeys) ? objectKeys : Object.keys(objectKeys || {})

  const ret = {}
  for (const key of keys) {
    if (!(key in object)) continue

    ret[key] = object[key]
  }

  return ret
}

function isFunction(functionToCheck) {
  return functionToCheck && typeof functionToCheck == 'function'
}

async function resolve(object) {
  return object
}

/**
 * This function should work like bluebird.props
 * The input is object with fields that their values can be promises (or regular values) and the output is
 * an object with the same keys and the resolved values.
 * @param {} object
 */
async function promiseProps(object) {
  object = await resolve(object)
  if (typeof object != 'object') {
    throw new Error('object must be of type object')
  }
  const result = {}
  const promises = []
  for (let key of Object.keys(object)) {
    async function resolveProperty() {
      return object[key]
    }
    async function populate() {
      const value = await resolveProperty()
      result[key] = value
    }
    promises.push(populate())
  }
  await Promise.all(promises)
  return result
}

/**
 * This function mimics the bluebird.map function.
 * @param {} collection - Collection of elemenst (or promise that resolves to a collection of elements)
 * @param {*} mapper - function(any item, int index, int length)
 * @param {Object {concurrency: int=Infinity}} options
 */
async function promiseMap(collection, mapper, {concurrency} = {concurrency: Infinity}) {
  if (concurrency != Infinity) {
    if (concurrency <= 0 || concurrency > 100) {
      throw new Error('concurrency should be in range: 1..100 or Infinity')
    }
  }

  if (!isFunction(mapper)) {
    throw new Error('mapper must be a function')
  }
  collection = await resolve(collection)
  if (!Array.isArray(collection)) {
    throw new Error('collection must be array')
  }
  if (collection.length == 0) {
    return []
  }
  const promises = []
  const result = new Array(collection.length)
  if (concurrency == Infinity) {
    for (let i = 0; i < collection.length; i++) {
      async function resolveElement() {
        result[i] = await mapper(await resolve(collection[i]), i, collection.length)
      }
      promises.push(resolveElement())
    }
  } else {
    const collectionWithIndexes = []
    for (let i = 0; i < collection.length; i++) {
      collectionWithIndexes.push({object: collection[i], index: i})
    }

    for (let i = 0; i < concurrency; i++) {
      async function worker() {
        while (collectionWithIndexes.length > 0) {
          const element = await resolve(collectionWithIndexes.pop())
          result[element.index] = await mapper(element.object, element.index, collection.length)
        }
      }
      promises.push(worker())
    }
  }
  await Promise.all(promises)
  return result
}

module.exports = {
  cacheFunctionSync,
  cacheFunctionAsync,
  throw_,
  range,
  sum,
  objectFromEntries,
  mapObject,
  mapValues,
  mapKeys,
  filterKeys,
  filterValues,
  filterEntries,
  failAfter,
  presult,
  unwrapPresult,
  ptimeoutWithValue,
  ptimeoutWithError,
  ptimeoutWithFunction,
  makeError,
  zip,
  delay,
  flatMap,
  makeThrottledFunction,
  makeResolveablePromise,
  resolveResolveablePromise,
  rejectResolveablePromise,
  pick,
  minus,
  diff,
  group,
  groupBy,
  promiseMap,
  promiseProps,
  isFunction,
}


/***/ }),

/***/ "./node_modules/@applitools/functional-commons/src/make-throttled-function.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/functional-commons/src/make-throttled-function.js ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";


const ONE_MINUTE_IN_MILLIS = 60 * 1000

/**
 * @template T
 * @param {(...args: any[]) => T} func
 * @param {{maxCallsPerTimeSpan?: number, now?: {nowService: () => number}, timeSpan?: number}} [options]
 * @returns {(...args: any[]) => (T|undefined)}
 */
function makeThrottledFunction(
  func,
  {maxCallsPerTimeSpan = 120, now: nowService = Date.now, timeSpan = ONE_MINUTE_IN_MILLIS},
) {
  let start = nowService()
  let countLogsInMinute = 0
  let loggedWarning = false

  return function (...args) {
    if (nowService() - start >= timeSpan) {
      start = nowService()
      countLogsInMinute = 0
      loggedWarning = false
    }
    ++countLogsInMinute
    if (countLogsInMinute > maxCallsPerTimeSpan) {
      if (!loggedWarning) {
        func('throttling debug messages because max of %d exceeded', maxCallsPerTimeSpan)
        loggedWarning = true
      }
    } else {
      return func(...args)
    }
  }
}

module.exports = makeThrottledFunction


/***/ }),

/***/ "./node_modules/@applitools/http-commons/src/retryFetch.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@applitools/http-commons/src/retryFetch.js ***!
  \*****************************************************************/
/***/ ((module) => {

"use strict";


// NOTE: this file is separate because it's consumed from the visual-grid-client, which should be isomorphic (loaded from node and from the browser).
// Due to this reason, it should remain without dependencies on node builtins (e.g. 'util', which is the reason for defining `psetTimeout` below)

const CONNECTION_ERROR_CODES = new Set([
  'ENOTFOUND',
  'ECONNREFUSED',
  'ETIMEDOUT',
  'EHOSTUNREACH',
  'ECONNRESET',
  'request-timeout',
])

/**
 * @param {Function} f
 * @param {{retries?: number, sleepTime?: number, backoff?: number, idempotent?: boolean}} [options]
 */
async function retryFetch(
  f,
  {retries = 2, sleepTime = 100, backoff = 1.1, idempotent = true} = {},
) {
  for (let retry = 0; retry <= retries; retry++) {
    if (retry === retries) {
      return await f(retry)
    }
    try {
      return await f(retry)
    } catch (err) {
      if (CONNECTION_ERROR_CODES.has(err.code) || CONNECTION_ERROR_CODES.has(err.type)) {
        // retry
      } else if (err.code === 'ERR_X_STATUS_CODE_NOT_OK') {
        if (err.status >= 300 && err.status < 500) {
          throw err
        }
      } else if (idempotent) {
        // retry
      } else {
        throw err
      }
      await psetTimeout(sleepTime * backoff ** retry)
    }
  }
}

function psetTimeout(timeout) {
  return new Promise(res => {
    setTimeout(res, timeout)
  })
}

module.exports = retryFetch


/***/ }),

/***/ "./node_modules/@applitools/isomorphic-fetch/fetch-npm-browserify.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/isomorphic-fetch/fetch-npm-browserify.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// the whatwg-fetch polyfill installs the fetch() function
// on the global object (window or self)
//
// Return that as the export for use in Webpack, Browserify etc.
__webpack_require__(/*! whatwg-fetch */ "./node_modules/whatwg-fetch/fetch.js");
module.exports = self.fetch.bind(self);


/***/ }),

/***/ "./node_modules/@applitools/logger/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@applitools/logger/index.js ***!
  \**************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const makeLogger = __webpack_require__(/*! ./src/logger */ "./node_modules/@applitools/logger/src/logger.js")
module.exports = makeLogger
module.exports.default = makeLogger


/***/ }),

/***/ "./node_modules/@applitools/logger/src/console-handler.js":
/*!****************************************************************!*\
  !*** ./node_modules/@applitools/logger/src/console-handler.js ***!
  \****************************************************************/
/***/ ((module) => {

function makeConsoleLogger() {
  return {log, warn, error}

  function log(message) {
    console.log(message)
  }

  function warn(message) {
    console.warn(message)
  }

  function error(message) {
    console.error(message)
  }
}

module.exports = makeConsoleLogger


/***/ }),

/***/ "./node_modules/@applitools/logger/src/file-handler.js":
/*!*************************************************************!*\
  !*** ./node_modules/@applitools/logger/src/file-handler.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js")
const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js")
const os = __webpack_require__(/*! os */ "./node_modules/os-browserify/browser.js")

function makeFileLogger({filename = 'eyes.log', append = true}) {
  let writer = null

  return {log, open, close}

  function open() {
    const filepath = path.normalize(filename)
    ensureDirectoryExistence(filepath)
    writer = fs.createWriteStream(filepath, {flags: append ? 'a' : 'w', encoding: 'utf8'})
  }
  function close() {
    if (!writer) return
    writer.end()
    writer = null
  }
  function log(message) {
    if (!writer) open()
    writer.write(message + os.EOL)
  }
}

function ensureDirectoryExistence(filename) {
  const dirname = path.dirname(filename)
  if (!fs.existsSync(dirname)) {
    ensureDirectoryExistence(dirname)
    fs.mkdirSync(dirname)
  }
}

module.exports = makeFileLogger


/***/ }),

/***/ "./node_modules/@applitools/logger/src/format.js":
/*!*******************************************************!*\
  !*** ./node_modules/@applitools/logger/src/format.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const chalk = __webpack_require__(/*! chalk */ "./node_modules/chalk/source/index.js")
const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")

function format(message, {formatting = true, label, timestamp = new Date(), level = 'info', tags, color, colors} = {}) {
  const parts = []
  if (formatting) {
    if (label) {
      const text = label.padEnd(10)
      const color = colors && colors.label
      parts.push(color ? colorize(text, {color}) : `${text}|`)
    }
    if (timestamp) {
      const text = new Date(timestamp).toISOString()
      const color = colors && colors.timestamp
      parts.push(color ? colorize(text, {color}) : text)
    }
    if (level) {
      const text = level.toUpperCase().padEnd(5)
      const color = colors && colors.level && colors.level[level]
      parts.push(color ? colorize(` ${text} `, {color}) : `[${text}]`)
    }
    if (!utils.types.isEmpty(tags)) {
      const text = JSON.stringify(tags)
      const color = colors && colors.tags
      parts.push(color ? colorize(text, {color}) : text)
    }
  }
  if (message !== undefined) {
    const text = utils.types.isString(message) ? message : JSON.stringify(message)
    const color = colors && colors.message
    parts.push(color ? colorize(text, {color}) : text)
  }

  const text = parts.join(' ')
  return color ? colorize(text, {color}) : text
}

function colorize(message, {color} = {}) {
  if (!color) return message
  if (!utils.types.isArray(color)) color = [color]
  return color.reduce((chalk, color) => chalk[color] || chalk, chalk)(message)
}

module.exports = format


/***/ }),

/***/ "./node_modules/@applitools/logger/src/logger.js":
/*!*******************************************************!*\
  !*** ./node_modules/@applitools/logger/src/logger.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const makeConsoleHandler = __webpack_require__(/*! ./console-handler */ "./node_modules/@applitools/logger/src/console-handler.js")
const makeFileHandler = __webpack_require__(/*! ./file-handler */ "./node_modules/@applitools/logger/src/file-handler.js")

const LEVELS = {
  silent: 0,
  fatal: 100,
  error: 200,
  warn: 300,
  info: 400,
  // debug: 500,
  // trace: 600,
  all: Number.MAX_VALUE,
}

const COLORS = {
  label: 'cyan',
  timestamp: 'greenBright',
  tags: 'blueBright',
  level: {
    info: ['bgBlueBright', 'black'],
    warn: ['bgYellowBright', 'black'],
    error: ['bgRedBright', 'white'],
    fatal: ['bgRed', 'white'],
  },
}

function makeLogger({
  handler,
  format = __webpack_require__(/*! ./format */ "./node_modules/@applitools/logger/src/format.js"),
  label,
  tags,
  timestamp,
  level = LEVELS.silent,
  colors = false,
  console = true,
} = {}) {
  if (!utils.types.isNumber(level)) level = LEVELS[level] || 0

  if (!handler || handler.type === 'console') {
    if (colors === true) colors = COLORS
    handler = makeConsoleHandler(handler)
  } else if (handler.type === 'file') {
    colors = {}
    handler = makeFileHandler(handler)
  } else {
    if (colors === true) colors = COLORS
    else colors = {}
  }

  return {
    ...makeAPI({handler, format, label, tags, timestamp, level, colors}),
    console: makeAPI({handler: console ? makeConsoleHandler() : handler, format, formatting: false}),
    extend(label, color) {
      return makeLogger({handler, format, label, timestamp, level, colors: {...colors, label: color}})
    },
    open() {
      if (handler.open) handler.open()
    },
    close() {
      if (handler.close) handler.close()
    },
  }

  function makeAPI({handler, format, level, ...defaults}) {
    return {
      log(message, options = {}) {
        if (level < LEVELS.info) return
        const opts = {...defaults, ...options, tags: {...defaults.tags, ...options.tags}, level: 'info'}
        handler.log(format(message, opts))
      },
      warn(message, options = {}) {
        if (level < LEVELS.warn) return
        const opts = {...defaults, ...options, tags: {...defaults.tags, ...options.tags}, level: 'warn'}
        if (handler.warn) handler.warn(format(message, opts))
        else handler.log(format(message, opts))
      },
      error(message, options = {}) {
        if (level < LEVELS.error) return
        const opts = {...defaults, ...options, tags: {...defaults.tags, ...options.tags}, level: 'error'}
        if (handler.error) handler.error(format(message, opts))
        else handler.log(format(message, opts))
      },
      fatal(message, options = {}) {
        if (level < LEVELS.fatal) return
        const opts = {...defaults, ...options, tags: {...defaults.tags, ...options.tags}, level: 'fatal'}
        if (handler.fatal) handler.fatal(format(message, opts))
        else if (handler.error) handler.error(format(message, opts))
        else handler.log(format(message, opts))
      },
    }
  }
}

module.exports = makeLogger


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/index.js":
/*!********************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/index.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./src/screenshoter */ "./node_modules/@applitools/screenshoter/src/screenshoter.js")


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/find-image-pattern.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/find-image-pattern.js ***!
  \*************************************************************************/
/***/ ((module) => {

function findImagePattern(image, pattern) {
  for (let pixel = 0; pixel < image.width * image.height; ++pixel) {
    if (isPattern(image, pixel, pattern)) {
      return {
        x: (pixel % image.width) - pattern.offset,
        y: Math.floor(pixel / image.width) - pattern.offset,
      }
    }
  }
  return null
}

function isPattern(image, index, pattern) {
  const channels = 4
  const roundNumber = pattern.size - Math.floor(pattern.size / 2)
  for (const [chunkIndex, chunkColor] of pattern.mask.entries()) {
    const pixelOffset = index + image.width * pattern.size * chunkIndex
    for (let round = 0; round < roundNumber; ++round) {
      const sideLength = pattern.size - round * 2
      const stepsNumber = sideLength * channels - channels
      const threshold = Math.min((roundNumber - round) * 10 + 10, 100)
      for (let step = 0; step < stepsNumber; ++step) {
        let pixelIndex = pixelOffset + round + round * image.width

        if (step < sideLength) {
          pixelIndex += step
        } else if (step < sideLength * 2 - 1) {
          pixelIndex += sideLength - 1 + ((step % sideLength) + 1) * image.width
        } else if (step < sideLength * 3 - 2) {
          pixelIndex += (sideLength - 1) * image.width + (sideLength - (step % sideLength) - 1)
        } else {
          pixelIndex += (step % sideLength) * image.width
        }

        const pixelColor = pixelColorAt(image, pixelIndex, threshold)
        if (pixelColor !== chunkColor) {
          return false
        }
      }
    }
  }
  return true
}

function pixelColorAt(image, index, threshold = 0) {
  const channels = 4
  const r = image.data[index * channels]
  const g = image.data[index * channels + 1]
  const b = image.data[index * channels + 2]
  const rgb = [r, g, b]

  // WHITE
  if (rgb.every(sub => sub >= 255 - threshold)) return 1
  // BLACK
  else if (rgb.every(sub => sub <= threshold)) return 0
  // OTHER
  else return -1
}

module.exports = findImagePattern


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/image.js":
/*!************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/image.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];
const fs = __webpack_require__(/*! fs */ "./src/builtins/fs.js")
const stream = __webpack_require__(/*! stream */ "./node_modules/stream-browserify/index.js")
const path = __webpack_require__(/*! path */ "./node_modules/path-browserify/index.js")
const png = __webpack_require__(/*! png-async */ "./node_modules/png-async/lib/index.js")
const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")

function makeImage(data) {
  let image, size
  let transforms = {rotate: 0, scale: 1, crop: null}

  if (utils.types.isBase64(data)) {
    const buffer = Buffer.from(data, 'base64')
    image = fromBuffer(buffer)
    size = extractPngSize(buffer)
  } else if (utils.types.isString(data)) {
    const buffer = fs.readFileSync(data)
    image = fromBuffer(buffer)
    size = extractPngSize(buffer)
  } else if (Buffer.isBuffer(data)) {
    image = fromBuffer(data)
    size = extractPngSize(data)
  } else if (data.isImage) {
    image = data.toRaw()
    size = data.size
    transforms = data.transforms
  } else if (utils.types.has(data, ['width', 'height'])) {
    image = fromSize(data)
    size = data
  } else {
    throw new Error('Unable to create an image abstraction from unknown data')
  }

  if (!transforms.crop) {
    transforms.crop = utils.geometry.region({x: 0, y: 0}, size)
  }

  return {
    get isImage() {
      return true
    },
    get size() {
      return {...utils.geometry.scale(size, transforms.scale)}
    },
    get transforms() {
      return {...transforms}
    },
    get width() {
      return size.width
    },
    get height() {
      return size.height
    },
    scale(ratio) {
      transforms.scale *= ratio
      return this
    },
    crop(region) {
      if (utils.types.has(region, ['left', 'right', 'top', 'bottom'])) {
        region = {
          x: region.left / transforms.scale,
          y: region.top / transforms.scale,
          width: image.width - (region.left + region.right) / transforms.scale,
          height: image.height - (region.top + region.bottom) / transforms.scale,
        }
      } else {
        region = utils.geometry.scale(region, 1 / transforms.scale)
      }
      region = utils.geometry.rotate(region, transforms.rotate)
      transforms.crop = utils.geometry.intersect(transforms.crop, region)

      size = utils.geometry.round(utils.geometry.size(transforms.crop))

      return this
    },
    rotate(degree) {
      transforms.rotate = (transforms.rotate + degree) % 360
      return this
    },
    async copy(srcImage, offset) {
      const [dst, src] = await Promise.all([this.toObject(), srcImage.toObject()])
      image = await copy(dst, src, offset)
      return this
    },
    async combine(firstImage, lastImage, region) {
      const [src, first, last] = await Promise.all([this.toObject(), firstImage.toObject(), lastImage.toObject()])
      image = await combine(first, last, src, region)
      size = {width: image.width, height: image.height}
      return this
    },
    async toBuffer() {
      const image = await this.toObject()
      return image.data
    },
    async toPng() {
      return toPng(await this.toObject())
    },
    async toFile(path) {
      return toFile(await this.toObject(), path)
    },
    async toRaw() {
      return image
    },
    async toObject() {
      image = await transform(await image, transforms)
      transforms = {rotate: 0, scale: 1, crop: utils.geometry.region({x: 0, y: 0}, size)}
      return image
    },
    async debug(debug) {
      if (!debug || !debug.path) return
      const timestamp = new Date().toISOString().replace(/[-T:.]/g, '_')
      const filename = ['screenshot', timestamp, debug.name, debug.suffix].filter(part => part).join('_') + '.png'
      return toFile(await transform(await image, transforms), path.join(debug.path, filename)).catch(() => null)
    },
  }
}

function extractPngSize(buffer) {
  return buffer.slice(12, 16).toString('ascii') === 'IHDR'
    ? {width: buffer.readUInt32BE(16), height: buffer.readUInt32BE(20)}
    : {width: 0, height: 0}
}

async function fromBuffer(buffer) {
  return new Promise((resolve, reject) => {
    const image = new png.Image()

    image.parse(buffer, (err, image) => {
      if (err) return reject(err)
      resolve(image)
    })
  })
}

async function fromSize(size) {
  return new png.Image({width: size.width, height: size.height})
}

async function toPng(image) {
  return new Promise((resolve, reject) => {
    let buffer = Buffer.alloc(0)

    const writable = new stream.Writable({
      write(chunk, _encoding, next) {
        buffer = Buffer.concat([buffer, chunk])
        next()
      },
    })

    image
      .pack()
      .pipe(writable)
      .on('finish', () => resolve(buffer))
      .on('error', err => reject(err))
  })
}

async function toFile(image, path) {
  const buffer = await toPng(image)
  return new Promise((resolve, reject) => {
    fs.writeFile(path, buffer, err => (err ? reject(err) : resolve()))
  })
}

async function transform(image, transforms) {
  const croppedImage = transforms.crop ? await extract(image, transforms.crop) : image
  const scaledImage = transforms.scale !== 1 ? await scale(croppedImage, transforms.scale) : croppedImage
  const rotatedImage = transforms.rotate > 0 ? await rotate(scaledImage, transforms.rotate) : scaledImage
  return rotatedImage
}

async function scale(image, scaleRatio) {
  if (scaleRatio === 1) return image

  const ratio = image.height / image.width
  const scaledWidth = Math.ceil(image.width * scaleRatio)
  const scaledHeight = Math.ceil(scaledWidth * ratio)
  return resize(image, {width: scaledWidth, height: scaledHeight})
}

async function resize(image, size) {
  const dst = {
    data: Buffer.alloc(size.height * size.width * 4),
    width: size.width,
    height: size.height,
  }

  if (dst.width > image.width || dst.height > image.height) {
    _doBicubicInterpolation(image, dst)
  } else {
    _scaleImageIncrementally(image, dst)
  }

  image.data = dst.data
  image.width = dst.width
  image.height = dst.height

  return image
}

async function extract(image, region) {
  const srcX = Math.max(0, Math.round(region.x))
  const srcY = Math.max(0, Math.round(region.y))
  const dstWidth = Math.round(Math.min(image.width - srcX, region.width))
  const dstHeight = Math.round(Math.min(image.height - srcY, region.height))
  const dstSize = {width: dstWidth, height: dstHeight}

  if (utils.geometry.isEmpty(dstSize)) {
    throw new Error(`Cannot extract empty region (${srcX};${srcY})${dstWidth}x${dstHeight} from image`)
  }

  const extracted = new png.Image(dstSize)

  if (srcX === 0 && dstWidth === image.width) {
    const srcOffset = srcY * image.width * 4
    const dstLength = dstWidth * dstHeight * 4
    extracted.data.set(image.data.subarray(srcOffset, srcOffset + dstLength))
  } else {
    const chunkLength = dstWidth * 4
    for (let chunk = 0; chunk < dstHeight; ++chunk) {
      const srcOffset = ((srcY + chunk) * image.width + srcX) * 4
      extracted.data.set(image.data.subarray(srcOffset, srcOffset + chunkLength), chunk * chunkLength)
    }
  }

  return extracted
}

async function rotate(image, degrees) {
  degrees = (360 + degrees) % 360

  const dstImage = new png.Image({width: image.width, height: image.height})

  if (degrees === 90) {
    dstImage.width = image.height
    dstImage.height = image.width
    for (let srcY = 0, dstX = image.height - 1; srcY < image.height; ++srcY, --dstX) {
      for (let srcX = 0, dstY = 0; srcX < image.width; ++srcX, ++dstY) {
        const pixel = image.data.readUInt32BE((srcY * image.width + srcX) * 4)
        dstImage.data.writeUInt32BE(pixel, (dstY * dstImage.width + dstX) * 4)
      }
    }
  } else if (degrees === 180) {
    dstImage.width = image.width
    dstImage.height = image.height
    for (let srcY = 0, dstY = image.height - 1; srcY < image.height; ++srcY, --dstY) {
      for (let srcX = 0, dstX = image.width - 1; srcX < image.width; ++srcX, --dstX) {
        const pixel = image.data.readUInt32BE((srcY * image.width + srcX) * 4)
        dstImage.data.writeUInt32BE(pixel, (dstY * dstImage.width + dstX) * 4)
      }
    }
  } else if (degrees === 270) {
    dstImage.width = image.height
    dstImage.height = image.width
    for (let srcY = 0, dstX = 0; srcY < image.height; ++srcY, ++dstX) {
      for (let srcX = 0, dstY = image.width - 1; srcX < image.width; ++srcX, --dstY) {
        const pixel = image.data.readUInt32BE((srcY * image.width + srcX) * 4)
        dstImage.data.writeUInt32BE(pixel, (srcX * dstImage.width + dstY) * 4)
      }
    }
  } else {
    return dstImage.data.set(image.data)
  }

  return dstImage
}

async function copy(dstImage, srcImage, offset) {
  const dstX = Math.round(offset.x)
  const dstY = Math.round(offset.y)
  const srcWidth = Math.min(srcImage.width, dstImage.width - dstX)
  const srcHeight = Math.min(srcImage.height, dstImage.height - dstY)

  if (dstX === 0 && srcWidth === dstImage.width && srcWidth === srcImage.width) {
    const dstOffset = dstY * dstImage.width * 4
    dstImage.data.set(srcImage.data.subarray(0, srcWidth * srcHeight * 4), dstOffset)
    return dstImage
  }

  const chunkLength = srcWidth * 4
  for (let chunk = 0; chunk < srcHeight; ++chunk) {
    const srcOffset = chunk * srcImage.width * 4
    const dstOffset = ((dstY + chunk) * dstImage.width + dstX) * 4
    dstImage.data.set(srcImage.data.subarray(srcOffset, srcOffset + chunkLength), dstOffset)
  }

  return dstImage
}

async function combine(firstImage, lastImage, srcImage, region) {
  region = utils.geometry.intersect({x: 0, y: 0, width: firstImage.width, height: firstImage.height}, region)

  if (region.x === 0 && region.y === 0 && region.width >= firstImage.width && region.height >= firstImage.height) {
    return srcImage
  }

  if (region.width === srcImage.width && region.height === srcImage.height) {
    await copy(firstImage, srcImage, {x: region.x, y: region.y})
    return firstImage
  }

  const dstImage = new png.Image({
    width: firstImage.width - region.width + srcImage.width,
    height: firstImage.height - region.height + srcImage.height,
  })

  if (region.width === srcImage.width) {
    const topImage = await extract(firstImage, {
      x: 0,
      y: 0,
      width: firstImage.width,
      height: region.y + region.height,
    })
    await copy(dstImage, topImage, {x: 0, y: 0})
  } else if (region.height === srcImage.height) {
    const leftImage = await extract(firstImage, {
      x: 0,
      y: 0,
      width: region.x + region.width,
      height: firstImage.height,
    })
    await copy(dstImage, leftImage, {x: 0, y: 0})
  } else {
    const topLeftImage = await extract(firstImage, {
      x: 0,
      y: 0,
      width: region.x + region.width,
      height: region.y + region.height,
    })
    await copy(dstImage, topLeftImage, {x: 0, y: 0})
    const topRightImage = await extract(firstImage, {
      x: region.x + region.width,
      y: 0,
      width: firstImage.width - (region.x + region.width),
      height: region.y + region.height,
    })
    await copy(dstImage, topRightImage, {x: region.x + srcImage.width, y: 0})
  }

  await copy(dstImage, srcImage, {x: region.x, y: region.y})

  if (lastImage.height > region.y + region.height) {
    if (region.width === srcImage.width) {
      const bottomImage = await extract(lastImage, {
        x: 0,
        y: region.y + region.height,
        width: lastImage.width,
        height: lastImage.height - (region.y + region.height),
      })
      await copy(dstImage, bottomImage, {x: 0, y: region.y + srcImage.height})
    } else if (region.height === srcImage.height) {
      const rightImage = await extract(lastImage, {
        x: region.x + region.width,
        y: 0,
        width: lastImage.width - (region.x + region.width),
        height: lastImage.height,
      })
      await copy(dstImage, rightImage, {x: region.x + srcImage.width, y: 0})
    } else {
      const bottomLeftImage = await extract(lastImage, {
        x: 0,
        y: region.y + region.height,
        width: region.x + region.width,
        height: lastImage.height - (region.y + region.height),
      })
      await copy(dstImage, bottomLeftImage, {x: 0, y: region.y + srcImage.height})
      const bottomRightImage = await extract(lastImage, {
        x: region.x + region.width,
        y: region.y + region.height,
        width: lastImage.width - (region.x + region.width),
        height: lastImage.height - (region.y + region.height),
      })
      await copy(dstImage, bottomRightImage, {
        x: region.x + srcImage.width,
        y: region.y + srcImage.height,
      })
    }
  }

  return dstImage
}

function _interpolateCubic(x0, x1, x2, x3, t) {
  const a0 = x3 - x2 - x0 + x1
  const a1 = x0 - x1 - a0
  const a2 = x2 - x0

  return Math.ceil(Math.max(0, Math.min(255, a0 * (t * t * t) + a1 * (t * t) + (a2 * t + x1))))
}

function _interpolateRows(bufSrc, wSrc, hSrc, wDst) {
  const buf = Buffer.alloc(wDst * hSrc * 4)
  for (let i = 0; i < hSrc; i += 1) {
    for (let j = 0; j < wDst; j += 1) {
      const x = (j * (wSrc - 1)) / wDst
      const xPos = Math.floor(x)
      const t = x - xPos
      const srcPos = (i * wSrc + xPos) * 4
      const buf1Pos = (i * wDst + j) * 4
      for (let k = 0; k < 4; k += 1) {
        const kPos = srcPos + k
        const x0 = xPos > 0 ? bufSrc[kPos - 4] : 2 * bufSrc[kPos] - bufSrc[kPos + 4]
        const x1 = bufSrc[kPos]
        const x2 = bufSrc[kPos + 4]
        const x3 = xPos < wSrc - 2 ? bufSrc[kPos + 8] : 2 * bufSrc[kPos + 4] - bufSrc[kPos]
        buf[buf1Pos + k] = _interpolateCubic(x0, x1, x2, x3, t)
      }
    }
  }

  return buf
}

function _interpolateColumns(bufSrc, hSrc, wDst, hDst) {
  const buf = Buffer.alloc(wDst * hDst * 4)
  for (let i = 0; i < hDst; i += 1) {
    for (let j = 0; j < wDst; j += 1) {
      const y = (i * (hSrc - 1)) / hDst

      const yPos = Math.floor(y)
      const t = y - yPos
      const buf1Pos = (yPos * wDst + j) * 4
      const buf2Pos = (i * wDst + j) * 4
      for (let k = 0; k < 4; k += 1) {
        const kPos = buf1Pos + k
        const y0 = yPos > 0 ? bufSrc[kPos - wDst * 4] : 2 * bufSrc[kPos] - bufSrc[kPos + wDst * 4]
        const y1 = bufSrc[kPos]
        const y2 = bufSrc[kPos + wDst * 4]
        const y3 = yPos < hSrc - 2 ? bufSrc[kPos + wDst * 8] : 2 * bufSrc[kPos + wDst * 4] - bufSrc[kPos]

        buf[buf2Pos + k] = _interpolateCubic(y0, y1, y2, y3, t)
      }
    }
  }

  return buf
}

function _interpolateScale(bufColumns, wDst, hDst, wDst2, m, wM, hM) {
  const buf = Buffer.alloc(wDst * hDst * 4)
  for (let i = 0; i < hDst; i += 1) {
    for (let j = 0; j < wDst; j += 1) {
      let r = 0
      let g = 0
      let b = 0
      let a = 0
      let realColors = 0
      for (let y = 0; y < hM; y += 1) {
        const yPos = i * hM + y
        for (let x = 0; x < wM; x += 1) {
          const xPos = j * wM + x
          const xyPos = (yPos * wDst2 + xPos) * 4
          const pixelAlpha = bufColumns[xyPos + 3]
          if (pixelAlpha) {
            r += bufColumns[xyPos]
            g += bufColumns[xyPos + 1]
            b += bufColumns[xyPos + 2]
            realColors += 1
          }
          a += pixelAlpha
        }
      }

      const pos = (i * wDst + j) * 4
      buf[pos] = realColors ? Math.round(r / realColors) : 0
      buf[pos + 1] = realColors ? Math.round(g / realColors) : 0
      buf[pos + 2] = realColors ? Math.round(b / realColors) : 0
      buf[pos + 3] = Math.round(a / m)
    }
  }

  return buf
}

function _doBicubicInterpolation(src, dst) {
  // The implementation was taken from
  // https://github.com/oliver-moran/jimp/blob/master/resize2.js

  // when dst smaller than src/2, interpolate first to a multiple between 0.5 and 1.0 src, then sum squares
  const wM = Math.max(1, Math.floor(src.width / dst.width))
  const wDst2 = dst.width * wM
  const hM = Math.max(1, Math.floor(src.height / dst.height))
  const hDst2 = dst.height * hM

  // Pass 1 - interpolate rows
  // bufRows has width of dst2 and height of src
  const bufRows = _interpolateRows(src.data, src.width, src.height, wDst2)

  // Pass 2 - interpolate columns
  // bufColumns has width and height of dst2
  const bufColumns = _interpolateColumns(bufRows, src.height, wDst2, hDst2)

  // Pass 3 - scale to dst
  const m = wM * hM
  if (m > 1) {
    dst.data = _interpolateScale(bufColumns, dst.width, dst.height, wDst2, m, wM, hM)
  } else {
    dst.data = bufColumns
  }

  return dst
}

function _scaleImageIncrementally(src, dst) {
  let currentWidth = src.width
  let currentHeight = src.height
  const targetWidth = dst.width
  const targetHeight = dst.height

  dst.data = src.data
  dst.width = src.width
  dst.height = src.height

  // For ultra quality should use 7
  const fraction = 2

  do {
    const prevCurrentWidth = currentWidth
    const prevCurrentHeight = currentHeight

    // If the current width is bigger than our target, cut it in half and sample again.
    if (currentWidth > targetWidth) {
      currentWidth -= Math.floor(currentWidth / fraction)

      // If we cut the width too far it means we are on our last iteration. Just set it to the target width
      // and finish up.
      if (currentWidth < targetWidth) {
        currentWidth = targetWidth
      }
    }

    // If the current height is bigger than our target, cut it in half and sample again.
    if (currentHeight > targetHeight) {
      currentHeight -= Math.floor(currentHeight / fraction)

      // If we cut the height too far it means we are on our last iteration. Just set it to the target height
      // and finish up.
      if (currentHeight < targetHeight) {
        currentHeight = targetHeight
      }
    }

    // Stop when we cannot incrementally step down anymore.
    if (prevCurrentWidth === currentWidth && prevCurrentHeight === currentHeight) {
      return dst
    }

    // Render the incremental scaled image.
    const incrementalImage = {
      data: Buffer.alloc(currentWidth * currentHeight * 4),
      width: currentWidth,
      height: currentHeight,
    }
    _doBicubicInterpolation(dst, incrementalImage)

    // Now treat our incremental partially scaled image as the src image
    // and cycle through our loop again to do another incremental scaling of it (if necessary).
    dst.data = incrementalImage.data
    dst.width = incrementalImage.width
    dst.height = incrementalImage.height
  } while (currentWidth !== targetWidth || currentHeight !== targetHeight)

  return dst
}

module.exports = makeImage


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/screenshoter.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/screenshoter.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const makeScroller = __webpack_require__(/*! ./scroller */ "./node_modules/@applitools/screenshoter/src/scroller.js")
const scrollIntoViewport = __webpack_require__(/*! ./scroll-into-viewport */ "./node_modules/@applitools/screenshoter/src/scroll-into-viewport.js")
const takeStitchedScreenshot = __webpack_require__(/*! ./take-stitched-screenshot */ "./node_modules/@applitools/screenshoter/src/take-stitched-screenshot.js")
const takeViewportScreenshot = __webpack_require__(/*! ./take-viewport-screenshot */ "./node_modules/@applitools/screenshoter/src/take-viewport-screenshot.js")

async function screenshoter({
  driver,
  frames = [],
  region,
  fully,
  scrollingMode,
  hideScrollbars,
  hideCaret,
  overlap,
  framed,
  wait,
  stabilization,
  hooks,
  debug,
  logger,
}) {
  // screenshot of a window/app was requested (fully or viewport)
  const window = !region && (!frames || frames.length === 0)
  // framed screenshots could be taken only when screenshot of window/app fully was requested
  framed = framed && fully && window

  const activeContext = driver.currentContext
  const context =
    frames.length > 0
      ? await activeContext.context(frames.reduce((parent, frame) => ({...frame, parent}), null))
      : activeContext

  // traverse from main context to target context to hide scrollbars and preserve context state (scroll/translate position)
  for (const nextContext of context.path) {
    const scrollingElement = await nextContext.getScrollingElement()
    // unlike web apps, native apps do not always have scrolling element
    if (scrollingElement) {
      if (driver.isWeb && hideScrollbars) await scrollingElement.hideScrollbars()
      await scrollingElement.preserveState()
    }
  }

  // blur active element in target context
  const activeElement = driver.isWeb && hideCaret ? await context.blurElement() : null

  const target = await getTarget({window, context, region, fully, scrollingMode, logger})

  if (driver.isWeb && hideScrollbars) await target.scroller.hideScrollbars()

  try {
    if (!window) await scrollIntoViewport({...target, logger})

    const screenshot = fully
      ? await takeStitchedScreenshot({...target, overlap, framed, wait, stabilization, debug, logger})
      : await takeViewportScreenshot({...target, wait, stabilization, debug, logger})

    if (hooks && hooks.afterScreenshot) {
      // imitate image-like state for the hook
      if (window && fully) {
        await target.scroller.moveTo({x: 0, y: 0}, await driver.mainContext.getScrollingElement())
      }
      await hooks.afterScreenshot({driver, scroller: target.scroller, screenshot})
    }

    return screenshot
  } finally {
    await target.scroller.restoreScrollbars()

    // if there was active element and we have blurred it, then restore focus
    if (activeElement) await context.focusElement(activeElement)

    // traverse from target context to the main context to restore scrollbars and context states
    for (const prevContext of context.path.reverse()) {
      const scrollingElement = await prevContext.getScrollingElement()
      if (scrollingElement) {
        if (driver.isWeb && hideScrollbars) await scrollingElement.restoreScrollbars()
        await scrollingElement.restoreState()
      }
    }

    // restore focus on original active context
    await activeContext.focus()
  }
}

async function getTarget({window, context, region, fully, scrollingMode, logger}) {
  if (window) {
    // window/app
    const scrollingElement = await context.main.getScrollingElement()
    return {
      context: context.main,
      scroller: makeScroller({element: scrollingElement, scrollingMode, logger}),
    }
  } else if (region) {
    if (utils.types.has(region, ['x', 'y', 'width', 'height'])) {
      // region by coordinates
      const scrollingElement = await context.getScrollingElement()
      return {
        context,
        region,
        scroller: makeScroller({element: scrollingElement, scrollingMode, logger}),
      }
    } else {
      // region by element or selector
      const element = await context.element(region)
      if (!element) throw new Error('Element not found!')

      if (fully) {
        const isScrollable = await element.isScrollable()
        // if element is scrollable, then take screenshot of the full element content, otherwise take screenshot of full element
        const region = isScrollable ? null : await element.getRegion()
        const scrollingElement = isScrollable ? element : await context.getScrollingElement()
        // css stitching could be applied only to root element of its context
        scrollingMode = scrollingMode === 'css' && !(await scrollingElement.isRoot()) ? 'mixed' : scrollingMode
        return {
          context,
          region,
          scroller: makeScroller({element: scrollingElement, scrollingMode, logger}),
        }
      } else {
        const scrollingElement = await context.getScrollingElement()
        return {
          context,
          region: await element.getRegion(),
          scroller: makeScroller({element: scrollingElement, scrollingMode, logger}),
        }
      }
    }
  } else if (!context.isMain) {
    // context
    if (fully) {
      const scrollingElement = await context.getScrollingElement()
      return {
        context,
        scroller: makeScroller({logger, element: scrollingElement, scrollingMode}),
      }
    } else {
      const scrollingElement = await context.parent.getScrollingElement()
      const element = await context.getContextElement()
      return {
        context: context.parent,
        region: await element.getRegion(), // IMHO we should use CLIENT (without borders) region here
        scroller: makeScroller({logger, element: scrollingElement, scrollingMode}),
      }
    }
  }
}

module.exports = screenshoter


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/scroll-into-viewport.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/scroll-into-viewport.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")

async function scrollIntoViewport({context, scroller, region, logger}) {
  if (context.driver.isNative) {
    logger.verbose(`NATIVE context identified, skipping 'ensure element visible'`)
    return
  }
  const elementContextRegion = region ? {...region} : await scroller.getClientRegion()
  const contextViewportLocation = await context.getLocationInViewport()
  const elementViewportRegion = utils.geometry.offset(elementContextRegion, contextViewportLocation)
  const viewportRegion = await context.main.getRegion()
  if (utils.geometry.contains(viewportRegion, elementViewportRegion)) return {x: 0, y: 0}

  let currentContext = context
  let remainingOffset = {x: elementContextRegion.x, y: elementContextRegion.y}
  while (currentContext) {
    const scrollingElement = await currentContext.getScrollingElement()
    const scrollingElementOffset = scrollingElement
      ? utils.geometry.location(await scrollingElement.getClientRegion())
      : {x: 0, y: 0}

    const actualOffset = await scroller.moveTo(
      utils.geometry.offsetNegative(remainingOffset, scrollingElementOffset),
      scrollingElement,
    )

    remainingOffset = utils.geometry.offset(
      utils.geometry.offsetNegative(remainingOffset, actualOffset),
      utils.geometry.location(await currentContext.getClientRegion()),
    )
    currentContext = currentContext.parent
  }
  return remainingOffset
}

module.exports = scrollIntoViewport


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/scroller.js":
/*!***************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/scroller.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")

function makeScroller({logger, element, scrollingMode = 'mixed'}) {
  const defaultElement = element

  return {
    element,
    moveTo,
    getInnerOffset,
    getContentSize,
    getClientRegion,
    getScrollOffset,
    getTranslateOffset,
    getShiftOffset,
    scrollTo,
    translateTo,
    shiftTo,
    preserveState,
    restoreState,
    hideScrollbars,
    restoreScrollbars,
  }

  async function moveTo(offset, element = defaultElement) {
    if (scrollingMode === 'scroll') return scrollTo(offset, element)
    if (scrollingMode === 'css') return translateTo(offset, element)
    if (scrollingMode === 'mixed') return shiftTo(offset, element)
  }

  async function getInnerOffset(element = defaultElement) {
    if (scrollingMode === 'scroll') return getScrollOffset(element)
    if (scrollingMode === 'css') return getTranslateOffset(element)
    if (scrollingMode === 'mixed') return getShiftOffset(element)
  }

  async function getContentSize() {
    const size = await element.getContentSize()
    return size
  }

  async function getClientRegion() {
    const region = await element.getClientRegion()
    // const location = await element.context.getLocationInPage()
    return region
  }

  async function getScrollOffset(element = defaultElement) {
    try {
      const offset = await element.getScrollOffset()
      return offset
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to extract current scroll offset!`, err)
      return {x: 0, y: 0}
    }
  }

  async function getTranslateOffset(element = defaultElement) {
    try {
      const offset = await element.getTranslateOffset()
      return offset
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to extract current translate offset!`, err)
      return {x: 0, y: 0}
    }
  }

  async function getShiftOffset(element = defaultElement) {
    try {
      const scrollOffset = await element.getScrollOffset()
      const translateOffset = await element.getTranslateOffset()
      return utils.geometry.offset(scrollOffset, translateOffset)
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to set current scroll offset!.`, err)
      return {x: 0, y: 0}
    }
  }

  async function scrollTo(offset, element = defaultElement) {
    try {
      // offset = {x: Math.max(offset.x, 0), y: Math.max(offset.y, 0)}
      const scrollOffset = await element.scrollTo(offset)
      return scrollOffset
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to set current scroll offset!.`, err)
      return {x: 0, y: 0}
    }
  }

  async function translateTo(offset, element = defaultElement) {
    try {
      // offset = {x: Math.max(offset.x, 0), y: Math.max(offset.y, 0)}
      await element.scrollTo({x: 0, y: 0})
      const translateOffset = await element.translateTo(offset)
      return translateOffset
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to set current scroll offset!.`, err)
      return {x: 0, y: 0}
    }
  }

  async function shiftTo(offset, element = defaultElement) {
    try {
      // offset = {x: Math.max(offset.x, 0), y: Math.max(offset.y, 0)}
      const scrollOffset = await element.scrollTo(offset)
      const remainingOffset = utils.geometry.offsetNegative(offset, scrollOffset)
      const translateOffset = await element.translateTo(remainingOffset)

      return utils.geometry.offset(scrollOffset, translateOffset)
    } catch (err) {
      // Sometimes it is expected e.g. on Appium, otherwise, take care
      logger.verbose(`Failed to set current scroll offset!.`, err)
      return {x: 0, y: 0}
    }
  }

  async function preserveState(element = defaultElement) {
    try {
      return element.preserveState()
    } catch (err) {
      logger.verbose(`Failed to get current transforms!.`, err)
      return {}
    }
  }

  async function restoreState(state, element = defaultElement) {
    try {
      await element.restoreState(state)
    } catch (err) {
      logger.verbose(`Failed to restore state!.`, err)
    }
  }

  async function hideScrollbars(element = defaultElement) {
    try {
      return element.hideScrollbars()
    } catch (err) {
      logger.verbose(`Failed to get current transforms!.`, err)
      return {}
    }
  }

  async function restoreScrollbars(state, element = defaultElement) {
    try {
      await element.restoreScrollbars(state)
    } catch (err) {
      logger.verbose(`Failed to restore state!.`, err)
    }
  }
}

module.exports = makeScroller


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/take-screenshot.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/take-screenshot.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const snippets = __webpack_require__(/*! @applitools/snippets */ "./node_modules/@applitools/snippets/dist/index.js")
const findImagePattern = __webpack_require__(/*! ./find-image-pattern */ "./node_modules/@applitools/screenshoter/src/find-image-pattern.js")
const makeImage = __webpack_require__(/*! ./image */ "./node_modules/@applitools/screenshoter/src/image.js")

function makeTakeScreenshot(options) {
  const {driver} = options
  if (driver.isNative) {
    return makeTakeNativeScreenshot(options)
  } else if (driver.browserName === 'Firefox') {
    try {
      const browserVersion = Number.parseInt(driver.browserVersion, 10)
      if (browserVersion >= 48 && browserVersion <= 72) {
        return makeTakeMainContextScreenshot(options)
      }
    } catch (ignored) {}
  } else if (driver.browserName === 'Safari') {
    if (driver.isIOS) {
      return makeTakeMarkedScreenshot(options)
    } else if (driver.browserVersion === '11') {
      return makeTakeSafari11Screenshot(options)
    }
  }

  return makeTakeDefaultScreenshot(options)
}

function makeTakeDefaultScreenshot({driver, stabilization = {}, debug, logger}) {
  const calculateScaleRatio = makeCalculateScaleRatio({driver})
  return async function takeScreenshot({name} = {}) {
    logger.verbose('Taking screenshot...')
    const image = makeImage(await driver.takeScreenshot())
    await image.debug({...debug, name, suffix: 'original'})

    if (stabilization.scale) image.scale(stabilization.scale)
    else image.scale(await calculateScaleRatio(image.width))

    if (stabilization.rotate) image.crop(stabilization.rotate)

    if (stabilization.crop) image.crop(stabilization.crop)

    return image
  }
}

function makeTakeMainContextScreenshot({driver, stabilization = {}, debug, logger}) {
  const calculateScaleRatio = makeCalculateScaleRatio({driver})
  return async function takeScreenshot({name} = {}) {
    logger.verbose('Taking screenshot...')
    const originalContext = driver.currentContext
    await driver.mainContext.focus()
    const image = makeImage(await driver.takeScreenshot())
    await originalContext.focus()
    await image.debug({...debug, name, suffix: 'original'})

    if (stabilization.scale) image.scale(stabilization.scale)
    else image.scale(await calculateScaleRatio(image.width))

    if (stabilization.rotate) image.rotate(stabilization.rotate)

    if (stabilization.crop) image.crop(stabilization.crop)

    return image
  }
}

function makeTakeSafari11Screenshot({driver, stabilization = {}, debug, logger}) {
  const calculateScaleRatio = makeCalculateScaleRatio({driver})
  let viewportSize

  return async function takeScreenshot({name} = {}) {
    logger.verbose('Taking safari 11 driver screenshot...')
    const image = makeImage(await driver.takeScreenshot())
    await image.debug({...debug, name, suffix: 'original'})

    if (stabilization.scale) image.scale(stabilization.scale)
    else image.scale(await calculateScaleRatio(image.width))

    if (stabilization.rotate) image.rotate(stabilization.rotate)

    if (stabilization.crop) image.crop(stabilization.crop)
    else {
      if (!viewportSize) viewportSize = await driver.getViewportSize()
      const viewportLocation = await driver.mainContext.execute(snippets.getElementScrollOffset, [])
      image.crop(utils.geometry.region(viewportLocation, viewportSize))
    }

    return image
  }
}

function makeTakeMarkedScreenshot({driver, stabilization = {}, debug, logger}) {
  const calculateScaleRatio = makeCalculateScaleRatio({driver})
  let viewportRegion

  return async function takeScreenshot({name} = {}) {
    logger.verbose('Taking viewport screenshot (using markers)...')
    const image = makeImage(await driver.takeScreenshot())
    await image.debug({...debug, name, suffix: 'original'})

    if (stabilization.scale) image.scale(stabilization.scale)
    else image.scale(await calculateScaleRatio(image.width))

    if (stabilization.rotate) image.rotate(stabilization.rotate)

    if (stabilization.crop) image.crop(stabilization.crop)
    else {
      if (!viewportRegion) viewportRegion = await getViewportRegion()
      image.crop(viewportRegion)
    }

    return image
  }

  async function getViewportRegion() {
    const marker = await driver.mainContext.execute(snippets.addPageMarker)
    try {
      const image = makeImage(await driver.takeScreenshot())

      if (stabilization.rotate) await image.rotate(stabilization.rotate)

      await image.debug({...debug, name: 'marker'})

      const markerLocation = findImagePattern(await image.toObject(), marker)
      if (!markerLocation) return null

      const viewportSize = await driver.getViewportSize()

      return utils.geometry.region(markerLocation, viewportSize)
    } finally {
      await driver.mainContext.execute(snippets.cleanupPageMarker)
    }
  }
}

function makeTakeNativeScreenshot({driver, stabilization = {}, debug, logger}) {
  return async function takeScreenshot({name} = {}) {
    logger.verbose('Taking native driver screenshot...')
    const image = makeImage(stabilization.crop ? await driver.takeScreenshot() : await takeViewportScreenshot())
    await image.debug({...debug, name, suffix: 'original'})

    if (stabilization.scale) image.scale(stabilization.scale)
    else image.scale(1 / driver.pixelRatio)

    if (stabilization.rotate) image.rotate(stabilization.rotate)

    if (stabilization.crop) image.crop(stabilization.crop)

    return image
  }

  async function takeViewportScreenshot() {
    const base64 = await driver.execute('mobile:viewportScreenshot')
    // trimming line breaks since 3rd party grid providers can return them
    return base64.replace(/\r\n/g, '')
  }
}

function makeCalculateScaleRatio({driver}) {
  let viewportWidth, contentWidth
  const VIEWPORT_THRESHOLD = 1
  const CONTENT_THRESHOLD = 10
  return async function calculateScaleRatio(imageWidth) {
    if (!viewportWidth) viewportWidth = await driver.getViewportSize().then(size => size.width)
    if (!contentWidth) contentWidth = await driver.mainContext.getContentSize().then(size => size.width)
    // If the image's width is the same as the viewport's width or the
    // top level context's width, no scaling is necessary.
    if (
      (imageWidth >= viewportWidth - VIEWPORT_THRESHOLD && imageWidth <= viewportWidth + VIEWPORT_THRESHOLD) ||
      (imageWidth >= contentWidth - CONTENT_THRESHOLD && imageWidth <= contentWidth + CONTENT_THRESHOLD)
    ) {
      return 1
    }

    const scaledImageWidth = Math.round(imageWidth / driver.pixelRatio)
    return viewportWidth / scaledImageWidth / driver.pixelRatio
  }
}

module.exports = makeTakeScreenshot


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/take-stitched-screenshot.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/take-stitched-screenshot.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const makeImage = __webpack_require__(/*! ./image */ "./node_modules/@applitools/screenshoter/src/image.js")
const makeTakeScreenshot = __webpack_require__(/*! ./take-screenshot */ "./node_modules/@applitools/screenshoter/src/take-screenshot.js")

async function takeStitchedScreenshot({
  logger,
  context,
  scroller,
  region,
  overlap = 50,
  framed,
  wait,
  stabilization,
  debug,
}) {
  logger.verbose('Taking full image of...')

  const driver = context.driver
  const takeScreenshot = makeTakeScreenshot({logger, driver, stabilization, debug})
  const scrollerState = await scroller.preserveState()

  const initialOffset = region ? utils.geometry.location(region) : {x: 0, y: 0}
  const actualOffset = await scroller.moveTo(initialOffset)
  const expectedRemainingOffset = utils.geometry.offsetNegative(initialOffset, actualOffset)

  await utils.general.sleep(wait)

  logger.verbose('Getting initial image...')
  let image = await takeScreenshot({name: 'initial'})
  const firstImage = framed ? makeImage(image) : null

  const targetRegion = region
    ? utils.geometry.intersect(
        utils.geometry.region(await scroller.getInnerOffset(), await scroller.getClientRegion()),
        region,
      )
    : await scroller.getClientRegion()

  // TODO the solution should not check driver specifics,
  // in this case target region coordinate should be already related to the scrolling element of the context
  const cropRegion = driver.isNative ? targetRegion : await driver.getRegionInViewport(context, targetRegion)

  logger.verbose('cropping...')
  image.crop(cropRegion)
  await image.debug({...debug, name: 'initial', suffix: 'region'})

  const contentRegion = utils.geometry.region({x: 0, y: 0}, await scroller.getContentSize())
  logger.verbose(`Scroller size: ${contentRegion}`)

  if (region) region = utils.geometry.intersect(region, contentRegion)
  else region = contentRegion

  region = utils.geometry.round(region)

  // TODO padding should be provided from args instead of overlap
  const padding = {top: overlap, bottom: overlap}
  const [initialRegion, ...partRegions] = utils.geometry.divide(region, image.size, padding)
  logger.verbose('Part regions', partRegions)

  logger.verbose('Creating stitched image composition container')
  const stitchedImage = makeImage({width: region.width, height: region.height})

  logger.verbose('Adding initial image...')
  await stitchedImage.copy(image, {x: 0, y: 0})

  logger.verbose('Getting the rest of the image parts...')

  let stitchedSize = {width: image.width, height: image.height}
  let lastImage
  for (const partRegion of partRegions) {
    const partName = `${partRegion.x}_${partRegion.y}_${partRegion.width}x${partRegion.height}`
    logger.verbose(`Processing part ${partName}`)

    const compensateOffset = {x: 0, y: initialRegion.y !== partRegion.y ? padding.top : 0}
    const requiredOffset = utils.geometry.offsetNegative(utils.geometry.location(partRegion), compensateOffset)

    logger.verbose(`Move to ${requiredOffset}`)
    const actualOffset = await scroller.moveTo(requiredOffset)
    const remainingOffset = utils.geometry.offset(
      utils.geometry.offsetNegative(
        utils.geometry.offsetNegative(requiredOffset, actualOffset),
        expectedRemainingOffset,
      ),
      compensateOffset,
    )
    const cropPartRegion = {
      x: cropRegion.x + remainingOffset.x,
      y: cropRegion.y + remainingOffset.y,
      width: partRegion.width,
      height: partRegion.height,
    }
    logger.verbose(`Actual offset is ${actualOffset}, remaining offset is ${remainingOffset}`)

    await utils.general.sleep(wait)

    if (utils.geometry.isEmpty(cropPartRegion) || !utils.geometry.isIntersected(cropRegion, cropPartRegion)) continue

    logger.verbose('Getting image...')
    image = await takeScreenshot({name: partName})
    lastImage = framed ? makeImage(image) : null

    logger.verbose('cropping...')
    image.crop(cropPartRegion)
    await image.debug({...debug, name: partName, suffix: 'region'})

    const pasteOffset = utils.geometry.offsetNegative(utils.geometry.location(partRegion), initialOffset)
    await stitchedImage.copy(image, pasteOffset)

    stitchedSize = {width: pasteOffset.x + image.width, height: pasteOffset.y + image.height}
  }

  await scroller.restoreState(scrollerState)

  logger.verbose(`Extracted entire size: ${region}`)
  logger.verbose(`Actual stitched size: ${stitchedSize}`)

  if (stitchedSize.width < stitchedImage.width || stitchedSize.height < stitchedImage.height) {
    logger.verbose('Trimming unnecessary margins...')
    stitchedImage.crop(utils.geometry.region({x: 0, y: 0}, stitchedSize))
  }

  await stitchedImage.debug({...debug, name: 'stitched'})

  if (framed) {
    await stitchedImage.combine(firstImage, lastImage, cropRegion)
    await stitchedImage.debug({...debug, name: 'framed'})

    return {
      image: stitchedImage,
      region: utils.geometry.region({x: 0, y: 0}, stitchedImage.size),
    }
  } else {
    return {
      image: stitchedImage,
      region: utils.geometry.region(cropRegion, stitchedImage.size),
    }
  }
}

module.exports = takeStitchedScreenshot


/***/ }),

/***/ "./node_modules/@applitools/screenshoter/src/take-viewport-screenshot.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/screenshoter/src/take-viewport-screenshot.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const utils = __webpack_require__(/*! @applitools/utils */ "./node_modules/@applitools/utils/dist/index.js")
const makeTakeScreenshot = __webpack_require__(/*! ./take-screenshot */ "./node_modules/@applitools/screenshoter/src/take-screenshot.js")

async function takeViewportScreenshot({logger, context, region, wait, stabilization, debug = {}}) {
  logger.verbose('Taking image of...')

  const driver = context.driver
  const takeScreenshot = makeTakeScreenshot({logger, driver, stabilization, debug})

  await utils.general.sleep(wait)

  const image = await takeScreenshot()

  if (region) {
    const cropRegion = await driver.getRegionInViewport(context, region)
    if (utils.geometry.isEmpty(cropRegion)) throw new Error('Screenshot region is out of viewport')
    await image.crop(cropRegion)
    await image.debug({path: debug.path, suffix: 'region'})
    return {image, region: cropRegion}
  } else {
    return {image, region: utils.geometry.region({x: 0, y: 0}, image.size)}
  }
}

module.exports = takeViewportScreenshot


/***/ }),

/***/ "./node_modules/@applitools/snippets/dist/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/@applitools/snippets/dist/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.addPageMarker=function(arg){
var s=function(){"use strict";var t=function(t){var e=void 0===t?[]:t,r=e[0],o=e[1],n=Object.keys(o).sort(),i=n.reduce((function(t,e){return t[e]={value:r.style.getPropertyValue(e),important:Boolean(r.style.getPropertyPriority(e))},t}),{});return n.forEach((function(t){r.style.setProperty(t,"string"!=typeof o[t]&&o[t]?o[t].value:o[t],o[t]&&o[t].important?"important":"")})),i};return function(){var e=document.createElement("div"),r=document.createElement("div");e.appendChild(r),document.body.appendChild(e),e.setAttribute("data-applitools-marker",""),e.style.setProperty("position","fixed","important"),e.style.setProperty("top","0","important"),e.style.setProperty("left","0","important"),e.style.setProperty("width","3px","important"),e.style.setProperty("height","9px","important"),e.style.setProperty("box-sizing","content-box","important"),e.style.setProperty("border","1px solid rgb(127,127,127)","important"),e.style.setProperty("background","rgb(0,0,0)","important"),e.style.setProperty("z-index","999999999","important"),r.style.setProperty("width","3px","important"),r.style.setProperty("height","3px","important"),r.style.setProperty("margin","3px 0","important"),r.style.setProperty("background","rgb(255,255,255)","important");var o={value:"none",important:!0},n=t([document.documentElement,{transform:o,"-webkit-transform":o}]),i=t([document.body,{transform:o,"-webkit-transform":o}]);return document.documentElement.setAttribute("data-applitools-original-transforms",JSON.stringify(n)),document.body.setAttribute("data-applitools-original-transforms",JSON.stringify(i)),{offset:1*window.devicePixelRatio,size:3*window.devicePixelRatio,mask:[0,1,0]}}}();
return s(arg)
}
exports.blurElement=function(arg){
var s=function(){"use strict";return function(t){var n=(void 0===t?[]:t)[0]||document.activeElement;return n&&n.blur(),n}}();
return s(arg)
}
exports.cleanupElementMarkers=function(arg){
var s=function(){"use strict";return function(t){t[0].forEach((function(t){return t.removeAttribute("data-applitools-marker")}))}}();
return s(arg)
}
exports.cleanupPageMarker=function(arg){
var s=function(){"use strict";var t=function(t){var e=void 0===t?[]:t,r=e[0],o=e[1],n=Object.keys(o).sort(),a=n.reduce((function(t,e){return t[e]={value:r.style.getPropertyValue(e),important:Boolean(r.style.getPropertyPriority(e))},t}),{});return n.forEach((function(t){r.style.setProperty(t,"string"!=typeof o[t]&&o[t]?o[t].value:o[t],o[t]&&o[t].important?"important":"")})),a};return function(){var e=document.querySelector("[data-applitools-marker]");e&&document.body.removeChild(e);var r=document.documentElement.getAttribute("data-applitools-original-transforms"),o=document.body.getAttribute("data-applitools-original-transforms");r&&t([document.documentElement,JSON.parse(r)]),o&&t([document.body,JSON.parse(o)])}}();
return s(arg)
}
exports.focusElement=function(arg){
var s=function(){"use strict";return function(n){var r=(void 0===n?[]:n)[0];r&&r.focus()}}();
return s(arg)
}
exports.getChildFramesInfo=function(arg){
var s=function(){"use strict";return function(){var r=document.querySelectorAll("frame, iframe");return Array.prototype.map.call(r,(function(r){return[r,!r.contentDocument,r.src]}))}}();
return s(arg)
}
exports.getContextInfo=function(arg){
var s=function(){"use strict";var t=function(t){var n=(void 0===t?[]:t)[0],e="",r=n.ownerDocument;if(!r)return e;for(var o=n;o!==r;){var a=Array.prototype.filter.call(o.parentNode.childNodes,(function(t){return t.tagName===o.tagName})).indexOf(o);e="/"+o.tagName+"["+(a+1)+"]"+e,o=o.parentNode}return e};return function(){var n,e,r;try{n=window.top.document===window.document}catch(t){n=!1}try{e=!window.parent.document===window.document}catch(t){e=!0}if(!e)try{r=t([window.frameElement])}catch(t){r=null}return[document.documentElement,r,n,e]}}();
return s(arg)
}
exports.getDocumentSize=function(arg){
var s=function(){"use strict";return function(){var t=document.documentElement.scrollWidth,e=document.documentElement.scrollHeight,n=document.documentElement.clientHeight,c=document.body.scrollWidth,o=document.body.scrollHeight,d=document.body.clientHeight;return{width:Math.max(t,c),height:Math.max(n,e,d,o)}}}();
return s(arg)
}
exports.getElementComputedStyleProperties=function(arg){
var s=function(){"use strict";return function(t){var r=void 0===t?[]:t,e=r[0],n=r[1],u=void 0===n?[]:n,o=window.getComputedStyle(e);return o?u.map((function(t){return o.getPropertyValue(t)})):[]}}();
return s(arg)
}
exports.getElementContentSize=function(arg){
var s=function(){"use strict";var t=function(t){var r=void 0===t?[]:t,e=r[0],n=r[1],o=Object.keys(n).sort(),i=o.reduce((function(t,r){return t[r]={value:e.style.getPropertyValue(r),important:Boolean(e.style.getPropertyPriority(r))},t}),{});return o.forEach((function(t){e.style.setProperty(t,"string"!=typeof n[t]&&n[t]?n[t].value:n[t],n[t]&&n[t].important?"important":"")})),i};return function(r){var e,n=(void 0===r?[]:r)[0];n===document.documentElement&&(e=t([n,{transform:"none"}]));var o={width:n.scrollWidth,height:n.scrollHeight};return e&&t([n,e]),o}}();
return s(arg)
}
exports.getElementFixedAncestor=function(arg){
var s=function(){"use strict";return function(t){for(var e=(void 0===t?[]:t)[0];e.offsetParent&&e.offsetParent!==document.body&&e.offsetParent!==document.documentElement;)e=e.offsetParent;return"fixed"===window.getComputedStyle(e).getPropertyValue("position")?e:null}}();
return s(arg)
}
exports.getElementInnerOffset=function(arg){
var s=function(){"use strict";var r=function(r){var t=(void 0===r?[]:r)[0];return t?{x:t.scrollLeft,y:t.scrollTop}:{x:window.scrollX||window.pageXOffset,y:window.scrollY||window.pageYOffset}};var t=function(r){var t=void 0===r?[]:r,e=t[0],o=t[1];return(void 0===o?[]:o).reduce((function(r,t){return r[t]={value:e.style.getPropertyValue(t),important:Boolean(e.style.getPropertyPriority(t))},r}),{})};var e=function(r){var e=(void 0===r?[]:r)[0],o=void 0===e?document.scrollingElement||document.documentElement:e,n=t([o,["transform","-webkit-transform"]]),i=Object.keys(n).reduce((function(r,t){var e=n[t].value;if(e){var o=e.match(/^translate\s*\(\s*(\-?[\d, \.]+)px\s*(,\s*(-?[\d, \.]+)px)?\s*\)/);if(o){var i=o[1],s=void 0!==o[3]?o[3]:0;r.push({x:Math.round(-parseFloat(i)),y:Math.round(-parseFloat(s))})}else r.push({x:0,y:0})}return r}),[]);if(!i.every((function(r){return i[0].x===r.x||i[0].y===r.y})))throw new Error("Got different css positions!");return i[0]||{x:0,y:0}};return function(t){var o=(void 0===t?[]:t)[0],n=r([o]),i=e([o]);return{x:n.x+i.x,y:n.y+i.y}}}();
return s(arg)
}
exports.getElementProperties=function(arg){
var s=function(){"use strict";return function(r){var n=void 0===r?[]:r,t=n[0],u=n[1];return(void 0===u?[]:u).reduce((function(r,n){return r[n]=t[n],r}),{})}}();
return s(arg)
}
exports.getElementRect=function(arg){
var s=function(){"use strict";var t=function(t){for(var e=(void 0===t?[]:t)[0];e.offsetParent&&e.offsetParent!==document.body&&e.offsetParent!==document.documentElement;)e=e.offsetParent;return"fixed"===window.getComputedStyle(e).getPropertyValue("position")?e:null};var e=function(t){var e=(void 0===t?[]:t)[0];return e?{x:e.scrollLeft,y:e.scrollTop}:{x:window.scrollX||window.pageXOffset,y:window.scrollY||window.pageYOffset}};var r=function(t){var e=void 0===t?[]:t,r=e[0],o=e[1];return(void 0===o?[]:o).reduce((function(t,e){return t[e]={value:r.style.getPropertyValue(e),important:Boolean(r.style.getPropertyPriority(e))},t}),{})};var o=function(t){var e=(void 0===t?[]:t)[0],o=void 0===e?document.scrollingElement||document.documentElement:e,n=r([o,["transform","-webkit-transform"]]),i=Object.keys(n).reduce((function(t,e){var r=n[e].value;if(r){var o=r.match(/^translate\s*\(\s*(\-?[\d, \.]+)px\s*(,\s*(-?[\d, \.]+)px)?\s*\)/);if(o){var i=o[1],a=void 0!==o[3]?o[3]:0;t.push({x:Math.round(-parseFloat(i)),y:Math.round(-parseFloat(a))})}else t.push({x:0,y:0})}return t}),[]);if(!i.every((function(t){return i[0].x===t.x||i[0].y===t.y})))throw new Error("Got different css positions!");return i[0]||{x:0,y:0}};var n=function(t){var r=(void 0===t?[]:t)[0],n=e([r]),i=o([r]);return{x:n.x+i.x,y:n.y+i.y}};return function(e){var r=void 0===e?[]:e,o=r[0],i=r[1],a=void 0!==i&&i,u=o.getBoundingClientRect(),d={x:u.left,y:u.top,width:u.width,height:u.height};if(a){var s=window.getComputedStyle(o);d.x+=parseInt(s.getPropertyValue("border-left-width")),d.y+=parseInt(s.getPropertyValue("border-top-width")),d.width=o.clientWidth,d.height=o.clientHeight}var f=t([o]);if(f){if(f!==o){var l=n([f]);d.x+=l.x,d.y+=l.y}}else{var v=n();d.x+=v.x,d.y+=v.y}return d}}();
return s(arg)
}
exports.getElementScrollOffset=function(arg){
var s=function(){"use strict";return function(o){var r=(void 0===o?[]:o)[0];return r?{x:r.scrollLeft,y:r.scrollTop}:{x:window.scrollX||window.pageXOffset,y:window.scrollY||window.pageYOffset}}}();
return s(arg)
}
exports.getElementStyleProperties=function(arg){
var s=function(){"use strict";return function(r){var t=void 0===r?[]:r,e=t[0],n=t[1];return(void 0===n?[]:n).reduce((function(r,t){return r[t]={value:e.style.getPropertyValue(t),important:Boolean(e.style.getPropertyPriority(t))},r}),{})}}();
return s(arg)
}
exports.getElementTranslateOffset=function(arg){
var s=function(){"use strict";var r=function(r){var t=void 0===r?[]:r,e=t[0],n=t[1];return(void 0===n?[]:n).reduce((function(r,t){return r[t]={value:e.style.getPropertyValue(t),important:Boolean(e.style.getPropertyPriority(t))},r}),{})};return function(t){var e=(void 0===t?[]:t)[0],n=void 0===e?document.scrollingElement||document.documentElement:e,o=r([n,["transform","-webkit-transform"]]),u=Object.keys(o).reduce((function(r,t){var e=o[t].value;if(e){var n=e.match(/^translate\s*\(\s*(\-?[\d, \.]+)px\s*(,\s*(-?[\d, \.]+)px)?\s*\)/);if(n){var u=n[1],s=void 0!==n[3]?n[3]:0;r.push({x:Math.round(-parseFloat(u)),y:Math.round(-parseFloat(s))})}else r.push({x:0,y:0})}return r}),[]);if(!u.every((function(r){return u[0].x===r.x||u[0].y===r.y})))throw new Error("Got different css positions!");return u[0]||{x:0,y:0}}}();
return s(arg)
}
exports.getElementXpath=function(arg){
var s=function(){"use strict";return function(r){var e=(void 0===r?[]:r)[0],t="",n=e.ownerDocument;if(!n)return t;for(var a=e;a!==n;){var o=Array.prototype.filter.call(a.parentNode.childNodes,(function(r){return r.tagName===a.tagName})).indexOf(a);t="/"+a.tagName+"["+(o+1)+"]"+t,a=a.parentNode}return t}}();
return s(arg)
}
exports.getPixelRatio=function(arg){
var s=function(){"use strict";return function(){return window.devicePixelRatio}}();
return s(arg)
}
exports.getUserAgent=function(arg){
var s=function(){"use strict";return function(){return window.navigator.userAgent}}();
return s(arg)
}
exports.getViewportSize=function(arg){
var s=function(){"use strict";return function(){var e=0,t=0;return window.innerHeight?t=window.innerHeight:document.documentElement&&document.documentElement.clientHeight?t=document.documentElement.clientHeight:document.body&&document.body.clientHeight&&(t=document.body.clientHeight),window.innerWidth?e=window.innerWidth:document.documentElement&&document.documentElement.clientWidth?e=document.documentElement.clientWidth:document.body&&document.body.clientWidth&&(e=document.body.clientWidth),{width:e,height:t}}}();
return s(arg)
}
exports.isElementScrollable=function(arg){
var s=function(){"use strict";return function(t){var i=(void 0===t?[]:t)[0];return i.scrollWidth>i.clientWidth||i.scrollHeight>i.clientHeight}}();
return s(arg)
}
exports.isEqualElements=function(arg){
var s=function(){"use strict";return function(r){var n=void 0===r?[]:r;return n[0]===n[1]}}();
return s(arg)
}
exports.scrollTo=function(arg){
var s=function(){"use strict";return function(o){var l=void 0===o?[]:o,r=l[0],c=l[1];return(r=r||document.documentElement).scrollTo?r.scrollTo(c.x,c.y):(r.scrollLeft=c.x,r.scrollTop=c.y),{x:r.scrollLeft,y:r.scrollTop}}}();
return s(arg)
}
exports.setElementAttributes=function(arg){
var s=function(){"use strict";return function(t){var e=void 0===t?[]:t,r=e[0],u=e[1];return Object.keys(u).reduce((function(t,e){return t[e]=r.getAttribute(e),r.setAttribute(e,u[e]),t}),{})}}();
return s(arg)
}
exports.setElementMarkers=function(arg){
var s=function(){"use strict";return function(t){var r=t[0],a=t[1];r.forEach((function(t,r){var e=t.getAttribute("data-applitools-marker");t.setAttribute("data-applitools-marker",e?e+" "+a[r]:a[r])}))}}();
return s(arg)
}
exports.setElementStyleProperties=function(arg){
var s=function(){"use strict";return function(t){var r=void 0===t?[]:t,e=r[0],o=r[1],n=Object.keys(o).sort(),i=n.reduce((function(t,r){return t[r]={value:e.style.getPropertyValue(r),important:Boolean(e.style.getPropertyPriority(r))},t}),{});return n.forEach((function(t){e.style.setProperty(t,"string"!=typeof o[t]&&o[t]?o[t].value:o[t],o[t]&&o[t].important?"important":"")})),i}}();
return s(arg)
}
exports.translateTo=function(arg){
var s=function(){"use strict";var t=function(t){var r=void 0===t?[]:t,e=r[0],n=r[1],o=Object.keys(n).sort(),a=o.reduce((function(t,r){return t[r]={value:e.style.getPropertyValue(r),important:Boolean(e.style.getPropertyPriority(r))},t}),{});return o.forEach((function(t){e.style.setProperty(t,"string"!=typeof n[t]&&n[t]?n[t].value:n[t],n[t]&&n[t].important?"important":"")})),a};return function(r){var e=void 0===r?[]:r,n=e[0],o=e[1];n=n||document.documentElement;var a="translate("+-o.x+"px, "+-o.y+"px)";return t([n,{transform:{value:a},"-webkit-transform":{value:a}}]),o}}();
return s(arg)
}

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/index.js":
/*!******************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/index.js ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.process = exports.geometry = exports.general = exports.guard = exports.types = void 0;
__exportStar(__webpack_require__(/*! ./src/utility-types */ "./node_modules/@applitools/utils/dist/src/utility-types.js"), exports);
exports.types = __webpack_require__(/*! ./src/types */ "./node_modules/@applitools/utils/dist/src/types.js");
exports.guard = __webpack_require__(/*! ./src/guard */ "./node_modules/@applitools/utils/dist/src/guard.js");
exports.general = __webpack_require__(/*! ./src/general */ "./node_modules/@applitools/utils/dist/src/general.js");
exports.geometry = __webpack_require__(/*! ./src/geometry */ "./node_modules/@applitools/utils/dist/src/geometry.js");
exports.process = __webpack_require__(/*! ./src/process */ "./node_modules/@applitools/utils/dist/src/process.js");
//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/general.js":
/*!************************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/general.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.toString = exports.toJSON = exports.sleep = exports.jwtDecode = exports.guid = exports.getEnvValue = void 0;
const types = __webpack_require__(/*! ./types */ "./node_modules/@applitools/utils/dist/src/types.js");
function getEnvValue(name, type) {
    if (!process)
        return;
    const value = process.env[`APPLITOOLS_${name}`];
    if (value === undefined || value === 'null')
        return;
    if (type === 'boolean' && types.isBoolean(value))
        return (value === 'true');
    if (type === 'number')
        return Number(value);
    return value;
}
exports.getEnvValue = getEnvValue;
function guid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, c => {
        const r = (Math.random() * 16) | 0;
        const v = c === 'x' ? r : (r & 0x3) | 0x8;
        return v.toString(16);
    });
}
exports.guid = guid;
function jwtDecode(token) {
    let payloadSeg = token.split('.')[1];
    payloadSeg += new Array(5 - (payloadSeg.length % 4)).join('=');
    payloadSeg = payloadSeg.replace(/-/g, '+').replace(/_/g, '/');
    return JSON.parse(Buffer.from(payloadSeg, 'base64').toString());
}
exports.jwtDecode = jwtDecode;
function sleep(ms) {
    if (types.isNumber(ms)) {
        return new Promise(resolve => setTimeout(resolve, ms));
    }
}
exports.sleep = sleep;
function toJSON(object, props) {
    if (!types.isObject(object))
        return null;
    const original = props ? Object.values(props) : Object.keys(object);
    const keys = !props || types.isArray(props) ? original : Object.keys(props);
    return keys.reduce((plain, key, index) => {
        const value = object[original[index]];
        plain[key] = value && types.isFunction(value.toJSON) ? value.toJSON() : value;
        return plain;
    }, {});
}
exports.toJSON = toJSON;
function toString(object) {
    return `${this.constructor.name} ${JSON.stringify(object, null, 2)}`;
}
exports.toString = toString;
//# sourceMappingURL=general.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/geometry.js":
/*!*************************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/geometry.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.divide = exports.equals = exports.contains = exports.isIntersected = exports.subtraction = exports.intersect = exports.offsetNegative = exports.offset = exports.scale = exports.rotate = exports.round = exports.isEmpty = exports.region = exports.size = exports.location = void 0;
const types = __webpack_require__(/*! ./types */ "./node_modules/@applitools/utils/dist/src/types.js");
const guard = __webpack_require__(/*! ./guard */ "./node_modules/@applitools/utils/dist/src/guard.js");
function location(region) {
    return { x: region.x, y: region.y };
}
exports.location = location;
function size(region) {
    return { width: region.width, height: region.height };
}
exports.size = size;
function region(location, size) {
    if (!location)
        location = { x: 0, y: 0 };
    return { x: location.x, y: location.y, width: size.width, height: size.height };
}
exports.region = region;
function isEmpty(sizeOrRegion) {
    return sizeOrRegion.width === 0 && sizeOrRegion.height === 0;
}
exports.isEmpty = isEmpty;
function round(target) {
    const result = Object.assign({}, target);
    if (types.has(target, ['x', 'y'])) {
        result.x = Math.round(target.x);
        result.y = Math.round(target.y);
    }
    if (types.has(target, ['width', 'height'])) {
        result.width = Math.round(target.width);
        result.height = Math.round(target.height);
    }
    return result;
}
exports.round = round;
function rotate(target, degree) {
    const result = Object.assign({}, target);
    const rotate = Boolean(Math.floor(degree / 90) % 2);
    if (rotate) {
        result.width = target.height;
        result.height = target.width;
    }
    return result;
}
exports.rotate = rotate;
function scale(target, scaleRatio) {
    const result = Object.assign({}, target);
    if (types.has(target, ['x', 'y'])) {
        result.x = target.x * scaleRatio;
        result.y = target.y * scaleRatio;
    }
    if (types.has(target, ['width', 'height'])) {
        result.width = target.width * scaleRatio;
        result.height = target.height * scaleRatio;
    }
    return result;
}
exports.scale = scale;
function offset(target, offset) {
    const result = Object.assign({}, target);
    result.x += offset.x;
    result.y += offset.y;
    return result;
}
exports.offset = offset;
function offsetNegative(target, offset) {
    const result = Object.assign({}, target);
    result.x -= offset.x;
    result.y -= offset.y;
    return result;
}
exports.offsetNegative = offsetNegative;
function intersect(region1, region2) {
    if (!isIntersected(region1, region2))
        return { x: 0, y: 0, width: 0, height: 0 };
    const result = {};
    result.x = Math.max(region1.x, region2.x);
    result.y = Math.max(region1.y, region2.y);
    result.width = Math.min(region1.x + region1.width, region2.x + region2.width) - result.x;
    result.height = Math.min(region1.y + region1.height, region2.y + region2.height) - result.y;
    return result;
}
exports.intersect = intersect;
function subtraction(region1, region2) {
    if (!isIntersected(region1, region2))
        return { x: 0, y: 0, width: 0, height: 0 };
    const result = {};
    result.x = Math.max(region1.x - region2.x, 0);
    result.y = Math.max(region1.y - region2.y, 0);
    result.width = Math.min(region1.x + region1.width, region2.x + region2.width) - (result.x + region2.x);
    result.height = Math.min(region1.y + region1.height, region2.y + region2.height) - (result.y + region2.y);
    return result;
}
exports.subtraction = subtraction;
function isIntersected(region1, region2) {
    return (((region1.x <= region2.x && region2.x <= region1.x + region1.width) ||
        (region2.x <= region1.x && region1.x <= region2.y + region2.width)) &&
        ((region1.y <= region2.y && region2.y <= region1.y + region1.height) ||
            (region2.y <= region1.y && region1.y <= region2.y + region2.height)));
}
exports.isIntersected = isIntersected;
function contains(region, locationOrRegion) {
    if (region.x <= locationOrRegion.x && region.y <= locationOrRegion.y) {
        if (types.has(locationOrRegion, ['width', 'height'])) {
            return (region.x + region.width >= locationOrRegion.x + locationOrRegion.width &&
                region.y + region.height >= locationOrRegion.y + locationOrRegion.height);
        }
        return true;
    }
    return false;
}
exports.contains = contains;
function equals(locationOrSizeOrRegion1, locationOrSizeOrRegion2) {
    if (types.has(locationOrSizeOrRegion1, ['x', 'y', 'width', 'height'])) {
        if (types.has(locationOrSizeOrRegion2, ['x', 'y', 'width', 'height'])) {
            return (locationOrSizeOrRegion1.x === locationOrSizeOrRegion2.x &&
                locationOrSizeOrRegion1.y === locationOrSizeOrRegion2.y &&
                locationOrSizeOrRegion1.width === locationOrSizeOrRegion2.width &&
                locationOrSizeOrRegion1.height === locationOrSizeOrRegion2.height);
        }
        return false;
    }
    if (types.has(locationOrSizeOrRegion1, ['x', 'y'])) {
        if (types.has(locationOrSizeOrRegion2, ['x', 'y'])) {
            return (locationOrSizeOrRegion1.x === locationOrSizeOrRegion2.x &&
                locationOrSizeOrRegion1.y === locationOrSizeOrRegion2.y);
        }
        return false;
    }
    if (types.has(locationOrSizeOrRegion1, ['width', 'height'])) {
        if (types.has(locationOrSizeOrRegion2, ['width', 'height'])) {
            return (locationOrSizeOrRegion1.width === locationOrSizeOrRegion2.width &&
                locationOrSizeOrRegion1.height === locationOrSizeOrRegion2.height);
        }
        return false;
    }
}
exports.equals = equals;
function divide(region, size, padding = {}) {
    var _a, _b;
    guard.notNull(region, { name: 'region' });
    guard.notNull(size, { name: 'size' });
    guard.isNumber(size.width, { name: 'size.width', gt: 0 });
    guard.isNumber(size.height, { name: 'size.height', gt: 0 });
    (_a = padding.top) !== null && _a !== void 0 ? _a : (padding.top = 0);
    (_b = padding.bottom) !== null && _b !== void 0 ? _b : (padding.bottom = 0);
    const subRegions = [];
    const maxX = region.x + region.width;
    const maxY = region.y + region.height;
    const stepX = size.width;
    const stepY = padding.top + padding.bottom < size.height ? size.height - (padding.top + padding.bottom) : size.height;
    let currentY = region.y;
    while (currentY < maxY) {
        let nextY = Math.min(currentY + stepY, maxY);
        // first region
        if (currentY === region.y)
            nextY += padding.top;
        // last region
        else if (nextY < maxY && nextY + padding.top >= maxY)
            nextY = maxY;
        const currentHeight = nextY - currentY;
        let currentX = region.x;
        while (currentX < maxX) {
            const nextX = Math.min(currentX + stepX, maxX);
            const currentWidth = nextX - currentX;
            subRegions.push({ x: currentX, y: currentY, width: currentWidth, height: currentHeight });
            currentX = nextX;
        }
        currentY = nextY;
    }
    return subRegions;
}
exports.divide = divide;
//# sourceMappingURL=geometry.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/guard.js":
/*!**********************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/guard.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.custom = exports.instanceOf = exports.isOneOf = exports.isEnumValue = exports.isObject = exports.isArray = exports.isNumeric = exports.isAlpha = exports.isAlphanumeric = exports.isString = exports.isGreaterThenOrEqual = exports.isGreaterThen = exports.isLessThenOrEqual = exports.isLessThen = exports.isInteger = exports.isNumber = exports.isBoolean = exports.notNull = void 0;
const types = __webpack_require__(/*! ./types */ "./node_modules/@applitools/utils/dist/src/types.js");
function notNull(value, { name }) {
    if (types.isNull(value)) {
        throw new Error(`IllegalArgument: ${name} is not allowed to be null or undefined`);
    }
}
exports.notNull = notNull;
function isBoolean(value, { name, strict = true }) {
    if ((strict || !types.isNull(value)) && !types.isBoolean(value)) {
        throw new Error(`IllegalType: ${name} must be of type boolean. Received ${value}`);
    }
}
exports.isBoolean = isBoolean;
function isNumber(value, { name, strict = true, lt, lte, gt, gte }) {
    if ((strict || !types.isNull(value)) && !types.isNumber(value)) {
        throw new Error(`IllegalArgument: ${name} must be of type number. Received ${value}`);
    }
    if (!types.isNull(lt))
        isLessThen(value, lt, { name });
    else if (!types.isNull(lte))
        isLessThenOrEqual(value, lte, { name });
    else if (!types.isNull(gt))
        isGreaterThen(value, gt, { name });
    else if (!types.isNull(gte))
        isGreaterThenOrEqual(value, gte, { name });
}
exports.isNumber = isNumber;
function isInteger(value, { name, strict = true, lt, lte, gt, gte }) {
    if ((strict || !types.isNull(value)) && !types.isInteger(value)) {
        throw new Error(`IllegalArgument: ${name} must be an integer of type number. Received ${value}`);
    }
    if (!types.isNull(lt))
        isLessThen(value, lt, { name });
    else if (!types.isNull(lte))
        isLessThenOrEqual(value, lte, { name });
    else if (!types.isNull(gt))
        isGreaterThen(value, gt, { name });
    else if (!types.isNull(gte))
        isGreaterThenOrEqual(value, gte, { name });
}
exports.isInteger = isInteger;
function isLessThen(value, limit, { name }) {
    if (!(value < limit)) {
        throw new Error(`IllegalArgument: ${name} must be < ${limit}. Received ${value}`);
    }
}
exports.isLessThen = isLessThen;
function isLessThenOrEqual(value, limit, { name }) {
    if (!(value <= limit)) {
        throw new Error(`IllegalArgument: ${name} must be <= ${limit}. Received ${value}`);
    }
}
exports.isLessThenOrEqual = isLessThenOrEqual;
function isGreaterThen(value, limit, { name }) {
    if (!(value > limit)) {
        throw new Error(`IllegalArgument: ${name} must be > ${limit}. Received ${value}`);
    }
}
exports.isGreaterThen = isGreaterThen;
function isGreaterThenOrEqual(value, limit, { name }) {
    if (!(value >= limit)) {
        throw new Error(`IllegalArgument: ${name} must be >= ${limit}. Received ${value}`);
    }
}
exports.isGreaterThenOrEqual = isGreaterThenOrEqual;
function isString(value, { name, strict = true, alpha, numeric }) {
    if ((strict || !types.isNull(value)) && !types.isString(value)) {
        throw new Error(`IllegalArgument: ${name} must be of type string. Received ${value}`);
    }
    if (alpha && numeric)
        isAlphanumeric(value, { name });
    else if (alpha)
        isAlpha(value, { name });
    else if (numeric)
        isNumeric(value, { name });
}
exports.isString = isString;
function isAlphanumeric(value, { name }) {
    if (!/^[a-z0-9]+$/i.test(value)) {
        throw new Error(`IllegalArgument: ${name} must be an alphanumeric string. Received ${value}`);
    }
}
exports.isAlphanumeric = isAlphanumeric;
function isAlpha(value, { name }) {
    if (!/^[a-z]+$/i.test(value)) {
        throw new Error(`IllegalArgument: ${name} must be an alphabetic string. Received ${value}`);
    }
}
exports.isAlpha = isAlpha;
function isNumeric(value, { name }) {
    if (!/^[0-9]+$/.test(value)) {
        throw new Error(`IllegalArgument: ${name} must be a numeric sring. Received ${value}`);
    }
}
exports.isNumeric = isNumeric;
function isArray(value, { name, strict = true }) {
    if ((strict || !types.isNull(value)) && !types.isArray(value)) {
        throw new Error(`IllegalArgument: ${name} must be of type array. Received ${value}`);
    }
}
exports.isArray = isArray;
function isObject(value, { name, strict = true }) {
    if ((strict || !types.isNull(value)) && !types.isObject(value)) {
        throw new Error(`IllegalArgument: ${name} must be of type object. Received ${value}`);
    }
}
exports.isObject = isObject;
function isEnumValue(value, enumeration, { name, strict = true }) {
    const values = new Set(Object.values(enumeration));
    if ((strict || !types.isNull(value)) && !values.has(value)) {
        const list = Array.from(values, value => JSON.stringify(value)).join(', ');
        throw new Error(`IllegalArgument: ${name} must be one of [${list}]. Received ${value}`);
    }
}
exports.isEnumValue = isEnumValue;
function isOneOf(value, values, { name, strict = true }) {
    if ((strict || !types.isNull(value)) && !values.includes(value)) {
        const list = values.map(value => JSON.stringify(value)).join(', ');
        throw new Error(`IllegalArgument: ${name} must be one of [${list}]. Received ${value}`);
    }
}
exports.isOneOf = isOneOf;
function instanceOf(value, ctor, { name, strict = true }) {
    if ((strict || !types.isNull(value)) && !types.instanceOf(value, ctor)) {
        throw new Error(`IllegalType: ${name} must be an instance of ${ctor.name}`);
    }
}
exports.instanceOf = instanceOf;
function custom(value, check, { name, strict = true, message }) {
    if ((strict || !types.isNull(value)) && !check(value)) {
        throw new Error(`IllegalType: ${name} ${message || 'is wrong type'}`);
    }
}
exports.custom = custom;
//# sourceMappingURL=guard.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/process.js":
/*!************************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/process.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.sh = exports.executeProcess = exports.executeAndControlProcess = void 0;
const child_process_1 = __webpack_require__(/*! child_process */ "?f352");
function makeError(error, properties) {
    if (typeof error === 'string') {
        error = new Error(error);
    }
    if (!properties)
        return error;
    return Object.assign(error, properties);
}
function executeAndControlProcess(command, args = [], options) {
    const subProcess = child_process_1.spawn(command, args, Object.assign({ stdio: 'pipe' }, options === null || options === void 0 ? void 0 : options.spawnOptions));
    const exitPromise = new Promise((resolve, reject) => {
        subProcess.on('error', reject).on('close', (exitCode, signal) => exitCode === 0
            ? resolve({ exitCode, stdout, stderr })
            : signal
                ? reject(makeError(new Error(`process exited due to signal ${signal} executing process ${command} with args ${JSON.stringify(args)}`), {
                    signal,
                    stdout,
                    stderr,
                }))
                : reject(makeError(new Error(`non-zero exit code (${exitCode}) executing process ${command} with args ${JSON.stringify(args)}`), {
                    exitCode,
                    stdout,
                    stderr,
                })));
        let stdout = subProcess.stdout ? '' : undefined;
        let stderr = subProcess.stderr ? '' : undefined;
        subProcess.stdout && subProcess.stdout.on('data', data => (stdout += data.toString()));
        subProcess.stderr && subProcess.stderr.on('data', data => (stderr += data.toString()));
        if (options === null || options === void 0 ? void 0 : options.timeout) {
            setTimeout(() => subProcess.kill(), options.timeout);
        }
        return { stdout, stderr };
    });
    return { subProcess, exitPromise };
}
exports.executeAndControlProcess = executeAndControlProcess;
function executeProcess(command, args = [], options) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield executeAndControlProcess(command, args, options).exitPromise;
    });
}
exports.executeProcess = executeProcess;
function sh(command, options) {
    return __awaiter(this, void 0, void 0, function* () {
        return yield executeProcess('/bin/bash', ['-c', command], Object.assign(Object.assign({}, options), { spawnOptions: Object.assign({ stdio: 'inherit' }, options === null || options === void 0 ? void 0 : options.spawnOptions) }));
    });
}
exports.sh = sh;
//# sourceMappingURL=process.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/types.js":
/*!**********************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/types.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

/* eslint {"@typescript-eslint/ban-types": ["error", {"types": {"Function": false}}]} */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.instanceOf = exports.has = exports.isEnumValue = exports.isFunction = exports.isEmpty = exports.isObject = exports.isArray = exports.isInteger = exports.isNumber = exports.isBase64 = exports.isString = exports.isBoolean = exports.isNull = void 0;
function isNull(value) {
    return value == null;
}
exports.isNull = isNull;
function isBoolean(value) {
    return typeof value === 'boolean' || value instanceof Boolean;
}
exports.isBoolean = isBoolean;
function isString(value) {
    return Object.prototype.toString.call(value) === '[object String]';
}
exports.isString = isString;
function isBase64(value) {
    return isString(value) && /^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$/.test(value);
}
exports.isBase64 = isBase64;
function isNumber(value) {
    return typeof value === 'number' || value instanceof Number;
}
exports.isNumber = isNumber;
function isInteger(value) {
    return isNumber(value) && Number.isInteger(value);
}
exports.isInteger = isInteger;
function isArray(value) {
    return Array.isArray(value);
}
exports.isArray = isArray;
function isObject(value) {
    return typeof value === 'object' && value !== null;
}
exports.isObject = isObject;
function isEmpty(value) {
    if (!value)
        return true;
    if (isObject(value))
        return Object.keys(value).length === 0;
    return value.length === 0;
}
exports.isEmpty = isEmpty;
function isFunction(value, key) {
    if (key && has(value, key))
        return typeof value[key] === 'function';
    return typeof value === 'function';
}
exports.isFunction = isFunction;
function isEnumValue(value, enumeration) {
    const values = new Set(Object.values(enumeration));
    return values.has(value);
}
exports.isEnumValue = isEnumValue;
function has(value, keys) {
    if (!isObject(value))
        return false;
    if (!isArray(keys))
        keys = [keys];
    for (const key of keys) {
        if (!(key in value))
            return false;
    }
    return true;
}
exports.has = has;
function instanceOf(value, ctorOrName) {
    if (!isObject(value))
        return false;
    if (!isString(ctorOrName))
        return value instanceof ctorOrName;
    let proto = Object.getPrototypeOf(value);
    while (proto) {
        if (proto.constructor.name === ctorOrName)
            return true;
        proto = Object.getPrototypeOf(proto);
    }
    return false;
}
exports.instanceOf = instanceOf;
//# sourceMappingURL=types.js.map

/***/ }),

/***/ "./node_modules/@applitools/utils/dist/src/utility-types.js":
/*!******************************************************************!*\
  !*** ./node_modules/@applitools/utils/dist/src/utility-types.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=utility-types.js.map

/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/package.json":
/*!******************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/package.json ***!
  \******************************************************************/
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"name":"@applitools/visual-grid-client","version":"15.8.19","description":"","keywords":["applitools","testing","browser","grid","visual-testing","nodejs","javascript"],"homepage":"https://applitools.com","author":"Amit Zur <amit.zur@applitools.com>","repository":{"type":"git","url":"git://github.com/applitools/eyes.sdk.javascript1.git"},"bugs":{"url":"https://github.com/applitools/eyes.sdk.javascript1/issues"},"directories":{"lib":"./src","test":"./test"},"main":"src/visual-grid-client.js","files":["src","browser.js","index.d.ts"],"dependencies":{"@applitools/eyes-sdk-core":"12.22.5","@applitools/functional-commons":"1.6.0","@applitools/http-commons":"2.4.3","@applitools/isomorphic-fetch":"3.0.0","@applitools/jsdom":"1.0.3","abort-controller":"3.0.0","chalk":"3.0.0","he":"1.2.0","lodash.mapvalues":"4.6.0","mime-types":"2.1.27","mkdirp":"0.5.5","postcss-value-parser":"4.1.0","throat":"5.0.0"},"browser":{"@applitools/jsdom":false},"devDependencies":{"@applitools/dom-snapshot":"4.5.7","@applitools/sdk-release-kit":"0.13.0","@applitools/test-server":"1.0.4","@applitools/test-utils":"1.0.7","chai":"^4.2.0","chai-spies":"^1.0.0","chai-uuid":"^1.0.6","cookie-parser":"^1.4.4","debug":"^4.1.1","eslint":"^7.9.0","eslint-plugin-mocha-no-only":"^1.1.1","eslint-plugin-node":"^11.1.0","eslint-plugin-prettier":"^3.1.4","express":"^4.17.1","husky":"^4.3.8","mocha":"^8.0.1","morgan":"^1.9.1","nock":"^11.3.5","node-fetch":"^2.6.0","null-loader":"^4.0.1","prettier":"1.19.0","puppeteer":"^1.20.0","typescript":"^3.9.2","ua-parser-js":"^0.7.20"},"scripts":{"lint":"eslint . --ext .js","render":"node example/render.js","build:browser":"cd test/fixtures/test-app && yarn install --focused && yarn build","test":"yarn build:browser && yarn test:mocha","test:mocha":"mocha --no-timeouts --parallel --jobs 15 \\"test/**/*.test.js\\"","test:sanity":"mocha --no-timeouts \'test/!(browser||e2e)/**/*.test.js\'","test:unit":"mocha --no-timeouts \\"test/unit/**/*.test.js\\"","test:it":"mocha --no-timeouts \\"test/it/**/*.test.js\\"","test:e2e":"mocha --no-timeouts \\"test/e2e/**/*.test.js\\"","test:browser":"mocha --no-timeouts \'test/browser/**/*.test.js\'","deps":"bongo deps","preversion":"bongo preversion","version":"bongo version","postversion":"bongo postversion --skip-release-notification"},"license":"SEE LICENSE IN LICENSE","engines":{"node":">=8.9.0"},"husky":{"hooks":{"pre-push":"yarn bongo lint"}}}');

/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/EyesWrapper.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/EyesWrapper.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {EyesBase, Location, ImageMatchSettings} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const VERSION = __webpack_require__(/*! ../../package.json */ "./node_modules/@applitools/visual-grid-client/package.json").version

class EyesWrapper extends EyesBase {
  constructor({apiKey, logHandler, getBatchInfoWithCache} = {}) {
    super()
    apiKey && this.setApiKey(apiKey)
    logHandler && this.setLogHandler(logHandler)
    this._getBatchInfoWithCache = getBatchInfoWithCache
  }

  async open({appName, testName, viewportSize, skipStartingSession}) {
    await super.openBase(appName, testName, undefined, undefined, skipStartingSession)

    if (viewportSize) {
      this.setViewportSize(viewportSize)
    }
  }

  async ensureRunningSession() {
    if (!this.getRunningSession()) {
      if (!this._ensureRunningSessionPromise) {
        this._ensureRunningSessionPromise = this._ensureRunningSession()
      }
      const [err] = await presult(this._ensureRunningSessionPromise)
      this._ensureRunningSessionPromise = null
      if (err) {
        this._logger.log(
          'failed to ensure a running session (probably due to a previous fatal error)',
          err,
        )
      }
    }
  }

  async ensureAborted() {
    await this.ensureRunningSession()
    await this.abort()
  }

  async getScreenshot() {
    return
  }

  async getScreenshotUrl() {
    return this.screenshotUrl
  }

  getRenderer() {
    return this._renderer
  }

  getAppEnvironment() {
    return this._eyesEnvironment
  }

  setRenderJobInfo({eyesEnvironment, renderer} = {}) {
    this._eyesEnvironment = eyesEnvironment
    this._renderer = renderer
  }

  async getInferredEnvironment() {
    return this.inferredEnvironment
  }

  async setViewportSize(viewportSize) {
    this._configuration.setViewportSize(viewportSize)
    this._viewportSizeHandler.set(this._configuration.getViewportSize())
  }

  async getTitle() {
    return 'some title' // TODO what should this be? is it connected with the tag in `checkWindow` somehow?
  }

  async getDomUrl() {
    return this.domUrl
  }

  async getImageLocation() {
    return this.imageLocation
  }

  /**
   * Get the AUT session id.
   *
   * @return {Promise<?String>}
   */
  async getAUTSessionId() {
    return // TODO is this good?
  }

  /** @override */
  getBaseAgentId() {
    return this._baseAgentId || `visual-grid-client/${VERSION}`
  }

  setBaseAgentId(baseAgentId) {
    this._baseAgentId = baseAgentId
  }

  setAccessibilityValidation(value) {
    this._configuration.getDefaultMatchSettings().setAccessibilitySettings(value)
  }

  /**
   * Get a RenderingInfo from eyes server
   *
   * @return {Promise<RenderingInfo>}
   */
  getRenderInfo() {
    return this._serverConnector.renderInfo()
  }

  setRenderingInfo(renderingInfo) {
    this._serverConnector.setRenderingInfo(renderingInfo)
  }

  /**
   * Create a screenshot of a page on RenderingGrid server
   *
   * @param {RenderRequest[]} renderRequests - The requests to be sent to the rendering grid
   * @return {Promise<String[]>} - The results of the render
   */
  renderBatch(renderRequests) {
    renderRequests.forEach(rr => rr.setAgentId(this.getBaseAgentId()))
    return this._serverConnector.render(renderRequests)
  }

  checkResources(resources) {
    return this._serverConnector.renderCheckResources(resources)
  }

  getRenderJobInfo(renderRequests) {
    return this._serverConnector.renderGetRenderJobInfo(renderRequests)
  }

  putResource(resource) {
    return this._serverConnector.renderPutResource(resource)
  }

  getRenderStatus(renderId) {
    return this._serverConnector.renderStatusById(renderId)
  }

  getEmulatedDevicesSizes() {
    return this._serverConnector.getEmulatedDevicesSizes()
  }

  getIosDevicesSizes() {
    return this._serverConnector.getIosDevicesSizes()
  }

  logEvents(events) {
    return this._serverConnector.logEvents(events)
  }

  checkWindow({
    screenshotUrl,
    tag,
    domUrl,
    checkSettings,
    imageLocation,
    url,
    closeAfterMatch,
    throwEx,
  }) {
    this.screenshotUrl = screenshotUrl
    this.domUrl = domUrl
    this.imageLocation = imageLocation || Location.ZERO
    this.matchSettings = new ImageMatchSettings({
      ...checkSettings,
      matchLevel:
        checkSettings.matchLevel || this._configuration.getDefaultMatchSettings().getMatchLevel(),
      ignoreCaret:
        checkSettings.ignoreCaret || this._configuration.getDefaultMatchSettings().getIgnoreCaret(),
      useDom: checkSettings.useDom || this._configuration.getDefaultMatchSettings().getUseDom(),
      enablePatterns:
        checkSettings.enablePatterns ||
        this._configuration.getDefaultMatchSettings().getEnablePatterns(),
      ignoreDisplacements:
        checkSettings.ignoreDisplacements ||
        this._configuration.getDefaultMatchSettings().getIgnoreDisplacements(),
      accessibilitySettings: this._configuration
        .getDefaultMatchSettings()
        .getAccessibilitySettings(),
      exact: null,
    })
    return closeAfterMatch
      ? this.checkWindowAndCloseBase({
          name: tag,
          url,
          renderId: checkSettings.renderId,
          variationGroupId: checkSettings.variationGroupId,
          sendDom: checkSettings.sendDom,
          retryTimeout: 0,
          closeAfterMatch,
          throwEx,
        })
      : this.checkWindowBase({
          name: tag,
          url,
          renderId: checkSettings.renderId,
          variationGroupId: checkSettings.variationGroupId,
          sendDom: checkSettings.sendDom,
          retryTimeout: 0,
        })
  }

  getMatchSettings() {
    return this.matchSettings
  }

  setProxy(proxy) {
    if (proxy.uri !== undefined) {
      proxy.url = proxy.uri // backward compatible
    }
    super.setProxy(proxy)
  }

  async getAndSaveRenderingInfo() {
    // Do nothing because visual grid client handles rendering info
  }

  async _getAndSaveBatchInfoFromServer(batchId) {
    return this._getBatchInfoWithCache(batchId)
  }

  async setIgnoreGitMergeBase(input) {
    this._configuration.setIgnoreGitMergeBase(input)
  }

  setAgentRunId(value) {
    this.agentRunId = value
  }
}

module.exports = EyesWrapper


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/absolutizeUrl.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/absolutizeUrl.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")

function absolutizeUrl(url, absoluteUrl) {
  return new URL(url, absoluteUrl).href
}

module.exports = absolutizeUrl


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/calculateSelectorsToFindRegionsFor.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/calculateSelectorsToFindRegionsFor.js ***!
  \***************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {Region} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

function selectorObject({selector, type}) {
  return type === 'xpath' || type === 'css' ? {type, selector} : selector
}

function calculateSelectorsToFindRegionsFor({
  ignore,
  layout,
  strict,
  content,
  accessibility,
  floating,
}) {
  const userRegions = Object.entries({
    ignore,
    layout,
    strict,
    content,
    accessibility,
    floating,
  }).reduce((entries, [name, regions]) => {
    if (regions) {
      entries.set(name, Array.isArray(regions) ? regions : [regions])
    }
    return entries
  }, new Map())

  if (userRegions.size === 0) {
    return {getMatchRegions}
  }

  const selectorsToFindRegionsFor = Array.from(userRegions.values()).reduce((prev, regions) => {
    prev.push(...regions.filter(region => region.selector).map(selectorObject))
    return prev
  }, [])

  // NOTE: in rare cases there might be duplicates here. Intentionally not removing them because later we map `selectorsToFindRegionsFor` to `selectorRegions`.
  return {selectorsToFindRegionsFor, getMatchRegions}

  function getMatchRegions({selectorRegions, imageLocation}) {
    let selectorRegionIndex = 0
    return Array.from(userRegions.entries()).reduce((allRegions, [regionName, userInput]) => {
      const regionValues = userInput.reduce((regions, userRegion) => {
        const codedRegions = userRegion.selector
          ? selectorRegions[selectorRegionIndex++]
          : [userRegion]

        if (codedRegions && codedRegions.length > 0) {
          codedRegions.forEach(region => {
            const regionObject = regionify({region})
            if (imageLocation && userRegion.selector) {
              regionObject.left = Math.max(0, regionObject.left - imageLocation.x)
              regionObject.top = Math.max(0, regionObject.top - imageLocation.y)
            }
            regions.push(regionWithUserInput({regionObject, userRegion, regionName}))
          })
        }

        return regions
      }, [])
      allRegions[regionName] = regionValues
      return allRegions
    }, {})
  }
}

function regionify({region}) {
  const regionInst = new Region(region)
  return {
    width: regionInst.getWidth(),
    height: regionInst.getHeight(),
    left: regionInst.getLeft(),
    top: regionInst.getTop(),
  }
}

function regionWithUserInput({regionObject, userRegion, regionName}) {
  // accesibility regions
  if (regionName === 'accessibility') {
    Object.assign(regionObject, {
      accessibilityType: userRegion.accessibilityType,
    })
  }
  // floating region
  if (regionName === 'floating') {
    Object.assign(regionObject, {
      maxUpOffset: userRegion.maxUpOffset,
      maxDownOffset: userRegion.maxDownOffset,
      maxLeftOffset: userRegion.maxLeftOffset,
      maxRightOffset: userRegion.maxRightOffset,
    })
  }

  return regionObject
}

module.exports = calculateSelectorsToFindRegionsFor


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/checkWindow.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/checkWindow.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const createRenderRequest = __webpack_require__(/*! ./createRenderRequest */ "./node_modules/@applitools/visual-grid-client/src/sdk/createRenderRequest.js")
const isInvalidAccessibility = __webpack_require__(/*! ./isInvalidAccessibility */ "./node_modules/@applitools/visual-grid-client/src/sdk/isInvalidAccessibility.js")
const calculateSelectorsToFindRegionsFor = __webpack_require__(/*! ./calculateSelectorsToFindRegionsFor */ "./node_modules/@applitools/visual-grid-client/src/sdk/calculateSelectorsToFindRegionsFor.js")
const makeWaitForTestEnd = __webpack_require__(/*! ./makeWaitForTestEnd */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeWaitForTestEnd.js")

function makeCheckWindow({
  globalState,
  testController,
  createRGridDOMAndGetResourceMapping,
  putResources,
  getRenderJobInfo,
  render,
  waitForRenderedStatus,
  renderInfo,
  logger,
  getCheckWindowPromises,
  setCheckWindowPromises,
  browsers,
  wrappers,
  renderThroat,
  stepCounter,
  testName,
  openEyesPromises,
  userAgent,
  matchLevel: _matchLevel,
  visualGridOptions: _visualGridOptions,
  resolveTests,
}) {
  return function checkWindow({
    snapshot,
    url,
    tag,
    target = 'window',
    fully = true,
    sizeMode = 'full-page',
    selector,
    region,
    scriptHooks,
    ignore,
    floating,
    accessibility,
    sendDom = true,
    matchLevel = _matchLevel,
    layout,
    strict,
    content,
    useDom,
    enablePatterns,
    ignoreDisplacements,
    visualGridOptions = _visualGridOptions,
    closeAfterMatch,
    throwEx = true,
    variationGroupId,
  }) {
    const snapshots = Array.isArray(snapshot) ? snapshot : Array(browsers.length).fill(snapshot)

    if (target === 'window' && !fully) {
      sizeMode = 'viewport'
    } else if (target === 'region' && selector) {
      sizeMode = fully ? 'full-selector' : 'selector'
    } else if (target === 'region' && region) {
      sizeMode = 'region'
    }

    const accErr = isInvalidAccessibility(accessibility)
    if (accErr) {
      testController.setFatalError(`Invalid accessibility:\n${accErr}`)
      return
    }

    const currStepCount = ++stepCounter
    logger.log(`running checkWindow for test ${testName} step #${currStepCount}`)
    if (testController.shouldStopAllTests()) {
      logger.log('aborting checkWindow synchronously')
      return
    }

    const {selectorsToFindRegionsFor, getMatchRegions} = calculateSelectorsToFindRegionsFor({
      sizeMode,
      selector,
      ignore,
      layout,
      strict,
      content,
      accessibility,
      floating,
    })

    const resourcesPromises = snapshots.map(async snapshot => {
      const {rGridDom: dom, allResources: resources} = await createRGridDOMAndGetResourceMapping({
        resourceUrls: snapshot.resourceUrls,
        resourceContents: snapshot.resourceContents,
        cdt: snapshot.cdt,
        frames: snapshot.frames,
        userAgent,
        referer: url,
        proxySettings: wrappers[0].getProxy(),
      })
      await putResources([dom, ...Object.values(resources)])
      return {dom, resources: Object.values(resources)}
    })

    const checkWindowRunningJobs = browsers.map((_browser, index) =>
      checkWindowJob(index, getCheckWindowPromises()[index]).catch(
        testController.setError.bind(null, index),
      ),
    )
    setCheckWindowPromises(checkWindowRunningJobs)

    const renderJobs = new WeakMap()

    if (closeAfterMatch) {
      const waitAndResolveTests = makeWaitForTestEnd({
        getCheckWindowPromises,
        openEyesPromises,
        logger,
      })

      let error, didError
      const settleError = (throwEx ? Promise.reject : Promise.resolve).bind(Promise)

      const batchId = wrappers[0].getBatchIdWithoutGenerating()
      globalState.batchStore.addId(batchId)

      return waitAndResolveTests(async (testIndex, result) => {
        resolveTests[testIndex]()

        if ((error = testController.getFatalError())) {
          await wrappers[testIndex].ensureAborted()
          return (didError = true), error
        }
        if ((error = testController.getError(testIndex))) {
          return (didError = true), error
        }

        const [closeError, closeResult] = await [null, result]
        if (!closeError) {
          return closeResult
        } else {
          didError = true
          return closeError
        }
      }).then(results => {
        return didError ? settleError(results) : results
      })
    }

    async function checkWindowJob(index, prevJobPromise = presult(Promise.resolve())) {
      logger.verbose(
        `starting checkWindowJob. test=${testName} stepCount #${currStepCount} index=${index}`,
      )

      const wrapper = wrappers[index]

      if (testController.shouldStopTest(index)) {
        logger.log(`aborting checkWindow - not waiting for render to complete (so no renderId yet)`)
        return
      }

      await openEyesPromises[index]

      if (testController.shouldStopTest(index)) {
        logger.log(`aborting checkWindow after waiting for openEyes promise`)
        return
      }

      const renderRequest = createRenderRequest({
        url,
        browser: browsers[index],
        renderInfo,
        sizeMode,
        selector,
        selectorsToFindRegionsFor,
        region,
        scriptHooks,
        sendDom,
        visualGridOptions,
      })

      if (!wrapper.getAppEnvironment()) {
        const info = await getRenderJobInfo(renderRequest)
        wrapper.setRenderJobInfo(info)
      }

      await wrapper.ensureRunningSession()

      const {dom, resources} = await resourcesPromises[index]
      renderRequest.setDom(dom)
      renderRequest.setResources(resources)
      renderRequest.setRenderer(wrapper.getRenderer())

      const [renderErr, renderId] = await presult(renderJob(renderRequest))

      if (testController.shouldStopTest(index)) {
        logger.log(
          `aborting checkWindow after render request complete but before waiting for rendered status`,
        )
        if (renderJobs.has(renderRequest)) renderJobs.get(renderRequest)()
        return
      }

      // render error fails all tests
      if (renderErr) {
        logger.log('got render error aborting tests', renderErr)
        testController.setFatalError(renderErr)
        if (renderJobs.has(renderRequest)) renderJobs.get(renderRequest)()
        return
      }

      testController.addRenderId(index, renderId)

      logger.verbose(
        `render request complete for ${renderId}. test=${testName} stepCount #${currStepCount} tag=${tag} target=${target} fully=${fully} region=${JSON.stringify(
          region,
        )} selector=${JSON.stringify(selector)} browser: ${JSON.stringify(browsers[index])}`,
      )

      const [renderStatusErr, renderStatusResult] = await presult(
        waitForRenderedStatus(renderId, testController.shouldStopTest.bind(null, index)),
      )

      if (testController.shouldStopTest(index)) {
        logger.log('aborting checkWindow after render status finished')
        if (renderJobs.has(renderRequest)) renderJobs.get(renderRequest)()
        return
      }

      if (renderStatusErr) {
        logger.log('got render status error aborting tests')
        testController.setFatalError(renderStatusErr)
        if (renderJobs.has(renderRequest)) renderJobs.get(renderRequest)()
        return
      }

      const {
        imageLocation: screenshotUrl,
        domLocation,
        selectorRegions,
        imagePositionInActiveFrame: imageLocation,
      } = renderStatusResult

      if (screenshotUrl) {
        logger.verbose(`screenshot available for ${renderId} at ${screenshotUrl}`)
      } else {
        logger.log(`screenshot NOT available for ${renderId}`)
      }

      renderJobs.get(renderRequest)()

      logger.verbose(
        `checkWindow waiting for prev job. test=${testName}, stepCount #${currStepCount}`,
      )

      await prevJobPromise

      if (testController.shouldStopTest(index)) {
        logger.log(
          `aborting checkWindow for ${renderId} because there was an error in some previous job`,
        )
        return
      }

      const regions = getMatchRegions({selectorRegions, imageLocation})

      const checkSettings = {
        ...regions,
        useDom,
        enablePatterns,
        ignoreDisplacements,
        renderId,
        matchLevel,
        variationGroupId,
      }

      logger.verbose(
        `checkWindow waiting for openEyes. test=${testName}, stepCount #${currStepCount}`,
      )

      if (testController.shouldStopTest(index)) {
        logger.log(`aborting checkWindow after waiting for openEyes promise`)
        return
      }

      logger.verbose(`running wrapper.checkWindow for test ${testName} stepCount #${currStepCount}`)

      const checkArgs = {
        screenshotUrl,
        tag,
        domUrl: domLocation,
        checkSettings,
        imageLocation,
        url,
        closeAfterMatch,
        throwEx,
      }

      return wrapper.checkWindow(checkArgs)
    }

    async function renderJob(renderRequest) {
      if (testController.shouldStopAllTests()) {
        logger.log(`aborting renderJob because there was an error in getAllResources`)
        return
      }

      const renderRequestTask = new Task()
      globalState.setQueuedRendersCount(globalState.getQueuedRendersCount() + 1)
      const holder = new Promise(resolve => {
        renderThroat(async () => {
          logger.log(`starting to render test ${testName}`)
          renderJobs.set(renderRequest, resolve)
          const [renderIdErr, renderId] = await presult(render(renderRequest))
          if (renderIdErr) {
            renderRequestTask.reject(renderIdErr)
          } else {
            renderRequestTask.resolve(renderId)
          }
          globalState.setQueuedRendersCount(globalState.getQueuedRendersCount() - 1)
          return holder
        })
      })

      return renderRequestTask.promise
    }
  }
}

module.exports = makeCheckWindow

function Task() {
  this.promise = new Promise((r, j) => {
    this.resolve = r
    this.reject = j
  })
}


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/configParams.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/configParams.js ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = [
  'appName',
  'testName',
  'displayName',
  'browser',
  'url',
  'apiKey',
  'showLogs',
  'batch',
  'batchId',
  'batchName',
  'batchSequenceName',
  'batchSequence',
  'properties',
  'baselineBranchName',
  'baselineBranch',
  'baselineEnvName',
  'baselineName',
  'envName',
  'ignoreCaret',
  'isDisabled',
  'matchLevel',
  'parentBranchName',
  'parentBranch',
  'branchName',
  'branch',
  'proxy',
  'saveDiffs',
  'saveFailedTests',
  'saveNewTests',
  'compareWithParentBranch',
  'ignoreBaseline',
  'serverUrl',
  'concurrency',
  'testConcurrency',
  'useDom',
  'enablePatterns',
  'ignoreDisplacements',
  'accessibilitySettings',
  'notifyOnCompletion',
  'batchNotify',
  'dontCloseBatches',
]


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/createEmulationInfo.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/createEmulationInfo.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const isEmulation = __webpack_require__(/*! ./isEmulation */ "./node_modules/@applitools/visual-grid-client/src/sdk/isEmulation.js")

function createEmulationInfo(browserConfig) {
  const {deviceName, screenOrientation, deviceScaleFactor, mobile, width, height} = browserConfig
  return isEmulation(browserConfig)
    ? {
        deviceName,
        screenOrientation,
        device: !deviceName ? {width, height, deviceScaleFactor, mobile} : undefined,
      }
    : undefined
}

module.exports = createEmulationInfo


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDOMAndGetResourceMapping.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDOMAndGetResourceMapping.js ***!
  \****************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const createRGridDom = __webpack_require__(/*! ./createRGridDom */ "./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDom.js")

function makeCreateRGridDOMAndGetResourceMapping({getAllResources}) {
  return async function createRGridDOMAndGetResourceMapping({
    cdt,
    resourceUrls,
    resourceContents,
    frames = [],
    userAgent,
    referer,
    proxySettings,
  }) {
    const resources = await getAllResources({
      resourceUrls,
      preResources: resourceContents,
      userAgent,
      referer,
      proxySettings,
    })
    const allResources = Object.assign({}, resources)

    const frameDoms = await Promise.all(frames.map(createRGridDOMAndGetResourceMapping))

    frameDoms.forEach(({rGridDom: frameDom, allResources: frameAllResources}, i) => {
      const frameUrl = frames[i].url
      frameDom.setUrl(frameUrl)
      allResources[frameUrl] = resources[frameUrl] = frameDom
      Object.assign(allResources, frameAllResources)
    })

    Object.assign(allResources, resources)

    const rGridDom = createRGridDom({cdt, resources})

    return {rGridDom, allResources}
  }
}

module.exports = makeCreateRGridDOMAndGetResourceMapping


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDom.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDom.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];


const {RGridResource} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

function createRGridDom({cdt, resources}) {
  const resourceArr = Object.values(resources).sort((r1, r2) =>
    r1.getUrl() > r2.getUrl() ? 1 : -1,
  )

  const domResources = resourceArr.reduce((acc, resource) => {
    acc[resource.getUrl()] = resource.getHashAsObject()
    return acc
  }, {})

  const content = Buffer.from(
    JSON.stringify({
      resources: domResources,
      domNodes: cdt,
    }),
  )

  return new RGridResource({content, contentType: 'x-applitools-html/cdt'})
}

module.exports = createRGridDom


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/createRenderRequest.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/createRenderRequest.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {RenderRequest, RenderInfo} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const createEmulationInfo = __webpack_require__(/*! ./createEmulationInfo */ "./node_modules/@applitools/visual-grid-client/src/sdk/createEmulationInfo.js")

function createRenderRequest({
  url,
  dom,
  resources,
  browser,
  renderInfo,
  sizeMode,
  selector,
  selectorsToFindRegionsFor,
  region,
  scriptHooks,
  sendDom,
  visualGridOptions,
}) {
  const {
    width,
    height,
    name,
    deviceName,
    screenOrientation,
    deviceScaleFactor,
    mobile,
    platform,
    iosDeviceInfo,
  } = browser
  const emulationInfo = createEmulationInfo({
    deviceName,
    screenOrientation,
    deviceScaleFactor,
    mobile,
    width,
    height,
  })
  const filledBrowserName = iosDeviceInfo && !name ? 'safari' : name
  const filledPlatform = iosDeviceInfo && !platform ? 'ios' : platform

  return new RenderRequest({
    webhook: renderInfo.getResultsUrl(),
    stitchingService: renderInfo.getStitchingServiceUrl(),
    url,
    resources,
    dom,
    enableMultipleResultsPerSelector: true,
    renderInfo: new RenderInfo({
      width,
      height,
      sizeMode,
      selector,
      region,
      emulationInfo,
      iosDeviceInfo,
    }),
    browserName: filledBrowserName,
    scriptHooks,
    selectorsToFindRegionsFor,
    sendDom,
    platform: filledPlatform,
    visualGridOptions,
  })
}

module.exports = createRenderRequest


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/createResourceCache.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/createResourceCache.js ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";


function createResourceCache() {
  function getOrInit(key) {
    return cache[key] || (cache[key] = {})
  }

  function getValue(key) {
    const entry = cache[key]
    return entry ? entry.value : null
  }

  function setValue(key, value) {
    const entry = getOrInit(key)
    entry.value = value
    return value
  }

  function setDependencies(key, dependencies) {
    const entry = getOrInit(key)
    entry.dependencies = dependencies
  }

  function getWithDependencies(key, rv = {}) {
    const entry = cache[key]
    if (!entry || !entry.value) return

    rv[key] = entry.value
    if (entry.dependencies) {
      entry.dependencies.forEach(dep => {
        // stop condition to avoid infinite recursion
        if (!rv[dep]) {
          getWithDependencies(dep, rv)
        }
      })
    }
    return rv
  }

  function remove(key) {
    delete cache[key]
  }

  // for debugging purposes
  function toJSON() {
    return Object.keys(cache).reduce((acc, curr) => {
      acc[curr] = {length: cache[curr].value.length, dependencies: cache[curr].dependencies}
      return acc
    }, {})
  }

  function getKeys() {
    return Object.keys(cache)
  }

  const cache = {}

  return {
    getValue,
    setValue,
    setDependencies,
    getWithDependencies,
    remove,
    toJSON,
    getKeys,
  }
}

module.exports = createResourceCache


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/extractCssResources.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/extractCssResources.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const toUriEncoding = __webpack_require__(/*! ./toUriEncoding */ "./node_modules/@applitools/visual-grid-client/src/sdk/toUriEncoding.js")
const toUnAnchoredUri = __webpack_require__(/*! ./toUnAnchoredUri */ "./node_modules/@applitools/visual-grid-client/src/sdk/toUnAnchoredUri.js")
const valueParser = __webpack_require__(/*! postcss-value-parser */ "./node_modules/postcss-value-parser/lib/index.js")

function extractCssResources(cssText) {
  const urls = []
  const parsedValue = valueParser(cssText)
  parsedValue.walk((node, i, nodes) => {
    const nUrls = nodeUrls(node, i, nodes)
    nUrls && urls.push(...nUrls)
  })
  return [...new Set(urls)].map(toUriEncoding).map(toUnAnchoredUri)
}

function nodeUrls(node, i, nodes) {
  if (node.type === 'function' && node.value === 'url' && node.nodes && node.nodes.length == 1) {
    return [node.nodes[0].value]
  } else if (
    node.type === 'word' &&
    node.value === '@import' &&
    nodes[i + 2] &&
    nodes[i + 2].type === 'string'
  ) {
    return [nodes[i + 2].value]
  } else if (node.type === 'function' && node.value.includes('image-set') && node.nodes) {
    return node.nodes.filter(n => n.type === 'string').map(n => n.value)
  }
}

module.exports = extractCssResources


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/extractSvgResources.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/extractSvgResources.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {JSDOM} = __webpack_require__(/*! @applitools/jsdom */ "?34ae")
const extractCssResources = __webpack_require__(/*! ./extractCssResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/extractCssResources.js")
const makeExtractResourcesFromSvg = __webpack_require__(/*! ./makeExtractResourcesFromSvg */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeExtractResourcesFromSvg.js")
const toUnAnchoredUri = __webpack_require__(/*! ./toUnAnchoredUri */ "./node_modules/@applitools/visual-grid-client/src/sdk/toUnAnchoredUri.js")
const flat = __webpack_require__(/*! ./flat */ "./node_modules/@applitools/visual-grid-client/src/sdk/flat.js")

let parser
if (typeof DOMParser !== 'function') {
  parser = {parseFromString: str => new JSDOM(str).window.document}
} else {
  // in browser
  /* eslint-disable-next-line no-undef */
  parser = new DOMParser()
}

const decoder = {decode: buff => buff}
const doExtractSvgResources = makeExtractResourcesFromSvg({
  parser,
  decoder,
  extractResourceUrlsFromStyleTags,
})

function extractSvgResources(value) {
  return doExtractSvgResources(value).map(toUnAnchoredUri)
}

function extractResourceUrlsFromStyleTags(doc) {
  const urls = [...doc.querySelectorAll('style')].map(
    s => s.textContent && extractCssResources(s.textContent),
  )
  return flat(urls).filter(Boolean)
}

module.exports = extractSvgResources


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/fetchResource.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/fetchResource.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js")["Buffer"];

const retryFetch = __webpack_require__(/*! @applitools/http-commons/src/retryFetch */ "./node_modules/@applitools/http-commons/src/retryFetch.js")
const createResourceCache = __webpack_require__(/*! ./createResourceCache */ "./node_modules/@applitools/visual-grid-client/src/sdk/createResourceCache.js")
const AbortController = __webpack_require__(/*! abort-controller */ "./node_modules/abort-controller/browser.js")

function makeFetchResource({
  logger,
  retries = 5,
  fetchCache = createResourceCache(),
  fetch,
  mediaDownloadTimeout = 30 * 1000,
}) {
  return (url, opts) =>
    fetchCache.getValue(url) || fetchCache.setValue(url, doFetchResource(url, opts))

  function doFetchResource(url, opts) {
    return retryFetch(
      async retry => {
        const retryStr = retry ? `(retry ${retry}/${retries})` : ''
        const optsStr = JSON.stringify(opts) || ''
        logger.verbose(`fetching ${url} ${retryStr} ${optsStr}`)

        const controller = new AbortController()
        const resp = await fetch(url, {...opts, signal: controller.signal})

        if (!resp.ok) {
          logger.verbose(`failed to fetch ${url} status ${resp.status}, returning errorStatusCode`)
          return {url, errorStatusCode: resp.status}
        }

        logger.verbose(`fetched ${url}`)

        const bufferPromise = resp.buffer ? resp.buffer() : resp.arrayBuffer()

        if (isProbablyStreaming(resp)) {
          return createStreamingPromise(resp, bufferPromise, controller)
        } else {
          const buffer = await bufferPromise
          return createResource(resp, buffer)
        }
      },
      {retries},
    )

    function createResource(resp, buffer) {
      return {
        url,
        type: resp.headers.get('Content-Type'),
        value: Buffer.from(buffer),
      }
    }

    function createStreamingPromise(resp, bufferPromise, controller) {
      return new Promise(async resolve => {
        const timeoutId = setTimeout(() => {
          logger.verbose('streaming timeout reached for resource', url)
          resolve({url, errorStatusCode: 599})
          controller.abort()
        }, mediaDownloadTimeout)

        // aborting the request causes node-fetch to reject bufferPromise, so we need to handle it
        try {
          const buffer = await bufferPromise
          resolve(createResource(resp, buffer))
        } catch (ex) {
          logger.verbose('streaming buffer exception', ex)
        } finally {
          clearTimeout(timeoutId)
        }
      })
    }

    function isProbablyStreaming(resp) {
      return (
        !resp.headers.get('Content-Length') &&
        ['audio/', 'video/'].some(prefix => resp.headers.get('Content-Type').startsWith(prefix))
      )
    }
  }
}

module.exports = makeFetchResource


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/flat.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/flat.js ***!
  \*********************************************************************/
/***/ ((module) => {

"use strict";


function flat(arr) {
  return [].concat(...arr)
}

module.exports = flat


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getAllResources.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getAllResources.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const mapValues = __webpack_require__(/*! lodash.mapvalues */ "./node_modules/lodash.mapvalues/index.js")
const {URL} = __webpack_require__(/*! url */ "./src/builtins/url.js")
const {RGridResource} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const absolutizeUrl = __webpack_require__(/*! ./absolutizeUrl */ "./node_modules/@applitools/visual-grid-client/src/sdk/absolutizeUrl.js")
const resourceType = __webpack_require__(/*! ./resourceType */ "./node_modules/@applitools/visual-grid-client/src/sdk/resourceType.js")
const toCacheEntry = __webpack_require__(/*! ./toCacheEntry */ "./node_modules/@applitools/visual-grid-client/src/sdk/toCacheEntry.js")
const extractSvgResources = __webpack_require__(/*! ./extractSvgResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/extractSvgResources.js")
const getFetchOptions = __webpack_require__(/*! ./getFetchOptions */ "./node_modules/@applitools/visual-grid-client/src/sdk/getFetchOptions.js")

// NOTE regarding support for errorStatusCode:
// why is this function still valid? because it is meant to add resources to the return value of getAllResources, if and only if it's not already there OR it is there but there is no content (for some reason I don't remember).
// when handling errorStatusCode resources, they are added if they are not already there, and if they are there, they will never have content so it's fine.
function assignContentfulResources(obj1, obj2) {
  for (const p in obj2) {
    if (!obj1[p] || !obj1[p].getContent()) {
      obj1[p] = obj2[p]
    }
  }
}

function fromCacheToRGridResource({url, type, hash, content, errorStatusCode}) {
  const resource = new RGridResource({url})
  if (errorStatusCode) {
    resource.setErrorStatusCode(errorStatusCode)
  } else {
    resource.setContentType(type)
    resource.setContent(content || '')
    // yuck! but RGridResource assumes it always has the content, which we prefer not to save in cache.
    // after renderBatch we clear the content of the resource, for saving space.
    resource._sha256hash = hash
  }
  return resource
}

function makeGetAllResources({resourceCache, fetchResource, extractCssResources, logger}) {
  function fromFetchedToRGridResource({url, type, value, errorStatusCode}) {
    const rGridResource = new RGridResource({url})
    if (errorStatusCode) {
      rGridResource.setErrorStatusCode(errorStatusCode)
    } else {
      rGridResource.setContentType(type || 'application/x-applitools-unknown') // TODO test this
      rGridResource.setContent(value || '')
      if (!value) {
        logger.log(`warning! the resource ${url} ${type} has no content.`)
      }
    }
    return rGridResource
  }

  return function getAllResources({resourceUrls, preResources, userAgent, referer, proxySettings}) {
    const handledResources = new Set()
    return getOrFetchResources(resourceUrls, preResources)

    async function getOrFetchResources(resourceUrls = [], preResources = {}) {
      const resources = {}
      for (const [url, resource] of Object.entries(preResources)) {
        // "preResources" are not fetched and not in "fetchCache" so cache them to "resourceCache".
        const rGridResource = fromFetchedToRGridResource(resource)
        resourceCache.setValue(url, toCacheEntry(rGridResource))
        if (resource.dependencies) {
          resourceCache.setDependencies(url, resource.dependencies)
        }
        handledResources.add(url)
        assignContentfulResources(resources, {[url]: rGridResource})
      }

      const unhandledResourceUrls = resourceUrls.filter(url => !handledResources.has(url))
      const missingResourceUrls = []
      for (const url of unhandledResourceUrls) {
        handledResources.add(url)
        const cacheEntry = resourceCache.getWithDependencies(url)
        if (cacheEntry) {
          assignContentfulResources(resources, mapValues(cacheEntry, fromCacheToRGridResource))
        } else if (/^https?:$/i.test(new URL(url).protocol)) {
          missingResourceUrls.push(url)
        }
      }

      await Promise.all(
        missingResourceUrls.map(async url => {
          try {
            const fetchOptions = getFetchOptions({url, referer, userAgent, proxySettings})
            const resource = await fetchResource(url, fetchOptions)
            return assignContentfulResources(resources, await processResource(resource))
          } catch (err) {
            logger.log(
              `error fetching resource at ${url}, setting errorStatusCode to 504. err=${err}`,
            )
            resources[url] = new RGridResource({url, errorStatusCode: 504})
          }
        }),
      )

      return resources
    }

    async function processResource(resource) {
      let {dependentResources, fetchedResources} = await getDependantResources(resource)
      const rGridResource = fromFetchedToRGridResource(resource)
      // It is time consuming to process css/svg so use "resourceCache".
      const doesRequireProcessing = !!resourceType(rGridResource.getContentType())
      if (doesRequireProcessing) {
        resourceCache.setValue(resource.url, toCacheEntry(rGridResource))
      }
      resourceCache.setDependencies(resource.url, dependentResources)
      return Object.assign({[resource.url]: rGridResource}, fetchedResources)
    }

    async function getDependantResources({url, type, value}) {
      let dependentResources, fetchedResources
      const rType = resourceType(type)

      try {
        if (rType === 'CSS') {
          dependentResources = extractCssResources(value.toString())
        } else if (rType === 'SVG') {
          dependentResources = extractSvgResources(value.toString())
        }
      } catch (e) {
        logger.log(`could not parse ${rType} ${url}`, e)
      }

      if (dependentResources) {
        dependentResources = dependentResources.map(u => absolutizeUrl(u, url))
        fetchedResources = await getOrFetchResources(dependentResources)
      }
      return {dependentResources, fetchedResources}
    }
  }
}

module.exports = makeGetAllResources


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getDeviceInfoFromBrowserConfig.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getDeviceInfoFromBrowserConfig.js ***!
  \***********************************************************************************************/
/***/ ((module) => {

"use strict";


function getDeviceInfoFromBrowserConfig(browser) {
  const chromeEmulationDeviceName =
    browser.deviceName || (browser.chromeEmulationInfo && browser.chromeEmulationInfo.deviceName)

  if (chromeEmulationDeviceName) {
    return `${chromeEmulationDeviceName} (Chrome emulation)`
  }

  if (browser.iosDeviceInfo) {
    return browser.iosDeviceInfo.deviceName
  }

  return 'Desktop'
}

module.exports = getDeviceInfoFromBrowserConfig


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getFetchOptions.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getFetchOptions.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {getTunnelAgentFromProxy} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

function getFetchOptions({url, referer, userAgent, proxySettings}) {
  const fetchOptions = {headers: {Referer: referer}}
  if (!/https:\/\/fonts.googleapis.com/.test(url)) {
    fetchOptions.headers['User-Agent'] = userAgent
  }

  if (proxySettings && proxySettings.getIsHttpOnly()) {
    fetchOptions.agent = getTunnelAgentFromProxy(proxySettings.toProxyObject())
  }
  return fetchOptions
}

module.exports = getFetchOptions


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getFinalConcurrency.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getFinalConcurrency.js ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";


function getFinalConcurrency({concurrency, testConcurrency}) {
  if (testConcurrency !== undefined) {
    return Number(testConcurrency)
  }
  const concurrencyNumber = Number(concurrency)
  if (!isNaN(concurrencyNumber)) {
    return concurrencyNumber * 5
  }
  return concurrencyNumber
}

module.exports = getFinalConcurrency


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderJobInfo.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getRenderJobInfo.js ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";

function makeGetRenderJobInfo({doGetRenderJobInfo, timeout = 100}) {
  let pendingRequests = new Map()
  let throttleTimer = false

  return function(renderRequest) {
    return new Promise((resolve, reject) => {
      pendingRequests.set(renderRequest, {resolve, reject})
      if (!throttleTimer) {
        throttleTimer = true
        setTimeout(() => {
          getRenderJobInfo(pendingRequests)
          pendingRequests = new Map()
          throttleTimer = false
        }, timeout)
      }
    })
  }

  async function getRenderJobInfo(pendingRequests) {
    try {
      const renderRequests = Array.from(pendingRequests.keys())
      const rendererInfos = await doGetRenderJobInfo(renderRequests)
      rendererInfos.forEach((rendererInfo, index) => {
        const {resolve} = pendingRequests.get(renderRequests[index])
        resolve(rendererInfo)
      })
    } catch (err) {
      pendingRequests.forEach(({reject}) => reject(err))
    }
  }
}

module.exports = makeGetRenderJobInfo


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderMethods.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getRenderMethods.js ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";


function getRenderMethods(renderWrapper) {
  const doGetRenderInfo = renderWrapper.getRenderInfo.bind(renderWrapper)
  const doRenderBatch = renderWrapper.renderBatch.bind(renderWrapper)
  const doCheckResources = renderWrapper.checkResources.bind(renderWrapper)
  const doPutResource = renderWrapper.putResource.bind(renderWrapper)
  const doGetRenderStatus = renderWrapper.getRenderStatus.bind(renderWrapper)
  const setRenderingInfo = renderWrapper.setRenderingInfo.bind(renderWrapper)
  const doGetRenderJobInfo = renderWrapper.getRenderJobInfo.bind(renderWrapper)
  const doLogEvents = renderWrapper.logEvents.bind(renderWrapper)
  const doGetEmulatedDevicesSizes = renderWrapper.getEmulatedDevicesSizes.bind(renderWrapper)
  const doGetIosDevicesSizes = renderWrapper.getIosDevicesSizes.bind(renderWrapper)
  return {
    doGetRenderInfo,
    doRenderBatch,
    doCheckResources,
    doPutResource,
    doGetRenderStatus,
    setRenderingInfo,
    doGetRenderJobInfo,
    doLogEvents,
    doGetEmulatedDevicesSizes,
    doGetIosDevicesSizes,
  }
}

module.exports = getRenderMethods


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderStatus.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/getRenderStatus.js ***!
  \********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")

const psetTimeout = t =>
  new Promise(res => {
    setTimeout(res, t)
  })

/*******************************
 *    This is THE STATUSER!    *
 *******************************/

function makeGetRenderStatus({logger, doGetRenderStatus, getStatusInterval = 500}) {
  let isRunning = false
  let pendingRenders = {}
  return function getRenderStatus(renderId) {
    return new Promise(async (resolve, reject) => {
      log(`adding job for ${renderId} isRunning=${isRunning}`)
      if (!pendingRenders[renderId]) {
        pendingRenders[renderId] = {resolve, reject}
      }
      if (!isRunning) {
        isRunning = true
        await psetTimeout(100)
        getRenderStatusJob()
      }
    })
  }

  async function getRenderStatusJob() {
    const renderIds = Object.keys(pendingRenders)
    log(`render status job (${renderIds.length}): ${renderIds}`)
    if (renderIds.length === 0) {
      isRunning = false
      return
    }

    const pendingRendersForJob = pendingRenders
    pendingRenders = {}

    const [err, renderStatuses] = await presult(doGetRenderStatus(renderIds))

    if (err) {
      log(`error during getRenderStatus: ${err}`)
      for (const renderId of renderIds) {
        pendingRendersForJob[renderId].reject(err)
      }
    } else {
      renderStatuses.forEach((rs, i) => {
        const renderId = renderIds[i]
        pendingRendersForJob[renderId].resolve(rs)
      })
    }

    await psetTimeout(getStatusInterval)
    getRenderStatusJob()
  }

  function log(msg) {
    logger.verbose(`[getRenderStatus] ${msg}`)
  }
}

module.exports = makeGetRenderStatus


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/globalState.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/globalState.js ***!
  \****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const makeTestController = __webpack_require__(/*! ./makeTestController */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeTestController.js")
const makeBatchStore = __webpack_require__(/*! ./makeBatchStore */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeBatchStore.js")

function makeGlobalState({logger}) {
  let queuedRendersCount = 0
  const queuedRendersConditions = []

  return {
    makeTestController,
    getQueuedRendersCount,
    setQueuedRendersCount,
    waitForQueuedRenders,
    batchStore: makeBatchStore(),
  }

  function getQueuedRendersCount() {
    return queuedRendersCount
  }

  function setQueuedRendersCount(value) {
    logger.log('setting queued renders count to', value)
    queuedRendersCount = value
    checkCondition()
  }

  async function waitForQueuedRenders(desiredCount) {
    if (desiredCount < queuedRendersCount) {
      return new Promise(resolve => {
        queuedRendersConditions.push({resolve, desiredCount})
      })
    }
  }

  function checkCondition() {
    const condition = queuedRendersConditions[0]
    if (condition && condition.desiredCount >= queuedRendersCount) {
      queuedRendersConditions.splice(0, 1)
      condition.resolve()
    }
  }
}

module.exports = makeGlobalState


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/isEmulation.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/isEmulation.js ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";


function isEmulation(browserConfig) {
  const {deviceName, deviceScaleFactor, mobile} = browserConfig
  return deviceName || deviceScaleFactor || mobile
}

module.exports = isEmulation


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/isInvalidAccessibility.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/isInvalidAccessibility.js ***!
  \***************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {AccessibilityRegionType, TypeUtils} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

function isInvalidAccessibility(accessibility = []) {
  const accObjects = [].concat(accessibility)
  const err = []
  const typeMsg = `Valid accessibilityType values are: ${Object.values(AccessibilityRegionType)}`
  for (const acc of accObjects) {
    if (acc.accessibilityType && !TypeUtils.has(AccessibilityRegionType, acc.accessibilityType)) {
      err.push(
        `The region ${JSON.stringify(acc)} has an invalid accessibilityType of: ${
          acc.accessibilityType
        } `,
      )
      !err.length && err.unshift(typeMsg)
    }
  }
  return err.join('\n')
}

module.exports = isInvalidAccessibility


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeAbort.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeAbort.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const makeWaitForTestEnd = __webpack_require__(/*! ./makeWaitForTestEnd */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeWaitForTestEnd.js")

function makeAbort({
  getCheckWindowPromises,
  wrappers,
  openEyesPromises,
  resolveTests,
  testController,
  globalState,
  logger,
}) {
  const waitAndResolveTests = makeWaitForTestEnd({
    getCheckWindowPromises,
    openEyesPromises,
    logger,
  })

  return async () => {
    testController.setIsAbortedByUser()

    const batchId = wrappers[0].getBatchIdWithoutGenerating()
    globalState.batchStore.addId(batchId)

    return waitAndResolveTests(async testIndex => {
      const [closeErr, closeResult] = await presult(wrappers[testIndex].abort())
      resolveTests[testIndex]()
      if (closeErr) {
        throw closeErr
      }
      return closeResult
    })
  }
}

module.exports = makeAbort


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeBatchStore.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeBatchStore.js ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";


function makeBatchStore() {
  const store = {
    ids: new Set(),
    addId: id => {
      if (id && !store.ids.has(id)) {
        store.ids.add(id)
      }
    },
    hasCloseBatch: () => !!store.closeBatch,
    setCloseBatch: closeBatch => (store.closeBatch = closeBatch),
  }
  return store
}

module.exports = makeBatchStore


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeClose.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeClose.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const makeWaitForTestEnd = __webpack_require__(/*! ./makeWaitForTestEnd */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeWaitForTestEnd.js")

function makeClose({
  getCheckWindowPromises,
  wrappers,
  openEyesPromises,
  resolveTests,
  testController,
  logger,
  globalState,
}) {
  const waitAndResolveTests = makeWaitForTestEnd({
    getCheckWindowPromises,
    openEyesPromises,
    logger,
  })

  return async (throwEx = true) => {
    let error, didError
    const settleError = (throwEx ? Promise.reject : Promise.resolve).bind(Promise)
    logger.log('closeEyes() called')

    if (testController.getIsAbortedByUser()) {
      logger.log('closeEyes() aborted by user')
      return settleError([])
    }

    const batchId = wrappers[0].getBatchIdWithoutGenerating()
    globalState.batchStore.addId(batchId)

    return waitAndResolveTests(async testIndex => {
      resolveTests[testIndex]()

      if ((error = testController.getFatalError())) {
        logger.log('closeEyes() fatal error found')
        await wrappers[testIndex].ensureAborted()
        return (didError = true), error
      }
      if ((error = testController.getError(testIndex))) {
        logger.log('closeEyes() found test error')
        return (didError = true), error
      }

      const closePromise = wrappers[testIndex].close(throwEx)
      const [closeError, closeResult] = await presult(closePromise)
      if (!closeError) {
        setRenderIds(closeResult, testIndex)
        return closeResult
      } else {
        didError = true
        return closeError
      }
    }).then(results => {
      logger.log(`closeEyes() done`)
      return didError ? settleError(results) : results
    })
  }

  function setRenderIds(result, testIndex) {
    const renderIds = testController.getRenderIds(testIndex)
    const steps = result.getStepsInfo()
    for (const [i, renderId] of renderIds.entries()) {
      steps[i].setRenderId(renderId)
    }
  }
}

module.exports = makeClose


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeCloseBatch.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeCloseBatch.js ***!
  \*******************************************************************************/
/***/ ((module) => {

"use strict";


function makeCloseBatch({globalState, dontCloseBatches, isDisabled}) {
  if (dontCloseBatches || isDisabled) {
    return async () => {}
  }

  return async () => {
    const {ids, closeBatch} = globalState.batchStore
    const promises = [...ids.values()].map(id => closeBatch(id))
    await Promise.all(promises)
  }
}

module.exports = makeCloseBatch


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeExtractResourcesFromSvg.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeExtractResourcesFromSvg.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


function makeExtractResourcesFromSvg({parser, decoder, extractResourceUrlsFromStyleTags}) {
  return function(svgArrayBuffer) {
    const decooder = decoder || new TextDecoder('utf-8') // eslint-disable-line node/no-unsupported-features/node-builtins
    const svgStr = decooder.decode(svgArrayBuffer)
    const domparser = parser || new DOMParser() // eslint-disable-line no-undef
    const doc = domparser.parseFromString(svgStr, 'image/svg+xml')

    const srcsetUrls = Array.from(doc.querySelectorAll('img[srcset]'))
      .map(srcsetEl =>
        srcsetEl
          .getAttribute('srcset')
          .split(', ')
          .map(str => str.trim().split(/\s+/)[0]),
      )
      .reduce((acc, urls) => acc.concat(urls), [])

    const srcUrls = Array.from(doc.querySelectorAll('img[src]')).map(srcEl =>
      srcEl.getAttribute('src'),
    )

    const fromHref = Array.from(doc.querySelectorAll('image,use,link[rel="stylesheet"]')).map(
      e => e.getAttribute('href') || e.getAttribute('xlink:href'),
    )
    const fromObjects = Array.from(doc.getElementsByTagName('object')).map(e =>
      e.getAttribute('data'),
    )
    const fromStyleTags = extractResourceUrlsFromStyleTags(doc, false)
    const fromStyleAttrs = urlsFromStyleAttrOfDoc(doc)

    return srcsetUrls
      .concat(srcUrls)
      .concat(fromHref)
      .concat(fromObjects)
      .concat(fromStyleTags)
      .concat(fromStyleAttrs)
      .filter(u => u[0] !== '#')
  }
}

function urlsFromStyleAttrOfDoc(doc) {
  return flat(
    Array.from(doc.querySelectorAll('*[style]'))
      .map(e => e.style.cssText)
      .map(getUrlFromCssText)
      .filter(Boolean),
  )
}

function getUrlFromCssText(cssText) {
  const re = /url\((?!['"]?:)['"]?([^'")]*)['"]?\)/g
  const ret = []
  let result
  while ((result = re.exec(cssText)) !== null) {
    ret.push(result[1])
  }
  return ret
}

function flat(arr) {
  return arr.reduce((flatArr, item) => flatArr.concat(item), [])
}

module.exports = makeExtractResourcesFromSvg


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeTestController.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeTestController.js ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";


function makeTestController({testName, numOfTests, logger}) {
  const errors = [...new Array(numOfTests)]
  const renderIds = [...new Array(numOfTests)].map(() => [])
  let abortedByUser = false
  let fatalError = false

  return {
    setError: (index, err) => {
      logger.log('error set in test', testName, err)
      errors[index] = err && err.message ? err : new Error(err)
    },

    getError: index => {
      return errors[index]
    },

    setIsAbortedByUser: () => {
      logger.log('user aborted test', testName)
      abortedByUser = true
    },

    getIsAbortedByUser: () => {
      return abortedByUser
    },

    setFatalError: err => {
      fatalError = err && err.message ? err : new Error(err)
    },

    getFatalError: () => {
      return fatalError
    },

    shouldStopAllTests: () => {
      return fatalError || errors.every(Boolean) || abortedByUser
    },

    shouldStopTest: index => {
      return errors[index] || fatalError || abortedByUser
    },

    addRenderId(index, ids) {
      renderIds[index].push(ids)
    },

    getRenderIds(index) {
      return renderIds[index]
    },
  }
}

module.exports = makeTestController


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeTestWindow.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeTestWindow.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const makeOpenEyes = __webpack_require__(/*! ./openEyes */ "./node_modules/@applitools/visual-grid-client/src/sdk/openEyes.js")

function makeTestWindow(openConfig) {
  const openEyes = makeOpenEyes(openConfig)
  return async ({openParams, checkParams, throwEx = true}) => {
    const {checkWindow} = await openEyes(openParams)
    return checkWindow({...checkParams, closeAfterMatch: true, throwEx})
  }
}

module.exports = makeTestWindow


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/makeWaitForTestEnd.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/makeWaitForTestEnd.js ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";


function makeWaitForTestEnd({getCheckWindowPromises, openEyesPromises, logger}) {
  return async function waitForTestEnd(onTestEnd) {
    return Promise.all(
      getCheckWindowPromises().map((checkWindowPromise, i) =>
        // the close job must start after openEyes has finished, otherwise resolving the whole test will fail.
        // This situation could happen when a render fails and the checkWindow promise is rejected before
        // waiting on openEyesPromise.
        checkWindowPromise
          .then(r => {
            logger.verbose(`waitForTestEnd() checkWindow ${i} done`)
            return Promise.all([openEyesPromises[i], r])
          })
          .then(([, r]) => {
            logger.verbose(`waitForTestEnd() open ${i} done`)
            return onTestEnd(i, r)
          }),
      ),
    )
  }
}

module.exports = makeWaitForTestEnd


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/mapChromeEmulationInfo.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/mapChromeEmulationInfo.js ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";


function mapChromeEmulationInfo(browser) {
  let withEmulationInfo = browser
  if (browser.chromeEmulationInfo && browser.chromeEmulationInfo.deviceName) {
    withEmulationInfo = {...browser, ...browser.chromeEmulationInfo}
    delete withEmulationInfo.chromeEmulationInfo
  }
  return withEmulationInfo
}

module.exports = mapChromeEmulationInfo


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/openEyes.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/openEyes.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {
  BatchInfo,
  GeneralUtils: {backwardCompatible, cachify},
  BrowserType,
} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const makeCheckWindow = __webpack_require__(/*! ./checkWindow */ "./node_modules/@applitools/visual-grid-client/src/sdk/checkWindow.js")
const makeAbort = __webpack_require__(/*! ./makeAbort */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeAbort.js")
const makeClose = __webpack_require__(/*! ./makeClose */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeClose.js")
const isEmulation = __webpack_require__(/*! ./isEmulation */ "./node_modules/@applitools/visual-grid-client/src/sdk/isEmulation.js")
const mapChromeEmulationInfo = __webpack_require__(/*! ./mapChromeEmulationInfo */ "./node_modules/@applitools/visual-grid-client/src/sdk/mapChromeEmulationInfo.js")
const getSupportedBrowsers = __webpack_require__(/*! ./supportedBrowsers */ "./node_modules/@applitools/visual-grid-client/src/sdk/supportedBrowsers.js")
const chalk = __webpack_require__(/*! chalk */ "./node_modules/chalk/source/index.js")
const throatPkg = __webpack_require__(/*! throat */ "./node_modules/throat/index.js")

const {
  initWrappers,
  configureWrappers,
  openWrappers,
  appNameFailMsg,
  apiKeyFailMsg,
} = __webpack_require__(/*! ./wrapperUtils */ "./node_modules/@applitools/visual-grid-client/src/sdk/wrapperUtils.js")

function makeOpenEyes({
  appName: _appName,
  browser: _browser,
  batch: _batch,
  properties: _properties,
  baselineBranchName: _baselineBranchName,
  baselineBranch: _baselineBranch,
  baselineEnvName: _baselineEnvName,
  baselineName: _baselineName,
  envName: _envName,
  ignoreCaret: _ignoreCaret,
  isDisabled: _isDisabled,
  matchLevel: _matchLevel,
  accessibilitySettings: _accessibilitySettings,
  useDom: _useDom,
  enablePatterns: _enablePatterns,
  ignoreDisplacements: _ignoreDisplacements,
  parentBranchName: _parentBranchName,
  parentBranch: _parentBranch,
  branchName: _branchName,
  branch: _branch,
  saveDiffs: _saveDiffs,
  saveFailedTests: _saveFailedTests,
  saveNewTests: _saveNewTests,
  compareWithParentBranch: _compareWithParentBranch,
  ignoreBaseline: _ignoreBaseline,
  userAgent: _userAgent,
  createRGridDOMAndGetResourceMapping,
  apiKey,
  proxy,
  serverUrl,
  logger,
  putResources,
  getRenderJobInfo,
  render,
  waitForRenderedStatus,
  eyesTransactionThroat,
  getInitialData,
  agentId,
  globalState,
  wrappers: _wrappers,
  visualGridOptions: _visualGridOptions,
  concurrentRendersPerTest,
  ignoreGitMergeBase,
}) {
  return async function openEyes({
    testName,
    displayName,
    wrappers = _wrappers,
    userAgent = _userAgent,
    appName = _appName,
    browser = _browser,
    batch = _batch,
    batchId,
    batchName,
    batchSequenceName,
    batchSequence,
    batchNotify,
    properties = _properties,
    baselineBranchName = _baselineBranchName,
    baselineBranch = _baselineBranch,
    baselineEnvName = _baselineEnvName,
    baselineName = _baselineName,
    envName = _envName,
    ignoreCaret = _ignoreCaret,
    isDisabled = _isDisabled,
    matchLevel = _matchLevel,
    accessibilitySettings = _accessibilitySettings,
    useDom = _useDom,
    enablePatterns = _enablePatterns,
    ignoreDisplacements = _ignoreDisplacements,
    parentBranchName = _parentBranchName,
    parentBranch = _parentBranch,
    branchName = _branchName,
    branch = _branch,
    saveDiffs = _saveDiffs,
    saveFailedTests = _saveFailedTests,
    saveNewTests = _saveNewTests,
    compareWithParentBranch = _compareWithParentBranch,
    ignoreBaseline = _ignoreBaseline,
    notifyOnCompletion,
    visualGridOptions = _visualGridOptions,
    agentRunId,
  }) {
    logger.verbose(`openEyes: testName=${testName}, browser=`, browser)

    if (!apiKey) {
      throw new Error(apiKeyFailMsg)
    }

    if (isDisabled) {
      logger.verbose('openEyes: isDisabled=true, skipping checks')
      return {
        checkWindow: disabledFunc('checkWindow'),
        close: disabledFunc('close', []),
        abort: disabledFunc('abort'),
      }
    }

    if (!appName) {
      throw new Error(appNameFailMsg)
    }

    const supportedBrowsers = getSupportedBrowsers()
    const supportedBrowserKeys = Object.keys(supportedBrowsers)
    const supportedBrowserKeysStr = `\n* ${supportedBrowserKeys
      .filter(x => x !== BrowserType.EDGE)
      .join('\n* ')}\n`

    let browsersArray = Array.isArray(browser) ? browser : [browser]
    browsersArray = browsersArray.map(mapChromeEmulationInfo)
    const browserError = browsersArray.length
      ? browsersArray.map(getBrowserError).find(Boolean)
      : getBrowserError()
    if (browserError) {
      console.log('\x1b[31m', `\nInvalid browser: ${browserError}\n`)
      throw new Error(browserError)
    }

    showBrowserWarning(browsersArray)

    const browsers = browsersArray.map(browser => ({
      ...browser,
      name: supportedBrowsers[browser.name] || browser.name,
    }))

    ;({batchSequence, baselineBranch, parentBranch, branch, batchNotify} = backwardCompatible(
      [{batchSequenceName}, {batchSequence}],
      [{baselineBranchName}, {baselineBranch}],
      [{parentBranchName}, {parentBranch}],
      [{branchName}, {branch}],
      [{notifyOnCompletion}, {batchNotify}],
      logger,
    ))

    const mergedBatch = mergeBatchProperties({
      batch,
      batchId,
      batchName,
      batchSequence,
      batchNotify,
    })

    let doGetBatchInfoWithCache
    const getBatchInfoWithCache = batchId => {
      if (!doGetBatchInfoWithCache) {
        const serverConnector = getServerConnector(wrappers)
        doGetBatchInfoWithCache = cachify(serverConnector.batchInfo.bind(serverConnector))
      }
      return doGetBatchInfoWithCache(batchId)
    }

    wrappers =
      wrappers ||
      initWrappers({
        count: browsers.length,
        apiKey,
        logHandler: logger.getLogHandler(),
        getBatchInfoWithCache,
      })

    const {renderInfo} = await getInitialData()

    configureWrappers({
      wrappers,
      browsers,
      isDisabled,
      displayName,
      batch: mergedBatch,
      properties,
      baselineBranch,
      baselineEnvName,
      baselineName,
      envName,
      ignoreCaret,
      matchLevel,
      accessibilitySettings,
      useDom,
      enablePatterns,
      ignoreDisplacements,
      parentBranch,
      branch,
      proxy,
      saveDiffs,
      saveFailedTests,
      saveNewTests,
      compareWithParentBranch,
      ignoreBaseline,
      serverUrl,
      agentId,
      ignoreGitMergeBase,
      agentRunId,
    })

    if (!globalState.batchStore.hasCloseBatch()) {
      const serverConnector = getServerConnector(wrappers)
      globalState.batchStore.setCloseBatch(
        serverConnector.deleteBatchSessions.bind(serverConnector),
      )
    }

    logger.verbose('openEyes: opening wrappers')
    const {openEyesPromises, resolveTests} = openWrappers({
      wrappers,
      browsers,
      appName,
      testName,
      eyesTransactionThroat,
      skipStartingSession: false,
    })

    let stepCounter = 0

    let checkWindowPromises = wrappers.map(() => Promise.resolve())
    const testController = globalState.makeTestController({
      testName,
      numOfTests: wrappers.length,
      logger,
    })

    const renderThroat = throatPkg(concurrentRendersPerTest * browsers.length)

    const checkWindow = makeCheckWindow({
      globalState,
      testController,
      createRGridDOMAndGetResourceMapping,
      putResources,
      getRenderJobInfo,
      render,
      waitForRenderedStatus,
      renderInfo,
      logger,
      getCheckWindowPromises,
      setCheckWindowPromises,
      browsers,
      wrappers,
      renderThroat,
      stepCounter,
      testName,
      openEyesPromises,
      matchLevel,
      userAgent,
      visualGridOptions,
      resolveTests,
    })

    const close = makeClose({
      getCheckWindowPromises,
      openEyesPromises,
      wrappers,
      resolveTests,
      globalState,
      testController,
      logger,
    })
    const abort = makeAbort({
      getCheckWindowPromises,
      openEyesPromises,
      wrappers,
      resolveTests,
      globalState,
      testController,
      logger,
    })

    return {
      checkWindow,
      close,
      abort,
    }

    function getServerConnector(wrappers) {
      return wrappers[0]._serverConnector
    }

    function getCheckWindowPromises() {
      return checkWindowPromises
    }

    function setCheckWindowPromises(promises) {
      checkWindowPromises = promises
    }

    function disabledFunc(name, rv) {
      return async () => {
        logger.verbose(`${name}: isDisabled=true, skipping checks`)
        return rv
      }
    }

    function getBrowserError(browser) {
      if (!browser) {
        return 'invalid browser configuration provided.'
      }
      if (browser.name && !supportedBrowserKeys.includes(browser.name)) {
        return `browser name should be one of the following:${supportedBrowserKeysStr}\nReceived: '${browser.name}'.`
      }
      if (
        browser.name &&
        !browser.deviceName &&
        !browser.iosDeviceInfo &&
        (!browser.height || !browser.width)
      ) {
        return `browser '${browser.name}' should include 'height' and 'width' parameters.`
      }
      if (isEmulation(browser) && !isSupportsDeviceEmulation(browser.name)) {
        return `browser '${browser.name}' does not support mobile device emulation. Please remove 'mobile:true' or 'deviceName' from the browser configuration`
      }
    }

    function isSupportsDeviceEmulation(browserName) {
      return !browserName || /^chrome/.test(browserName)
    }

    function showBrowserWarning(browsersArr) {
      if (browsersArr.some(({name}) => name === BrowserType.EDGE)) {
        console.log(
          chalk.yellow(
            `The 'edge' option that is being used in your browsers' configuration will soon be deprecated. Please change it to either 'edgelegacy' for the legacy version or to 'edgechromium' for the new Chromium-based version. Please note, when using the built-in BrowserType enum, then the values are BrowserType.EDGE_LEGACY and BrowserType.EDGE_CHROMIUM, respectively.`,
          ),
        )
      }
    }
  }
}

function mergeBatchProperties({batch, batchId, batchName, batchSequence, batchNotify}) {
  const isGeneratedId = batchId !== undefined ? false : batch.getIsGeneratedId()
  return new BatchInfo({
    id: batchId !== undefined ? batchId : batch.getId(),
    name: batchName !== undefined ? batchName : batch.getName(),
    sequenceName: batchSequence !== undefined ? batchSequence : batch.getSequenceName(),
    notifyOnCompletion: batchNotify !== undefined ? batchNotify : batch.getNotifyOnCompletion(),
    properties: batch.getProperties(),
    isGeneratedId,
  })
}

module.exports = makeOpenEyes


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/putResources.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/putResources.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const throat = __webpack_require__(/*! throat */ "./node_modules/throat/index.js")
const toCacheEntry = __webpack_require__(/*! ./toCacheEntry */ "./node_modules/@applitools/visual-grid-client/src/sdk/toCacheEntry.js")
const resourceType = __webpack_require__(/*! ./resourceType */ "./node_modules/@applitools/visual-grid-client/src/sdk/resourceType.js")

function makePutResources({
  logger,
  doPutResource,
  doCheckResources,
  resourceCache,
  fetchCache,
  timeout = 300,
  concurrency = 100,
}) {
  const putResource = throat(concurrency, doPutResource)
  const uploadedResources = new Set()
  const requestedResources = new Map()
  let pendingResources = new Map()
  let throttleTimer = false

  return async function(resources = []) {
    const promises = resources.map(resource => {
      const hash = resource.getContent() ? resource.getSha256Hash() : null
      if (!hash || uploadedResources.has(hash)) {
        return Promise.resolve()
      } else if (requestedResources.has(hash)) {
        return Promise.resolve(requestedResources.get(hash))
      } else {
        const promise = new Promise((resolve, reject) => {
          pendingResources.set(resource, {
            resolve: result => {
              requestedResources.delete(hash)
              uploadedResources.add(hash)
              return resolve(result)
            },
            reject: err => {
              requestedResources.delete(hash)
              return reject(err)
            },
          })
        })
        requestedResources.set(hash, promise)
        return promise
      }
    }, [])
    if (!throttleTimer) {
      throttleTimer = true
      setTimeout(() => {
        putResources(pendingResources)
        pendingResources = new Map()
        throttleTimer = false
      }, timeout)
    }
    const result = await Promise.all(promises)
    for (const resource of resources) {
      const url = resource.getUrl()
      logger.verbose('setting resource to cache: ', url)
      fetchCache.remove(url)
      const doesRequireProcessing = Boolean(resourceType(resource.getContentType()))
      resourceCache.setValue(url, toCacheEntry(resource, doesRequireProcessing))
    }
    return result
  }

  async function putResources(requests) {
    try {
      const resources = Array.from(requests.keys())
      const presentedResources = await doCheckResources(resources)

      for (const [index, presented] of presentedResources.entries()) {
        const resource = resources[index]
        const {resolve, reject} = requests.get(resource)
        if (presented) {
          resolve()
        } else {
          putResource(resource).then(resolve, reject)
        }
      }
    } catch (err) {
      requests.forEach(({reject}) => reject(err))
    }
  }
}

module.exports = makePutResources


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/render.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/render.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const {RenderStatus} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

function makeRender({logger, doRenderBatch, timeout = 300}) {
  let pendingRequests = new Map()
  let throttleTimer = false

  return function(renderRequest) {
    return new Promise(async (resolve, reject) => {
      pendingRequests.set(renderRequest, {resolve, reject})
      if (!throttleTimer) {
        throttleTimer = true
        setTimeout(() => {
          renderBatch(pendingRequests)
          pendingRequests = new Map()
          throttleTimer = false
        }, timeout)
      }
    })
  }

  async function renderBatch(pendingRequests) {
    try {
      const renderRequests = Array.from(pendingRequests.keys())
      const runningRenders = await doRenderBatch(renderRequests)

      runningRenders.forEach((runningRender, index) => {
        const {resolve, reject} = pendingRequests.get(renderRequests[index])
        if (runningRender.getRenderStatus() === RenderStatus.NEED_MORE_RESOURCES) {
          logger.log('unexpectedly got "need more resources" on second render request')
          reject(new Error('Unexpected error while taking screenshot'))
        } else {
          resolve(runningRender.getRenderId())
        }
      })
    } catch (err) {
      pendingRequests.forEach(({reject}) => reject(err))
    }
  }
}

module.exports = makeRender


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/renderer.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/renderer.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* global fetch */


const makeGetAllResources = __webpack_require__(/*! ./getAllResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/getAllResources.js")
const extractCssResources = __webpack_require__(/*! ./extractCssResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/extractCssResources.js")
const makeFetchResource = __webpack_require__(/*! ./fetchResource */ "./node_modules/@applitools/visual-grid-client/src/sdk/fetchResource.js")
const createResourceCache = __webpack_require__(/*! ./createResourceCache */ "./node_modules/@applitools/visual-grid-client/src/sdk/createResourceCache.js")
const makeWaitForRenderedStatus = __webpack_require__(/*! ./waitForRenderedStatus */ "./node_modules/@applitools/visual-grid-client/src/sdk/waitForRenderedStatus.js")
const makeGetRenderStatus = __webpack_require__(/*! ./getRenderStatus */ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderStatus.js")
const makePutResources = __webpack_require__(/*! ./putResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/putResources.js")
const makeRender = __webpack_require__(/*! ./render */ "./node_modules/@applitools/visual-grid-client/src/sdk/render.js")
const makeCreateRGridDOMAndGetResourceMapping = __webpack_require__(/*! ./createRGridDOMAndGetResourceMapping */ "./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDOMAndGetResourceMapping.js")
const getRenderMethods = __webpack_require__(/*! ./getRenderMethods */ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderMethods.js")
const {createRenderWrapper} = __webpack_require__(/*! ./wrapperUtils */ "./node_modules/@applitools/visual-grid-client/src/sdk/wrapperUtils.js")
const {ptimeoutWithError} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const {Logger} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

const fetchResourceTimeout = 120000

function makeRenderer({apiKey, showLogs, serverUrl, proxy, renderingInfo, renderTimeout}) {
  const logger = new Logger(showLogs)

  const renderWrapper = createRenderWrapper({
    apiKey,
    logHandler: logger.getLogHandler(),
    serverUrl,
    proxy,
  })

  const {doRenderBatch, doCheckResources, doPutResource, doGetRenderStatus} = getRenderMethods(
    renderWrapper,
  )
  renderWrapper.setRenderingInfo(renderingInfo)

  const resourceCache = createResourceCache()
  const fetchCache = createResourceCache()
  const fetchWithTimeout = url =>
    ptimeoutWithError(fetch(url), fetchResourceTimeout, 'fetch timed out')
  const fetchResource = makeFetchResource({logger, fetchCache, fetch: fetchWithTimeout})
  const putResources = makePutResources({
    logger,
    doPutResource,
    doCheckResources,
    fetchCache,
    resourceCache,
  })
  const render = makeRender({logger, doRenderBatch, timeout: renderTimeout})
  const getRenderStatus = makeGetRenderStatus({logger, doGetRenderStatus})
  const waitForRenderedStatus = makeWaitForRenderedStatus({logger, getRenderStatus})
  const getAllResources = makeGetAllResources({
    resourceCache,
    extractCssResources,
    fetchResource,
    logger,
  })
  const createRGridDOMAndGetResourceMapping = makeCreateRGridDOMAndGetResourceMapping({
    getAllResources,
  })

  return {createRGridDOMAndGetResourceMapping, render: putResourcesAndRender, waitForRenderedStatus}

  async function putResourcesAndRender(renderRequest) {
    await putResources([renderRequest.getDom(), ...renderRequest.getResources()])
    return render(renderRequest)
  }
}

module.exports = makeRenderer


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/renderingGridClient.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/renderingGridClient.js ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* global fetch */


const {
  BatchInfo,
  Logger,
  GeneralUtils: {backwardCompatible, deprecationWarning},
  RunnerStartedEvent,
} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const {ptimeoutWithError, presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")
const makeGetAllResources = __webpack_require__(/*! ./getAllResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/getAllResources.js")
const extractCssResources = __webpack_require__(/*! ./extractCssResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/extractCssResources.js")
const makeFetchResource = __webpack_require__(/*! ./fetchResource */ "./node_modules/@applitools/visual-grid-client/src/sdk/fetchResource.js")
const createResourceCache = __webpack_require__(/*! ./createResourceCache */ "./node_modules/@applitools/visual-grid-client/src/sdk/createResourceCache.js")
const makeWaitForRenderedStatus = __webpack_require__(/*! ./waitForRenderedStatus */ "./node_modules/@applitools/visual-grid-client/src/sdk/waitForRenderedStatus.js")
const makeGetRenderStatus = __webpack_require__(/*! ./getRenderStatus */ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderStatus.js")
const makePutResources = __webpack_require__(/*! ./putResources */ "./node_modules/@applitools/visual-grid-client/src/sdk/putResources.js")
const makeGetRenderJobInfo = __webpack_require__(/*! ./getRenderJobInfo */ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderJobInfo.js")
const makeRender = __webpack_require__(/*! ./render */ "./node_modules/@applitools/visual-grid-client/src/sdk/render.js")
const makeOpenEyes = __webpack_require__(/*! ./openEyes */ "./node_modules/@applitools/visual-grid-client/src/sdk/openEyes.js")
const makeCreateRGridDOMAndGetResourceMapping = __webpack_require__(/*! ./createRGridDOMAndGetResourceMapping */ "./node_modules/@applitools/visual-grid-client/src/sdk/createRGridDOMAndGetResourceMapping.js")
const makeCloseBatch = __webpack_require__(/*! ./makeCloseBatch */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeCloseBatch.js")
const makeTestWindow = __webpack_require__(/*! ./makeTestWindow */ "./node_modules/@applitools/visual-grid-client/src/sdk/makeTestWindow.js")
const transactionThroat = __webpack_require__(/*! ./transactionThroat */ "./node_modules/@applitools/visual-grid-client/src/sdk/transactionThroat.js")
const getRenderMethods = __webpack_require__(/*! ./getRenderMethods */ "./node_modules/@applitools/visual-grid-client/src/sdk/getRenderMethods.js")
const makeGlobalState = __webpack_require__(/*! ./globalState */ "./node_modules/@applitools/visual-grid-client/src/sdk/globalState.js")

const {
  createRenderWrapper,
  authorizationErrMsg,
  blockedAccountErrMsg,
  badRequestErrMsg,
} = __webpack_require__(/*! ./wrapperUtils */ "./node_modules/@applitools/visual-grid-client/src/sdk/wrapperUtils.js")
const getFinalConcurrency = __webpack_require__(/*! ./getFinalConcurrency */ "./node_modules/@applitools/visual-grid-client/src/sdk/getFinalConcurrency.js")
__webpack_require__(/*! @applitools/isomorphic-fetch */ "./node_modules/@applitools/isomorphic-fetch/fetch-npm-browserify.js")

// TODO when supporting only Node version >= 8.6.0 then we can use ...config for all the params that are just passed on to makeOpenEyes
function makeRenderingGridClient({
  renderWrapper, // for tests
  logger,
  showLogs,
  renderTimeout,
  renderJobInfoTimeout,
  putResourcesTimeout,
  renderStatusTimeout,
  renderStatusInterval,
  concurrency,
  testConcurrency,
  appName,
  browser = {width: 1024, height: 768},
  apiKey,
  saveDebugData,
  batch,
  batchId,
  batchName,
  batchSequenceName,
  batchSequence,
  properties,
  baselineBranchName,
  baselineBranch,
  baselineEnvName,
  baselineName,
  envName,
  ignoreCaret,
  isDisabled,
  matchLevel,
  accessibilitySettings,
  useDom,
  enablePatterns,
  ignoreDisplacements,
  parentBranchName,
  parentBranch,
  branchName,
  branch,
  proxy,
  saveDiffs,
  saveFailedTests,
  saveNewTests,
  compareWithParentBranch,
  ignoreBaseline,
  serverUrl,
  agentId,
  fetchResourceTimeout = 120000,
  userAgent,
  notifyOnCompletion,
  batchNotify,
  globalState: _globalState,
  dontCloseBatches,
  visualGridOptions,
  concurrentRendersPerTest = 1,
  ignoreGitMergeBase,
}) {
  if (saveDebugData) {
    deprecationWarning({deprecatedThing: 'saveDebugData', isDead: true})
  }

  let finalConcurrency = getFinalConcurrency({concurrency, testConcurrency})
  let defaultConcurrency
  if (!finalConcurrency) {
    finalConcurrency = defaultConcurrency = 5
  }

  logger = logger || new Logger(showLogs, 'visual-grid-client')
  logger.verbose('vgc concurrency is', finalConcurrency)
  ;({batchSequence, baselineBranch, parentBranch, branch, batchNotify} = backwardCompatible(
    [{batchSequenceName}, {batchSequence}],
    [{baselineBranchName}, {baselineBranch}],
    [{parentBranchName}, {parentBranch}],
    [{branchName}, {branch}],
    [{notifyOnCompletion}, {batchNotify}],
    logger,
  ))

  let initialDataPromise
  const eyesTransactionThroat = transactionThroat(finalConcurrency)
  renderWrapper =
    renderWrapper ||
    createRenderWrapper({
      apiKey,
      logHandler: logger.getLogHandler(),
      serverUrl,
      proxy,
      agentId,
    })
  const {
    doGetRenderInfo,
    doRenderBatch,
    doCheckResources,
    doPutResource,
    doGetRenderStatus,
    setRenderingInfo,
    doGetRenderJobInfo,
    doLogEvents,
    doGetEmulatedDevicesSizes,
    doGetIosDevicesSizes,
  } = getRenderMethods(renderWrapper)

  const resourceCache = createResourceCache()
  const fetchCache = createResourceCache()

  const fetchWithTimeout = (url, opt) =>
    ptimeoutWithError(fetch(url, opt), fetchResourceTimeout, 'fetch timed out')
  const fetchResource = makeFetchResource({logger, fetchCache, fetch: fetchWithTimeout})
  const putResources = makePutResources({
    logger,
    doPutResource,
    doCheckResources,
    fetchCache,
    resourceCache,
    timeout: putResourcesTimeout,
  })
  const render = makeRender({logger, doRenderBatch, timeout: renderTimeout})
  const getRenderJobInfo = makeGetRenderJobInfo({doGetRenderJobInfo, timeout: renderJobInfoTimeout})
  const getRenderStatus = makeGetRenderStatus({
    logger,
    doGetRenderStatus,
    getStatusInterval: renderStatusInterval,
  })
  const waitForRenderedStatus = makeWaitForRenderedStatus({
    timeout: renderStatusTimeout,
    logger,
    getRenderStatus,
  })
  const getAllResources = makeGetAllResources({
    resourceCache,
    extractCssResources,
    fetchResource,
    logger,
  })
  const createRGridDOMAndGetResourceMapping = makeCreateRGridDOMAndGetResourceMapping({
    getAllResources,
  })

  const batchInfo = batch
    ? new BatchInfo(batch)
    : new BatchInfo({
        name: batchName,
        id: batchId,
        sequenceName: batchSequence,
        notifyOnCompletion: batchNotify,
      })

  const globalState = _globalState || makeGlobalState({logger})

  const openConfig = {
    appName,
    browser,
    apiKey,
    batch: batchInfo,
    properties,
    baselineBranch,
    baselineEnvName,
    baselineName,
    envName,
    ignoreCaret,
    isDisabled,
    matchLevel,
    accessibilitySettings,
    useDom,
    enablePatterns,
    ignoreDisplacements,
    parentBranch,
    branch,
    proxy,
    saveDiffs,
    saveFailedTests,
    saveNewTests,
    compareWithParentBranch,
    ignoreBaseline,
    serverUrl,
    logger,
    putResources,
    getRenderJobInfo,
    render,
    waitForRenderedStatus,
    concurrentRendersPerTest,
    getInitialData,
    createRGridDOMAndGetResourceMapping,
    eyesTransactionThroat,
    agentId,
    userAgent,
    globalState,
    visualGridOptions,
    ignoreGitMergeBase,
  }

  const openEyes = makeOpenEyes(openConfig)
  const closeBatch = makeCloseBatch({globalState, dontCloseBatches, isDisabled})
  const testWindow = makeTestWindow(openConfig)

  let emulatedDevicesSizesPromise
  let iosDevicesSizesPromise

  return {
    openEyes,
    closeBatch,
    globalState,
    testWindow,
    getResourceUrlsInCache,
    getIosDevicesSizes,
    getEmulatedDevicesSizes,
    getSetRenderInfo,
  }

  async function getInitialData() {
    if (initialDataPromise) return initialDataPromise

    initialDataPromise = doGetInitialData()
    return initialDataPromise
  }

  async function doGetInitialData() {
    if (!renderWrapper.getApiKey()) {
      renderWrapper.setApiKey(apiKey)
    }

    const runnerStaredEvent = RunnerStartedEvent({concurrency, testConcurrency, defaultConcurrency})
    logger.verbose('runnerStartedEvent', runnerStaredEvent)
    const [[err, renderInfo]] = await Promise.all([
      presult(doGetRenderInfo()),
      doLogEvents([runnerStaredEvent]).catch(err =>
        logger.log('error when logging batchStart', err),
      ),
    ])

    if (err) {
      if (err.response) {
        if (err.response.status === 401) {
          throw new Error(authorizationErrMsg)
        }
        if (err.response.status === 403) {
          throw new Error(blockedAccountErrMsg)
        }
        if (err.response.status === 400) {
          throw new Error(badRequestErrMsg)
        }
      }

      throw err
    }

    setRenderingInfo(renderInfo)
    return {renderInfo}
  }

  async function getEmulatedDevicesSizes() {
    if (!emulatedDevicesSizesPromise) {
      await getInitialData()
      emulatedDevicesSizesPromise = doGetEmulatedDevicesSizes()
    }
    return emulatedDevicesSizesPromise
  }

  async function getIosDevicesSizes() {
    if (!iosDevicesSizesPromise) {
      await getInitialData()
      iosDevicesSizesPromise = doGetIosDevicesSizes()
    }
    return iosDevicesSizesPromise
  }

  function getResourceUrlsInCache() {
    return resourceCache.getKeys()
  }

  async function getSetRenderInfo() {
    return await getInitialData()
  }
}

module.exports = makeRenderingGridClient


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/resourceType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/resourceType.js ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";


function resourceType(contentType) {
  if (/text\/css/.test(contentType)) {
    return 'CSS'
  } else if (/image\/svg/.test(contentType)) {
    return 'SVG'
  }
}

module.exports = resourceType


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/supportedBrowsers.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/supportedBrowsers.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const translateBrowserNameVersion = __webpack_require__(/*! ./translateBrowserNameVersion */ "./node_modules/@applitools/visual-grid-client/src/sdk/translateBrowserNameVersion.js")

function getSupportedBrowsers() {
  // This is a map from the value we get from the user to the value we send to the visual grid
  // user --> VG
  const supportedBrowsers = {
    chrome: 'chrome',
    'chrome-canary': 'chrome-canary',
    firefox: 'firefox',
    ie10: 'ie10',
    ie11: 'ie11',
    edge: 'edge', // excluded in openEyes for the supported browsers message to the user
    edgechromium: 'edgechromium',
    edgelegacy: 'edgelegacy',
    ie: 'ie',
    safari: 'safari',
    'safari-earlyaccess': 'safari-earlyaccess',
    [translateBrowserNameVersion('chrome-1')]: 'chrome-1',
    [translateBrowserNameVersion('chrome-2')]: 'chrome-2',
    [translateBrowserNameVersion('firefox-1')]: 'firefox-1',
    [translateBrowserNameVersion('firefox-2')]: 'firefox-2',
    [translateBrowserNameVersion('safari-1')]: 'safari-1',
    [translateBrowserNameVersion('safari-2')]: 'safari-2',
    [translateBrowserNameVersion('edgechromium-1')]: 'edgechromium-1',
    [translateBrowserNameVersion('edgechromium-2')]: 'edgechromium-2',
  }

  return supportedBrowsers
}

module.exports = getSupportedBrowsers


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/takeScreenshot.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/takeScreenshot.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const makeRenderer = __webpack_require__(/*! ./renderer */ "./node_modules/@applitools/visual-grid-client/src/sdk/renderer.js")
const createRenderRequest = __webpack_require__(/*! ./createRenderRequest */ "./node_modules/@applitools/visual-grid-client/src/sdk/createRenderRequest.js")
const {RenderingInfo, deserializeDomSnapshotResult} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")

__webpack_require__(/*! @applitools/isomorphic-fetch */ "./node_modules/@applitools/isomorphic-fetch/fetch-npm-browserify.js") // TODO can just use node-fetch

async function takeScreenshot({
  showLogs,
  apiKey,
  serverUrl,
  proxy,
  renderInfo,
  snapshot,
  url,
  browsers = [{width: 1024, height: 768}],
  sizeMode = 'full-page',
  selector,
  region,
  scriptHooks,
}) {
  const snapshots = Array.isArray(snapshot) ? snapshot : Array(browsers.length).fill(snapshot)

  const renderingInfo = new RenderingInfo({
    serviceUrl: renderInfo.serviceUrl,
    accessToken: renderInfo.accessToken,
    resultsUrl: renderInfo.resultsUrl,
  })

  const {createRGridDOMAndGetResourceMapping, render, waitForRenderedStatus} = makeRenderer({
    apiKey,
    showLogs,
    serverUrl,
    proxy,
    renderingInfo,
  })

  const renderRequests = await Promise.all(
    snapshots.map(async (snapshot, index) => {
      const {resourceUrls, resourceContents, frames, cdt} = deserializeDomSnapshotResult(snapshot)
      const {rGridDom, allResources} = await createRGridDOMAndGetResourceMapping({
        resourceUrls,
        resourceContents,
        frames,
        cdt,
      })
      return createRenderRequest({
        url,
        dom: rGridDom,
        resources: Object.values(allResources),
        browser: browsers[index],
        renderInfo: renderingInfo,
        sizeMode,
        selector,
        region,
        scriptHooks,
        sendDom: true,
      })
    }),
  )

  const renderIds = await Promise.all(renderRequests.map(render))

  const renderStatusResults = await Promise.all(
    renderIds.map(renderId =>
      waitForRenderedStatus(renderId, () => false).then(({imageLocation}) => ({
        imageLocation,
        renderId,
      })),
    ),
  )

  return renderStatusResults
}

module.exports = takeScreenshot


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/toCacheEntry.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/toCacheEntry.js ***!
  \*****************************************************************************/
/***/ ((module) => {

"use strict";


function toCacheEntry(rGridResource, isContentNeeded = true) {
  if (rGridResource.getErrorStatusCode()) {
    return {
      url: rGridResource.getUrl(),
      errorStatusCode: rGridResource.getErrorStatusCode(),
    }
  } else {
    return {
      url: rGridResource.getUrl(),
      type: rGridResource.getContentType(),
      hash: rGridResource.getSha256Hash(),
      content: isContentNeeded ? rGridResource.getContent() : undefined,
    }
  }
}

module.exports = toCacheEntry


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/toUnAnchoredUri.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/toUnAnchoredUri.js ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";


function toUnAnchoredUri(url) {
  const m = url && url.match(/(^[^#]*)/)
  const res = (m && m[1]) || url
  return (res && res.replace(/\?\s*$/, '?')) || url
}

module.exports = toUnAnchoredUri


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/toUriEncoding.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/toUriEncoding.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";


function toUriEncoding(url) {
  const result =
    (url &&
      url.replace(/(\\[0-9a-fA-F]{1,6}\s?)/g, s => {
        const int = parseInt(s.substr(1).trim(), 16)
        return String.fromCodePoint(int)
      })) ||
    url
  return result
}

module.exports = toUriEncoding


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/transactionThroat.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/transactionThroat.js ***!
  \**********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const throatPkg = __webpack_require__(/*! throat */ "./node_modules/throat/index.js")

function transactionThroat(size) {
  const throat = throatPkg(size)
  return start

  function start(func) {
    let stop
    return {
      promise: throat(run),
      resolve: () => {
        if (stop) stop()
        else throw new Error('stopped transaction before it started') // TODO
      },
    }

    function run() {
      return new Promise(resolve => {
        stop = resolve
        func()
      })
    }
  }
}

module.exports = transactionThroat


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/translateBrowserNameVersion.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/translateBrowserNameVersion.js ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";


const VERSION_BACK_REGEX = /^(chrome|firefox|safari|edgechromium)\-(1|2)$/

function translateBrowserNameVersion(browserName) {
  if (VERSION_BACK_REGEX.test(browserName)) {
    return browserName.replace('1', 'one-version-back').replace('2', 'two-versions-back')
  }

  return browserName
}

module.exports = translateBrowserNameVersion


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/waitForRenderedStatus.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/waitForRenderedStatus.js ***!
  \**************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const {RenderStatus} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const {presult} = __webpack_require__(/*! @applitools/functional-commons */ "./node_modules/@applitools/functional-commons/src/functional-commons.js")

const psetTimeout = t =>
  new Promise(res => {
    setTimeout(res, t)
  })

const failMsg = (renderId, err) => {
  let msg = `failed to render screenshot${renderId ? ' ' + renderId : ''}`
  if (err) {
    msg = `${msg} got error: ${err}`
  }
  return msg
}

function makeWaitForRenderedStatus({timeout = 3600000, logger, getRenderStatus}) {
  return async function waitForRenderedStatus(renderId, stopCondition = () => {}) {
    return new Promise(async (resolve, reject) => {
      log(`waiting for ${renderId} to be rendered`)
      const startTime = Date.now()
      getRenderStatusJob()

      async function getRenderStatusJob() {
        if (stopCondition()) {
          return reject(new Error(`aborted render ${renderId}`))
        }

        if (Date.now() - startTime > timeout) {
          return reject(new Error(failMsg(renderId)))
        }

        const [err, rs] = await presult(getRenderStatus(renderId))

        if (err) {
          log(`error during getRenderStatus for ${renderId}: ${err}`)
          return getRenderStatusJob()
        }

        log(`render status result for ${renderId}: ${rs}`)

        const status = rs.getStatus()
        if (status === RenderStatus.ERROR) {
          return reject(new Error(failMsg(renderId, rs.getError())))
        } else if (status === RenderStatus.RENDERED) {
          return resolve(rs.toJSON())
        }

        await psetTimeout(0)
        return getRenderStatusJob()
      }
    })

    function log(msg) {
      logger.verbose(`[waitForRenderedStatus] ${msg}`)
    }
  }
}

module.exports = makeWaitForRenderedStatus
module.exports.failMsg = failMsg


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/sdk/wrapperUtils.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/sdk/wrapperUtils.js ***!
  \*****************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

const EyesWrapper = __webpack_require__(/*! ./EyesWrapper */ "./node_modules/@applitools/visual-grid-client/src/sdk/EyesWrapper.js")
const {RectangleSize, TypeUtils} = __webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js")
const getDeviceInfoFromBrowserConfig = __webpack_require__(/*! ./getDeviceInfoFromBrowserConfig */ "./node_modules/@applitools/visual-grid-client/src/sdk/getDeviceInfoFromBrowserConfig.js")

function initWrappers({count, apiKey, logHandler, getBatchInfoWithCache}) {
  return Array.from(
    new Array(count),
    () => new EyesWrapper({apiKey, logHandler, getBatchInfoWithCache}),
  )
}

function validateAndAddProperties(wrapper, properties) {
  if (properties) {
    if (Array.isArray(properties)) {
      properties.forEach(prop => {
        if (typeof prop === 'object') {
          if (TypeUtils.hasMethod(prop, ['getName', 'getValue'])) {
            wrapper.addProperty(prop.getName(), prop.getValue())
          } else {
            wrapper.addProperty(prop.name, prop.value)
          }
        } else {
          throw new Error(`${propertiesFailMsg}. Type of property inside array was ${typeof prop}`)
        }
      })
    } else {
      throw new Error(`${propertiesFailMsg}. Type of properties argument was ${typeof properties}`)
    }
  }
}

function configureWrappers({
  wrappers,
  browsers,
  isDisabled,
  displayName,
  batch,
  properties,
  baselineBranch,
  baselineEnvName,
  baselineName,
  envName,
  ignoreCaret,
  matchLevel,
  accessibilitySettings,
  parentBranch,
  branch,
  proxy,
  saveDiffs,
  saveFailedTests,
  saveNewTests,
  compareWithParentBranch,
  ignoreBaseline,
  serverUrl,
  agentId,
  useDom,
  enablePatterns,
  ignoreDisplacements,
  ignoreGitMergeBase,
  agentRunId,
}) {
  for (let i = 0, ii = wrappers.length; i < ii; i++) {
    const wrapper = wrappers[i]
    const browser = browsers[i]

    const deviceInfo = getDeviceInfoFromBrowserConfig(browser)
    wrapper.setDeviceInfo(deviceInfo)

    validateAndAddProperties(wrapper, properties)
    wrapper.setBatch(batch)

    displayName !== undefined && wrapper.setDisplayName(displayName)
    baselineBranch !== undefined && wrapper.setBaselineBranchName(baselineBranch)
    baselineEnvName !== undefined && wrapper.setBaselineEnvName(baselineEnvName)
    baselineName !== undefined && wrapper.setBaselineName(baselineName)
    envName !== undefined && wrapper.setEnvName(envName)
    ignoreCaret !== undefined && wrapper.setIgnoreCaret(ignoreCaret)
    isDisabled !== undefined && wrapper.setIsDisabled(isDisabled)
    matchLevel !== undefined && wrapper.setMatchLevel(matchLevel)
    accessibilitySettings !== undefined && wrapper.setAccessibilityValidation(accessibilitySettings)
    useDom !== undefined && wrapper.setUseDom(useDom)
    enablePatterns !== undefined && wrapper.setEnablePatterns(enablePatterns)
    ignoreDisplacements !== undefined && wrapper.setIgnoreDisplacements(ignoreDisplacements)
    parentBranch !== undefined && wrapper.setParentBranchName(parentBranch)
    branch !== undefined && wrapper.setBranchName(branch)
    proxy !== undefined && wrapper.setProxy(proxy)
    saveDiffs !== undefined && wrapper.setSaveDiffs(saveDiffs)
    saveFailedTests !== undefined && wrapper.setSaveFailedTests(saveFailedTests)
    saveNewTests !== undefined && wrapper.setSaveNewTests(saveNewTests)
    compareWithParentBranch !== undefined &&
      wrapper.setCompareWithParentBranch(compareWithParentBranch)
    ignoreBaseline !== undefined && wrapper.setIgnoreBaseline(ignoreBaseline)
    serverUrl !== undefined && wrapper.setServerUrl(serverUrl)
    agentId !== undefined && wrapper.setBaseAgentId(agentId)
    ignoreGitMergeBase !== undefined && wrapper.setIgnoreGitMergeBase(ignoreGitMergeBase)
    agentRunId !== undefined && wrapper.setAgentRunId(agentRunId)
  }
}

function openWrappers({
  wrappers,
  browsers,
  appName,
  testName,
  eyesTransactionThroat,
  skipStartingSession,
}) {
  const openPromisesAndResolves = wrappers.map(() => {
    let resolve
    const promise = new Promise(r => (resolve = r))
    return {promise, resolve}
  })
  return wrappers
    .map((wrapper, i) => {
      const viewportSize = browsers[i].width && new RectangleSize(browsers[i])
      return eyesTransactionThroat(() =>
        wrapper
          .open({appName, testName, viewportSize, skipStartingSession})
          .then(openPromisesAndResolves[i].resolve),
      )
    })
    .reduce(
      (acc, {resolve}, i) => ({
        openEyesPromises: [...acc.openEyesPromises, openPromisesAndResolves[i].promise],
        resolveTests: [...acc.resolveTests, resolve],
      }),
      {
        openEyesPromises: [],
        resolveTests: [], // resolve hooks for jobs in eyesTransactionThroat
      },
    )
}

function createRenderWrapper({serverUrl, apiKey, logHandler, proxy, agentId}) {
  const wrapper = new EyesWrapper({apiKey, logHandler})
  serverUrl !== undefined && wrapper.setServerUrl(serverUrl)
  proxy !== undefined && wrapper.setProxy(proxy)
  agentId !== undefined && wrapper.setBaseAgentId(agentId)
  return wrapper
}

const apiKeyFailMsg =
  'APPLITOOLS_API_KEY env variable is missing. It is required to define this variable for Applitools visual tests to run successfully.'

const propertiesFailMsg =
  'Argument "properties" should be an array of objects, each one with a "name" and "value" properties'

const appNameFailMsg =
  'Argument "appName" is missing. It\'s possible to specify "appName" in either the config file, an env variable or by passing to the open method.'

const authorizationErrMsg = 'Unauthorized access to Eyes server. Please check your API key.'

const blockedAccountErrMsg =
  'Unable to access Eyes server. This might mean that your account is blocked. Please contact Applitools support.'

const badRequestErrMsg =
  'Unable to process request to Eyes server. This might mean that a proxy server is misconfigured. It\'s possible to specify "proxy" in either the config file or as an env variable.'

module.exports = {
  initWrappers,
  configureWrappers,
  openWrappers,
  createRenderWrapper,
  apiKeyFailMsg,
  propertiesFailMsg,
  authorizationErrMsg,
  appNameFailMsg,
  blockedAccountErrMsg,
  badRequestErrMsg,
}


/***/ }),

/***/ "./node_modules/@applitools/visual-grid-client/src/visual-grid-client.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@applitools/visual-grid-client/src/visual-grid-client.js ***!
  \*******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const makeVisualGridClient = __webpack_require__(/*! ./sdk/renderingGridClient */ "./node_modules/@applitools/visual-grid-client/src/sdk/renderingGridClient.js")
const configParams = __webpack_require__(/*! ./sdk/configParams */ "./node_modules/@applitools/visual-grid-client/src/sdk/configParams.js")
const takeScreenshot = __webpack_require__(/*! ./sdk/takeScreenshot */ "./node_modules/@applitools/visual-grid-client/src/sdk/takeScreenshot.js")

module.exports = {
  ...__webpack_require__(/*! @applitools/eyes-sdk-core/shared */ "./node_modules/@applitools/eyes-sdk-core/shared/index.js"),
  makeVisualGridClient,
  takeScreenshot,
  configParams,
}


/***/ }),

/***/ "./node_modules/@babel/code-frame/lib/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@babel/code-frame/lib/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.codeFrameColumns = codeFrameColumns;
exports.default = _default;

var _highlight = __webpack_require__(/*! @babel/highlight */ "./node_modules/@babel/highlight/lib/index.js");

let deprecationWarningShown = false;

function getDefs(chalk) {
  return {
    gutter: chalk.grey,
    marker: chalk.red.bold,
    message: chalk.red.bold
  };
}

const NEWLINE = /\r\n|[\n\r\u2028\u2029]/;

function getMarkerLines(loc, source, opts) {
  const startLoc = Object.assign({
    column: 0,
    line: -1
  }, loc.start);
  const endLoc = Object.assign({}, startLoc, loc.end);
  const {
    linesAbove = 2,
    linesBelow = 3
  } = opts || {};
  const startLine = startLoc.line;
  const startColumn = startLoc.column;
  const endLine = endLoc.line;
  const endColumn = endLoc.column;
  let start = Math.max(startLine - (linesAbove + 1), 0);
  let end = Math.min(source.length, endLine + linesBelow);

  if (startLine === -1) {
    start = 0;
  }

  if (endLine === -1) {
    end = source.length;
  }

  const lineDiff = endLine - startLine;
  const markerLines = {};

  if (lineDiff) {
    for (let i = 0; i <= lineDiff; i++) {
      const lineNumber = i + startLine;

      if (!startColumn) {
        markerLines[lineNumber] = true;
      } else if (i === 0) {
        const sourceLength = source[lineNumber - 1].length;
        markerLines[lineNumber] = [startColumn, sourceLength - startColumn + 1];
      } else if (i === lineDiff) {
        markerLines[lineNumber] = [0, endColumn];
      } else {
        const sourceLength = source[lineNumber - i].length;
        markerLines[lineNumber] = [0, sourceLength];
      }
    }
  } else {
    if (startColumn === endColumn) {
      if (startColumn) {
        markerLines[startLine] = [startColumn, 0];
      } else {
        markerLines[startLine] = true;
      }
    } else {
      markerLines[startLine] = [startColumn, endColumn - startColumn];
    }
  }

  return {
    start,
    end,
    markerLines
  };
}

function codeFrameColumns(rawLines, loc, opts = {}) {
  const highlighted = (opts.highlightCode || opts.forceColor) && (0, _highlight.shouldHighlight)(opts);
  const chalk = (0, _highlight.getChalk)(opts);
  const defs = getDefs(chalk);

  const maybeHighlight = (chalkFn, string) => {
    return highlighted ? chalkFn(string) : string;
  };

  const lines = rawLines.split(NEWLINE);
  const {
    start,
    end,
    markerLines
  } = getMarkerLines(loc, lines, opts);
  const hasColumns = loc.start && typeof loc.start.column === "number";
  const numberMaxWidth = String(end).length;
  const highlightedLines = highlighted ? (0, _highlight.default)(rawLines, opts) : rawLines;
  let frame = highlightedLines.split(NEWLINE).slice(start, end).map((line, index) => {
    const number = start + 1 + index;
    const paddedNumber = ` ${number}`.slice(-numberMaxWidth);
    const gutter = ` ${paddedNumber} |`;
    const hasMarker = markerLines[number];
    const lastMarkerLine = !markerLines[number + 1];

    if (hasMarker) {
      let markerLine = "";

      if (Array.isArray(hasMarker)) {
        const markerSpacing = line.slice(0, Math.max(hasMarker[0] - 1, 0)).replace(/[^\t]/g, " ");
        const numberOfMarkers = hasMarker[1] || 1;
        markerLine = ["\n ", maybeHighlight(defs.gutter, gutter.replace(/\d/g, " ")), " ", markerSpacing, maybeHighlight(defs.marker, "^").repeat(numberOfMarkers)].join("");

        if (lastMarkerLine && opts.message) {
          markerLine += " " + maybeHighlight(defs.message, opts.message);
        }
      }

      return [maybeHighlight(defs.marker, ">"), maybeHighlight(defs.gutter, gutter), line.length > 0 ? ` ${line}` : "", markerLine].join("");
    } else {
      return ` ${maybeHighlight(defs.gutter, gutter)}${line.length > 0 ? ` ${line}` : ""}`;
    }
  }).join("\n");

  if (opts.message && !hasColumns) {
    frame = `${" ".repeat(numberMaxWidth + 1)}${opts.message}\n${frame}`;
  }

  if (highlighted) {
    return chalk.reset(frame);
  } else {
    return frame;
  }
}

function _default(rawLines, lineNumber, colNumber, opts = {}) {
  if (!deprecationWarningShown) {
    deprecationWarningShown = true;
    const message = "Passing lineNumber and colNumber is deprecated to @babel/code-frame. Please use `codeFrameColumns`.";

    if (process.emitWarning) {
      process.emitWarning(message, "DeprecationWarning");
    } else {
      const deprecationError = new Error(message);
      deprecationError.name = "DeprecationWarning";
      console.warn(new Error(message));
    }
  }

  colNumber = Math.max(colNumber, 0);
  const location = {
    start: {
      column: colNumber,
      line: lineNumber
    }
  };
  return codeFrameColumns(rawLines, location, opts);
}

/***/ }),

/***/ "./node_modules/@babel/helper-validator-identifier/lib/identifier.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babel/helper-validator-identifier/lib/identifier.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isIdentifierStart = isIdentifierStart;
exports.isIdentifierChar = isIdentifierChar;
exports.isIdentifierName = isIdentifierName;
let nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u08a0-\u08b4\u08b6-\u08c7\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\u9ffc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7bf\ua7c2-\ua7ca\ua7f5-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";
let nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf\u1ac0\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f";
const nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
const nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
const astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 157, 310, 10, 21, 11, 7, 153, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 107, 20, 28, 22, 13, 52, 76, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 85, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 230, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 35, 56, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 190, 0, 80, 921, 103, 110, 18, 195, 2749, 1070, 4050, 582, 8634, 568, 8, 30, 114, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8952, 286, 50, 2, 18, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 2357, 44, 11, 6, 17, 0, 370, 43, 1301, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42717, 35, 4148, 12, 221, 3, 5761, 15, 7472, 3104, 541, 1507, 4938];
const astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 154, 10, 176, 2, 54, 14, 32, 9, 16, 3, 46, 10, 54, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 161, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 19306, 9, 135, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 5319, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 262, 6, 10, 9, 419, 13, 1495, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

function isInAstralSet(code, set) {
  let pos = 0x10000;

  for (let i = 0, length = set.length; i < length; i += 2) {
    pos += set[i];
    if (pos > code) return false;
    pos += set[i + 1];
    if (pos >= code) return true;
  }

  return false;
}

function isIdentifierStart(code) {
  if (code < 65) return code === 36;
  if (code <= 90) return true;
  if (code < 97) return code === 95;
  if (code <= 122) return true;

  if (code <= 0xffff) {
    return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code));
  }

  return isInAstralSet(code, astralIdentifierStartCodes);
}

function isIdentifierChar(code) {
  if (code < 48) return code === 36;
  if (code < 58) return true;
  if (code < 65) return false;
  if (code <= 90) return true;
  if (code < 97) return code === 95;
  if (code <= 122) return true;

  if (code <= 0xffff) {
    return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code));
  }

  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
}

function isIdentifierName(name) {
  let isFirst = true;

  for (let i = 0; i < name.length; i++) {
    let cp = name.charCodeAt(i);

    if ((cp & 0xfc00) === 0xd800 && i + 1 < name.length) {
      const trail = name.charCodeAt(++i);

      if ((trail & 0xfc00) === 0xdc00) {
        cp = 0x10000 + ((cp & 0x3ff) << 10) + (trail & 0x3ff);
      }
    }

    if (isFirst) {
      isFirst = false;

      if (!isIdentifierStart(cp)) {
        return false;
      }
    } else if (!isIdentifierChar(cp)) {
      return false;
    }
  }

  return !isFirst;
}

/***/ }),

/***/ "./node_modules/@babel/helper-validator-identifier/lib/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/helper-validator-identifier/lib/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "isIdentifierName", ({
  enumerable: true,
  get: function () {
    return _identifier.isIdentifierName;
  }
}));
Object.defineProperty(exports, "isIdentifierChar", ({
  enumerable: true,
  get: function () {
    return _identifier.isIdentifierChar;
  }
}));
Object.defineProperty(exports, "isIdentifierStart", ({
  enumerable: true,
  get: function () {
    return _identifier.isIdentifierStart;
  }
}));
Object.defineProperty(exports, "isReservedWord", ({
  enumerable: true,
  get: function () {
    return _keyword.isReservedWord;
  }
}));
Object.defineProperty(exports, "isStrictBindOnlyReservedWord", ({
  enumerable: true,
  get: function () {
    return _keyword.isStrictBindOnlyReservedWord;
  }
}));
Object.defineProperty(exports, "isStrictBindReservedWord", ({
  enumerable: true,
  get: function () {
    return _keyword.isStrictBindReservedWord;
  }
}));
Object.defineProperty(exports, "isStrictReservedWord", ({
  enumerable: true,
  get: function () {
    return _keyword.isStrictReservedWord;
  }
}));
Object.defineProperty(exports, "isKeyword", ({
  enumerable: true,
  get: function () {
    return _keyword.isKeyword;
  }
}));

var _identifier = __webpack_require__(/*! ./identifier */ "./node_modules/@babel/helper-validator-identifier/lib/identifier.js");

var _keyword = __webpack_require__(/*! ./keyword */ "./node_modules/@babel/helper-validator-identifier/lib/keyword.js");

/***/ }),

/***/ "./node_modules/@babel/helper-validator-identifier/lib/keyword.js":
/*!************************************************************************!*\
  !*** ./node_modules/@babel/helper-validator-identifier/lib/keyword.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isReservedWord = isReservedWord;
exports.isStrictReservedWord = isStrictReservedWord;
exports.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
exports.isStrictBindReservedWord = isStrictBindReservedWord;
exports.isKeyword = isKeyword;
const reservedWords = {
  keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
  strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
  strictBind: ["eval", "arguments"]
};
const keywords = new Set(reservedWords.keyword);
const reservedWordsStrictSet = new Set(reservedWords.strict);
const reservedWordsStrictBindSet = new Set(reservedWords.strictBind);

function isReservedWord(word, inModule) {
  return inModule && word === "await" || word === "enum";
}

function isStrictReservedWord(word, inModule) {
  return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
}

function isStrictBindOnlyReservedWord(word) {
  return reservedWordsStrictBindSet.has(word);
}

function isStrictBindReservedWord(word, inModule) {
  return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
}

function isKeyword(word) {
  return keywords.has(word);
}

/***/ }),

/***/ "./node_modules/@babel/highlight/lib/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@babel/highlight/lib/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.shouldHighlight = shouldHighlight;
exports.getChalk = getChalk;
exports.default = highlight;

var _jsTokens = __webpack_require__(/*! js-tokens */ "./node_modules/js-tokens/index.js");

var _helperValidatorIdentifier = __webpack_require__(/*! @babel/helper-validator-identifier */ "./node_modules/@babel/helper-validator-identifier/lib/index.js");

var _chalk = __webpack_require__(/*! chalk */ "./node_modules/@babel/highlight/node_modules/chalk/index.js");

const sometimesKeywords = new Set(["as", "async", "from", "get", "of", "set"]);

function getDefs(chalk) {
  return {
    keyword: chalk.cyan,
    capitalized: chalk.yellow,
    jsxIdentifier: chalk.yellow,
    punctuator: chalk.yellow,
    number: chalk.magenta,
    string: chalk.green,
    regex: chalk.magenta,
    comment: chalk.grey,
    invalid: chalk.white.bgRed.bold
  };
}

const NEWLINE = /\r\n|[\n\r\u2028\u2029]/;
const BRACKET = /^[()[\]{}]$/;
let tokenize;
{
  const JSX_TAG = /^[a-z][\w-]*$/i;

  const getTokenType = function (token, offset, text) {
    if (token.type === "name") {
      if ((0, _helperValidatorIdentifier.isKeyword)(token.value) || (0, _helperValidatorIdentifier.isStrictReservedWord)(token.value, true) || sometimesKeywords.has(token.value)) {
        return "keyword";
      }

      if (JSX_TAG.test(token.value) && (text[offset - 1] === "<" || text.substr(offset - 2, 2) == "</")) {
        return "jsxIdentifier";
      }

      if (token.value[0] !== token.value[0].toLowerCase()) {
        return "capitalized";
      }
    }

    if (token.type === "punctuator" && BRACKET.test(token.value)) {
      return "bracket";
    }

    if (token.type === "invalid" && (token.value === "@" || token.value === "#")) {
      return "punctuator";
    }

    return token.type;
  };

  tokenize = function* (text) {
    let match;

    while (match = _jsTokens.default.exec(text)) {
      const token = _jsTokens.matchToToken(match);

      yield {
        type: getTokenType(token, match.index, text),
        value: token.value
      };
    }
  };
}

function highlightTokens(defs, text) {
  let highlighted = "";

  for (const {
    type,
    value
  } of tokenize(text)) {
    const colorize = defs[type];

    if (colorize) {
      highlighted += value.split(NEWLINE).map(str => colorize(str)).join("\n");
    } else {
      highlighted += value;
    }
  }

  return highlighted;
}

function shouldHighlight(options) {
  return !!_chalk.supportsColor || options.forceColor;
}

function getChalk(options) {
  return options.forceColor ? new _chalk.constructor({
    enabled: true,
    level: 1
  }) : _chalk;
}

function highlight(code, options = {}) {
  if (shouldHighlight(options)) {
    const chalk = getChalk(options);
    const defs = getDefs(chalk);
    return highlightTokens(defs, code);
  } else {
    return code;
  }
}

/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/ansi-styles/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/ansi-styles/index.js ***!
  \*************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* module decorator */ module = __webpack_require__.nmd(module);

const colorConvert = __webpack_require__(/*! color-convert */ "./node_modules/@babel/highlight/node_modules/color-convert/index.js");

const wrapAnsi16 = (fn, offset) => function () {
	const code = fn.apply(colorConvert, arguments);
	return `\u001B[${code + offset}m`;
};

const wrapAnsi256 = (fn, offset) => function () {
	const code = fn.apply(colorConvert, arguments);
	return `\u001B[${38 + offset};5;${code}m`;
};

const wrapAnsi16m = (fn, offset) => function () {
	const rgb = fn.apply(colorConvert, arguments);
	return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
};

function assembleStyles() {
	const codes = new Map();
	const styles = {
		modifier: {
			reset: [0, 0],
			// 21 isn't widely supported and 22 does the same thing
			bold: [1, 22],
			dim: [2, 22],
			italic: [3, 23],
			underline: [4, 24],
			inverse: [7, 27],
			hidden: [8, 28],
			strikethrough: [9, 29]
		},
		color: {
			black: [30, 39],
			red: [31, 39],
			green: [32, 39],
			yellow: [33, 39],
			blue: [34, 39],
			magenta: [35, 39],
			cyan: [36, 39],
			white: [37, 39],
			gray: [90, 39],

			// Bright color
			redBright: [91, 39],
			greenBright: [92, 39],
			yellowBright: [93, 39],
			blueBright: [94, 39],
			magentaBright: [95, 39],
			cyanBright: [96, 39],
			whiteBright: [97, 39]
		},
		bgColor: {
			bgBlack: [40, 49],
			bgRed: [41, 49],
			bgGreen: [42, 49],
			bgYellow: [43, 49],
			bgBlue: [44, 49],
			bgMagenta: [45, 49],
			bgCyan: [46, 49],
			bgWhite: [47, 49],

			// Bright color
			bgBlackBright: [100, 49],
			bgRedBright: [101, 49],
			bgGreenBright: [102, 49],
			bgYellowBright: [103, 49],
			bgBlueBright: [104, 49],
			bgMagentaBright: [105, 49],
			bgCyanBright: [106, 49],
			bgWhiteBright: [107, 49]
		}
	};

	// Fix humans
	styles.color.grey = styles.color.gray;

	for (const groupName of Object.keys(styles)) {
		const group = styles[groupName];

		for (const styleName of Object.keys(group)) {
			const style = group[styleName];

			styles[styleName] = {
				open: `\u001B[${style[0]}m`,
				close: `\u001B[${style[1]}m`
			};

			group[styleName] = styles[styleName];

			codes.set(style[0], style[1]);
		}

		Object.defineProperty(styles, groupName, {
			value: group,
			enumerable: false
		});

		Object.defineProperty(styles, 'codes', {
			value: codes,
			enumerable: false
		});
	}

	const ansi2ansi = n => n;
	const rgb2rgb = (r, g, b) => [r, g, b];

	styles.color.close = '\u001B[39m';
	styles.bgColor.close = '\u001B[49m';

	styles.color.ansi = {
		ansi: wrapAnsi16(ansi2ansi, 0)
	};
	styles.color.ansi256 = {
		ansi256: wrapAnsi256(ansi2ansi, 0)
	};
	styles.color.ansi16m = {
		rgb: wrapAnsi16m(rgb2rgb, 0)
	};

	styles.bgColor.ansi = {
		ansi: wrapAnsi16(ansi2ansi, 10)
	};
	styles.bgColor.ansi256 = {
		ansi256: wrapAnsi256(ansi2ansi, 10)
	};
	styles.bgColor.ansi16m = {
		rgb: wrapAnsi16m(rgb2rgb, 10)
	};

	for (let key of Object.keys(colorConvert)) {
		if (typeof colorConvert[key] !== 'object') {
			continue;
		}

		const suite = colorConvert[key];

		if (key === 'ansi16') {
			key = 'ansi';
		}

		if ('ansi16' in suite) {
			styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
			styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
		}

		if ('ansi256' in suite) {
			styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
			styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
		}

		if ('rgb' in suite) {
			styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
			styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
		}
	}

	return styles;
}

// Make the export immutable
Object.defineProperty(module, 'exports', {
	enumerable: true,
	get: assembleStyles
});


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/chalk/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/chalk/index.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process */ "./node_modules/process/browser.js");

const escapeStringRegexp = __webpack_require__(/*! escape-string-regexp */ "./node_modules/escape-string-regexp/index.js");
const ansiStyles = __webpack_require__(/*! ansi-styles */ "./node_modules/@babel/highlight/node_modules/ansi-styles/index.js");
const stdoutColor = __webpack_require__(/*! supports-color */ "./node_modules/@babel/highlight/node_modules/supports-color/browser.js").stdout;

const template = __webpack_require__(/*! ./templates.js */ "./node_modules/@babel/highlight/node_modules/chalk/templates.js");

const isSimpleWindowsTerm = process.platform === 'win32' && !(process.env.TERM || '').toLowerCase().startsWith('xterm');

// `supportsColor.level` → `ansiStyles.color[name]` mapping
const levelMapping = ['ansi', 'ansi', 'ansi256', 'ansi16m'];

// `color-convert` models to exclude from the Chalk API due to conflicts and such
const skipModels = new Set(['gray']);

const styles = Object.create(null);

function applyOptions(obj, options) {
	options = options || {};

	// Detect level if not set manually
	const scLevel = stdoutColor ? stdoutColor.level : 0;
	obj.level = options.level === undefined ? scLevel : options.level;
	obj.enabled = 'enabled' in options ? options.enabled : obj.level > 0;
}

function Chalk(options) {
	// We check for this.template here since calling `chalk.constructor()`
	// by itself will have a `this` of a previously constructed chalk object
	if (!this || !(this instanceof Chalk) || this.template) {
		const chalk = {};
		applyOptions(chalk, options);

		chalk.template = function () {
			const args = [].slice.call(arguments);
			return chalkTag.apply(null, [chalk.template].concat(args));
		};

		Object.setPrototypeOf(chalk, Chalk.prototype);
		Object.setPrototypeOf(chalk.template, chalk);

		chalk.template.constructor = Chalk;

		return chalk.template;
	}

	applyOptions(this, options);
}

// Use bright blue on Windows as the normal blue color is illegible
if (isSimpleWindowsTerm) {
	ansiStyles.blue.open = '\u001B[94m';
}

for (const key of Object.keys(ansiStyles)) {
	ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');

	styles[key] = {
		get() {
			const codes = ansiStyles[key];
			return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, key);
		}
	};
}

styles.visible = {
	get() {
		return build.call(this, this._styles || [], true, 'visible');
	}
};

ansiStyles.color.closeRe = new RegExp(escapeStringRegexp(ansiStyles.color.close), 'g');
for (const model of Object.keys(ansiStyles.color.ansi)) {
	if (skipModels.has(model)) {
		continue;
	}

	styles[model] = {
		get() {
			const level = this.level;
			return function () {
				const open = ansiStyles.color[levelMapping[level]][model].apply(null, arguments);
				const codes = {
					open,
					close: ansiStyles.color.close,
					closeRe: ansiStyles.color.closeRe
				};
				return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
			};
		}
	};
}

ansiStyles.bgColor.closeRe = new RegExp(escapeStringRegexp(ansiStyles.bgColor.close), 'g');
for (const model of Object.keys(ansiStyles.bgColor.ansi)) {
	if (skipModels.has(model)) {
		continue;
	}

	const bgModel = 'bg' + model[0].toUpperCase() + model.slice(1);
	styles[bgModel] = {
		get() {
			const level = this.level;
			return function () {
				const open = ansiStyles.bgColor[levelMapping[level]][model].apply(null, arguments);
				const codes = {
					open,
					close: ansiStyles.bgColor.close,
					closeRe: ansiStyles.bgColor.closeRe
				};
				return build.call(this, this._styles ? this._styles.concat(codes) : [codes], this._empty, model);
			};
		}
	};
}

const proto = Object.defineProperties(() => {}, styles);

function build(_styles, _empty, key) {
	const builder = function () {
		return applyStyle.apply(builder, arguments);
	};

	builder._styles = _styles;
	builder._empty = _empty;

	const self = this;

	Object.defineProperty(builder, 'level', {
		enumerable: true,
		get() {
			return self.level;
		},
		set(level) {
			self.level = level;
		}
	});

	Object.defineProperty(builder, 'enabled', {
		enumerable: true,
		get() {
			return self.enabled;
		},
		set(enabled) {
			self.enabled = enabled;
		}
	});

	// See below for fix regarding invisible grey/dim combination on Windows
	builder.hasGrey = this.hasGrey || key === 'gray' || key === 'grey';

	// `__proto__` is used because we must return a function, but there is
	// no way to create a function with a different prototype
	builder.__proto__ = proto; // eslint-disable-line no-proto

	return builder;
}

function applyStyle() {
	// Support varags, but simply cast to string in case there's only one arg
	const args = arguments;
	const argsLen = args.length;
	let str = String(arguments[0]);

	if (argsLen === 0) {
		return '';
	}

	if (argsLen > 1) {
		// Don't slice `arguments`, it prevents V8 optimizations
		for (let a = 1; a < argsLen; a++) {
			str += ' ' + args[a];
		}
	}

	if (!this.enabled || this.level <= 0 || !str) {
		return this._empty ? '' : str;
	}

	// Turns out that on Windows dimmed gray text becomes invisible in cmd.exe,
	// see https://github.com/chalk/chalk/issues/58
	// If we're on Windows and we're dealing with a gray color, temporarily make 'dim' a noop.
	const originalDim = ansiStyles.dim.open;
	if (isSimpleWindowsTerm && this.hasGrey) {
		ansiStyles.dim.open = '';
	}

	for (const code of this._styles.slice().reverse()) {
		// Replace any instances already present with a re-opening code
		// otherwise only the part of the string until said closing code
		// will be colored, and the rest will simply be 'plain'.
		str = code.open + str.replace(code.closeRe, code.open) + code.close;

		// Close the styling before a linebreak and reopen
		// after next line to fix a bleed issue on macOS
		// https://github.com/chalk/chalk/pull/92
		str = str.replace(/\r?\n/g, `${code.close}$&${code.open}`);
	}

	// Reset the original `dim` if we changed it to work around the Windows dimmed gray issue
	ansiStyles.dim.open = originalDim;

	return str;
}

function chalkTag(chalk, strings) {
	if (!Array.isArray(strings)) {
		// If chalk() was called by itself or with a string,
		// return the string itself as a string.
		return [].slice.call(arguments, 1).join(' ');
	}

	const args = [].slice.call(arguments, 2);
	const parts = [strings.raw[0]];

	for (let i = 1; i < strings.length; i++) {
		parts.push(String(args[i - 1]).replace(/[{}\\]/g, '\\$&'));
		parts.push(String(strings.raw[i]));
	}

	return template(chalk, parts.join(''));
}

Object.defineProperties(Chalk.prototype, styles);

module.exports = Chalk(); // eslint-disable-line new-cap
module.exports.supportsColor = stdoutColor;
module.exports.default = module.exports; // For TypeScript


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/chalk/templates.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/chalk/templates.js ***!
  \***********************************************************************/
/***/ ((module) => {

"use strict";

const TEMPLATE_REGEX = /(?:\\(u[a-f\d]{4}|x[a-f\d]{2}|.))|(?:\{(~)?(\w+(?:\([^)]*\))?(?:\.\w+(?:\([^)]*\))?)*)(?:[ \t]|(?=\r?\n)))|(\})|((?:.|[\r\n\f])+?)/gi;
const STYLE_REGEX = /(?:^|\.)(\w+)(?:\(([^)]*)\))?/g;
const STRING_REGEX = /^(['"])((?:\\.|(?!\1)[^\\])*)\1$/;
const ESCAPE_REGEX = /\\(u[a-f\d]{4}|x[a-f\d]{2}|.)|([^\\])/gi;

const ESCAPES = new Map([
	['n', '\n'],
	['r', '\r'],
	['t', '\t'],
	['b', '\b'],
	['f', '\f'],
	['v', '\v'],
	['0', '\0'],
	['\\', '\\'],
	['e', '\u001B'],
	['a', '\u0007']
]);

function unescape(c) {
	if ((c[0] === 'u' && c.length === 5) || (c[0] === 'x' && c.length === 3)) {
		return String.fromCharCode(parseInt(c.slice(1), 16));
	}

	return ESCAPES.get(c) || c;
}

function parseArguments(name, args) {
	const results = [];
	const chunks = args.trim().split(/\s*,\s*/g);
	let matches;

	for (const chunk of chunks) {
		if (!isNaN(chunk)) {
			results.push(Number(chunk));
		} else if ((matches = chunk.match(STRING_REGEX))) {
			results.push(matches[2].replace(ESCAPE_REGEX, (m, escape, chr) => escape ? unescape(escape) : chr));
		} else {
			throw new Error(`Invalid Chalk template style argument: ${chunk} (in style '${name}')`);
		}
	}

	return results;
}

function parseStyle(style) {
	STYLE_REGEX.lastIndex = 0;

	const results = [];
	let matches;

	while ((matches = STYLE_REGEX.exec(style)) !== null) {
		const name = matches[1];

		if (matches[2]) {
			const args = parseArguments(name, matches[2]);
			results.push([name].concat(args));
		} else {
			results.push([name]);
		}
	}

	return results;
}

function buildStyle(chalk, styles) {
	const enabled = {};

	for (const layer of styles) {
		for (const style of layer.styles) {
			enabled[style[0]] = layer.inverse ? null : style.slice(1);
		}
	}

	let current = chalk;
	for (const styleName of Object.keys(enabled)) {
		if (Array.isArray(enabled[styleName])) {
			if (!(styleName in current)) {
				throw new Error(`Unknown Chalk style: ${styleName}`);
			}

			if (enabled[styleName].length > 0) {
				current = current[styleName].apply(current, enabled[styleName]);
			} else {
				current = current[styleName];
			}
		}
	}

	return current;
}

module.exports = (chalk, tmp) => {
	const styles = [];
	const chunks = [];
	let chunk = [];

	// eslint-disable-next-line max-params
	tmp.replace(TEMPLATE_REGEX, (m, escapeChar, inverse, style, close, chr) => {
		if (escapeChar) {
			chunk.push(unescape(escapeChar));
		} else if (style) {
			const str = chunk.join('');
			chunk = [];
			chunks.push(styles.length === 0 ? str : buildStyle(chalk, styles)(str));
			styles.push({inverse, styles: parseStyle(style)});
		} else if (close) {
			if (styles.length === 0) {
				throw new Error('Found extraneous } in Chalk template literal');
			}

			chunks.push(buildStyle(chalk, styles)(chunk.join('')));
			chunk = [];
			styles.pop();
		} else {
			chunk.push(chr);
		}
	});

	chunks.push(chunk.join(''));

	if (styles.length > 0) {
		const errMsg = `Chalk template literal is missing ${styles.length} closing bracket${styles.length === 1 ? '' : 's'} (\`}\`)`;
		throw new Error(errMsg);
	}

	return chunks.join('');
};


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/color-convert/conversions.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/color-convert/conversions.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* MIT license */
var cssKeywords = __webpack_require__(/*! color-name */ "./node_modules/@babel/highlight/node_modules/color-name/index.js");

// NOTE: conversions should only return primitive values (i.e. arrays, or
//       values that give correct `typeof` results).
//       do not use box values types (i.e. Number(), String(), etc.)

var reverseKeywords = {};
for (var key in cssKeywords) {
	if (cssKeywords.hasOwnProperty(key)) {
		reverseKeywords[cssKeywords[key]] = key;
	}
}

var convert = module.exports = {
	rgb: {channels: 3, labels: 'rgb'},
	hsl: {channels: 3, labels: 'hsl'},
	hsv: {channels: 3, labels: 'hsv'},
	hwb: {channels: 3, labels: 'hwb'},
	cmyk: {channels: 4, labels: 'cmyk'},
	xyz: {channels: 3, labels: 'xyz'},
	lab: {channels: 3, labels: 'lab'},
	lch: {channels: 3, labels: 'lch'},
	hex: {channels: 1, labels: ['hex']},
	keyword: {channels: 1, labels: ['keyword']},
	ansi16: {channels: 1, labels: ['ansi16']},
	ansi256: {channels: 1, labels: ['ansi256']},
	hcg: {channels: 3, labels: ['h', 'c', 'g']},
	apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
	gray: {channels: 1, labels: ['gray']}
};

// hide .channels and .labels properties
for (var model in convert) {
	if (convert.hasOwnProperty(model)) {
		if (!('channels' in convert[model])) {
			throw new Error('missing channels property: ' + model);
		}

		if (!('labels' in convert[model])) {
			throw new Error('missing channel labels property: ' + model);
		}

		if (convert[model].labels.length !== convert[model].channels) {
			throw new Error('channel and label counts mismatch: ' + model);
		}

		var channels = convert[model].channels;
		var labels = convert[model].labels;
		delete convert[model].channels;
		delete convert[model].labels;
		Object.defineProperty(convert[model], 'channels', {value: channels});
		Object.defineProperty(convert[model], 'labels', {value: labels});
	}
}

convert.rgb.hsl = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var min = Math.min(r, g, b);
	var max = Math.max(r, g, b);
	var delta = max - min;
	var h;
	var s;
	var l;

	if (max === min) {
		h = 0;
	} else if (r === max) {
		h = (g - b) / delta;
	} else if (g === max) {
		h = 2 + (b - r) / delta;
	} else if (b === max) {
		h = 4 + (r - g) / delta;
	}

	h = Math.min(h * 60, 360);

	if (h < 0) {
		h += 360;
	}

	l = (min + max) / 2;

	if (max === min) {
		s = 0;
	} else if (l <= 0.5) {
		s = delta / (max + min);
	} else {
		s = delta / (2 - max - min);
	}

	return [h, s * 100, l * 100];
};

convert.rgb.hsv = function (rgb) {
	var rdif;
	var gdif;
	var bdif;
	var h;
	var s;

	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var v = Math.max(r, g, b);
	var diff = v - Math.min(r, g, b);
	var diffc = function (c) {
		return (v - c) / 6 / diff + 1 / 2;
	};

	if (diff === 0) {
		h = s = 0;
	} else {
		s = diff / v;
		rdif = diffc(r);
		gdif = diffc(g);
		bdif = diffc(b);

		if (r === v) {
			h = bdif - gdif;
		} else if (g === v) {
			h = (1 / 3) + rdif - bdif;
		} else if (b === v) {
			h = (2 / 3) + gdif - rdif;
		}
		if (h < 0) {
			h += 1;
		} else if (h > 1) {
			h -= 1;
		}
	}

	return [
		h * 360,
		s * 100,
		v * 100
	];
};

convert.rgb.hwb = function (rgb) {
	var r = rgb[0];
	var g = rgb[1];
	var b = rgb[2];
	var h = convert.rgb.hsl(rgb)[0];
	var w = 1 / 255 * Math.min(r, Math.min(g, b));

	b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

	return [h, w * 100, b * 100];
};

convert.rgb.cmyk = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var c;
	var m;
	var y;
	var k;

	k = Math.min(1 - r, 1 - g, 1 - b);
	c = (1 - r - k) / (1 - k) || 0;
	m = (1 - g - k) / (1 - k) || 0;
	y = (1 - b - k) / (1 - k) || 0;

	return [c * 100, m * 100, y * 100, k * 100];
};

/**
 * See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
 * */
function comparativeDistance(x, y) {
	return (
		Math.pow(x[0] - y[0], 2) +
		Math.pow(x[1] - y[1], 2) +
		Math.pow(x[2] - y[2], 2)
	);
}

convert.rgb.keyword = function (rgb) {
	var reversed = reverseKeywords[rgb];
	if (reversed) {
		return reversed;
	}

	var currentClosestDistance = Infinity;
	var currentClosestKeyword;

	for (var keyword in cssKeywords) {
		if (cssKeywords.hasOwnProperty(keyword)) {
			var value = cssKeywords[keyword];

			// Compute comparative distance
			var distance = comparativeDistance(rgb, value);

			// Check if its less, if so set as closest
			if (distance < currentClosestDistance) {
				currentClosestDistance = distance;
				currentClosestKeyword = keyword;
			}
		}
	}

	return currentClosestKeyword;
};

convert.keyword.rgb = function (keyword) {
	return cssKeywords[keyword];
};

convert.rgb.xyz = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;

	// assume sRGB
	r = r > 0.04045 ? Math.pow(((r + 0.055) / 1.055), 2.4) : (r / 12.92);
	g = g > 0.04045 ? Math.pow(((g + 0.055) / 1.055), 2.4) : (g / 12.92);
	b = b > 0.04045 ? Math.pow(((b + 0.055) / 1.055), 2.4) : (b / 12.92);

	var x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
	var y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
	var z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

	return [x * 100, y * 100, z * 100];
};

convert.rgb.lab = function (rgb) {
	var xyz = convert.rgb.xyz(rgb);
	var x = xyz[0];
	var y = xyz[1];
	var z = xyz[2];
	var l;
	var a;
	var b;

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

	l = (116 * y) - 16;
	a = 500 * (x - y);
	b = 200 * (y - z);

	return [l, a, b];
};

convert.hsl.rgb = function (hsl) {
	var h = hsl[0] / 360;
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var t1;
	var t2;
	var t3;
	var rgb;
	var val;

	if (s === 0) {
		val = l * 255;
		return [val, val, val];
	}

	if (l < 0.5) {
		t2 = l * (1 + s);
	} else {
		t2 = l + s - l * s;
	}

	t1 = 2 * l - t2;

	rgb = [0, 0, 0];
	for (var i = 0; i < 3; i++) {
		t3 = h + 1 / 3 * -(i - 1);
		if (t3 < 0) {
			t3++;
		}
		if (t3 > 1) {
			t3--;
		}

		if (6 * t3 < 1) {
			val = t1 + (t2 - t1) * 6 * t3;
		} else if (2 * t3 < 1) {
			val = t2;
		} else if (3 * t3 < 2) {
			val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
		} else {
			val = t1;
		}

		rgb[i] = val * 255;
	}

	return rgb;
};

convert.hsl.hsv = function (hsl) {
	var h = hsl[0];
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var smin = s;
	var lmin = Math.max(l, 0.01);
	var sv;
	var v;

	l *= 2;
	s *= (l <= 1) ? l : 2 - l;
	smin *= lmin <= 1 ? lmin : 2 - lmin;
	v = (l + s) / 2;
	sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

	return [h, sv * 100, v * 100];
};

convert.hsv.rgb = function (hsv) {
	var h = hsv[0] / 60;
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;
	var hi = Math.floor(h) % 6;

	var f = h - Math.floor(h);
	var p = 255 * v * (1 - s);
	var q = 255 * v * (1 - (s * f));
	var t = 255 * v * (1 - (s * (1 - f)));
	v *= 255;

	switch (hi) {
		case 0:
			return [v, t, p];
		case 1:
			return [q, v, p];
		case 2:
			return [p, v, t];
		case 3:
			return [p, q, v];
		case 4:
			return [t, p, v];
		case 5:
			return [v, p, q];
	}
};

convert.hsv.hsl = function (hsv) {
	var h = hsv[0];
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;
	var vmin = Math.max(v, 0.01);
	var lmin;
	var sl;
	var l;

	l = (2 - s) * v;
	lmin = (2 - s) * vmin;
	sl = s * vmin;
	sl /= (lmin <= 1) ? lmin : 2 - lmin;
	sl = sl || 0;
	l /= 2;

	return [h, sl * 100, l * 100];
};

// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
convert.hwb.rgb = function (hwb) {
	var h = hwb[0] / 360;
	var wh = hwb[1] / 100;
	var bl = hwb[2] / 100;
	var ratio = wh + bl;
	var i;
	var v;
	var f;
	var n;

	// wh + bl cant be > 1
	if (ratio > 1) {
		wh /= ratio;
		bl /= ratio;
	}

	i = Math.floor(6 * h);
	v = 1 - bl;
	f = 6 * h - i;

	if ((i & 0x01) !== 0) {
		f = 1 - f;
	}

	n = wh + f * (v - wh); // linear interpolation

	var r;
	var g;
	var b;
	switch (i) {
		default:
		case 6:
		case 0: r = v; g = n; b = wh; break;
		case 1: r = n; g = v; b = wh; break;
		case 2: r = wh; g = v; b = n; break;
		case 3: r = wh; g = n; b = v; break;
		case 4: r = n; g = wh; b = v; break;
		case 5: r = v; g = wh; b = n; break;
	}

	return [r * 255, g * 255, b * 255];
};

convert.cmyk.rgb = function (cmyk) {
	var c = cmyk[0] / 100;
	var m = cmyk[1] / 100;
	var y = cmyk[2] / 100;
	var k = cmyk[3] / 100;
	var r;
	var g;
	var b;

	r = 1 - Math.min(1, c * (1 - k) + k);
	g = 1 - Math.min(1, m * (1 - k) + k);
	b = 1 - Math.min(1, y * (1 - k) + k);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.rgb = function (xyz) {
	var x = xyz[0] / 100;
	var y = xyz[1] / 100;
	var z = xyz[2] / 100;
	var r;
	var g;
	var b;

	r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
	g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
	b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

	// assume sRGB
	r = r > 0.0031308
		? ((1.055 * Math.pow(r, 1.0 / 2.4)) - 0.055)
		: r * 12.92;

	g = g > 0.0031308
		? ((1.055 * Math.pow(g, 1.0 / 2.4)) - 0.055)
		: g * 12.92;

	b = b > 0.0031308
		? ((1.055 * Math.pow(b, 1.0 / 2.4)) - 0.055)
		: b * 12.92;

	r = Math.min(Math.max(0, r), 1);
	g = Math.min(Math.max(0, g), 1);
	b = Math.min(Math.max(0, b), 1);

	return [r * 255, g * 255, b * 255];
};

convert.xyz.lab = function (xyz) {
	var x = xyz[0];
	var y = xyz[1];
	var z = xyz[2];
	var l;
	var a;
	var b;

	x /= 95.047;
	y /= 100;
	z /= 108.883;

	x = x > 0.008856 ? Math.pow(x, 1 / 3) : (7.787 * x) + (16 / 116);
	y = y > 0.008856 ? Math.pow(y, 1 / 3) : (7.787 * y) + (16 / 116);
	z = z > 0.008856 ? Math.pow(z, 1 / 3) : (7.787 * z) + (16 / 116);

	l = (116 * y) - 16;
	a = 500 * (x - y);
	b = 200 * (y - z);

	return [l, a, b];
};

convert.lab.xyz = function (lab) {
	var l = lab[0];
	var a = lab[1];
	var b = lab[2];
	var x;
	var y;
	var z;

	y = (l + 16) / 116;
	x = a / 500 + y;
	z = y - b / 200;

	var y2 = Math.pow(y, 3);
	var x2 = Math.pow(x, 3);
	var z2 = Math.pow(z, 3);
	y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
	x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
	z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

	x *= 95.047;
	y *= 100;
	z *= 108.883;

	return [x, y, z];
};

convert.lab.lch = function (lab) {
	var l = lab[0];
	var a = lab[1];
	var b = lab[2];
	var hr;
	var h;
	var c;

	hr = Math.atan2(b, a);
	h = hr * 360 / 2 / Math.PI;

	if (h < 0) {
		h += 360;
	}

	c = Math.sqrt(a * a + b * b);

	return [l, c, h];
};

convert.lch.lab = function (lch) {
	var l = lch[0];
	var c = lch[1];
	var h = lch[2];
	var a;
	var b;
	var hr;

	hr = h / 360 * 2 * Math.PI;
	a = c * Math.cos(hr);
	b = c * Math.sin(hr);

	return [l, a, b];
};

convert.rgb.ansi16 = function (args) {
	var r = args[0];
	var g = args[1];
	var b = args[2];
	var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2]; // hsv -> ansi16 optimization

	value = Math.round(value / 50);

	if (value === 0) {
		return 30;
	}

	var ansi = 30
		+ ((Math.round(b / 255) << 2)
		| (Math.round(g / 255) << 1)
		| Math.round(r / 255));

	if (value === 2) {
		ansi += 60;
	}

	return ansi;
};

convert.hsv.ansi16 = function (args) {
	// optimization here; we already know the value and don't need to get
	// it converted for us.
	return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
};

convert.rgb.ansi256 = function (args) {
	var r = args[0];
	var g = args[1];
	var b = args[2];

	// we use the extended greyscale palette here, with the exception of
	// black and white. normal palette only has 4 greyscale shades.
	if (r === g && g === b) {
		if (r < 8) {
			return 16;
		}

		if (r > 248) {
			return 231;
		}

		return Math.round(((r - 8) / 247) * 24) + 232;
	}

	var ansi = 16
		+ (36 * Math.round(r / 255 * 5))
		+ (6 * Math.round(g / 255 * 5))
		+ Math.round(b / 255 * 5);

	return ansi;
};

convert.ansi16.rgb = function (args) {
	var color = args % 10;

	// handle greyscale
	if (color === 0 || color === 7) {
		if (args > 50) {
			color += 3.5;
		}

		color = color / 10.5 * 255;

		return [color, color, color];
	}

	var mult = (~~(args > 50) + 1) * 0.5;
	var r = ((color & 1) * mult) * 255;
	var g = (((color >> 1) & 1) * mult) * 255;
	var b = (((color >> 2) & 1) * mult) * 255;

	return [r, g, b];
};

convert.ansi256.rgb = function (args) {
	// handle greyscale
	if (args >= 232) {
		var c = (args - 232) * 10 + 8;
		return [c, c, c];
	}

	args -= 16;

	var rem;
	var r = Math.floor(args / 36) / 5 * 255;
	var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
	var b = (rem % 6) / 5 * 255;

	return [r, g, b];
};

convert.rgb.hex = function (args) {
	var integer = ((Math.round(args[0]) & 0xFF) << 16)
		+ ((Math.round(args[1]) & 0xFF) << 8)
		+ (Math.round(args[2]) & 0xFF);

	var string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.hex.rgb = function (args) {
	var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
	if (!match) {
		return [0, 0, 0];
	}

	var colorString = match[0];

	if (match[0].length === 3) {
		colorString = colorString.split('').map(function (char) {
			return char + char;
		}).join('');
	}

	var integer = parseInt(colorString, 16);
	var r = (integer >> 16) & 0xFF;
	var g = (integer >> 8) & 0xFF;
	var b = integer & 0xFF;

	return [r, g, b];
};

convert.rgb.hcg = function (rgb) {
	var r = rgb[0] / 255;
	var g = rgb[1] / 255;
	var b = rgb[2] / 255;
	var max = Math.max(Math.max(r, g), b);
	var min = Math.min(Math.min(r, g), b);
	var chroma = (max - min);
	var grayscale;
	var hue;

	if (chroma < 1) {
		grayscale = min / (1 - chroma);
	} else {
		grayscale = 0;
	}

	if (chroma <= 0) {
		hue = 0;
	} else
	if (max === r) {
		hue = ((g - b) / chroma) % 6;
	} else
	if (max === g) {
		hue = 2 + (b - r) / chroma;
	} else {
		hue = 4 + (r - g) / chroma + 4;
	}

	hue /= 6;
	hue %= 1;

	return [hue * 360, chroma * 100, grayscale * 100];
};

convert.hsl.hcg = function (hsl) {
	var s = hsl[1] / 100;
	var l = hsl[2] / 100;
	var c = 1;
	var f = 0;

	if (l < 0.5) {
		c = 2.0 * s * l;
	} else {
		c = 2.0 * s * (1.0 - l);
	}

	if (c < 1.0) {
		f = (l - 0.5 * c) / (1.0 - c);
	}

	return [hsl[0], c * 100, f * 100];
};

convert.hsv.hcg = function (hsv) {
	var s = hsv[1] / 100;
	var v = hsv[2] / 100;

	var c = s * v;
	var f = 0;

	if (c < 1.0) {
		f = (v - c) / (1 - c);
	}

	return [hsv[0], c * 100, f * 100];
};

convert.hcg.rgb = function (hcg) {
	var h = hcg[0] / 360;
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	if (c === 0.0) {
		return [g * 255, g * 255, g * 255];
	}

	var pure = [0, 0, 0];
	var hi = (h % 1) * 6;
	var v = hi % 1;
	var w = 1 - v;
	var mg = 0;

	switch (Math.floor(hi)) {
		case 0:
			pure[0] = 1; pure[1] = v; pure[2] = 0; break;
		case 1:
			pure[0] = w; pure[1] = 1; pure[2] = 0; break;
		case 2:
			pure[0] = 0; pure[1] = 1; pure[2] = v; break;
		case 3:
			pure[0] = 0; pure[1] = w; pure[2] = 1; break;
		case 4:
			pure[0] = v; pure[1] = 0; pure[2] = 1; break;
		default:
			pure[0] = 1; pure[1] = 0; pure[2] = w;
	}

	mg = (1.0 - c) * g;

	return [
		(c * pure[0] + mg) * 255,
		(c * pure[1] + mg) * 255,
		(c * pure[2] + mg) * 255
	];
};

convert.hcg.hsv = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	var v = c + g * (1.0 - c);
	var f = 0;

	if (v > 0.0) {
		f = c / v;
	}

	return [hcg[0], f * 100, v * 100];
};

convert.hcg.hsl = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;

	var l = g * (1.0 - c) + 0.5 * c;
	var s = 0;

	if (l > 0.0 && l < 0.5) {
		s = c / (2 * l);
	} else
	if (l >= 0.5 && l < 1.0) {
		s = c / (2 * (1 - l));
	}

	return [hcg[0], s * 100, l * 100];
};

convert.hcg.hwb = function (hcg) {
	var c = hcg[1] / 100;
	var g = hcg[2] / 100;
	var v = c + g * (1.0 - c);
	return [hcg[0], (v - c) * 100, (1 - v) * 100];
};

convert.hwb.hcg = function (hwb) {
	var w = hwb[1] / 100;
	var b = hwb[2] / 100;
	var v = 1 - b;
	var c = v - w;
	var g = 0;

	if (c < 1) {
		g = (v - c) / (1 - c);
	}

	return [hwb[0], c * 100, g * 100];
};

convert.apple.rgb = function (apple) {
	return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
};

convert.rgb.apple = function (rgb) {
	return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
};

convert.gray.rgb = function (args) {
	return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
};

convert.gray.hsl = convert.gray.hsv = function (args) {
	return [0, 0, args[0]];
};

convert.gray.hwb = function (gray) {
	return [0, 100, gray[0]];
};

convert.gray.cmyk = function (gray) {
	return [0, 0, 0, gray[0]];
};

convert.gray.lab = function (gray) {
	return [gray[0], 0, 0];
};

convert.gray.hex = function (gray) {
	var val = Math.round(gray[0] / 100 * 255) & 0xFF;
	var integer = (val << 16) + (val << 8) + val;

	var string = integer.toString(16).toUpperCase();
	return '000000'.substring(string.length) + string;
};

convert.rgb.gray = function (rgb) {
	var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
	return [val / 255 * 100];
};


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/color-convert/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/color-convert/index.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var conversions = __webpack_require__(/*! ./conversions */ "./node_modules/@babel/highlight/node_modules/color-convert/conversions.js");
var route = __webpack_require__(/*! ./route */ "./node_modules/@babel/highlight/node_modules/color-convert/route.js");

var convert = {};

var models = Object.keys(conversions);

function wrapRaw(fn) {
	var wrappedFn = function (args) {
		if (args === undefined || args === null) {
			return args;
		}

		if (arguments.length > 1) {
			args = Array.prototype.slice.call(arguments);
		}

		return fn(args);
	};

	// preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

function wrapRounded(fn) {
	var wrappedFn = function (args) {
		if (args === undefined || args === null) {
			return args;
		}

		if (arguments.length > 1) {
			args = Array.prototype.slice.call(arguments);
		}

		var result = fn(args);

		// we're assuming the result is an array here.
		// see notice in conversions.js; don't use box types
		// in conversion functions.
		if (typeof result === 'object') {
			for (var len = result.length, i = 0; i < len; i++) {
				result[i] = Math.round(result[i]);
			}
		}

		return result;
	};

	// preserve .conversion property if there is one
	if ('conversion' in fn) {
		wrappedFn.conversion = fn.conversion;
	}

	return wrappedFn;
}

models.forEach(function (fromModel) {
	convert[fromModel] = {};

	Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
	Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

	var routes = route(fromModel);
	var routeModels = Object.keys(routes);

	routeModels.forEach(function (toModel) {
		var fn = routes[toModel];

		convert[fromModel][toModel] = wrapRounded(fn);
		convert[fromModel][toModel].raw = wrapRaw(fn);
	});
});

module.exports = convert;


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/color-convert/route.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/color-convert/route.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var conversions = __webpack_require__(/*! ./conversions */ "./node_modules/@babel/highlight/node_modules/color-convert/conversions.js");

/*
	this function routes a model to all other models.

	all functions that are routed have a property `.conversion` attached
	to the returned synthetic function. This property is an array
	of strings, each with the steps in between the 'from' and 'to'
	color models (inclusive).

	conversions that are not possible simply are not included.
*/

function buildGraph() {
	var graph = {};
	// https://jsperf.com/object-keys-vs-for-in-with-closure/3
	var models = Object.keys(conversions);

	for (var len = models.length, i = 0; i < len; i++) {
		graph[models[i]] = {
			// http://jsperf.com/1-vs-infinity
			// micro-opt, but this is simple.
			distance: -1,
			parent: null
		};
	}

	return graph;
}

// https://en.wikipedia.org/wiki/Breadth-first_search
function deriveBFS(fromModel) {
	var graph = buildGraph();
	var queue = [fromModel]; // unshift -> queue -> pop

	graph[fromModel].distance = 0;

	while (queue.length) {
		var current = queue.pop();
		var adjacents = Object.keys(conversions[current]);

		for (var len = adjacents.length, i = 0; i < len; i++) {
			var adjacent = adjacents[i];
			var node = graph[adjacent];

			if (node.distance === -1) {
				node.distance = graph[current].distance + 1;
				node.parent = current;
				queue.unshift(adjacent);
			}
		}
	}

	return graph;
}

function link(from, to) {
	return function (args) {
		return to(from(args));
	};
}

function wrapConversion(toModel, graph) {
	var path = [graph[toModel].parent, toModel];
	var fn = conversions[graph[toModel].parent][toModel];

	var cur = graph[toModel].parent;
	while (graph[cur].parent) {
		path.unshift(graph[cur].parent);
		fn = link(conversions[graph[cur].parent][cur], fn);
		cur = graph[cur].parent;
	}

	fn.conversion = path;
	return fn;
}

module.exports = function (fromModel) {
	var graph = deriveBFS(fromModel);
	var conversion = {};

	var models = Object.keys(graph);
	for (var len = models.length, i = 0; i < len; i++) {
		var toModel = models[i];
		var node = graph[toModel];

		if (node.parent === null) {
			// no possible conversion, or this node is the source model.
			continue;
		}

		conversion[toModel] = wrapConversion(toModel, graph);
	}

	return conversion;
};



/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/color-name/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/color-name/index.js ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = {
	"aliceblue": [240, 248, 255],
	"antiquewhite": [250, 235, 215],
	"aqua": [0, 255, 255],
	"aquamarine": [127, 255, 212],
	"azure": [240, 255, 255],
	"beige": [245, 245, 220],
	"bisque": [255, 228, 196],
	"black": [0, 0, 0],
	"blanchedalmond": [255, 235, 205],
	"blue": [0, 0, 255],
	"blueviolet": [138, 43, 226],
	"brown": [165, 42, 42],
	"burlywood": [222, 184, 135],
	"cadetblue": [95, 158, 160],
	"chartreuse": [127, 255, 0],
	"chocolate": [210, 105, 30],
	"coral": [255, 127, 80],
	"cornflowerblue": [100, 149, 237],
	"cornsilk": [255, 248, 220],
	"crimson": [220, 20, 60],
	"cyan": [0, 255, 255],
	"darkblue": [0, 0, 139],
	"darkcyan": [0, 139, 139],
	"darkgoldenrod": [184, 134, 11],
	"darkgray": [169, 169, 169],
	"darkgreen": [0, 100, 0],
	"darkgrey": [169, 169, 169],
	"darkkhaki": [189, 183, 107],
	"darkmagenta": [139, 0, 139],
	"darkolivegreen": [85, 107, 47],
	"darkorange": [255, 140, 0],
	"darkorchid": [153, 50, 204],
	"darkred": [139, 0, 0],
	"darksalmon": [233, 150, 122],
	"darkseagreen": [143, 188, 143],
	"darkslateblue": [72, 61, 139],
	"darkslategray": [47, 79, 79],
	"darkslategrey": [47, 79, 79],
	"darkturquoise": [0, 206, 209],
	"darkviolet": [148, 0, 211],
	"deeppink": [255, 20, 147],
	"deepskyblue": [0, 191, 255],
	"dimgray": [105, 105, 105],
	"dimgrey": [105, 105, 105],
	"dodgerblue": [30, 144, 255],
	"firebrick": [178, 34, 34],
	"floralwhite": [255, 250, 240],
	"forestgreen": [34, 139, 34],
	"fuchsia": [255, 0, 255],
	"gainsboro": [220, 220, 220],
	"ghostwhite": [248, 248, 255],
	"gold": [255, 215, 0],
	"goldenrod": [218, 165, 32],
	"gray": [128, 128, 128],
	"green": [0, 128, 0],
	"greenyellow": [173, 255, 47],
	"grey": [128, 128, 128],
	"honeydew": [240, 255, 240],
	"hotpink": [255, 105, 180],
	"indianred": [205, 92, 92],
	"indigo": [75, 0, 130],
	"ivory": [255, 255, 240],
	"khaki": [240, 230, 140],
	"lavender": [230, 230, 250],
	"lavenderblush": [255, 240, 245],
	"lawngreen": [124, 252, 0],
	"lemonchiffon": [255, 250, 205],
	"lightblue": [173, 216, 230],
	"lightcoral": [240, 128, 128],
	"lightcyan": [224, 255, 255],
	"lightgoldenrodyellow": [250, 250, 210],
	"lightgray": [211, 211, 211],
	"lightgreen": [144, 238, 144],
	"lightgrey": [211, 211, 211],
	"lightpink": [255, 182, 193],
	"lightsalmon": [255, 160, 122],
	"lightseagreen": [32, 178, 170],
	"lightskyblue": [135, 206, 250],
	"lightslategray": [119, 136, 153],
	"lightslategrey": [119, 136, 153],
	"lightsteelblue": [176, 196, 222],
	"lightyellow": [255, 255, 224],
	"lime": [0, 255, 0],
	"limegreen": [50, 205, 50],
	"linen": [250, 240, 230],
	"magenta": [255, 0, 255],
	"maroon": [128, 0, 0],
	"mediumaquamarine": [102, 205, 170],
	"mediumblue": [0, 0, 205],
	"mediumorchid": [186, 85, 211],
	"mediumpurple": [147, 112, 219],
	"mediumseagreen": [60, 179, 113],
	"mediumslateblue": [123, 104, 238],
	"mediumspringgreen": [0, 250, 154],
	"mediumturquoise": [72, 209, 204],
	"mediumvioletred": [199, 21, 133],
	"midnightblue": [25, 25, 112],
	"mintcream": [245, 255, 250],
	"mistyrose": [255, 228, 225],
	"moccasin": [255, 228, 181],
	"navajowhite": [255, 222, 173],
	"navy": [0, 0, 128],
	"oldlace": [253, 245, 230],
	"olive": [128, 128, 0],
	"olivedrab": [107, 142, 35],
	"orange": [255, 165, 0],
	"orangered": [255, 69, 0],
	"orchid": [218, 112, 214],
	"palegoldenrod": [238, 232, 170],
	"palegreen": [152, 251, 152],
	"paleturquoise": [175, 238, 238],
	"palevioletred": [219, 112, 147],
	"papayawhip": [255, 239, 213],
	"peachpuff": [255, 218, 185],
	"peru": [205, 133, 63],
	"pink": [255, 192, 203],
	"plum": [221, 160, 221],
	"powderblue": [176, 224, 230],
	"purple": [128, 0, 128],
	"rebeccapurple": [102, 51, 153],
	"red": [255, 0, 0],
	"rosybrown": [188, 143, 143],
	"royalblue": [65, 105, 225],
	"saddlebrown": [139, 69, 19],
	"salmon": [250, 128, 114],
	"sandybrown": [244, 164, 96],
	"seagreen": [46, 139, 87],
	"seashell": [255, 245, 238],
	"sienna": [160, 82, 45],
	"silver": [192, 192, 192],
	"skyblue": [135, 206, 235],
	"slateblue": [106, 90, 205],
	"slategray": [112, 128, 144],
	"slategrey": [112, 128, 144],
	"snow": [255, 250, 250],
	"springgreen": [0, 255, 127],
	"steelblue": [70, 130, 180],
	"tan": [210, 180, 140],
	"teal": [0, 128, 128],
	"thistle": [216, 191, 216],
	"tomato": [255, 99, 71],
	"turquoise": [64, 224, 208],
	"violet": [238, 130, 238],
	"wheat": [245, 222, 179],
	"white": [255, 255, 255],
	"whitesmoke": [245, 245, 245],
	"yellow": [255, 255, 0],
	"yellowgreen": [154, 205, 50]
};


/***/ }),

/***/ "./node_modules/@babel/highlight/node_modules/supports-color/browser.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@babel/highlight/node_modules/supports-color/browser.js ***!
  \******************************************************************************/
/***/ ((module) => {

"use strict";

module.exports = {
	stdout: false,
	stderr: false
};


/***/ }),

/***/ "./node_modules/abort-controller/browser.js":
/*!**************************************************!*\
  !*** ./node_modules/abort-controller/browser.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";
/*globals self, window */


/*eslint-disable @mysticatea/prettier */
const { AbortController, AbortSignal } =
    typeof self !== "undefined" ? self :
    typeof window !== "undefined" ? window :
    /* otherwise */ undefined
/*eslint-enable @mysticatea/prettier */

module.exports = AbortController
module.exports.AbortSignal = AbortSignal
module.exports.default = AbortController


/***/ }),

/***/ "./node_modules/ansi-styles/index.js":
/*!*******************************************!*\
  !*** ./node_modules/ansi-styles/index.js ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* module decorator */ module = __webpack_require__.nmd(module);


const wrapAnsi16 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${code + offset}m`;
};

const wrapAnsi256 = (fn, offset) => (...args) => {
	const code = fn(...args);
	return `\u001B[${38 + offset};5;${code}m`;
};

const wrapAnsi16m = (fn, offset) => (...args) => {
	const rgb = fn(...args);
	return `\u001B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
};

const ansi2ansi = n => n;
const rgb2rgb = (r, g, b) => [r, g, b];

const setLazyProperty = (object, property, get) => {
	Object.defineProperty(object, property, {
		get: () => {
			const value = get();

			Object.defineProperty(object, property, {
				value,
				enumerable: true,
				configurable: true
			});

			return value;
		},
		enumerable: true,
		configurable: true
	});
};

/** @type {typeof import('color-convert')} */
let colorConvert;
const makeDynamicStyles = (wrap, targetSpace, identity, isBackground) => {
	if (colorConvert === undefined) {
		colorConvert = __webpack_require__(/*! color-convert */ "./node_modules/color-convert/index.js");
	}

	const offset = isBackground ? 10 : 0;
	const styles = {};

	for (const [sourceSpace, suite] of Object.entries(colorConvert)) {
		const name = sourceSpace === 'ansi16' ? 'ansi' : sourceSpace;
		if (sourceSpace === targetSpace) {
			styles[name] = wrap(identity, offset);
		} else if (typeof suite === 'object') {
			styles[name] = wrap(suite[targetSpace], offset);
		}
	}

	return styles;
};

function assembleStyles() {
	const codes = new Map();
	const styles = {
		modifier: {
			reset: [0, 0],
			// 21 isn't widely supported and 22 does the same thing
			bold: [1, 22],
			dim: [2, 22],
			italic: [3, 23],
			underline: [4, 24],
			inverse: [7, 27],
			hidden: [8, 28],
			strikethrough: [9, 29]
		},
		color: {
			black: [30, 39],
			red: [31, 39],
			green: [32, 39],
			yellow: [33, 39],
			blue: [34, 39],
			magenta: [35, 39],
			cyan: [36, 39],
			white: [37, 39],

			// Bright color
			blackBright: [90, 39],
			redBright: [91, 39],
			greenBright: [92, 39],
			yellowBright: [93, 39],
			blueBright: [94, 39],
			magentaBright: [95, 39],
			cyanBright: [96, 39],
			whiteBright: [97, 39]
		},
		bgColor: {
			bgBlack: [40, 49],
			bgRed: [41, 49],
			bgGreen: [42, 49],
			bgYellow: [43, 49],
			bgBlue: [44, 49],
			bgMagenta: [45, 49],
			bgCyan: [46, 49],
			bgWhite: [47, 49],

			// Bright color
			bgBlackBright: [100, 49],
			bgRedBright: [101, 49],
			bgGreenBright: [102, 49],
			bgYellowBright: [103, 49],
			bgBlueBright: [104, 49],
			bgMagentaBright: [105, 49],
			bgCyanBright: [106, 49],
			bgWhiteBright: [107, 49]
		}
	};

	// Alias bright black as gray (and grey)
	styles.color.gray = styles.color.blackBright;
	styles.bgColor.bgGray = styles.bgColor.bgBlackBright;
	styles.color.grey = styles.color.blackBright;
	styles.bgColor.bgGrey = styles.bgColor.bgBlackBright;

	for (const [groupName, group] of Object.entries(styles)) {
		for (const [styleName, style] of Object.entries(group)) {
			styles[styleName] = {
				open: `\u001B[${style[0]}m`,
				close: `\u001B[${style[1]}m`
			};

			group[styleName] = styles[styleName];

			codes.set(style[0], style[1]);
		}

		Object.defineProperty(styles, groupName, {
			value: group,
			enumerable: false
		});
	}

	Object.defineProperty(styles, 'codes', {
		value: codes,
		enumerable: false
	});

	styles.color.close = '\u001B[39m';
	styles.bgColor.close = '\u001B[49m';

	setLazyProperty(styles.color, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, false));
	setLazyProperty(styles.color, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, false));
	setLazyProperty(styles.bgColor, 'ansi', () => makeDynamicStyles(wrapAnsi16, 'ansi16', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi256', () => makeDynamicStyles(wrapAnsi256, 'ansi256', ansi2ansi, true));
	setLazyProperty(styles.bgColor, 'ansi16m', () => makeDynamicStyles(wrapAnsi16m, 'rgb', rgb2rgb, true));

	return styles;
}

// Make the export immutable
Object.defineProperty(module, 'exports', {
	enumerable: true,
	get: assembleStyles
});


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1.js":
/*!******************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const asn1 = exports;

asn1.bignum = __webpack_require__(/*! bn.js */ "./node_modules/bn.js/lib/bn.js");

asn1.define = __webpack_require__(/*! ./asn1/api */ "./node_modules/asn1.js/lib/asn1/api.js").define;
asn1.base = __webpack_require__(/*! ./asn1/base */ "./node_modules/asn1.js/lib/asn1/base/index.js");
asn1.constants = __webpack_require__(/*! ./asn1/constants */ "./node_modules/asn1.js/lib/asn1/constants/index.js");
asn1.decoders = __webpack_require__(/*! ./asn1/decoders */ "./node_modules/asn1.js/lib/asn1/decoders/index.js");
asn1.encoders = __webpack_require__(/*! ./asn1/encoders */ "./node_modules/asn1.js/lib/asn1/encoders/index.js");


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/api.js":
/*!**********************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/api.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const encoders = __webpack_require__(/*! ./encoders */ "./node_modules/asn1.js/lib/asn1/encoders/index.js");
const decoders = __webpack_require__(/*! ./decoders */ "./node_modules/asn1.js/lib/asn1/decoders/index.js");
const inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");

const api = exports;

api.define = function define(name, body) {
  return new Entity(name, body);
};

function Entity(name, body) {
  this.name = name;
  this.body = body;

  this.decoders = {};
  this.encoders = {};
}

Entity.prototype._createNamed = function createNamed(Base) {
  const name = this.name;

  function Generated(entity) {
    this._initNamed(entity, name);
  }
  inherits(Generated, Base);
  Generated.prototype._initNamed = function _initNamed(entity, name) {
    Base.call(this, entity, name);
  };

  return new Generated(this);
};

Entity.prototype._getDecoder = function _getDecoder(enc) {
  enc = enc || 'der';
  // Lazily create decoder
  if (!this.decoders.hasOwnProperty(enc))
    this.decoders[enc] = this._createNamed(decoders[enc]);
  return this.decoders[enc];
};

Entity.prototype.decode = function decode(data, enc, options) {
  return this._getDecoder(enc).decode(data, options);
};

Entity.prototype._getEncoder = function _getEncoder(enc) {
  enc = enc || 'der';
  // Lazily create encoder
  if (!this.encoders.hasOwnProperty(enc))
    this.encoders[enc] = this._createNamed(encoders[enc]);
  return this.encoders[enc];
};

Entity.prototype.encode = function encode(data, enc, /* internal */ reporter) {
  return this._getEncoder(enc).encode(data, reporter);
};


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/base/buffer.js":
/*!******************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/base/buffer.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");
const Reporter = __webpack_require__(/*! ../base/reporter */ "./node_modules/asn1.js/lib/asn1/base/reporter.js").Reporter;
const Buffer = __webpack_require__(/*! safer-buffer */ "./node_modules/safer-buffer/safer.js").Buffer;

function DecoderBuffer(base, options) {
  Reporter.call(this, options);
  if (!Buffer.isBuffer(base)) {
    this.error('Input not Buffer');
    return;
  }

  this.base = base;
  this.offset = 0;
  this.length = base.length;
}
inherits(DecoderBuffer, Reporter);
exports.DecoderBuffer = DecoderBuffer;

DecoderBuffer.isDecoderBuffer = function isDecoderBuffer(data) {
  if (data instanceof DecoderBuffer) {
    return true;
  }

  // Or accept compatible API
  const isCompatible = typeof data === 'object' &&
    Buffer.isBuffer(data.base) &&
    data.constructor.name === 'DecoderBuffer' &&
    typeof data.offset === 'number' &&
    typeof data.length === 'number' &&
    typeof data.save === 'function' &&
    typeof data.restore === 'function' &&
    typeof data.isEmpty === 'function' &&
    typeof data.readUInt8 === 'function' &&
    typeof data.skip === 'function' &&
    typeof data.raw === 'function';

  return isCompatible;
};

DecoderBuffer.prototype.save = function save() {
  return { offset: this.offset, reporter: Reporter.prototype.save.call(this) };
};

DecoderBuffer.prototype.restore = function restore(save) {
  // Return skipped data
  const res = new DecoderBuffer(this.base);
  res.offset = save.offset;
  res.length = this.offset;

  this.offset = save.offset;
  Reporter.prototype.restore.call(this, save.reporter);

  return res;
};

DecoderBuffer.prototype.isEmpty = function isEmpty() {
  return this.offset === this.length;
};

DecoderBuffer.prototype.readUInt8 = function readUInt8(fail) {
  if (this.offset + 1 <= this.length)
    return this.base.readUInt8(this.offset++, true);
  else
    return this.error(fail || 'DecoderBuffer overrun');
};

DecoderBuffer.prototype.skip = function skip(bytes, fail) {
  if (!(this.offset + bytes <= this.length))
    return this.error(fail || 'DecoderBuffer overrun');

  const res = new DecoderBuffer(this.base);

  // Share reporter state
  res._reporterState = this._reporterState;

  res.offset = this.offset;
  res.length = this.offset + bytes;
  this.offset += bytes;
  return res;
};

DecoderBuffer.prototype.raw = function raw(save) {
  return this.base.slice(save ? save.offset : this.offset, this.length);
};

function EncoderBuffer(value, reporter) {
  if (Array.isArray(value)) {
    this.length = 0;
    this.value = value.map(function(item) {
      if (!EncoderBuffer.isEncoderBuffer(item))
        item = new EncoderBuffer(item, reporter);
      this.length += item.length;
      return item;
    }, this);
  } else if (typeof value === 'number') {
    if (!(0 <= value && value <= 0xff))
      return reporter.error('non-byte EncoderBuffer value');
    this.value = value;
    this.length = 1;
  } else if (typeof value === 'string') {
    this.value = value;
    this.length = Buffer.byteLength(value);
  } else if (Buffer.isBuffer(value)) {
    this.value = value;
    this.length = value.length;
  } else {
    return reporter.error('Unsupported type: ' + typeof value);
  }
}
exports.EncoderBuffer = EncoderBuffer;

EncoderBuffer.isEncoderBuffer = function isEncoderBuffer(data) {
  if (data instanceof EncoderBuffer) {
    return true;
  }

  // Or accept compatible API
  const isCompatible = typeof data === 'object' &&
    data.constructor.name === 'EncoderBuffer' &&
    typeof data.length === 'number' &&
    typeof data.join === 'function';

  return isCompatible;
};

EncoderBuffer.prototype.join = function join(out, offset) {
  if (!out)
    out = Buffer.alloc(this.length);
  if (!offset)
    offset = 0;

  if (this.length === 0)
    return out;

  if (Array.isArray(this.value)) {
    this.value.forEach(function(item) {
      item.join(out, offset);
      offset += item.length;
    });
  } else {
    if (typeof this.value === 'number')
      out[offset] = this.value;
    else if (typeof this.value === 'string')
      out.write(this.value, offset);
    else if (Buffer.isBuffer(this.value))
      this.value.copy(out, offset);
    offset += this.length;
  }

  return out;
};


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/base/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/base/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const base = exports;

base.Reporter = __webpack_require__(/*! ./reporter */ "./node_modules/asn1.js/lib/asn1/base/reporter.js").Reporter;
base.DecoderBuffer = __webpack_require__(/*! ./buffer */ "./node_modules/asn1.js/lib/asn1/base/buffer.js").DecoderBuffer;
base.EncoderBuffer = __webpack_require__(/*! ./buffer */ "./node_modules/asn1.js/lib/asn1/base/buffer.js").EncoderBuffer;
base.Node = __webpack_require__(/*! ./node */ "./node_modules/asn1.js/lib/asn1/base/node.js");


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/base/node.js":
/*!****************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/base/node.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const Reporter = __webpack_require__(/*! ../base/reporter */ "./node_modules/asn1.js/lib/asn1/base/reporter.js").Reporter;
const EncoderBuffer = __webpack_require__(/*! ../base/buffer */ "./node_modules/asn1.js/lib/asn1/base/buffer.js").EncoderBuffer;
const DecoderBuffer = __webpack_require__(/*! ../base/buffer */ "./node_modules/asn1.js/lib/asn1/base/buffer.js").DecoderBuffer;
const assert = __webpack_require__(/*! minimalistic-assert */ "./node_modules/minimalistic-assert/index.js");

// Supported tags
const tags = [
  'seq', 'seqof', 'set', 'setof', 'objid', 'bool',
  'gentime', 'utctime', 'null_', 'enum', 'int', 'objDesc',
  'bitstr', 'bmpstr', 'charstr', 'genstr', 'graphstr', 'ia5str', 'iso646str',
  'numstr', 'octstr', 'printstr', 't61str', 'unistr', 'utf8str', 'videostr'
];

// Public methods list
const methods = [
  'key', 'obj', 'use', 'optional', 'explicit', 'implicit', 'def', 'choice',
  'any', 'contains'
].concat(tags);

// Overrided methods list
const overrided = [
  '_peekTag', '_decodeTag', '_use',
  '_decodeStr', '_decodeObjid', '_decodeTime',
  '_decodeNull', '_decodeInt', '_decodeBool', '_decodeList',

  '_encodeComposite', '_encodeStr', '_encodeObjid', '_encodeTime',
  '_encodeNull', '_encodeInt', '_encodeBool'
];

function Node(enc, parent, name) {
  const state = {};
  this._baseState = state;

  state.name = name;
  state.enc = enc;

  state.parent = parent || null;
  state.children = null;

  // State
  state.tag = null;
  state.args = null;
  state.reverseArgs = null;
  state.choice = null;
  state.optional = false;
  state.any = false;
  state.obj = false;
  state.use = null;
  state.useDecoder = null;
  state.key = null;
  state['default'] = null;
  state.explicit = null;
  state.implicit = null;
  state.contains = null;

  // Should create new instance on each method
  if (!state.parent) {
    state.children = [];
    this._wrap();
  }
}
module.exports = Node;

const stateProps = [
  'enc', 'parent', 'children', 'tag', 'args', 'reverseArgs', 'choice',
  'optional', 'any', 'obj', 'use', 'alteredUse', 'key', 'default', 'explicit',
  'implicit', 'contains'
];

Node.prototype.clone = function clone() {
  const state = this._baseState;
  const cstate = {};
  stateProps.forEach(function(prop) {
    cstate[prop] = state[prop];
  });
  const res = new this.constructor(cstate.parent);
  res._baseState = cstate;
  return res;
};

Node.prototype._wrap = function wrap() {
  const state = this._baseState;
  methods.forEach(function(method) {
    this[method] = function _wrappedMethod() {
      const clone = new this.constructor(this);
      state.children.push(clone);
      return clone[method].apply(clone, arguments);
    };
  }, this);
};

Node.prototype._init = function init(body) {
  const state = this._baseState;

  assert(state.parent === null);
  body.call(this);

  // Filter children
  state.children = state.children.filter(function(child) {
    return child._baseState.parent === this;
  }, this);
  assert.equal(state.children.length, 1, 'Root node can have only one child');
};

Node.prototype._useArgs = function useArgs(args) {
  const state = this._baseState;

  // Filter children and args
  const children = args.filter(function(arg) {
    return arg instanceof this.constructor;
  }, this);
  args = args.filter(function(arg) {
    return !(arg instanceof this.constructor);
  }, this);

  if (children.length !== 0) {
    assert(state.children === null);
    state.children = children;

    // Replace parent to maintain backward link
    children.forEach(function(child) {
      child._baseState.parent = this;
    }, this);
  }
  if (args.length !== 0) {
    assert(state.args === null);
    state.args = args;
    state.reverseArgs = args.map(function(arg) {
      if (typeof arg !== 'object' || arg.constructor !== Object)
        return arg;

      const res = {};
      Object.keys(arg).forEach(function(key) {
        if (key == (key | 0))
          key |= 0;
        const value = arg[key];
        res[value] = key;
      });
      return res;
    });
  }
};

//
// Overrided methods
//

overrided.forEach(function(method) {
  Node.prototype[method] = function _overrided() {
    const state = this._baseState;
    throw new Error(method + ' not implemented for encoding: ' + state.enc);
  };
});

//
// Public methods
//

tags.forEach(function(tag) {
  Node.prototype[tag] = function _tagMethod() {
    const state = this._baseState;
    const args = Array.prototype.slice.call(arguments);

    assert(state.tag === null);
    state.tag = tag;

    this._useArgs(args);

    return this;
  };
});

Node.prototype.use = function use(item) {
  assert(item);
  const state = this._baseState;

  assert(state.use === null);
  state.use = item;

  return this;
};

Node.prototype.optional = function optional() {
  const state = this._baseState;

  state.optional = true;

  return this;
};

Node.prototype.def = function def(val) {
  const state = this._baseState;

  assert(state['default'] === null);
  state['default'] = val;
  state.optional = true;

  return this;
};

Node.prototype.explicit = function explicit(num) {
  const state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.explicit = num;

  return this;
};

Node.prototype.implicit = function implicit(num) {
  const state = this._baseState;

  assert(state.explicit === null && state.implicit === null);
  state.implicit = num;

  return this;
};

Node.prototype.obj = function obj() {
  const state = this._baseState;
  const args = Array.prototype.slice.call(arguments);

  state.obj = true;

  if (args.length !== 0)
    this._useArgs(args);

  return this;
};

Node.prototype.key = function key(newKey) {
  const state = this._baseState;

  assert(state.key === null);
  state.key = newKey;

  return this;
};

Node.prototype.any = function any() {
  const state = this._baseState;

  state.any = true;

  return this;
};

Node.prototype.choice = function choice(obj) {
  const state = this._baseState;

  assert(state.choice === null);
  state.choice = obj;
  this._useArgs(Object.keys(obj).map(function(key) {
    return obj[key];
  }));

  return this;
};

Node.prototype.contains = function contains(item) {
  const state = this._baseState;

  assert(state.use === null);
  state.contains = item;

  return this;
};

//
// Decoding
//

Node.prototype._decode = function decode(input, options) {
  const state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return input.wrapResult(state.children[0]._decode(input, options));

  let result = state['default'];
  let present = true;

  let prevKey = null;
  if (state.key !== null)
    prevKey = input.enterKey(state.key);

  // Check if tag is there
  if (state.optional) {
    let tag = null;
    if (state.explicit !== null)
      tag = state.explicit;
    else if (state.implicit !== null)
      tag = state.implicit;
    else if (state.tag !== null)
      tag = state.tag;

    if (tag === null && !state.any) {
      // Trial and Error
      const save = input.save();
      try {
        if (state.choice === null)
          this._decodeGeneric(state.tag, input, options);
        else
          this._decodeChoice(input, options);
        present = true;
      } catch (e) {
        present = false;
      }
      input.restore(save);
    } else {
      present = this._peekTag(input, tag, state.any);

      if (input.isError(present))
        return present;
    }
  }

  // Push object on stack
  let prevObj;
  if (state.obj && present)
    prevObj = input.enterObject();

  if (present) {
    // Unwrap explicit values
    if (state.explicit !== null) {
      const explicit = this._decodeTag(input, state.explicit);
      if (input.isError(explicit))
        return explicit;
      input = explicit;
    }

    const start = input.offset;

    // Unwrap implicit and normal values
    if (state.use === null && state.choice === null) {
      let save;
      if (state.any)
        save = input.save();
      const body = this._decodeTag(
        input,
        state.implicit !== null ? state.implicit : state.tag,
        state.any
      );
      if (input.isError(body))
        return body;

      if (state.any)
        result = input.raw(save);
      else
        input = body;
    }

    if (options && options.track && state.tag !== null)
      options.track(input.path(), start, input.length, 'tagged');

    if (options && options.track && state.tag !== null)
      options.track(input.path(), input.offset, input.length, 'content');

    // Select proper method for tag
    if (state.any) {
      // no-op
    } else if (state.choice === null) {
      result = this._decodeGeneric(state.tag, input, options);
    } else {
      result = this._decodeChoice(input, options);
    }

    if (input.isError(result))
      return result;

    // Decode children
    if (!state.any && state.choice === null && state.children !== null) {
      state.children.forEach(function decodeChildren(child) {
        // NOTE: We are ignoring errors here, to let parser continue with other
        // parts of encoded data
        child._decode(input, options);
      });
    }

    // Decode contained/encoded by schema, only in bit or octet strings
    if (state.contains && (state.tag === 'octstr' || state.tag === 'bitstr')) {
      const data = new DecoderBuffer(result);
      result = this._getUse(state.contains, input._reporterState.obj)
        ._decode(data, options);
    }
  }

  // Pop object
  if (state.obj && present)
    result = input.leaveObject(prevObj);

  // Set key
  if (state.key !== null && (result !== null || present === true))
    input.leaveKey(prevKey, state.key, result);
  else if (prevKey !== null)
    input.exitKey(prevKey);

  return result;
};

Node.prototype._decodeGeneric = function decodeGeneric(tag, input, options) {
  const state = this._baseState;

  if (tag === 'seq' || tag === 'set')
    return null;
  if (tag === 'seqof' || tag === 'setof')
    return this._decodeList(input, tag, state.args[0], options);
  else if (/str$/.test(tag))
    return this._decodeStr(input, tag, options);
  else if (tag === 'objid' && state.args)
    return this._decodeObjid(input, state.args[0], state.args[1], options);
  else if (tag === 'objid')
    return this._decodeObjid(input, null, null, options);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._decodeTime(input, tag, options);
  else if (tag === 'null_')
    return this._decodeNull(input, options);
  else if (tag === 'bool')
    return this._decodeBool(input, options);
  else if (tag === 'objDesc')
    return this._decodeStr(input, tag, options);
  else if (tag === 'int' || tag === 'enum')
    return this._decodeInt(input, state.args && state.args[0], options);

  if (state.use !== null) {
    return this._getUse(state.use, input._reporterState.obj)
      ._decode(input, options);
  } else {
    return input.error('unknown tag: ' + tag);
  }
};

Node.prototype._getUse = function _getUse(entity, obj) {

  const state = this._baseState;
  // Create altered use decoder if implicit is set
  state.useDecoder = this._use(entity, obj);
  assert(state.useDecoder._baseState.parent === null);
  state.useDecoder = state.useDecoder._baseState.children[0];
  if (state.implicit !== state.useDecoder._baseState.implicit) {
    state.useDecoder = state.useDecoder.clone();
    state.useDecoder._baseState.implicit = state.implicit;
  }
  return state.useDecoder;
};

Node.prototype._decodeChoice = function decodeChoice(input, options) {
  const state = this._baseState;
  let result = null;
  let match = false;

  Object.keys(state.choice).some(function(key) {
    const save = input.save();
    const node = state.choice[key];
    try {
      const value = node._decode(input, options);
      if (input.isError(value))
        return false;

      result = { type: key, value: value };
      match = true;
    } catch (e) {
      input.restore(save);
      return false;
    }
    return true;
  }, this);

  if (!match)
    return input.error('Choice not matched');

  return result;
};

//
// Encoding
//

Node.prototype._createEncoderBuffer = function createEncoderBuffer(data) {
  return new EncoderBuffer(data, this.reporter);
};

Node.prototype._encode = function encode(data, reporter, parent) {
  const state = this._baseState;
  if (state['default'] !== null && state['default'] === data)
    return;

  const result = this._encodeValue(data, reporter, parent);
  if (result === undefined)
    return;

  if (this._skipDefault(result, reporter, parent))
    return;

  return result;
};

Node.prototype._encodeValue = function encode(data, reporter, parent) {
  const state = this._baseState;

  // Decode root node
  if (state.parent === null)
    return state.children[0]._encode(data, reporter || new Reporter());

  let result = null;

  // Set reporter to share it with a child class
  this.reporter = reporter;

  // Check if data is there
  if (state.optional && data === undefined) {
    if (state['default'] !== null)
      data = state['default'];
    else
      return;
  }

  // Encode children first
  let content = null;
  let primitive = false;
  if (state.any) {
    // Anything that was given is translated to buffer
    result = this._createEncoderBuffer(data);
  } else if (state.choice) {
    result = this._encodeChoice(data, reporter);
  } else if (state.contains) {
    content = this._getUse(state.contains, parent)._encode(data, reporter);
    primitive = true;
  } else if (state.children) {
    content = state.children.map(function(child) {
      if (child._baseState.tag === 'null_')
        return child._encode(null, reporter, data);

      if (child._baseState.key === null)
        return reporter.error('Child should have a key');
      const prevKey = reporter.enterKey(child._baseState.key);

      if (typeof data !== 'object')
        return reporter.error('Child expected, but input is not object');

      const res = child._encode(data[child._baseState.key], reporter, data);
      reporter.leaveKey(prevKey);

      return res;
    }, this).filter(function(child) {
      return child;
    });
    content = this._createEncoderBuffer(content);
  } else {
    if (state.tag === 'seqof' || state.tag === 'setof') {
      // TODO(indutny): this should be thrown on DSL level
      if (!(state.args && state.args.length === 1))
        return reporter.error('Too many args for : ' + state.tag);

      if (!Array.isArray(data))
        return reporter.error('seqof/setof, but data is not Array');

      const child = this.clone();
      child._baseState.implicit = null;
      content = this._createEncoderBuffer(data.map(function(item) {
        const state = this._baseState;

        return this._getUse(state.args[0], data)._encode(item, reporter);
      }, child));
    } else if (state.use !== null) {
      result = this._getUse(state.use, parent)._encode(data, reporter);
    } else {
      content = this._encodePrimitive(state.tag, data);
      primitive = true;
    }
  }

  // Encode data itself
  if (!state.any && state.choice === null) {
    const tag = state.implicit !== null ? state.implicit : state.tag;
    const cls = state.implicit === null ? 'universal' : 'context';

    if (tag === null) {
      if (state.use === null)
        reporter.error('Tag could be omitted only for .use()');
    } else {
      if (state.use === null)
        result = this._encodeComposite(tag, primitive, cls, content);
    }
  }

  // Wrap in explicit
  if (state.explicit !== null)
    result = this._encodeComposite(state.explicit, false, 'context', result);

  return result;
};

Node.prototype._encodeChoice = function encodeChoice(data, reporter) {
  const state = this._baseState;

  const node = state.choice[data.type];
  if (!node) {
    assert(
      false,
      data.type + ' not found in ' +
            JSON.stringify(Object.keys(state.choice)));
  }
  return node._encode(data.value, reporter);
};

Node.prototype._encodePrimitive = function encodePrimitive(tag, data) {
  const state = this._baseState;

  if (/str$/.test(tag))
    return this._encodeStr(data, tag);
  else if (tag === 'objid' && state.args)
    return this._encodeObjid(data, state.reverseArgs[0], state.args[1]);
  else if (tag === 'objid')
    return this._encodeObjid(data, null, null);
  else if (tag === 'gentime' || tag === 'utctime')
    return this._encodeTime(data, tag);
  else if (tag === 'null_')
    return this._encodeNull();
  else if (tag === 'int' || tag === 'enum')
    return this._encodeInt(data, state.args && state.reverseArgs[0]);
  else if (tag === 'bool')
    return this._encodeBool(data);
  else if (tag === 'objDesc')
    return this._encodeStr(data, tag);
  else
    throw new Error('Unsupported tag: ' + tag);
};

Node.prototype._isNumstr = function isNumstr(str) {
  return /^[0-9 ]*$/.test(str);
};

Node.prototype._isPrintstr = function isPrintstr(str) {
  return /^[A-Za-z0-9 '()+,-./:=?]*$/.test(str);
};


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/base/reporter.js":
/*!********************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/base/reporter.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");

function Reporter(options) {
  this._reporterState = {
    obj: null,
    path: [],
    options: options || {},
    errors: []
  };
}
exports.Reporter = Reporter;

Reporter.prototype.isError = function isError(obj) {
  return obj instanceof ReporterError;
};

Reporter.prototype.save = function save() {
  const state = this._reporterState;

  return { obj: state.obj, pathLen: state.path.length };
};

Reporter.prototype.restore = function restore(data) {
  const state = this._reporterState;

  state.obj = data.obj;
  state.path = state.path.slice(0, data.pathLen);
};

Reporter.prototype.enterKey = function enterKey(key) {
  return this._reporterState.path.push(key);
};

Reporter.prototype.exitKey = function exitKey(index) {
  const state = this._reporterState;

  state.path = state.path.slice(0, index - 1);
};

Reporter.prototype.leaveKey = function leaveKey(index, key, value) {
  const state = this._reporterState;

  this.exitKey(index);
  if (state.obj !== null)
    state.obj[key] = value;
};

Reporter.prototype.path = function path() {
  return this._reporterState.path.join('/');
};

Reporter.prototype.enterObject = function enterObject() {
  const state = this._reporterState;

  const prev = state.obj;
  state.obj = {};
  return prev;
};

Reporter.prototype.leaveObject = function leaveObject(prev) {
  const state = this._reporterState;

  const now = state.obj;
  state.obj = prev;
  return now;
};

Reporter.prototype.error = function error(msg) {
  let err;
  const state = this._reporterState;

  const inherited = msg instanceof ReporterError;
  if (inherited) {
    err = msg;
  } else {
    err = new ReporterError(state.path.map(function(elem) {
      return '[' + JSON.stringify(elem) + ']';
    }).join(''), msg.message || msg, msg.stack);
  }

  if (!state.options.partial)
    throw err;

  if (!inherited)
    state.errors.push(err);

  return err;
};

Reporter.prototype.wrapResult = function wrapResult(result) {
  const state = this._reporterState;
  if (!state.options.partial)
    return result;

  return {
    result: this.isError(result) ? null : result,
    errors: state.errors
  };
};

function ReporterError(path, msg) {
  this.path = path;
  this.rethrow(msg);
}
inherits(ReporterError, Error);

ReporterError.prototype.rethrow = function rethrow(msg) {
  this.message = msg + ' at: ' + (this.path || '(shallow)');
  if (Error.captureStackTrace)
    Error.captureStackTrace(this, ReporterError);

  if (!this.stack) {
    try {
      // IE only adds stack when thrown
      throw new Error(this.message);
    } catch (e) {
      this.stack = e.stack;
    }
  }
  return this;
};


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/constants/der.js":
/*!********************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/constants/der.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


// Helper
function reverse(map) {
  const res = {};

  Object.keys(map).forEach(function(key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key)
      key = key | 0;

    const value = map[key];
    res[value] = key;
  });

  return res;
}

exports.tagClass = {
  0: 'universal',
  1: 'application',
  2: 'context',
  3: 'private'
};
exports.tagClassByName = reverse(exports.tagClass);

exports.tag = {
  0x00: 'end',
  0x01: 'bool',
  0x02: 'int',
  0x03: 'bitstr',
  0x04: 'octstr',
  0x05: 'null_',
  0x06: 'objid',
  0x07: 'objDesc',
  0x08: 'external',
  0x09: 'real',
  0x0a: 'enum',
  0x0b: 'embed',
  0x0c: 'utf8str',
  0x0d: 'relativeOid',
  0x10: 'seq',
  0x11: 'set',
  0x12: 'numstr',
  0x13: 'printstr',
  0x14: 't61str',
  0x15: 'videostr',
  0x16: 'ia5str',
  0x17: 'utctime',
  0x18: 'gentime',
  0x19: 'graphstr',
  0x1a: 'iso646str',
  0x1b: 'genstr',
  0x1c: 'unistr',
  0x1d: 'charstr',
  0x1e: 'bmpstr'
};
exports.tagByName = reverse(exports.tag);


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/constants/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/constants/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const constants = exports;

// Helper
constants._reverse = function reverse(map) {
  const res = {};

  Object.keys(map).forEach(function(key) {
    // Convert key to integer if it is stringified
    if ((key | 0) == key)
      key = key | 0;

    const value = map[key];
    res[value] = key;
  });

  return res;
};

constants.der = __webpack_require__(/*! ./der */ "./node_modules/asn1.js/lib/asn1/constants/der.js");


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/decoders/der.js":
/*!*******************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/decoders/der.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");

const bignum = __webpack_require__(/*! bn.js */ "./node_modules/bn.js/lib/bn.js");
const DecoderBuffer = __webpack_require__(/*! ../base/buffer */ "./node_modules/asn1.js/lib/asn1/base/buffer.js").DecoderBuffer;
const Node = __webpack_require__(/*! ../base/node */ "./node_modules/asn1.js/lib/asn1/base/node.js");

// Import DER constants
const der = __webpack_require__(/*! ../constants/der */ "./node_modules/asn1.js/lib/asn1/constants/der.js");

function DERDecoder(entity) {
  this.enc = 'der';
  this.name = entity.name;
  this.entity = entity;

  // Construct base tree
  this.tree = new DERNode();
  this.tree._init(entity.body);
}
module.exports = DERDecoder;

DERDecoder.prototype.decode = function decode(data, options) {
  if (!DecoderBuffer.isDecoderBuffer(data)) {
    data = new DecoderBuffer(data, options);
  }

  return this.tree._decode(data, options);
};

// Tree methods

function DERNode(parent) {
  Node.call(this, 'der', parent);
}
inherits(DERNode, Node);

DERNode.prototype._peekTag = function peekTag(buffer, tag, any) {
  if (buffer.isEmpty())
    return false;

  const state = buffer.save();
  const decodedTag = derDecodeTag(buffer, 'Failed to peek tag: "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  buffer.restore(state);

  return decodedTag.tag === tag || decodedTag.tagStr === tag ||
    (decodedTag.tagStr + 'of') === tag || any;
};

DERNode.prototype._decodeTag = function decodeTag(buffer, tag, any) {
  const decodedTag = derDecodeTag(buffer,
    'Failed to decode tag of "' + tag + '"');
  if (buffer.isError(decodedTag))
    return decodedTag;

  let len = derDecodeLen(buffer,
    decodedTag.primitive,
    'Failed to get length of "' + tag + '"');

  // Failure
  if (buffer.isError(len))
    return len;

  if (!any &&
      decodedTag.tag !== tag &&
      decodedTag.tagStr !== tag &&
      decodedTag.tagStr + 'of' !== tag) {
    return buffer.error('Failed to match tag: "' + tag + '"');
  }

  if (decodedTag.primitive || len !== null)
    return buffer.skip(len, 'Failed to match body of: "' + tag + '"');

  // Indefinite length... find END tag
  const state = buffer.save();
  const res = this._skipUntilEnd(
    buffer,
    'Failed to skip indefinite length body: "' + this.tag + '"');
  if (buffer.isError(res))
    return res;

  len = buffer.offset - state.offset;
  buffer.restore(state);
  return buffer.skip(len, 'Failed to match body of: "' + tag + '"');
};

DERNode.prototype._skipUntilEnd = function skipUntilEnd(buffer, fail) {
  for (;;) {
    const tag = derDecodeTag(buffer, fail);
    if (buffer.isError(tag))
      return tag;
    const len = derDecodeLen(buffer, tag.primitive, fail);
    if (buffer.isError(len))
      return len;

    let res;
    if (tag.primitive || len !== null)
      res = buffer.skip(len);
    else
      res = this._skipUntilEnd(buffer, fail);

    // Failure
    if (buffer.isError(res))
      return res;

    if (tag.tagStr === 'end')
      break;
  }
};

DERNode.prototype._decodeList = function decodeList(buffer, tag, decoder,
  options) {
  const result = [];
  while (!buffer.isEmpty()) {
    const possibleEnd = this._peekTag(buffer, 'end');
    if (buffer.isError(possibleEnd))
      return possibleEnd;

    const res = decoder.decode(buffer, 'der', options);
    if (buffer.isError(res) && possibleEnd)
      break;
    result.push(res);
  }
  return result;
};

DERNode.prototype._decodeStr = function decodeStr(buffer, tag) {
  if (tag === 'bitstr') {
    const unused = buffer.readUInt8();
    if (buffer.isError(unused))
      return unused;
    return { unused: unused, data: buffer.raw() };
  } else if (tag === 'bmpstr') {
    const raw = buffer.raw();
    if (raw.length % 2 === 1)
      return buffer.error('Decoding of string type: bmpstr length mismatch');

    let str = '';
    for (let i = 0; i < raw.length / 2; i++) {
      str += String.fromCharCode(raw.readUInt16BE(i * 2));
    }
    return str;
  } else if (tag === 'numstr') {
    const numstr = buffer.raw().toString('ascii');
    if (!this._isNumstr(numstr)) {
      return buffer.error('Decoding of string type: ' +
                          'numstr unsupported characters');
    }
    return numstr;
  } else if (tag === 'octstr') {
    return buffer.raw();
  } else if (tag === 'objDesc') {
    return buffer.raw();
  } else if (tag === 'printstr') {
    const printstr = buffer.raw().toString('ascii');
    if (!this._isPrintstr(printstr)) {
      return buffer.error('Decoding of string type: ' +
                          'printstr unsupported characters');
    }
    return printstr;
  } else if (/str$/.test(tag)) {
    return buffer.raw().toString();
  } else {
    return buffer.error('Decoding of string type: ' + tag + ' unsupported');
  }
};

DERNode.prototype._decodeObjid = function decodeObjid(buffer, values, relative) {
  let result;
  const identifiers = [];
  let ident = 0;
  let subident = 0;
  while (!buffer.isEmpty()) {
    subident = buffer.readUInt8();
    ident <<= 7;
    ident |= subident & 0x7f;
    if ((subident & 0x80) === 0) {
      identifiers.push(ident);
      ident = 0;
    }
  }
  if (subident & 0x80)
    identifiers.push(ident);

  const first = (identifiers[0] / 40) | 0;
  const second = identifiers[0] % 40;

  if (relative)
    result = identifiers;
  else
    result = [first, second].concat(identifiers.slice(1));

  if (values) {
    let tmp = values[result.join(' ')];
    if (tmp === undefined)
      tmp = values[result.join('.')];
    if (tmp !== undefined)
      result = tmp;
  }

  return result;
};

DERNode.prototype._decodeTime = function decodeTime(buffer, tag) {
  const str = buffer.raw().toString();

  let year;
  let mon;
  let day;
  let hour;
  let min;
  let sec;
  if (tag === 'gentime') {
    year = str.slice(0, 4) | 0;
    mon = str.slice(4, 6) | 0;
    day = str.slice(6, 8) | 0;
    hour = str.slice(8, 10) | 0;
    min = str.slice(10, 12) | 0;
    sec = str.slice(12, 14) | 0;
  } else if (tag === 'utctime') {
    year = str.slice(0, 2) | 0;
    mon = str.slice(2, 4) | 0;
    day = str.slice(4, 6) | 0;
    hour = str.slice(6, 8) | 0;
    min = str.slice(8, 10) | 0;
    sec = str.slice(10, 12) | 0;
    if (year < 70)
      year = 2000 + year;
    else
      year = 1900 + year;
  } else {
    return buffer.error('Decoding ' + tag + ' time is not supported yet');
  }

  return Date.UTC(year, mon - 1, day, hour, min, sec, 0);
};

DERNode.prototype._decodeNull = function decodeNull() {
  return null;
};

DERNode.prototype._decodeBool = function decodeBool(buffer) {
  const res = buffer.readUInt8();
  if (buffer.isError(res))
    return res;
  else
    return res !== 0;
};

DERNode.prototype._decodeInt = function decodeInt(buffer, values) {
  // Bigint, return as it is (assume big endian)
  const raw = buffer.raw();
  let res = new bignum(raw);

  if (values)
    res = values[res.toString(10)] || res;

  return res;
};

DERNode.prototype._use = function use(entity, obj) {
  if (typeof entity === 'function')
    entity = entity(obj);
  return entity._getDecoder('der').tree;
};

// Utility methods

function derDecodeTag(buf, fail) {
  let tag = buf.readUInt8(fail);
  if (buf.isError(tag))
    return tag;

  const cls = der.tagClass[tag >> 6];
  const primitive = (tag & 0x20) === 0;

  // Multi-octet tag - load
  if ((tag & 0x1f) === 0x1f) {
    let oct = tag;
    tag = 0;
    while ((oct & 0x80) === 0x80) {
      oct = buf.readUInt8(fail);
      if (buf.isError(oct))
        return oct;

      tag <<= 7;
      tag |= oct & 0x7f;
    }
  } else {
    tag &= 0x1f;
  }
  const tagStr = der.tag[tag];

  return {
    cls: cls,
    primitive: primitive,
    tag: tag,
    tagStr: tagStr
  };
}

function derDecodeLen(buf, primitive, fail) {
  let len = buf.readUInt8(fail);
  if (buf.isError(len))
    return len;

  // Indefinite form
  if (!primitive && len === 0x80)
    return null;

  // Definite form
  if ((len & 0x80) === 0) {
    // Short form
    return len;
  }

  // Long form
  const num = len & 0x7f;
  if (num > 4)
    return buf.error('length octect is too long');

  len = 0;
  for (let i = 0; i < num; i++) {
    len <<= 8;
    const j = buf.readUInt8(fail);
    if (buf.isError(j))
      return j;
    len |= j;
  }

  return len;
}


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/decoders/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/decoders/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


const decoders = exports;

decoders.der = __webpack_require__(/*! ./der */ "./node_modules/asn1.js/lib/asn1/decoders/der.js");
decoders.pem = __webpack_require__(/*! ./pem */ "./node_modules/asn1.js/lib/asn1/decoders/pem.js");


/***/ }),

/***/ "./node_modules/asn1.js/lib/asn1/decoders/pem.js":
/*!*******************************************************!*\
  !*** ./node_modules/asn1.js/lib/asn1/decoders/pem.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


const inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");
const Buffer = __webpack_require__(/*! safer-buffer */ "./node_modules/safer-buffer/safer.js").Buffer;

const DERDecoder = __webpack_require__(/*! ./der */ "./node_modules/asn1.js/lib/asn1/decoders/der.js");

function PEMDecoder(entity) {
  DERDecoder.call(this, entity);
  this.enc = 'pem';
}
inherits(PEMDecoder, DERDecoder);
module.exports = PEMDecoder;

PEMDecoder.prototype.decode = function decode(data, options) {
  const lines = data.toString().split(/[\r\n]+/g);

  const label = options.label.toUpperCase();

  const re = /^-----(BEGIN|END) ([^-]+)-----$/;
  let start = -1;
  let end = -1;
  for (let i = 0; i < lines.length; i++) {
    const match = lines[i].match(re);
    if (match === null)
      continue;

    if (match[2] !== label)
      continue;

    if (start === -1) {
      if (match[1] !== 'BEGIN')
        break;
      start = i;
    } else {
      if (match[1] !== 'END')
        break;
      end = i;
      break;
    }
  }
  if (start === -1 || end === -1)
    throw new Error('PEM section not found for: ' + label);

  const base64 = lines.slice(start + 1, end).join('');
  // Remove excessive symbols
  base64.replace(/[^a-z0-9+/=]+/gi, '');

  const input = Buffer.from(base64, 'base64');
  return DERDecoder.prototype.decode.call(this, input, options);
};


/***/ }),

/***/ "./node_modu