//var webdriver = require('selenium-webdriver');

define(function (require) {
    var registerSuite = require('intern!object');
    var webdriver = require('intern/dojo/node!selenium-webdriver');
    var executors = require('intern/dojo/node!selenium-webdriver/executors');
    var Eyes = require('intern/dojo/node!eyes.selenium').Eyes;
    var LogHandler = require('intern/dojo/node!eyes.selenium').ConsoleLogHandler;

    var initEyes = function () {
        var eyes = new Eyes("https://localhost.applitools.com");
        eyes.setApiKey(process.env.APPLITOOLS_API_KEY);
        eyes.setLogHandler(new LogHandler(true));
        eyes.setHideScrollbars(true);
        //eyes.setForceFullPageScreenshot(true);
        //eyes.setStitchMode(Eyes.StitchMode.CSS);
        return eyes;
    };

    registerSuite(function () {
        var commandExecutor,driver, eyes;
        return {
            name: 'Intern with Eyes',

            setup: function () {
                this.timeout = 30000;
                commandExecutor = executors.createExecutor(this.remote.session.server.url);
                driver = webdriver.WebDriver.attachToSession(commandExecutor, this.remote.session.sessionId);
                eyes = initEyes();
            },


            beforeEach: function () {
                return eyes.open(driver, "Eyes Intern", 'Intern test 1');
            },

            afterEach: function () {
                return eyes.abortIfNotClosed();
            },

            'Simple test': function () {
                var dfd = this.async(600000);
                this.remote
                    .get("http://www.applitools.com")
                    .setFindTimeout(5000)
                    .findByClassName('customersSayTitle')
                    .then(function () {
                        return eyes.checkWindow("Applitools home")
                    }).then(function () {
                        return eyes.close();
                    }).then(function () {
                            dfd.resolve();
                        }, function (err) {
                            dfd.reject(err);
                        }
                    );
            }
        };
    });
});
